;
;-----------------------------------------------------------------------
pro meridional,info,linetype
;
;  Do generic set up for line plots
;
  lines,info,linetype

  line = *info.pline

  tlb = line.linebase

  fields = *info.fields  ; fields info structure
;
; Read data from first field:
;
  if ptr_valid(fields[0].data) then begin ; field has been read

    meridsliders,line 

    deflinedata,line,*fields[0].data

  endif else begin

    widget_control,/hourglass
    varget,info,fields[0],ncdata
    field = fields[0]
    procfield,info,ncdata,field,info.z_hist
    fields[0] = field
;    line.levmin = (*field.levs)[0] & line.levmax = (*field.levs)[field.nlev-1]
;
;  Set up sliders for line plot type
;
    meridsliders,line 

    deflinedata,line,*fields[0].data

    line.field = field
;    line.levs = line.field.levs

  endelse
;
; Set min,max for first field:
;
  fminmax,*line.data,fmin,fmax,line.missing_value
  rpt_minmax,info,fields[0],fmin,fmax
;  widget_control,line.minmaxmenu,sensitive=0 ; because default plottype is image+contour
;
; Update state info, realize the widgets, plot the first slice:
;
  *info.fields = fields
  info.pline = ptr_new(line)
  widget_control,tlb,/realize
  pinfo = ptr_new(info)
  pltline,info
  widget_control,tlb,set_uvalue=pinfo
  xmanager,'lines',tlb,/no_block

end
