;
FUNCTION levToLnPLev, inLevs

  nLevs = N_ELEMENTS(inlevs) 
  outLevs = inLevs

  FOR iLev=0,nLevs-1 DO BEGIN

    kLev = nLevs - iLev - 1
    outLevs(kLev) =  ALOG(5.0E-07/inlevs(iLev))  

  ENDFOR	      

  RETURN, outLevs

END
;
;--------------------------------------------------------------------------
;
FUNCTION getTimesW, cdFIDW
;
; Read WACCM times and get into TIMEGCM format:
;
  IDTimeD = ncdf_dimid(cdFIDW,'time')

  if IDTimeD eq -1 then begin

    print,'>>> WARNING readfile: no time dimension.'
    stop,'time'

  endif

  ncdf_diminq,cdFIDW,IDTimeD,timeName,nTimes

  times = INTARR(3,nTimes)
;
;  Need to get day, hour, minute for WACCM times
;
  IDDate = ncdf_varid(cdFIDW, 'date')
  ncdf_varget,cdFIDW,IDDate,inDates

  strDate = STRTRIM(STRING(inDates),2)
  inMonths = FIX(STRMID(strDate,4,2))
  inDays = FIX(STRMID(strDate,6,2))

  inYears = inDates/10000

  julDayBeg = JULDAY(1,1,inYears[0])

  julDayNow = JULDAY(inMonths,inDays,inYears)
  
  IDSec = ncdf_varid(cdFIDW, 'nscur')
  ncdf_varget,cdFIDW,IDSec,inSecs

  inHours = inSecs/3600.0

  inMinSecs = inHours - FIX(inHours)
 
  times[0,0:nTimes-1] = julDayNow - julDayBeg + 1
  times[1,0:nTimes-1] = FIX(inHours)
  times[2,0:nTimes-1] = FIX(inMinSecs*60)

  RETURN, times

END
;
;--------------------------------------------------------------------------
function getvarsW,info
;
; Find variables on cdFIDW whose dimension names include "lat", "lon",
; and "time". This should include all 3d and 4d vars (with or without
; a vertical dimension) on both geographic and magnetic grids. 
; These vars are saved in an array of field structures 
;
printfield = 0
cdFIDW = info.cdfid
ncdf_control,cdFIDW,/verbose
file_inq = ncdf_inquire(cdFIDW)
nvars = 0
for ivar = 0,file_inq.nvars-1 do begin
  var = ncdf_varinq(cdFIDW,ivar)
  if (var.ndims gt 0) then begin
    dimnames = ' '
    for idim = 0,var.ndims-1 do begin
      ncdf_diminq,cdFIDW,var.dim(idim),dimname,dimsize
      dimnames = dimnames + ' ' + dimname
    endfor
;
; Group files that have (time,lat,lon) in their dimension names:
;
    time_substr = strpos(dimnames,'time')
    lat_substr = strpos(dimnames,'lat')
    lon_substr = strpos(dimnames,'lon')
    if (time_substr ge 0 and lat_substr ge 0 and lon_substr ge 0) then begin
      nvars = nvars+1        
    endif
  endif
endfor ; ivar=0,nvars-1
;
; Define a structure to hold variables from the file:
;
; Structure for a variable with lon,lat,time, and possibly lev dimensions.
; Grid may be geographic (nlon,nlat, etc), or magnetic (mlon,mlat, etc)
; (3d field if nlev==0, otherwise 4d field)
;
field = {fieldstruct,           $ ; a field structure type
  name:' ',                     $ ; short name (char8)
  long_name: ' ',               $ ; long name (may be blank)
  units: ' ',                   $ ; units (may be blank)
  idvar:0,                      $ ; netcdf variable id
  nlon:0,                       $ ; longitude dimension size
  nlat:0,                       $ ; latitude dimension size
  nlev:0,                       $ ; vertical dimension size (may be 0)
  ntime:0,                      $ ; time dimension size
  grid_type:'',                 $ ; geographic or magnetic
  dimnames:strarr(4),           $ ; dimension names in order (4th may be blank)
  ncfile:'',                    $ ; file from which field is read
  difftype:'',                  $ ; difference type ('' or '%')
  lons:ptr_new(/allocate_heap), $ ; longitude coord var
  lats:ptr_new(/allocate_heap), $ ; latitude coord var
  levs:ptr_new(/allocate_heap), $ ; levels coord var
  levname:'',levunits:'',       $ ; name and units of lev coord var (zp or height)
  levshortname:'',              $ ; short name of lev coord var
  missing_value:0.,             $ ; missing data value for this field
  times:ptr_new(/allocate_heap),$ ; times coord var
  data:ptr_new(/allocate_heap)  $ ; the data
}
;
; Make array of field structures:
;
if (nvars gt 0) then begin
  fields = replicate({fieldstruct},nvars)
  n = -1
  for ivar = 0,file_inq.nvars-1 do begin
    var = ncdf_varinq(cdfidW,ivar)
    if (var.ndims gt 0) then begin
      dimnames = ' '
      for idim = 0,var.ndims-1 do begin
        ncdf_diminq,cdfidW,var.dim(idim),dimname,dimsize
        dimnames = dimnames + ' ' + dimname
      endfor
      time_substr = strpos(dimnames,'time')
      lat_substr = strpos(dimnames,'lat')
      lon_substr = strpos(dimnames,'lon')
      if (time_substr ge 0 and lat_substr ge 0 and lon_substr ge 0) then begin
        n = n+1
;
; Set name and netcdf var id:
;
        fields[n].name = var.name
        fields[n].idvar = ivar
        if printfield then print,'Field ',n,': ',fields[n].name
;
; Set dimension sizes and coordinate vars for lat,lon,lev,time:
;
        for idim = 0,var.ndims-1 do begin
          ncdf_diminq,cdfidW,var.dim(idim),dimname,dimsize
          if (strpos(dimname,'time') gt -1) then begin
            fields[n].ntime=dimsize

;           print,'readfile: field ',fields[n].name,' ndims=',var.ndims,$
;             ' dimname=',dimname,' dimsize=',dimsize,' fields[n].ntime=',$
;             fields[n].ntime

            if (dimsize gt 0) then begin
              timeid = ncdf_varid(cdfidW, dimname)
              times = fltarr(dimsize)
              ncdf_varget,cdfidW,timeid,times

;creates the rotation of time data when using a mars model
              
              IF info.ftype eq 'WACCM' THEN BEGIN

                model_name = 'WACCM'

              ENDIF ELSE BEGIN

                ncdf_attget,cdfidW,/global,'model_name',model_name
                model_name=string(model_name)
                if model_name eq 'mtgcm' then begin
                    times = times + (60*12)
                endif 
            
              ENDELSE

              if ptr_valid(fields[n].times) then $
                    *fields[n].times=times else fields[n].times=ptr_new(times)

            endif
          endif
          if (strpos(dimname,'lat' ) gt -1) then begin
            fields(n).nlat=dimsize
            if (dimsize gt 0) then begin
              latid = ncdf_varid(cdfidW, dimname)
              lats = fltarr(dimsize)
              ncdf_varget,cdfidW,latid,lats
              if ptr_valid(fields[n].lats) then $
                *fields[n].lats=lats else fields[n].lats=ptr_new(lats)
            endif
          endif
          if (strpos(dimname,'lon' ) gt -1) then begin
            fields(n).nlon=dimsize
            if (dimsize gt 0) then begin
              lonid = ncdf_varid(cdfidW, dimname)
              lons = fltarr(dimsize)
              ncdf_varget,cdfidW,lonid,lons

              convertlons,info,lons
;
;  Lons are now in TIME-GCM order but need the values adjusted
;
              iHighLons = WHERE(lons ge 180.0)
              lons(iHighLons) = lons(iHighLons) - 360.0
              
              if ptr_valid(fields[n].lons) then $
                *fields[n].lons=lons else fields[n].lons=ptr_new(lons)
            endif
          endif
          if (strpos(dimname,'lev' ) gt -1) then begin
            fields(n).nlev=dimsize
            if (dimsize gt 0) then begin
              levid = ncdf_varid(cdfidW, dimname)
              levs = fltarr(dimsize)
              ncdf_varget,cdfidW,levid,rdLevs

              levs = levToLnPLev(rdLevs)

              if ptr_valid(fields[n].levs) then $
                *fields[n].levs=levs else fields[n].levs=ptr_new(levs)
;
; Get lev label (name and units) (assume lev var name is dimname dimension)
              long_name = ''
              units = ''
              for ivartmp = 0,file_inq.nvars-1 do begin
                vartmp = ncdf_varinq(cdfidW,ivartmp)
                if vartmp.name eq dimname then begin
                  for ii=0,vartmp.natts-1 do begin
                    attname = ncdf_attname(cdfidW,ivartmp,ii) 
                    if (attname eq 'long_name') then begin
                      ncdf_attget,cdfidW,ivartmp,'long_name',rd_long_name
                      long_name = string(rd_long_name)
                    endif
                    if (attname eq 'units') then begin
                      ncdf_attget,cdfidW,ivartmp,'units',rd_units
                      units = string(rd_units)
                    endif
                  endfor
                endif
              endfor
              fields[n].levname = long_name
              fields[n].levunits = units
              if strpos(long_name,"pressure") gt -1 or $
                 strpos(long_name,"PRESSURE") gt -1 or $
                 strpos(long_name,"Pressure") gt -1 or $
                 strpos(long_name,"Pressure") gt -1 then $
                 fields[n].levshortname = 'ZP'
;
; New history file format (12/05) distinguishes between midpoint
; and interface levels:
              if strpos(long_name,"midpoint") gt -1 or $
                 strpos(long_name,"interface") gt -1 then $
                 fields[n].levshortname = 'ZP'
;
; Levels will be height only if file is tgcmproc_f90 post-proc output file:
              if strpos(long_name,"height") gt -1 or $
                 strpos(long_name,"Height") gt -1 or $
                 strpos(long_name,"HEIGHT") gt -1 then $
                 fields[n].levshortname = 'HEIGHT'
             ;print,'readfile: n=',n,' fields[n].levname=',fields[n].levname,$
             ;      'levunits=',fields[n].levunits
            endif
          endif
          fields[n].dimnames(idim) = dimname
        endfor
        if (var.natts gt 0) then begin
;
; Get field attributes:
;
          for i=0,var.natts-1 do begin
            attname = ncdf_attname(cdfidW,ivar,i) 
            case attname of
            'long_name': begin
              ncdf_attget,cdfidW,ivar,'long_name',long_name
              long_name = string(long_name)
              if strlen(strcompress(long_name,/remove_all)) eq 0 then $
                fields[n].long_name = fields[n].name $
              else fields[n].long_name = long_name
              if printfield then print,'  long_name: ',fields[n].long_name
            end
            'units': begin
              ncdf_attget,cdfidW,ivar,'units',units
              fields[n].units = string(units)
              if printfield then print,'  units: ',fields[n].units
            end
            'differences': begin
              ncdf_attget,cdfidW,ivar,'differences',difftype
              fields[n].difftype = string(difftype)
;             difftype = string(difftype)
;             if strpos(difftype,'PERC') ge 0 or strpos(difftype,'perc') ge 0 $
;               then fields[n].difftype = '%'
              if printfield then print,'  difftype: ',fields[n].difftype
            end
            'type': begin

            end
;
; Only new histories have missing_value on per field basis:
            'missing_value': begin
              ncdf_attget,cdfid,ivar,'missing_value',missing_value
              fields[n].missing_value = missing_value
              if printfield then print,'  missing_value: ',fields[n].missing_value
            end
            else: begin
;             print,'Did not read attribute "',attname,'" of field ',$
;               fields[n].name
            end
            endcase
          endfor ; 0,var.natts-1
        endif ; var.natts > 0
;
; Set grid type (geographic or magnetic):
;
        fields[n].grid_type = 'geographic'
        for idim = 0,var.ndims-1 do begin
          if (strpos(fields[n].dimnames(idim),'mlon') gt -1) then $
            fields[n].grid_type = 'magnetic'
        endfor
;
; File from which field is read:
        fields[n].ncfile = info.file
      endif ; is lat,lon,time var [n]
    endif ; var.ndims > 0
  endfor ; ivar=0,file_inq.nvars-1
  if model_name eq 'mtgcm' then $
    print,'read mars global attributes adding rotation to minutes'
endif ; nvars > 0
return,fields
end
;-----------------------------------------------------------------------
pro readFileW,info
;
; Read WACCM netcdf history file attached to info.cdfid.
;
cdFIDW = info.cdfid
print,'Reading file ',info.file,'...'
;
; Check for difference fields:
;
diffs = 0
fileinfo = ncdf_inquire(cdfidW)

;help,fileinfo,/struct
;exit

for i=0,fileinfo.ngatts-1 do begin
  name = ncdf_attname(cdfidW,/global,i)
  if name eq 'difference_fields' then begin
    ncdf_attget,cdfid,/global,name,diffbytes
;   print,'Difference fields = ',string(diffbytes)
    if string(diffbytes) eq 'yes' then begin
      diffs = 1
      print,'This file contains difference fields.'
    endif
  endif

endfor
info.diffs = diffs
;
; 10/28/05: Check for old history done for TIMEGCM so keep variable here:
;
oldhist = 0
tgcmproc_file = 0
;
; Get fields:
;
fields = getvarsW(info)
pfields = ptr_new(fields)
info.fields = pfields
info.nflds = n_elements(fields)

times = getTimesW(cdFIDW)

timeInfo = SIZE(times)
nTimes = timeInfo(2)

;
; Get lons,lats,levs:
;
IDLon = ncdf_varid(cdFIDW,'lon')
if IDLon gt -1 then BEGIN

  ncdf_varget,cdFIDW,IDLon,lons

  convertlons, info, lons
;
;  Lons are now in TIME-GCM order but need the values adjusted
;
  iHighLons = WHERE(lons ge 180.0)
  lons(iHighLons) = lons(iHighLons) - 360.0

ENDIF else BEGIN 

  lons = 0.

ENDELSE

IDLat = ncdf_varid(cdFIDW,'lat')
if IDLat gt -1 then ncdf_varget,cdFIDW,IDLat,lats else lats = 0.
;print,'readfile: lons=',lons
;print,'readfile: lats=',lats

IDLev = ncdf_varid(cdFIDW,'lev')
if IDLev gt -1 then BEGIN 

  ncdf_varget,cdFIDW,IDLev,rdLevs

  levs = levToLnPLev(rdLevs)

ENDIF else BEGIN 

  levs = 0.

ENDELSE

IDLev = ncdf_varid(cdFIDW,'ilev')
if IDLev gt -1 then BEGIN 

  ncdf_varget,cdFIDW,IDLev,rdILevs

  iLevs = levToLnPLev(rdILevs)

ENDIF else BEGIN

  ilevs = 0.

ENDELSE
;print,'readfile: levs (midpoints)=',levs
;print,'readfile: ilevs (interfaces)=',ilevs
;
missing_value = 1.0E+36

; Create file structure:
 file = {                  $
   path:info.file,         $ ; path to netcdf file
   cdfid:info.cdfid,       $ ; file id connected to file
   nflds:info.nflds,       $ ; number of 3d or 4d fields to display
   mtimes:times,           $ ; model times (int(3))
   ntimes:nTimes,          $ ; number of model times
   diffs:diffs,            $ ; diffs==1 if difference fields (global file attribute)
   lons:lons,              $
   lats:lats,              $
   levs:levs,              $ ; midpoint levels
   ilevs:ilevs,            $ ; interface levels
   missing_value:missing_value, $ ; missing data value
   tgcmproc_file:tgcmproc_file, $
   oldhist:oldhist         $
 }
pfile = ptr_new(file)
info.pfile = pfile
end
