;
;-----------------------------------------------------------------------
function setminlon,lons,lonmin,err
  err = 0
  nlons = n_elements(lons)
  if (lonmin lt lons[0]) or (lonmin gt lons[nlons-1]) then begin
    print,'>>> Bad longitude minimum = ',lonmin,' (must be >= ',lons[0],$
      ' and <= ',lons[nlons-1],')'
    err = 1
    return,lons[0]
  endif else begin
    j = ixfind_nearest(lons,lonmin)
    if j gt -1 then begin
      return,lons[j]
    endif else begin
      print,'>>> WARNING: cannot find j index to lonmin=',lonmin
      err = 1
      return,lons[0]
    endelse
  endelse
end
;
;-----------------------------------------------------------------------
function setmaxlon,lons,lonmax,err
  err = 0
  nlons = n_elements(lons)
  if (lonmax gt lons[nlons-1]) or (lonmax lt lons[0]) then begin
    print,'>>> Bad longitude maximum = ',lonmax,' (must be <= ',lons[nlons-1],$
      ' and >= ',lons[0],')'
    err = 1
    return,lons[nlons-1]
  endif else begin
    j = ixfind_nearest(lons,lonmax)
    if j gt -1 then begin
      return,lons[j]
    endif else begin
      print,'>>> WARNING: cannot find j index to lonmax=',lonmax
      err = 1
      return,lons[nlons-1]
    endelse
  endelse
end
;
;-----------------------------------------------------------------------
pro setaxis_lon_event,event
  widget_control,event.id,get_uvalue=widget
  widget_control,event.top,get_uvalue=plonaxis
  lonaxis = *plonaxis
  lons = *lonaxis.lons     ; full axis longitudes
  nlons = n_elements(lons)
  case widget of
    'LONMIN': begin
      widget_control,event.id,get_value=botstring
      lonmin = mkfloat(botstring[0],lonaxis.lonmin,event.id)
      lonmin = setminlon(lons,lonmin,err)
      if not err then begin
        print,'Set longitude minimum = ',lonaxis.lonmin
        lonaxis.lonmin = lonmin
        *plonaxis = lonaxis
      endif else begin
        widget_control,event.id,setvalue=lonaxis.lonmin
      endelse
    end
    'LONMAX': begin
      widget_control,event.id,get_value=topstring
      lonmax = mkfloat(topstring[0],lonaxis.lonmax,event.id)
      lonmax = setmaxlon(lons,lonmax,err)
      if not err then begin
        lonaxis.lonmax = lonmax
        print,'Set longitude maximum = ',lonaxis.lonmax
        *plonaxis = lonaxis
      endif else begin
        widget_control,event.id,setvalue=lonaxis.lonmax
      endelse
    end
    'OK': begin
      widget_control,lonaxis.textmin,get_value=botstring
      widget_control,lonaxis.textmax,get_value=topstring
;
      lonmin = mkfloat(botstring[0],lonaxis.lonmin,lonaxis.textmin)
      lonaxis.lonmin = setminlon(lons,lonmin,err)
      if err then print,'>>> WARNING setaxis_lon: error from func setmaxlon'
;
      lonmax = mkfloat(topstring[0],lonaxis.lonmax,lonaxis.textmax)
      lonaxis.lonmax = setmaxlon(lons,lonmax,err)
      if err then print,'>>> WARNING setaxis_lon: error from func setminlon'
;
      if lonmin gt lonmax then begin
        print,'>>> Minimum must be < maximum: minimum=',lonmin,' maximum=',lonmax
        print,'    Resetting to full axis range: ',lons[0],' to ',$
          lons[nlons-1]
        lonaxis.lonmin = lons[0]
        lonaxis.lonmax = lons[nlons-1]
        widget_control,lonaxis.textmax,set_value=string(lonaxis.lonmax)
        widget_control,lonaxis.textmin,set_value=string(lonaxis.lonmin)
        *plonaxis = lonaxis
      endif else if lonmin eq lonmax then begin
        print,'Setting lonitude axis min,max to full range: ',lons[0],$
          ' to ',lons[nlons-1]
        lonaxis.lonmin = lons[0]
        lonaxis.lonmax = lons[nlons-1]
        widget_control,lonaxis.textmax,set_value=string(lonaxis.lonmax)
        widget_control,lonaxis.textmin,set_value=string(lonaxis.lonmin)
        *plonaxis = lonaxis
        widget_control,event.top,/destroy
      endif else begin
        lonaxis.lonmin = lonmin
        lonaxis.lonmax = lonmax
        *plonaxis = lonaxis
        widget_control,event.top,/destroy
      endelse
    end
    'RESET': begin
      lonaxis.lonmin = lons[0]
      lonaxis.lonmax = lons[nlons-1]
      *plonaxis = lonaxis
      widget_control,event.top,/destroy
    end
    'CANCEL': begin
      print,'Canceling: y-axis lonmin,max=',lonaxis.lonmin,lonaxis.lonmax
      widget_control,event.top,/destroy
    end
    else: print,'>>> setaxes: unrecognized event: ',widget
  endcase
end
;-----------------------------------------------------------------------
pro setaxis_lon,info,pslice
;
  slice = *pslice
  fields = *info.fields
  field = fields[slice.ifield]
  lons = *field.lons
;
  title = 'User set longitude axis range'
  tlb = widget_base(column=1,title=title,group_leader=info.tlb,/modal)
; tlb = widget_base(column=1,title=title,group_leader=info.tlb)
;
; Begin, end of longitude axis:
;
  lonbase = widget_base(tlb,column=1,/frame)
  label = widget_label(lonbase,value='Enter minimum (southern most) longitude ') 
  textmin = widget_text(lonbase,/editable,value=string(slice.lonmin),$
    uvalue='LONMIN')
  label = widget_label(lonbase,value='Enter maximum (northern most) longitude') 
  textmax = widget_text(lonbase,/editable,value=string(slice.lonmax),$
    uvalue='LONMAX')
;
; Reset to vertical range of field:
  button = widget_button(tlb,value='Reset to full longitude range',$
    uvalue='RESET')
;
; ok and cancel buttons:
;
  base = widget_base(tlb,/frame,row=1)
  button = widget_button(base,value='OK',uvalue='OK')
  button = widget_button(base,value='CANCEL',uvalue='CANCEL')
;
; State info:
;
  lonaxis = {lonaxis_struct, $
    lonmin:slice.lonmin,     $ ; longitude minimum on axis 
    lonmax:slice.lonmax,     $ ; longitude maximum on axis
    textmin:textmin,         $ ; widget id of min
    textmax:textmax,         $ ; widget id of max
    lons:ptr_new(lons)       $ ; full longitude array
  }
;
; Pointer to state info:
;
  plonaxis = ptr_new(lonaxis)
  widget_control,tlb,set_uvalue=plonaxis
  widget_control,tlb,/realize
  xmanager,'setaxis_lon',tlb,/no_block
;
; Update slice state info: 
;
  slice.lonmin = (*plonaxis).lonmin  
  slice.lonmax = (*plonaxis).lonmax
  print,'Set user longitude axis min,max = ',slice.lonmin,slice.lonmax
  *pslice = slice 
end
