;
pro setaxis_vert_event,event
  widget_control,event.id,get_uvalue=widget
  widget_control,event.top,get_uvalue=pyaxis
  yaxis = *pyaxis
  levs = *yaxis.levs
  nlevs = n_elements(levs)
  case widget of
    'VBOT': begin
      widget_control,event.id,get_value=botstring
      vbot = mkfloat(botstring[0],yaxis.vbot,event.id)
      if (vbot lt levs[0]) or (vbot gt levs[nlevs-1]) then begin
        print,'>>> Bad bottom value = ',vbot,' (must be >= ',levs[0],$
          ' and <= ',levs[nlevs-1],')'
        widget_control,event.id,set_value=string(yaxis.vbot)
      endif else begin
        yaxis.vbot = vbot
        print,'Set bottom value = ',yaxis.vbot
        *pyaxis = yaxis
      endelse
    end
    'VTOP': begin
      widget_control,event.id,get_value=topstring
      vtop = mkfloat(topstring[0],yaxis.vtop,event.id)
      if (vtop lt levs[0]) or (vtop gt levs[nlevs-1]) then begin
        print,'>>> Bad top value = ',vtop,' (must be >= ',levs[0],$
          ' and <= ',levs[nlevs-1],')'
        widget_control,event.id,set_value=string(yaxis.vtop)
      endif else begin
        yaxis.vtop = vtop
        print,'Set top value = ',yaxis.vtop
        *pyaxis = yaxis
      endelse
    end
    'OK': begin
      widget_control,yaxis.textbot,get_value=botstring
      widget_control,yaxis.texttop,get_value=topstring
      vbot = mkfloat(botstring[0],yaxis.vbot,yaxis.textbot)
      vtop = mkfloat(topstring[0],yaxis.vtop,yaxis.texttop)
      if vbot gt vtop then begin
        print,'>>> Bottom must be < top: bottom=',vbot,' top=',vtop
        print,'    Resetting to full axis range: ',levs[0],' to ',$
          levs[nlevs-1]
        yaxis.vbot = levs[0]
        yaxis.vtop = levs[nlevs-1]
        widget_control,yaxis.texttop,set_value=string(yaxis.vtop)
        widget_control,yaxis.textbot,set_value=string(yaxis.vbot)
        *pyaxis = yaxis
      endif else if vbot eq vtop then begin
        print,'Setting y-axis bottom,top to full axis range: ',levs[0],$
          ' to ',levs[nlevs-1]
        yaxis.vbot = levs[0]
        yaxis.vtop = levs[nlevs-1]
        widget_control,yaxis.texttop,set_value=string(yaxis.vtop)
        widget_control,yaxis.textbot,set_value=string(yaxis.vbot)
        *pyaxis = yaxis
        ;widget_control,event.top,/destroy
      endif else begin
        yaxis.vbot = vbot
        yaxis.vtop = vtop
        *pyaxis = yaxis
        widget_control,event.top,/destroy
      endelse
    end
    'RESET': begin
      yaxis.vbot = levs[0]
      yaxis.vtop = levs[nlevs-1]
      *pyaxis = yaxis
      widget_control,event.top,/destroy
    end
    'CANCEL': begin
      print,'Canceling: y-axis levmin,max=',yaxis.vbot,yaxis.vtop
      widget_control,event.top,/destroy
    end
    else: print,'>>> setaxes: unrecognized event: ',widget
  endcase
end
;-----------------------------------------------------------------------
pro setaxis_vert,info,pslice
;
  slice = *pslice
  fields = *info.fields
  field = fields[slice.ifield]
  levs = *field.levs
;
  title = 'User set axis ranges for vertical slices'
  tlb = widget_base(column=1,title=title,group_leader=info.tlb,/modal)
; tlb = widget_base(column=1,title=title,group_leader=info.tlb)
;
; Bottom, top of vertical y-axis:
;
  levbase = widget_base(tlb,column=1,/frame)
  label = widget_label(levbase,value='Enter top value') 
  texttop = widget_text(levbase,/editable,value=string(slice.levmax),$
    uvalue='VTOP')
  label = widget_label(levbase,value='Enter bottom value') 
  textbot = widget_text(levbase,/editable,value=string(slice.levmin),$
    uvalue='VBOT')
;
; Reset to vertical range of field:
  button = widget_button(tlb,value='Reset to Vertical Range of Field',$
    uvalue='RESET')
;
; ok and cancel buttons:
;
  base = widget_base(tlb,/frame,row=1)
  button = widget_button(base,value='OK',uvalue='OK')
  button = widget_button(base,value='CANCEL',uvalue='CANCEL')
;
; State info:
;
  yaxis = {yaxis_struct, $
    vbot:slice.levmin,   $ ; top axis value
    vtop:slice.levmax,   $ ; bottom axis value
    textbot:textbot,     $ ; widget id of bottom
    texttop:texttop,     $ ; widget id of top
    levs:ptr_new(levs)   $ ; full levs array
  }
;
; Pointer to state info:
;
  pyaxis = ptr_new(yaxis)
  widget_control,tlb,set_uvalue=pyaxis
  widget_control,tlb,/realize
  xmanager,'setaxis_vert',tlb,/no_block
;
; Update slice state info: 
;
  slice.levmin = (*pyaxis).vbot  
  slice.levmax = (*pyaxis).vtop
  print,'Set user vertical bottom,top = ',slice.levmin,slice.levmax

  *pslice = slice 

end
