
pro blue_white_red,ps=ps
;
; Load Jen's custom blue-white-red color table:
;
if (keyword_set(ps)) then $
  print,'Making custom color table blue-white-red (for ps)...' else $
  print,'Making custom color table blue-white-red (no ps)...'

  loadct, 1, /silent
  tvlct, r1, g1, b1, /get
  loadct, 3, /silent
  tvlct, r2, g2, b2, /get
  ncolors = n_elements(r1)
  r1 = reverse(r1)
  b1 = reverse(b1)
  g1 = reverse(g1)
 
  r = r1
  g = g1
  b = b1
  r(0:ncolors/2.-1) = r1(0:ncolors/2.-1)
  r(ncolors/2.:ncolors-1) = r2(ncolors/2.:ncolors-1)
  g(0:ncolors/2.-1) = g1(0:ncolors/2.-1)
  g(ncolors/2.:ncolors-1) = g2(ncolors/2.:ncolors-1)
  b(0:ncolors/2.-1) = b1(0:ncolors/2.-1)
  b(ncolors/2.:ncolors-1) = b2(ncolors/2.:ncolors-1)

  r(0:ncolors/2.-1) = reverse(r(0:ncolors/2.-1))
  r(ncolors/2.:ncolors-1) = reverse(r(ncolors/2.:ncolors-1))
  g(0:ncolors/2.-1) = reverse(g(0:ncolors/2.-1))
  g(ncolors/2.:ncolors-1) = reverse(g(ncolors/2.:ncolors-1))
  b(0:ncolors/2.-1) = reverse(b(0:ncolors/2.-1))
  b(ncolors/2.:ncolors-1) = reverse(b(ncolors/2.:ncolors-1))

nc = ncolors
if (keyword_set(ps)) then begin
  r(0) = 255
  g(0) = 255
  b(0) = 255
  r(nc-1) = 0
  g(nc-1) = 0
  b(nc-1) = 0
endif else begin
  r(0) = 0
  g(0) = 0
  b(0) = 0
  r(nc-1) = 255
  g(nc-1) = 255
  b(nc-1) = 255
endelse
tvlct,r,g,b
!p.color = nc-1
!p.background = 0

end
;-----------------------------------------------------------------------
pro setclrtab,clrtab,ps=ps
if clrtab eq -1 then begin
  if keyword_set(ps) then blue_white_red,/ps else $
                          blue_white_red
  return  
end
loadct,clrtab
tvlct,r,g,b,/get
nc = !d.table_size
if (keyword_set(ps)) then begin
  r(0) = 255
  g(0) = 255
  b(0) = 255
  r(nc-1) = 0
  g(nc-1) = 0
  b(nc-1) = 0
endif else begin
  r(0) = 0
  g(0) = 0
  b(0) = 0
  r(nc-1) = 255
  g(nc-1) = 255
  b(nc-1) = 255
endelse
tvlct,r,g,b
!p.color = nc-1
!p.background = 0
end
