;-----------------------------------------------------------------------
pro anim_event,event
;
; Event handler for animation window:
;
case event.action of
  "DONE": begin
    widget_control,event.top,/destroy
    return
  end
  else: print,'anim_event: Unknown action: ',event.action
endcase
return
end
;-----------------------------------------------------------------------
pro mkcontrols,utvert,new_xaxis=new_xaxis
;this creates and rearranges the different buttons and sliders at the 
;top of the pltutvert.pro plot, it is set up so that the four different
;options LON,ZM,GM,SLT are created seperate from each other.
;written by Tom Freestone 9/3/03
	
if keyword_set(new_xaxis) then begin
  mtime=*utvert.uts
endif else begin
  mtime=utvert.mtime
endelse
;while loop destroys the bases to make room for new ones
child =1
while(child ne 0) do begin
  child=widget_info(utvert.sliderbase, /child)
  if(child ne 0) then begin
    widget_control,child,/destroy
  endif
endwhile

getfield = utvert.field
lats = *getfield.lats
nlat = n_elements(lats)
dlat = .5
file=utvert.file
utmin=utvert.utmin
utmax=utvert.utmax
for i=0,file.ntimes-1 do begin
  if file.mtimes[0,i] eq utmin[0] and file.mtimes[1,i] eq utmin[1] and $
    file.mtimes[2,i] eq utmin[2] then begin
    imtime_min=i
  endif
  if file.mtimes[0,i] eq utmax[0] and file.mtimes[1,i] eq utmax[1] and $
    file.mtimes[2,i] eq utmax[2] then begin
    imtime_max=i
  endif
endfor
imax=imtime_max
imin=imtime_min
radiobase = widget_base(utvert.sliderbase,/base_align_top,column=2)
slider2base = widget_base(utvert.sliderbase,/base_align_bottom,column=2)
;
; dial is either slt,lon,gm,or zm:
;
if getfield.grid_type eq 'magnetic' then begin
  fixbase = widget_base(radiobase,/frame,/exclusive,sensitive=1, $
    column=4,XSIZE=250,YSIZE=30)
  fixlon = widget_button(fixbase,value='LON',$
    uvalue='FIX_LON',/no_release,/align_left)
  fixzm = widget_button(fixbase,value='ZM',$
    uvalue='FIX_ZM',/no_release,/align_center)
  fixgm = widget_button(fixbase,value='GM',$
    uvalue='FIX_GM',/no_release,/align_right)
  fixslt = widget_button(fixbase,value='MLT',$
    uvalue='FIX_SLT',/no_release)
endif else begin
  fixbase = widget_base(radiobase,/frame,/exclusive,sensitive=1, $
    column=4,XSIZE=250,YSIZE=30)
  fixlon = widget_button(fixbase,value='LON',$
    uvalue='FIX_LON',/no_release,/align_left)
  fixzm = widget_button(fixbase,value='ZM',$
    uvalue='FIX_ZM',/no_release,/align_center)
  fixgm = widget_button(fixbase,value='GM',$
    uvalue='FIX_GM',/no_release,/align_right)
  fixslt = widget_button(fixbase,value='SLT',$
    uvalue='FIX_SLT',/no_release)
endelse

dims=size(mtime)
if dims[0] gt 1 then ntm=dims[2]
if dims[0] eq 1 then ntm=1

;checks to see if the slt option is necessary
if utvert.add_slt gt 0 and utvert.days gt 9 then $
  widget_control,fixslt,sensitive=0 
if utvert.add_slt eq 0 then $
  widget_control,fixslt,sensitive=0 

case utvert.slideselect of 
'SLT': begin
  ;
  ; Select local time:
  ;
  t=ntm-1
;sets up the slt slider for the different times
  if utvert.add_slt eq 0 then begin
    if t eq 0 then minimum=mtime[0,0]
    if t eq ntm-1 then maximum=mtime[0,t]
    div=t/(t*2.)
  endif else begin
    minimum=0.
    maximum=24.
    div=1/3.
    if utvert.minutes le 120. and utvert.add_slt gt 0 then begin
      if t eq 0 then minimum=mtime[2,0]/60+mtime[1,0]
      if t eq ntm-1 then maximum=mtime[2,t]/60+mtime[1,t]
    endif
  endelse 
  mag = 0 & if getfield.grid_type eq 'magnetic' then mag = 1
  sltbase = widget_base(slider2base)
  ut = utvert.ut
  title=getfield.grid_type+' Local Time'
  dslt = div
  if utvert.sslt lt minimum or utvert.sslt gt maximum then begin
    utvert.sslt=(maximum+minimum)/2. 
    print,'UTVERT.SSLT OUT OF RANGE, NEW SSLT ',utvert.sslt 
  endif
  if ntm-1 gt 0 and minimum+2 lt maximum or utvert.minutes gt 24.*60. then $
     *utvert.wfsl_slt = cw_fslide(sltbase,minimum=minimum,maximum=maximum,$
      delta=dslt,xsize=230,uvalue="SELECT_SLT",format='(f7.1)',value=utvert.sslt,$
      title=title)
  ;
  ; Select latitude:
  ;
  slatbase = widget_base(slider2base)
  title = getfield.grid_type+' Latitude'
  wfsl_slat = cw_fslide(slatbase,minimum=lats[0],maximum=lats[nlat-1],$
    delta=dlat,xsize=200,uvalue="SELECT_LAT",format='(f7.2)',value=utvert.slat,$
    title=title)
;  if getfield.grid_type eq 'magnetic' then begin
;    widget_control,slatbase,/destroy
;    slatbase = widget_base(slider2base)
;    tx_slat = cw_field(slatbase,/return_events,/floating,/frame, $
;      value=utvert.slat, uvalue="SELECT_LAT",title="magnetic Latitude") 
;  endif
  if(utvert.slideselect eq 'SLT') then begin
    widget_control,fixslt, /set_button
  endif
end
'LON': begin
  ;
  ; Select longitude:
  ;
  lons = *getfield.lons
  nlon = n_elements(lons)
  dlon = lons[1]-lons[0]
  minimum=lons[0]
  maximum=lons[nlon-1]
  delta=dlon
  ;if utvert.minutes le 180. then begin
  ;  minimum=-10.0
  ;  maximum=10.0
  ;  delta=5.0
  ;endif else if utvert.minutes gt 180. then begin
  minimum=-180
  maximum=165
  delta=15.
  dims=size(mtime)
  rows=dims[2]
  ; a delta of 60 is used b/c the slider function rounds to 180
  if rows gt 60 and utvert.minutes gt 59*60 then delta=60
  if mtime[2,1]-mtime[2,0] ne 0 then begin
    delta=0 
  endif 
  if delta le 0 then begin
    maximum =175
    minimum =-180
    delta=5
  endif
  ;endif 
  slonbase = widget_base(slider2base)
  title = getfield.grid_type+' Longitude'
  wfsl_lon = cw_fslide(slonbase,minimum=minimum,maximum=maximum,$
    delta=delta,xsize=200,uvalue="SELECT_LON",format='(f7.2)',value=utvert.slon,$
    title=title)
  ;
  ; Select latitude:
  ;
  slatbase = widget_base(slider2base)
  title = getfield.grid_type+' Latitude'
  wfsl_slat = cw_fslide(slatbase,minimum=lats[0],maximum=lats[nlat-1],$
    delta=dlat,xsize=200,uvalue="SELECT_LAT",format='(f7.2)',value=utvert.slat,$
    title=title)
;  if getfield.grid_type eq 'magnetic' then begin
;    widget_control,slatbase,/destroy
;    slatbase = widget_base(slider2base)
;    tx_slat = cw_field(slatbase,/return_events,/floating,/frame, $
;      value=utvert.slat, uvalue="SELECT_LAT",title="magnetic Latitude") 
;  endif
  if(utvert.slideselect eq 'LON') then begin
    widget_control,fixlon, /set_button
  endif
  *utvert.wfsl_lon=wfsl_lon
end
'GM': begin
  if(utvert.slideselect eq 'GM') then begin
    widget_control,fixgm, /set_button
  endif
end
'ZM': begin
  ;
  ; Select latitude:
  ;
  slatbase = widget_base(radiobase)
  title = getfield.grid_type+' Latitude'
  wfsl_slat = cw_fslide(slatbase,minimum=lats[0],maximum=lats[nlat-1],$
    delta=dlat,xsize=200,uvalue="SELECT_LAT",format='(f7.2)',value=utvert.slat,$
    title=title)
;  if getfield.grid_type eq 'magnetic' then begin
;    widget_control,slatbase,/destroy
;    slatbase = widget_base(slider2base)
;    tx_slat = cw_field(slatbase,/return_events,/floating,/frame, $
;      value=utvert.slat, uvalue="SELECT_LAT",title="magnetic Latitude") 
;  endif
  if(utvert.slideselect eq 'ZM') then begin
    widget_control,fixzm, /set_button
  endif
end
else: print,'Error making buttons returning' 
endcase
end
;-----------------------------------------------------------------------
pro utverts_event,event
widget_control,event.id,get_uvalue=widget
widget_control,event.top,get_uvalue=pinfo
info = *pinfo
utvert = *info.putvert
fields = *info.fields
getfield=utvert.field
file = *info.pfile
field = fields[utvert.ifield]
mag = 0 & if field.grid_type eq 'magnetic' then mag = 1
;
case widget of
  'CLOSE': widget_control,event.top,/destroy
  'SELECT_LON': begin
    utvert.slon = event.value
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    *info.putvert = utvert
    mkcontrols,utvert
    pltutvert,info
  end
  'SELECT_LAT': begin
    if getfield.grid_type eq 'magnetic' then begin
        utvert.slat=event.value
    endif else begin
      utvert.slat = event.value
    endelse
   
    lats = *getfield.lats
    ilat = ixfind_nearest(lats,utvert.slat)
    utvert.slat=lats[ilat]
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    *info.putvert = utvert
    mkcontrols,utvert
    pltutvert,info
  end
  'SELECT_SLT': begin
    utvert.sslt=event.value
    utvert.fixedslt=event.value
    lons = *fields[utvert.ifield].lons
;    utvert.slon=utvert.sslt*15.-180.+71.
    utvert.slon=fslt(utvert.sslt,12,utvert.slon,'getlon')
;    utvert.sslt=compute_sslt(utvert.utmin,utvert.utmax,utvert.minutes)
    utvert.sslt=fslt(utvert.sslt,12,utvert.slon,'getlt')
    if field.grid_type eq 'magnetic' then begin
      utvert.slon=fslt(utvert.fixedslt,12.-71/15.,utvert.slon,'getlon',mag=mag)
      utvert.sslt=fslt(utvert.fixedslt,12,utvert.slon,'getlt',mag=mag)
    endif
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    *info.putvert =utvert
    mkcontrols,utvert
    pltutvert,info
  end
  'FIX_GM': begin
    utvert.slideselect='GM'
    utvert.zonalmean=0
    utvert.globalmean=1
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    *info.putvert=utvert
    mkcontrols,utvert
    utvert.add_slt=0
    pltutvert,info
  end
  'FIX_LON': begin
    utvert.slideselect='LON'
    utvert.zonalmean=0
    utvert.globalmean=0
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    *info.putvert=utvert
    mkcontrols,utvert
    ntms=size(mtime)
    if ntms[0] eq 2 then begin
      ntms=ntms[2]
      for t=0,ntms-1 do begin
        if mtime[1,t] or mtime[2,t] ne 0 then $
          utvert.add_slt=1
      endfor
    endif else utvert.add_slt=0
    pltutvert,info
  end
  'FIX_SLT': begin
    utvert.slideselect='SLT'
    utvert.zonalmean=0
    utvert.globalmean=0
    utvert.slon=0.
    utvert.sslt=12.
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    *info.putvert=utvert
    mkcontrols,utvert
    utvert.add_slt=0
    pltutvert,info
  end
  'FIX_ZM': begin
    utvert.slideselect='ZM'
    utvert.zonalmean = 1 ; defutvertdata and pltutvert will check for this
    utvert.globalmean=0
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    help,utvert.mtimesmenu
    *info.putvert =utvert 
    mkcontrols,utvert
    utvert.add_slt=0
    pltutvert,info
  end
  'SET_MTIME': begin
    mincheck=1
    maxcheck=0
    while (mincheck ge maxcheck) do begin
      newtimes=intarr(3,3)
      newtimes=setaxis_ut(info,info.putvert,utvert.utmin,utvert.utmax,utvert.utint)
      utvert.utmin[0]=newtimes[0,0] & utvert.utmin[1]=newtimes[1,0] & $
        utvert.utmin[2]=newtimes[2,0]
      utvert.utmax[0]=newtimes[0,1] & utvert.utmax[1]=newtimes[1,1] & $
        utvert.utmax[2]=newtimes[2,1]
      mincheck=utvert.utmin[0]*60.*24.+utvert.utmin[1]*60.+utvert.utmin[2]
      maxcheck=utvert.utmax[0]*60.*24.+utvert.utmax[1]*60.+utvert.utmax[2]
      if mincheck ge maxcheck then begin
        print,'Beginning time is before  Ending time, select again'
        mtimes=file.mtimes
        ntimes=size(mtimes)
        ntimes=ntimes[2]
        utvert.utmin[0] = mtimes[0,0] 
        utvert.utmin[1] = mtimes[1,0] 
        utvert.utmin[2] = mtimes[2,0] 
        utvert.utmax[0] = mtimes[0,file.ntimes-1]
        utvert.utmax[1] = mtimes[1,file.ntimes-1]
        utvert.utmax[2] = mtimes[2,file.ntimes-1]
      endif
    endwhile 
    utvert.utint=newtimes[0,2]
    utvert.sslt=compute_sslt(utvert.utmin,utvert.utmax,utvert.minutes)
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    *info.putvert = utvert
    pltutvert,info
  end
  'COLOR': begin
    clrtab = xcolor(info.colortab,event.top)
    info.colortab = clrtab
    pltutvert,info
  end
  'SET_MINMAX': begin
    umin=utvert.fmin & umax=utvert.fmax
    setminmax,info,umin,umax
    utvert.fmin=umin & utvert.fmax=umax
    *info.putvert = utvert
    pltutvert,info
  end
  'RESET_MINMAX': begin
    utvert.fmin=0. & utvert.fmax=0.
    print,'UT slices: reset image min,max to full range.'
    *info.putvert = utvert
    pltutvert,info
  end
  'SET_YAXIS': begin
    setaxis_vert,info,info.putvert 
    utvert = *info.putvert
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    *info.putvert = utvert
    pltutvert,info
  end
  'RESET_YAXIS': begin
    utvert.levmin = (*field.levs)[0] & utvert.levmax = (*field.levs)[field.nlev-1]
    print,'UT vs. Vertical: reset y-axis (zp or ht) to full range.'
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    *info.putvert = utvert
    pltutvert,info
  end
  'RESET_XAXIS': begin
    mtimes=file.mtimes
    ntimes=size(mtimes)
    ntimes=ntimes[2]
    utvert.utmin[0] = mtimes[0,0] 
    utvert.utmin[1] = mtimes[1,0] 
    utvert.utmin[2] = mtimes[2,0] 
    utvert.utmax[0] = mtimes[0,file.ntimes-1]
    utvert.utmax[1] = mtimes[1,file.ntimes-1]
    utvert.utmax[2] = mtimes[2,file.ntimes-1]
    utvert.utint=1
    utvert.sslt=compute_sslt(utvert.utmin,utvert.utmax,utvert.minutes)
    print,'UT vs. Vertical: reset x-axis (UT) to full range.'
    data = *field.data
    defutvertdata,utvert,data
    *info.putvert = utvert
    pltutvert,info
  end
  'ADD_YAX': begin
    utvert.rhyaxis = 1 ; add extra right-hand y-axis
    if field.difftype ne '' then begin
      print,'>>> WARNING: this is a difference fields file: right-hand',$
            '    axis in height is not available...'
      utvert.rhyaxis = 0
    endif else if mag eq 1 then begin
      print,'>>> WARNING: this is a magnetic gridded field: right-hand',$
            '    axis in height is not available...'
      utvert.rhyaxis = 0
    endif else begin
      print,'Will add extra right-hand y-axis'
    endelse
    *info.putvert = utvert
    pltutvert,info
  end
  'RM_YAX': begin
    utvert.rhyaxis = 0 ; remove extra right-hand y-axis
    print,'Will remove extra right-hand y-axis'
    *info.putvert = utvert
    pltutvert,info
  end
  'CUSTOM_CONTOUR': begin
    utvert.setcontour = 'on'
    cmin=utvert.fmin & cmax=utvert.fmax & cint=utvert.cint & clineclr = utvert.clineclr
    custom_contour,info.tlb,cmin,cmax,cint,clineclr
    utvert.clineclr = clineclr
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    data = *utvert.data
    fminmax,data,fmin,fmax,utvert.missing_value
    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
    utvert.fmin=cmin & utvert.fmax=cmax & utvert.cint=cint
    *utvert.clevels = levels
    *info.putvert = utvert
    pltutvert,info
  end
  'RESET_CONTOUR': begin
    utvert.setcontour = 'off'
    cmin=0. & cmax=0. & cint=0.
    print,'UT vs. Vertical: reset contour min,max to full range.'
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
    data = *utvert.data
    fminmax,data,fmin,fmax,utvert.missing_value
    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
    utvert.fmin=cmin & utvert.fmax=cmax & utvert.cint=cint
    *utvert.clevels = levels
    *info.putvert = utvert
    pltutvert,info
  end
  'LOG10': begin
    utvert.log10 = 'density fields'
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
;
; Reset min,max and contour interval:
    fminmax,*utvert.data,fmin,fmax,utvert.missing_value
    cmin=0. & cmax=0. & cint=0.
    *utvert.clevels = mkclevels(fmin,fmax,cmin,cmax,cint)
    utvert.fmin=cmin & utvert.fmax=cmax & utvert.cint=cint
    *info.putvert = utvert
    print,'Will plot log10 of density fields'
    pltutvert,info
  end
  'LOG10_ALLFIELDS': begin
    utvert.log10 = 'all fields'
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
;
; Reset min,max and contour interval:
    fminmax,*utvert.data,fmin,fmax,utvert.missing_value
    cmin=0. & cmax=0. & cint=0.
    *utvert.clevels = mkclevels(fmin,fmax,cmin,cmax,cint)
    utvert.fmin=cmin & utvert.fmax=cmax & utvert.cint=cint
    *info.putvert = utvert
    print,'Will plot log10 of all fields'
    pltutvert,info
  end
  'LINEAR': begin
    utvert.log10 = 'none'
    data = *fields[utvert.ifield].data
    defutvertdata,utvert,data
;
; Reset min,max and contour interval:
    fminmax,*utvert.data,fmin,fmax,utvert.missing_value
    cmin=0. & cmax=0. & cint=0.
    *utvert.clevels = mkclevels(fmin,fmax,cmin,cmax,cint)
    utvert.fmin=cmin & utvert.fmax=cmax & utvert.cint=cint
    *info.putvert = utvert
    print,'Will plot linear fields (no log10)'
    pltutvert,info
  end
  'ANIM_LAT_FIXLON': begin
    widget_control,event.id,/sensitive
    animate_utvert,info,'lat_fixlon'
  end
  'ANIM_UT_SCAN': begin
    widget_control,event.id,/sensitive
    animate_utvert,info,'ut_scan'
  end
  'ANIM_UT_JUMP': begin
    widget_control,event.id,/sensitive
    animate_utvert,info,'ut_jump'
  end
;
; Save images in ps or bitmap file for export:
;
  'SAVE_PS': begin
    title='Select File for Postscript'
    psfile = dialog_pickfile(path=info.openpath,title=title,$
      group=event.top)
    if (psfile ne '') then begin
      widget_control,event.top,hourglass=1
      pson,filename=psfile,margin=1.0
      setclrtab,info.colortab,/ps
      pltutvert,info,/ps
      psoff
      widget_control,event.top,hourglass=0
    endif
  end
  'SAVE_PNG': begin
    windowsave = !d.window
    window,xsize=utvert.draw_xsize,ysize=utvert.draw_ysize,/pixmap
    windo = !d.window
    wset,windo
    setclrtab,info.colortab
    pltutvert,info,/png
    writeimage,info.openpath,event.top,'PNG'
    wset,windowsave
  end
  'SAVE_GIF': begin
    version = float(!version.release)
    if version le 5.3 then begin
      writeimage,info.openpath,event.top,'GIF'
    endif else begin 
      print,'>>> NEED IDL version 5.3 to make GIF'
    endelse
  end  
  'SAVE_BMP': writeimage,info.openpath,event.top,'BMP'
  'SAVE_JPEG': writeimage,info.openpath,event.top,'JPEG'
  'SAVE_TIFF': writeimage,info.openpath,event.top,'TIFF'
;
; Plot types
;
  'IMAGE_ONLY': begin
;    if mag eq 1 then begin
 ;     print,'>>> WARNING: cannot make image of magnetic field because of ',$
 ;       'irregular latitude grid. Staying with plot type ',utvert.plottype
 ;   endif else begin
      utvert.plottype = 'image_only'
      *info.putvert = utvert
      print,'Set plot type to ',utvert.plottype
      pltutvert,info
      widget_control,utvert.minmaxmenu,sensitive=1   ; can set image min,max
      widget_control,utvert.contourmenu,sensitive=0  ; not doing contours
  ;  endelse
  end
  'IMAGE+CONTOURS': begin
   ; if mag eq 1 then begin
   ;   print,'>>> WARNING: cannot make image of magnetic field because of ',$
   ;     'irregular latitude grid. Staying with plot type ',utvert.plottype
   ; endif else begin
      utvert.plottype = 'image+contours'
      *info.putvert = utvert
      print,'Set plot type to ',utvert.plottype
      pltutvert,info
      widget_control,utvert.minmaxmenu,sensitive=0   ; image minmax will be fmin,fmax
      widget_control,utvert.contourmenu,sensitive=1  ; doing contours
   ; endelse
  end
  'MONOCHROME_CONTOURS': begin
    utvert.plottype = 'monochrome_contours'
    *info.putvert = utvert
    print,'Set plot type to ',utvert.plottype
    pltutvert,info
    widget_control,utvert.minmaxmenu,sensitive=0   ; no image
    widget_control,utvert.contourmenu,sensitive=1  ; doing contours
  end
  'COLORFILL_CONTOURS': begin
    utvert.plottype = 'colorfill_contours'
    *info.putvert = utvert
    print,'Set plot type to ',utvert.plottype
    pltutvert,info
    widget_control,utvert.minmaxmenu,sensitive=0   ; no image
    widget_control,utvert.contourmenu,sensitive=1  ; doing contours
  end
  else: print,'>>> utverts_event: unknown widget ',widget
endcase
*pinfo = info
end
;-----------------------------------------------------------------------
pro field_utvert_event,event
;
; User has selected a field. Read field from the file and update
; utvert structure.
;
widget_control,event.id,get_uvalue=widget
widget_control,event.top,get_uvalue=pinfo

info = *pinfo
utvert = *info.putvert
utvert.setcontour = 'off'
fields = *info.fields
gridtype_prev = fields[utvert.ifield].grid_type
for i=0,info.nflds-1 do begin
  if (widget eq fields[i].name) then begin
    utvert.ifield = i
;
; Field has already been read and post-processed -> just update utvert.field:
    if ptr_valid(fields[i].data) then begin ; field has been read
      print,'Selected field ',fields[i].name
      fmin = min(*fields[i].data) & fmax = max(*fields[i].data)
      utvert.field = fields[i]
;
; Field has not been read yet:
    endif else begin
      widget_control,/hourglass
      print,'Reading field ',fields[i].name
;
; Read 4d data from the file -- data is returned in ncdata: 
      varget,info,fields[i],ncdata
      field = fields[i]
;
; Post-process the field:
      procfield,info,ncdata,field,info.z_hist
      fields[i] = field
;
; Report 4d min,max:
      fmin = min(*fields[i].data) & fmax = max(*fields[i].data)
      rpt_minmax,info,fields[i],fmin,fmax
    endelse
    utvert.field = fields[i]
    data = *fields[utvert.ifield].data
;
; If this is a change in grid type, reset select-longitude slider:
    if fields[utvert.ifield].grid_type ne gridtype_prev then begin
      mag = 0 & if fields[utvert.ifield].grid_type eq 'magnetic' then mag = 1
      print,'Switching longitude slider geo<->mag..'
      mkcontrols,utvert
    endif
;
; Get ut vs vertical slice:
    defutvertdata,utvert,*fields[i].data
;
; Reset min,max and contour interval:
    data = *utvert.data
    fminmax,*utvert.data,fmin,fmax,utvert.missing_value
    cmin=0. & cmax=0. & cint=0.
    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
    utvert.fmin=cmin & utvert.fmax=cmax & utvert.cint=cint
    *utvert.clevels = levels
  endif ; found field name
endfor
;
; Update state info:
;
  *info.fields = fields
  *info.putvert = utvert
  *pinfo = info
  pltutvert,info
end
;-----------------------------------------------------------------------
pro utverts,info
;this procedure is the main procedure to produce plots of ut vs. vertical
;using the data read in from readfile.pro, the structure utvert is created
;in the procedure 
;written by Tom Freestone 9/3/03
;
; Set up longitude slice widget:
;
file = *info.pfile     ; file info structure
fields = *info.fields  ; fields info structure
;
title = 'UT vs. Vertical: '+info.file
tlb = widget_base(column=1,mbar=mbar, title=title)
;
utvert_ids = *info.putvert_ids
for i=0,n_elements(utvert_ids)-1 do begin
  if (utvert_ids(i) le 0) then begin
    utvert_ids(i) = tlb
    goto,done
 endif
endfor
done:
missing_value = file.missing_value
;
; Fields menu:
;
;fieldsmenu = widget_button(mbar,value='Field')
;for i=0,info.nflds-1 do begin
;  button = widget_button(fieldsmenu,value=fields[i].name,$
;    uvalue=fields[i].name,event_pro='field_utvert_event')
;  if (i eq 0) then field = fields[i].name
;endfor

 fieldsmenu = fields_menu(mbar,fields,'field_utvert_event')
;
; Model times menu:
;

mtimesmenu = widget_button(mbar,value='ModelTime')
button = widget_button(mtimesmenu,$
  value='Set beginning and ending times',uvalue='SET_MTIME')
button = widget_button(mtimesmenu,$
  value='Reset times to full range',uvalue='RESET_XAXIS')
mtime = file.mtimes
imtime = 0
;
; ------------------------- Plot options menus -----------------
;
optsmenu = widget_button(mbar,value='PlotOptions')
;
; Plot types (submenu under plot options):
;
plottype = widget_button(optsmenu,value='Plot Type',/menu)
button = widget_button(plottype,$
  value='Image Only',uvalue='IMAGE_ONLY')
button = widget_button(plottype,$
  value='Image plus Contours',uvalue='IMAGE+CONTOURS')
button = widget_button(plottype,$
  value='Monochrome Contours',uvalue='MONOCHROME_CONTOURS')
button = widget_button(plottype,$
  value='Color-fill Contours',uvalue='COLORFILL_CONTOURS')

;
; Plotting log10 of the fields: there are 3 options:
;   utvert.log10 = 'density fields'  -> plot log10 of density fields only
;   utvert.log10 = 'all fields'      -> always plot log10
;   utvert.log10 = 'none'            -> never plot log10
; (See pro utvert_event above, and defutvertdata.pro and pltlon.pro)
; Log10 submenu under PlotOptions:
;
log10menu = widget_button(optsmenu,value='Plot log10 of field:',/menu)
button = widget_button(log10menu,value='Plot log10 (density fields only)',$
  uvalue='LOG10')
button = widget_button(log10menu,value='Plot log10 (all fields)',$
  uvalue='LOG10_ALLFIELDS')
button = widget_button(log10menu,value='Plot linear (all fields)',$
  uvalue='LINEAR')
;
; Add or remove extra right-hand y-axis (if left-hand y-axis is linear
; Zp then add non-linear right y-axis in height):
;
yaxmenu = widget_button(optsmenu,value='Extra right-hand y-axis:',/menu)
button = widget_button(yaxmenu,value='Add Right-hand Y-axis in Height',$
  uvalue='ADD_YAX')
button = widget_button(yaxmenu,value='Remove Right-hand Y-axis in Height',$
  uvalue='RM_YAX')
;
; User set y-axis range (zp):
;
yaxismenu = widget_button(optsmenu,value='Set y-axis range (zp or ht)',/menu)
button = widget_button(yaxismenu,value='Reset to full range',$
  uvalue='RESET_YAXIS')
button = widget_button(yaxismenu,value='Set vertical min,max...',$
  uvalue='SET_YAXIS')
;
; User set x-axis range (ut):
;
;xaxismenu = widget_button(optsmenu,value='Set x-axis range (UT)',/menu)
;button = widget_button(xaxismenu,value='Reset to full range',$
;  uvalue='RESET_XAXIS')
;button = widget_button(xaxismenu,value='Set UT min,max...',$
;  uvalue='SET_XAXIS')
;
; Custom Contour:
;
contourmenu = widget_button(optsmenu,value='Custom Contour',/menu)
button = widget_button(contourmenu,value='Reset to full range',$
  uvalue='RESET_CONTOUR')
button = widget_button(contourmenu,value='Set min,max,interval...',$
  uvalue='CUSTOM_CONTOUR')
;
; User set field min,max of image:
;
minmaxmenu = widget_button(optsmenu,value='Fix Image min,max',/menu)
button = widget_button(minmaxmenu,value='Reset to full range',$
  uvalue='RESET_MINMAX') 
button = widget_button(minmaxmenu,value='Set Image min,max...',$
  uvalue='SET_MINMAX') 
;
; Change color tables:
;
button = widget_button(optsmenu,value='Color...',uvalue='COLOR')
;
; ------------------------- Animation menus --------------------------
;
animmenu = widget_button(mbar,value='Animate')
button = widget_button(animmenu,value='Animate in latitude (fixed longitude)',$
  uvalue='ANIM_LAT_FIXLON')
button = widget_button(animmenu,value='Animate scan ut (fixed location)',$
  uvalue='ANIM_UT_SCAN')
button = widget_button(animmenu,value='Animate jump ut (fixed location)',$
  uvalue='ANIM_UT_JUMP')
;
; ------------------------- Save output files --------------------------
;
savemenu = widget_button(mbar,value='SaveFiles')
button = widget_button(savemenu,value='Postscript...',uvalue='SAVE_PS')
button = widget_button(savemenu,value='PNG...',uvalue='SAVE_PNG')
button = widget_button(savemenu,value='GIF...',uvalue='SAVE_GIF')
button = widget_button(savemenu,value='BMP...',uvalue='SAVE_BMP')
button = widget_button(savemenu,value='JPEG...',uvalue='SAVE_JPEG')
button = widget_button(savemenu,value='TIFF...',uvalue='SAVE_TIFF')
;
; ------------------ Sliders for selected lons, slt -------------------
;
; Base for 2 sliders that select longitude and local time:
;
sliderbase = widget_base(tlb,row=2,/frame)
;
*info.putvert_ids = utvert_ids
draw_xsize = 500 & draw_ysize = 500
draw = widget_draw(tlb,xsize=draw_xsize,ysize=draw_ysize,uvalue='DRAW_UTVERT')
button = widget_button(tlb,value='Close',uvalue='CLOSE')
;
;defines variables for the structure
lats = *fields[0].lats
latmin = lats[0] & latmax = lats[n_elements(lats)-1]
levs = *fields[0].levs
levmin = levs[0]
;nlev = fields[0].nlev
nlev = SIZE(levs,/N_ELEMENTS)
levmax = levs[nlev-1]
ut = mtime[1]+mtime[2]/60.

nut = fields[0].ntime
;determines what form of time the histories are in (min,hr,day)
;and determines how many times there are and what the middle history is
add_slt=0

dims=size(mtime)
if dims[0] ne 1 then begin
for i=0,dims[2]-1 do begin
  if mtime[1,i] ne 0 or mtime[2,i] ne 0 then begin 
    add_slt=1
  endif
endfor
endif
if dims[0] ne 1 then begin 
  imin=0
  imax=dims[2]-1
  utmin=mtime[*,imin]
  utmax=mtime[*,imax]
  arr_minutes=get_time_min(file.mtimes,utmin,utmax)
  dims2=size(arr_minutes)
  dims2=dims2[1]
  minutes=arr_minutes[dims2-1]-arr_minutes[0]
  minutes=minutes+(arr_minutes[1]-arr_minutes[0])
  sslt = compute_sslt(utmin,utmax,minutes)
  days=utmax[0]-utmin[0]
  if (utmin[2]-mtime[2,1]) ne 0. then begin
    min_hist=1
  endif else begin
    min_hist=0
  endelse
  if (utmin[1]-mtime[1,1]) ne 0. then begin
    hr_hist=1
  endif else begin
    hr_hist=0
  endelse
endif else begin 
  imin=0
  imax=0
  utmin=mtime[*,imin]
  utmax=mtime[*,imax]
  minutes=0
  sslt=0
  days=0
  min_hist=0
  hr_hist=0
endelse 
if hr_hist eq 1 then begin
 interval=mtime[1,1]-mtime[1,0] & type='hr'
endif else if min_hist eq 1 then begin
  interval=mtime[2,1]-mtime[2,0] & type='min'
  interval=1
endif else begin
  interval=mtime[0,1]-mtime[0,0] & type='day'
endelse  
slat=37.5
; -------------------------- UT vs. Vertical structure ---------------------
;
utvert = {                 $
  field:fields[0],                $ ; current field structure
  ifield:0,		          $ ; index to current field	
  file:file,                      $ ; file structure
  slon:0.,                        $ ; selected longitude
  sslt:sslt,                      $ ; selected local time
  slat:slat,                      $ ; selected latitude
  fixedslt:12,                    $ ; selected fixed slt
  utvert_type:'lon',              $ ; 'lon','slt', or 'zm'
  mtime:mtime,                    $ ; model time (default first time on file)
  imtime:imtime,                  $ ; index to mtime (file.mtimes[imtime]) 
  imin:imin,                      $ ; index to min selected mtime (file.mtimes[imtime]) 
  utint:interval,                 $ ; interval between ut
  imax:imax,                      $ ; index to max mtime (file.mtimes[imtime]) 
  mtimesmenu:mtimesmenu,          $ ; model time widget to control sensitivity
  minutes:minutes,                $ ; total minutes in model time
  days:days,                      $ ; indicates amount of days in history
  min_hist:min_hist,              $ ; indicates a minute history
  hr_hist:hr_hist,                $ ; indicates an hourly history
  add_slt:add_slt,                $ ; adds the extra slt axis and indicates if the histories are daily
  log10:'density fields',         $ ; plot log10 (densities, current field, on none)
  ut:ut,                          $ ; ut (hrs)
  missing_value:missing_value,    $ ; missing data value
  sliderbase:sliderbase,          $ ; widget id of cw lev slider base
  tlb:tlb,                        $ ; top level base of utvert menu
  rhyaxis:1,                      $ ; if > 0 then add extra right-hand y-axis
  draw:draw,                      $ ; draw widget id
  draw_xsize:draw_xsize,          $ ; x size of draw widget
  draw_ysize:draw_ysize,          $ ; y size of draw widget
  slideselect:'LON',              $ ; controls radio buttons
  minmaxmenu:minmaxmenu,          $ ; menu widget for setting image min,max
  contourmenu:contourmenu,        $ ; menu widget for custom contour
  ftype:info.ftype,               $ ; Type of input file (TIME-GCM or WACCM presently)
  plottype:'image+contours',      $ ; 4 options (see plottype_menu)
  clineclr:!d.table_size-1,       $ ; contour line color
  zonalmean:0,                    $ ; plot zonal mean if zonalmean==1
  globalmean:0,                   $ ; plot global mean if globalmean==1
  setcontour:'off',               $ ; controls when the contours should reset 
  fmin:0.,fmax:0.,cint:0.,        $ ; field min,max and contour interval
  clevels:ptr_new(/allocate_heap),$ ; contour levels
  levs:ptr_new(/allocate_heap),   $ ; vertical levels for y axis
  uts:ptr_new(/allocate_heap),    $ ; uts for the x axis
  levmin:levmin,levmax:levmax,    $ ; min,max of lev y-axis
  utmin:utmin,utmax:utmax,        $ ; ut min and max
  data:ptr_new(/allocate_heap),   $ ; 2d data (lats,levs)
  wfsl_lon:ptr_new(/allocate_heap), $; pointer to lon slider for mag fields
  wfsl_slt:ptr_new(/allocate_heap) $; pointer to lon slider for mag fields
}
*utvert.levs = levs
mkcontrols,utvert
;
; Read data from first field:
;
if ptr_valid(fields[0].data) then begin ; field has been read
  defutvertdata,utvert,*fields[0].data
endif else begin
  widget_control,/hourglass
  varget,info,fields[0],ncdata
  field = fields[0]
  procfield,info,ncdata,field,info.z_hist
  fields[0] = field
  utvert.levmin = (*field.levs)[0] & utvert.levmax = (*field.levs)[field.nlev-1]
  defutvertdata,utvert,*fields[0].data
  utvert.field = field
;  utvert.levs = utvert.field.levs
endelse
;
; Set min,max for first field:
;
fminmax,*utvert.data,fmin,fmax,utvert.missing_value
rpt_minmax,info,fields[0],fmin,fmax
widget_control,utvert.minmaxmenu,sensitive=0 ; because default plottype is image+contour
;
; Set min,max and contour interval:
;
cmin=0. & cmax=0. & cint=0.
levels = mkclevels(fmin,fmax,cmin,cmax,cint)
utvert.fmin=cmin & utvert.fmax=cmax & utvert.cint=cint
*utvert.clevels = levels
;
; Update state info, realize the widgets, plot the first slice:
;
*info.fields = fields
info.putvert = ptr_new(utvert)
widget_control,tlb,/realize
pinfo = ptr_new(info)
pltutvert,info
widget_control,tlb,set_uvalue=pinfo
xmanager,'utverts',tlb,/no_block
end
