;-----------------------------------------------------------------------
PRO zonalsliders,line

  field = line.field
  sliderbase = line.sliderbase
;
; ------------------ Sliders for selected lons, levs -------------------
;
; Select latitude:
;
  lats = *field.lats
  nlat = n_elements(lats)
  dlat = lats[1]-lats[0]
  slat = line.slat
  slatbase = widget_base(sliderbase)
  title='Select '+field.grid_type+' Latitude'
  wfsl_slat = cw_fslide(slatbase,minimum=lats[0],maximum=lats[nlat-1],$
    delta=dlat,xsize=230,uvalue="SELECT_LAT",format='(f7.2)',value=slat,$
    title=title)
  line.wfsl_lat = wfsl_slat
;
; Select level:
;
  levs = *line.levs
  nlev = n_elements(levs)
  dlev = levs[1]-levs[0]
  slev = line.slev
  slevbase = widget_base(sliderbase)
  title='Select Vertical Level'
  wfsl_slev = cw_fslide(slevbase,minimum=levs[0],maximum=levs[nlev-1],$
    delta=dlev,xsize=230,uvalue="SELECT_LEV",format='(f7.2)',value=slev,$
    title=title)
  line.wfsl_lev = wfsl_slev
;
; Select local time:
;
;  sltbase = widget_base(sliderbase)
;  sslt = line.sslt
;  dslt = dlon/15.
;  title='Select '+field.grid_type+' Local Time'
;  wfsl_slt = cw_fslide(sltbase,minimum=0.,maximum=24.,$
;    delta=dslt,xsize=230,uvalue="SELECT_SLT",format='(f5.2)',value=sslt,$
;    title=title)
;
;  line.wfsl_slt = wfsl_slt

END
