# Linux (non-lightning Linux, e.g. hao linux boxes):
#
 FC = pgf90
#
# Works with Fedora core 3:
#FFLAGS = -O2 -I/opt/local/include -DMSS -DLINUX
#
# 7/24/07: Downloaded precompiled netcdf-3.6.2 for hao linux to avoid
# "File too large" error from 3.6.0 for files larger than 2 GB. The new 
# lib is temporarilly in /oreo/d/foster/netcdf-3.6.2. At some point it
# will be copied to /opt/local/lib. 
#
 FFLAGS = -O2 -I/opt/local/include -DMSS -DLINUX
#
 LIBS = -L/usr/lib/gcc-lib/i386-redhat-linux/3.2.3/ -lg2c -lgcc \
        -L /opt/local/lib -lhlu -lncarg -lncarg_gks -lncarg_c \
        -L /usr/lib -lX11 -lXext \
        -L /oreo/d/foster/netcdf-3.6.2/lib -lnetcdf

#       -L /opt/local/rh9/lib -lnetcdf
 CSRCS= wrxdrc.c v5d.c binio.c
 COBJS= $(CSRCS:.c=.o)
#
#FC=/usr/bin/f90
#FFLAGS = -C -v -c -freeform -64 -g -DEBUG:div_check=3:trap_uninitialized=ON:verbose_runtime=ON:fullwarn=ON
#FFLAGS= -c -g -I /hir1/cacraig/HDF-EOS5/hdfeos5/include -freeform -mp -64
#LINKFLAGS= -g3 -64 -C -mp
#INCS=-I. -I$(PGSINC) -I$(HDFINC) -I$(MOD_F95) -I$(MOD_F90) -I$(HDFEOS5_INC)
#LIB_DIRS=-L${PGSLIB}
#LIB_FILES=$(PGSLIB)/libPGSTK.a
#LIBS = -L$(HDF5LIB) -lhdf5 -L$(HDFEOS5_LIB) -lhe5_hdfeos $(LIB_DIRS) -lPGSTK -L$(HDF5LIB) -lhdf5 -L/usr/freeware/lib64 -rpath$(HDF5LIB) -L$(HDFLIB) -lmfhdf -ldf -lz -ljpeg
GOAL=lambWaves
OBJS=lambWaves.o shaes.o sphcom.o hrfft.o

H2  = ../H2
SWT = /hir1/joemci/ENGIN/SWATH/
#SWT = /hir1/joemci/ENGIN/H2CLP/SWATH/
#$GOAL: $(OBJS) $(LIB_FILES) lambWaves.make
#	$(FC) -o $(GOAL) $(LINKFLAGS) $(OBJS) $(LIBS)

$GOAL: $(OBJS) $(LIB_FILES) lambWaves.make
	$(FC) -o $(GOAL) $(OBJS) $(LIBS)

lambWaves.o: $(OBJS)
	$(FC) $(FFLAGS) tstH2CLP.f $(INCS)

H2_Mod.o: $(H2)/H2_Mod.f\
          $(H2)/H2_MoveFile.f\
          $(H2)/H2_ErrHandle.f\
          $(H2)/H2_Diagnostic.f\
          $(H2)/H2_CheckAlloc.f\
          $(H2)/H2_Parselist.f\
          $(H2)/H2_Interp2dlin.f\
          $(H2)/H2_CheckDims.f\
          $(H2)/H2_Missing.f\
          $(H2)/H2_NaN.f
	$(FC) $(FFLAGS) ../H2/H2_Mod.f $(INCS)

H2CLP_Mod.o: H2CLP_Mod.f H2CLP_Driver.f SWATH_Mod.o H2CLP.f
	$(FC) $(FFLAGS) H2CLP_Mod.f $(INCS)

SWATH_Mod.o: $(SWT)SWATH_Mod.f \
             $(SWT)SWATH_Create.f \
             H2_Mod.o  \
             $(SWT)SWATH_Init.f \
             $(SWT)SWATH_SetExtent.f \
             $(SWT)SWATH_Write.f \
             $(SWT)SWATH_Write_generic.f \
             $(SWT)SWATH_WriteHeader.f \
             $(SWT)SWATH_Open.f \
             $(SWT)SWATH_Read.f \
             $(SWT)SWATH_WriteDynam2D.f \
             $(SWT)SWATH_ReadHeader.f \
             $(SWT)SWATH_ReadDynam2D.f \
             $(SWT)SWATH_HIRRAD_ReadStatic.f \
             $(SWT)SWATH_HIR2LSGW_WriteStatic.f \
             $(SWT)SWATH_HIR2CLC_WriteStatic.f \
             $(SWT)SWATH_HIR2CLIM_ReadStatic.f \
             $(SWT)SWATH_HIRPROF_ReadStatic.f \
             $(SWT)SWATH_HIRPROF_WriteStatic.f \
             $(SWT)SWATH_HIRDLS2_WriteStatic.f 
	$(FC) $(FFLAGS) $(SWT)SWATH_Mod.f $(INCS)
