;-----------------------------------------------------------------------
pro animate_lats,info,func
;
; Animate latitude slices in one of two ways, according to input func:
;   In time (at fixed latitude)   func = 'time_fixlat'
;   In latitude (at fixed ut)     func = 'lat_fixut'
;
; Get state info:
;
lat = *info.plat
fields = *info.fields
field = fields[lat.ifield]
data = *field.data
file = *info.pfile
wanim_xsize=450 & wanim_ysize=450
mag = 0 & if field.grid_type eq 'magnetic' then mag = 1
;
;print,'Enter animate_lats: lat.fmin,max=',lat.fmin,lat.fmax
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Animate in time (fixed latitude):
;
widget_control,/hourglass
case func of
  "time_fixlat": begin
    animbase = widget_base(title=$
      'Animate lat slices in time (fixed latitude)')
    newtimes=intarr(3,3)
    utmin=intarr(3,1)
    utmax=intarr(3,1)
    utmin[0]=file.mtimes[0,0] & utmin[1]=file.mtimes[1,0] & $
      utmin[2]=file.mtimes[2,0]
    utmax[0]=file.mtimes[0,file.ntimes-1] & utmax[1]=file.mtimes[1,file.ntimes-1] & $
      utmax[2]=file.mtimes[2,file.ntimes-1]
    interval=1
    newtimes=setaxis_ut(info,info.plat,utmin,utmax,interval)
    utmin[0]=newtimes[0,0] & utmin[1]=newtimes[1,0] & $
      utmin[2]=newtimes[2,0]
    utmax[0]=newtimes[0,1] & utmax[1]=newtimes[1,1] & $
      utmax[2]=newtimes[2,1]
    interval=newtimes[0,2]
    if (interval eq -1) then begin
      print,'Cancelling lat slice animation..'
      return
    endif
    type_hist=newtimes[1,2]
    imtime_min = -1
    imtime_max = -1
    for i=0,file.ntimes-1 do begin
      if file.mtimes[0,i] eq utmin[0] and file.mtimes[1,i] eq utmin[1] and $
        file.mtimes[2,i] eq utmin[2] then begin
        imtime_min=i
      endif
      if file.mtimes[0,i] eq utmax[0] and file.mtimes[1,i] eq utmax[1] and $
        file.mtimes[2,i] eq utmax[2] then begin
        imtime_max=i
      endif
    endfor
    if imtime_min gt imtime_max then $
      imtime_max=file.ntimes-1 & $  
      print,'max time is less than min time resetting max time:',imtime_max
    nframes=imtime_max-imtime_min+1
;
; Set min,max for constant scale:
; Save current:
;
    savemtime  = lat.mtime  & saveimtime = lat.imtime
    savefmin = lat.fmin & savefmax = lat.fmax
    saveut     = lat.ut
;
; Calculate min,max for entire animation if not already fixed:
;
    if lat.setcontour eq 'off' then begin
      lat.fmin =  1.e36 & lat.fmax = -1.e36
      ;for i=0,nframes-1 do begin
      for i=0,file.ntimes-1 do begin
        lat.imtime = i
        deflatdata,lat,data
        fminmax,*lat.data,fmin,fmax,file.missing_value
        if fmin lt lat.fmin then lat.fmin = fmin
        if fmax gt lat.fmax then lat.fmax = fmax
        cmin=0. & cmax=0. & cint=0.
        levels = mkclevels(fmin,fmax,cmin,cmax,cint)
        *lat.clevels = levels
      endfor
      print,'animate_lats: calculated fmin,max=',lat.fmin,lat.fmax
    endif
;
; Load frames and run cw_animate:
;
    numberframes=0 
    for i=0,nframes-1 do begin
      lat.imtime = i+imtime_min
      if file.mtimes[type_hist,lat.imtime] mod interval eq 0 then begin
        numberframes=numberframes+1
      endif
    endfor
    animate = cw_animate(animbase,wanim_xsize,wanim_ysize, $
      numberframes)
    add_animid,info,animate

    widget_control,animbase,/realize 
    framenum=0
    for i=0,nframes-1 do begin
      lat.imtime = i+imtime_min
      if file.mtimes[type_hist,lat.imtime] mod interval eq 0 then begin
        lat.mtime = file.mtimes[*,lat.imtime]
        lat.ut = lat.mtime[1]+lat.mtime[2]/60.
        deflatdata,lat,data
        *info.plat = lat
        window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
        windo = !d.window
        wset,windo
        pltlat,info,/animate
        cw_animate_load,animate,frame=framenum,window=windo,/track
	framenum=framenum+1
      endif
;     print,'Animate lat in time (fixed lat): frame=',i,' out of ',nframes,$
;       ' lat.fmin,max=',lat.fmin,lat.fmax
    endfor
;
    lat.mtime = savemtime & lat.imtime = saveimtime
    lat.fmin = savefmin & lat.fmax = savefmax
    lat.ut = saveut
    *info.plat = lat
    cw_animate_run,animate,nframes= $
      ceil(float(nframes)/float(interval))
  end ; animate in time (fixed latitude)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Animate in latitude (fixed ut):
;
  "lat_fixut": begin
    animbase = widget_base(title='Animate in latitude (fixed ut)')
    nframes = field.nlat
    savelat = lat.slat
    savefmin = lat.fmin & savefmax = lat.fmax
;
; Calculate min,max for entire animation if not already fixed:
;
   if lat.setcontour eq 'off' then begin
    if lat.fmin ge lat.fmax then begin ; minmax is *not* fixed
      lat.fmin =  1.e36 & lat.fmax = -1.e36
      for i=0,nframes-1 do begin
        lat.slat = (*field.lats)[i]
        deflatdata,lat,data
        fminmax,*lat.data,fmin,fmax,file.missing_value
        if fmin lt lat.fmin then lat.fmin = fmin
        if fmax gt lat.fmax then lat.fmax = fmax
      endfor
      print,'animate_lats: calculated fmin,max=',lat.fmin,lat.fmax
    endif else $
      print,'animate_lats: using already set fmin,max=',lat.fmin,lat.fmax
   endif
;
; Load frames and run cw_animate:
;
    animate = cw_animate(animbase,wanim_xsize,wanim_ysize,nframes)
    add_animid,info,animate

    widget_control,animbase,/realize 
    for i=0,nframes-1 do begin
      lat.slat = (*field.lats)[i]
      deflatdata,lat,data
      *info.plat = lat
      window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
      windo = !d.window
      wset,windo
      pltlat,info,/animate
      cw_animate_load,animate,frame=i,window=windo,/track
;     print,'Animate lat slices in latitude (fixed ut): frame=',i,' out of ',$
;       nframes,' lat.fmin,max=',lat.fmin,lat.fmax
    endfor
    lat.fmin = savefmin & lat.fmax = savefmax
    lat.slat = savelat
    *info.plat = lat
    cw_animate_run,animate,nframes=nframes
  end
;
; Unknown animation type:
;
  else: print,'>>> animate_lats: unknown animation type func=',func
endcase
widget_control,hourglass=0
xmanager,"Map Animation",animbase,event_handler="anim_event"
;info = save_info
end

