;
pro custom_contour_event,event
widget_control,event.id,get_uvalue=widget
widget_control,event.top,get_uvalue=pcinfo
cinfo = *pcinfo
case widget of
  'CMIN': begin
    widget_control,event.id,get_value=cminstring
    cinfo.cmin = mkfloat(cminstring,cinfo.cmin,event.id)
    print,'Set contour minimum = ',cinfo.cmin
    *pcinfo = cinfo
  end
  'CMAX': begin
    widget_control,event.id,get_value=cmaxstring
    cinfo.cmax = mkfloat(cmaxstring,cinfo.cmax,event.id)
    print,'Set contour maximum = ',cinfo.cmax
    *pcinfo = cinfo
  end
  'CINT': begin
    widget_control,event.id,get_value=cintstring
    cinfo.cint = mkfloat(cintstring,cinfo.cint,event.id)
    print,'Set contour interval = ',cinfo.cint
    *pcinfo = cinfo
  end
  'RESET': begin
    cinfo.cmin=0. & cinfo.cmax=0. & cinfo.cint=0.
    cinfo.cancel = 0
    *pcinfo = cinfo
    widget_control,event.top,/destroy
  end
  'CLINECLR_WHITE': begin
    cinfo.clineclr = !d.table_size-1
    *pcinfo = cinfo
    print,'Set contour line color to white.'
  end
  'CLINECLR_BLACK': begin
    cinfo.clineclr = 0
    *pcinfo = cinfo
    print,'Set contour line color to black.'
  end
  'OK': begin
    widget_control,cinfo.wcmin,get_value=cminstring
    widget_control,cinfo.wcmax,get_value=cmaxstring
    widget_control,cinfo.wcint,get_value=cintstring
    cinfo.cmin = mkfloat(cminstring,cinfo.cmin,cinfo.wcmin)
    cinfo.cmax = mkfloat(cmaxstring,cinfo.cmax,cinfo.wcmax)
    cinfo.cint = mkfloat(cintstring,cinfo.cint,cinfo.wcint)
    cinfo.cancel = 0
    *pcinfo = cinfo
    widget_control,event.top,/destroy
  end
  'CANCEL': begin
    cinfo.cancel = 1
    *pcinfo = cinfo
    widget_control,event.top,/destroy
  end
  'HELP': begin
      xdisplayfile,"yaxislons.help",done_button='Done',title= $
        'Help for Custom Contouring',group=event.top,$
        modal=widget_info(event.top,/modal),width=90,height=50,text=[ $
      " ",$
      "Custom Contouring has three text entry options:",$
      " ",$
      "  1. Enter Contour Minimum: enter minimum value to be contoured.",$
      "     Contours will not be drawn for field values less than this minimum.",$
      " ",$
      "  2. Enter Contour Maximum: enter maximum value to be contoured.",$
      "     Contours will not be drawn for field values greater than this maximum.",$
      " ",$
      "  3. Enter Contour Interval: enter desired contour interval.",$
      " "," ",$
      "Buttons:"," ",$
      "  'OK':",$
      "     This button will apply your min,max,interval text entries, and close",$
      "     the custom contour window.",$
      " ",$   
      "  'CANCEL'",$
      "     This button will apply contouring that was set before the",$
      "     custom contour window was opened, and close the window.",$
      " ",$   
      "  'Reset to Range of field'",$
      "     This button will ignore your text entries, and reset contouring",$
      "     to the full range of the field for the current frame. It will choose",$
      "     an interval resulting in approximately 10 contour levels.",$
      "     (see also notes below).",$
      " ",$   
      "  There are 2 radio buttons which allow selection of black or white ",$
      "  contour lines.",$ 
      " "," ",$
      "Notes:"," ",$
      "  If the contour interval is <= 0., a value will be chosen that results in ",$
      "    approximately 10 contour levels."," ",$
      "  If minimum is >= maximum, or the button labeled 'Reset to Range of Field'",$
      "    is hit, then the full range of the field for the current frame will be used.",$
      " " ]
  end
  else: print,'>>> custom_contour_event: unknown widget ',widget
endcase
end
;-----------------------------------------------------------------------
pro custom_contour,parent,cmin_inout,cmax_inout,cint_inout,clineclr_inout
title = 'Custom Contour'
tlb = widget_base(column=1,title=title,group_leader=parent,/modal)
;
cmin = 0.
minbase = widget_base(tlb,column=1,/frame)
label = widget_label(minbase,value='Enter Contour Minimum')
wcmin = widget_text(minbase,/editable,value=string(cmin_inout),$
  uvalue='CMIN')
;
cmax = 0.
maxbase = widget_base(tlb,column=1,/frame)
label = widget_label(maxbase,value='Enter Contour Maximum')
wcmax = widget_text(maxbase,/editable,value=string(cmax_inout),$
  uvalue='CMAX')
;
cint = 0.
intbase = widget_base(tlb,column=1,/frame)
label = widget_label(intbase,value='Enter Contour Interval')
wcint = widget_text(intbase,/editable,value=string(cint_inout),$
  uvalue='CINT')
;
base = widget_base(tlb,column=1,/frame)
button = widget_button(base,value='Reset to Range of Field',uvalue='RESET')
;
clineclrbase1 = widget_base(tlb,column=1,/frame)
labe = widget_label(clineclrbase1,value='Contour Line Color')
clineclrbase2 = widget_base(clineclrbase1,column=2,/exclusive)
clineclr_white = widget_button(clineclrbase2,value='WHITE',$
  uvalue='CLINECLR_WHITE',/no_release)
clineclr_black = widget_button(clineclrbase2,value='BLACK',$
  uvalue='CLINECLR_BLACK',/no_release)
if clineclr_inout eq 0 then widget_control,clineclr_black,set_button=1 else $
  widget_control,clineclr_white,set_button=1
;
base = widget_base(tlb,column=3,/frame)
button = widget_button(base,value='OK',uvalue='OK')
button = widget_button(base,value='CANCEL',uvalue='CANCEL')
button = widget_button(base,value='HELP',uvalue='HELP')
;
; State info:
;
cinfo = {cinfo_struct, $
  cmin:cmin,           $ ; contour minimum
  cmax:cmax,           $ ; contour maximum
  cint:cint,           $ ; contour interval
  clineclr:clineclr_inout, $ index of contour line color
  wcmin:wcmin,         $ ; id of cmin text widget
  wcmax:wcmax,         $ ; id of cmax text widget
  wcint:wcint,         $ ; id of cint text widget
  cancel:0             $ ; if CANCEL button was hit, cancel=1
}
;
; Realize and turn over to wmanager:
;
pcinfo = ptr_new(cinfo)
widget_control,tlb,set_uvalue=pcinfo
widget_control,tlb,/realize
xmanager,'custom_contour',tlb,/no_block
;
cinfo = *pcinfo
if cinfo.cancel eq 0 then begin
  cmin_inout = cinfo.cmin
  cmax_inout = cinfo.cmax
  cint_inout = cinfo.cint
  clineclr_inout = cinfo.clineclr
; print,'Custom_contour returning cmin=',cmin_inout,' cmax=',cmax_inout,$
;   ' cint=',cint_inout
endif else begin
; print,'Custom_contour was canceled: no change to cmin,max,int=',$
;   cmin_inout,cmax_inout,cint_inout
endelse
end
