;
;------------------------------------------------------------------
;
function fslide_event,ev
child = widget_info(ev.handler,/child)
widget_control,child,get_uvalue=state
val = state.vec(ev.value)
widget_control,state.labelid,set_value=string(format=state.format,val)
if not ev.drag then $
  return,{ID:ev.handler, TOP:ev.top, HANDLER:0L, VALUE:val}
end
;
;------------------------------------------------------------------
;
function fslide_get_value,id
child = widget_info(id,/child)
widget_control,child,get_uvalue=state
widget_control,state.slideid,get_value=ix
val = state.vec(ix)
return,val
end
;
;------------------------------------------------------------------
;
pro fslide_set_value,id,val
child = widget_info(id,/child)
widget_control,child,get_uvalue=state
ival = -1
nvec = n_elements(state.vec)
del = state.vec(1)-state.vec(0)
for i=0,nvec-1 do begin
  if val ge state.vec(i)-.5*del and val le state.vec(i)+.5*del then ival=i
endfor
if ival lt 0 then begin
  print,'>>> cw_fslide set_value warning: val=',val,' not found in vec=' 
  print,state.vec
  ival = 0
endif
widget_control,state.slideid,set_value=ival
widget_control,state.labelid,set_value=string(format=state.format,val)
return
end
;
;------------------------------------------------------------------
;
function cw_fslide,parent,minimum=min,maximum=max,delta=del,title=title,$
  xsize=xsize,value=val,format=format,uvalue=uval
;
if n_elements(min) eq 0 then min = 0.
if n_elements(max) eq 0 then min = 100.
if n_elements(del) eq 0 then del = 5.
if n_elements(val) eq 0 then val = min
if not (keyword_set(title)) then title=""
if not (keyword_set(xsize)) then xsize=350
if not (keyword_set(format)) then format='(G13.6)'
if not (keyword_set(uval)) then uval = 0
nvec = fix((max-min)/del+1.5) ; .5 is for nearest int
vec = fltarr(nvec)
ival = -1
for i=0,nvec-1 do begin
  vec(i) = min+float(i)*del
  if val ge vec(i)-.5*del and val le vec(i)+.5*del then ival=i
endfor
if ival lt 0 then begin
  print,'>>> cw_fslide warning: val=',val,' not found in vec=' 
  print,vec
  ival = 0
endif
state = {slideid:0L, labelid:0L, vec:vec, format:format}
;
mainbase = widget_base(parent,/column,event_func='fslide_event',$
  func_get_value='fslide_get_value',pro_set_value='fslide_set_value',$
  uvalue=uval)
state.labelid = widget_label(mainbase,value=string(format=state.format,val))
state.slideid = widget_slider(mainbase,minimum=0,maximum=nvec-1,$
  /drag,xsize=xsize,/suppress_value,title=title,value=ival)
child = widget_info(mainbase,/child)
widget_control,child,set_uvalue=state,/no_copy
return,mainbase
end
