;
pro deflinedata,line,data
;
;  This routine finds the subset of the field data which will be plotted for 
;  three types of line plots, profile, meridional, and zonal.
;
;latmin = -30. & latmax = 30. ; lat limits for x-axis
;
; Define line.data(nlat,nlev) from processed var in data.
;
field = line.field
nlon = field.nlon & nlat = field.nlat & nlev = field.nlev
;print,' '
;print,'deflinedata: Field ',field.name,' nlat=',nlat,' nlev=',nlev
;print,'  slon=',lon.slon,' sslt=',lon.sslt,' ut=',lon.ut
;
; Check dimensions (return if field is only 2d lat x lon)
;
dims = size(data,/dimensions)
ndims = n_elements(dims)
error = 0
if (dims[0] ne field.nlon) then begin
  print,'>>> WARNING deflinedata: 1st dimension is not nlons: dims[0]=',$
    dims[0],' but nlon=',field.nlon
  error = 1 
endif
if (dims[1] ne field.nlat) then begin
  print,'>>> WARNING deflinedata: 2nd dimension is not nlats: dims[1]=',$
    dims[1],' but nlat=',field.nlat
  error = 1 
endif
if (dims[2] ne field.nlev) then begin
  print,'>>> WARNING deflinedata: 3rd dimension is not nlevs: dims[2]=',$
    dims[2],' but nlev=',field.nlev
  error = 1 
endif
if nlev le 0 then begin
  print,'>>> deflinedata: nlev=',nlev,' -- cannot make vertical slice.'
  error = 1 
endif
if error gt 0 then begin
; size = size(lon.data)
; londata = fltarr(size[1],size[2])
; londata[*,*] = float(lon.missing_value)
; lon.data = ptr_new(londata)
  heap_free,line.data
  return
endif
lons = *field.lons
lats = *field.lats
latindices = indgen(nlat)
;
; Use limited x-axis range, if requested by user:
;
;latmin = line.latmin & latmax = line.latmax
;if latmin gt lats[0] or latmax lt lats[nlat-1] then begin
;  nlatsnew = 0
;  for j=0,nlat-1 do begin
;    if lats[j] ge latmin and lats[j] le latmax then begin
;      nlatsnew = nlatsnew+1 
;     print,'deflinedata: j=',j,' latmin,max=',latmin,latmax,' lats[j]=',lats[j],$
;       ' nlatsnew=',nlatsnew
;    endif
;  endfor 
;  if nlatsnew le 2 then begin
;    print,'>>> WARNING deflinedata: latmin,max=',latmin,latmax,' nlatsnew=',$
;      nlatsnew
;    print,'    Cannot plot this latmin,max -- resorting to full latitude ',$
;      'grid..'
;    nlatsnew = nlat
;  endif else begin
;    newlats = fltarr(nlatsnew)
;    latindnew = intarr(nlatsnew)
;    jj = 0
;    for j=0,nlat-1 do begin
;      if lats[j] ge latmin and lats[j] le latmax then begin
;        newlats[jj] = lats[j]
;        latindnew[jj] = j
;        jj = jj+1
;      endif
;    endfor
;    lats = newlats
;    nlat = nlatsnew
;    latindices = latindnew
;   print,'deflinedata limit latitude x-axis: nlat=',nlat,' lats=' & print,lats
;   print,'latindices=' & print,latindices
;  endelse
;endif
;
fieldlevs = *field.levs
nfieldlevs = n_elements(fieldlevs)
;print,'deflinedata: nfieldlevs=',nfieldlevs,' fieldlevs=' & print,fieldlevs
;print,'deflinedata: line.levmin=',line.levmin,' line.levmax=',lon.levmax
;
; If axis limits levmin,max are set, reset levs accordingly:
;
;if line.levmin lt line.levmax then begin ; set axes limits levs:
; print,'deflinedata: line.levmin,max=',line.levmin,line.levmax
;  nlev = 0
;  for k=0,nfieldlevs-1 do $
;    if fieldlevs[k] ge line.levmin and fieldlevs[k] le line.levmax then nlev = nlev+1
;  if nlev lt 2 then print,'>>> WARNING pltline: nlev point for y-axis must be',$
;    ' at least 2: nlev=',nlev
;  levs = fltarr(nlev)
;  kk = 0
;  for k=0,nfieldlevs-1 do $
;    if fieldlevs[k] ge line.levmin and fieldlevs[k] le line.levmax then begin
;      levs[kk] = fieldlevs[k]
;      kk = kk+1
;    endif
;endif else levs = fieldlevs

levs = *line.levs
IF line.plottype EQ 'profile' THEN levs = fieldlevs

nlev = n_elements(levs)
;
;  Flip WACCM vertical coordinate
;
IF levs(nLev-1) GT 100.0 THEN BEGIN
  tempLevs = levs
  FOR iLev=0,nLev-1 DO BEGIN 

    newILev = nLev - iLev - 1
    levs(newILev) = tempLevs(iLev)

  ENDFOR

ENDIF

;line.levmin = levs[0]
;line.levmax = levs[nlev-1]
;
;print,'deflinedata: nfieldlevs=',nfieldlevs,' nlev=',nlev,' levs=' & print,levs
;
; Define array to hold data for this field and line plot type
;
;  Get profile data for this latitude/longitude
;
ilat = -1
ilon = -1
iLev = -1
;
;  Need to handle when line.slat is outside current latitude range
;
;sLat = line.slat
;IF sLat LT MIN(lats) THEN sLat = MIN(lats)
;IF sLat GT MAX(lats) THEN sLat = MAX(lats)
;print, 'line.slat, lats in deflinedata', line.slat, lats  
;
;  Find indices into field data for longitude, latitude, and vertical level
;
FOR iLt=0,nLat-1 DO BEGIN

  IF lats[iLt] LE line.slat+.01 AND lats[iLt] GE line.slat-.01 THEN BEGIN

    for i=0,nlon-1 do begin
      if lons[i] le line.slon+.01 and lons[i] ge line.slon-.01 then begin

        IF line.slev LE line.levmin THEN line.slev = levs[0]
        IF line.slev GE line.levmax THEN line.slev = levs[nLev-1]
 
        FOR iLv = 0, nLev - 1 DO BEGIN

          IF levs[iLv] LE line.slev+.01 AND levs[iLv] GE line.slev-.01 THEN BEGIN

              ilon = i 
              iLat = iLt
              iLev = iLv
              goto,found
           
          ENDIF

        ENDFOR

      endif
    endfor

  ENDIF

ENDFOR
found:
;
;  Form subset data array
;
linedata = fltarr(nlev)
linedata[*] = 0.
;
;  Check to make sure data indices found for longitude, latitude, and level
;
if (ilat lt 0) then begin
  print,'>>> deflinedata: cannot find latitude ',line.slat,': nlat=',nlat,$
    ' ilat=',ilat,' lats=' & print,lats
  line.data = ptr_new(linedata)
  return
endif

if (ilon lt 0) then begin
  print,'>>> deflinedata: cannot find longitude ',line.slon,': nlon=',nlon,$
    ' ilon=',ilon,' lons=' & print,lons
  line.data = ptr_new(linedata)
  return
endif

if (iLev lt 0) then begin
  print,'>>> deflinedata: cannot find level ',line.slev,': nlev=',nlev,$
    ' ilev=',ilev,' levs=' & print,levs
  line.data = ptr_new(linedata)
  return
endif
;
;  Set latitude, longitude, and level indices for subsetting input data 
;
line.ilat = ilat
line.ilon = ilon
line.ilev = ilev
line.lats = ptr_new(lats)
line.lons = ptr_new(lons)
;line.levs = ptr_new(levs)
;
;  Based on line plot type vertical profile(data/lev), meridional(lon/data), and zonal(lat/data), 
;  get 2-D subset data for line plot
;
CASE line.plottype OF

  'profile': BEGIN

     defprofdata,line,data,linedata

  END

  'meridional': BEGIN

     defmeriddata,line,data,linedata

  END

  'zonal': BEGIN

     defzonaldata,line,data,linedata

  END

  ELSE: PRINT,'>>> deflinedata: unknown plot type ',line.plottype

ENDCASE ; plot type
;
; Update line structure geolocation variables:
;
line.lats = ptr_new(lats)
line.lons = ptr_new(lons)
;line.levs = ptr_new(levs)

end
