;
pro fileinfo_event,event
widget_control,event.id,get_uvalue=widget
case widget of
  'CLOSE': begin
    widget_control,event.top,/destroy
  end
  else: print,'>>> fileinfo_event: unknown widget ',widget
endcase
end
;-----------------------------------------------------------------------
pro fileinfo,info
;
; Create scrollable text widget in new top level base
; to display ncdump:
;
if (strlen(strcompress(info.file,/remove_all)) le 0) then begin
  print,'>>> fileinfo: no file!'
  return
endif
tlb = widget_base(column=1,mbar=mbar,title=info.file)
info.finfo_id = tlb 
;
; Do ncdump and display result in scrollable text widget: 
command = 'ncdump -c '+info.file
spawn,command,result
textwidget = widget_text(tlb,xsize=80,ysize=40,/scroll,$
  value=result)
;
; Close button:
button = widget_button(tlb,value='Close',uvalue='CLOSE')
;
; Realize and start xmanager:
widget_control,tlb,/realize
xmanager,'fileinfo',tlb,/no_block
end
