function get_time_mod,minutes
;this function returns an array giving the model times 
;written by Tom Freestone 9/17/03

dims=size(minutes)
if dims[0] eq 0 then dims=1
if dims[0] eq 2 then dims=dims[2]

if dims gt 1 then begin
  mtime=findgen(3,dims)
  for i=0,dims-1 do begin
    if minutes[i] ge 24.*60. then begin
      mtime[0,i]=minutes[i]/24./60.
      minutes[i]=minutes[i]-mtime[0,i]*24.*60.
    endif
    if minutes[i] ge 60. then begin
      mtime[1,i]=minutes[i]/60.
      minutes[i]=minutes[i]-mtime[1,i]*60.
    endif
    mtime[2,i]=minutes[i]
  endfor
endif else begin
  mtime=findgen(3)
  mtime=mtime*0.
  if minutes ge 24.*60. then begin
    mtime[0]=fix(minutes/24/60)
    minutes=minutes-mtime[0]*24.*60.
  endif
  if minutes ge 60. then begin
    mtime[1]=fix(minutes/60)
    minutes=minutes-mtime[1]*60.
  endif
  mtime[2]=minutes
endelse

return,mtime
end

