;
;-------------------------------------------------------------------
;
function getglb,ixf,szp
@global.h
@tgcmidl.h
;
; Determine if array returned in previous frame can be used for
; current frame:
;
case ixf of
  ixu: begin
    if chnge_mapun le 0 then begin
      glb = mapun_prev
      print,'  (using un from previous definition)'
      return,glb
    endif
  end
  ixv: begin
    if chnge_mapvn le 0 then begin
      glb = mapvn_prev
      print,'  (using vn from previous definition)'
      return,glb
    endif
  end
  ixui: begin
    if chnge_mapui le 0 then begin
      glb = mapui_prev
      print,'  (using ui from previous definition)'
      return,glb
    endif
  end
  ixvi: begin
    if chnge_mapvi le 0 then begin
      glb = mapvi_prev
      print,'  (using vi from previous definition)'
      return,glb
    endif
  end
  else: begin
    if chnge_map le 0 then begin
      glb = map_prev
      print,'  (using global field ',flab(ixf),' from previous definition)'
      return,glb
    endif
  end
endcase
;
; Return msis or hwm field:
;
if ihwm93 gt 0 then begin
  glb = getglb_hwm93(ixf,szp)
  goto,done
endif
if ims90 gt 0 then begin
  glb = getglb_ms90(ixf,szp)
  goto,done
endif
;
; Return iri:
;
if iiri gt 0 then begin
  glb = getglb_iri(ixf,szp)
  goto,done
endif
glb = fltarr(!imx,!jmx)
;
; Define global array at selected pressure or height:
;
if (ixf lt nfcdf) then begin ; field is on history
  if (map.iht le 0) then begin ; at selected pressure
    ixzp = ixfind(gcmzp,!kmx,szp,!dzp)
    if (ixzp lt 0) then begin
      print,'>>> getglb: bad szp? szp=',szp
      glb = 0.
      goto,done
    endif
    glb(*,*) = pnt(*,ixzp,*,ixf)
  endif else begin ; interpolate to selected height
    print,format="('Interpolating field ',a,' globally to ',f5.1,' km')",$
      flab(ixf),map.ht
    print,'This can take about 25 secs, so please be patient ...'
    ier = 0
    glbhtint, pnt,ixf,ixz,glb,map.ht,map.log10,spval,ier,0
  endelse
endif else begin ; derived field
  if (ixf eq ixrho) then begin ; total density
    if (map.iht le 0) then begin ; at selected pressure
      ixzp = ixfind(gcmzp,!kmx,szp,!dzp)
      if (ixzp lt 0) then begin
        print,'>>> getglb: bad szp? szp=',szp
        glb = 0.
        goto,done
      endif
      glb(*,*) = pnt(*,ixzp,*,ixo2)+pnt(*,ixzp,*,ixo1)+$
                    pnt(*,ixzp,*,ixn2)
    endif else begin ; interpolate to selected height
      glbo1 = fltarr(!imx,!jmx) & glbn2 = fltarr(!imx,!jmx)
      print,format="('Interpolating densities for rho to ',f5.1,' km ...')",$
        map.ht
      print,'This can take forever, so please be patient ...'
      glbhtint, pnt,ixo2,ixz,glb,map.ht,map.log10,spval,ier,0
      print,'  Completed interpolation of o2...'
      glbhtint, pnt,ixo1,ixz,glbo1,map.ht,map.log10,spval,ier,0
      print,'  Completed interpolation of o1...'
      glbhtint, pnt,ixn2,ixz,glbn2,map.ht,map.log10,spval,ier,0
      print,'  Completed interpolation of n2...'
      glb(*,*) = glb(*,*) + glbo1(*,*) + glbn2(*,*)
    endelse
  endif else begin
    print,'>>> getglb: unknown field=',flab(ixf)
    glb = 0.
    goto,done
  endelse
endelse
if (map.log10 gt 0) then log10f, glb,!imx*!jmx,rlogmin,spval
done:
case ixf of
  ixu: begin
    mapun_prev = glb
    chnge_mapun = 0
  end
  ixv: begin
    mapvn_prev = glb
    chnge_mapvn = 0
  end
  ixui: begin
    mapui_prev = glb
    chnge_mapui = 0
  end
  ixvi: begin
    mapvi_prev = glb
    chnge_mapvi = 0
  end
  else: begin
    map_prev = glb
    chnge_map = 0
  end
endcase
return,glb
end
;
;-------------------------------------------------------------------
