;------------------------------------------------------------------
function glbmean, glb,nlon,nlat,glat,spval
;
; Find global mean of glb(nlon,nlat) weighted by cos(lat):
; (modified 12/14/93, with help from Cicely)
;
nval = n_elements(glb)
cs = fltarr(nlat)
dtheta = !pi/float(nlat)
for j=0,nlat-1 do cs(j) = cos(-!pi/2.+(float(j)-.5)*dtheta)
fglbm = 0.
wt = 0.
;
; Global weighted average:
;
for j=0,nlat-1 do begin
  sum = 0.
  for i=0,nlon-1 do begin
    sum = sum + glb(i,j)
  endfor
  fglbm = fglbm + sum*cs(j)
  wt = wt + cs(j)
endfor
fglbm = fglbm / (float(nlon)*wt)
;
return,fglbm
end
;------------------------------------------------------------------
