;------------------------------------------------------------------
pro labutx, utvert,position,charsize=charsize
;this procedure produces a second slt for the pltutvert
;it calls change_xaxis.pro to get the string for the 
;correct axis labels and change_time_units.pro for the units label
;written by Tom Freestone 9/3/03
;
if keyword_set(charsize) then begin
  chrsize = charsize
endif else begin
  chrsize =0.
endelse
yoff = .1 & ticlen = .014 & ynumoff = .03
xll=position(0) & yll=position(1) & xur=position(2) & yur=position(3)
mtime=utvert.mtime
ntms=size(utvert.mtime)
ntms=ntms[2]
slon=utvert.slon
xposday=[mtime[0,0]+mtime[1,0]/24.+mtime[2,0]/(24.*60.), $
  mtime[0,ntms-1]+mtime[1,ntms-1]/24.+mtime[2,ntms-1]/(24.*60)]
yposax = yll-yoff
plots,[xll,xur],[yposax,yposax],/norm
;
; Convert to decimal slt (including model day):
;
slt=change_xaxis(utvert,'slt')
units=change_time_units(utvert)
xlab = 'LOCAL TIME ('+units+')' 

;
; Loop on labeled intervals:
;
ypos = yll-yoff-ynumoff
num_slt=n_elements(slt)
for i=0,num_slt-1 do begin
  xpos = xll + (xur-xll)/(num_slt-1)*i
  plots,[xpos,xpos],[yposax,yposax+ticlen],/norm
  xyouts,xpos,ypos,slt[i],charsize=chsize,/norm,align=.5
  if i lt num_slt-1 then begin
    for t=0,3 do begin
      x2 = (xur-xll)/(num_slt-1)*t/3
      xmnr = xpos+x2
      plots,[xmnr,xmnr],[yposax,yposax+.5*ticlen],/norm 
    endfor
  endif
endfor
xyouts,.5*(xll+xur),yll-yoff-2.2*ynumoff,xlab,charsize=chsize,align=.5,/norm

return
end
