;---------------------------------------------------------------------- -
pro new_draw_window,info,projection
check_map = *info.pmap
if projection ne 'Cylindrical Equidistant' then begin
  xsize=500 & ysize=500
endif else begin
  xsize=500 & ysize=400
endelse
maps,info,xsize=xsize,ysize=ysize,projection=projection,check_map=check_map
end
;-----------------------------------------------------------------------
pro anim_event,event
;
; Event handler for animation window:
;
case event.action of
  "DONE": begin
    widget_control,event.top,/destroy
    return
  end
  else: print,'anim_event: Unknown action: ',event.action
endcase
return
end
;-----------------------------------------------------------------------
pro pltmaps,info,animate=animate,ps=ps
;
map = *info.pmap
vector=map.vector
fields = *info.fields
widget_control,map.draw,bad_id=id_check
if not keyword_set(animate) and not keyword_set(ps) then begin
  widget_control,map.draw,get_value=index
  wset,index
  erase
endif
if vector.control ne 'only' then begin
  if map.setcontour eq 'off' then begin
    cmin=0. & cmax=0. & cint=0.
;   print,'Maps: reset contour min,max to full range.'
    defmapdata,map,*fields[map.ifield].data,map.izvert,map.imtime
    fminmax,*map.data,fmin,fmax,map.missing_value
    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
    map.fmin=cmin & map.fmax=cmax & map.cint=cint
    *map.clevels = levels
    *info.pmap = map
  endif
endif
;
; Call appropriate procedure for current projection:
;
index=map.ifield
data = *fields[index].data
case map.projection of
  "Cylindrical Equidistant": begin
    if map.setcontour ne 'only' then begin
      defmapdata,map,data,map.izvert,map.imtime
    endif
    *info.pmap = map
    pltce,info,animate=animate
  end
  "Polar Stereographic": begin
    if map.setcontour ne 'only' then begin
      defmapdata,map,data,map.izvert,map.imtime
    endif
    *info.pmap = map
    pltst,info,animate=animate,ps=ps
  end
;added by Tom Freestone 6/9/03 for Satellite View
  "Satellite Projection": begin
    if map.setcontour ne 'only' then begin
      defmapdata,map,data,map.izvert,map.imtime
    endif
    *info.pmap = map
    pltsv,info,animate=animate
  end
  default: print,'>>> WARNING pltmaps: unknown projection ',map.proj
endcase

end
;-----------------------------------------------------------------------
pro mtime_map_event,event
;
; Respond to user selection of a model time:
;
widget_control,event.top,get_uvalue=pinfo
widget_control,event.id,get_uvalue=mtime_request
info = *pinfo
fields = *info.fields
map = *info.pmap
file = *info.pfile
imtime = -1
for i=0,file.ntimes-1 do begin
  mtime_string = $
    strcompress(string(file.mtimes[0,i]),/remove_all)+','+ $
    strcompress(string(file.mtimes[1,i]),/remove_all)+','+ $
    strcompress(string(file.mtimes[2,i]),/remove_all)
  if mtime_string eq mtime_request then begin
    imtime = i
    goto, found
  endif
endfor
print,'>>> WARNING mtime_map_event: could not find index to model time ',$
  mtime_request
return
found:
map.imtime = imtime
map.mtime = file.mtimes[*,imtime]
;data = *fields[map.ifield].data
*info.pmap = map
pltmaps,info
end
;-----------------------------------------------------------------------
pro mkproj,map,info,tlb

;created by Tom Freestone 6/11/03 to improve the base that controls the coordinates
;of the plots in the case below:cylindrical equidistant,polar,satellite

fields=map.field
;levs pertains to the altitude relative to pressure
nlevs=fields[0].nlev
if(nlevs ne 0) then begin
  levbase = widget_base(map.projbase)
  levs = *fields[0].levs
endif
;while loop destroys the bases to make room for new ones
child =1
while(child ne 0) do begin
  child=widget_info(map.projbase, /child)
  if(child ne 0) then begin
    widget_control,child,/destroy
  endif
endwhile
case map.projection of 
'Cylindrical Equidistant': begin
	if fields.grid_type eq 'geographic' then begin
          title = 'SLT(HRS) CENTER X-AXIS'
        endif else begin
          title = 'MLT(HRS) CENTER X-AXIS'
        endelse 
	;slt slider
         sltbase = widget_base(map.projbase)
	 levslt=findgen(25)
	 nlevslt=size(levslt,/n_elements)
  	 zvert = map.zvert ; default bottom boundary
  	 dzvert = levslt[1]-levslt[0]
	 sltslider = cw_fslide(sltbase,minimum=levslt[0],maximum=levslt[nlevslt-1],$
    	   delta=dzvert,xsize=200,format="(f5.2)",value=map.censlt,$
    	   title=title,uvalue='SELECT_SLT')

	;longitude slider
	lonbase = widget_base(map.projbase)
	levlon=indgen(76)*5-185
	nlevlon=size(levlon,/n_elements)
  	zvert = map.zvert ; default bottom boundary
  	dzvert = levlon[1]-levlon[0]
	lonslider = cw_fslide(lonbase,minimum=levlon[1],maximum=levlon[nlevlon-3],$
    	  delta=dzvert,xsize=200,format="(f6.0)",value=map.cenlon,$
    	  title='LON(DEG) CENTER X-AXIS',uvalue='SELECT_LON')
	
	  if(map.fixpolar eq 'SLT') then begin
                widget_control, lonslider,/destroy 
	  endif
 	  if(map.fixpolar eq 'LON') then begin
	        widget_control, sltslider,/destroy 
          endif
	; Select perimeter latitude for stereographic via cw slider:
	lats = *fields[0].lats
	nlat = n_elements(lats)
	dlat = lats[1]-lats[0]

	;
	; Polar dial is either slt or lon:
	;

;	fixpolarbase = widget_base(map.projbase,/exclusive, $
;         units=0,frame=3,sensitive=1)
; old way that gave the warning
;	fixpolarbase = widget_base(map.projbase,/frame,/exclusive,sensitive=1)
	fixpolarbase = widget_base(map.projbase,/exclusive,sensitive=1)

	fixpolarslt = widget_button(fixpolarbase,value='SLT',$
	  uvalue='FIXPOLAR_SLT',/no_release)
	fixpolarlon = widget_button(fixpolarbase,value='LON',$
	  uvalue='FIXPOLAR_LON',/no_release)
	 ;controls sensitivity of the slt and lon sliders 
	 ;controls sensitivity of the slt and lon sliders 
 	  if(map.fixpolar eq 'LON') then begin
	        widget_control,fixpolarlon, /set_button
          endif
	  if(map.fixpolar eq 'SLT') then begin
	        widget_control,fixpolarslt, /set_button
	  endif
	if(nlevs ne 0) then begin
	  ;pressure slider
	  levbase = widget_base(map.projbase)
;
;  WACCM uses map structure level values and TIME-GCM uses field structure level values for level slider
;
          IF info.ftype eq 'WACCM' THEN BEGIN 

  	    zvert = map.zvert ; default bottom boundary
  	    levsW = map.levs
	    nLevsW = N_ELEMENTS(levsW)
	    dzvert = levsW[1] - levsW[0]

  	    levslider = cw_fslide(levbase,minimum=levsW[0],maximum=levsW[nLevsW-1],$
    	      delta=dzvert,xsize=200,format="(f6.2)",value=map.zvert,$
    	      title=' Log Pressure Level ',uvalue='SELECT_LEV')

          ENDIF ELSE BEGIN 

  	    zvert = map.zvert ; default bottom boundary
  	    dzvert = levs[1]-levs[0]

  	    levslider = cw_fslide(levbase,minimum=levs[0],maximum=levs[nlevs-1],$
    	      delta=dzvert,xsize=200,format="(f6.2)",value=map.zvert,$
    	      title=fields[0].levname+' ('+fields[0].levunits+')',uvalue='SELECT_LEV')
           
          ENDELSE

	endif
      end
'Polar Stereographic': begin
	if(nlevs ne 0) then begin

	  levbase = widget_base(map.projbase)
;
;  WACCM uses level index and TIME-GCM uses level value for level slider
;
          IF info.ftype eq 'WACCM' THEN BEGIN 

  	    zvert = map.zvert ; default bottom boundary
  	    levsW = map.levs
	    nLevsW = N_ELEMENTS(levsW)
	    dzvert = levsW[1] - levsW[0]

  	    levslider = cw_fslide(levbase,minimum=levsW[0],maximum=levsW[nLevsW-1],$
    	      delta=dzvert,xsize=200,format="(f6.2)",value=map.zvert,$
    	      title=' Log Pressure Level ',uvalue='SELECT_LEV')

          ENDIF ELSE BEGIN 

  	    zvert = map.zvert ; default bottom boundary
  	    dzvert = levs[1]-levs[0]
   	    levslider = cw_fslide(levbase,minimum=levs[0],maximum=levs[nlevs-1],$
    	      delta=dzvert,xsize=200,format="(f6.2)",value=map.zvert,$
      	      title=fields[0].levname+' ('+fields[0].levunits+')',uvalue='SELECT_LEV')
           
          ENDELSE

        endif

	stperim = map.stperim
	; Select perimeter latitude for stereographic via cw slider:
	lats = *fields[0].lats
	nlat = n_elements(lats)
	dlat = lats[1]-lats[0]
	;
	; Polar dial is either slt or lon:
	;
	fixpolarbase = widget_base(map.projbase,/frame,/exclusive,sensitive=1)
	fixpolarslt = widget_button(fixpolarbase,value='SLT',$
	  uvalue='POLAR_SLT',/no_release)
	fixpolarlon = widget_button(fixpolarbase,value='LON',$
	  uvalue='POLAR_LON',/no_release)
	  
	  if(map.fixpolar eq 'SLT') then begin
	        widget_control,fixpolarslt, /set_button
	  endif
 	  if(map.fixpolar eq 'LON') then begin
	        widget_control,fixpolarlon, /set_button
          endif

	perimbase = widget_base(map.projbase)
	wfsl_perimlat = cw_fslide(perimbase,minimum=lats[1],maximum=lats[nlat-2],$
	  delta=dlat,xsize=200,uvalue="PERIMLAT",format='(f5.1)',value=stperim,$
	  title='Perimeter Latitude')
  end
'Satellite Projection': begin
	;slt slider
	sltbase = widget_base(map.projbase)
	levslt=indgen(25)
	nlevslt=size(levslt,/n_elements)
  	zvert = map.zvert ; default bottom boundary
  	dzvert = levslt[1]-levslt[0]
	if fields.grid_type eq 'geographic' then begin
          title = 'SLT(HRS) CENTER X-AXIS'
        endif else begin
          title = 'MLT(HRS) CENTER X-AXIS'
        endelse 
        sltslider = cw_fslide(sltbase,minimum=levslt[0],maximum=levslt[nlevslt-1],$
    	  delta=dzvert,xsize=200,format="(i3)",value=map.censlt,$
    	  title=title,uvalue='SELECT_SLT')

	if(nlevs ne 0) then begin
	  ;pressure slider
	  levbase = widget_base(map.projbase)
;
;  WACCM uses level index and TIME-GCM uses level value for level slider
;
          IF info.ftype eq 'WACCM' THEN BEGIN 

  	    zvert = map.zvert ; default bottom boundary
  	    levsW = map.levs
	    nLevsW = N_ELEMENTS(levsW)
	    dzvert = levsW[1] - levsW[0]

  	    levslider = cw_fslide(levbase,minimum=levsW[0],maximum=levsW[nLevsW-1],$
    	      delta=dzvert,xsize=200,format="(f6.2)",value=map.zvert,$
    	      title=' Log Pressure Level ',uvalue='SELECT_LEV')

          ENDIF ELSE BEGIN 

   	    zvert = map.zvert ; default bottom boundary
  	    dzvert = levs[1]-levs[0]
  	    levslider = cw_fslide(levbase,minimum=levs[0],maximum=levs[nlevs-1],$
    	      delta=dzvert,xsize=200,format="(f6.2)",value=map.zvert,$
    	      title=fields[0].levname+' ('+fields[0].levunits+')',uvalue='SELECT_LEV')
           
          ENDELSE

        endif

	;longitude slider
	lonbase = widget_base(map.projbase)
	levlon=indgen(76)*5-185
	nlevlon=size(levlon,/n_elements)
  	zvert = map.zvert ; default bottom boundary
  	dzvert = levlon[1]-levlon[0]
	lonslider = cw_fslide(lonbase,minimum=levlon[1],maximum=levlon[nlevlon-3],$
    		delta=dzvert,xsize=200,format="(f6.0)",value=map.cenlon,$
    		title='LON(DEG) CENTER X-AXIS',uvalue='SELECT_LON')
	
	; Select perimeter latitude for stereographic via cw slider:
	lats = *fields[0].lats
	nlat = n_elements(lats)
	dlat = lats[1]-lats[0]
	 
	 ;latitude slider
	levlat=findgen(180)-90.0
	nlevlat=size(levlat,/n_elements)
	perimbase = widget_base(map.projbase)
	wfsl_perimlat = cw_fslide(perimbase,minimum=levlat[0],maximum=levlat[179],$
	  xsize=200,uvalue="SELECT_LAT",format='(f5.1)',value=map.cenlat,$
	  title='Center Latitude')
	widget_control,perimbase,sensitive=1
	
	;
	; Polar dial is either slt or lon:
	;
	fixpolarbase = widget_base(map.projbase,/frame,/exclusive,sensitive=1)
	fixpolarslt = widget_button(fixpolarbase,value='SLT',$
	  uvalue='FIXPOLAR_SLT',/no_release)
	fixpolarlon = widget_button(fixpolarbase,value='LON',$
	  uvalue='FIXPOLAR_LON',/no_release)
	polbase_GEO=widget_info(fixpolarbase,/geometry)  
	erad_xsize=polbase_GEO.xsize+polbase_GEO.xpad
	
	 ;controls sensitivity of the slt and lon sliders 
	  if(map.fixpolar eq 'SLT') then begin
	        widget_control,fixpolarslt, /set_button
		widget_control, lonslider, sensitive=0
	  endif
 	  if(map.fixpolar eq 'LON') then begin
		widget_control, sltslider, sensitive=0
	        widget_control,fixpolarlon, /set_button
          endif

	;earth radius slider
	eradbase = widget_base(map.projbase)
	levera=indgen(10)+1*2
	nlevera=size(levera,/n_elements)
  	zvert = map.zvert ; default bottom boundary
  	dzvert = levera[1]-levera[0]
	eraslider = cw_fslide(eradbase,minimum=levera[0],maximum=levera[nlevera-1],$
    		delta=dzvert,format="(i3)",value=map.erad,$
    		title='Distance',uvalue='SELECT_ERA',xsize=erad_xsize)
  end
else: print, '>>> Unknown plot type: ', proj 
endcase
end
;-----------------------------------------------------------------------
pro maps_event,event
widget_control,event.id,get_uvalue=widget
widget_control,event.top,get_uvalue=pinfo
info = *pinfo
fields = *info.fields
map = *info.pmap
vector = map.vector
field = map.field
data = *fields[map.ifield].data
case widget of
  'CLOSE': begin
    widget_control,event.top,/destroy
  end
  'SELECT_LEV': begin
    nlevs = field.nlev
;
;  WACCM uses level index and TIME-GCM uses level value to find request level
;
    IF info.ftype eq 'WACCM' THEN BEGIN

      nlevs = N_ELEMENTS(map.levs)
      levs = map.levs
      izvert = -1
      for k=0,nlevs-1 do begin
        if (levs[k] eq event.value) then begin
          izvert = k
        endif
      endfor
      if (izvert eq -1) then begin
        print,'>>> WARNING map_event: cannot find index to level ',$
          event.value
        ;print,'    levs = ',levs
      endif
      map.zvert = levs[izvert]
      map.izvert = izvert

    ENDIF ELSE BEGIN

      if (nlevs gt 1) then begin
        levs = *field.levs
        izvert = -1
        for k=0,nlevs-1 do begin
          if (levs[k] eq event.value) then begin
            izvert = k
          endif
        endfor
        if (izvert eq -1) then begin
          print,'>>> WARNING map_event: cannot find index to level ',$
            event.value
          ;print,'    levs = ',levs
        endif
        map.zvert = levs[izvert]
        map.izvert = izvert
      endif

    ENDELSE
;
; Reset min,max and contour interval:
;    cmin=0. & cmax=0. & cint=0.
;    defmapdata,map,*fields[map.ifield].data,map.izvert,map.imtime
;    fminmax,*map.data,fmin,fmax,map.missing_value
;    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
;    map.fmin=cmin & map.fmax=cmax & map.cint=cint
;    *map.clevels = levels
; Update state and make map:
    *info.pmap = map
    pltmaps,info
  end
  ;SELECT_LAT,LON,ERA,SLT redraw the plot with the new parameters
  'SELECT_LON': begin
    map.cenlon=event.value
    *info.pmap=map
    pltmaps,info
  end
  'SELECT_LAT': begin
    map.cenlat=event.value
    *info.pmap=map
    pltmaps,info
  end
  'SELECT_ERA': begin
    map.erad=event.value
    *info.pmap=map
    pltmaps,info
  end
  'SELECT_SLT': begin
    map.censlt=event.value
    *info.pmap = map
    pltmaps,info
  end
  ;FIXPOLAR_SLT,LON redraw the widgets and plot
  'FIXPOLAR_SLT': begin
    map.fixpolar='SLT'
    *info.pmap=map
    mkproj,map,info,0
    pltmaps,info
  end
  'FIXPOLAR_LON': begin
    map.fixpolar='LON'
    *info.pmap=map
    mkproj,map,info,0
    pltmaps,info
  end
  'PERIMLAT': begin
; Reset min,max and contour interval:
;    cmin=0. & cmax=0. & cint=0.
;    defmapdata,map,*fields[map.ifield].data,map.izvert,map.imtime
;    fminmax,*map.data,fmin,fmax,map.missing_value
;    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
;    map.fmin=cmin & map.fmax=cmax & map.cint=cint
;    *map.clevels = levels
; Update state and make map:
    map.stperim=event.value
    *info.pmap = map
    pltmaps,info
  end
;modified by Tom Freestone on 6/10/03 to create new widget button heiarchy
  'CE': begin ; cylindrical equidistant projection
    map.projection = 'Cylindrical Equidistant'
    *info.pmap = map
    widget_control,event.top,/destroy
    ;pltmaps,info
    new_draw_window,info,map.projection
  end
  'ST': begin ; polar stereographic projection
    map.projection = 'Polar Stereographic'
    *info.pmap = map
    widget_control,event.top,/destroy
    ;pltmaps,info
    new_draw_window,info,map.projection
  end
;added by Tom Freestone 6/9/03 for Satellite View
  'SV': begin ; satellite projection
    map.projection = 'Satellite Projection'
    ;mkproj,map,info,tlb
    map.grid=1
    map.grid_color=0
    map.continents=1
    *info.pmap = map
    widget_control,event.top,/destroy
    ;pltmaps,info
    new_draw_window,info,map.projection
  end
  'COLOR': begin
;   xloadct,group=event.top,/modal
    clrtab = xcolor(info.colortab,event.top)
    info.colortab = clrtab
    *pinfo = info
    pltmaps,info
  end
  'CONTINENTS_WHITE': begin
    map.continents = 1
    map.continents_color = !d.table_size-1
    *info.pmap = map
    pltmaps,info
  end
  'CONTINENTS_BLACK': begin
    map.continents = 1
    map.continents_color = 0
    *info.pmap = map
    pltmaps,info
  end
  'CONTINENTS_OFF': begin
    map.continents = 0
    *info.pmap = map
    pltmaps,info
  end
  'MAPGRID_WHITE': begin
    map.grid = 1
    map.grid_color = !d.table_size-1
    *info.pmap = map
    pltmaps,info
  end
  'MAPGRID_BLACK': begin
    map.grid = 1
    map.grid_color = 0
    *info.pmap = map
    pltmaps,info
  end
  'MAPGRID_OFF': begin
    map.grid = 0
    *info.pmap = map
    pltmaps,info
  end
  'SET_MINMAX': begin
   ; umin=map.fmin & umax=map.fmax
   ; setminmax,info,umin,umax
   ; map.fmin = umin & map.fmax = umax
   ; *info.pmap = map
   ; pltmaps,info
   map.setcontour='on'
   umin=map.fmin & umax=map.fmax
   setminmax,info,umin,umax
   map.fmin = umin & map.fmax = umax
   *info.pmap = map
   pltmaps,info
  end
  'RESET_MINMAX': begin
    ;map.fmin=0. & map.fmax=0.
    ;print,'Maps: reset image min,max to full range.'
    ;*info.pmap = map
    ;pltmaps,info
    map.setcontour='off'
    map.fmin=0. & map.fmax=0.
    print,'Maps: reset image min,max to full range.'
    *info.pmap = map
    pltmaps,info
  end
  'LOG10': begin
    map.log10 = 'density fields'
    data = *fields[map.ifield].data
    defmapdata,map,data,map.izvert,map.imtime
;
; Reset min,max and contour interval:
    fminmax,*map.data,fmin,fmax,map.missing_value
    cmin=0. & cmax=0. & cint=0.
    *map.clevels = mkclevels(fmin,fmax,cmin,cmax,cint)
    map.fmin=cmin & map.fmax=cmax & map.cint=cint
    *info.pmap = map
    print,'Will plot log10 of density fields'
    pltmaps,info
  end
  'LOG10_ALLFIELDS': begin
    map.log10 = 'all fields'
    data = *fields[map.ifield].data
    defmapdata,map,data,map.izvert,map.imtime
;
; Reset min,max and contour interval:
    fminmax,*map.data,fmin,fmax,map.missing_value
    cmin=0. & cmax=0. & cint=0.
    *map.clevels = mkclevels(fmin,fmax,cmin,cmax,cint)
    map.fmin=cmin & map.fmax=cmax & map.cint=cint
    *info.pmap = map
    print,'Will plot log10 of all fields'
    pltmaps,info
  end
  'LINEAR': begin
    map.log10 = 'none'
    data = *fields[map.ifield].data
    defmapdata,map,data,map.izvert,map.imtime
;
; Reset min,max and contour interval:
    fminmax,*map.data,fmin,fmax,map.missing_value
    cmin=0. & cmax=0. & cint=0.
    *map.clevels = mkclevels(fmin,fmax,cmin,cmax,cint)
    map.fmin=cmin & map.fmax=cmax & map.cint=cint
    *info.pmap = map
    print,'Will plot linear fields (no log10)'
    pltmaps,info
  end
  'CUSTOM_CONTOUR': begin
    map.setcontour='on'
    cmin=map.fmin & cmax=map.fmax & cint=map.cint & clineclr=map.clineclr
    custom_contour,info.tlb,cmin,cmax,cint,clineclr
    map.clineclr = clineclr
    defmapdata,map,*fields[map.ifield].data,map.izvert,map.imtime
    fminmax,*map.data,fmin,fmax,map.missing_value
    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
    map.fmin=cmin & map.fmax=cmax & map.cint=cint
    *map.clevels = levels
    *info.pmap = map
    pltmaps,info
  end
  'RESET_CONTOUR': begin
    map.setcontour='off'
    cmin=0. & cmax=0. & cint=0.
;   print,'Maps: reset contour min,max to full range.'
    defmapdata,map,*fields[map.ifield].data,map.izvert,map.imtime
    fminmax,*map.data,fmin,fmax,map.missing_value
    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
    map.fmin=cmin & map.fmax=cmax & map.cint=cint
    *map.clevels = levels
    *info.pmap = map
    pltmaps,info
  end
  'ANIM_TIME': begin
    vector.vecanimate='on'
    map.vector=vector
    *info.pmap = map
    if field.ntime eq 1 then begin
      print,' '
      print,'>>> Cannot animate in time: there is only one time on the file!'
      widget_control,event.id,sensitive=0
    endif else begin
      widget_control,event.id,/sensitive
      animate_maps,info,map,'time'
    endelse
    vector.vecanimate='off'
    map.vector=vector
    *info.pmap = map
  end
  'ANIM_VERT': begin
    vector.vecanimate='on'
    map.vector=vector
    *info.pmap = map
    if field.nlev le 0 then begin
      print,' '
      print,'>>> Cannot animate in vertical: field.nlev=',field.nlev
    endif else $
      animate_maps,info,map,'zvert'
    vector.vecanimate='off'
    map.vector=vector
    *info.pmap = map
  end
  'SAVE_PS': begin
    psfile = dialog_pickfile(path=info.openpath,/write,group=event.top)
    if (psfile ne '') then begin
      widget_control,event.top,hourglass=1
      pson,filename=psfile,margin=1.0
; I am not sure why we call this, it just resets the color table
; by removing line the color scheme is saved properly.
; Maura had this problem:
;After changing
;>the color palette during a given session, the screen
;>display continues to display that palette even though I 
;>may be looking at multiple files. The same is not true for
;>the ps file that I save during that session. I don't get
;>what I see after I load a new file unless I go back into
;>the drop-down menu and reselect the color palette that I'm
;>looking at.
;
;      setclrtab,info.colortab,/ps
      pltmaps,info,/ps
      psoff
      widget_control,event.top,hourglass=0
    endif
  end
  'SAVE_PNG': writeimage,info.openpath,event.top,'PNG'
  'SAVE_GIF': begin
    version = float(!version.release)
    if version le 5.3 then begin
      writeimage,info.openpath,event.top,'GIF'
    endif else begin 
      print,'>>> NEED IDL version 5.3 to make GIF'
    endelse
  end  
  'SAVE_BMP': writeimage,info.openpath,event.top,'BMP'
  'SAVE_JPEG': writeimage,info.openpath,event.top,'JPEG'
  'SAVE_TIFF': writeimage,info.openpath,event.top,'TIFF'
;
  'IMAGE_ONLY': begin
    map.plottype = 'image_only'
    *info.pmap = map
    print,'Set plot type to ',map.plottype
    pltmaps,info
    widget_control,map.minmaxmenu,sensitive=1   ; can set image min,max
    widget_control,map.contourmenu,sensitive=0  ; not doing contours
  end
  'IMAGE+CONTOURS': begin
    map.plottype = 'image+contours'
    *info.pmap = map
    print,'Set plot type to ',map.plottype
    pltmaps,info
    widget_control,map.minmaxmenu,sensitive=0   ; image min,max will be fmin,fmax
    widget_control,map.contourmenu,sensitive=1  ; doing contours
  end
  'MONOCHROME_CONTOURS': begin
    map.plottype = 'monochrome_contours'
    *info.pmap = map
    print,'Set plot type to ',map.plottype
    pltmaps,info
    widget_control,map.minmaxmenu,sensitive=0   ; image min,max will be fmin,fmax
    widget_control,map.contourmenu,sensitive=1  ; doing contours
  end
  'COLORFILL_CONTOURS': begin
    map.plottype = 'colorfill_contours'
    *info.pmap = map
    print,'Set plot type to ',map.plottype
    pltmaps,info
    widget_control,map.minmaxmenu,sensitive=0   ; image min,max will be fmin,fmax
    widget_control,map.contourmenu,sensitive=1  ; doing contours
  end
  'VEC_ON': begin
    vector.control='on'
    vector.carrows=0
    map.vector=vector
    *info.pmap = map
    get_vectors,info
   ; pltmaps,info
  end
  'VEC_OFF': begin
    vector.control='off'
    map.vector=vector
    *info.pmap = map
    pltmaps,info
  end
  'VEC_ONLY': begin
    vector.control='only'
    vector.carrows=!d.table_size-1
    map.vector=vector
    *info.pmap = map
    get_vectors,info
    vector.carrows=0
    ;pltmaps,info
  end
  'POLAR_SLT': begin
    map.fixpolar = 'SLT'
    *info.pmap = map
    print,'Set polar dial to SLT (local noon at top of polar projection)'
    pltmaps,info
  end
  'POLAR_LON': begin
    map.fixpolar = 'LON'
    *info.pmap = map
    print,'Set polar dial to LON (longitude 0 at top of polar projection)'
    pltmaps,info
  end
  else: print,'>>> maps_event: unknown widget ',widget
endcase 
end
;-----------------------------------------------------------------------
pro field_event,event
;
; User has selected a field. Read field from the file and update
; map structure.
;
widget_control,event.top,get_uvalue=pinfo
info = *pinfo
map = *info.pmap
map.setcontour='off'
widget_control,event.id,get_uvalue=widget
fields = *info.fields
for i=0,info.nflds-1 do begin
  if (widget eq fields[i].name) then begin
    map.ifield = i
    if ptr_valid(fields[i].data) then begin ; field has been read
      print,'Selected field ',fields[i].name
      fmin = min(*fields[i].data) & fmax = max(*fields[i].data)
    endif else begin
      widget_control,/hourglass
      varget,info,fields[i],ncdata
;     print,'field_event after varget: help,ncdata = ' & help,ncdata
      field = fields[i]
;     print,'field_event: read field ',field.name,' field.ntime=',field.ntime,$
;       ' help,ncdata=' & help,ncdata
      procfield,info,ncdata,field,info.z_hist
      fields[i] = field
      if map.izvert lt 0 then begin
        if fields[i].nlev gt 0 then begin
          map.izvert = 0
          map.zvert = (*field.levs)[map.izvert]
          widget_control,map.animzvert,sensitive=1
          print,'field_event set map.izvert=',map.izvert,' map.zvert=',$
            map.zvert
          print,'field.levs=' & print,*field.levs
        endif
      endif
      *info.pmap = map
      *info.fields = fields
      fmin = min(*fields[i].data) & fmax = max(*fields[i].data)
      rpt_minmax,info,fields[i],fmin,fmax
    endelse
    map.field = fields[i]

;   data = *fields[map.ifield].data
;   defmapdata,map,data,map.izvert,map.imtime

    cmin=0. & cmax=0. & cint=0.
    defmapdata,map,*fields[map.ifield].data,map.izvert,map.imtime
    fminmax,*map.data,fmin,fmax,map.missing_value
    levels = mkclevels(fmin,fmax,cmin,cmax,cint)
    map.fmin=cmin & map.fmax=cmax & map.cint=cint
    *map.clevels = levels
  endif
endfor
field=map.field
vector=map.vector
if field.grid_type ne vector.lon_grid_type or $
  field.grid_type ne vector.lat_grid_type and $
  vector.ilonvec ge 0 and vector.ilatvec ge 0 and $
  vector.control eq 'on' and $
  vector.control ne 'only' then begin
    errtlb=map.tlb  
    message='Map coordinates do not match for the wind fields and current field'  
    error_popup,errtlb,message
    vector.control = 'off'
    map.vector=vector
endif 
;if map.field.nlev le 1 then $
;  widget_control,map.levbase,sensitive=0 $
;else $
;  widget_control,map.levbase,/sensitive
;
; Update state info:
;
*info.pmap = map
*pinfo = info
mkproj,map,info,0
pltmaps,info
end ; field_event
;-----------------------------------------------------------------------
pro maps,info,xsize=xsize,ysize=ysize,projection=projection,check_map=check_map
;
file = *info.pfile ; file info structure
title = 'Maps: '+info.file

if keyword_set(xsize) then begin
  xsize = xsize
endif else begin
  xsize =500
endelse
if keyword_set(ysize) then begin
  ysize = ysize
endif else begin
  ysize =400
endelse

if keyword_set(projection) then begin
  projection = projection
endif else begin
  projection='Cylindrical Equidistant'  ; map projection
 ; projection='Satellite Projection'  ; map projection
 ; projection='Polar Stereographic'  ; map projection
endelse
if arg_present(*info.pmap) then begin
  map2 = *info.pmap
  if arg_present(map2.tlb) then begin
    widget_control,map2.tlb,/destroy
  endif
endif

;print,'maps: info.groupleader=',info.groupleader
;tlb = widget_base(column=1,mbar=mbar,title=title,group_leader=info.groupleader)
tlb = widget_base(column=1,mbar=mbar,title=title)

map_ids = *info.pmap_ids
for i=0,n_elements(map_ids)-1 do begin
  if (map_ids[i] le 0) then begin
    map_ids[i] = tlb
;   break ; this does not work, why?
    goto,done
  endif
endfor
done:
*info.pmap_ids = map_ids
;
; Projections menu:
projmenu = widget_button(mbar,value='Projection')
proj = widget_button(projmenu,value='Cylindrical Equidistant',$
  uvalue='CE')
proj = widget_button(projmenu,value='Polar Stereographic',$
  uvalue='ST')
;added by Tom Freeston on 6/9/03 for satellite view
proj = widget_button(projmenu,value='Satellite View', $
  uvalue='SV')
;
; Fields menu:
;fieldsmenu = widget_button(mbar,value='Field')
fields = *info.fields
;for i=0,info.nflds-1 do begin
;  button = widget_button(fieldsmenu,value=fields[i].name,$
;    uvalue=fields[i].name,event_pro='field_event')
;  if (i eq 0) then field = fields[i].name
;endfor
fieldsmenu = fields_menu(mbar,fields,'field_event')
;
; Model times menu:
mtimesmenu = mtime_menu(mbar,file.mtimes,'mtime_map_event')
;
; Plot options:
;
optsmenu = widget_button(mbar,value='PlotOptions')
;
; Plot types (submenu under plot options):
;
plottype = widget_button(optsmenu,value='Plot Type',/menu)
button = widget_button(plottype,$
  value='Image Only',uvalue='IMAGE_ONLY')
button = widget_button(plottype,$
  value='Image plus Contours',uvalue='IMAGE+CONTOURS')
button = widget_button(plottype,$
  value='Monochrome Contours',uvalue='MONOCHROME_CONTOURS')
button = widget_button(plottype,$
  value='Color-fill Contours',uvalue='COLORFILL_CONTOURS')

vecplot = widget_button(optsmenu,value='Vector Plot',/menu)
button = widget_button(vecplot,$
  value='Vectors On...',uvalue='VEC_ON')
button = widget_button(vecplot,$
  value='Vectors Off',uvalue='VEC_OFF')
button = widget_button(vecplot,$
  value='Vectors Only...',uvalue='VEC_ONLY')
;widget_control,vecplot,sensitive=0

;
; Plotting log10 of the fields: there are 3 options:
;   map.log10 = 'density fields'  -> plot log10 of density fields only
;   map.log10 = 'all fields'      -> always plot log10
;   map.log10 = 'none'            -> never plot log10
; (See pro map_event above, and defmapdata.pro and pltlon.pro)
; Log10 submenu under PlotOptions:
;
log10menu = widget_button(optsmenu,value='Plot log10 of field:',/menu)
button = widget_button(log10menu,value='Plot log10 (density fields only)',$
  uvalue='LOG10')
button = widget_button(log10menu,value='Plot log10 (all fields)',$
  uvalue='LOG10_ALLFIELDS')
button = widget_button(log10menu,value='Plot linear (all fields)',$
  uvalue='LINEAR')

;
; Continents on/off (submenu under plot options):
;
continents = widget_button(optsmenu,value='Continents',/menu)
button = widget_button(continents,value='Continents White',$
  uvalue='CONTINENTS_WHITE')
button = widget_button(continents,value='Continents Black',$
  uvalue='CONTINENTS_BLACK')
button = widget_button(continents,value='Continents Off',$
  uvalue='CONTINENTS_OFF')
;
; Map grid on/off (submenu under plot options):
;
mapgrid = widget_button(optsmenu,value='Map Grid',/menu)
button = widget_button(mapgrid,value='Map Grid White',$
  uvalue='MAPGRID_WHITE')
button = widget_button(mapgrid,value='Map Grid Black',$
  uvalue='MAPGRID_BLACK')
button = widget_button(mapgrid,value='Map Grid Off',$
  uvalue='MAPGRID_OFF')
;
; Custom Contour:
;
contourmenu = widget_button(optsmenu,value='Custom Contour',/menu)
button = widget_button(contourmenu,value='Reset to full range',$
  uvalue='RESET_CONTOUR')
button = widget_button(contourmenu,value='Set min,max,interval...',$
  uvalue='CUSTOM_CONTOUR')
;
; Set image min,max:
;
minmaxmenu = widget_button(optsmenu,value='Fix Image min,max',/menu)
button = widget_button(minmaxmenu,value='Reset to full range',$
  uvalue='RESET_MINMAX') 
button = widget_button(minmaxmenu,value='Set Image min,max...',$
  uvalue='SET_MINMAX') 
;
; Color tables:
;
button = widget_button(optsmenu,value='Color...',uvalue='COLOR')
;
; Animation menu (last of PlotOptions):
;
animmenu = widget_button(mbar,value='Animate')
button = widget_button(animmenu,value='Animate in time',uvalue='ANIM_TIME')
animzvert = widget_button(animmenu,value='Animate in vertical',uvalue='ANIM_VERT')
;
; Save files menu:
;
savemenu = widget_button(mbar,value='SaveFiles')
button = widget_button(savemenu,value='Postscript...',uvalue='SAVE_PS')
button = widget_button(savemenu,value='PNG...',uvalue='SAVE_PNG')
button = widget_button(savemenu,value='GIF...',uvalue='SAVE_GIF')
button = widget_button(savemenu,value='BMP...',uvalue='SAVE_BMP')
button = widget_button(savemenu,value='JPEG...',uvalue='SAVE_JPEG')
button = widget_button(savemenu,value='TIFF...',uvalue='SAVE_TIFF')
;
;
projbase = widget_base(tlb,column=3,/frame)
draw = widget_draw(tlb,xsize=xsize,ysize=ysize,uvalue='DRAW_MAP')
button = widget_button(tlb,value='Close',uvalue='CLOSE')
widget_control,draw,bad_id=id_check

IF info.ftype EQ 'WACCM' THEN BEGIN

  nlevs = 54
  levs = FINDGEN(nlevs)*0.5 - 21.5    
  izvert = 0
  zvert = levs[izvert]
  dzvert  = levs[1] - levs[0]

ENDIF ELSE BEGIN    

  nlevs = fields[0].nlev
  if (nlevs gt 0) then begin
    izvert = 0
    zvert = (*fields[0].levs)[izvert] ; default bottom boundary
    levs = *fields[0].levs
    dzvert = levs[1]-levs[0]
  endif else begin
    izvert = -1
    zvert = missing_value
  endelse

ENDELSE
;
;checks to see if previous structure exists
;if it does then it retrieves the previous values
;
if keyword_set(check_map) then begin
  mtime = check_map.mtime
  imtime = check_map.imtime
  field = check_map.field
  ifield = check_map.ifield
  fixpolar = check_map.fixpolar
  censlt = check_map.censlt
  erad = check_map.erad
  cenlat = check_map.cenlat
  cenlon = check_map.cenlon
  continents = check_map.continents
  continents_color = check_map.continents_color
  grid = check_map.grid
  grid_color = check_map.grid_color
  plottype = check_map.plottype
  clineclr = check_map.clineclr
  stperim = check_map.stperim
  zvert = check_map.zvert
  izvert = check_map.izvert
  levs = check_map.levs
  fmin = check_map.fmin
  fmax = check_map.fmax
  cint = check_map.cint
  setcontour = check_map.setcontour
  missing_value = check_map.missing_value
; vector structure variables
  check_vec=check_map.vector
  lonvector=check_vec.lonvector        ; field of longitudinal vector
  latvector=check_vec.latvector        ; field of lateral vector
  ilonvec=check_vec.ilonvec            ; field index to lon vector
  ilatvec=check_vec.ilatvec            ; field index to lat vector
  vmagnitude=check_vec.vmag            ; magnitude of arrow
  vlength=check_vec.vlen               ; magnitude of arrow
  windint=check_vec.windint            ; interval of arrow magnitudes
  lonint=check_vec.lonint              ; longitude wind increment
  latint=check_vec.latint              ; latitude wind increment
  lon_grid_type=check_vec.lon_grid_type    ; gridtype eq geographic or magnetic
  lat_grid_type=check_vec.lat_grid_type    ; gridtype eq geographic or magnetic
  latdensity=check_vec.latdensity      ; meridonal arrow density
  londensity=check_vec.londensity      ; zonal arrow density
  units=check_vec.units                ; units of wind vectors
  carrows=check_vec.carrows            ; color of arrows, white default
  control=check_vec.control            ; controls vector plots
  vecanimate=check_vec.vecanimate            ; controls vector animation
  vecmissing_value=check_vec.missing_value
endif else begin
;
; Set up maps structure. Default to first field at first mtime.
;
  mtime = file.mtimes[*,0]
  imtime = 0
  field = fields[0]
  ifield = 0
  fixpolar = 'SLT'
  censlt = 12
  erad = 11
  cenlat = 60.0
  cenlon = 0.0
  continents = 0
  continents_color = !d.table_size-1
  grid = 0
  grid_color = !d.table_size-1
  plottype = 'image+contours'
  clineclr = !d.table_size-1
  stperim = -27.5
  fmin=0.
  fmax=0.
  cint=0.
  missing_value = file.missing_value
;vector structure default values
  lonvector=' '                       ; field of longitudinal vector
  latvector=' '                       ; field of lateral vector
  ilonvec=  -1                        ; field index to lon vector
  ilatvec=  -1                        ; field index to lat vector
  vmagnitude=0.0                      ; magnitude of arrow
  vlength=0.07                        ; length of arrow
  windint=0.0                         ; interval of arrow magnitudes
  lonint=0.0                          ; longitude wind increment
  latint=0.0                          ; latitude wind increment
  lon_grid_type=''                    ; gridtype eq geographic or magnetic
  lat_grid_type=''                    ; gridtype eq geographic or magnetic
  latdensity=1                        ; meridonal arrow density
  londensity=1                        ; zonal arrow density
  units=''                            ; units of wind vectors
  carrows=0                           ; color of arrows, white default
  vecmissing_value=file.missing_value ; value that won't plot arrows
  control='off'                       ; controls vector plots
  vecanimate='off'
  setcontour='off'                    ; controls contour settings
endelse
vector = {                            $
  lonvector:lonvector,                $ ; field of longitudinal vector
  latvector:latvector,                $ ; field of lateral vector
  ilonvec:ilonvec,                    $ ; field index to lon vector
  ilatvec:ilatvec,                    $ ; field index to lat vector
  lon_grid_type:lon_grid_type,        $ ; gridtype eq geographic or magnetic
  lat_grid_type:lat_grid_type,        $ ; gridtype eq geographic or magnetic
  vmag:vmagnitude,                    $ ; magnitude of arrow
  vlen:vlength,                       $ ; length of arrow
  windint:windint,                    $ ; interval of arrow magnitudes
  lonint:lonint,                      $ ; longitude wind increment
  latint:latint,                      $ ; latitude wind increment
  latdensity:latdensity,              $ ; meridonal arrow density
  londensity:londensity,              $ ; zonal arrow density
  units:units,                        $ ; units of wind vectors
  carrows:carrows,                    $ ; color of arrows, white default
  wdrw_vlen:0,                        $ ; vector arrow widget
  missing_value:vecmissing_value,     $ ; value that won't plot arrows
  control:control,                    $ ; controls vector plots
  vecanimate:vecanimate,              $ ; informs vectors that animation is on
  vmin:ptr_new(/allocate_heap),       $ ; min of vector data
  vmax:ptr_new(/allocate_heap),       $ ; max of vector data
  vint:ptr_new(/allocate_heap),       $ ; int of vector data
  lonvecs:ptr_new(/allocate_heap),    $ ; longitude vector data
  latvecs:ptr_new(/allocate_heap),    $ ; latitude vector data
  lonvecdata:ptr_new(/allocate_heap), $ ; lon vector data
  latvecdata:ptr_new(/allocate_heap)  $ ; lat vector data
}
map = {                           $
  projection:projection,          $ ; map projection
  field:field,                    $ ; current field structure
  ifield:ifield,		  $ ; index to current field	
  zvert:zvert,                    $ ; vertical level (default bottom boundary)
  izvert:izvert,                  $ ; index to zvert (field.levs[izvert])
  levs:levs,                      $ ; pressure levels
  mtime:mtime,                    $ ; model time (default first time on file)
  imtime:imtime,                  $ ; index to mtime (file.mtimes[imtime]) 
  missing_value:missing_value,    $ ; missing data value
  log10:'density fields',         $ ; plot log10 (densities, current field, on none)
  fixpolar:fixpolar,              $ ; fix polar proj in either 'slt' or 'lon'
  tlb:tlb,                        $ ; top level base widget
  projbase:projbase,		  $ ; map projection options base
  stperim:stperim,		  $ ; perimeter latitude for polar proj
  animzvert:animzvert,            $ ; widget id of animate in zvert button 
  draw:draw,                      $ ; draw widget id
  censlt:censlt,                  $ ; time that slt is centered on
  erad:erad,			  $ ; earth radius for satellite view
  cenlat:cenlat,		  $ ; plot latitude of center
  cenlon:cenlon,                  $ ; plot longitude of center
  continents:continents,          $ ; continents on or off (0/1)
  continents_color:continents_color, $ ; continents color index (white or black)
  grid:grid,                      $ ; map grid on or off (0/1)
  grid_color:grid_color,          $ ; color index of map grid
  ftype:info.ftype,               $ ; Type of input file (TIME-GCM or WACCM presently)
  plottype:plottype,              $ ; 4 options (see plot_type_menu)
  vector:vector,                  $ ; vector structure
  clineclr:clineclr,              $ ; contour line color
  minmaxmenu:minmaxmenu,          $ ; menu widget for setting image min,max
  contourmenu:contourmenu,        $ ; menu widget for custom contour
  setcontour:setcontour,               $ ; keeps track of contour levels setting
  fmin:fmin,fmax:fmax,cint:cint,  $ ; field min,max and contour interval
  clevels:ptr_new(/allocate_heap),$ ; contour levels
  lons:ptr_new(/allocate_heap),   $ ; longitudes
  lats:ptr_new(/allocate_heap),   $ ; latitudes
  data:ptr_new(/allocate_heap)    $ ; 2d data (lon,lat)
}
;
; Read data from first field:
;
if keyword_set(check_map) then begin
  *map.clevels=*check_map.clevels
  *map.lons=*check_map.lons
  *map.lats=*check_map.lats
  if vector.control ne 'off' then begin
    *vector.lonvecdata=*check_vec.lonvecdata
    *vector.latvecdata=*check_vec.latvecdata
  endif
endif else begin
  if ptr_valid(fields[0].data) then begin ; field has been read
    defmapdata,map,*fields[0].data,map.izvert,map.imtime
  endif else begin
    widget_control,/hourglass
    varget,info,fields[0],ncdata
    field = fields[0]
    procfield,info,ncdata,field,info.z_hist
    fields[0] = field
    defmapdata,map,*fields[0].data,map.izvert,map.imtime
  endelse
  fminmax,*map.data,fmin,fmax,map.missing_value
  rpt_minmax,info,fields[0],fmin,fmax
  widget_control,map.minmaxmenu,sensitive=0 ; because default plottype is image+contour
;
; Set contour levels:
;
  cmin=0. & cmax=0. & cint=0.
  levels = mkclevels(fmin,fmax,cmin,cmax,cint)
  map.fmin=cmin & map.fmax=cmax & map.cint=cint
  *map.clevels = levels
endelse
;
; Update state info, realize, and turn over to wmanager:
;
*info.fields = fields
info.pmap = ptr_new(map)
widget_control,tlb,/realize
pinfo = ptr_new(info)
mkproj,map,info,tlb
pltmaps,info

widget_control,tlb,set_uvalue=pinfo
xmanager,'maps',tlb,/no_block
end
