;------------------------------------------------------------------
;
pro mkarrow,xt,yt,xh,yh,theta=theta,color=color
;
; Draw an arrow from (xt,yt) to (xh,yh) (normalized coords)
;
if xt eq 1.e12 or yt eq 1.e12 or xh eq 1.e12 or yh eq 1.e12 then return
if keyword_set(theta) then hdeg = theta*!dtor else $
  hdeg = 22.5*!dtor      ; angle between arrow and head parts
if n_elements(color) eq 1 then begin
  clr = color 
endif else clr = !d.table_size-1

phi = atan(yh-yt,xh-xt) ; angle between arrow and x-axis
dlen = sqrt((yh-yt)^2+(xh-xt)^2)	; distance of line part
scale = 0.2 ; length of head pieces are 1/5 of arrow length
r = scale*dlen
xh1 = xt + ((dlen-r*cos(hdeg))*cos(phi) - r*sin(hdeg)*sin(phi))
yh1 = yt + ((dlen-r*cos(hdeg))*sin(phi) + r*sin(hdeg)*cos(phi))
xh2 = xt + ((dlen-r*cos(hdeg))*cos(phi) + r*sin(hdeg)*sin(phi))
yh2 = yt + ((dlen-r*cos(hdeg))*sin(phi) - r*sin(hdeg)*cos(phi))
plots,[xt,xh,xh1,xh,xh2],[yt,yh,yh1,yh,yh2],/norm,color=clr
return
end
;
;------------------------------------------------------------------
