;
function make_mtime_string,mtime
return,$
  strcompress(string(mtime[0]),/remove_all)+','+ $
  strcompress(string(mtime[1]),/remove_all)+','+ $
  strcompress(string(mtime[2]),/remove_all)
end
;-----------------------------------------------------------------------
function mtime_menu,parent,mtimes,event_pro,mk_insensitive=mk_insensitive
;
; Construct an mtimes menu, returning widget id.
;
dims = size(mtimes,/dimensions)
ndims = n_elements(dims)
if dims[0] ne 3 then begin
  print,'>>> construct_mtime_menu: first dim of mtimes should be 3,',$
    ' but is ',dims[0]
  return,-1
endif
if ndims eq 2 then begin
  if dims[1] le 0 then begin
    print,'>>> construct_mtime_menu: no times? ntimes=',ntimes
    return,-1
  endif
endif
if ndims eq 1 then begin
; print,'>>> construct_mtime_menu: bad ndims=',ndims,' from size(mtimes)'
; return,-1
  ntimes = 1
endif else begin
  ntimes = dims[1]
endelse
;
mxitems = 25
;ntimes = dims[1]
if ntimes le mxitems then begin
  mtimesmenu = widget_button(parent,value='ModelTime')
  for i=0,ntimes-1 do begin
    mtime_string = make_mtime_string(mtimes[*,i])
    button = widget_button(mtimesmenu,value=mtime_string,uvalue=mtime_string,$
      event_pro=event_pro)
  endfor
endif else begin ; > mxitems times
  mtimesmenu = widget_button(parent,value='ModelTime',/menu)
  nmenus = ntimes / mxitems
  menubases = intarr(nmenus)
;  print,'construct_mtime_menu: ntimes=',ntimes,' nmenus=',nmenus
  imtime = 0
  for m=0,nmenus-1 do begin
    mtime_string0 = make_mtime_string(mtimes[*,imtime])
    mtime_string1 = make_mtime_string(mtimes[*,imtime+mxitems-1])
    title = mtime_string0+'to'+mtime_string1
    menubases[m] = widget_button(mtimesmenu,value=title,/menu)
    for i=0,mxitems-1 do begin
      mtime_string = make_mtime_string(mtimes[*,imtime])
      button = widget_button(menubases[m],value=mtime_string,$
        uvalue=mtime_string,event_pro=event_pro)
      imtime = imtime+1
    endfor
  endfor ; m=0,nmenus-1
  ntimes_last = ntimes mod mxitems
  if ntimes_last gt 0 then begin
    mtime_string0 = make_mtime_string(mtimes[*,imtime])
    mtime_string1 = make_mtime_string(mtimes[*,imtime+ntimes_last-1])
    title = mtime_string0+'to'+mtime_string1
    menubase = widget_button(mtimesmenu,value=title,/menu)
    for m=0,ntimes_last-1 do begin
      mtime_string = make_mtime_string(mtimes[*,imtime])
      button = widget_button(menubase,value=mtime_string,$
        uvalue=mtime_string,event_pro=event_pro)
      imtime = imtime+1
    endfor
  endif
endelse
if keyword_set(mk_insensitive) then $
  widget_control,mtimesmenu,sensitive=0
end
