;
pro polarlats,map,lat,hem
;
; Return lat array given perimeter latitude of a polar stereographic
; projection (map.stperim).
;
field = map.field
lat0 = *field.lats
nlat0 = n_elements(lat0)
nlat = 0
if map.stperim le 0. then begin ; southern hemisphere
  hem = 'S' 
  for j=0,nlat0-1 do begin
    if (lat0[j] le map.stperim) then nlat = nlat+1
  endfor
  if (lat0[nlat-1] ne map.stperim and nlat lt nlat0-1) then nlat=nlat+1
  lat = fltarr(nlat)
  lat = lat0[0:nlat-1]
endif else begin                ; northern hemisphere
  hem = 'N' 
  for j=nlat0-1,0,-1 do begin
    if (lat0[j] ge map.stperim) then nlat = nlat+1
  endfor
  jj = nlat0-nlat+1
  if (lat0[jj] ne map.stperim and nlat le nlat0) then nlat=nlat+1
  lat = fltarr(nlat)
  for j=0,nlat-1 do begin
    lat[j] = lat0[nlat0-1-j]
  endfor
endelse ; N or S
end
