;
pro setminmax_event,event
  widget_control,event.id,get_uvalue=widget
  widget_control,event.top,get_uvalue=pminmax
  minmax = *pminmax
  case widget of
    'TEXTMIN': begin
      widget_control,event.id,get_value=minstring
      minmax.umin = mkfloat(minstring,minmax.umin,event.id)
      print,'Set minimum = ',minmax.umin
      *pminmax = minmax
    end
    'TEXTMAX': begin
      widget_control,event.id,get_value=maxstring
      minmax.umax = mkfloat(maxstring,minmax.umax,event.id)
      print,'Set maximum = ',minmax.umax
      *pminmax = minmax
    end
    'OK': begin
;
; Read min and max values from text widgets:
      widget_control,minmax.textmin,get_value=minstring
      widget_control,minmax.textmax,get_value=maxstring
      minmax.umin = mkfloat(minstring,minmax.umin,minmax.textmin)
      minmax.umax = mkfloat(maxstring,minmax.umax,minmax.textmax)
;
; Insure that min <= max. If min > max, reset both to zero.
;     if minmax.umin gt minmax.umax then begin
;       print,' '
;       print,'>>> Minimum value must be <= Maximum value.'
;       print,'    Min=',minmax.umin,' Max=',minmax.umax
;       print,'    Resetting min=max=0...' & print,' '
;       minmax.umin = mkfloat('0.',0.,minmax.textmin)
;       minmax.umax = mkfloat('0.',0.,minmax.textmax)
;       *pminmax = minmax
;       return
;     endif
;
; Update state and quit:
      minmax.umin = mkfloat(minstring,minmax.umin,minmax.textmin)
      minmax.umax = mkfloat(maxstring,minmax.umin,minmax.textmax)
      *pminmax = minmax
      widget_control,event.top,/destroy
    end ; OK
    'RESET': begin
      minmax.umin=0. & minmax.umax=0.
      *pminmax = minmax
      widget_control,event.top,/destroy
    end
    'CANCEL': begin
      print,'Canceling: saving current min,max ',minmax.umin,minmax.umax
      widget_control,event.top,/destroy
      *pminmax = minmax
    end
    'HELP': begin
      xdisplayfile,"setminmax.help",done_button='Done',title= $
        'Help for Fixing Min,Max Field Values for Image Display',$
        group=event.top,modal=widget_info(event.top,/modal), $
        width=90,height=50,text=[ $
      " ",$
      "Fix Minimum and Maximum Field Values for Image Display.",$
      "('Fix Image Min,Max' option from the PlotOptions menu)"," ",$
      "There are two text field options:",$
      " ",$
      "  1. Enter minimum value of the current field to be displayed by the image.",$
      "     Field values less than the minimum will be displayed with the bottom color.",$
      " ",$
      "  2. Enter maximum value of the current field to be displayed by the image.",$
      "     Field values greater than the maximum will be displayed with the top color.",$
      " ",$
      "Buttons:"," ",$
      "  'OK':",$
      "     This button will validate and apply the min,max text entries, and close",$
      "     the window.",$
      " ",$   
      "  'CANCEL'",$
      "     This button will apply the min,max that was set before the fix min,max ",$
      "       window was opened, and close the window.",$
      " ",$   
      "  'Reset to Range of field'",$
      "     This button will ignore your text entries, and reset min,max to zero,",$
      "     signalling the program to use the full range of the field for the current frame.",$ 
      "     (see also notes below).",$
      " ",$
      "Notes:"," ",$
      "  Setting these options has NO EFFECT ON CONTOURS. They effect only the",$
      "  image display.",$ 
      " ",$
      "  If minimum < maximum:",$
      "    These values will be used for image display in subsequent frames",$
      "    until actions are taken that force a reset of the min,max (see below)",$
      " ",$
      "  If minimum = maximum:",$
      "    This action has the same effect as hitting the 'Reset to Range of Field' button:",$
      "    The minimum, maximum will be reset to the range of the field for the",$
      "    current frame. These new values will be used in subsequent frames until",$
      "    actions are taken that force a reset of the min,max (see below)",$
      " ",$
      "  If minimum > maximum:",$
      "    This has the same effect as minimum=maximum, except for this important",$
      "    exception: if an animation is initiated, the animator will calculate",$
      "    the min,max for the entire movie before making the frames.",$
      " ",$ 
      "  Actions that will force resetting min,max to range of the field:",$
      " ",$
      "    a. Choosing a new field (any plot type).",$
      "    b. Choosing a new level for a map (any projection).",$
      "    c. Resetting the range of the y-axis for longitude slices.",$
      "    d. Resetting log10 option for longitude slices.",$
      " ",$
      "  Several actions (such as changing model time, or longitude/slt) do NOT ",$
      "    result in resetting the min,max to the full field range. If you find that ",$
      "    the range of colors being displayed is too small (maybe all the top or ",$
      "    all the bottom color), then hitting the 'Reset to Range of Field' button",$
      "    may help.",$
      " " $
      ]
    end
    else: print,'>>> setminmax: unrecognized event: ',widget
  endcase
end
;-----------------------------------------------------------------------
pro setminmax,info,umin,umax
;
; Widget to allow user to set min,max for current frame.
;   umin,umax are returned.
; Info is used only to provide tlb with a group_leader (info.tlb)
;   (tlb cannot be modal without a group leader)
; Note if umin=umax, then calling procedure should use field min,max.
;
; print,'Enter setminmax: input umin,umax=',umin,umax
; if umin ge umax then begin 
;   umin = 0. & umax = 0. 
; endif
  title = 'User Set Image Min,Max'
  tlb = widget_base(column=1,title=title,group_leader=info.tlb,/modal)
;
  label = widget_label(tlb,value='Enter minimum field value for image')
  textmin = widget_text(tlb,/editable,value=string(umin),uvalue='TEXTMIN')
;
  label = widget_label(tlb,value='Enter maximum field value for image')
  textmax = widget_text(tlb,/editable,value=string(umax),uvalue='TEXTMAX')
;
button = widget_button(tlb,value='Reset to Range of Field',uvalue='RESET')
base = widget_base(tlb,column=3,/frame)
button = widget_button(base,value='OK',uvalue='OK')
button = widget_button(base,value='CANCEL',uvalue='CANCEL')
button = widget_button(base,value='HELP',uvalue='HELP')
;
; State info:
;
  minmax = {minmax_struct,     $
    umin:umin, umax:umax,      $ ; current user min,max
    textmin:textmin,           $ ; widget id of min text
    textmax:textmax            $ ; widget id of max text
  }
;
  pminmax = ptr_new(minmax)
  widget_control,tlb,set_uvalue=pminmax
  widget_control,tlb,/realize
  xmanager,'setminmax',tlb,/no_block
;
; Return umin,umax to calling procedure:
;
  umin = (*pminmax).umin & umax = (*pminmax).umax
; print,'Set user min,max = ',umin,umax
end
