;
pro submit_f90_event,event
widget_control,event.id,get_uvalue=widget
widget_control,event.top,get_uvalue=psubmitinfo
submitinfo = *psubmitinfo
case widget of
  'SUBMIT': begin
    print,'Submit job..'
    widget_control,submitinfo.wtext,get_value=text
    print,'Text = ' & print,text,format='(a)'
  end
  'CANCEL': begin
    widget_control,event.top,/destroy
  end
  'SAVEAS': begin
    title = "Save text as file"
    file = dialog_pickfile(path=submitinfo.openpath,title=title,/write)
    if n_elements(file) gt 0 then begin
      widget_control,submitinfo.wtext,get_value=text
      openw,lu,file,/get_lun
      print,'file=',file,' lu=',lu
      printf,lu,text,format='(a)'
      close,lu
    endif
  end
  'TEXT': begin
;   print,'Text was touched..'
;   help,event,/struct
;   if event.type eq 0 then begin
;     print,'event.ch (byte)  =$',event.ch,'$'
;     print,'event.ch (string)=$',string(event.ch),'$'
;     if event.ch eq 10 then begin
;       print,'Carriage Return'
;     endif
;   endif
  end
  else: print,'submit_f90_event: unknown event: widget=',widget
endcase
end
;-----------------------------------------------------------------------
pro submit_f90,info
  title = "Submit tgcmproc f90 batch job"
  tlb = widget_base(column=1,title=title,group_leader=info.tlb,/modal)
  wtext = widget_text(tlb,/editable,xsize=75,ysize=50,/scroll,/all_events,$
  uvalue='TEXT',$
  value=[$
'&proc_input                                                         ',$
' tmpdir = "/ptmp/foster/tgcmproc/tmpdir"                            ',$ 
' histvols="unvn_march97_wotid_wmc.nc"                               ',$ 
';mtimes = 72,12,0                                                   ',$ 
' mtimes = 73,0,0                                                    ',$ 
' iden = 1                                                           ',$ 
' modelhts = 1                                                       ',$ 
' cfields="VN"                                                       ',$ 
' fmnmxint = "VN",-15.,15.,1.                                        ',$ 
' icolor = 1                                                         ',$ 
' outplt = "cgm","ps"                                                ',$ 
';                                                                   ',$ 
';ipltmaps=1		; plot flag for maps                         ',$ 
';map_global=1		; CE projections (cyl equidistant)           ',$ 
';map_continents=0	; continental outlines flag                  ',$ 
';fmap_zpht = -6.5                                                   ',$ 
';                                                                   ',$
' ipltlon=1		; plot flag for longitude slices             ',$
' ilon_log10=1		; plot log10 sp if ilat_log10 > 0            ',$
' ilon_yaxright=1	; extra right-hand y-axes                    ',$
' flons = "zm"                                                       ',$
' flon_zprange = -99.,-2.                                            ',$
';                                                                   ',$
' sendcgm = "vishnu.hao:/e/foster/tgcmproc/vn_zm_73-0-0.cgm"         ',$
' senddat = "vishnu.hao:/e/foster/tgcmproc/vn_zm_73-0-0.dat"         ',$
' sendps  = "vishnu.hao:/e/foster/tgcmproc/vn_zm_73-0-0.ps"          ',$
'/'                                                                  ])

  base = widget_base(tlb,column=3,/frame)
  button = widget_button(base,value='SUBMIT',uvalue='SUBMIT')
  button = widget_button(base,value='SAVE AS...',uvalue='SAVEAS')
  button = widget_button(base,value='CANCEL',uvalue='CANCEL')
;
; State info:
;
submitinfo = {submitinfo_struct, $
  wtext:wtext,                   $ ; text widget
  openpath:info.openpath         $ ;
}

  psubmitinfo = ptr_new(submitinfo)
  widget_control,tlb,set_uvalue=psubmitinfo
  widget_control,tlb,/realize
  xmanager,'submit_f90',tlb,/no_block
end
