;
pro xcolor_event,event
widget_control,event.id,get_uvalue=widget
widget_control,event.top,get_uvalue=pclrtabs
clrtabs = *pclrtabs
case widget of
  'OK': begin
    widget_control,event.top,/destroy
   end
  'CANCEL': begin
    clrtabs.newtable = clrtabs.oldtable
    print,'Xcolor cancelling..retaining original color table ',$
      clrtabs.newtable
    setclrtab,clrtabs.newtable
    widget_control,event.top,/destroy
  end
  'TABLE_SELECT': begin
    clrtabs.newtable = event.index-1
    setclrtab,clrtabs.newtable
  end
  else: print,'>>> xcolor_event: unrecognized event: ',widget
endcase
*pclrtabs = clrtabs
end ; pro xcolor_event
;-----------------------------------------------------------------------
function xcolor,oldtable,group
;
; Allow user to select pre-defined color table (or custom blue-white-red).
;
tlb = widget_base(column=1,title='Select Color Table',group_leader=group,$
  /modal,/frame)
loadct,get_name=names
nnames = n_elements(names)
xnames = strarr(nnames+1)
xnames[1:nnames] = names[0:nnames-1]
xnames[0] = 'Custom Blue-White-Red'
names = xnames
list = widget_list(tlb,value=names,uvalue='TABLE_SELECT',ysize=20)
widget_control,list,set_list_select=oldtable+1
widget_control,list,set_list_top=0
;
base = widget_base(tlb,column=2,/frame)
button = widget_button(base,value='OK',uvalue='OK')
button = widget_button(base,value='CANCEL',uvalue='CANCEL')
;
clrtabs = {clrtabs_struct, $
  oldtable:oldtable,       $
  newtable:oldtable        $
}
pclrtabs = ptr_new(clrtabs)
widget_control,tlb,set_uvalue=pclrtabs
widget_control,tlb,/realize
xmanager,'xcolor',tlb,/no_block
clrtabs = *pclrtabs
return,clrtabs.newtable
end ; pro xcolor
