




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1007) = -(rxt(83)*y(2) + rxt(90)*y(3) + rxt(115)*y(19) + rxt(120)*y(20) &
                      + rxt(128)*y(21) + rxt(140)*y(6) + rxt(143)*y(7) + rxt(155) &
                      *y(25) + rxt(182)*y(34) + rxt(235)*y(41) + rxt(256)*y(56) &
                      + rxt(278)*y(74) + rxt(284)*y(75) + rxt(302)*y(80) + rxt(334) &
                      *y(96))
         mat(1032) = -rxt(83)*y(1)
         mat(948) = -rxt(90)*y(1)
         mat(690) = -rxt(115)*y(1)
         mat(888) = -rxt(120)*y(1)
         mat(1099) = -rxt(128)*y(1)
         mat(1191) = -rxt(140)*y(1)
         mat(797) = -rxt(143)*y(1)
         mat(1217) = -rxt(155)*y(1)
         mat(1140) = -rxt(182)*y(1)
         mat(137) = -rxt(235)*y(1)
         mat(470) = -rxt(256)*y(1)
         mat(587) = -rxt(278)*y(1)
         mat(542) = -rxt(284)*y(1)
         mat(412) = -rxt(302)*y(1)
         mat(278) = -rxt(334)*y(1)

         mat(1007) = mat(1007) + .100_r8*rxt(302)*y(80) + .200_r8*rxt(278)*y(74) &
                      + .200_r8*rxt(284)*y(75)
         mat(1099) = mat(1099) + .250_r8*rxt(246)*y(45) + .250_r8*rxt(294)*y(73)
         mat(412) = mat(412) + .100_r8*rxt(302)*y(1)
         mat(673) = .250_r8*rxt(246)*y(21)
         mat(587) = mat(587) + .200_r8*rxt(278)*y(1)
         mat(542) = mat(542) + .200_r8*rxt(284)*y(1)
         mat(647) = .250_r8*rxt(294)*y(21)

         mat(1033) = -(rxt(83)*y(1) + 4._r8*rxt(84)*y(2) + rxt(119)*y(20) + rxt(126) &
                      *y(18) + rxt(127)*y(21) + rxt(130)*y(22) + rxt(138)*y(6) &
                      + (rxt(141) + rxt(142)) * y(7) + rxt(149)*y(8) + rxt(162)*y(27) &
                      + rxt(175)*y(30) + rxt(176)*y(31) + rxt(179)*y(32) + rxt(185) &
                      *y(35) + rxt(195)*y(36) + rxt(196)*y(37) + rxt(197)*y(38) &
                      + rxt(215)*y(16))
         mat(1008) = -rxt(83)*y(2)
         mat(889) = -rxt(119)*y(2)
         mat(493) = -rxt(126)*y(2)
         mat(1100) = -rxt(127)*y(2)
         mat(268) = -rxt(130)*y(2)
         mat(1192) = -rxt(138)*y(2)
         mat(798) = -(rxt(141) + rxt(142)) * y(2)
         mat(930) = -rxt(149)*y(2)
         mat(1123) = -rxt(162)*y(2)
         mat(970) = -rxt(175)*y(2)
         mat(419) = -rxt(176)*y(2)
         mat(431) = -rxt(179)*y(2)
         mat(708) = -rxt(185)*y(2)
         mat(378) = -rxt(195)*y(2)
         mat(364) = -rxt(196)*y(2)
         mat(262) = -rxt(197)*y(2)
         mat(765) = -rxt(215)*y(2)

         mat(70) = rxt(134)*y(6) + rxt(135)*y(7)
         mat(1192) = mat(1192) + rxt(134)*y(5)
         mat(798) = mat(798) + rxt(135)*y(5)
         mat(889) = mat(889) + 2.000_r8*rxt(122)*y(20)
         mat(691) = rxt(118)*y(21)
         mat(1100) = mat(1100) + rxt(118)*y(19)

         mat(946) = -(rxt(87)*y(145) + rxt(90)*y(1) + rxt(110)*y(18) + rxt(111)*y(30) &
                      + rxt(112)*y(36) + rxt(113)*y(39))
         mat(680) = -rxt(87)*y(3)
         mat(1005) = -rxt(90)*y(3)
         mat(491) = -rxt(110)*y(3)
         mat(967) = -rxt(111)*y(3)
         mat(377) = -rxt(112)*y(3)
         mat(74) = -rxt(113)*y(3)

         mat(487) = -(rxt(110)*y(3) + rxt(124)*y(20) + rxt(126)*y(2) + rxt(156)*y(25))
         mat(938) = -rxt(110)*y(18)
         mat(865) = -rxt(124)*y(18)
         mat(1021) = -rxt(126)*y(18)
         mat(1204) = -rxt(156)*y(18)

         mat(684) = rxt(117)*y(21)
         mat(1076) = rxt(117)*y(19)

         mat(495) = -((rxt(211) + rxt(212)) * y(20))
         mat(866) = -(rxt(211) + rxt(212)) * y(17)

         mat(985) = .560_r8*rxt(256)*y(56) + .300_r8*rxt(302)*y(80) + .500_r8*rxt(235) &
                      *y(41) + .050_r8*rxt(278)*y(74) + .200_r8*rxt(284)*y(75)
         mat(1022) = rxt(215)*y(16)
         mat(1169) = .220_r8*rxt(285)*y(76) + .500_r8*rxt(320)*y(88)
         mat(866) = mat(866) + rxt(214)*y(16) + rxt(251)*y(50) + rxt(272)*y(65) &
                      + .350_r8*rxt(228)*y(118)
         mat(908) = rxt(213)*y(16) + .220_r8*rxt(287)*y(76) + rxt(273)*y(65) &
                      + .500_r8*rxt(321)*y(88)
         mat(725) = .110_r8*rxt(289)*y(76) + .200_r8*rxt(323)*y(88)
         mat(755) = rxt(215)*y(2) + rxt(214)*y(20) + rxt(213)*y(8) + rxt(160)*y(25) &
                      + rxt(184)*y(34)
         mat(1205) = rxt(160)*y(16)
         mat(1130) = rxt(184)*y(16)
         mat(460) = .560_r8*rxt(256)*y(1)
         mat(402) = .300_r8*rxt(302)*y(1)
         mat(656) = .220_r8*rxt(290)*y(76) + .500_r8*rxt(324)*y(88)
         mat(134) = .500_r8*rxt(235)*y(1)
         mat(294) = rxt(251)*y(20)
         mat(573) = .050_r8*rxt(278)*y(1)
         mat(532) = .200_r8*rxt(284)*y(1)
         mat(594) = .220_r8*rxt(285)*y(6) + .220_r8*rxt(287)*y(8) + .110_r8*rxt(289) &
                      *y(13) + .220_r8*rxt(290)*y(45)
         mat(545) = rxt(272)*y(20) + rxt(273)*y(8)
         mat(558) = .500_r8*rxt(320)*y(6) + .500_r8*rxt(321)*y(8) + .200_r8*rxt(323) &
                      *y(13) + .500_r8*rxt(324)*y(45)
         mat(59) = .350_r8*rxt(228)*y(20)

         mat(68) = -(rxt(134)*y(6) + (rxt(135) + rxt(136) + rxt(137)) * y(7))
         mat(1147) = -rxt(134)*y(5)
         mat(771) = -(rxt(135) + rxt(136) + rxt(137)) * y(5)

         mat(1196) = -(rxt(134)*y(5) + rxt(138)*y(2) + rxt(139)*y(21) + rxt(140)*y(1) &
                      + rxt(148)*y(8) + rxt(167)*y(27) + rxt(188)*y(35) + rxt(217) &
                      *y(13) + rxt(225)*y(120) + rxt(231)*y(52) + rxt(237)*y(43) &
                      + rxt(244)*y(45) + rxt(258)*y(58) + rxt(263)*y(61) + rxt(267) &
                      *y(64) + rxt(276)*y(70) + rxt(280)*y(71) + (rxt(285) + rxt(286) &
                      ) * y(76) + rxt(292)*y(73) + rxt(304)*y(85) + rxt(310)*y(86) &
                      + rxt(317)*y(81) + rxt(320)*y(88) + rxt(328)*y(93) + rxt(336) &
                      *y(97))
         mat(71) = -rxt(134)*y(6)
         mat(1037) = -rxt(138)*y(6)
         mat(1104) = -rxt(139)*y(6)
         mat(1012) = -rxt(140)*y(6)
         mat(934) = -rxt(148)*y(6)
         mat(1127) = -rxt(167)*y(6)
         mat(712) = -rxt(188)*y(6)
         mat(749) = -rxt(217)*y(6)
         mat(206) = -rxt(225)*y(6)
         mat(288) = -rxt(231)*y(6)
         mat(357) = -rxt(237)*y(6)
         mat(675) = -rxt(244)*y(6)
         mat(392) = -rxt(258)*y(6)
         mat(346) = -rxt(263)*y(6)
         mat(455) = -rxt(267)*y(6)
         mat(111) = -rxt(276)*y(6)
         mat(315) = -rxt(280)*y(6)
         mat(609) = -(rxt(285) + rxt(286)) * y(6)
         mat(649) = -rxt(292)*y(6)
         mat(632) = -rxt(304)*y(6)
         mat(486) = -rxt(310)*y(6)
         mat(330) = -rxt(317)*y(6)
         mat(571) = -rxt(320)*y(6)
         mat(221) = -rxt(328)*y(6)
         mat(514) = -rxt(336)*y(6)

         mat(1037) = mat(1037) + rxt(141)*y(7)
         mat(71) = mat(71) + 2.000_r8*rxt(136)*y(7)
         mat(802) = rxt(141)*y(2) + 2.000_r8*rxt(136)*y(5)

         mat(792) = -((rxt(135) + rxt(136) + rxt(137)) * y(5) + (rxt(141) + rxt(142) &
                      ) * y(2) + rxt(143)*y(1) + rxt(144)*y(8) + rxt(146)*y(20) &
                      + rxt(152)*y(21) + rxt(168)*y(27) + rxt(189)*y(35) + rxt(245) &
                      *y(45) + rxt(298)*y(73) + rxt(332)*y(95))
         mat(69) = -(rxt(135) + rxt(136) + rxt(137)) * y(7)
         mat(1027) = -(rxt(141) + rxt(142)) * y(7)
         mat(1002) = -rxt(143)*y(7)
         mat(924) = -rxt(144)*y(7)
         mat(883) = -rxt(146)*y(7)
         mat(1094) = -rxt(152)*y(7)
         mat(1117) = -rxt(168)*y(7)
         mat(702) = -rxt(189)*y(7)
         mat(670) = -rxt(245)*y(7)
         mat(644) = -rxt(298)*y(7)
         mat(66) = -rxt(332)*y(7)

         mat(1002) = mat(1002) + rxt(140)*y(6)
         mat(1027) = mat(1027) + rxt(138)*y(6) + rxt(149)*y(8)
         mat(1186) = rxt(140)*y(1) + rxt(138)*y(2) + 2.000_r8*rxt(148)*y(8) + rxt(217) &
                      *y(13) + rxt(139)*y(21) + rxt(167)*y(27) + rxt(188)*y(35) &
                      + rxt(263)*y(61) + rxt(244)*y(45) + rxt(276)*y(70) &
                      + .900_r8*rxt(317)*y(81) + rxt(280)*y(71) + .900_r8*rxt(328) &
                      *y(93) + rxt(336)*y(97) + .920_r8*rxt(304)*y(85) + rxt(285) &
                      *y(76) + rxt(292)*y(73) + rxt(237)*y(43) + rxt(258)*y(58) &
                      + rxt(231)*y(52) + rxt(267)*y(64) + 1.206_r8*rxt(310)*y(86) &
                      + rxt(320)*y(88) + rxt(225)*y(120)
         mat(792) = mat(792) + .700_r8*rxt(332)*y(95)
         mat(883) = mat(883) + rxt(150)*y(8) + rxt(153)*y(10) + rxt(274)*y(79) &
                      + .400_r8*rxt(314)*y(87)
         mat(924) = mat(924) + rxt(149)*y(2) + 2.000_r8*rxt(148)*y(6) + rxt(150)*y(20) &
                      + rxt(151)*y(21) + rxt(305)*y(85) + rxt(287)*y(76) + rxt(293) &
                      *y(73) + rxt(335)*y(96) + 1.206_r8*rxt(311)*y(86) + rxt(315) &
                      *y(87) + rxt(321)*y(88)
         mat(170) = rxt(153)*y(20)
         mat(740) = rxt(217)*y(6)
         mat(1094) = mat(1094) + rxt(139)*y(6) + rxt(151)*y(8) + .206_r8*rxt(312) &
                      *y(86)
         mat(1117) = mat(1117) + rxt(167)*y(6)
         mat(702) = mat(702) + rxt(188)*y(6)
         mat(343) = rxt(263)*y(6)
         mat(670) = mat(670) + rxt(244)*y(6)
         mat(162) = rxt(274)*y(20)
         mat(109) = rxt(276)*y(6)
         mat(327) = .900_r8*rxt(317)*y(6)
         mat(312) = rxt(280)*y(6)
         mat(218) = .900_r8*rxt(328)*y(6)
         mat(66) = mat(66) + .700_r8*rxt(332)*y(7)
         mat(511) = rxt(336)*y(6)
         mat(627) = .920_r8*rxt(304)*y(6) + rxt(305)*y(8)
         mat(605) = rxt(285)*y(6) + rxt(287)*y(8)
         mat(644) = mat(644) + rxt(292)*y(6) + rxt(293)*y(8)
         mat(354) = rxt(237)*y(6)
         mat(275) = rxt(335)*y(8)
         mat(389) = rxt(258)*y(6)
         mat(285) = rxt(231)*y(6)
         mat(452) = rxt(267)*y(6)
         mat(482) = 1.206_r8*rxt(310)*y(6) + 1.206_r8*rxt(311)*y(8) + .206_r8*rxt(312) &
                      *y(21)
         mat(439) = .400_r8*rxt(314)*y(20) + rxt(315)*y(8)
         mat(567) = rxt(320)*y(6) + rxt(321)*y(8)
         mat(203) = rxt(225)*y(6)

         mat(884) = -(rxt(119)*y(2) + rxt(120)*y(1) + rxt(121)*y(21) + (4._r8*rxt(122) &
                      + 4._r8*rxt(123)) * y(20) + rxt(124)*y(18) + rxt(125)*y(22) &
                      + rxt(131)*y(39) + rxt(132)*y(40) + rxt(146)*y(7) + rxt(147) &
                      *y(9) + rxt(150)*y(8) + rxt(153)*y(10) + (rxt(163) + rxt(164) &
                      ) * y(27) + rxt(174)*y(30) + rxt(178)*y(31) + rxt(180)*y(32) &
                      + rxt(186)*y(35) + rxt(194)*y(36) + (rxt(211) + rxt(212) &
                      ) * y(17) + rxt(214)*y(16) + rxt(221)*y(15) + rxt(222)*y(14) &
                      + rxt(223)*y(119) + rxt(228)*y(118) + rxt(229)*y(42) + rxt(230) &
                      *y(41) + rxt(236)*y(46) + rxt(241)*y(44) + rxt(242)*y(47) &
                      + rxt(249)*y(51) + rxt(250)*y(49) + rxt(251)*y(50) + rxt(252) &
                      *y(48) + rxt(254)*y(55) + rxt(255)*y(56) + rxt(261)*y(59) &
                      + rxt(262)*y(57) + rxt(265)*y(62) + rxt(266)*y(60) + rxt(270) &
                      *y(66) + rxt(271)*y(63) + rxt(272)*y(65) + rxt(274)*y(79) &
                      + rxt(275)*y(67) + rxt(277)*y(74) + rxt(279)*y(69) + rxt(282) &
                      *y(72) + rxt(283)*y(75) + rxt(291)*y(77) + rxt(300)*y(78) &
                      + rxt(301)*y(80) + rxt(307)*y(90) + rxt(313)*y(68) + rxt(314) &
                      *y(87) + rxt(316)*y(84) + rxt(319)*y(82) + rxt(325)*y(89) &
                      + rxt(327)*y(91) + rxt(330)*y(94) + rxt(331)*y(92) + rxt(333) &
                      *y(96) + rxt(338)*y(98) + rxt(343)*y(121) + (rxt(344) + rxt(345) &
                      ) * y(122) + rxt(347)*y(123))
         mat(1028) = -rxt(119)*y(20)
         mat(1003) = -rxt(120)*y(20)
         mat(1095) = -rxt(121)*y(20)
         mat(490) = -rxt(124)*y(20)
         mat(266) = -rxt(125)*y(20)
         mat(73) = -rxt(131)*y(20)
         mat(33) = -rxt(132)*y(20)
         mat(793) = -rxt(146)*y(20)
         mat(396) = -rxt(147)*y(20)
         mat(925) = -rxt(150)*y(20)
         mat(171) = -rxt(153)*y(20)
         mat(1118) = -(rxt(163) + rxt(164)) * y(20)
         mat(965) = -rxt(174)*y(20)
         mat(417) = -rxt(178)*y(20)
         mat(428) = -rxt(180)*y(20)
         mat(703) = -rxt(186)*y(20)
         mat(376) = -rxt(194)*y(20)
         mat(497) = -(rxt(211) + rxt(212)) * y(20)
         mat(760) = -rxt(214)*y(20)
         mat(238) = -rxt(221)*y(20)
         mat(179) = -rxt(222)*y(20)
         mat(166) = -rxt(223)*y(20)
         mat(60) = -rxt(228)*y(20)
         mat(96) = -rxt(229)*y(20)
         mat(136) = -rxt(230)*y(20)
         mat(292) = -rxt(236)*y(20)
         mat(125) = -rxt(241)*y(20)
         mat(529) = -rxt(242)*y(20)
         mat(212) = -rxt(249)*y(20)
         mat(371) = -rxt(250)*y(20)
         mat(295) = -rxt(251)*y(20)
         mat(87) = -rxt(252)*y(20)
         mat(197) = -rxt(254)*y(20)
         mat(468) = -rxt(255)*y(20)
         mat(152) = -rxt(261)*y(20)
         mat(38) = -rxt(262)*y(20)
         mat(246) = -rxt(265)*y(20)
         mat(336) = -rxt(266)*y(20)
         mat(159) = -rxt(270)*y(20)
         mat(519) = -rxt(271)*y(20)
         mat(551) = -rxt(272)*y(20)
         mat(163) = -rxt(274)*y(20)
         mat(28) = -rxt(275)*y(20)
         mat(585) = -rxt(277)*y(20)
         mat(184) = -rxt(279)*y(20)
         mat(116) = -rxt(282)*y(20)
         mat(541) = -rxt(283)*y(20)
         mat(120) = -rxt(291)*y(20)
         mat(233) = -rxt(300)*y(20)
         mat(410) = -rxt(301)*y(20)
         mat(254) = -rxt(307)*y(20)
         mat(25) = -rxt(313)*y(20)
         mat(440) = -rxt(314)*y(20)
         mat(141) = -rxt(316)*y(20)
         mat(306) = -rxt(319)*y(20)
         mat(130) = -rxt(325)*y(20)
         mat(45) = -rxt(327)*y(20)
         mat(147) = -rxt(330)*y(20)
         mat(49) = -rxt(331)*y(20)
         mat(276) = -rxt(333)*y(20)
         mat(190) = -rxt(338)*y(20)
         mat(41) = -rxt(343)*y(20)
         mat(82) = -(rxt(344) + rxt(345)) * y(20)
         mat(31) = -rxt(347)*y(20)

         mat(1003) = mat(1003) + rxt(115)*y(19) + rxt(128)*y(21) + .330_r8*rxt(256) &
                      *y(56) + .270_r8*rxt(302)*y(80) + .120_r8*rxt(235)*y(41) &
                      + .080_r8*rxt(278)*y(74) + .215_r8*rxt(284)*y(75) &
                      + .700_r8*rxt(334)*y(96)
         mat(1028) = mat(1028) + rxt(126)*y(18) + rxt(215)*y(16) + rxt(127)*y(21) &
                      + rxt(130)*y(22) + rxt(175)*y(30) + rxt(176)*y(31) + rxt(195) &
                      *y(36) + rxt(196)*y(37)
         mat(944) = rxt(110)*y(18) + rxt(113)*y(39) + 2.000_r8*rxt(87)*y(145) &
                      + rxt(111)*y(30) + rxt(112)*y(36)
         mat(490) = mat(490) + rxt(126)*y(2) + rxt(110)*y(3)
         mat(1187) = rxt(139)*y(21)
         mat(884) = mat(884) + .300_r8*rxt(222)*y(14) + .500_r8*rxt(265)*y(62) &
                      + .100_r8*rxt(291)*y(77) + .500_r8*rxt(241)*y(44) &
                      + .650_r8*rxt(228)*y(118)
         mat(925) = mat(925) + rxt(151)*y(21)
         mat(179) = mat(179) + .300_r8*rxt(222)*y(20)
         mat(73) = mat(73) + rxt(113)*y(3)
         mat(760) = mat(760) + rxt(215)*y(2)
         mat(687) = rxt(115)*y(1) + 2.000_r8*rxt(116)*y(21)
         mat(1095) = mat(1095) + rxt(128)*y(1) + rxt(127)*y(2) + rxt(139)*y(6) &
                      + rxt(151)*y(8) + 2.000_r8*rxt(116)*y(19) + rxt(159)*y(25)
         mat(266) = mat(266) + rxt(130)*y(2)
         mat(679) = 2.000_r8*rxt(87)*y(3)
         mat(1213) = rxt(159)*y(21)
         mat(965) = mat(965) + rxt(175)*y(2) + rxt(111)*y(3)
         mat(417) = mat(417) + rxt(176)*y(2)
         mat(376) = mat(376) + rxt(195)*y(2) + rxt(112)*y(3)
         mat(362) = rxt(196)*y(2)
         mat(468) = mat(468) + .330_r8*rxt(256)*y(1)
         mat(410) = mat(410) + .270_r8*rxt(302)*y(1)
         mat(246) = mat(246) + .500_r8*rxt(265)*y(20)
         mat(136) = mat(136) + .120_r8*rxt(235)*y(1)
         mat(585) = mat(585) + .080_r8*rxt(278)*y(1)
         mat(541) = mat(541) + .215_r8*rxt(284)*y(1)
         mat(120) = mat(120) + .100_r8*rxt(291)*y(20)
         mat(125) = mat(125) + .500_r8*rxt(241)*y(20)
         mat(276) = mat(276) + .700_r8*rxt(334)*y(1)
         mat(60) = mat(60) + .650_r8*rxt(228)*y(20)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(926) = -(rxt(144)*y(7) + rxt(148)*y(6) + rxt(149)*y(2) + rxt(150)*y(20) &
                      + rxt(151)*y(21) + rxt(213)*y(16) + rxt(243)*y(47) + rxt(257) &
                      *y(56) + rxt(273)*y(65) + rxt(287)*y(76) + rxt(293)*y(73) &
                      + rxt(303)*y(80) + rxt(305)*y(85) + rxt(311)*y(86) + rxt(315) &
                      *y(87) + rxt(321)*y(88) + rxt(335)*y(96) + rxt(346)*y(122))
         mat(794) = -rxt(144)*y(8)
         mat(1188) = -rxt(148)*y(8)
         mat(1029) = -rxt(149)*y(8)
         mat(885) = -rxt(150)*y(8)
         mat(1096) = -rxt(151)*y(8)
         mat(761) = -rxt(213)*y(8)
         mat(530) = -rxt(243)*y(8)
         mat(469) = -rxt(257)*y(8)
         mat(552) = -rxt(273)*y(8)
         mat(607) = -rxt(287)*y(8)
         mat(646) = -rxt(293)*y(8)
         mat(411) = -rxt(303)*y(8)
         mat(629) = -rxt(305)*y(8)
         mat(484) = -rxt(311)*y(8)
         mat(441) = -rxt(315)*y(8)
         mat(569) = -rxt(321)*y(8)
         mat(277) = -rxt(335)*y(8)
         mat(83) = -rxt(346)*y(8)

         mat(1004) = rxt(143)*y(7)
         mat(1029) = mat(1029) + rxt(142)*y(7) + rxt(179)*y(32) + rxt(197)*y(38)
         mat(794) = mat(794) + rxt(143)*y(1) + rxt(142)*y(2)
         mat(885) = mat(885) + rxt(147)*y(9) + rxt(180)*y(32) + rxt(254)*y(55) &
                      + .500_r8*rxt(300)*y(78)
         mat(397) = rxt(147)*y(20)
         mat(1214) = rxt(181)*y(32)
         mat(429) = rxt(179)*y(2) + rxt(180)*y(20) + rxt(181)*y(25)
         mat(261) = rxt(197)*y(2)
         mat(198) = rxt(254)*y(20)
         mat(234) = .500_r8*rxt(300)*y(20)

         mat(393) = -(rxt(147)*y(20))
         mat(857) = -rxt(147)*y(9)

         mat(780) = rxt(146)*y(20)
         mat(857) = mat(857) + rxt(146)*y(7)
         mat(903) = rxt(213)*y(16) + rxt(243)*y(47) + rxt(273)*y(65) + rxt(346)*y(122)
         mat(753) = rxt(213)*y(8)
         mat(958) = (rxt(352)+rxt(357)+rxt(363))*y(32)
         mat(423) = (rxt(352)+rxt(357)+rxt(363))*y(30)
         mat(521) = rxt(243)*y(8)
         mat(544) = rxt(273)*y(8)
         mat(81) = rxt(346)*y(8)

         mat(168) = -(rxt(153)*y(20))
         mat(831) = -rxt(153)*y(10)

         mat(773) = rxt(152)*y(21)
         mat(1049) = rxt(152)*y(7)


         mat(772) = rxt(144)*y(8)
         mat(897) = rxt(144)*y(7)

         mat(738) = -(rxt(166)*y(27) + rxt(217)*y(6) + rxt(218)*y(21) + (4._r8*rxt(219) &
                      + 4._r8*rxt(220)) * y(13) + rxt(239)*y(43) + rxt(247)*y(45) &
                      + rxt(260)*y(58) + rxt(269)*y(64) + rxt(289)*y(76) + rxt(295) &
                      *y(73) + rxt(308)*y(85) + rxt(323)*y(88))
         mat(1115) = -rxt(166)*y(13)
         mat(1184) = -rxt(217)*y(13)
         mat(1092) = -rxt(218)*y(13)
         mat(352) = -rxt(239)*y(13)
         mat(668) = -rxt(247)*y(13)
         mat(387) = -rxt(260)*y(13)
         mat(450) = -rxt(269)*y(13)
         mat(603) = -rxt(289)*y(13)
         mat(642) = -rxt(295)*y(13)
         mat(625) = -rxt(308)*y(13)
         mat(565) = -rxt(323)*y(13)

         mat(1000) = .310_r8*rxt(256)*y(56)
         mat(1184) = mat(1184) + rxt(244)*y(45)
         mat(881) = .700_r8*rxt(222)*y(14) + rxt(236)*y(46)
         mat(738) = mat(738) + .900_r8*rxt(247)*y(45)
         mat(177) = .700_r8*rxt(222)*y(20)
         mat(465) = .310_r8*rxt(256)*y(1)
         mat(291) = rxt(236)*y(20)
         mat(668) = mat(668) + rxt(244)*y(6) + .900_r8*rxt(247)*y(13) &
                      + 4.000_r8*rxt(248)*y(45) + rxt(309)*y(85) + rxt(290)*y(76) &
                      + rxt(296)*y(73) + rxt(324)*y(88)
         mat(625) = mat(625) + rxt(309)*y(45)
         mat(603) = mat(603) + rxt(290)*y(45)
         mat(642) = mat(642) + rxt(296)*y(45)
         mat(565) = mat(565) + rxt(324)*y(45)

         mat(174) = -(rxt(222)*y(20))
         mat(832) = -rxt(222)*y(14)

         mat(716) = rxt(218)*y(21)
         mat(1050) = rxt(218)*y(13)

         mat(72) = -(rxt(113)*y(3) + rxt(131)*y(20))
         mat(936) = -rxt(113)*y(39)
         mat(815) = -rxt(131)*y(39)

         mat(32) = -(rxt(132)*y(20))
         mat(808) = -rxt(132)*y(40)

         mat(758) = -(rxt(160)*y(25) + rxt(184)*y(34) + rxt(213)*y(8) + rxt(214)*y(20) &
                      + rxt(215)*y(2) + rxt(216)*y(21))
         mat(1211) = -rxt(160)*y(16)
         mat(1134) = -rxt(184)*y(16)
         mat(923) = -rxt(213)*y(16)
         mat(882) = -rxt(214)*y(16)
         mat(1026) = -rxt(215)*y(16)
         mat(1093) = -rxt(216)*y(16)

         mat(1001) = .540_r8*rxt(256)*y(56) + .600_r8*rxt(302)*y(80) + rxt(235)*y(41) &
                      + .800_r8*rxt(278)*y(74) + .700_r8*rxt(284)*y(75)
         mat(1185) = rxt(217)*y(13) + rxt(263)*y(61) + .500_r8*rxt(276)*y(70) &
                      + .100_r8*rxt(317)*y(81) + .510_r8*rxt(304)*y(85) &
                      + .250_r8*rxt(285)*y(76) + rxt(292)*y(73) + .500_r8*rxt(231) &
                      *y(52) + rxt(267)*y(64) + .072_r8*rxt(310)*y(86)
         mat(882) = mat(882) + .300_r8*rxt(222)*y(14) + .500_r8*rxt(249)*y(51) &
                      + rxt(254)*y(55) + .500_r8*rxt(300)*y(78) + rxt(221)*y(15) &
                      + .800_r8*rxt(250)*y(49)
         mat(923) = mat(923) + .600_r8*rxt(305)*y(85) + .250_r8*rxt(287)*y(76) &
                      + rxt(293)*y(73) + .072_r8*rxt(311)*y(86)
         mat(739) = rxt(217)*y(6) + (4.000_r8*rxt(219)+2.000_r8*rxt(220))*y(13) &
                      + rxt(166)*y(27) + rxt(247)*y(45) + 1.200_r8*rxt(308)*y(85) &
                      + .880_r8*rxt(289)*y(76) + 2.000_r8*rxt(295)*y(73) &
                      + .700_r8*rxt(239)*y(43) + rxt(260)*y(58) + .800_r8*rxt(269) &
                      *y(64) + .700_r8*rxt(323)*y(88)
         mat(178) = .300_r8*rxt(222)*y(20)
         mat(1093) = mat(1093) + .008_r8*rxt(312)*y(86)
         mat(1116) = rxt(166)*y(13)
         mat(466) = .540_r8*rxt(256)*y(1)
         mat(409) = .600_r8*rxt(302)*y(1)
         mat(342) = rxt(263)*y(6)
         mat(669) = rxt(247)*y(13) + .600_r8*rxt(309)*y(85) + .250_r8*rxt(290)*y(76) &
                      + rxt(296)*y(73)
         mat(211) = .500_r8*rxt(249)*y(20)
         mat(195) = rxt(254)*y(20)
         mat(135) = rxt(235)*y(1)
         mat(231) = .500_r8*rxt(300)*y(20)
         mat(108) = .500_r8*rxt(276)*y(6)
         mat(326) = .100_r8*rxt(317)*y(6)
         mat(626) = .510_r8*rxt(304)*y(6) + .600_r8*rxt(305)*y(8) + 1.200_r8*rxt(308) &
                      *y(13) + .600_r8*rxt(309)*y(45)
         mat(583) = .800_r8*rxt(278)*y(1)
         mat(540) = .700_r8*rxt(284)*y(1)
         mat(604) = .250_r8*rxt(285)*y(6) + .250_r8*rxt(287)*y(8) + .880_r8*rxt(289) &
                      *y(13) + .250_r8*rxt(290)*y(45)
         mat(643) = rxt(292)*y(6) + rxt(293)*y(8) + 2.000_r8*rxt(295)*y(13) + rxt(296) &
                      *y(45) + 4.000_r8*rxt(297)*y(73)
         mat(353) = .700_r8*rxt(239)*y(13)
         mat(388) = rxt(260)*y(13)
         mat(237) = rxt(221)*y(20)
         mat(370) = .800_r8*rxt(250)*y(20)
         mat(284) = .500_r8*rxt(231)*y(6)
         mat(451) = rxt(267)*y(6) + .800_r8*rxt(269)*y(13)
         mat(481) = .072_r8*rxt(310)*y(6) + .072_r8*rxt(311)*y(8) + .008_r8*rxt(312) &
                      *y(21)
         mat(566) = .700_r8*rxt(323)*y(13)

         mat(686) = -(rxt(115)*y(1) + (rxt(116) + rxt(117) + rxt(118)) * y(21))
         mat(998) = -rxt(115)*y(19)
         mat(1090) = -(rxt(116) + rxt(117) + rxt(118)) * y(19)

         mat(1024) = rxt(126)*y(18) + rxt(119)*y(20)
         mat(940) = rxt(110)*y(18)
         mat(489) = rxt(126)*y(2) + rxt(110)*y(3) + rxt(124)*y(20) + rxt(156)*y(25)
         mat(496) = rxt(211)*y(20)
         mat(879) = rxt(119)*y(2) + rxt(124)*y(18) + rxt(211)*y(17) + rxt(214)*y(16)
         mat(757) = rxt(214)*y(20)
         mat(1209) = rxt(156)*y(18)

         mat(1101) = -((rxt(116) + rxt(117) + rxt(118)) * y(19) + rxt(121)*y(20) &
                      + rxt(127)*y(2) + rxt(128)*y(1) + 4._r8*rxt(129)*y(21) + rxt(139) &
                      *y(6) + rxt(151)*y(8) + rxt(152)*y(7) + (rxt(158) + rxt(159) &
                      ) * y(25) + rxt(165)*y(27) + rxt(183)*y(34) + rxt(187)*y(35) &
                      + rxt(216)*y(16) + rxt(218)*y(13) + rxt(226)*y(120) + rxt(232) &
                      *y(52) + rxt(238)*y(43) + rxt(246)*y(45) + rxt(259)*y(58) &
                      + rxt(264)*y(61) + rxt(268)*y(64) + rxt(281)*y(71) + rxt(288) &
                      *y(76) + rxt(294)*y(73) + rxt(306)*y(85) + rxt(312)*y(86) &
                      + rxt(318)*y(81) + rxt(322)*y(88) + rxt(329)*y(93) + rxt(337) &
                      *y(97))
         mat(692) = -(rxt(116) + rxt(117) + rxt(118)) * y(21)
         mat(890) = -rxt(121)*y(21)
         mat(1034) = -rxt(127)*y(21)
         mat(1009) = -rxt(128)*y(21)
         mat(1193) = -rxt(139)*y(21)
         mat(931) = -rxt(151)*y(21)
         mat(799) = -rxt(152)*y(21)
         mat(1219) = -(rxt(158) + rxt(159)) * y(21)
         mat(1124) = -rxt(165)*y(21)
         mat(1142) = -rxt(183)*y(21)
         mat(709) = -rxt(187)*y(21)
         mat(766) = -rxt(216)*y(21)
         mat(747) = -rxt(218)*y(21)
         mat(205) = -rxt(226)*y(21)
         mat(287) = -rxt(232)*y(21)
         mat(356) = -rxt(238)*y(21)
         mat(674) = -rxt(246)*y(21)
         mat(391) = -rxt(259)*y(21)
         mat(345) = -rxt(264)*y(21)
         mat(454) = -rxt(268)*y(21)
         mat(314) = -rxt(281)*y(21)
         mat(608) = -rxt(288)*y(21)
         mat(648) = -rxt(294)*y(21)
         mat(631) = -rxt(306)*y(21)
         mat(485) = -rxt(312)*y(21)
         mat(329) = -rxt(318)*y(21)
         mat(570) = -rxt(322)*y(21)
         mat(220) = -rxt(329)*y(21)
         mat(513) = -rxt(337)*y(21)

         mat(1009) = mat(1009) + rxt(120)*y(20) + .190_r8*rxt(256)*y(56) &
                      + .060_r8*rxt(302)*y(80) + .120_r8*rxt(235)*y(41) &
                      + .060_r8*rxt(278)*y(74) + .275_r8*rxt(284)*y(75) + rxt(334) &
                      *y(96)
         mat(1034) = mat(1034) + rxt(215)*y(16) + rxt(130)*y(22)
         mat(498) = rxt(212)*y(20)
         mat(1193) = mat(1193) + rxt(217)*y(13) + rxt(263)*y(61) + rxt(276)*y(70) &
                      + .900_r8*rxt(317)*y(81) + .900_r8*rxt(328)*y(93) + rxt(336) &
                      *y(97) + rxt(304)*y(85) + .470_r8*rxt(285)*y(76) + rxt(237) &
                      *y(43) + rxt(258)*y(58) + .250_r8*rxt(231)*y(52) &
                      + .794_r8*rxt(310)*y(86) + rxt(320)*y(88) + rxt(225)*y(120)
         mat(799) = mat(799) + .700_r8*rxt(332)*y(95)
         mat(890) = mat(890) + rxt(120)*y(1) + rxt(212)*y(17) + rxt(150)*y(8) &
                      + rxt(131)*y(39) + rxt(132)*y(40) + rxt(125)*y(22) + rxt(163) &
                      *y(27) + rxt(186)*y(35) + .500_r8*rxt(300)*y(78) &
                      + .250_r8*rxt(327)*y(91) + rxt(251)*y(50) + .200_r8*rxt(291) &
                      *y(77) + rxt(221)*y(15) + rxt(252)*y(48) + rxt(250)*y(49) &
                      + rxt(271)*y(63) + rxt(314)*y(87) + .350_r8*rxt(228)*y(118) &
                      + rxt(223)*y(119) + .500_r8*rxt(345)*y(122)
         mat(931) = mat(931) + rxt(150)*y(20) + rxt(213)*y(16) + rxt(305)*y(85) &
                      + .470_r8*rxt(287)*y(76) + .794_r8*rxt(311)*y(86) + rxt(315) &
                      *y(87) + rxt(321)*y(88)
         mat(747) = mat(747) + rxt(217)*y(6) + 4.000_r8*rxt(219)*y(13) + rxt(166) &
                      *y(27) + .900_r8*rxt(247)*y(45) + rxt(308)*y(85) &
                      + .730_r8*rxt(289)*y(76) + rxt(295)*y(73) + rxt(239)*y(43) &
                      + rxt(260)*y(58) + .300_r8*rxt(269)*y(64) + .800_r8*rxt(323) &
                      *y(88)
         mat(75) = rxt(131)*y(20)
         mat(34) = rxt(132)*y(20)
         mat(766) = mat(766) + rxt(215)*y(2) + rxt(213)*y(8) + rxt(160)*y(25) &
                      + rxt(184)*y(34)
         mat(1101) = mat(1101) + .794_r8*rxt(312)*y(86)
         mat(269) = rxt(130)*y(2) + rxt(125)*y(20) + rxt(157)*y(25)
         mat(1219) = mat(1219) + rxt(160)*y(16) + rxt(157)*y(22)
         mat(1124) = mat(1124) + rxt(163)*y(20) + rxt(166)*y(13)
         mat(1142) = mat(1142) + rxt(184)*y(16)
         mat(709) = mat(709) + rxt(186)*y(20)
         mat(471) = .190_r8*rxt(256)*y(1)
         mat(413) = .060_r8*rxt(302)*y(1)
         mat(345) = mat(345) + rxt(263)*y(6)
         mat(674) = mat(674) + .900_r8*rxt(247)*y(13) + rxt(309)*y(85) &
                      + .470_r8*rxt(290)*y(76) + rxt(324)*y(88)
         mat(138) = .120_r8*rxt(235)*y(1)
         mat(235) = .500_r8*rxt(300)*y(20)
         mat(110) = rxt(276)*y(6)
         mat(329) = mat(329) + .900_r8*rxt(317)*y(6)
         mat(46) = .250_r8*rxt(327)*y(20)
         mat(220) = mat(220) + .900_r8*rxt(328)*y(6)
         mat(67) = .700_r8*rxt(332)*y(7)
         mat(513) = mat(513) + rxt(336)*y(6)
         mat(296) = rxt(251)*y(20)
         mat(631) = mat(631) + rxt(304)*y(6) + rxt(305)*y(8) + rxt(308)*y(13) &
                      + rxt(309)*y(45)
         mat(588) = .060_r8*rxt(278)*y(1)
         mat(543) = .275_r8*rxt(284)*y(1)
         mat(608) = mat(608) + .470_r8*rxt(285)*y(6) + .470_r8*rxt(287)*y(8) &
                      + .730_r8*rxt(289)*y(13) + .470_r8*rxt(290)*y(45)
         mat(121) = .200_r8*rxt(291)*y(20)
         mat(648) = mat(648) + rxt(295)*y(13)
         mat(356) = mat(356) + rxt(237)*y(6) + rxt(239)*y(13) + 2.400_r8*rxt(240) &
                      *y(43)
         mat(279) = rxt(334)*y(1)
         mat(391) = mat(391) + rxt(258)*y(6) + rxt(260)*y(13)
         mat(239) = rxt(221)*y(20)
         mat(88) = rxt(252)*y(20)
         mat(372) = rxt(250)*y(20)
         mat(520) = rxt(271)*y(20)
         mat(287) = mat(287) + .250_r8*rxt(231)*y(6)
         mat(454) = mat(454) + .300_r8*rxt(269)*y(13)
         mat(485) = mat(485) + .794_r8*rxt(310)*y(6) + .794_r8*rxt(311)*y(8) &
                      + .794_r8*rxt(312)*y(21)
         mat(442) = rxt(314)*y(20) + rxt(315)*y(8)
         mat(570) = mat(570) + rxt(320)*y(6) + rxt(321)*y(8) + .800_r8*rxt(323)*y(13) &
                      + rxt(324)*y(45)
         mat(61) = .350_r8*rxt(228)*y(20)
         mat(167) = rxt(223)*y(20)
         mat(205) = mat(205) + rxt(225)*y(6)
         mat(84) = .500_r8*rxt(345)*y(20)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(264) = -(rxt(125)*y(20) + rxt(130)*y(2) + rxt(157)*y(25))
         mat(843) = -rxt(125)*y(22)
         mat(1015) = -rxt(130)*y(22)
         mat(1200) = -rxt(157)*y(22)

         mat(843) = mat(843) + 2.000_r8*rxt(123)*y(20)
         mat(1058) = 2.000_r8*rxt(129)*y(21)

         mat(677) = -(rxt(87)*y(3))
         mat(939) = -rxt(87)*y(145)

         mat(488) = rxt(124)*y(20)
         mat(878) = rxt(124)*y(18) + 2.000_r8*rxt(122)*y(20) + rxt(147)*y(9) &
                      + rxt(153)*y(10) + rxt(222)*y(14) + rxt(214)*y(16) + rxt(121) &
                      *y(21) + rxt(125)*y(22) + rxt(174)*y(30) + rxt(178)*y(31) &
                      + rxt(194)*y(36) + rxt(242)*y(47) + rxt(236)*y(46) + rxt(265) &
                      *y(62) + rxt(249)*y(51) + rxt(229)*y(42) + .500_r8*rxt(283) &
                      *y(75) + rxt(262)*y(57) + rxt(261)*y(59) + rxt(266)*y(60) &
                      + rxt(270)*y(66) + rxt(272)*y(65) + (rxt(325)+rxt(326))*y(89) &
                      + rxt(223)*y(119) + rxt(347)*y(123)
         mat(394) = rxt(147)*y(20)
         mat(169) = rxt(153)*y(20)
         mat(175) = rxt(222)*y(20)
         mat(756) = rxt(214)*y(20)
         mat(685) = rxt(118)*y(21)
         mat(1089) = rxt(121)*y(20) + rxt(118)*y(19)
         mat(265) = rxt(125)*y(20)
         mat(961) = rxt(174)*y(20) + (rxt(353)+rxt(358)+rxt(364))*y(31) + (rxt(354) &
                       +rxt(365))*y(37)
         mat(416) = rxt(178)*y(20) + (rxt(353)+rxt(358)+rxt(364))*y(30)
         mat(374) = rxt(194)*y(20)
         mat(360) = (rxt(354)+rxt(365))*y(30)
         mat(525) = rxt(242)*y(20)
         mat(290) = rxt(236)*y(20)
         mat(244) = rxt(265)*y(20)
         mat(209) = rxt(249)*y(20)
         mat(95) = rxt(229)*y(20)
         mat(538) = .500_r8*rxt(283)*y(20)
         mat(37) = rxt(262)*y(20)
         mat(151) = rxt(261)*y(20)
         mat(334) = rxt(266)*y(20)
         mat(157) = rxt(270)*y(20)
         mat(548) = rxt(272)*y(20)
         mat(129) = (rxt(325)+rxt(326))*y(20)
         mat(165) = rxt(223)*y(20)
         mat(30) = rxt(347)*y(20)

         mat(1223) = -(rxt(155)*y(1) + rxt(156)*y(18) + rxt(157)*y(22) + (rxt(158) &
                      + rxt(159)) * y(21) + rxt(160)*y(16) + rxt(177)*y(31) + rxt(181) &
                      *y(32) + rxt(227)*y(42))
         mat(1013) = -rxt(155)*y(25)
         mat(494) = -rxt(156)*y(25)
         mat(270) = -rxt(157)*y(25)
         mat(1105) = -(rxt(158) + rxt(159)) * y(25)
         mat(769) = -rxt(160)*y(25)
         mat(421) = -rxt(177)*y(25)
         mat(433) = -rxt(181)*y(25)
         mat(98) = -rxt(227)*y(25)

         mat(1038) = rxt(162)*y(27) + rxt(175)*y(30)
         mat(954) = rxt(111)*y(30)
         mat(1197) = rxt(167)*y(27)
         mat(894) = rxt(163)*y(27) + rxt(174)*y(30)
         mat(750) = rxt(166)*y(27)
         mat(1128) = rxt(162)*y(2) + rxt(167)*y(6) + rxt(163)*y(20) + rxt(166)*y(13) + ( &
                      + 4.000_r8*rxt(169)+2.000_r8*rxt(171))*y(27) + rxt(191)*y(35)
         mat(975) = rxt(175)*y(2) + rxt(111)*y(3) + rxt(174)*y(20)
         mat(713) = rxt(191)*y(27)


         mat(1198) = rxt(181)*y(32)
         mat(1108) = 2.000_r8*rxt(170)*y(27)
         mat(955) = (rxt(353)+rxt(358)+rxt(364))*y(31) + (rxt(352)+rxt(357)+rxt(363)) &
                      *y(32)
         mat(414) = (rxt(353)+rxt(358)+rxt(364))*y(30)
         mat(422) = rxt(181)*y(25) + (rxt(352)+rxt(357)+rxt(363))*y(30)

         mat(1125) = -(rxt(162)*y(2) + (rxt(163) + rxt(164)) * y(20) + rxt(165)*y(21) &
                      + rxt(166)*y(13) + rxt(167)*y(6) + rxt(168)*y(7) + (4._r8*rxt(169) &
                      + 4._r8*rxt(170) + 4._r8*rxt(171) + 4._r8*rxt(172)) * y(27) &
                      + (rxt(190) + rxt(191) + rxt(192)) * y(35))
         mat(1035) = -rxt(162)*y(27)
         mat(891) = -(rxt(163) + rxt(164)) * y(27)
         mat(1102) = -rxt(165)*y(27)
         mat(748) = -rxt(166)*y(27)
         mat(1194) = -rxt(167)*y(27)
         mat(800) = -rxt(168)*y(27)
         mat(710) = -(rxt(190) + rxt(191) + rxt(192)) * y(27)

         mat(1010) = rxt(155)*y(25)
         mat(1035) = mat(1035) + rxt(176)*y(31) + rxt(179)*y(32)
         mat(891) = mat(891) + rxt(178)*y(31)
         mat(1102) = mat(1102) + rxt(159)*y(25)
         mat(1220) = rxt(155)*y(1) + rxt(159)*y(21) + rxt(177)*y(31)
         mat(420) = rxt(176)*y(2) + rxt(178)*y(20) + rxt(177)*y(25)
         mat(432) = rxt(179)*y(2)


         mat(1107) = 2.000_r8*rxt(171)*y(27) + rxt(190)*y(35)
         mat(694) = rxt(190)*y(27)


         mat(1106) = 2.000_r8*rxt(172)*y(27)

         mat(968) = -(rxt(111)*y(3) + rxt(174)*y(20) + rxt(175)*y(2) + (rxt(352) &
                      + rxt(357) + rxt(363)) * y(32) + (rxt(353) + rxt(358) + rxt(364) &
                      ) * y(31) + (rxt(354) + rxt(365)) * y(37))
         mat(947) = -rxt(111)*y(30)
         mat(887) = -rxt(174)*y(30)
         mat(1031) = -rxt(175)*y(30)
         mat(430) = -(rxt(352) + rxt(357) + rxt(363)) * y(30)
         mat(418) = -(rxt(353) + rxt(358) + rxt(364)) * y(30)
         mat(363) = -(rxt(354) + rxt(365)) * y(30)

         mat(492) = rxt(156)*y(25)
         mat(887) = mat(887) + rxt(164)*y(27)
         mat(763) = rxt(160)*y(25)
         mat(1098) = rxt(158)*y(25)
         mat(267) = rxt(157)*y(25)
         mat(1216) = rxt(156)*y(18) + rxt(160)*y(16) + rxt(158)*y(21) + rxt(157)*y(22) &
                      + rxt(177)*y(31) + rxt(227)*y(42)
         mat(1121) = rxt(164)*y(20)
         mat(418) = mat(418) + rxt(177)*y(25)
         mat(97) = rxt(227)*y(25)

         mat(415) = -(rxt(176)*y(2) + rxt(177)*y(25) + rxt(178)*y(20) + (rxt(353) &
                      + rxt(358) + rxt(364)) * y(30))
         mat(1019) = -rxt(176)*y(31)
         mat(1202) = -rxt(177)*y(31)
         mat(859) = -rxt(178)*y(31)
         mat(959) = -(rxt(353) + rxt(358) + rxt(364)) * y(31)

         mat(859) = mat(859) + rxt(180)*y(32)
         mat(1072) = rxt(165)*y(27)
         mat(1110) = rxt(165)*y(21)
         mat(424) = rxt(180)*y(20)

         mat(425) = -(rxt(179)*y(2) + rxt(180)*y(20) + rxt(181)*y(25) + (rxt(352) &
                      + rxt(357) + rxt(363)) * y(30))
         mat(1020) = -rxt(179)*y(32)
         mat(860) = -rxt(180)*y(32)
         mat(1203) = -rxt(181)*y(32)
         mat(960) = -(rxt(352) + rxt(357) + rxt(363)) * y(32)

         mat(781) = rxt(168)*y(27)
         mat(1111) = rxt(168)*y(7)


         mat(1109) = rxt(192)*y(35)
         mat(956) = (rxt(354)+rxt(365))*y(37)
         mat(695) = rxt(192)*y(27)
         mat(358) = (rxt(354)+rxt(365))*y(30)

         mat(1144) = -(rxt(182)*y(1) + rxt(183)*y(21) + rxt(184)*y(16))
         mat(1011) = -rxt(182)*y(34)
         mat(1103) = -rxt(183)*y(34)
         mat(767) = -rxt(184)*y(34)

         mat(1036) = rxt(185)*y(35) + rxt(195)*y(36)
         mat(952) = rxt(112)*y(36)
         mat(1195) = rxt(188)*y(35)
         mat(892) = rxt(186)*y(35) + rxt(194)*y(36)
         mat(1126) = (rxt(190)+rxt(191))*y(35)
         mat(711) = rxt(185)*y(2) + rxt(188)*y(6) + rxt(186)*y(20) + (rxt(190) &
                       +rxt(191))*y(27) + 4.000_r8*rxt(193)*y(35)
         mat(379) = rxt(195)*y(2) + rxt(112)*y(3) + rxt(194)*y(20)

         mat(701) = -(rxt(185)*y(2) + rxt(186)*y(20) + rxt(187)*y(21) + rxt(188)*y(6) &
                      + rxt(189)*y(7) + (rxt(190) + rxt(191) + rxt(192)) * y(27) &
                      + 4._r8*rxt(193)*y(35))
         mat(1025) = -rxt(185)*y(35)
         mat(880) = -rxt(186)*y(35)
         mat(1091) = -rxt(187)*y(35)
         mat(1183) = -rxt(188)*y(35)
         mat(789) = -rxt(189)*y(35)
         mat(1114) = -(rxt(190) + rxt(191) + rxt(192)) * y(35)

         mat(999) = rxt(182)*y(34)
         mat(1025) = mat(1025) + rxt(196)*y(37) + rxt(197)*y(38)
         mat(1133) = rxt(182)*y(1)
         mat(361) = rxt(196)*y(2)
         mat(259) = rxt(197)*y(2)

         mat(373) = -(rxt(112)*y(3) + rxt(194)*y(20) + rxt(195)*y(2))
         mat(937) = -rxt(112)*y(36)
         mat(855) = -rxt(194)*y(36)
         mat(1017) = -rxt(195)*y(36)

         mat(752) = rxt(184)*y(34)
         mat(1070) = rxt(183)*y(34)
         mat(1129) = rxt(184)*y(16) + rxt(183)*y(21)

         mat(359) = -(rxt(196)*y(2) + (rxt(354) + rxt(365)) * y(30))
         mat(1016) = -rxt(196)*y(37)
         mat(957) = -(rxt(354) + rxt(365)) * y(37)

         mat(1068) = rxt(187)*y(35)
         mat(697) = rxt(187)*y(21)

         mat(256) = -(rxt(197)*y(2))
         mat(1014) = -rxt(197)*y(38)

         mat(777) = rxt(189)*y(35)
         mat(696) = rxt(189)*y(7)

         mat(459) = -(rxt(255)*y(20) + rxt(256)*y(1) + rxt(257)*y(8))
         mat(863) = -rxt(255)*y(56)
         mat(983) = -rxt(256)*y(56)
         mat(906) = -rxt(257)*y(56)

         mat(983) = mat(983) + .070_r8*rxt(302)*y(80)
         mat(400) = .070_r8*rxt(302)*y(1)

         mat(399) = -(rxt(301)*y(20) + rxt(302)*y(1) + rxt(303)*y(8))
         mat(858) = -rxt(301)*y(80)
         mat(982) = -rxt(302)*y(80)
         mat(904) = -rxt(303)*y(80)

         mat(338) = -(rxt(263)*y(6) + rxt(264)*y(21))
         mat(1162) = -rxt(263)*y(61)
         mat(1066) = -rxt(264)*y(61)

         mat(852) = rxt(255)*y(56) + .500_r8*rxt(265)*y(62)
         mat(458) = rxt(255)*y(20)
         mat(241) = .500_r8*rxt(265)*y(20)

         mat(523) = -(rxt(242)*y(20) + rxt(243)*y(8))
         mat(869) = -rxt(242)*y(47)
         mat(911) = -rxt(243)*y(47)

         mat(988) = .500_r8*rxt(256)*y(56) + .040_r8*rxt(278)*y(74)
         mat(1172) = rxt(263)*y(61) + rxt(276)*y(70) + .400_r8*rxt(317)*y(81) &
                      + rxt(280)*y(71) + rxt(237)*y(43) + .270_r8*rxt(258)*y(58)
         mat(869) = mat(869) + .500_r8*rxt(241)*y(44) + rxt(252)*y(48)
         mat(727) = .800_r8*rxt(239)*y(43)
         mat(462) = .500_r8*rxt(256)*y(1)
         mat(340) = rxt(263)*y(6)
         mat(107) = rxt(276)*y(6)
         mat(323) = .400_r8*rxt(317)*y(6)
         mat(310) = rxt(280)*y(6)
         mat(575) = .040_r8*rxt(278)*y(1)
         mat(351) = rxt(237)*y(6) + .800_r8*rxt(239)*y(13) + 3.200_r8*rxt(240)*y(43)
         mat(124) = .500_r8*rxt(241)*y(20)
         mat(384) = .270_r8*rxt(258)*y(6)
         mat(86) = rxt(252)*y(20)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(289) = -(rxt(236)*y(20))
         mat(846) = -rxt(236)*y(46)

         mat(980) = .250_r8*rxt(256)*y(56) + .200_r8*rxt(302)*y(80)
         mat(718) = .100_r8*rxt(247)*y(45)
         mat(1060) = .250_r8*rxt(246)*y(45) + .250_r8*rxt(294)*y(73)
         mat(457) = .250_r8*rxt(256)*y(1)
         mat(398) = .200_r8*rxt(302)*y(1)
         mat(653) = .100_r8*rxt(247)*y(13) + .250_r8*rxt(246)*y(21)
         mat(635) = .250_r8*rxt(294)*y(21)

         mat(240) = -(rxt(265)*y(20))
         mat(841) = -rxt(265)*y(62)

         mat(1056) = rxt(264)*y(61)
         mat(337) = rxt(264)*y(21)

         mat(665) = -(rxt(244)*y(6) + rxt(245)*y(7) + rxt(246)*y(21) + rxt(247)*y(13) &
                      + 4._r8*rxt(248)*y(45) + rxt(290)*y(76) + rxt(309)*y(85) + rxt(324) &
                      *y(88))
         mat(1180) = -rxt(244)*y(45)
         mat(786) = -rxt(245)*y(45)
         mat(1088) = -rxt(246)*y(45)
         mat(735) = -rxt(247)*y(45)
         mat(600) = -rxt(290)*y(45)
         mat(622) = -rxt(309)*y(45)
         mat(562) = -rxt(324)*y(45)

         mat(1180) = mat(1180) + rxt(280)*y(71) + .530_r8*rxt(285)*y(76) + rxt(292) &
                      *y(73) + rxt(267)*y(64)
         mat(877) = rxt(242)*y(47) + .500_r8*rxt(249)*y(51) + rxt(272)*y(65)
         mat(919) = rxt(243)*y(47) + .530_r8*rxt(287)*y(76) + rxt(293)*y(73) &
                      + rxt(273)*y(65)
         mat(735) = mat(735) + .260_r8*rxt(289)*y(76) + rxt(295)*y(73) &
                      + .300_r8*rxt(269)*y(64)
         mat(524) = rxt(242)*y(20) + rxt(243)*y(8)
         mat(665) = mat(665) + .530_r8*rxt(290)*y(76)
         mat(208) = .500_r8*rxt(249)*y(20)
         mat(311) = rxt(280)*y(6)
         mat(600) = mat(600) + .530_r8*rxt(285)*y(6) + .530_r8*rxt(287)*y(8) &
                      + .260_r8*rxt(289)*y(13) + .530_r8*rxt(290)*y(45)
         mat(639) = rxt(292)*y(6) + rxt(293)*y(8) + rxt(295)*y(13) + 4.000_r8*rxt(297) &
                      *y(73)
         mat(448) = rxt(267)*y(6) + .300_r8*rxt(269)*y(13)
         mat(547) = rxt(272)*y(20) + rxt(273)*y(8)

         mat(207) = -(rxt(249)*y(20))
         mat(836) = -rxt(249)*y(51)

         mat(1053) = .750_r8*rxt(246)*y(45) + .750_r8*rxt(294)*y(73)
         mat(652) = .750_r8*rxt(246)*y(21)
         mat(633) = .750_r8*rxt(294)*y(21)

         mat(192) = -(rxt(254)*y(20))
         mat(835) = -rxt(254)*y(55)

         mat(774) = rxt(245)*y(45)
         mat(651) = rxt(245)*y(7)

         mat(160) = -(rxt(274)*y(20))
         mat(829) = -rxt(274)*y(79)

         mat(1151) = .100_r8*rxt(317)*y(81)
         mat(899) = rxt(257)*y(56)
         mat(456) = rxt(257)*y(8)
         mat(316) = .100_r8*rxt(317)*y(6)

         mat(93) = -(rxt(227)*y(25) + rxt(229)*y(20))
         mat(1199) = -rxt(227)*y(42)
         mat(818) = -rxt(229)*y(42)

         mat(131) = -(rxt(230)*y(20) + rxt(235)*y(1))
         mat(824) = -rxt(230)*y(41)
         mat(976) = -rxt(235)*y(41)

         mat(23) = -(rxt(313)*y(20))
         mat(805) = -rxt(313)*y(68)

         mat(228) = -(rxt(300)*y(20))
         mat(839) = -rxt(300)*y(78)

         mat(776) = rxt(298)*y(73)
         mat(634) = rxt(298)*y(7)

         mat(26) = -(rxt(275)*y(20))
         mat(806) = -rxt(275)*y(67)

         mat(105) = -(rxt(276)*y(6))
         mat(1149) = -rxt(276)*y(70)

         mat(819) = rxt(275)*y(67)
         mat(27) = rxt(275)*y(20)

         mat(320) = -(rxt(317)*y(6) + rxt(318)*y(21))
         mat(1160) = -rxt(317)*y(81)
         mat(1064) = -rxt(318)*y(81)

         mat(850) = rxt(313)*y(68) + rxt(319)*y(82)
         mat(24) = rxt(313)*y(20)
         mat(300) = rxt(319)*y(20)

         mat(298) = -(rxt(319)*y(20))
         mat(848) = -rxt(319)*y(82)

         mat(1062) = rxt(318)*y(81)
         mat(318) = rxt(318)*y(21)

         mat(180) = -(rxt(279)*y(20))
         mat(833) = -rxt(279)*y(69)

         mat(1153) = .800_r8*rxt(317)*y(81)
         mat(317) = .800_r8*rxt(317)*y(6)

         mat(309) = -(rxt(280)*y(6) + rxt(281)*y(21))
         mat(1159) = -rxt(280)*y(71)
         mat(1063) = -rxt(281)*y(71)

         mat(849) = rxt(279)*y(69) + rxt(282)*y(72)
         mat(181) = rxt(279)*y(20)
         mat(113) = rxt(282)*y(20)

         mat(112) = -(rxt(282)*y(20))
         mat(820) = -rxt(282)*y(72)

         mat(1041) = rxt(281)*y(71)
         mat(308) = rxt(281)*y(21)

         mat(42) = -(rxt(327)*y(20))
         mat(811) = -rxt(327)*y(91)

         mat(47) = -(rxt(331)*y(20))
         mat(812) = -rxt(331)*y(92)

         mat(812) = mat(812) + .250_r8*rxt(327)*y(91)
         mat(43) = .250_r8*rxt(327)*y(20)

         mat(214) = -(rxt(328)*y(6) + rxt(329)*y(21))
         mat(1155) = -rxt(328)*y(93)
         mat(1054) = -rxt(329)*y(93)

         mat(837) = .700_r8*rxt(327)*y(91) + rxt(330)*y(94)
         mat(44) = .700_r8*rxt(327)*y(20)
         mat(143) = rxt(330)*y(20)

         mat(142) = -(rxt(330)*y(20))
         mat(826) = -rxt(330)*y(94)

         mat(1045) = rxt(329)*y(93)
         mat(213) = rxt(329)*y(21)

         mat(64) = -(rxt(332)*y(7))
         mat(770) = -rxt(332)*y(95)

         mat(814) = rxt(331)*y(92)
         mat(48) = rxt(331)*y(20)

         mat(502) = -(rxt(336)*y(6) + rxt(337)*y(21))
         mat(1170) = -rxt(336)*y(97)
         mat(1078) = -rxt(337)*y(97)

         mat(867) = rxt(338)*y(98) + rxt(333)*y(96)
         mat(909) = rxt(335)*y(96)
         mat(187) = rxt(338)*y(20)
         mat(272) = rxt(333)*y(20) + rxt(335)*y(8)

         mat(185) = -(rxt(338)*y(20))
         mat(834) = -rxt(338)*y(98)

         mat(1051) = rxt(337)*y(97)
         mat(499) = rxt(337)*y(21)


         mat(1156) = .900_r8*rxt(328)*y(93)
         mat(775) = .700_r8*rxt(332)*y(95)
         mat(215) = .900_r8*rxt(328)*y(6)
         mat(65) = .700_r8*rxt(332)*y(7)

         mat(293) = -(rxt(251)*y(20))
         mat(847) = -rxt(251)*y(50)

         mat(1158) = .450_r8*rxt(328)*y(93) + .250_r8*rxt(320)*y(88)
         mat(847) = mat(847) + .200_r8*rxt(250)*y(49) + .650_r8*rxt(228)*y(118)
         mat(901) = .250_r8*rxt(321)*y(88)
         mat(719) = .100_r8*rxt(323)*y(88)
         mat(654) = .250_r8*rxt(324)*y(88)
         mat(216) = .450_r8*rxt(328)*y(6)
         mat(367) = .200_r8*rxt(250)*y(20)
         mat(556) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)
         mat(58) = .650_r8*rxt(228)*y(20)

         mat(620) = -(rxt(304)*y(6) + rxt(305)*y(8) + rxt(306)*y(21) + rxt(308)*y(13) &
                      + rxt(309)*y(45))
         mat(1178) = -rxt(304)*y(85)
         mat(917) = -rxt(305)*y(85)
         mat(1086) = -rxt(306)*y(85)
         mat(733) = -rxt(308)*y(85)
         mat(663) = -rxt(309)*y(85)

         mat(875) = rxt(301)*y(80) + .200_r8*rxt(307)*y(90)
         mat(405) = rxt(301)*y(20)
         mat(252) = .200_r8*rxt(307)*y(20)

         mat(577) = -(rxt(277)*y(20) + rxt(278)*y(1))
         mat(873) = -rxt(277)*y(74)
         mat(992) = -rxt(278)*y(74)

         mat(992) = mat(992) + .200_r8*rxt(302)*y(80) + rxt(334)*y(96)
         mat(1176) = rxt(336)*y(97) + .320_r8*rxt(304)*y(85) + .039_r8*rxt(310)*y(86)
         mat(915) = .350_r8*rxt(305)*y(85) + .039_r8*rxt(311)*y(86)
         mat(731) = .260_r8*rxt(308)*y(85)
         mat(1084) = .039_r8*rxt(312)*y(86)
         mat(404) = .200_r8*rxt(302)*y(1)
         mat(661) = .350_r8*rxt(309)*y(85)
         mat(506) = rxt(336)*y(6)
         mat(618) = .320_r8*rxt(304)*y(6) + .350_r8*rxt(305)*y(8) + .260_r8*rxt(308) &
                      *y(13) + .350_r8*rxt(309)*y(45)
         mat(274) = rxt(334)*y(1)
         mat(479) = .039_r8*rxt(310)*y(6) + .039_r8*rxt(311)*y(8) + .039_r8*rxt(312) &
                      *y(21)

         mat(533) = -(rxt(283)*y(20) + rxt(284)*y(1))
         mat(870) = -rxt(283)*y(75)
         mat(989) = -rxt(284)*y(75)

         mat(989) = mat(989) + .400_r8*rxt(302)*y(80) + rxt(334)*y(96)
         mat(1173) = rxt(336)*y(97) + .230_r8*rxt(304)*y(85) + .167_r8*rxt(310)*y(86)
         mat(912) = .250_r8*rxt(305)*y(85) + .167_r8*rxt(311)*y(86)
         mat(728) = .190_r8*rxt(308)*y(85)
         mat(1081) = .167_r8*rxt(312)*y(86)
         mat(403) = .400_r8*rxt(302)*y(1)
         mat(658) = .250_r8*rxt(309)*y(85)
         mat(504) = rxt(336)*y(6)
         mat(615) = .230_r8*rxt(304)*y(6) + .250_r8*rxt(305)*y(8) + .190_r8*rxt(308) &
                      *y(13) + .250_r8*rxt(309)*y(45)
         mat(273) = rxt(334)*y(1)
         mat(477) = .167_r8*rxt(310)*y(6) + .167_r8*rxt(311)*y(8) + .167_r8*rxt(312) &
                      *y(21)

         mat(598) = -((rxt(285) + rxt(286)) * y(6) + rxt(287)*y(8) + rxt(288)*y(21) &
                      + rxt(289)*y(13) + rxt(290)*y(45))
         mat(1177) = -(rxt(285) + rxt(286)) * y(76)
         mat(916) = -rxt(287)*y(76)
         mat(1085) = -rxt(288)*y(76)
         mat(732) = -rxt(289)*y(76)
         mat(662) = -rxt(290)*y(76)

         mat(874) = rxt(277)*y(74) + .500_r8*rxt(283)*y(75) + .200_r8*rxt(291)*y(77)
         mat(578) = rxt(277)*y(20)
         mat(535) = .500_r8*rxt(283)*y(20)
         mat(118) = .200_r8*rxt(291)*y(20)

         mat(117) = -(rxt(291)*y(20))
         mat(821) = -rxt(291)*y(77)

         mat(1042) = rxt(288)*y(76)
         mat(590) = rxt(288)*y(21)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(638) = -(rxt(292)*y(6) + rxt(293)*y(8) + rxt(294)*y(21) + rxt(295)*y(13) &
                      + rxt(296)*y(45) + 4._r8*rxt(297)*y(73) + rxt(298)*y(7))
         mat(1179) = -rxt(292)*y(73)
         mat(918) = -rxt(293)*y(73)
         mat(1087) = -rxt(294)*y(73)
         mat(734) = -rxt(295)*y(73)
         mat(664) = -rxt(296)*y(73)
         mat(785) = -rxt(298)*y(73)

         mat(995) = .200_r8*rxt(302)*y(80)
         mat(876) = .500_r8*rxt(283)*y(75) + .500_r8*rxt(291)*y(77)
         mat(406) = .200_r8*rxt(302)*y(1)
         mat(536) = .500_r8*rxt(283)*y(20)
         mat(119) = .500_r8*rxt(291)*y(20)

         mat(350) = -(rxt(237)*y(6) + rxt(238)*y(21) + rxt(239)*y(13) + 4._r8*rxt(240) &
                      *y(43))
         mat(1163) = -rxt(237)*y(43)
         mat(1067) = -rxt(238)*y(43)
         mat(721) = -rxt(239)*y(43)

         mat(853) = rxt(229)*y(42) + .500_r8*rxt(241)*y(44)
         mat(1201) = rxt(227)*y(42)
         mat(94) = rxt(229)*y(20) + rxt(227)*y(25)
         mat(123) = .500_r8*rxt(241)*y(20)

         mat(122) = -(rxt(241)*y(20))
         mat(822) = -rxt(241)*y(44)

         mat(1043) = rxt(238)*y(43)
         mat(348) = rxt(238)*y(21)

         mat(271) = -(rxt(333)*y(20) + rxt(334)*y(1) + rxt(335)*y(8))
         mat(844) = -rxt(333)*y(96)
         mat(978) = -rxt(334)*y(96)
         mat(900) = -rxt(335)*y(96)

         mat(35) = -(rxt(262)*y(20))
         mat(809) = -rxt(262)*y(57)

         mat(382) = -(rxt(258)*y(6) + rxt(259)*y(21) + rxt(260)*y(13))
         mat(1165) = -rxt(258)*y(58)
         mat(1071) = -rxt(259)*y(58)
         mat(723) = -rxt(260)*y(58)

         mat(856) = rxt(262)*y(57) + rxt(261)*y(59)
         mat(36) = rxt(262)*y(20)
         mat(150) = rxt(261)*y(20)

         mat(148) = -(rxt(261)*y(20))
         mat(827) = -rxt(261)*y(59)

         mat(1046) = rxt(259)*y(58)
         mat(380) = rxt(259)*y(21)

         mat(331) = -(rxt(266)*y(20))
         mat(851) = -rxt(266)*y(60)

         mat(1161) = .500_r8*rxt(276)*y(70) + .250_r8*rxt(317)*y(81) &
                      + .100_r8*rxt(336)*y(97) + .820_r8*rxt(258)*y(58)
         mat(720) = .820_r8*rxt(260)*y(58)
         mat(106) = .500_r8*rxt(276)*y(6)
         mat(321) = .250_r8*rxt(317)*y(6)
         mat(500) = .100_r8*rxt(336)*y(6)
         mat(381) = .820_r8*rxt(258)*y(6) + .820_r8*rxt(260)*y(13)

         mat(154) = -(rxt(270)*y(20))
         mat(828) = -rxt(270)*y(66)

         mat(1047) = rxt(268)*y(64)
         mat(443) = rxt(268)*y(21)

         mat(236) = -(rxt(221)*y(20))
         mat(840) = -rxt(221)*y(15)

         mat(717) = 2.000_r8*rxt(220)*y(13) + .250_r8*rxt(308)*y(85) &
                      + .250_r8*rxt(289)*y(76) + .300_r8*rxt(239)*y(43) &
                      + .500_r8*rxt(269)*y(64) + .300_r8*rxt(323)*y(88)
         mat(611) = .250_r8*rxt(308)*y(13)
         mat(591) = .250_r8*rxt(289)*y(13)
         mat(349) = .300_r8*rxt(239)*y(13)
         mat(444) = .500_r8*rxt(269)*y(13)
         mat(555) = .300_r8*rxt(323)*y(13)

         mat(85) = -(rxt(252)*y(20))
         mat(817) = -rxt(252)*y(48)

         mat(714) = .200_r8*rxt(239)*y(43)
         mat(347) = .200_r8*rxt(239)*y(13) + .800_r8*rxt(240)*y(43)

         mat(368) = -(rxt(250)*y(20))
         mat(854) = -rxt(250)*y(49)

         mat(1164) = .530_r8*rxt(285)*y(76) + .250_r8*rxt(320)*y(88)
         mat(902) = .530_r8*rxt(287)*y(76) + .250_r8*rxt(321)*y(88)
         mat(722) = .260_r8*rxt(289)*y(76) + .100_r8*rxt(323)*y(88)
         mat(655) = .530_r8*rxt(290)*y(76) + .250_r8*rxt(324)*y(88)
         mat(592) = .530_r8*rxt(285)*y(6) + .530_r8*rxt(287)*y(8) + .260_r8*rxt(289) &
                      *y(13) + .530_r8*rxt(290)*y(45)
         mat(557) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)

         mat(515) = -(rxt(271)*y(20))
         mat(868) = -rxt(271)*y(63)

         mat(1171) = .220_r8*rxt(285)*y(76) + .250_r8*rxt(320)*y(88)
         mat(868) = mat(868) + .500_r8*rxt(265)*y(62) + .500_r8*rxt(300)*y(78)
         mat(910) = .220_r8*rxt(287)*y(76) + .250_r8*rxt(321)*y(88)
         mat(726) = .230_r8*rxt(289)*y(76) + .200_r8*rxt(269)*y(64) + .100_r8*rxt(323) &
                      *y(88)
         mat(242) = .500_r8*rxt(265)*y(20)
         mat(657) = .220_r8*rxt(290)*y(76) + .250_r8*rxt(324)*y(88)
         mat(229) = .500_r8*rxt(300)*y(20)
         mat(595) = .220_r8*rxt(285)*y(6) + .220_r8*rxt(287)*y(8) + .230_r8*rxt(289) &
                      *y(13) + .220_r8*rxt(290)*y(45)
         mat(446) = .200_r8*rxt(269)*y(13)
         mat(559) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)

         mat(282) = -(rxt(231)*y(6) + rxt(232)*y(21))
         mat(1157) = -rxt(231)*y(52)
         mat(1059) = -rxt(232)*y(52)

         mat(845) = rxt(230)*y(41)
         mat(133) = rxt(230)*y(20)


         mat(1148) = .750_r8*rxt(231)*y(52)
         mat(281) = .750_r8*rxt(231)*y(6)


         mat(1039) = rxt(232)*y(52)
         mat(280) = rxt(232)*y(21)

         mat(139) = -(rxt(316)*y(20))
         mat(825) = -rxt(316)*y(84)

         mat(1150) = .370_r8*rxt(304)*y(85)
         mat(825) = mat(825) + rxt(314)*y(87)
         mat(898) = .400_r8*rxt(305)*y(85) + rxt(315)*y(87)
         mat(715) = .300_r8*rxt(308)*y(85)
         mat(650) = .400_r8*rxt(309)*y(85)
         mat(610) = .370_r8*rxt(304)*y(6) + .400_r8*rxt(305)*y(8) + .300_r8*rxt(308) &
                      *y(13) + .400_r8*rxt(309)*y(45)
         mat(434) = rxt(314)*y(20) + rxt(315)*y(8)

         mat(445) = -(rxt(267)*y(6) + rxt(268)*y(21) + rxt(269)*y(13))
         mat(1167) = -rxt(267)*y(64)
         mat(1074) = -rxt(268)*y(64)
         mat(724) = -rxt(269)*y(64)

         mat(862) = rxt(266)*y(60) + rxt(270)*y(66)
         mat(332) = rxt(266)*y(20)
         mat(155) = rxt(270)*y(20)

         mat(546) = -(rxt(272)*y(20) + rxt(273)*y(8))
         mat(871) = -rxt(272)*y(65)
         mat(913) = -rxt(273)*y(65)

         mat(990) = .950_r8*rxt(278)*y(74) + .800_r8*rxt(284)*y(75)
         mat(1174) = .450_r8*rxt(328)*y(93) + .250_r8*rxt(285)*y(76) &
                      + .250_r8*rxt(320)*y(88)
         mat(871) = mat(871) + rxt(274)*y(79) + rxt(271)*y(63)
         mat(913) = mat(913) + .250_r8*rxt(287)*y(76) + .250_r8*rxt(321)*y(88)
         mat(729) = .240_r8*rxt(289)*y(76) + .500_r8*rxt(269)*y(64) + .100_r8*rxt(323) &
                      *y(88)
         mat(659) = .250_r8*rxt(290)*y(76) + .250_r8*rxt(324)*y(88)
         mat(161) = rxt(274)*y(20)
         mat(217) = .450_r8*rxt(328)*y(6)
         mat(576) = .950_r8*rxt(278)*y(1)
         mat(534) = .800_r8*rxt(284)*y(1)
         mat(596) = .250_r8*rxt(285)*y(6) + .250_r8*rxt(287)*y(8) + .240_r8*rxt(289) &
                      *y(13) + .250_r8*rxt(290)*y(45)
         mat(516) = rxt(271)*y(20)
         mat(447) = .500_r8*rxt(269)*y(13)
         mat(560) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)

         mat(475) = -(rxt(310)*y(6) + rxt(311)*y(8) + rxt(312)*y(21))
         mat(1168) = -rxt(310)*y(86)
         mat(907) = -rxt(311)*y(86)
         mat(1075) = -rxt(312)*y(86)

         mat(907) = mat(907) + rxt(303)*y(80)
         mat(401) = rxt(303)*y(8)

         mat(435) = -(rxt(314)*y(20) + rxt(315)*y(8))
         mat(861) = -rxt(314)*y(87)
         mat(905) = -rxt(315)*y(87)

         mat(1166) = .080_r8*rxt(304)*y(85) + .800_r8*rxt(286)*y(76) &
                      + .794_r8*rxt(310)*y(86)
         mat(905) = mat(905) + .794_r8*rxt(311)*y(86)
         mat(1073) = .794_r8*rxt(312)*y(86)
         mat(613) = .080_r8*rxt(304)*y(6)
         mat(593) = .800_r8*rxt(286)*y(6)
         mat(474) = .794_r8*rxt(310)*y(6) + .794_r8*rxt(311)*y(8) + .794_r8*rxt(312) &
                      *y(21)

         mat(561) = -(rxt(320)*y(6) + rxt(321)*y(8) + rxt(322)*y(21) + rxt(323)*y(13) &
                      + rxt(324)*y(45))
         mat(1175) = -rxt(320)*y(88)
         mat(914) = -rxt(321)*y(88)
         mat(1083) = -rxt(322)*y(88)
         mat(730) = -rxt(323)*y(88)
         mat(660) = -rxt(324)*y(88)

         mat(872) = rxt(316)*y(84) + rxt(325)*y(89) + .800_r8*rxt(307)*y(90)
         mat(140) = rxt(316)*y(20)
         mat(128) = rxt(325)*y(20)
         mat(250) = .800_r8*rxt(307)*y(20)

         mat(127) = -((rxt(325) + rxt(326)) * y(20))
         mat(823) = -(rxt(325) + rxt(326)) * y(89)

         mat(1044) = rxt(312)*y(86) + rxt(322)*y(88)
         mat(473) = rxt(312)*y(21)
         mat(554) = rxt(322)*y(21)

         mat(248) = -(rxt(307)*y(20))
         mat(842) = -rxt(307)*y(90)

         mat(1057) = rxt(306)*y(85)
         mat(612) = rxt(306)*y(21)

         mat(56) = -(rxt(228)*y(20))
         mat(813) = -rxt(228)*y(118)

         mat(164) = -(rxt(223)*y(20))
         mat(830) = -rxt(223)*y(119)

         mat(977) = .500_r8*rxt(235)*y(41)
         mat(1152) = rxt(225)*y(120)
         mat(830) = mat(830) + .350_r8*rxt(228)*y(118)
         mat(1048) = rxt(226)*y(120)
         mat(132) = .500_r8*rxt(235)*y(1)
         mat(57) = .350_r8*rxt(228)*y(20)
         mat(199) = rxt(225)*y(6) + rxt(226)*y(21)

         mat(200) = -(rxt(225)*y(6) + rxt(226)*y(21))
         mat(1154) = -rxt(225)*y(120)
         mat(1052) = -rxt(226)*y(120)

         mat(751) = rxt(216)*y(21)
         mat(1052) = mat(1052) + rxt(216)*y(16)

         mat(40) = -(rxt(343)*y(20))
         mat(810) = -rxt(343)*y(121)

         mat(810) = mat(810) + (rxt(344)+.500_r8*rxt(345))*y(122)
         mat(895) = rxt(346)*y(122)
         mat(79) = (rxt(344)+.500_r8*rxt(345))*y(20) + rxt(346)*y(8)

         mat(80) = -((rxt(344) + rxt(345)) * y(20) + rxt(346)*y(8))
         mat(816) = -(rxt(344) + rxt(345)) * y(122)
         mat(896) = -rxt(346)*y(122)

         mat(29) = -(rxt(347)*y(20))
         mat(807) = -rxt(347)*y(123)




         mat(804) = rxt(343)*y(121)
         mat(39) = rxt(343)*y(20)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      end subroutine nlnmat06
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = mat( 23) + lmat( 23)
         mat( 26) = mat( 26) + lmat( 26)
         mat( 29) = mat( 29) + lmat( 29)
         mat( 32) = mat( 32) + lmat( 32)
         mat( 35) = mat( 35) + lmat( 35)
         mat( 40) = mat( 40) + lmat( 40)
         mat( 42) = mat( 42) + lmat( 42)
         mat( 47) = mat( 47) + lmat( 47)
         mat( 50) = lmat( 50)
         mat( 51) = lmat( 51)
         mat( 52) = lmat( 52)
         mat( 53) = lmat( 53)
         mat( 54) = lmat( 54)
         mat( 55) = lmat( 55)
         mat( 56) = mat( 56) + lmat( 56)
         mat( 62) = lmat( 62)
         mat( 63) = lmat( 63)
         mat( 64) = mat( 64) + lmat( 64)
         mat( 68) = mat( 68) + lmat( 68)
         mat( 70) = mat( 70) + lmat( 70)
         mat( 71) = mat( 71) + lmat( 71)
         mat( 72) = mat( 72) + lmat( 72)
         mat( 76) = lmat( 76)
         mat( 77) = lmat( 77)
         mat( 78) = lmat( 78)
         mat( 80) = mat( 80) + lmat( 80)
         mat( 85) = mat( 85) + lmat( 85)
         mat( 89) = lmat( 89)
         mat( 90) = lmat( 90)
         mat( 91) = lmat( 91)
         mat( 92) = lmat( 92)
         mat( 93) = mat( 93) + lmat( 93)
         mat( 99) = lmat( 99)
         mat( 100) = lmat( 100)
         mat( 101) = lmat( 101)
         mat( 102) = lmat( 102)
         mat( 103) = lmat( 103)
         mat( 104) = lmat( 104)
         mat( 105) = mat( 105) + lmat( 105)
         mat( 112) = mat( 112) + lmat( 112)
         mat( 114) = lmat( 114)
         mat( 115) = lmat( 115)
         mat( 116) = mat( 116) + lmat( 116)
         mat( 117) = mat( 117) + lmat( 117)
         mat( 122) = mat( 122) + lmat( 122)
         mat( 124) = mat( 124) + lmat( 124)
         mat( 125) = mat( 125) + lmat( 125)
         mat( 126) = lmat( 126)
         mat( 127) = mat( 127) + lmat( 127)
         mat( 130) = mat( 130) + lmat( 130)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 139) = mat( 139) + lmat( 139)
         mat( 142) = mat( 142) + lmat( 142)
         mat( 144) = lmat( 144)
         mat( 145) = lmat( 145)
         mat( 146) = lmat( 146)
         mat( 147) = mat( 147) + lmat( 147)
         mat( 148) = mat( 148) + lmat( 148)
         mat( 149) = lmat( 149)
         mat( 152) = mat( 152) + lmat( 152)
         mat( 153) = lmat( 153)
         mat( 154) = mat( 154) + lmat( 154)
         mat( 156) = lmat( 156)
         mat( 158) = lmat( 158)
         mat( 159) = mat( 159) + lmat( 159)
         mat( 160) = mat( 160) + lmat( 160)
         mat( 164) = mat( 164) + lmat( 164)
         mat( 168) = mat( 168) + lmat( 168)
         mat( 170) = mat( 170) + lmat( 170)
         mat( 171) = mat( 171) + lmat( 171)
         mat( 172) = lmat( 172)
         mat( 173) = lmat( 173)
         mat( 174) = mat( 174) + lmat( 174)
         mat( 176) = lmat( 176)
         mat( 178) = mat( 178) + lmat( 178)
         mat( 179) = mat( 179) + lmat( 179)
         mat( 180) = mat( 180) + lmat( 180)
         mat( 182) = lmat( 182)
         mat( 183) = lmat( 183)
         mat( 185) = mat( 185) + lmat( 185)
         mat( 186) = lmat( 186)
         mat( 188) = lmat( 188)
         mat( 189) = lmat( 189)
         mat( 190) = mat( 190) + lmat( 190)
         mat( 191) = lmat( 191)
         mat( 192) = mat( 192) + lmat( 192)
         mat( 193) = lmat( 193)
         mat( 194) = lmat( 194)
         mat( 196) = lmat( 196)
         mat( 198) = mat( 198) + lmat( 198)
         mat( 200) = mat( 200) + lmat( 200)
         mat( 202) = lmat( 202)
         mat( 205) = mat( 205) + lmat( 205)
         mat( 207) = mat( 207) + lmat( 207)
         mat( 210) = lmat( 210)
         mat( 212) = mat( 212) + lmat( 212)
         mat( 214) = mat( 214) + lmat( 214)
         mat( 222) = lmat( 222)
         mat( 223) = lmat( 223)
         mat( 224) = lmat( 224)
         mat( 225) = lmat( 225)
         mat( 226) = lmat( 226)
         mat( 227) = lmat( 227)
         mat( 228) = mat( 228) + lmat( 228)
         mat( 230) = lmat( 230)
         mat( 232) = lmat( 232)
         mat( 236) = mat( 236) + lmat( 236)
         mat( 240) = mat( 240) + lmat( 240)
         mat( 243) = lmat( 243)
         mat( 245) = lmat( 245)
         mat( 246) = mat( 246) + lmat( 246)
         mat( 247) = lmat( 247)
         mat( 248) = mat( 248) + lmat( 248)
         mat( 249) = lmat( 249)
         mat( 251) = lmat( 251)
         mat( 253) = lmat( 253)
         mat( 255) = lmat( 255)
         mat( 256) = mat( 256) + lmat( 256)
         mat( 257) = lmat( 257)
         mat( 258) = lmat( 258)
         mat( 259) = mat( 259) + lmat( 259)
         mat( 260) = lmat( 260)
         mat( 261) = mat( 261) + lmat( 261)
         mat( 263) = lmat( 263)
         mat( 264) = mat( 264) + lmat( 264)
         mat( 266) = mat( 266) + lmat( 266)
         mat( 271) = mat( 271) + lmat( 271)
         mat( 282) = mat( 282) + lmat( 282)
         mat( 289) = mat( 289) + lmat( 289)
         mat( 293) = mat( 293) + lmat( 293)
         mat( 294) = mat( 294) + lmat( 294)
         mat( 296) = mat( 296) + lmat( 296)
         mat( 297) = lmat( 297)
         mat( 298) = mat( 298) + lmat( 298)
         mat( 301) = lmat( 301)
         mat( 303) = lmat( 303)
         mat( 305) = lmat( 305)
         mat( 306) = mat( 306) + lmat( 306)
         mat( 307) = lmat( 307)
         mat( 309) = mat( 309) + lmat( 309)
         mat( 320) = mat( 320) + lmat( 320)
         mat( 331) = mat( 331) + lmat( 331)
         mat( 333) = lmat( 333)
         mat( 335) = lmat( 335)
         mat( 338) = mat( 338) + lmat( 338)
         mat( 350) = mat( 350) + lmat( 350)
         mat( 359) = mat( 359) + lmat( 359)
         mat( 362) = mat( 362) + lmat( 362)
         mat( 365) = lmat( 365)
         mat( 368) = mat( 368) + lmat( 368)
         mat( 369) = lmat( 369)
         mat( 370) = mat( 370) + lmat( 370)
         mat( 372) = mat( 372) + lmat( 372)
         mat( 373) = mat( 373) + lmat( 373)
         mat( 375) = lmat( 375)
         mat( 379) = mat( 379) + lmat( 379)
         mat( 382) = mat( 382) + lmat( 382)
         mat( 393) = mat( 393) + lmat( 393)
         mat( 395) = lmat( 395)
         mat( 396) = mat( 396) + lmat( 396)
         mat( 399) = mat( 399) + lmat( 399)
         mat( 415) = mat( 415) + lmat( 415)
         mat( 417) = mat( 417) + lmat( 417)
         mat( 421) = mat( 421) + lmat( 421)
         mat( 423) = mat( 423) + lmat( 423)
         mat( 424) = mat( 424) + lmat( 424)
         mat( 425) = mat( 425) + lmat( 425)
         mat( 427) = lmat( 427)
         mat( 429) = mat( 429) + lmat( 429)
         mat( 432) = mat( 432) + lmat( 432)
         mat( 433) = mat( 433) + lmat( 433)
         mat( 435) = mat( 435) + lmat( 435)
         mat( 436) = lmat( 436)
         mat( 438) = lmat( 438)
         mat( 439) = mat( 439) + lmat( 439)
         mat( 442) = mat( 442) + lmat( 442)
         mat( 445) = mat( 445) + lmat( 445)
         mat( 459) = mat( 459) + lmat( 459)
         mat( 475) = mat( 475) + lmat( 475)
         mat( 487) = mat( 487) + lmat( 487)
         mat( 495) = mat( 495) + lmat( 495)
         mat( 502) = mat( 502) + lmat( 502)
         mat( 515) = mat( 515) + lmat( 515)
         mat( 517) = lmat( 517)
         mat( 518) = lmat( 518)
         mat( 520) = mat( 520) + lmat( 520)
         mat( 522) = lmat( 522)
         mat( 523) = mat( 523) + lmat( 523)
         mat( 527) = lmat( 527)
         mat( 531) = lmat( 531)
         mat( 532) = mat( 532) + lmat( 532)
         mat( 533) = mat( 533) + lmat( 533)
         mat( 536) = mat( 536) + lmat( 536)
         mat( 537) = lmat( 537)
         mat( 540) = mat( 540) + lmat( 540)
         mat( 543) = mat( 543) + lmat( 543)
         mat( 545) = mat( 545) + lmat( 545)
         mat( 546) = mat( 546) + lmat( 546)
         mat( 547) = mat( 547) + lmat( 547)
         mat( 553) = lmat( 553)
         mat( 561) = mat( 561) + lmat( 561)
         mat( 572) = lmat( 572)
         mat( 573) = mat( 573) + lmat( 573)
         mat( 577) = mat( 577) + lmat( 577)
         mat( 579) = lmat( 579)
         mat( 582) = lmat( 582)
         mat( 598) = mat( 598) + lmat( 598)
         mat( 620) = mat( 620) + lmat( 620)
         mat( 638) = mat( 638) + lmat( 638)
         mat( 665) = mat( 665) + lmat( 665)
         mat( 676) = lmat( 676)
         mat( 677) = mat( 677) + lmat( 677)
         mat( 678) = lmat( 678)
         mat( 679) = mat( 679) + lmat( 679)
         mat( 680) = mat( 680) + lmat( 680)
         mat( 682) = lmat( 682)
         mat( 686) = mat( 686) + lmat( 686)
         mat( 692) = mat( 692) + lmat( 692)
         mat( 701) = mat( 701) + lmat( 701)
         mat( 708) = mat( 708) + lmat( 708)
         mat( 711) = mat( 711) + lmat( 711)
         mat( 738) = mat( 738) + lmat( 738)
         mat( 754) = lmat( 754)
         mat( 755) = mat( 755) + lmat( 755)
         mat( 757) = mat( 757) + lmat( 757)
         mat( 758) = mat( 758) + lmat( 758)
         mat( 780) = mat( 780) + lmat( 780)
         mat( 792) = mat( 792) + lmat( 792)
         mat( 793) = mat( 793) + lmat( 793)
         mat( 798) = mat( 798) + lmat( 798)
         mat( 802) = mat( 802) + lmat( 802)
         mat( 878) = mat( 878) + lmat( 878)
         mat( 881) = mat( 881) + lmat( 881)
         mat( 884) = mat( 884) + lmat( 884)
         mat( 890) = mat( 890) + lmat( 890)
         mat( 892) = mat( 892) + lmat( 892)
         mat( 894) = mat( 894) + lmat( 894)
         mat( 903) = mat( 903) + lmat( 903)
         mat( 924) = mat( 924) + lmat( 924)
         mat( 926) = mat( 926) + lmat( 926)
         mat( 930) = mat( 930) + lmat( 930)
         mat( 934) = mat( 934) + lmat( 934)
         mat( 938) = mat( 938) + lmat( 938)
         mat( 940) = mat( 940) + lmat( 940)
         mat( 941) = lmat( 941)
         mat( 942) = lmat( 942)
         mat( 944) = mat( 944) + lmat( 944)
         mat( 946) = mat( 946) + lmat( 946)
         mat( 949) = lmat( 949)
         mat( 950) = lmat( 950)
         mat( 952) = mat( 952) + lmat( 952)
         mat( 953) = lmat( 953)
         mat( 954) = mat( 954) + lmat( 954)
         mat( 962) = lmat( 962)
         mat( 968) = mat( 968) + lmat( 968)
         mat( 975) = mat( 975) + lmat( 975)
         mat(1005) = mat(1005) + lmat(1005)
         mat(1007) = mat(1007) + lmat(1007)
         mat(1008) = mat(1008) + lmat(1008)
         mat(1032) = mat(1032) + lmat(1032)
         mat(1033) = mat(1033) + lmat(1033)
         mat(1058) = mat(1058) + lmat(1058)
         mat(1101) = mat(1101) + lmat(1101)
         mat(1123) = mat(1123) + lmat(1123)
         mat(1125) = mat(1125) + lmat(1125)
         mat(1128) = mat(1128) + lmat(1128)
         mat(1144) = mat(1144) + lmat(1144)
         mat(1147) = mat(1147) + lmat(1147)
         mat(1192) = mat(1192) + lmat(1192)
         mat(1196) = mat(1196) + lmat(1196)
         mat(1205) = mat(1205) + lmat(1205)
         mat(1210) = lmat(1210)
         mat(1216) = mat(1216) + lmat(1216)
         mat(1219) = mat(1219) + lmat(1219)
         mat(1221) = lmat(1221)
         mat(1223) = mat(1223) + lmat(1223)
         mat( 201) = 0._r8
         mat( 204) = 0._r8
         mat( 219) = 0._r8
         mat( 283) = 0._r8
         mat( 286) = 0._r8
         mat( 299) = 0._r8
         mat( 302) = 0._r8
         mat( 304) = 0._r8
         mat( 313) = 0._r8
         mat( 319) = 0._r8
         mat( 322) = 0._r8
         mat( 324) = 0._r8
         mat( 325) = 0._r8
         mat( 328) = 0._r8
         mat( 339) = 0._r8
         mat( 341) = 0._r8
         mat( 344) = 0._r8
         mat( 355) = 0._r8
         mat( 366) = 0._r8
         mat( 383) = 0._r8
         mat( 385) = 0._r8
         mat( 386) = 0._r8
         mat( 390) = 0._r8
         mat( 407) = 0._r8
         mat( 408) = 0._r8
         mat( 426) = 0._r8
         mat( 437) = 0._r8
         mat( 449) = 0._r8
         mat( 453) = 0._r8
         mat( 461) = 0._r8
         mat( 463) = 0._r8
         mat( 464) = 0._r8
         mat( 467) = 0._r8
         mat( 472) = 0._r8
         mat( 476) = 0._r8
         mat( 478) = 0._r8
         mat( 480) = 0._r8
         mat( 483) = 0._r8
         mat( 501) = 0._r8
         mat( 503) = 0._r8
         mat( 505) = 0._r8
         mat( 507) = 0._r8
         mat( 508) = 0._r8
         mat( 509) = 0._r8
         mat( 510) = 0._r8
         mat( 512) = 0._r8
         mat( 526) = 0._r8
         mat( 528) = 0._r8
         mat( 539) = 0._r8
         mat( 549) = 0._r8
         mat( 550) = 0._r8
         mat( 563) = 0._r8
         mat( 564) = 0._r8
         mat( 568) = 0._r8
         mat( 574) = 0._r8
         mat( 580) = 0._r8
         mat( 581) = 0._r8
         mat( 584) = 0._r8
         mat( 586) = 0._r8
         mat( 589) = 0._r8
         mat( 597) = 0._r8
         mat( 599) = 0._r8
         mat( 601) = 0._r8
         mat( 602) = 0._r8
         mat( 606) = 0._r8
         mat( 614) = 0._r8
         mat( 616) = 0._r8
         mat( 617) = 0._r8
         mat( 619) = 0._r8
         mat( 621) = 0._r8
         mat( 623) = 0._r8
         mat( 624) = 0._r8
         mat( 628) = 0._r8
         mat( 630) = 0._r8
         mat( 636) = 0._r8
         mat( 637) = 0._r8
         mat( 640) = 0._r8
         mat( 641) = 0._r8
         mat( 645) = 0._r8
         mat( 666) = 0._r8
         mat( 667) = 0._r8
         mat( 671) = 0._r8
         mat( 672) = 0._r8
         mat( 681) = 0._r8
         mat( 683) = 0._r8
         mat( 688) = 0._r8
         mat( 689) = 0._r8
         mat( 693) = 0._r8
         mat( 698) = 0._r8
         mat( 699) = 0._r8
         mat( 700) = 0._r8
         mat( 704) = 0._r8
         mat( 705) = 0._r8
         mat( 706) = 0._r8
         mat( 707) = 0._r8
         mat( 736) = 0._r8
         mat( 737) = 0._r8
         mat( 741) = 0._r8
         mat( 742) = 0._r8
         mat( 743) = 0._r8
         mat( 744) = 0._r8
         mat( 745) = 0._r8
         mat( 746) = 0._r8
         mat( 759) = 0._r8
         mat( 762) = 0._r8
         mat( 764) = 0._r8
         mat( 768) = 0._r8
         mat( 778) = 0._r8
         mat( 779) = 0._r8
         mat( 782) = 0._r8
         mat( 783) = 0._r8
         mat( 784) = 0._r8
         mat( 787) = 0._r8
         mat( 788) = 0._r8
         mat( 790) = 0._r8
         mat( 791) = 0._r8
         mat( 795) = 0._r8
         mat( 796) = 0._r8
         mat( 801) = 0._r8
         mat( 803) = 0._r8
         mat( 838) = 0._r8
         mat( 864) = 0._r8
         mat( 886) = 0._r8
         mat( 893) = 0._r8
         mat( 920) = 0._r8
         mat( 921) = 0._r8
         mat( 922) = 0._r8
         mat( 927) = 0._r8
         mat( 928) = 0._r8
         mat( 929) = 0._r8
         mat( 932) = 0._r8
         mat( 933) = 0._r8
         mat( 935) = 0._r8
         mat( 943) = 0._r8
         mat( 945) = 0._r8
         mat( 951) = 0._r8
         mat( 963) = 0._r8
         mat( 964) = 0._r8
         mat( 966) = 0._r8
         mat( 969) = 0._r8
         mat( 971) = 0._r8
         mat( 972) = 0._r8
         mat( 973) = 0._r8
         mat( 974) = 0._r8
         mat( 979) = 0._r8
         mat( 981) = 0._r8
         mat( 984) = 0._r8
         mat( 986) = 0._r8
         mat( 987) = 0._r8
         mat( 991) = 0._r8
         mat( 993) = 0._r8
         mat( 994) = 0._r8
         mat( 996) = 0._r8
         mat( 997) = 0._r8
         mat(1006) = 0._r8
         mat(1018) = 0._r8
         mat(1023) = 0._r8
         mat(1030) = 0._r8
         mat(1040) = 0._r8
         mat(1055) = 0._r8
         mat(1061) = 0._r8
         mat(1065) = 0._r8
         mat(1069) = 0._r8
         mat(1077) = 0._r8
         mat(1079) = 0._r8
         mat(1080) = 0._r8
         mat(1082) = 0._r8
         mat(1097) = 0._r8
         mat(1112) = 0._r8
         mat(1113) = 0._r8
         mat(1119) = 0._r8
         mat(1120) = 0._r8
         mat(1122) = 0._r8
         mat(1131) = 0._r8
         mat(1132) = 0._r8
         mat(1135) = 0._r8
         mat(1136) = 0._r8
         mat(1137) = 0._r8
         mat(1138) = 0._r8
         mat(1139) = 0._r8
         mat(1141) = 0._r8
         mat(1143) = 0._r8
         mat(1145) = 0._r8
         mat(1146) = 0._r8
         mat(1181) = 0._r8
         mat(1182) = 0._r8
         mat(1189) = 0._r8
         mat(1190) = 0._r8
         mat(1206) = 0._r8
         mat(1207) = 0._r8
         mat(1208) = 0._r8
         mat(1212) = 0._r8
         mat(1215) = 0._r8
         mat(1218) = 0._r8
         mat(1222) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 17) = mat( 17) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 20) = mat( 20) - dti
         mat( 23) = mat( 23) - dti
         mat( 26) = mat( 26) - dti
         mat( 29) = mat( 29) - dti
         mat( 32) = mat( 32) - dti
         mat( 35) = mat( 35) - dti
         mat( 40) = mat( 40) - dti
         mat( 42) = mat( 42) - dti
         mat( 47) = mat( 47) - dti
         mat( 50) = mat( 50) - dti
         mat( 53) = mat( 53) - dti
         mat( 56) = mat( 56) - dti
         mat( 62) = mat( 62) - dti
         mat( 64) = mat( 64) - dti
         mat( 68) = mat( 68) - dti
         mat( 72) = mat( 72) - dti
         mat( 76) = mat( 76) - dti
         mat( 80) = mat( 80) - dti
         mat( 85) = mat( 85) - dti
         mat( 89) = mat( 89) - dti
         mat( 93) = mat( 93) - dti
         mat( 99) = mat( 99) - dti
         mat( 105) = mat( 105) - dti
         mat( 112) = mat( 112) - dti
         mat( 117) = mat( 117) - dti
         mat( 122) = mat( 122) - dti
         mat( 127) = mat( 127) - dti
         mat( 131) = mat( 131) - dti
         mat( 139) = mat( 139) - dti
         mat( 142) = mat( 142) - dti
         mat( 148) = mat( 148) - dti
         mat( 154) = mat( 154) - dti
         mat( 160) = mat( 160) - dti
         mat( 164) = mat( 164) - dti
         mat( 168) = mat( 168) - dti
         mat( 174) = mat( 174) - dti
         mat( 180) = mat( 180) - dti
         mat( 185) = mat( 185) - dti
         mat( 192) = mat( 192) - dti
         mat( 200) = mat( 200) - dti
         mat( 207) = mat( 207) - dti
         mat( 214) = mat( 214) - dti
         mat( 222) = mat( 222) - dti
         mat( 228) = mat( 228) - dti
         mat( 236) = mat( 236) - dti
         mat( 240) = mat( 240) - dti
         mat( 248) = mat( 248) - dti
         mat( 256) = mat( 256) - dti
         mat( 264) = mat( 264) - dti
         mat( 271) = mat( 271) - dti
         mat( 282) = mat( 282) - dti
         mat( 289) = mat( 289) - dti
         mat( 293) = mat( 293) - dti
         mat( 298) = mat( 298) - dti
         mat( 309) = mat( 309) - dti
         mat( 320) = mat( 320) - dti
         mat( 331) = mat( 331) - dti
         mat( 338) = mat( 338) - dti
         mat( 350) = mat( 350) - dti
         mat( 359) = mat( 359) - dti
         mat( 368) = mat( 368) - dti
         mat( 373) = mat( 373) - dti
         mat( 382) = mat( 382) - dti
         mat( 393) = mat( 393) - dti
         mat( 399) = mat( 399) - dti
         mat( 415) = mat( 415) - dti
         mat( 425) = mat( 425) - dti
         mat( 435) = mat( 435) - dti
         mat( 445) = mat( 445) - dti
         mat( 459) = mat( 459) - dti
         mat( 475) = mat( 475) - dti
         mat( 487) = mat( 487) - dti
         mat( 495) = mat( 495) - dti
         mat( 502) = mat( 502) - dti
         mat( 515) = mat( 515) - dti
         mat( 523) = mat( 523) - dti
         mat( 533) = mat( 533) - dti
         mat( 546) = mat( 546) - dti
         mat( 561) = mat( 561) - dti
         mat( 577) = mat( 577) - dti
         mat( 598) = mat( 598) - dti
         mat( 620) = mat( 620) - dti
         mat( 638) = mat( 638) - dti
         mat( 665) = mat( 665) - dti
         mat( 677) = mat( 677) - dti
         mat( 686) = mat( 686) - dti
         mat( 701) = mat( 701) - dti
         mat( 738) = mat( 738) - dti
         mat( 758) = mat( 758) - dti
         mat( 792) = mat( 792) - dti
         mat( 884) = mat( 884) - dti
         mat( 926) = mat( 926) - dti
         mat( 946) = mat( 946) - dti
         mat( 968) = mat( 968) - dti
         mat(1007) = mat(1007) - dti
         mat(1033) = mat(1033) - dti
         mat(1101) = mat(1101) - dti
         mat(1125) = mat(1125) - dti
         mat(1144) = mat(1144) - dti
         mat(1196) = mat(1196) - dti
         mat(1223) = mat(1223) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
