



      module mo_prod_loss

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: exp_prod_loss
      public :: imp_prod_loss

      contains

      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:,:,:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:,:,:)
      real(r8), intent(in) :: rxt(:,:,:)
      real(r8), intent(in) :: het_rates(:,:,:)



!--------------------------------------------------------------------
! ... loss and production for Explicit method
!--------------------------------------------------------------------


         loss(:,:,1) = ((rxt(:,:,107) +rxt(:,:,108) +rxt(:,:,109))* y(:,:,3) &
                  +rxt(:,:,210)* y(:,:,20) +rxt(:,:,161)* y(:,:,25) + rxt(:,:,54) &
                  + rxt(:,:,55) + het_rates(:,:,12))* y(:,:,12)
         prod(:,:,1) = 0._r8
         loss(:,:,2) = ((rxt(:,:,88) +rxt(:,:,89))* y(:,:,3) + rxt(:,:,4) &
                  + het_rates(:,:,4))* y(:,:,4)
         prod(:,:,2) = 0._r8
         loss(:,:,3) = (rxt(:,:,199)* y(:,:,20) +rxt(:,:,198)* y(:,:,25) + rxt(:,:,35) &
                  + het_rates(:,:,99))* y(:,:,99)
         prod(:,:,3) = 0._r8
         loss(:,:,4) = (rxt(:,:,100)* y(:,:,3) +rxt(:,:,202)* y(:,:,20) +rxt(:,:,203) &
                 * y(:,:,25) + rxt(:,:,46) + het_rates(:,:,100))* y(:,:,100)
         prod(:,:,4) = 0._r8
         loss(:,:,5) = (rxt(:,:,91)* y(:,:,3) + rxt(:,:,38) + het_rates(:,:,101)) &
                 * y(:,:,101)
         prod(:,:,5) = 0._r8
         loss(:,:,6) = (rxt(:,:,92)* y(:,:,3) + rxt(:,:,39) + het_rates(:,:,102)) &
                 * y(:,:,102)
         prod(:,:,6) = 0._r8
         loss(:,:,7) = (rxt(:,:,93)* y(:,:,3) + rxt(:,:,40) + het_rates(:,:,103)) &
                 * y(:,:,103)
         prod(:,:,7) = 0._r8
         loss(:,:,8) = (rxt(:,:,94)* y(:,:,3) + rxt(:,:,42) + het_rates(:,:,111)) &
                 * y(:,:,111)
         prod(:,:,8) = 0._r8
         loss(:,:,9) = (rxt(:,:,95)* y(:,:,3) + rxt(:,:,43) + het_rates(:,:,112)) &
                 * y(:,:,112)
         prod(:,:,9) = 0._r8
         loss(:,:,10) = (rxt(:,:,96)* y(:,:,3) +rxt(:,:,201)* y(:,:,20) + rxt(:,:,41) &
                  + het_rates(:,:,104))* y(:,:,104)
         prod(:,:,10) = 0._r8
         loss(:,:,11) = (rxt(:,:,97)* y(:,:,3) +rxt(:,:,204)* y(:,:,20) + rxt(:,:,44) &
                  + het_rates(:,:,109))* y(:,:,109)
         prod(:,:,11) = 0._r8
         loss(:,:,12) = (rxt(:,:,98)* y(:,:,3) +rxt(:,:,205)* y(:,:,20) + rxt(:,:,45) &
                  + het_rates(:,:,110))* y(:,:,110)
         prod(:,:,12) = 0._r8
         loss(:,:,13) = (rxt(:,:,99)* y(:,:,3) + rxt(:,:,36) + het_rates(:,:,105)) &
                 * y(:,:,105)
         prod(:,:,13) = 0._r8
         loss(:,:,14) = (rxt(:,:,200)* y(:,:,20) + rxt(:,:,37) + het_rates(:,:,106)) &
                 * y(:,:,106)
         prod(:,:,14) = 0._r8
         loss(:,:,15) = (rxt(:,:,102)* y(:,:,3) + rxt(:,:,47) + het_rates(:,:,107)) &
                 * y(:,:,107)
         prod(:,:,15) = 0._r8
         loss(:,:,16) = (rxt(:,:,101)* y(:,:,3) + rxt(:,:,50) + het_rates(:,:,108)) &
                 * y(:,:,108)
         prod(:,:,16) = 0._r8
         loss(:,:,17) = (rxt(:,:,103)* y(:,:,3) + rxt(:,:,48) + het_rates(:,:,113)) &
                 * y(:,:,113)
         prod(:,:,17) = 0._r8
         loss(:,:,18) = (rxt(:,:,104)* y(:,:,3) + rxt(:,:,49) + het_rates(:,:,114)) &
                 * y(:,:,114)
         prod(:,:,18) = 0._r8
         loss(:,:,19) = (rxt(:,:,105)* y(:,:,3) +rxt(:,:,207)* y(:,:,20) +rxt(:,:,209) &
                 * y(:,:,25) + rxt(:,:,51) + het_rates(:,:,115))* y(:,:,115)
         prod(:,:,19) = 0._r8
         loss(:,:,20) = (rxt(:,:,106)* y(:,:,3) +rxt(:,:,206)* y(:,:,20) +rxt(:,:,208) &
                 * y(:,:,25) + rxt(:,:,52) + het_rates(:,:,116))* y(:,:,116)
         prod(:,:,20) = 0._r8
         loss(:,:,21) = ( + rxt(:,:,53) + het_rates(:,:,117))* y(:,:,117)
         prod(:,:,21) =.440_r8*rxt(:,:,55)*y(:,:,12)
         loss(:,:,22) = ( + het_rates(:,:,23))* y(:,:,23)
         prod(:,:,22) = 0._r8
         loss(:,:,23) = ( + het_rates(:,:,24))* y(:,:,24)
         prod(:,:,23) = 0._r8
         loss(:,:,24) = ( + rxt(:,:,339) + het_rates(:,:,125))* y(:,:,125)
         prod(:,:,24) = 0._r8
         loss(:,:,25) = ( + het_rates(:,:,126))* y(:,:,126)
         prod(:,:,25) =rxt(:,:,339)*y(:,:,125)

      end subroutine exp_prod_loss

      subroutine imp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:)
      real(r8), intent(in) :: rxt(:)
      real(r8), intent(in) :: het_rates(:)



!--------------------------------------------------------------------
! ... loss and production for Implicit method
!--------------------------------------------------------------------


         loss(114) = (rxt(83)* y(2) +rxt(90)* y(3) +rxt(140)* y(6) +rxt(143)* y(7) &
                  +rxt(115)* y(19) +rxt(120)* y(20) +rxt(128)* y(21) +rxt(155)* y(25) &
                  +rxt(182)* y(34) +rxt(235)* y(41) +rxt(256)* y(56) +rxt(278)* y(74) &
                  +rxt(284)* y(75) +rxt(302)* y(80) +rxt(334)* y(96) + rxt(2) + rxt(3) &
                  + het_rates(1))* y(1)
         prod(114) = (.200_r8*rxt(278)*y(74) +.200_r8*rxt(284)*y(75) + &
                 .100_r8*rxt(302)*y(80))*y(1) + (.250_r8*rxt(246)*y(45) + &
                 .250_r8*rxt(294)*y(73))*y(21) +rxt(82)*y(2)
         loss(115) = (rxt(83)* y(1) + 2._r8*rxt(84)* y(2) +rxt(138)* y(6) &
                  + (rxt(141) +rxt(142))* y(7) +rxt(149)* y(8) +rxt(215)* y(16) &
                  +rxt(126)* y(18) +rxt(119)* y(20) +rxt(127)* y(21) +rxt(130)* y(22) &
                  +rxt(162)* y(27) +rxt(175)* y(30) +rxt(176)* y(31) +rxt(179)* y(32) &
                  +rxt(185)* y(35) +rxt(195)* y(36) +rxt(196)* y(37) +rxt(197)* y(38) &
                  + rxt(82) + het_rates(2))* y(2)
         prod(115) = (rxt(133) +rxt(134)*y(6) +rxt(135)*y(7))*y(5) + (rxt(85) + &
                 rxt(86))*y(3) +rxt(3)*y(1) +rxt(5)*y(6) +rxt(6)*y(7) +rxt(10)*y(8) &
                  +rxt(8)*y(11) +rxt(118)*y(21)*y(19) +rxt(122)*y(20)*y(20) +rxt(22) &
                 *y(27) +rxt(23)*y(28) +rxt(30)*y(35) +rxt(19)*y(145)
         loss(112) = (rxt(90)* y(1) + (rxt(88) +rxt(89))* y(4) + (rxt(107) +rxt(108) + &
                 rxt(109))* y(12) +rxt(110)* y(18) +rxt(111)* y(30) +rxt(112)* y(36) &
                  +rxt(113)* y(39) +rxt(100)* y(100) +rxt(91)* y(101) +rxt(92)* y(102) &
                  +rxt(93)* y(103) +rxt(96)* y(104) +rxt(99)* y(105) +rxt(102)* y(107) &
                  +rxt(101)* y(108) +rxt(97)* y(109) +rxt(98)* y(110) +rxt(94)* y(111) &
                  +rxt(95)* y(112) +rxt(103)* y(113) +rxt(104)* y(114) +rxt(105) &
                 * y(115) +rxt(106)* y(116) +rxt(87)* y(145) + rxt(85) + rxt(86) &
                  + het_rates(3))* y(3)
         prod(112) =rxt(2)*y(1) +rxt(18)*y(145)
         loss(91) = (rxt(126)* y(2) +rxt(110)* y(3) +rxt(124)* y(20) +rxt(156)* y(25) &
                  + het_rates(18))* y(18)
         prod(91) =rxt(109)*y(12)*y(3) +rxt(16)*y(16) +rxt(117)*y(21)*y(19) +rxt(18) &
                 *y(145)
         loss(92) = ((rxt(211) +rxt(212))* y(20) + het_rates(17))* y(17)
         prod(92) = (rxt(15) +rxt(16) +rxt(160)*y(25) +rxt(184)*y(34) +rxt(213)*y(8) + &
                 rxt(214)*y(20) +rxt(215)*y(2))*y(16) + (.500_r8*rxt(235)*y(41) + &
                 .560_r8*rxt(256)*y(56) +.050_r8*rxt(278)*y(74) + &
                 .200_r8*rxt(284)*y(75) +.300_r8*rxt(302)*y(80))*y(1) &
                  + (.220_r8*rxt(285)*y(6) +.220_r8*rxt(287)*y(8) + &
                 .110_r8*rxt(289)*y(13) +.220_r8*rxt(290)*y(45))*y(76) &
                  + (.500_r8*rxt(320)*y(6) +.500_r8*rxt(321)*y(8) + &
                 .200_r8*rxt(323)*y(13) +.500_r8*rxt(324)*y(45))*y(88) &
                  + (.350_r8*rxt(228)*y(118) +rxt(251)*y(50) +rxt(272)*y(65))*y(20) &
                  + (rxt(69) +rxt(273)*y(8))*y(65) +rxt(198)*y(99)*y(25) +rxt(56) &
                 *y(47) +rxt(74)*y(49) +2.000_r8*rxt(77)*y(50) +.700_r8*rxt(63)*y(74) &
                  +1.340_r8*rxt(62)*y(75) +.450_r8*rxt(76)*y(83) +rxt(71)*y(87)
         loss(34) = (rxt(134)* y(6) + (rxt(135) +rxt(136) +rxt(137))* y(7) + rxt(133) &
                  + het_rates(5))* y(5)
         prod(34) =rxt(5)*y(6)
         loss(119) = (rxt(140)* y(1) +rxt(138)* y(2) +rxt(134)* y(5) +rxt(148)* y(8) &
                  +rxt(217)* y(13) +rxt(139)* y(21) +rxt(167)* y(27) +rxt(188)* y(35) &
                  +rxt(237)* y(43) +rxt(244)* y(45) +rxt(231)* y(52) +rxt(258)* y(58) &
                  +rxt(263)* y(61) +rxt(267)* y(64) +rxt(276)* y(70) +rxt(280)* y(71) &
                  +rxt(292)* y(73) + (rxt(285) +rxt(286))* y(76) +rxt(317)* y(81) &
                  +rxt(304)* y(85) +rxt(310)* y(86) +rxt(320)* y(88) +rxt(328)* y(93) &
                  +rxt(336)* y(97) +rxt(225)* y(120) + rxt(5) + het_rates(6))* y(6)
         prod(119) = (rxt(6) +.500_r8*rxt(342) +2.000_r8*rxt(136)*y(5) +rxt(141)*y(2)) &
                 *y(7) +2.000_r8*rxt(88)*y(4)*y(3) +rxt(133)*y(5) +rxt(11)*y(8) &
                  +rxt(8)*y(11)
         loss(109) = (rxt(143)* y(1) + (rxt(141) +rxt(142))* y(2) + (rxt(135) + &
                 rxt(136) +rxt(137))* y(5) +rxt(144)* y(8) +rxt(146)* y(20) +rxt(152) &
                 * y(21) +rxt(168)* y(27) +rxt(189)* y(35) +rxt(245)* y(45) +rxt(298) &
                 * y(73) +rxt(332)* y(95) + rxt(6) + rxt(342) + het_rates(7))* y(7)
         prod(109) = (rxt(138)*y(2) +rxt(139)*y(21) +rxt(140)*y(1) + &
                 2.000_r8*rxt(148)*y(8) +rxt(167)*y(27) +rxt(188)*y(35) + &
                 rxt(217)*y(13) +rxt(225)*y(120) +rxt(231)*y(52) +rxt(237)*y(43) + &
                 rxt(244)*y(45) +rxt(258)*y(58) +rxt(263)*y(61) +rxt(267)*y(64) + &
                 rxt(276)*y(70) +rxt(280)*y(71) +rxt(285)*y(76) +rxt(292)*y(73) + &
                 .920_r8*rxt(304)*y(85) +1.206_r8*rxt(310)*y(86) + &
                 .900_r8*rxt(317)*y(81) +rxt(320)*y(88) +.900_r8*rxt(328)*y(93) + &
                 rxt(336)*y(97))*y(6) + (rxt(10) +rxt(149)*y(2) +rxt(150)*y(20) + &
                 rxt(151)*y(21) +rxt(287)*y(76) +rxt(293)*y(73) +rxt(305)*y(85) + &
                 1.206_r8*rxt(311)*y(86) +rxt(315)*y(87) +rxt(321)*y(88) + &
                 rxt(335)*y(96))*y(8) + (rxt(13) +rxt(154) +rxt(153)*y(20))*y(10) &
                  + (rxt(7) +rxt(145))*y(11) + (rxt(274)*y(79) + &
                 .400_r8*rxt(314)*y(87))*y(20) + (.600_r8*rxt(59) +rxt(253))*y(55) &
                  + (rxt(60) +rxt(299))*y(78) +.700_r8*rxt(332)*y(95)*y(7) +rxt(9) &
                 *y(9) +.206_r8*rxt(312)*y(86)*y(21) +rxt(28)*y(32) +rxt(33)*y(38) &
                  +rxt(71)*y(87)
         loss(110) = (rxt(120)* y(1) +rxt(119)* y(2) +rxt(146)* y(7) +rxt(150)* y(8) &
                  +rxt(147)* y(9) +rxt(153)* y(10) +rxt(210)* y(12) +rxt(222)* y(14) &
                  +rxt(221)* y(15) +rxt(214)* y(16) + (rxt(211) +rxt(212))* y(17) &
                  +rxt(124)* y(18) + 2._r8*(rxt(122) +rxt(123))* y(20) +rxt(121) &
                 * y(21) +rxt(125)* y(22) + (rxt(163) +rxt(164))* y(27) +rxt(174) &
                 * y(30) +rxt(178)* y(31) +rxt(180)* y(32) +rxt(186)* y(35) +rxt(194) &
                 * y(36) +rxt(131)* y(39) +rxt(132)* y(40) +rxt(230)* y(41) +rxt(229) &
                 * y(42) +rxt(241)* y(44) +rxt(236)* y(46) +rxt(242)* y(47) +rxt(252) &
                 * y(48) +rxt(250)* y(49) +rxt(251)* y(50) +rxt(249)* y(51) +rxt(254) &
                 * y(55) +rxt(255)* y(56) +rxt(262)* y(57) +rxt(261)* y(59) +rxt(266) &
                 * y(60) +rxt(265)* y(62) +rxt(271)* y(63) +rxt(272)* y(65) +rxt(270) &
                 * y(66) +rxt(275)* y(67) +rxt(313)* y(68) +rxt(279)* y(69) +rxt(282) &
                 * y(72) +rxt(277)* y(74) +rxt(283)* y(75) +rxt(291)* y(77) +rxt(300) &
                 * y(78) +rxt(274)* y(79) +rxt(301)* y(80) +rxt(319)* y(82) +rxt(316) &
                 * y(84) +rxt(314)* y(87) +rxt(325)* y(89) +rxt(307)* y(90) +rxt(327) &
                 * y(91) +rxt(331)* y(92) +rxt(330)* y(94) +rxt(333)* y(96) +rxt(338) &
                 * y(98) +rxt(199)* y(99) +rxt(202)* y(100) +rxt(201)* y(104) &
                  +rxt(200)* y(106) +rxt(204)* y(109) +rxt(205)* y(110) +rxt(207) &
                 * y(115) +rxt(206)* y(116) +rxt(228)* y(118) +rxt(223)* y(119) &
                  +rxt(343)* y(121) + (rxt(344) +rxt(345))* y(122) +rxt(347)* y(123) &
                  + het_rates(20))* y(20)
         prod(110) = (rxt(115)*y(19) +rxt(128)*y(21) +.120_r8*rxt(235)*y(41) + &
                 .330_r8*rxt(256)*y(56) +.080_r8*rxt(278)*y(74) + &
                 .215_r8*rxt(284)*y(75) +.270_r8*rxt(302)*y(80) + &
                 .700_r8*rxt(334)*y(96))*y(1) + (rxt(126)*y(18) +rxt(127)*y(21) + &
                 rxt(130)*y(22) +rxt(175)*y(30) +rxt(176)*y(31) +rxt(195)*y(36) + &
                 rxt(196)*y(37) +rxt(215)*y(16))*y(2) + (rxt(107)*y(12) + &
                 2.000_r8*rxt(87)*y(145) +rxt(110)*y(18) +rxt(111)*y(30) + &
                 rxt(112)*y(36) +rxt(113)*y(39))*y(3) + (.300_r8*rxt(222)*y(14) + &
                 .650_r8*rxt(228)*y(118) +.500_r8*rxt(241)*y(44) + &
                 .500_r8*rxt(265)*y(62) +.100_r8*rxt(291)*y(77))*y(20) &
                  + (2.000_r8*rxt(116)*y(19) +rxt(139)*y(6) +rxt(151)*y(8) + &
                 rxt(159)*y(25))*y(21) +.500_r8*rxt(342)*y(7) +rxt(9)*y(9) +rxt(12) &
                 *y(10) +rxt(14)*y(14) +2.000_r8*rxt(20)*y(22) +rxt(25)*y(31) +rxt(31) &
                 *y(37) +rxt(64)*y(44) +rxt(58)*y(51) +rxt(65)*y(54) +rxt(66)*y(59) &
                  +rxt(57)*y(62) +rxt(67)*y(66) +rxt(79)*y(72) +rxt(78)*y(82) +rxt(70) &
                 *y(89) +rxt(80)*y(94) +rxt(81)*y(98) +rxt(17)*y(145)
         loss(111) = (rxt(149)* y(2) +rxt(148)* y(6) +rxt(144)* y(7) +rxt(213)* y(16) &
                  +rxt(150)* y(20) +rxt(151)* y(21) +rxt(243)* y(47) +rxt(257)* y(56) &
                  +rxt(273)* y(65) +rxt(293)* y(73) +rxt(287)* y(76) +rxt(303)* y(80) &
                  +rxt(305)* y(85) +rxt(311)* y(86) +rxt(315)* y(87) +rxt(321)* y(88) &
                  +rxt(335)* y(96) +rxt(346)* y(122) + rxt(10) + rxt(11) + rxt(341) &
                  + het_rates(8))* y(8)
         prod(111) = (rxt(147)*y(9) +rxt(180)*y(32) +rxt(254)*y(55) + &
                 .500_r8*rxt(300)*y(78))*y(20) + (rxt(142)*y(7) +rxt(179)*y(32) + &
                 rxt(197)*y(38))*y(2) + (rxt(7) +rxt(8) +rxt(145))*y(11) + (rxt(27) + &
                 rxt(181)*y(25))*y(32) +rxt(143)*y(7)*y(1) +rxt(12)*y(10) +rxt(32) &
                 *y(38) +.400_r8*rxt(59)*y(55)
         loss(83) = (rxt(147)* y(20) + rxt(9) + het_rates(9))* y(9)
         prod(83) = (rxt(350) +rxt(356) +rxt(361) +rxt(352)*y(30) +rxt(357)*y(30) + &
                 rxt(363)*y(30))*y(32) + (rxt(341) +rxt(213)*y(16) +rxt(243)*y(47) + &
                 rxt(273)*y(65) +rxt(346)*y(122))*y(8) + (2.000_r8*rxt(340) + &
                 2.000_r8*rxt(349) +2.000_r8*rxt(355) +2.000_r8*rxt(360))*y(11) &
                  + (rxt(351) +rxt(359) +rxt(362))*y(38) + (.500_r8*rxt(342) + &
                 rxt(146)*y(20))*y(7)
         loss(54) = (rxt(153)* y(20) + rxt(12) + rxt(13) + rxt(154) + het_rates(10)) &
                 * y(10)
         prod(54) =rxt(152)*y(21)*y(7)
         loss(41) = ( + rxt(7) + rxt(8) + rxt(145) + rxt(340) + rxt(349) + rxt(355) &
                  + rxt(360) + het_rates(11))* y(11)
         prod(41) =rxt(144)*y(8)*y(7)
         loss(107) = (rxt(217)* y(6) + 2._r8*(rxt(219) +rxt(220))* y(13) +rxt(218) &
                 * y(21) +rxt(166)* y(27) +rxt(239)* y(43) +rxt(247)* y(45) +rxt(260) &
                 * y(58) +rxt(269)* y(64) +rxt(295)* y(73) +rxt(289)* y(76) +rxt(308) &
                 * y(85) +rxt(323)* y(88) + het_rates(13))* y(13)
         prod(107) = (rxt(244)*y(6) +.900_r8*rxt(247)*y(13) +2.000_r8*rxt(248)*y(45) + &
                 rxt(290)*y(76) +rxt(296)*y(73) +rxt(309)*y(85) +rxt(324)*y(88))*y(45) &
                  + (rxt(107)*y(3) +rxt(161)*y(25) +rxt(210)*y(20))*y(12) &
                  + (.700_r8*rxt(222)*y(14) +rxt(236)*y(46))*y(20) &
                  +.310_r8*rxt(256)*y(56)*y(1) +rxt(56)*y(47) +rxt(58)*y(51) &
                  +.400_r8*rxt(59)*y(55) +rxt(68)*y(60) +.300_r8*rxt(63)*y(74)
         loss(55) = (rxt(222)* y(20) + rxt(14) + het_rates(14))* y(14)
         prod(55) =rxt(218)*y(21)*y(13)
         loss(35) = (rxt(113)* y(3) +rxt(131)* y(20) + het_rates(39))* y(39)
         prod(35) = 0._r8
         loss(24) = (rxt(132)* y(20) + het_rates(40))* y(40)
         prod(24) = 0._r8
         loss(108) = (rxt(215)* y(2) +rxt(213)* y(8) +rxt(214)* y(20) +rxt(216)* y(21) &
                  +rxt(160)* y(25) +rxt(184)* y(34) + rxt(15) + rxt(16) &
                  + het_rates(16))* y(16)
         prod(108) = (rxt(166)*y(27) +rxt(217)*y(6) +2.000_r8*rxt(219)*y(13) + &
                 rxt(220)*y(13) +.700_r8*rxt(239)*y(43) +rxt(247)*y(45) + &
                 rxt(260)*y(58) +.800_r8*rxt(269)*y(64) +.880_r8*rxt(289)*y(76) + &
                 2.000_r8*rxt(295)*y(73) +1.200_r8*rxt(308)*y(85) + &
                 .700_r8*rxt(323)*y(88))*y(13) + (.500_r8*rxt(231)*y(52) + &
                 rxt(263)*y(61) +rxt(267)*y(64) +.500_r8*rxt(276)*y(70) + &
                 .250_r8*rxt(285)*y(76) +rxt(292)*y(73) +.510_r8*rxt(304)*y(85) + &
                 .072_r8*rxt(310)*y(86) +.100_r8*rxt(317)*y(81))*y(6) &
                  + (rxt(221)*y(15) +.300_r8*rxt(222)*y(14) +.500_r8*rxt(249)*y(51) + &
                 .800_r8*rxt(250)*y(49) +rxt(254)*y(55) +.500_r8*rxt(300)*y(78))*y(20) &
                  + (rxt(235)*y(41) +.540_r8*rxt(256)*y(56) +.800_r8*rxt(278)*y(74) + &
                 .700_r8*rxt(284)*y(75) +.600_r8*rxt(302)*y(80))*y(1) &
                  + (.250_r8*rxt(287)*y(76) +rxt(293)*y(73) +.600_r8*rxt(305)*y(85) + &
                 .072_r8*rxt(311)*y(86))*y(8) + (.250_r8*rxt(290)*y(76) + &
                 rxt(296)*y(73) +.600_r8*rxt(309)*y(85))*y(45) + (rxt(108)*y(12) + &
                 rxt(109)*y(12))*y(3) +rxt(14)*y(14) +.008_r8*rxt(312)*y(86)*y(21) &
                  +rxt(74)*y(49) +2.000_r8*rxt(234)*y(53) +rxt(57)*y(62) +rxt(73) &
                 *y(63) +rxt(67)*y(66) +2.000_r8*rxt(297)*y(73)*y(73) &
                  +1.340_r8*rxt(61)*y(75) +.100_r8*rxt(78)*y(82) +rxt(71)*y(87) &
                  +.690_r8*rxt(72)*y(90) +rxt(224)*y(120)
         loss(105) = (rxt(115)* y(1) + (rxt(116) +rxt(117) +rxt(118))* y(21) &
                  + rxt(114) + het_rates(19))* y(19)
         prod(105) = (rxt(110)*y(3) +rxt(124)*y(20) +rxt(126)*y(2) +rxt(156)*y(25)) &
                 *y(18) + (rxt(119)*y(2) +rxt(211)*y(17) +rxt(214)*y(16))*y(20) &
                  + (rxt(17) +2.000_r8*rxt(19))*y(145) +rxt(108)*y(12)*y(3) +rxt(14) &
                 *y(14) +2.000_r8*rxt(15)*y(16) +rxt(26)*y(30) +rxt(34)*y(36)
         loss(116) = (rxt(128)* y(1) +rxt(127)* y(2) +rxt(139)* y(6) +rxt(152)* y(7) &
                  +rxt(151)* y(8) +rxt(218)* y(13) +rxt(216)* y(16) + (rxt(116) + &
                 rxt(117) +rxt(118))* y(19) +rxt(121)* y(20) + 2._r8*rxt(129)* y(21) &
                  + (rxt(158) +rxt(159))* y(25) +rxt(165)* y(27) +rxt(183)* y(34) &
                  +rxt(187)* y(35) +rxt(238)* y(43) +rxt(246)* y(45) +rxt(232)* y(52) &
                  +rxt(259)* y(58) +rxt(264)* y(61) +rxt(268)* y(64) +rxt(281)* y(71) &
                  +rxt(294)* y(73) +rxt(288)* y(76) +rxt(318)* y(81) +rxt(306)* y(85) &
                  +rxt(312)* y(86) +rxt(322)* y(88) +rxt(329)* y(93) +rxt(337)* y(97) &
                  +rxt(226)* y(120) + rxt(348) + het_rates(21))* y(21)
         prod(116) = (rxt(199)*y(99) +rxt(202)*y(100) +rxt(120)*y(1) +rxt(125)*y(22) + &
                 rxt(131)*y(39) +rxt(132)*y(40) +rxt(150)*y(8) +rxt(163)*y(27) + &
                 rxt(186)*y(35) +rxt(212)*y(17) +rxt(221)*y(15) +rxt(223)*y(119) + &
                 .350_r8*rxt(228)*y(118) +rxt(250)*y(49) +rxt(251)*y(50) + &
                 rxt(252)*y(48) +rxt(271)*y(63) +.200_r8*rxt(291)*y(77) + &
                 .500_r8*rxt(300)*y(78) +rxt(314)*y(87) +.250_r8*rxt(327)*y(91) + &
                 .500_r8*rxt(345)*y(122))*y(20) + (rxt(217)*y(13) +rxt(225)*y(120) + &
                 .250_r8*rxt(231)*y(52) +rxt(237)*y(43) +rxt(258)*y(58) + &
                 rxt(263)*y(61) +rxt(276)*y(70) +.470_r8*rxt(285)*y(76) + &
                 rxt(304)*y(85) +.794_r8*rxt(310)*y(86) +.900_r8*rxt(317)*y(81) + &
                 rxt(320)*y(88) +.900_r8*rxt(328)*y(93) +rxt(336)*y(97))*y(6) &
                  + (rxt(166)*y(27) +2.000_r8*rxt(219)*y(13) +rxt(239)*y(43) + &
                 .900_r8*rxt(247)*y(45) +rxt(260)*y(58) +.300_r8*rxt(269)*y(64) + &
                 .730_r8*rxt(289)*y(76) +rxt(295)*y(73) +rxt(308)*y(85) + &
                 .800_r8*rxt(323)*y(88))*y(13) + (.120_r8*rxt(235)*y(41) + &
                 .190_r8*rxt(256)*y(56) +.060_r8*rxt(278)*y(74) + &
                 .275_r8*rxt(284)*y(75) +.060_r8*rxt(302)*y(80) +rxt(334)*y(96))*y(1) &
                  + (rxt(213)*y(16) +.470_r8*rxt(287)*y(76) +rxt(305)*y(85) + &
                 .794_r8*rxt(311)*y(86) +rxt(315)*y(87) +rxt(321)*y(88))*y(8) &
                  + (rxt(198)*y(99) +rxt(203)*y(100) +rxt(157)*y(22) +rxt(160)*y(16)) &
                 *y(25) + (.470_r8*rxt(290)*y(76) +rxt(309)*y(85) +rxt(324)*y(88)) &
                 *y(45) + (rxt(130)*y(22) +rxt(215)*y(16))*y(2) + (rxt(13) +rxt(154)) &
                 *y(10) + (rxt(233) +rxt(234))*y(53) + (1.340_r8*rxt(61) + &
                 .660_r8*rxt(62))*y(75) +rxt(108)*y(12)*y(3) +.700_r8*rxt(332)*y(95) &
                 *y(7) +rxt(184)*y(34)*y(16) +rxt(114)*y(19) +.794_r8*rxt(312)*y(86) &
                 *y(21) +1.200_r8*rxt(240)*y(43)*y(43) +rxt(64)*y(44) +rxt(56)*y(47) &
                  +2.000_r8*rxt(74)*y(49) +2.000_r8*rxt(77)*y(50) +rxt(66)*y(59) &
                  +rxt(57)*y(62) +rxt(73)*y(63) +rxt(69)*y(65) +.900_r8*rxt(78)*y(82) &
                  +.560_r8*rxt(76)*y(83) +rxt(71)*y(87) +rxt(72)*y(90) +rxt(81)*y(98) &
                  +rxt(224)*y(120)
         loss(68) = (rxt(130)* y(2) +rxt(125)* y(20) +rxt(157)* y(25) + rxt(20) &
                  + het_rates(22))* y(22)
         prod(68) = (.500_r8*rxt(348) +rxt(129)*y(21))*y(21) +rxt(123)*y(20)*y(20)
         loss(104) = (rxt(87)* y(3) + rxt(17) + rxt(18) + rxt(19) + het_rates(145)) &
                 * y(145)
         prod(104) = (rxt(199)*y(99) +rxt(200)*y(106) +rxt(201)*y(104) + &
                 rxt(202)*y(100) +rxt(206)*y(116) +rxt(210)*y(12) +rxt(121)*y(21) + &
                 rxt(122)*y(20) +rxt(124)*y(18) +rxt(125)*y(22) +rxt(147)*y(9) + &
                 rxt(153)*y(10) +rxt(174)*y(30) +rxt(178)*y(31) +rxt(194)*y(36) + &
                 rxt(214)*y(16) +rxt(222)*y(14) +rxt(223)*y(119) +rxt(229)*y(42) + &
                 rxt(236)*y(46) +rxt(242)*y(47) +rxt(249)*y(51) +rxt(261)*y(59) + &
                 rxt(262)*y(57) +rxt(265)*y(62) +rxt(266)*y(60) +rxt(270)*y(66) + &
                 rxt(272)*y(65) +.500_r8*rxt(283)*y(75) +rxt(325)*y(89) + &
                 rxt(326)*y(89) +rxt(347)*y(123))*y(20) + (rxt(353)*y(31) + &
                 rxt(354)*y(37) +rxt(358)*y(31) +rxt(364)*y(31) +rxt(365)*y(37))*y(30) &
                  +rxt(118)*y(21)*y(19)
         loss(120) = (rxt(155)* y(1) +rxt(161)* y(12) +rxt(160)* y(16) +rxt(156) &
                 * y(18) + (rxt(158) +rxt(159))* y(21) +rxt(157)* y(22) +rxt(177) &
                 * y(31) +rxt(181)* y(32) +rxt(227)* y(42) +rxt(198)* y(99) +rxt(203) &
                 * y(100) +rxt(209)* y(115) +rxt(208)* y(116) + het_rates(25))* y(25)
         prod(120) = (3.000_r8*rxt(91)*y(101) +2.000_r8*rxt(92)*y(102) + &
                 3.000_r8*rxt(93)*y(103) +2.000_r8*rxt(94)*y(111) +rxt(95)*y(112) + &
                 rxt(96)*y(104) +2.000_r8*rxt(97)*y(109) +rxt(98)*y(110) + &
                 4.000_r8*rxt(99)*y(105) +rxt(101)*y(108) +rxt(111)*y(30))*y(3) &
                  + (rxt(22) +rxt(162)*y(2) +rxt(163)*y(20) +rxt(166)*y(13) + &
                 rxt(167)*y(6) +2.000_r8*rxt(169)*y(27) +rxt(171)*y(27) + &
                 rxt(191)*y(35))*y(27) + (rxt(199)*y(99) +3.000_r8*rxt(200)*y(106) + &
                 rxt(201)*y(104) +2.000_r8*rxt(204)*y(109) +rxt(205)*y(110) + &
                 rxt(174)*y(30))*y(20) + (rxt(26) +rxt(175)*y(2))*y(30) &
                  +2.000_r8*rxt(21)*y(26) +2.000_r8*rxt(24)*y(29) +rxt(25)*y(31) &
                  +rxt(27)*y(32) +rxt(29)*y(33)
         loss(32) = ( + rxt(21) + het_rates(26))* y(26)
         prod(32) = (rxt(352)*y(32) +rxt(353)*y(31) +rxt(357)*y(32) +rxt(358)*y(31) + &
                 rxt(363)*y(32) +rxt(364)*y(31))*y(30) +rxt(181)*y(32)*y(25) &
                  +rxt(170)*y(27)*y(27)
         loss(117) = (rxt(162)* y(2) +rxt(167)* y(6) +rxt(168)* y(7) +rxt(166)* y(13) &
                  + (rxt(163) +rxt(164))* y(20) +rxt(165)* y(21) + 2._r8*(rxt(169) + &
                 rxt(170) +rxt(171) +rxt(172))* y(27) + (rxt(190) +rxt(191) +rxt(192)) &
                 * y(35) + rxt(22) + het_rates(27))* y(27)
         prod(117) = (rxt(155)*y(1) +rxt(159)*y(21) +rxt(177)*y(31))*y(25) &
                  + (rxt(176)*y(31) +rxt(179)*y(32))*y(2) +rxt(178)*y(31)*y(20) &
                  +rxt(23)*y(28) +2.000_r8*rxt(173)*y(29) +rxt(28)*y(32)
         loss(30) = ( + rxt(23) + het_rates(28))* y(28)
         prod(30) = (rxt(171)*y(27) +rxt(190)*y(35))*y(27)
         loss(20) = ( + rxt(24) + rxt(173) + het_rates(29))* y(29)
         prod(20) =rxt(172)*y(27)*y(27)
         loss(113) = (rxt(175)* y(2) +rxt(111)* y(3) +rxt(174)* y(20) + (rxt(353) + &
                 rxt(358) +rxt(364))* y(31) + (rxt(352) +rxt(357) +rxt(363))* y(32) &
                  + (rxt(354) +rxt(365))* y(37) + rxt(26) + het_rates(30))* y(30)
         prod(113) = (rxt(161)*y(12) +2.000_r8*rxt(198)*y(99) +rxt(203)*y(100) + &
                 rxt(208)*y(116) +rxt(209)*y(115) +rxt(156)*y(18) +rxt(157)*y(22) + &
                 rxt(158)*y(21) +rxt(160)*y(16) +rxt(177)*y(31) +rxt(227)*y(42))*y(25) &
                  +rxt(164)*y(27)*y(20)
         loss(85) = (rxt(176)* y(2) +rxt(178)* y(20) +rxt(177)* y(25) + (rxt(353) + &
                 rxt(358) +rxt(364))* y(30) + rxt(25) + het_rates(31))* y(31)
         prod(85) = (rxt(350) +rxt(356) +rxt(361) +rxt(180)*y(20))*y(32) &
                  +rxt(165)*y(27)*y(21)
         loss(86) = (rxt(179)* y(2) +rxt(180)* y(20) +rxt(181)* y(25) + (rxt(352) + &
                 rxt(357) +rxt(363))* y(30) + rxt(27) + rxt(28) + rxt(350) + rxt(356) &
                  + rxt(361) + het_rates(32))* y(32)
         prod(86) =rxt(168)*y(27)*y(7)
         loss(36) = ( + rxt(29) + het_rates(33))* y(33)
         prod(36) = (rxt(354)*y(37) +rxt(365)*y(37))*y(30) +rxt(192)*y(35)*y(27)
         loss(118) = (rxt(182)* y(1) +rxt(184)* y(16) +rxt(183)* y(21) &
                  + het_rates(34))* y(34)
         prod(118) = (rxt(100)*y(100) +rxt(101)*y(108) +rxt(102)*y(107) + &
                 2.000_r8*rxt(103)*y(113) +2.000_r8*rxt(104)*y(114) + &
                 3.000_r8*rxt(105)*y(115) +2.000_r8*rxt(106)*y(116) +rxt(112)*y(36)) &
                 *y(3) + (rxt(30) +rxt(185)*y(2) +rxt(186)*y(20) +rxt(188)*y(6) + &
                 rxt(190)*y(27) +rxt(191)*y(27) +2.000_r8*rxt(193)*y(35))*y(35) &
                  + (rxt(202)*y(100) +2.000_r8*rxt(206)*y(116) + &
                 3.000_r8*rxt(207)*y(115) +rxt(194)*y(36))*y(20) + (rxt(203)*y(100) + &
                 2.000_r8*rxt(208)*y(116) +3.000_r8*rxt(209)*y(115))*y(25) &
                  + (rxt(34) +rxt(195)*y(2))*y(36) +rxt(29)*y(33) +rxt(31)*y(37) &
                  +rxt(32)*y(38)
         loss(106) = (rxt(185)* y(2) +rxt(188)* y(6) +rxt(189)* y(7) +rxt(186)* y(20) &
                  +rxt(187)* y(21) + (rxt(190) +rxt(191) +rxt(192))* y(27) &
                  + 2._r8*rxt(193)* y(35) + rxt(30) + het_rates(35))* y(35)
         prod(106) = (rxt(196)*y(37) +rxt(197)*y(38))*y(2) +rxt(182)*y(34)*y(1) &
                  +rxt(33)*y(38)
         loss(81) = (rxt(195)* y(2) +rxt(112)* y(3) +rxt(194)* y(20) + rxt(34) &
                  + het_rates(36))* y(36)
         prod(81) = (rxt(183)*y(21) +rxt(184)*y(16))*y(34)
         loss(79) = (rxt(196)* y(2) + (rxt(354) +rxt(365))* y(30) + rxt(31) &
                  + het_rates(37))* y(37)
         prod(79) = (rxt(351) +rxt(359) +rxt(362))*y(38) +rxt(187)*y(35)*y(21)
         loss(67) = (rxt(197)* y(2) + rxt(32) + rxt(33) + rxt(351) + rxt(359) &
                  + rxt(362) + het_rates(38))* y(38)
         prod(67) =rxt(189)*y(35)*y(7)
         loss(89) = (rxt(256)* y(1) +rxt(257)* y(8) +rxt(255)* y(20) + het_rates(56)) &
                 * y(56)
         prod(89) =.070_r8*rxt(302)*y(80)*y(1) +.700_r8*rxt(63)*y(74)
         loss(84) = (rxt(302)* y(1) +rxt(303)* y(8) +rxt(301)* y(20) + het_rates(80)) &
                 * y(80)
         prod(84) = 0._r8
         loss(77) = (rxt(263)* y(6) +rxt(264)* y(21) + het_rates(61))* y(61)
         prod(77) = (rxt(255)*y(56) +.500_r8*rxt(265)*y(62))*y(20)
         loss(95) = (rxt(243)* y(8) +rxt(242)* y(20) + rxt(56) + het_rates(47))* y(47)
         prod(95) = (rxt(237)*y(43) +.270_r8*rxt(258)*y(58) +rxt(263)*y(61) + &
                 rxt(276)*y(70) +rxt(280)*y(71) +.400_r8*rxt(317)*y(81))*y(6) &
                  + (.500_r8*rxt(256)*y(56) +.040_r8*rxt(278)*y(74))*y(1) &
                  + (.500_r8*rxt(241)*y(44) +rxt(252)*y(48))*y(20) &
                  + (.800_r8*rxt(239)*y(13) +1.600_r8*rxt(240)*y(43))*y(43) +rxt(64) &
                 *y(44) +rxt(57)*y(62) +rxt(79)*y(72) +.400_r8*rxt(78)*y(82)
         loss(71) = (rxt(236)* y(20) + het_rates(46))* y(46)
         prod(71) = (.250_r8*rxt(256)*y(56) +.200_r8*rxt(302)*y(80))*y(1) &
                  + (.250_r8*rxt(246)*y(45) +.250_r8*rxt(294)*y(73))*y(21) &
                  +.100_r8*rxt(247)*y(45)*y(13)
         loss(65) = (rxt(265)* y(20) + rxt(57) + het_rates(62))* y(62)
         prod(65) =rxt(264)*y(61)*y(21)
         loss(103) = (rxt(244)* y(6) +rxt(245)* y(7) +rxt(247)* y(13) +rxt(246)* y(21) &
                  + 2._r8*rxt(248)* y(45) +rxt(290)* y(76) +rxt(309)* y(85) +rxt(324) &
                 * y(88) + het_rates(45))* y(45)
         prod(103) = (rxt(267)*y(64) +rxt(280)*y(71) +.530_r8*rxt(285)*y(76) + &
                 rxt(292)*y(73))*y(6) + (rxt(243)*y(47) +rxt(273)*y(65) + &
                 .530_r8*rxt(287)*y(76) +rxt(293)*y(73))*y(8) &
                  + (.300_r8*rxt(269)*y(64) +.260_r8*rxt(289)*y(76) +rxt(295)*y(73)) &
                 *y(13) + (rxt(242)*y(47) +.500_r8*rxt(249)*y(51) +rxt(272)*y(65)) &
                 *y(20) + (.600_r8*rxt(59) +rxt(253))*y(55) +.530_r8*rxt(290)*y(76) &
                 *y(45) +rxt(68)*y(60) +rxt(73)*y(63) +rxt(69)*y(65) +rxt(67)*y(66) &
                  +rxt(75)*y(69) +rxt(79)*y(72) +2.000_r8*rxt(297)*y(73)*y(73) &
                  +.300_r8*rxt(63)*y(74) +1.340_r8*rxt(61)*y(75) +.130_r8*rxt(76) &
                 *y(83)
         loss(60) = (rxt(249)* y(20) + rxt(58) + het_rates(51))* y(51)
         prod(60) = (.750_r8*rxt(246)*y(45) +.750_r8*rxt(294)*y(73))*y(21)
         loss(58) = (rxt(254)* y(20) + rxt(59) + rxt(253) + het_rates(55))* y(55)
         prod(58) =rxt(245)*y(45)*y(7)
         loss(52) = (rxt(274)* y(20) + het_rates(79))* y(79)
         prod(52) =.100_r8*rxt(317)*y(81)*y(6) +rxt(257)*y(56)*y(8)
         loss(40) = (rxt(229)* y(20) +rxt(227)* y(25) + het_rates(42))* y(42)
         prod(40) = 0._r8
         loss(47) = (rxt(235)* y(1) +rxt(230)* y(20) + het_rates(41))* y(41)
         prod(47) = 0._r8
         loss(21) = (rxt(313)* y(20) + het_rates(68))* y(68)
         prod(21) = 0._r8
         loss(63) = (rxt(300)* y(20) + rxt(60) + rxt(299) + het_rates(78))* y(78)
         prod(63) =rxt(298)*y(73)*y(7)
         loss(22) = (rxt(275)* y(20) + het_rates(67))* y(67)
         prod(22) = 0._r8
         loss(42) = (rxt(276)* y(6) + het_rates(70))* y(70)
         prod(42) =rxt(275)*y(67)*y(20)
         loss(75) = (rxt(317)* y(6) +rxt(318)* y(21) + het_rates(81))* y(81)
         prod(75) = (rxt(313)*y(68) +rxt(319)*y(82))*y(20)
         loss(73) = (rxt(319)* y(20) + rxt(78) + het_rates(82))* y(82)
         prod(73) =rxt(318)*y(81)*y(21)
         loss(56) = (rxt(279)* y(20) + rxt(75) + het_rates(69))* y(69)
         prod(56) =.800_r8*rxt(317)*y(81)*y(6) +.800_r8*rxt(78)*y(82)
         loss(74) = (rxt(280)* y(6) +rxt(281)* y(21) + het_rates(71))* y(71)
         prod(74) = (rxt(279)*y(69) +rxt(282)*y(72))*y(20)
         loss(43) = (rxt(282)* y(20) + rxt(79) + het_rates(72))* y(72)
         prod(43) =rxt(281)*y(71)*y(21)
         loss(27) = (rxt(327)* y(20) + het_rates(91))* y(91)
         prod(27) = 0._r8
         loss(28) = (rxt(331)* y(20) + het_rates(92))* y(92)
         prod(28) =.250_r8*rxt(327)*y(91)*y(20)
         loss(61) = (rxt(328)* y(6) +rxt(329)* y(21) + het_rates(93))* y(93)
         prod(61) = (.700_r8*rxt(327)*y(91) +rxt(330)*y(94))*y(20)
         loss(49) = (rxt(330)* y(20) + rxt(80) + het_rates(94))* y(94)
         prod(49) =rxt(329)*y(93)*y(21)
         loss(33) = (rxt(332)* y(7) + het_rates(95))* y(95)
         prod(33) =rxt(331)*y(92)*y(20)
         loss(93) = (rxt(336)* y(6) +rxt(337)* y(21) + het_rates(97))* y(97)
         prod(93) = (rxt(333)*y(96) +rxt(338)*y(98))*y(20) +rxt(335)*y(96)*y(8)
         loss(57) = (rxt(338)* y(20) + rxt(81) + het_rates(98))* y(98)
         prod(57) =rxt(337)*y(97)*y(21)
         loss(62) = ( + rxt(76) + het_rates(83))* y(83)
         prod(62) =.900_r8*rxt(328)*y(93)*y(6) +.700_r8*rxt(332)*y(95)*y(7) &
                  +.900_r8*rxt(80)*y(94)
         loss(72) = (rxt(251)* y(20) + rxt(77) + het_rates(50))* y(50)
         prod(72) = (.250_r8*rxt(320)*y(6) +.250_r8*rxt(321)*y(8) + &
                 .100_r8*rxt(323)*y(13) +.250_r8*rxt(324)*y(45))*y(88) &
                  + (.650_r8*rxt(228)*y(118) +.200_r8*rxt(250)*y(49))*y(20) &
                  +.450_r8*rxt(328)*y(93)*y(6) +.130_r8*rxt(76)*y(83) +.450_r8*rxt(80) &
                 *y(94)
         loss(101) = (rxt(304)* y(6) +rxt(305)* y(8) +rxt(308)* y(13) +rxt(306)* y(21) &
                  +rxt(309)* y(45) + het_rates(85))* y(85)
         prod(101) = (rxt(301)*y(80) +.200_r8*rxt(307)*y(90))*y(20)
         loss(99) = (rxt(278)* y(1) +rxt(277)* y(20) + rxt(63) + het_rates(74))* y(74)
         prod(99) = (.320_r8*rxt(304)*y(6) +.350_r8*rxt(305)*y(8) + &
                 .260_r8*rxt(308)*y(13) +.350_r8*rxt(309)*y(45))*y(85) &
                  + (.039_r8*rxt(310)*y(6) +.039_r8*rxt(311)*y(8) + &
                 .039_r8*rxt(312)*y(21))*y(86) + (.200_r8*rxt(302)*y(80) + &
                 rxt(334)*y(96))*y(1) +rxt(336)*y(97)*y(6) +.402_r8*rxt(72)*y(90) &
                  +rxt(81)*y(98)
         loss(96) = (rxt(284)* y(1) +rxt(283)* y(20) + rxt(61) + rxt(62) &
                  + het_rates(75))* y(75)
         prod(96) = (.230_r8*rxt(304)*y(6) +.250_r8*rxt(305)*y(8) + &
                 .190_r8*rxt(308)*y(13) +.250_r8*rxt(309)*y(45))*y(85) &
                  + (.167_r8*rxt(310)*y(6) +.167_r8*rxt(311)*y(8) + &
                 .167_r8*rxt(312)*y(21))*y(86) + (.400_r8*rxt(302)*y(80) + &
                 rxt(334)*y(96))*y(1) +rxt(336)*y(97)*y(6) +.288_r8*rxt(72)*y(90) &
                  +rxt(81)*y(98)
         loss(100) = ((rxt(285) +rxt(286))* y(6) +rxt(287)* y(8) +rxt(289)* y(13) &
                  +rxt(288)* y(21) +rxt(290)* y(45) + het_rates(76))* y(76)
         prod(100) = (rxt(277)*y(74) +.500_r8*rxt(283)*y(75) +.200_r8*rxt(291)*y(77)) &
                 *y(20)
         loss(44) = (rxt(291)* y(20) + het_rates(77))* y(77)
         prod(44) =rxt(288)*y(76)*y(21)
         loss(102) = (rxt(292)* y(6) +rxt(298)* y(7) +rxt(293)* y(8) +rxt(295)* y(13) &
                  +rxt(294)* y(21) +rxt(296)* y(45) + 2._r8*rxt(297)* y(73) &
                  + het_rates(73))* y(73)
         prod(102) = (.500_r8*rxt(283)*y(75) +.500_r8*rxt(291)*y(77))*y(20) &
                  + (rxt(60) +rxt(299))*y(78) +.200_r8*rxt(302)*y(80)*y(1) &
                  +.660_r8*rxt(61)*y(75)
         loss(78) = (rxt(237)* y(6) +rxt(239)* y(13) +rxt(238)* y(21) + 2._r8*rxt(240) &
                 * y(43) + het_rates(43))* y(43)
         prod(78) = (rxt(229)*y(42) +.500_r8*rxt(241)*y(44))*y(20) +rxt(227)*y(42) &
                 *y(25) +rxt(75)*y(69)
         loss(45) = (rxt(241)* y(20) + rxt(64) + het_rates(44))* y(44)
         prod(45) =rxt(238)*y(43)*y(21)
         loss(69) = (rxt(334)* y(1) +rxt(335)* y(8) +rxt(333)* y(20) + het_rates(96)) &
                 * y(96)
         prod(69) = 0._r8
         loss(25) = (rxt(262)* y(20) + het_rates(57))* y(57)
         prod(25) = 0._r8
         loss(82) = (rxt(258)* y(6) +rxt(260)* y(13) +rxt(259)* y(21) + het_rates(58)) &
                 * y(58)
         prod(82) = (rxt(261)*y(59) +rxt(262)*y(57))*y(20)
         loss(50) = (rxt(261)* y(20) + rxt(66) + het_rates(59))* y(59)
         prod(50) =rxt(259)*y(58)*y(21)
         loss(76) = (rxt(266)* y(20) + rxt(68) + het_rates(60))* y(60)
         prod(76) = (.820_r8*rxt(258)*y(58) +.500_r8*rxt(276)*y(70) + &
                 .250_r8*rxt(317)*y(81) +.100_r8*rxt(336)*y(97))*y(6) &
                  +.820_r8*rxt(260)*y(58)*y(13) +.820_r8*rxt(66)*y(59) &
                  +.250_r8*rxt(78)*y(82) +.100_r8*rxt(81)*y(98)
         loss(51) = (rxt(270)* y(20) + rxt(67) + het_rates(66))* y(66)
         prod(51) =rxt(268)*y(64)*y(21)
         loss(64) = (rxt(221)* y(20) + het_rates(15))* y(15)
         prod(64) = (rxt(220)*y(13) +.300_r8*rxt(239)*y(43) +.500_r8*rxt(269)*y(64) + &
                 .250_r8*rxt(289)*y(76) +.250_r8*rxt(308)*y(85) + &
                 .300_r8*rxt(323)*y(88))*y(13)
         loss(38) = (rxt(252)* y(20) + het_rates(48))* y(48)
         prod(38) = (.200_r8*rxt(239)*y(13) +.400_r8*rxt(240)*y(43))*y(43)
         loss(80) = (rxt(250)* y(20) + rxt(74) + het_rates(49))* y(49)
         prod(80) = (.530_r8*rxt(285)*y(6) +.530_r8*rxt(287)*y(8) + &
                 .260_r8*rxt(289)*y(13) +.530_r8*rxt(290)*y(45))*y(76) &
                  + (.250_r8*rxt(320)*y(6) +.250_r8*rxt(321)*y(8) + &
                 .100_r8*rxt(323)*y(13) +.250_r8*rxt(324)*y(45))*y(88) +rxt(233)*y(53)
         loss(94) = (rxt(271)* y(20) + rxt(73) + het_rates(63))* y(63)
         prod(94) = (.220_r8*rxt(285)*y(6) +.220_r8*rxt(287)*y(8) + &
                 .230_r8*rxt(289)*y(13) +.220_r8*rxt(290)*y(45))*y(76) &
                  + (.250_r8*rxt(320)*y(6) +.250_r8*rxt(321)*y(8) + &
                 .100_r8*rxt(323)*y(13) +.250_r8*rxt(324)*y(45))*y(88) &
                  + (.500_r8*rxt(265)*y(62) +.500_r8*rxt(300)*y(78))*y(20) &
                  +.200_r8*rxt(269)*y(64)*y(13)
         loss(70) = (rxt(231)* y(6) +rxt(232)* y(21) + het_rates(52))* y(52)
         prod(70) =rxt(230)*y(41)*y(20)
         loss(39) = ( + rxt(233) + rxt(234) + het_rates(53))* y(53)
         prod(39) =.750_r8*rxt(231)*y(52)*y(6) +rxt(65)*y(54)
         loss(29) = ( + rxt(65) + het_rates(54))* y(54)
         prod(29) =rxt(232)*y(52)*y(21)
         loss(48) = (rxt(316)* y(20) + het_rates(84))* y(84)
         prod(48) = (.370_r8*rxt(304)*y(6) +.400_r8*rxt(305)*y(8) + &
                 .300_r8*rxt(308)*y(13) +.400_r8*rxt(309)*y(45))*y(85) &
                  + (rxt(314)*y(20) +rxt(315)*y(8))*y(87)
         loss(88) = (rxt(267)* y(6) +rxt(269)* y(13) +rxt(268)* y(21) + het_rates(64)) &
                 * y(64)
         prod(88) = (rxt(266)*y(60) +rxt(270)*y(66))*y(20)
         loss(97) = (rxt(273)* y(8) +rxt(272)* y(20) + rxt(69) + het_rates(65))* y(65)
         prod(97) = (.250_r8*rxt(285)*y(6) +.250_r8*rxt(287)*y(8) + &
                 .240_r8*rxt(289)*y(13) +.250_r8*rxt(290)*y(45))*y(76) &
                  + (.250_r8*rxt(320)*y(6) +.250_r8*rxt(321)*y(8) + &
                 .100_r8*rxt(323)*y(13) +.250_r8*rxt(324)*y(45))*y(88) &
                  + (.950_r8*rxt(278)*y(74) +.800_r8*rxt(284)*y(75))*y(1) &
                  + (rxt(271)*y(63) +rxt(274)*y(79))*y(20) +.450_r8*rxt(328)*y(93) &
                 *y(6) +.500_r8*rxt(269)*y(64)*y(13) +.180_r8*rxt(76)*y(83) &
                  +.450_r8*rxt(80)*y(94)
         loss(90) = (rxt(310)* y(6) +rxt(311)* y(8) +rxt(312)* y(21) + het_rates(86)) &
                 * y(86)
         prod(90) =rxt(303)*y(80)*y(8)
         loss(87) = (rxt(315)* y(8) +rxt(314)* y(20) + rxt(71) + het_rates(87))* y(87)
         prod(87) = (.800_r8*rxt(286)*y(76) +.080_r8*rxt(304)*y(85) + &
                 .794_r8*rxt(310)*y(86))*y(6) + (.794_r8*rxt(311)*y(8) + &
                 .794_r8*rxt(312)*y(21))*y(86)
         loss(98) = (rxt(320)* y(6) +rxt(321)* y(8) +rxt(323)* y(13) +rxt(322)* y(21) &
                  +rxt(324)* y(45) + het_rates(88))* y(88)
         prod(98) = (.800_r8*rxt(307)*y(90) +rxt(316)*y(84) +rxt(325)*y(89))*y(20)
         loss(46) = ((rxt(325) +rxt(326))* y(20) + rxt(70) + het_rates(89))* y(89)
         prod(46) = (rxt(312)*y(86) +rxt(322)*y(88))*y(21)
         loss(66) = (rxt(307)* y(20) + rxt(72) + het_rates(90))* y(90)
         prod(66) =rxt(306)*y(85)*y(21)
         loss(31) = (rxt(228)* y(20) + het_rates(118))* y(118)
         prod(31) = 0._r8
         loss(53) = (rxt(223)* y(20) + het_rates(119))* y(119)
         prod(53) = (rxt(225)*y(6) +rxt(226)*y(21))*y(120) +.500_r8*rxt(235)*y(41) &
                 *y(1) +.350_r8*rxt(228)*y(118)*y(20)
         loss(59) = (rxt(225)* y(6) +rxt(226)* y(21) + rxt(224) + het_rates(120)) &
                 * y(120)
         prod(59) =rxt(216)*y(21)*y(16)
         loss(26) = (rxt(343)* y(20) + het_rates(121))* y(121)
         prod(26) = (rxt(344)*y(20) +.500_r8*rxt(345)*y(20) +rxt(346)*y(8))*y(122)
         loss(37) = (rxt(346)* y(8) + (rxt(344) +rxt(345))* y(20) + het_rates(122)) &
                 * y(122)
         prod(37) = 0._r8
         loss(23) = (rxt(347)* y(20) + het_rates(123))* y(123)
         prod(23) = 0._r8
         loss(1) = ( + het_rates(124))* y(124)
         prod(1) = 0._r8
         loss(2) = ( + het_rates(129))* y(129)
         prod(2) = 0._r8
         loss(3) = ( + het_rates(127))* y(127)
         prod(3) =rxt(343)*y(121)*y(20)
         loss(4) = ( + het_rates(128))* y(128)
         prod(4) = 0._r8
         loss(5) = ( + het_rates(130))* y(130)
         prod(5) = 0._r8
         loss(6) = ( + het_rates(131))* y(131)
         prod(6) = 0._r8
         loss(7) = ( + het_rates(132))* y(132)
         prod(7) = 0._r8
         loss(8) = ( + het_rates(133))* y(133)
         prod(8) = 0._r8
         loss(9) = ( + het_rates(134))* y(134)
         prod(9) = 0._r8
         loss(10) = ( + het_rates(135))* y(135)
         prod(10) = 0._r8
         loss(11) = ( + het_rates(136))* y(136)
         prod(11) = 0._r8
         loss(12) = ( + het_rates(137))* y(137)
         prod(12) = 0._r8
         loss(13) = ( + het_rates(138))* y(138)
         prod(13) = 0._r8
         loss(14) = ( + het_rates(139))* y(139)
         prod(14) = 0._r8
         loss(15) = ( + het_rates(140))* y(140)
         prod(15) = 0._r8
         loss(16) = ( + het_rates(141))* y(141)
         prod(16) = 0._r8
         loss(17) = ( + het_rates(142))* y(142)
         prod(17) = 0._r8
         loss(18) = ( + het_rates(143))* y(143)
         prod(18) = 0._r8
         loss(19) = ( + het_rates(144))* y(144)
         prod(19) = 0._r8

      end subroutine imp_prod_loss

      end module mo_prod_loss
