




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(951) = -(rxt(83)*y(2) + rxt(90)*y(3) + rxt(115)*y(19) + rxt(120)*y(20) &
                      + rxt(128)*y(21) + rxt(140)*y(6) + rxt(143)*y(7) + rxt(155) &
                      *y(25) + rxt(182)*y(34) + rxt(235)*y(41) + rxt(256)*y(56) &
                      + rxt(278)*y(74) + rxt(284)*y(75) + rxt(302)*y(80) + rxt(334) &
                      *y(96))
         mat(1176) = -rxt(83)*y(1)
         mat(1084) = -rxt(90)*y(1)
         mat(700) = -rxt(115)*y(1)
         mat(1064) = -rxt(120)*y(1)
         mat(1151) = -rxt(128)*y(1)
         mat(847) = -rxt(140)*y(1)
         mat(1231) = -rxt(143)*y(1)
         mat(796) = -rxt(155)*y(1)
         mat(750) = -rxt(182)*y(1)
         mat(151) = -rxt(235)*y(1)
         mat(484) = -rxt(256)*y(1)
         mat(598) = -rxt(278)*y(1)
         mat(553) = -rxt(284)*y(1)
         mat(426) = -rxt(302)*y(1)
         mat(293) = -rxt(334)*y(1)

         mat(951) = mat(951) + .100_r8*rxt(302)*y(80) + .200_r8*rxt(278)*y(74) &
                      + .200_r8*rxt(284)*y(75)
         mat(1151) = mat(1151) + .250_r8*rxt(246)*y(45) + .250_r8*rxt(294)*y(73)
         mat(426) = mat(426) + .100_r8*rxt(302)*y(1)
         mat(684) = .250_r8*rxt(246)*y(21)
         mat(598) = mat(598) + .200_r8*rxt(278)*y(1)
         mat(553) = mat(553) + .200_r8*rxt(284)*y(1)
         mat(658) = .250_r8*rxt(294)*y(21)

         mat(1181) = -(rxt(83)*y(1) + 4._r8*rxt(84)*y(2) + rxt(119)*y(20) + rxt(126) &
                      *y(18) + rxt(127)*y(21) + rxt(130)*y(22) + rxt(138)*y(6) &
                      + (rxt(141) + rxt(142)) * y(7) + rxt(149)*y(8) + rxt(162)*y(27) &
                      + rxt(175)*y(30) + rxt(176)*y(31) + rxt(179)*y(32) + rxt(185) &
                      *y(35) + rxt(195)*y(36) + rxt(196)*y(37) + rxt(197)*y(38) &
                      + rxt(215)*y(16))
         mat(956) = -rxt(83)*y(2)
         mat(1069) = -rxt(119)*y(2)
         mat(509) = -rxt(126)*y(2)
         mat(1156) = -rxt(127)*y(2)
         mat(307) = -rxt(130)*y(2)
         mat(852) = -rxt(138)*y(2)
         mat(1236) = -(rxt(141) + rxt(142)) * y(2)
         mat(917) = -rxt(149)*y(2)
         mat(875) = -rxt(162)*y(2)
         mat(978) = -rxt(175)*y(2)
         mat(436) = -rxt(176)*y(2)
         mat(447) = -rxt(179)*y(2)
         mat(1202) = -rxt(185)*y(2)
         mat(394) = -rxt(195)*y(2)
         mat(380) = -rxt(196)*y(2)
         mat(260) = -rxt(197)*y(2)
         mat(774) = -rxt(215)*y(2)

         mat(85) = rxt(134)*y(6) + rxt(135)*y(7)
         mat(852) = mat(852) + rxt(134)*y(5)
         mat(1236) = mat(1236) + rxt(135)*y(5)
         mat(1069) = mat(1069) + 2.000_r8*rxt(122)*y(20)
         mat(705) = rxt(118)*y(21)
         mat(1156) = mat(1156) + rxt(118)*y(19)

         mat(1087) = -(rxt(87)*y(160) + rxt(90)*y(1) + rxt(110)*y(18) + rxt(111)*y(30) &
                      + rxt(112)*y(36) + rxt(113)*y(39))
         mat(694) = -rxt(87)*y(3)
         mat(954) = -rxt(90)*y(3)
         mat(508) = -rxt(110)*y(3)
         mat(976) = -rxt(111)*y(3)
         mat(393) = -rxt(112)*y(3)
         mat(89) = -rxt(113)*y(3)

         mat(502) = -(rxt(110)*y(3) + rxt(124)*y(20) + rxt(126)*y(2) + rxt(156)*y(25))
         mat(1074) = -rxt(110)*y(18)
         mat(1042) = -rxt(124)*y(18)
         mat(1166) = -rxt(126)*y(18)
         mat(783) = -rxt(156)*y(18)

         mat(696) = rxt(117)*y(21)
         mat(1129) = rxt(117)*y(19)

         mat(510) = -((rxt(211) + rxt(212)) * y(20))
         mat(1043) = -(rxt(211) + rxt(212)) * y(17)

         mat(930) = .560_r8*rxt(256)*y(56) + .300_r8*rxt(302)*y(80) + .500_r8*rxt(235) &
                      *y(41) + .050_r8*rxt(278)*y(74) + .200_r8*rxt(284)*y(75)
         mat(1167) = rxt(215)*y(16)
         mat(826) = .220_r8*rxt(285)*y(76) + .500_r8*rxt(320)*y(88)
         mat(1043) = mat(1043) + rxt(214)*y(16) + rxt(251)*y(50) + rxt(272)*y(65) &
                      + .350_r8*rxt(228)*y(118)
         mat(892) = rxt(213)*y(16) + .220_r8*rxt(287)*y(76) + rxt(273)*y(65) &
                      + .500_r8*rxt(321)*y(88)
         mat(716) = .110_r8*rxt(289)*y(76) + .200_r8*rxt(323)*y(88)
         mat(761) = rxt(215)*y(2) + rxt(214)*y(20) + rxt(213)*y(8) + rxt(160)*y(25) &
                      + rxt(184)*y(34)
         mat(784) = rxt(160)*y(16)
         mat(744) = rxt(184)*y(16)
         mat(475) = .560_r8*rxt(256)*y(1)
         mat(417) = .300_r8*rxt(302)*y(1)
         mat(668) = .220_r8*rxt(290)*y(76) + .500_r8*rxt(324)*y(88)
         mat(149) = .500_r8*rxt(235)*y(1)
         mat(309) = rxt(251)*y(20)
         mat(585) = .050_r8*rxt(278)*y(1)
         mat(544) = .200_r8*rxt(284)*y(1)
         mat(606) = .220_r8*rxt(285)*y(6) + .220_r8*rxt(287)*y(8) + .110_r8*rxt(289) &
                      *y(13) + .220_r8*rxt(290)*y(45)
         mat(557) = rxt(272)*y(20) + rxt(273)*y(8)
         mat(570) = .500_r8*rxt(320)*y(6) + .500_r8*rxt(321)*y(8) + .200_r8*rxt(323) &
                      *y(13) + .500_r8*rxt(324)*y(45)
         mat(74) = .350_r8*rxt(228)*y(20)

         mat(83) = -(rxt(134)*y(6) + (rxt(135) + rxt(136) + rxt(137)) * y(7))
         mat(804) = -rxt(134)*y(5)
         mat(1206) = -(rxt(135) + rxt(136) + rxt(137)) * y(5)

         mat(844) = -(rxt(134)*y(5) + rxt(138)*y(2) + rxt(139)*y(21) + rxt(140)*y(1) &
                      + rxt(148)*y(8) + rxt(167)*y(27) + rxt(188)*y(35) + rxt(217) &
                      *y(13) + rxt(225)*y(120) + rxt(231)*y(52) + rxt(237)*y(43) &
                      + rxt(244)*y(45) + rxt(258)*y(58) + rxt(263)*y(61) + rxt(267) &
                      *y(64) + rxt(276)*y(70) + rxt(280)*y(71) + (rxt(285) + rxt(286) &
                      ) * y(76) + rxt(292)*y(73) + rxt(304)*y(85) + rxt(310)*y(86) &
                      + rxt(317)*y(81) + rxt(320)*y(88) + rxt(328)*y(93) + rxt(336) &
                      *y(97))
         mat(84) = -rxt(134)*y(6)
         mat(1173) = -rxt(138)*y(6)
         mat(1148) = -rxt(139)*y(6)
         mat(948) = -rxt(140)*y(6)
         mat(909) = -rxt(148)*y(6)
         mat(867) = -rxt(167)*y(6)
         mat(1194) = -rxt(188)*y(6)
         mat(733) = -rxt(217)*y(6)
         mat(211) = -rxt(225)*y(6)
         mat(284) = -rxt(231)*y(6)
         mat(369) = -rxt(237)*y(6)
         mat(682) = -rxt(244)*y(6)
         mat(404) = -rxt(258)*y(6)
         mat(358) = -rxt(263)*y(6)
         mat(523) = -rxt(267)*y(6)
         mat(143) = -rxt(276)*y(6)
         mat(327) = -rxt(280)*y(6)
         mat(617) = -(rxt(285) + rxt(286)) * y(6)
         mat(656) = -rxt(292)*y(6)
         mat(639) = -rxt(304)*y(6)
         mat(497) = -rxt(310)*y(6)
         mat(342) = -rxt(317)*y(6)
         mat(579) = -rxt(320)*y(6)
         mat(237) = -rxt(328)*y(6)
         mat(467) = -rxt(336)*y(6)

         mat(1173) = mat(1173) + rxt(141)*y(7)
         mat(84) = mat(84) + 2.000_r8*rxt(136)*y(7)
         mat(1228) = rxt(141)*y(2) + 2.000_r8*rxt(136)*y(5)

         mat(1238) = -((rxt(135) + rxt(136) + rxt(137)) * y(5) + (rxt(141) + rxt(142) &
                      ) * y(2) + rxt(143)*y(1) + rxt(144)*y(8) + rxt(146)*y(20) &
                      + rxt(152)*y(21) + rxt(168)*y(27) + rxt(189)*y(35) + rxt(245) &
                      *y(45) + rxt(298)*y(73) + rxt(332)*y(95))
         mat(86) = -(rxt(135) + rxt(136) + rxt(137)) * y(7)
         mat(1183) = -(rxt(141) + rxt(142)) * y(7)
         mat(958) = -rxt(143)*y(7)
         mat(919) = -rxt(144)*y(7)
         mat(1071) = -rxt(146)*y(7)
         mat(1158) = -rxt(152)*y(7)
         mat(877) = -rxt(168)*y(7)
         mat(1204) = -rxt(189)*y(7)
         mat(687) = -rxt(245)*y(7)
         mat(661) = -rxt(298)*y(7)
         mat(82) = -rxt(332)*y(7)

         mat(958) = mat(958) + rxt(140)*y(6)
         mat(1183) = mat(1183) + rxt(138)*y(6) + rxt(149)*y(8)
         mat(854) = rxt(140)*y(1) + rxt(138)*y(2) + 2.000_r8*rxt(148)*y(8) + rxt(217) &
                      *y(13) + rxt(139)*y(21) + rxt(167)*y(27) + rxt(188)*y(35) &
                      + rxt(263)*y(61) + rxt(244)*y(45) + rxt(276)*y(70) &
                      + .900_r8*rxt(317)*y(81) + rxt(280)*y(71) + .900_r8*rxt(328) &
                      *y(93) + rxt(336)*y(97) + .920_r8*rxt(304)*y(85) + rxt(285) &
                      *y(76) + rxt(292)*y(73) + rxt(237)*y(43) + rxt(258)*y(58) &
                      + rxt(231)*y(52) + rxt(267)*y(64) + 1.206_r8*rxt(310)*y(86) &
                      + rxt(320)*y(88) + rxt(225)*y(120)
         mat(1238) = mat(1238) + .700_r8*rxt(332)*y(95)
         mat(1071) = mat(1071) + rxt(150)*y(8) + rxt(153)*y(10) + rxt(274)*y(79) &
                      + .400_r8*rxt(314)*y(87)
         mat(919) = mat(919) + rxt(149)*y(2) + 2.000_r8*rxt(148)*y(6) + rxt(150)*y(20) &
                      + rxt(151)*y(21) + rxt(305)*y(85) + rxt(287)*y(76) + rxt(293) &
                      *y(73) + rxt(335)*y(96) + 1.206_r8*rxt(311)*y(86) + rxt(315) &
                      *y(87) + rxt(321)*y(88)
         mat(182) = rxt(153)*y(20)
         mat(742) = rxt(217)*y(6)
         mat(1158) = mat(1158) + rxt(139)*y(6) + rxt(151)*y(8) + .206_r8*rxt(312) &
                      *y(86)
         mat(877) = mat(877) + rxt(167)*y(6)
         mat(1204) = mat(1204) + rxt(188)*y(6)
         mat(361) = rxt(263)*y(6)
         mat(687) = mat(687) + rxt(244)*y(6)
         mat(172) = rxt(274)*y(20)
         mat(145) = rxt(276)*y(6)
         mat(345) = .900_r8*rxt(317)*y(6)
         mat(330) = rxt(280)*y(6)
         mat(240) = .900_r8*rxt(328)*y(6)
         mat(82) = mat(82) + .700_r8*rxt(332)*y(7)
         mat(470) = rxt(336)*y(6)
         mat(644) = .920_r8*rxt(304)*y(6) + rxt(305)*y(8)
         mat(621) = rxt(285)*y(6) + rxt(287)*y(8)
         mat(661) = mat(661) + rxt(292)*y(6) + rxt(293)*y(8)
         mat(372) = rxt(237)*y(6)
         mat(296) = rxt(335)*y(8)
         mat(407) = rxt(258)*y(6)
         mat(287) = rxt(231)*y(6)
         mat(526) = rxt(267)*y(6)
         mat(501) = 1.206_r8*rxt(310)*y(6) + 1.206_r8*rxt(311)*y(8) + .206_r8*rxt(312) &
                      *y(21)
         mat(457) = .400_r8*rxt(314)*y(20) + rxt(315)*y(8)
         mat(583) = rxt(320)*y(6) + rxt(321)*y(8)
         mat(214) = rxt(225)*y(6)

         mat(1066) = -(rxt(119)*y(2) + rxt(120)*y(1) + rxt(121)*y(21) + (4._r8*rxt(122) &
                      + 4._r8*rxt(123)) * y(20) + rxt(124)*y(18) + rxt(125)*y(22) &
                      + rxt(131)*y(39) + rxt(132)*y(40) + rxt(146)*y(7) + rxt(147) &
                      *y(9) + rxt(150)*y(8) + rxt(153)*y(10) + (rxt(163) + rxt(164) &
                      ) * y(27) + rxt(174)*y(30) + rxt(178)*y(31) + rxt(180)*y(32) &
                      + rxt(186)*y(35) + rxt(194)*y(36) + (rxt(211) + rxt(212) &
                      ) * y(17) + rxt(214)*y(16) + rxt(221)*y(15) + rxt(222)*y(14) &
                      + rxt(223)*y(119) + rxt(228)*y(118) + rxt(229)*y(42) + rxt(230) &
                      *y(41) + rxt(236)*y(46) + rxt(241)*y(44) + rxt(242)*y(47) &
                      + rxt(249)*y(51) + rxt(250)*y(49) + rxt(251)*y(50) + rxt(252) &
                      *y(48) + rxt(254)*y(55) + rxt(255)*y(56) + rxt(261)*y(59) &
                      + rxt(262)*y(57) + rxt(265)*y(62) + rxt(266)*y(60) + rxt(270) &
                      *y(66) + rxt(271)*y(63) + rxt(272)*y(65) + rxt(274)*y(79) &
                      + rxt(275)*y(67) + rxt(277)*y(74) + rxt(279)*y(69) + rxt(282) &
                      *y(72) + rxt(283)*y(75) + rxt(291)*y(77) + rxt(300)*y(78) &
                      + rxt(301)*y(80) + rxt(307)*y(90) + rxt(313)*y(68) + rxt(314) &
                      *y(87) + rxt(316)*y(84) + rxt(319)*y(82) + rxt(325)*y(89) &
                      + rxt(327)*y(91) + rxt(330)*y(94) + rxt(331)*y(92) + rxt(333) &
                      *y(96) + rxt(338)*y(98) + rxt(343)*y(121) + (rxt(344) + rxt(345) &
                      ) * y(122) + rxt(347)*y(123))
         mat(1178) = -rxt(119)*y(20)
         mat(953) = -rxt(120)*y(20)
         mat(1153) = -rxt(121)*y(20)
         mat(507) = -rxt(124)*y(20)
         mat(305) = -rxt(125)*y(20)
         mat(88) = -rxt(131)*y(20)
         mat(45) = -rxt(132)*y(20)
         mat(1233) = -rxt(146)*y(20)
         mat(411) = -rxt(147)*y(20)
         mat(914) = -rxt(150)*y(20)
         mat(180) = -rxt(153)*y(20)
         mat(872) = -(rxt(163) + rxt(164)) * y(20)
         mat(975) = -rxt(174)*y(20)
         mat(435) = -rxt(178)*y(20)
         mat(446) = -rxt(180)*y(20)
         mat(1199) = -rxt(186)*y(20)
         mat(392) = -rxt(194)*y(20)
         mat(512) = -(rxt(211) + rxt(212)) * y(20)
         mat(771) = -rxt(214)*y(20)
         mat(230) = -rxt(221)*y(20)
         mat(188) = -rxt(222)*y(20)
         mat(175) = -rxt(223)*y(20)
         mat(75) = -rxt(228)*y(20)
         mat(119) = -rxt(229)*y(20)
         mat(152) = -rxt(230)*y(20)
         mat(300) = -rxt(236)*y(20)
         mat(133) = -rxt(241)*y(20)
         mat(541) = -rxt(242)*y(20)
         mat(227) = -rxt(249)*y(20)
         mat(386) = -rxt(250)*y(20)
         mat(310) = -rxt(251)*y(20)
         mat(102) = -rxt(252)*y(20)
         mat(220) = -rxt(254)*y(20)
         mat(485) = -rxt(255)*y(20)
         mat(161) = -rxt(261)*y(20)
         mat(53) = -rxt(262)*y(20)
         mat(269) = -rxt(265)*y(20)
         mat(351) = -rxt(266)*y(20)
         mat(168) = -rxt(270)*y(20)
         mat(531) = -rxt(271)*y(20)
         mat(563) = -rxt(272)*y(20)
         mat(171) = -rxt(274)*y(20)
         mat(40) = -rxt(275)*y(20)
         mat(599) = -rxt(277)*y(20)
         mat(199) = -rxt(279)*y(20)
         mat(124) = -rxt(282)*y(20)
         mat(554) = -rxt(283)*y(20)
         mat(128) = -rxt(291)*y(20)
         mat(276) = -rxt(300)*y(20)
         mat(427) = -rxt(301)*y(20)
         mat(253) = -rxt(307)*y(20)
         mat(37) = -rxt(313)*y(20)
         mat(455) = -rxt(314)*y(20)
         mat(156) = -rxt(316)*y(20)
         mat(321) = -rxt(319)*y(20)
         mat(138) = -rxt(325)*y(20)
         mat(60) = -rxt(327)*y(20)
         mat(194) = -rxt(330)*y(20)
         mat(64) = -rxt(331)*y(20)
         mat(294) = -rxt(333)*y(20)
         mat(205) = -rxt(338)*y(20)
         mat(56) = -rxt(343)*y(20)
         mat(95) = -(rxt(344) + rxt(345)) * y(20)
         mat(43) = -rxt(347)*y(20)

         mat(953) = mat(953) + rxt(115)*y(19) + rxt(128)*y(21) + .330_r8*rxt(256) &
                      *y(56) + .270_r8*rxt(302)*y(80) + .120_r8*rxt(235)*y(41) &
                      + .080_r8*rxt(278)*y(74) + .215_r8*rxt(284)*y(75) &
                      + .700_r8*rxt(334)*y(96)
         mat(1178) = mat(1178) + rxt(126)*y(18) + rxt(215)*y(16) + rxt(127)*y(21) &
                      + rxt(130)*y(22) + rxt(175)*y(30) + rxt(176)*y(31) + rxt(195) &
                      *y(36) + rxt(196)*y(37)
         mat(1086) = rxt(110)*y(18) + rxt(113)*y(39) + 2.000_r8*rxt(87)*y(160) &
                      + rxt(111)*y(30) + rxt(112)*y(36)
         mat(507) = mat(507) + rxt(126)*y(2) + rxt(110)*y(3)
         mat(849) = rxt(139)*y(21)
         mat(1066) = mat(1066) + .300_r8*rxt(222)*y(14) + .500_r8*rxt(265)*y(62) &
                      + .100_r8*rxt(291)*y(77) + .500_r8*rxt(241)*y(44) &
                      + .650_r8*rxt(228)*y(118)
         mat(914) = mat(914) + rxt(151)*y(21)
         mat(188) = mat(188) + .300_r8*rxt(222)*y(20)
         mat(88) = mat(88) + rxt(113)*y(3)
         mat(771) = mat(771) + rxt(215)*y(2)
         mat(702) = rxt(115)*y(1) + 2.000_r8*rxt(116)*y(21)
         mat(1153) = mat(1153) + rxt(128)*y(1) + rxt(127)*y(2) + rxt(139)*y(6) &
                      + rxt(151)*y(8) + 2.000_r8*rxt(116)*y(19) + rxt(159)*y(25)
         mat(305) = mat(305) + rxt(130)*y(2)
         mat(693) = 2.000_r8*rxt(87)*y(3)
         mat(798) = rxt(159)*y(21)
         mat(975) = mat(975) + rxt(175)*y(2) + rxt(111)*y(3)
         mat(435) = mat(435) + rxt(176)*y(2)
         mat(392) = mat(392) + rxt(195)*y(2) + rxt(112)*y(3)
         mat(379) = rxt(196)*y(2)
         mat(485) = mat(485) + .330_r8*rxt(256)*y(1)
         mat(427) = mat(427) + .270_r8*rxt(302)*y(1)
         mat(269) = mat(269) + .500_r8*rxt(265)*y(20)
         mat(152) = mat(152) + .120_r8*rxt(235)*y(1)
         mat(599) = mat(599) + .080_r8*rxt(278)*y(1)
         mat(554) = mat(554) + .215_r8*rxt(284)*y(1)
         mat(128) = mat(128) + .100_r8*rxt(291)*y(20)
         mat(133) = mat(133) + .500_r8*rxt(241)*y(20)
         mat(294) = mat(294) + .700_r8*rxt(334)*y(1)
         mat(75) = mat(75) + .650_r8*rxt(228)*y(20)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(911) = -(rxt(144)*y(7) + rxt(148)*y(6) + rxt(149)*y(2) + rxt(150)*y(20) &
                      + rxt(151)*y(21) + rxt(213)*y(16) + rxt(243)*y(47) + rxt(257) &
                      *y(56) + rxt(273)*y(65) + rxt(287)*y(76) + rxt(293)*y(73) &
                      + rxt(303)*y(80) + rxt(305)*y(85) + rxt(311)*y(86) + rxt(315) &
                      *y(87) + rxt(321)*y(88) + rxt(335)*y(96) + rxt(346)*y(122))
         mat(1230) = -rxt(144)*y(8)
         mat(846) = -rxt(148)*y(8)
         mat(1175) = -rxt(149)*y(8)
         mat(1063) = -rxt(150)*y(8)
         mat(1150) = -rxt(151)*y(8)
         mat(768) = -rxt(213)*y(8)
         mat(540) = -rxt(243)*y(8)
         mat(483) = -rxt(257)*y(8)
         mat(562) = -rxt(273)*y(8)
         mat(618) = -rxt(287)*y(8)
         mat(657) = -rxt(293)*y(8)
         mat(425) = -rxt(303)*y(8)
         mat(640) = -rxt(305)*y(8)
         mat(498) = -rxt(311)*y(8)
         mat(454) = -rxt(315)*y(8)
         mat(580) = -rxt(321)*y(8)
         mat(292) = -rxt(335)*y(8)
         mat(94) = -rxt(346)*y(8)

         mat(950) = rxt(143)*y(7)
         mat(1175) = mat(1175) + rxt(142)*y(7) + rxt(179)*y(32) + rxt(197)*y(38)
         mat(1230) = mat(1230) + rxt(143)*y(1) + rxt(142)*y(2)
         mat(1063) = mat(1063) + rxt(147)*y(9) + rxt(180)*y(32) + rxt(254)*y(55) &
                      + .500_r8*rxt(300)*y(78)
         mat(410) = rxt(147)*y(20)
         mat(795) = rxt(181)*y(32)
         mat(444) = rxt(179)*y(2) + rxt(180)*y(20) + rxt(181)*y(25)
         mat(259) = rxt(197)*y(2)
         mat(219) = rxt(254)*y(20)
         mat(275) = .500_r8*rxt(300)*y(20)

         mat(408) = -(rxt(147)*y(20))
         mat(1034) = -rxt(147)*y(9)

         mat(1215) = rxt(146)*y(20)
         mat(1034) = mat(1034) + rxt(146)*y(7)
         mat(886) = rxt(213)*y(16) + rxt(243)*y(47) + rxt(273)*y(65) + rxt(346)*y(122)
         mat(759) = rxt(213)*y(8)
         mat(962) = (rxt(352)+rxt(357)+rxt(363))*y(32)
         mat(438) = (rxt(352)+rxt(357)+rxt(363))*y(30)
         mat(533) = rxt(243)*y(8)
         mat(556) = rxt(273)*y(8)
         mat(93) = rxt(346)*y(8)

         mat(177) = -(rxt(153)*y(20))
         mat(1007) = -rxt(153)*y(10)

         mat(1208) = rxt(152)*y(21)
         mat(1101) = rxt(152)*y(7)


         mat(1207) = rxt(144)*y(8)
         mat(880) = rxt(144)*y(7)

         mat(730) = -(rxt(166)*y(27) + rxt(217)*y(6) + rxt(218)*y(21) + (4._r8*rxt(219) &
                      + 4._r8*rxt(220)) * y(13) + rxt(239)*y(43) + rxt(247)*y(45) &
                      + rxt(260)*y(58) + rxt(269)*y(64) + rxt(289)*y(76) + rxt(295) &
                      *y(73) + rxt(308)*y(85) + rxt(323)*y(88))
         mat(863) = -rxt(166)*y(13)
         mat(840) = -rxt(217)*y(13)
         mat(1144) = -rxt(218)*y(13)
         mat(367) = -rxt(239)*y(13)
         mat(680) = -rxt(247)*y(13)
         mat(402) = -rxt(260)*y(13)
         mat(521) = -rxt(269)*y(13)
         mat(615) = -rxt(289)*y(13)
         mat(654) = -rxt(295)*y(13)
         mat(637) = -rxt(308)*y(13)
         mat(577) = -rxt(323)*y(13)

         mat(944) = .310_r8*rxt(256)*y(56)
         mat(840) = mat(840) + rxt(244)*y(45)
         mat(1057) = .700_r8*rxt(222)*y(14) + rxt(236)*y(46)
         mat(730) = mat(730) + .900_r8*rxt(247)*y(45)
         mat(186) = .700_r8*rxt(222)*y(20)
         mat(480) = .310_r8*rxt(256)*y(1)
         mat(299) = rxt(236)*y(20)
         mat(680) = mat(680) + rxt(244)*y(6) + .900_r8*rxt(247)*y(13) &
                      + 4.000_r8*rxt(248)*y(45) + rxt(309)*y(85) + rxt(290)*y(76) &
                      + rxt(296)*y(73) + rxt(324)*y(88)
         mat(637) = mat(637) + rxt(309)*y(45)
         mat(615) = mat(615) + rxt(290)*y(45)
         mat(654) = mat(654) + rxt(296)*y(45)
         mat(577) = mat(577) + rxt(324)*y(45)

         mat(183) = -(rxt(222)*y(20))
         mat(1008) = -rxt(222)*y(14)

         mat(708) = rxt(218)*y(21)
         mat(1102) = rxt(218)*y(13)

         mat(87) = -(rxt(113)*y(3) + rxt(131)*y(20))
         mat(1072) = -rxt(113)*y(39)
         mat(992) = -rxt(131)*y(39)

         mat(44) = -(rxt(132)*y(20))
         mat(985) = -rxt(132)*y(40)

         mat(765) = -(rxt(160)*y(25) + rxt(184)*y(34) + rxt(213)*y(8) + rxt(214)*y(20) &
                      + rxt(215)*y(2) + rxt(216)*y(21))
         mat(791) = -rxt(160)*y(16)
         mat(748) = -rxt(184)*y(16)
         mat(907) = -rxt(213)*y(16)
         mat(1059) = -rxt(214)*y(16)
         mat(1171) = -rxt(215)*y(16)
         mat(1146) = -rxt(216)*y(16)

         mat(946) = .540_r8*rxt(256)*y(56) + .600_r8*rxt(302)*y(80) + rxt(235)*y(41) &
                      + .800_r8*rxt(278)*y(74) + .700_r8*rxt(284)*y(75)
         mat(842) = rxt(217)*y(13) + rxt(263)*y(61) + .500_r8*rxt(276)*y(70) &
                      + .100_r8*rxt(317)*y(81) + .510_r8*rxt(304)*y(85) &
                      + .250_r8*rxt(285)*y(76) + rxt(292)*y(73) + .500_r8*rxt(231) &
                      *y(52) + rxt(267)*y(64) + .072_r8*rxt(310)*y(86)
         mat(1059) = mat(1059) + .300_r8*rxt(222)*y(14) + .500_r8*rxt(249)*y(51) &
                      + rxt(254)*y(55) + .500_r8*rxt(300)*y(78) + rxt(221)*y(15) &
                      + .800_r8*rxt(250)*y(49)
         mat(907) = mat(907) + .600_r8*rxt(305)*y(85) + .250_r8*rxt(287)*y(76) &
                      + rxt(293)*y(73) + .072_r8*rxt(311)*y(86)
         mat(731) = rxt(217)*y(6) + (4.000_r8*rxt(219)+2.000_r8*rxt(220))*y(13) &
                      + rxt(166)*y(27) + rxt(247)*y(45) + 1.200_r8*rxt(308)*y(85) &
                      + .880_r8*rxt(289)*y(76) + 2.000_r8*rxt(295)*y(73) &
                      + .700_r8*rxt(239)*y(43) + rxt(260)*y(58) + .800_r8*rxt(269) &
                      *y(64) + .700_r8*rxt(323)*y(88)
         mat(187) = .300_r8*rxt(222)*y(20)
         mat(1146) = mat(1146) + .008_r8*rxt(312)*y(86)
         mat(865) = rxt(166)*y(13)
         mat(481) = .540_r8*rxt(256)*y(1)
         mat(424) = .600_r8*rxt(302)*y(1)
         mat(357) = rxt(263)*y(6)
         mat(681) = rxt(247)*y(13) + .600_r8*rxt(309)*y(85) + .250_r8*rxt(290)*y(76) &
                      + rxt(296)*y(73)
         mat(226) = .500_r8*rxt(249)*y(20)
         mat(218) = rxt(254)*y(20)
         mat(150) = rxt(235)*y(1)
         mat(274) = .500_r8*rxt(300)*y(20)
         mat(142) = .500_r8*rxt(276)*y(6)
         mat(341) = .100_r8*rxt(317)*y(6)
         mat(638) = .510_r8*rxt(304)*y(6) + .600_r8*rxt(305)*y(8) + 1.200_r8*rxt(308) &
                      *y(13) + .600_r8*rxt(309)*y(45)
         mat(595) = .800_r8*rxt(278)*y(1)
         mat(552) = .700_r8*rxt(284)*y(1)
         mat(616) = .250_r8*rxt(285)*y(6) + .250_r8*rxt(287)*y(8) + .880_r8*rxt(289) &
                      *y(13) + .250_r8*rxt(290)*y(45)
         mat(655) = rxt(292)*y(6) + rxt(293)*y(8) + 2.000_r8*rxt(295)*y(13) + rxt(296) &
                      *y(45) + 4.000_r8*rxt(297)*y(73)
         mat(368) = .700_r8*rxt(239)*y(13)
         mat(403) = rxt(260)*y(13)
         mat(229) = rxt(221)*y(20)
         mat(385) = .800_r8*rxt(250)*y(20)
         mat(283) = .500_r8*rxt(231)*y(6)
         mat(522) = rxt(267)*y(6) + .800_r8*rxt(269)*y(13)
         mat(496) = .072_r8*rxt(310)*y(6) + .072_r8*rxt(311)*y(8) + .008_r8*rxt(312) &
                      *y(21)
         mat(578) = .700_r8*rxt(323)*y(13)

         mat(698) = -(rxt(115)*y(1) + (rxt(116) + rxt(117) + rxt(118)) * y(21))
         mat(943) = -rxt(115)*y(19)
         mat(1143) = -(rxt(116) + rxt(117) + rxt(118)) * y(19)

         mat(1169) = rxt(126)*y(18) + rxt(119)*y(20)
         mat(1076) = rxt(110)*y(18)
         mat(504) = rxt(126)*y(2) + rxt(110)*y(3) + rxt(124)*y(20) + rxt(156)*y(25)
         mat(511) = rxt(211)*y(20)
         mat(1056) = rxt(119)*y(2) + rxt(124)*y(18) + rxt(211)*y(17) + rxt(214)*y(16)
         mat(763) = rxt(214)*y(20)
         mat(788) = rxt(156)*y(18)

         mat(1155) = -((rxt(116) + rxt(117) + rxt(118)) * y(19) + rxt(121)*y(20) &
                      + rxt(127)*y(2) + rxt(128)*y(1) + 4._r8*rxt(129)*y(21) + rxt(139) &
                      *y(6) + rxt(151)*y(8) + rxt(152)*y(7) + (rxt(158) + rxt(159) &
                      ) * y(25) + rxt(165)*y(27) + rxt(183)*y(34) + rxt(187)*y(35) &
                      + rxt(216)*y(16) + rxt(218)*y(13) + rxt(226)*y(120) + rxt(232) &
                      *y(52) + rxt(238)*y(43) + rxt(246)*y(45) + rxt(259)*y(58) &
                      + rxt(264)*y(61) + rxt(268)*y(64) + rxt(281)*y(71) + rxt(288) &
                      *y(76) + rxt(294)*y(73) + rxt(306)*y(85) + rxt(312)*y(86) &
                      + rxt(318)*y(81) + rxt(322)*y(88) + rxt(329)*y(93) + rxt(337) &
                      *y(97))
         mat(704) = -(rxt(116) + rxt(117) + rxt(118)) * y(21)
         mat(1068) = -rxt(121)*y(21)
         mat(1180) = -rxt(127)*y(21)
         mat(955) = -rxt(128)*y(21)
         mat(851) = -rxt(139)*y(21)
         mat(916) = -rxt(151)*y(21)
         mat(1235) = -rxt(152)*y(21)
         mat(800) = -(rxt(158) + rxt(159)) * y(21)
         mat(874) = -rxt(165)*y(21)
         mat(754) = -rxt(183)*y(21)
         mat(1201) = -rxt(187)*y(21)
         mat(773) = -rxt(216)*y(21)
         mat(740) = -rxt(218)*y(21)
         mat(213) = -rxt(226)*y(21)
         mat(286) = -rxt(232)*y(21)
         mat(371) = -rxt(238)*y(21)
         mat(686) = -rxt(246)*y(21)
         mat(406) = -rxt(259)*y(21)
         mat(360) = -rxt(264)*y(21)
         mat(525) = -rxt(268)*y(21)
         mat(329) = -rxt(281)*y(21)
         mat(620) = -rxt(288)*y(21)
         mat(660) = -rxt(294)*y(21)
         mat(643) = -rxt(306)*y(21)
         mat(500) = -rxt(312)*y(21)
         mat(344) = -rxt(318)*y(21)
         mat(582) = -rxt(322)*y(21)
         mat(239) = -rxt(329)*y(21)
         mat(469) = -rxt(337)*y(21)

         mat(955) = mat(955) + rxt(120)*y(20) + .190_r8*rxt(256)*y(56) &
                      + .060_r8*rxt(302)*y(80) + .120_r8*rxt(235)*y(41) &
                      + .060_r8*rxt(278)*y(74) + .275_r8*rxt(284)*y(75) + rxt(334) &
                      *y(96)
         mat(1180) = mat(1180) + rxt(215)*y(16) + rxt(130)*y(22)
         mat(513) = rxt(212)*y(20)
         mat(851) = mat(851) + rxt(217)*y(13) + rxt(263)*y(61) + rxt(276)*y(70) &
                      + .900_r8*rxt(317)*y(81) + .900_r8*rxt(328)*y(93) + rxt(336) &
                      *y(97) + rxt(304)*y(85) + .470_r8*rxt(285)*y(76) + rxt(237) &
                      *y(43) + rxt(258)*y(58) + .250_r8*rxt(231)*y(52) &
                      + .794_r8*rxt(310)*y(86) + rxt(320)*y(88) + rxt(225)*y(120)
         mat(1235) = mat(1235) + .700_r8*rxt(332)*y(95)
         mat(1068) = mat(1068) + rxt(120)*y(1) + rxt(212)*y(17) + rxt(150)*y(8) &
                      + rxt(131)*y(39) + rxt(132)*y(40) + rxt(125)*y(22) + rxt(163) &
                      *y(27) + rxt(186)*y(35) + .500_r8*rxt(300)*y(78) &
                      + .250_r8*rxt(327)*y(91) + rxt(251)*y(50) + .200_r8*rxt(291) &
                      *y(77) + rxt(221)*y(15) + rxt(252)*y(48) + rxt(250)*y(49) &
                      + rxt(271)*y(63) + rxt(314)*y(87) + .350_r8*rxt(228)*y(118) &
                      + rxt(223)*y(119) + .500_r8*rxt(345)*y(122)
         mat(916) = mat(916) + rxt(150)*y(20) + rxt(213)*y(16) + rxt(305)*y(85) &
                      + .470_r8*rxt(287)*y(76) + .794_r8*rxt(311)*y(86) + rxt(315) &
                      *y(87) + rxt(321)*y(88)
         mat(740) = mat(740) + rxt(217)*y(6) + 4.000_r8*rxt(219)*y(13) + rxt(166) &
                      *y(27) + .900_r8*rxt(247)*y(45) + rxt(308)*y(85) &
                      + .730_r8*rxt(289)*y(76) + rxt(295)*y(73) + rxt(239)*y(43) &
                      + rxt(260)*y(58) + .300_r8*rxt(269)*y(64) + .800_r8*rxt(323) &
                      *y(88)
         mat(90) = rxt(131)*y(20)
         mat(46) = rxt(132)*y(20)
         mat(773) = mat(773) + rxt(215)*y(2) + rxt(213)*y(8) + rxt(160)*y(25) &
                      + rxt(184)*y(34)
         mat(1155) = mat(1155) + .794_r8*rxt(312)*y(86)
         mat(306) = rxt(130)*y(2) + rxt(125)*y(20) + rxt(157)*y(25)
         mat(800) = mat(800) + rxt(160)*y(16) + rxt(157)*y(22)
         mat(874) = mat(874) + rxt(163)*y(20) + rxt(166)*y(13)
         mat(754) = mat(754) + rxt(184)*y(16)
         mat(1201) = mat(1201) + rxt(186)*y(20)
         mat(486) = .190_r8*rxt(256)*y(1)
         mat(428) = .060_r8*rxt(302)*y(1)
         mat(360) = mat(360) + rxt(263)*y(6)
         mat(686) = mat(686) + .900_r8*rxt(247)*y(13) + rxt(309)*y(85) &
                      + .470_r8*rxt(290)*y(76) + rxt(324)*y(88)
         mat(153) = .120_r8*rxt(235)*y(1)
         mat(277) = .500_r8*rxt(300)*y(20)
         mat(144) = rxt(276)*y(6)
         mat(344) = mat(344) + .900_r8*rxt(317)*y(6)
         mat(61) = .250_r8*rxt(327)*y(20)
         mat(239) = mat(239) + .900_r8*rxt(328)*y(6)
         mat(81) = .700_r8*rxt(332)*y(7)
         mat(469) = mat(469) + rxt(336)*y(6)
         mat(311) = rxt(251)*y(20)
         mat(643) = mat(643) + rxt(304)*y(6) + rxt(305)*y(8) + rxt(308)*y(13) &
                      + rxt(309)*y(45)
         mat(600) = .060_r8*rxt(278)*y(1)
         mat(555) = .275_r8*rxt(284)*y(1)
         mat(620) = mat(620) + .470_r8*rxt(285)*y(6) + .470_r8*rxt(287)*y(8) &
                      + .730_r8*rxt(289)*y(13) + .470_r8*rxt(290)*y(45)
         mat(129) = .200_r8*rxt(291)*y(20)
         mat(660) = mat(660) + rxt(295)*y(13)
         mat(371) = mat(371) + rxt(237)*y(6) + rxt(239)*y(13) + 2.400_r8*rxt(240) &
                      *y(43)
         mat(295) = rxt(334)*y(1)
         mat(406) = mat(406) + rxt(258)*y(6) + rxt(260)*y(13)
         mat(231) = rxt(221)*y(20)
         mat(103) = rxt(252)*y(20)
         mat(387) = rxt(250)*y(20)
         mat(532) = rxt(271)*y(20)
         mat(286) = mat(286) + .250_r8*rxt(231)*y(6)
         mat(525) = mat(525) + .300_r8*rxt(269)*y(13)
         mat(500) = mat(500) + .794_r8*rxt(310)*y(6) + .794_r8*rxt(311)*y(8) &
                      + .794_r8*rxt(312)*y(21)
         mat(456) = rxt(314)*y(20) + rxt(315)*y(8)
         mat(582) = mat(582) + rxt(320)*y(6) + rxt(321)*y(8) + .800_r8*rxt(323)*y(13) &
                      + rxt(324)*y(45)
         mat(76) = .350_r8*rxt(228)*y(20)
         mat(176) = rxt(223)*y(20)
         mat(213) = mat(213) + rxt(225)*y(6)
         mat(96) = .500_r8*rxt(345)*y(20)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(301) = -(rxt(125)*y(20) + rxt(130)*y(2) + rxt(157)*y(25))
         mat(1023) = -rxt(125)*y(22)
         mat(1160) = -rxt(130)*y(22)
         mat(779) = -rxt(157)*y(22)

         mat(1023) = mat(1023) + 2.000_r8*rxt(123)*y(20)
         mat(1113) = 2.000_r8*rxt(129)*y(21)

         mat(689) = -(rxt(87)*y(3))
         mat(1075) = -rxt(87)*y(160)

         mat(503) = rxt(124)*y(20)
         mat(1055) = rxt(124)*y(18) + 2.000_r8*rxt(122)*y(20) + rxt(147)*y(9) &
                      + rxt(153)*y(10) + rxt(222)*y(14) + rxt(214)*y(16) + rxt(121) &
                      *y(21) + rxt(125)*y(22) + rxt(174)*y(30) + rxt(178)*y(31) &
                      + rxt(194)*y(36) + rxt(242)*y(47) + rxt(236)*y(46) + rxt(265) &
                      *y(62) + rxt(249)*y(51) + rxt(229)*y(42) + .500_r8*rxt(283) &
                      *y(75) + rxt(262)*y(57) + rxt(261)*y(59) + rxt(266)*y(60) &
                      + rxt(270)*y(66) + rxt(272)*y(65) + (rxt(325)+rxt(326))*y(89) &
                      + rxt(223)*y(119) + rxt(347)*y(123)
         mat(409) = rxt(147)*y(20)
         mat(178) = rxt(153)*y(20)
         mat(184) = rxt(222)*y(20)
         mat(762) = rxt(214)*y(20)
         mat(697) = rxt(118)*y(21)
         mat(1142) = rxt(121)*y(20) + rxt(118)*y(19)
         mat(302) = rxt(125)*y(20)
         mat(965) = rxt(174)*y(20) + (rxt(353)+rxt(358)+rxt(364))*y(31) + (rxt(354) &
                       +rxt(365))*y(37)
         mat(431) = rxt(178)*y(20) + (rxt(353)+rxt(358)+rxt(364))*y(30)
         mat(389) = rxt(194)*y(20)
         mat(375) = (rxt(354)+rxt(365))*y(30)
         mat(537) = rxt(242)*y(20)
         mat(298) = rxt(236)*y(20)
         mat(267) = rxt(265)*y(20)
         mat(224) = rxt(249)*y(20)
         mat(116) = rxt(229)*y(20)
         mat(550) = .500_r8*rxt(283)*y(20)
         mat(52) = rxt(262)*y(20)
         mat(160) = rxt(261)*y(20)
         mat(349) = rxt(266)*y(20)
         mat(166) = rxt(270)*y(20)
         mat(560) = rxt(272)*y(20)
         mat(137) = (rxt(325)+rxt(326))*y(20)
         mat(174) = rxt(223)*y(20)
         mat(42) = rxt(347)*y(20)

         mat(792) = -(rxt(155)*y(1) + rxt(156)*y(18) + rxt(157)*y(22) + (rxt(158) &
                      + rxt(159)) * y(21) + rxt(160)*y(16) + rxt(177)*y(31) + rxt(181) &
                      *y(32) + rxt(227)*y(42))
         mat(947) = -rxt(155)*y(25)
         mat(505) = -rxt(156)*y(25)
         mat(303) = -rxt(157)*y(25)
         mat(1147) = -(rxt(158) + rxt(159)) * y(25)
         mat(766) = -rxt(160)*y(25)
         mat(432) = -rxt(177)*y(25)
         mat(442) = -rxt(181)*y(25)
         mat(117) = -rxt(227)*y(25)

         mat(1172) = rxt(162)*y(27) + rxt(175)*y(30)
         mat(1080) = rxt(111)*y(30)
         mat(843) = rxt(167)*y(27)
         mat(1060) = rxt(163)*y(27) + rxt(174)*y(30)
         mat(732) = rxt(166)*y(27)
         mat(866) = rxt(162)*y(2) + rxt(167)*y(6) + rxt(163)*y(20) + rxt(166)*y(13) + ( &
                      + 4.000_r8*rxt(169)+2.000_r8*rxt(171))*y(27) + rxt(191)*y(35)
         mat(969) = rxt(175)*y(2) + rxt(111)*y(3) + rxt(174)*y(20)
         mat(1193) = rxt(191)*y(27)


         mat(777) = rxt(181)*y(32)
         mat(857) = 2.000_r8*rxt(170)*y(27)
         mat(959) = (rxt(353)+rxt(358)+rxt(364))*y(31) + (rxt(352)+rxt(357)+rxt(363)) &
                      *y(32)
         mat(429) = (rxt(353)+rxt(358)+rxt(364))*y(30)
         mat(437) = rxt(181)*y(25) + (rxt(352)+rxt(357)+rxt(363))*y(30)

         mat(868) = -(rxt(162)*y(2) + (rxt(163) + rxt(164)) * y(20) + rxt(165)*y(21) &
                      + rxt(166)*y(13) + rxt(167)*y(6) + rxt(168)*y(7) + (4._r8*rxt(169) &
                      + 4._r8*rxt(170) + 4._r8*rxt(171) + 4._r8*rxt(172)) * y(27) &
                      + (rxt(190) + rxt(191) + rxt(192)) * y(35))
         mat(1174) = -rxt(162)*y(27)
         mat(1062) = -(rxt(163) + rxt(164)) * y(27)
         mat(1149) = -rxt(165)*y(27)
         mat(734) = -rxt(166)*y(27)
         mat(845) = -rxt(167)*y(27)
         mat(1229) = -rxt(168)*y(27)
         mat(1195) = -(rxt(190) + rxt(191) + rxt(192)) * y(27)

         mat(949) = rxt(155)*y(25)
         mat(1174) = mat(1174) + rxt(176)*y(31) + rxt(179)*y(32)
         mat(1062) = mat(1062) + rxt(178)*y(31)
         mat(1149) = mat(1149) + rxt(159)*y(25)
         mat(794) = rxt(155)*y(1) + rxt(159)*y(21) + rxt(177)*y(31)
         mat(433) = rxt(176)*y(2) + rxt(178)*y(20) + rxt(177)*y(25)
         mat(443) = rxt(179)*y(2)


         mat(856) = 2.000_r8*rxt(171)*y(27) + rxt(190)*y(35)
         mat(1184) = rxt(190)*y(27)


         mat(855) = 2.000_r8*rxt(172)*y(27)

         mat(974) = -(rxt(111)*y(3) + rxt(174)*y(20) + rxt(175)*y(2) + (rxt(352) &
                      + rxt(357) + rxt(363)) * y(32) + (rxt(353) + rxt(358) + rxt(364) &
                      ) * y(31) + (rxt(354) + rxt(365)) * y(37))
         mat(1085) = -rxt(111)*y(30)
         mat(1065) = -rxt(174)*y(30)
         mat(1177) = -rxt(175)*y(30)
         mat(445) = -(rxt(352) + rxt(357) + rxt(363)) * y(30)
         mat(434) = -(rxt(353) + rxt(358) + rxt(364)) * y(30)
         mat(378) = -(rxt(354) + rxt(365)) * y(30)

         mat(506) = rxt(156)*y(25)
         mat(1065) = mat(1065) + rxt(164)*y(27)
         mat(770) = rxt(160)*y(25)
         mat(1152) = rxt(158)*y(25)
         mat(304) = rxt(157)*y(25)
         mat(797) = rxt(156)*y(18) + rxt(160)*y(16) + rxt(158)*y(21) + rxt(157)*y(22) &
                      + rxt(177)*y(31) + rxt(227)*y(42)
         mat(871) = rxt(164)*y(20)
         mat(434) = mat(434) + rxt(177)*y(25)
         mat(118) = rxt(227)*y(25)

         mat(430) = -(rxt(176)*y(2) + rxt(177)*y(25) + rxt(178)*y(20) + (rxt(353) &
                      + rxt(358) + rxt(364)) * y(30))
         mat(1164) = -rxt(176)*y(31)
         mat(781) = -rxt(177)*y(31)
         mat(1036) = -rxt(178)*y(31)
         mat(963) = -(rxt(353) + rxt(358) + rxt(364)) * y(31)

         mat(1036) = mat(1036) + rxt(180)*y(32)
         mat(1125) = rxt(165)*y(27)
         mat(859) = rxt(165)*y(21)
         mat(439) = rxt(180)*y(20)

         mat(440) = -(rxt(179)*y(2) + rxt(180)*y(20) + rxt(181)*y(25) + (rxt(352) &
                      + rxt(357) + rxt(363)) * y(30))
         mat(1165) = -rxt(179)*y(32)
         mat(1037) = -rxt(180)*y(32)
         mat(782) = -rxt(181)*y(32)
         mat(964) = -(rxt(352) + rxt(357) + rxt(363)) * y(32)

         mat(1216) = rxt(168)*y(27)
         mat(860) = rxt(168)*y(7)


         mat(858) = rxt(192)*y(35)
         mat(960) = (rxt(354)+rxt(365))*y(37)
         mat(1185) = rxt(192)*y(27)
         mat(373) = (rxt(354)+rxt(365))*y(30)

         mat(747) = -(rxt(182)*y(1) + rxt(183)*y(21) + rxt(184)*y(16))
         mat(945) = -rxt(182)*y(34)
         mat(1145) = -rxt(183)*y(34)
         mat(764) = -rxt(184)*y(34)

         mat(1170) = rxt(185)*y(35) + rxt(195)*y(36)
         mat(1078) = rxt(112)*y(36)
         mat(841) = rxt(188)*y(35)
         mat(1058) = rxt(186)*y(35) + rxt(194)*y(36)
         mat(864) = (rxt(190)+rxt(191))*y(35)
         mat(1191) = rxt(185)*y(2) + rxt(188)*y(6) + rxt(186)*y(20) + (rxt(190) &
                       +rxt(191))*y(27) + 4.000_r8*rxt(193)*y(35)
         mat(391) = rxt(195)*y(2) + rxt(112)*y(3) + rxt(194)*y(20)

         mat(1203) = -(rxt(185)*y(2) + rxt(186)*y(20) + rxt(187)*y(21) + rxt(188)*y(6) &
                      + rxt(189)*y(7) + (rxt(190) + rxt(191) + rxt(192)) * y(27) &
                      + 4._r8*rxt(193)*y(35))
         mat(1182) = -rxt(185)*y(35)
         mat(1070) = -rxt(186)*y(35)
         mat(1157) = -rxt(187)*y(35)
         mat(853) = -rxt(188)*y(35)
         mat(1237) = -rxt(189)*y(35)
         mat(876) = -(rxt(190) + rxt(191) + rxt(192)) * y(35)

         mat(957) = rxt(182)*y(34)
         mat(1182) = mat(1182) + rxt(196)*y(37) + rxt(197)*y(38)
         mat(756) = rxt(182)*y(1)
         mat(381) = rxt(196)*y(2)
         mat(261) = rxt(197)*y(2)

         mat(388) = -(rxt(112)*y(3) + rxt(194)*y(20) + rxt(195)*y(2))
         mat(1073) = -rxt(112)*y(36)
         mat(1032) = -rxt(194)*y(36)
         mat(1162) = -rxt(195)*y(36)

         mat(758) = rxt(184)*y(34)
         mat(1123) = rxt(183)*y(34)
         mat(743) = rxt(184)*y(16) + rxt(183)*y(21)

         mat(374) = -(rxt(196)*y(2) + (rxt(354) + rxt(365)) * y(30))
         mat(1161) = -rxt(196)*y(37)
         mat(961) = -(rxt(354) + rxt(365)) * y(37)

         mat(1121) = rxt(187)*y(35)
         mat(1187) = rxt(187)*y(21)

         mat(255) = -(rxt(197)*y(2))
         mat(1159) = -rxt(197)*y(38)

         mat(1211) = rxt(189)*y(35)
         mat(1186) = rxt(189)*y(7)

         mat(474) = -(rxt(255)*y(20) + rxt(256)*y(1) + rxt(257)*y(8))
         mat(1040) = -rxt(255)*y(56)
         mat(928) = -rxt(256)*y(56)
         mat(890) = -rxt(257)*y(56)

         mat(928) = mat(928) + .070_r8*rxt(302)*y(80)
         mat(415) = .070_r8*rxt(302)*y(1)

         mat(414) = -(rxt(301)*y(20) + rxt(302)*y(1) + rxt(303)*y(8))
         mat(1035) = -rxt(301)*y(80)
         mat(926) = -rxt(302)*y(80)
         mat(887) = -rxt(303)*y(80)

         mat(353) = -(rxt(263)*y(6) + rxt(264)*y(21))
         mat(819) = -rxt(263)*y(61)
         mat(1119) = -rxt(264)*y(61)

         mat(1029) = rxt(255)*y(56) + .500_r8*rxt(265)*y(62)
         mat(473) = rxt(255)*y(20)
         mat(264) = .500_r8*rxt(265)*y(20)

         mat(535) = -(rxt(242)*y(20) + rxt(243)*y(8))
         mat(1046) = -rxt(242)*y(47)
         mat(895) = -rxt(243)*y(47)

         mat(933) = .500_r8*rxt(256)*y(56) + .040_r8*rxt(278)*y(74)
         mat(829) = rxt(263)*y(61) + rxt(276)*y(70) + .400_r8*rxt(317)*y(81) &
                      + rxt(280)*y(71) + rxt(237)*y(43) + .270_r8*rxt(258)*y(58)
         mat(1046) = mat(1046) + .500_r8*rxt(241)*y(44) + rxt(252)*y(48)
         mat(719) = .800_r8*rxt(239)*y(43)
         mat(477) = .500_r8*rxt(256)*y(1)
         mat(355) = rxt(263)*y(6)
         mat(141) = rxt(276)*y(6)
         mat(338) = .400_r8*rxt(317)*y(6)
         mat(325) = rxt(280)*y(6)
         mat(587) = .040_r8*rxt(278)*y(1)
         mat(366) = rxt(237)*y(6) + .800_r8*rxt(239)*y(13) + 3.200_r8*rxt(240)*y(43)
         mat(132) = .500_r8*rxt(241)*y(20)
         mat(399) = .270_r8*rxt(258)*y(6)
         mat(101) = rxt(252)*y(20)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(297) = -(rxt(236)*y(20))
         mat(1022) = -rxt(236)*y(46)

         mat(924) = .250_r8*rxt(256)*y(56) + .200_r8*rxt(302)*y(80)
         mat(710) = .100_r8*rxt(247)*y(45)
         mat(1112) = .250_r8*rxt(246)*y(45) + .250_r8*rxt(294)*y(73)
         mat(472) = .250_r8*rxt(256)*y(1)
         mat(413) = .200_r8*rxt(302)*y(1)
         mat(665) = .100_r8*rxt(247)*y(13) + .250_r8*rxt(246)*y(21)
         mat(647) = .250_r8*rxt(294)*y(21)

         mat(263) = -(rxt(265)*y(20))
         mat(1018) = -rxt(265)*y(62)

         mat(1110) = rxt(264)*y(61)
         mat(352) = rxt(264)*y(21)

         mat(677) = -(rxt(244)*y(6) + rxt(245)*y(7) + rxt(246)*y(21) + rxt(247)*y(13) &
                      + 4._r8*rxt(248)*y(45) + rxt(290)*y(76) + rxt(309)*y(85) + rxt(324) &
                      *y(88))
         mat(837) = -rxt(244)*y(45)
         mat(1221) = -rxt(245)*y(45)
         mat(1141) = -rxt(246)*y(45)
         mat(727) = -rxt(247)*y(45)
         mat(612) = -rxt(290)*y(45)
         mat(634) = -rxt(309)*y(45)
         mat(574) = -rxt(324)*y(45)

         mat(837) = mat(837) + rxt(280)*y(71) + .530_r8*rxt(285)*y(76) + rxt(292) &
                      *y(73) + rxt(267)*y(64)
         mat(1054) = rxt(242)*y(47) + .500_r8*rxt(249)*y(51) + rxt(272)*y(65)
         mat(903) = rxt(243)*y(47) + .530_r8*rxt(287)*y(76) + rxt(293)*y(73) &
                      + rxt(273)*y(65)
         mat(727) = mat(727) + .260_r8*rxt(289)*y(76) + rxt(295)*y(73) &
                      + .300_r8*rxt(269)*y(64)
         mat(536) = rxt(242)*y(20) + rxt(243)*y(8)
         mat(677) = mat(677) + .530_r8*rxt(290)*y(76)
         mat(223) = .500_r8*rxt(249)*y(20)
         mat(326) = rxt(280)*y(6)
         mat(612) = mat(612) + .530_r8*rxt(285)*y(6) + .530_r8*rxt(287)*y(8) &
                      + .260_r8*rxt(289)*y(13) + .530_r8*rxt(290)*y(45)
         mat(651) = rxt(292)*y(6) + rxt(293)*y(8) + rxt(295)*y(13) + 4.000_r8*rxt(297) &
                      *y(73)
         mat(519) = rxt(267)*y(6) + .300_r8*rxt(269)*y(13)
         mat(559) = rxt(272)*y(20) + rxt(273)*y(8)

         mat(222) = -(rxt(249)*y(20))
         mat(1013) = -rxt(249)*y(51)

         mat(1106) = .750_r8*rxt(246)*y(45) + .750_r8*rxt(294)*y(73)
         mat(664) = .750_r8*rxt(246)*y(21)
         mat(645) = .750_r8*rxt(294)*y(21)

         mat(215) = -(rxt(254)*y(20))
         mat(1012) = -rxt(254)*y(55)

         mat(1209) = rxt(245)*y(45)
         mat(663) = rxt(245)*y(7)

         mat(169) = -(rxt(274)*y(20))
         mat(1005) = -rxt(274)*y(79)

         mat(808) = .100_r8*rxt(317)*y(81)
         mat(882) = rxt(257)*y(56)
         mat(471) = rxt(257)*y(8)
         mat(331) = .100_r8*rxt(317)*y(6)

         mat(114) = -(rxt(227)*y(25) + rxt(229)*y(20))
         mat(778) = -rxt(227)*y(42)
         mat(995) = -rxt(229)*y(42)

         mat(146) = -(rxt(230)*y(20) + rxt(235)*y(1))
         mat(1001) = -rxt(230)*y(41)
         mat(920) = -rxt(235)*y(41)

         mat(35) = -(rxt(313)*y(20))
         mat(982) = -rxt(313)*y(68)

         mat(271) = -(rxt(300)*y(20))
         mat(1019) = -rxt(300)*y(78)

         mat(1212) = rxt(298)*y(73)
         mat(646) = rxt(298)*y(7)

         mat(38) = -(rxt(275)*y(20))
         mat(983) = -rxt(275)*y(67)

         mat(139) = -(rxt(276)*y(6))
         mat(806) = -rxt(276)*y(70)

         mat(1000) = rxt(275)*y(67)
         mat(39) = rxt(275)*y(20)

         mat(335) = -(rxt(317)*y(6) + rxt(318)*y(21))
         mat(817) = -rxt(317)*y(81)
         mat(1117) = -rxt(318)*y(81)

         mat(1027) = rxt(313)*y(68) + rxt(319)*y(82)
         mat(36) = rxt(313)*y(20)
         mat(315) = rxt(319)*y(20)

         mat(313) = -(rxt(319)*y(20))
         mat(1025) = -rxt(319)*y(82)

         mat(1115) = rxt(318)*y(81)
         mat(333) = rxt(318)*y(21)

         mat(195) = -(rxt(279)*y(20))
         mat(1010) = -rxt(279)*y(69)

         mat(810) = .800_r8*rxt(317)*y(81)
         mat(332) = .800_r8*rxt(317)*y(6)

         mat(324) = -(rxt(280)*y(6) + rxt(281)*y(21))
         mat(816) = -rxt(280)*y(71)
         mat(1116) = -rxt(281)*y(71)

         mat(1026) = rxt(279)*y(69) + rxt(282)*y(72)
         mat(196) = rxt(279)*y(20)
         mat(121) = rxt(282)*y(20)

         mat(120) = -(rxt(282)*y(20))
         mat(996) = -rxt(282)*y(72)

         mat(1094) = rxt(281)*y(71)
         mat(323) = rxt(281)*y(21)

         mat(57) = -(rxt(327)*y(20))
         mat(988) = -rxt(327)*y(91)

         mat(62) = -(rxt(331)*y(20))
         mat(989) = -rxt(331)*y(92)

         mat(989) = mat(989) + .250_r8*rxt(327)*y(91)
         mat(58) = .250_r8*rxt(327)*y(20)

         mat(233) = -(rxt(328)*y(6) + rxt(329)*y(21))
         mat(812) = -rxt(328)*y(93)
         mat(1107) = -rxt(329)*y(93)

         mat(1015) = .700_r8*rxt(327)*y(91) + rxt(330)*y(94)
         mat(59) = .700_r8*rxt(327)*y(20)
         mat(190) = rxt(330)*y(20)

         mat(189) = -(rxt(330)*y(20))
         mat(1009) = -rxt(330)*y(94)

         mat(1103) = rxt(329)*y(93)
         mat(232) = rxt(329)*y(21)

         mat(79) = -(rxt(332)*y(7))
         mat(1205) = -rxt(332)*y(95)

         mat(991) = rxt(331)*y(92)
         mat(63) = rxt(331)*y(20)

         mat(460) = -(rxt(336)*y(6) + rxt(337)*y(21))
         mat(824) = -rxt(336)*y(97)
         mat(1127) = -rxt(337)*y(97)

         mat(1039) = rxt(338)*y(98) + rxt(333)*y(96)
         mat(889) = rxt(335)*y(96)
         mat(202) = rxt(338)*y(20)
         mat(289) = rxt(333)*y(20) + rxt(335)*y(8)

         mat(200) = -(rxt(338)*y(20))
         mat(1011) = -rxt(338)*y(98)

         mat(1104) = rxt(337)*y(97)
         mat(458) = rxt(337)*y(21)


         mat(813) = .900_r8*rxt(328)*y(93)
         mat(1210) = .700_r8*rxt(332)*y(95)
         mat(234) = .900_r8*rxt(328)*y(6)
         mat(80) = .700_r8*rxt(332)*y(7)

         mat(308) = -(rxt(251)*y(20))
         mat(1024) = -rxt(251)*y(50)

         mat(815) = .450_r8*rxt(328)*y(93) + .250_r8*rxt(320)*y(88)
         mat(1024) = mat(1024) + .200_r8*rxt(250)*y(49) + .650_r8*rxt(228)*y(118)
         mat(884) = .250_r8*rxt(321)*y(88)
         mat(711) = .100_r8*rxt(323)*y(88)
         mat(666) = .250_r8*rxt(324)*y(88)
         mat(235) = .450_r8*rxt(328)*y(6)
         mat(382) = .200_r8*rxt(250)*y(20)
         mat(568) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)
         mat(73) = .650_r8*rxt(228)*y(20)

         mat(632) = -(rxt(304)*y(6) + rxt(305)*y(8) + rxt(306)*y(21) + rxt(308)*y(13) &
                      + rxt(309)*y(45))
         mat(835) = -rxt(304)*y(85)
         mat(901) = -rxt(305)*y(85)
         mat(1139) = -rxt(306)*y(85)
         mat(725) = -rxt(308)*y(85)
         mat(675) = -rxt(309)*y(85)

         mat(1052) = rxt(301)*y(80) + .200_r8*rxt(307)*y(90)
         mat(420) = rxt(301)*y(20)
         mat(251) = .200_r8*rxt(307)*y(20)

         mat(589) = -(rxt(277)*y(20) + rxt(278)*y(1))
         mat(1050) = -rxt(277)*y(74)
         mat(937) = -rxt(278)*y(74)

         mat(937) = mat(937) + .200_r8*rxt(302)*y(80) + rxt(334)*y(96)
         mat(833) = rxt(336)*y(97) + .320_r8*rxt(304)*y(85) + .039_r8*rxt(310)*y(86)
         mat(899) = .350_r8*rxt(305)*y(85) + .039_r8*rxt(311)*y(86)
         mat(723) = .260_r8*rxt(308)*y(85)
         mat(1137) = .039_r8*rxt(312)*y(86)
         mat(419) = .200_r8*rxt(302)*y(1)
         mat(673) = .350_r8*rxt(309)*y(85)
         mat(463) = rxt(336)*y(6)
         mat(630) = .320_r8*rxt(304)*y(6) + .350_r8*rxt(305)*y(8) + .260_r8*rxt(308) &
                      *y(13) + .350_r8*rxt(309)*y(45)
         mat(291) = rxt(334)*y(1)
         mat(494) = .039_r8*rxt(310)*y(6) + .039_r8*rxt(311)*y(8) + .039_r8*rxt(312) &
                      *y(21)

         mat(545) = -(rxt(283)*y(20) + rxt(284)*y(1))
         mat(1047) = -rxt(283)*y(75)
         mat(934) = -rxt(284)*y(75)

         mat(934) = mat(934) + .400_r8*rxt(302)*y(80) + rxt(334)*y(96)
         mat(830) = rxt(336)*y(97) + .230_r8*rxt(304)*y(85) + .167_r8*rxt(310)*y(86)
         mat(896) = .250_r8*rxt(305)*y(85) + .167_r8*rxt(311)*y(86)
         mat(720) = .190_r8*rxt(308)*y(85)
         mat(1134) = .167_r8*rxt(312)*y(86)
         mat(418) = .400_r8*rxt(302)*y(1)
         mat(670) = .250_r8*rxt(309)*y(85)
         mat(462) = rxt(336)*y(6)
         mat(627) = .230_r8*rxt(304)*y(6) + .250_r8*rxt(305)*y(8) + .190_r8*rxt(308) &
                      *y(13) + .250_r8*rxt(309)*y(45)
         mat(290) = rxt(334)*y(1)
         mat(492) = .167_r8*rxt(310)*y(6) + .167_r8*rxt(311)*y(8) + .167_r8*rxt(312) &
                      *y(21)

         mat(610) = -((rxt(285) + rxt(286)) * y(6) + rxt(287)*y(8) + rxt(288)*y(21) &
                      + rxt(289)*y(13) + rxt(290)*y(45))
         mat(834) = -(rxt(285) + rxt(286)) * y(76)
         mat(900) = -rxt(287)*y(76)
         mat(1138) = -rxt(288)*y(76)
         mat(724) = -rxt(289)*y(76)
         mat(674) = -rxt(290)*y(76)

         mat(1051) = rxt(277)*y(74) + .500_r8*rxt(283)*y(75) + .200_r8*rxt(291)*y(77)
         mat(590) = rxt(277)*y(20)
         mat(547) = .500_r8*rxt(283)*y(20)
         mat(126) = .200_r8*rxt(291)*y(20)

         mat(125) = -(rxt(291)*y(20))
         mat(997) = -rxt(291)*y(77)

         mat(1095) = rxt(288)*y(76)
         mat(602) = rxt(288)*y(21)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(650) = -(rxt(292)*y(6) + rxt(293)*y(8) + rxt(294)*y(21) + rxt(295)*y(13) &
                      + rxt(296)*y(45) + 4._r8*rxt(297)*y(73) + rxt(298)*y(7))
         mat(836) = -rxt(292)*y(73)
         mat(902) = -rxt(293)*y(73)
         mat(1140) = -rxt(294)*y(73)
         mat(726) = -rxt(295)*y(73)
         mat(676) = -rxt(296)*y(73)
         mat(1220) = -rxt(298)*y(73)

         mat(940) = .200_r8*rxt(302)*y(80)
         mat(1053) = .500_r8*rxt(283)*y(75) + .500_r8*rxt(291)*y(77)
         mat(421) = .200_r8*rxt(302)*y(1)
         mat(548) = .500_r8*rxt(283)*y(20)
         mat(127) = .500_r8*rxt(291)*y(20)

         mat(365) = -(rxt(237)*y(6) + rxt(238)*y(21) + rxt(239)*y(13) + 4._r8*rxt(240) &
                      *y(43))
         mat(820) = -rxt(237)*y(43)
         mat(1120) = -rxt(238)*y(43)
         mat(713) = -rxt(239)*y(43)

         mat(1030) = rxt(229)*y(42) + .500_r8*rxt(241)*y(44)
         mat(780) = rxt(227)*y(42)
         mat(115) = rxt(229)*y(20) + rxt(227)*y(25)
         mat(131) = .500_r8*rxt(241)*y(20)

         mat(130) = -(rxt(241)*y(20))
         mat(998) = -rxt(241)*y(44)

         mat(1096) = rxt(238)*y(43)
         mat(363) = rxt(238)*y(21)

         mat(288) = -(rxt(333)*y(20) + rxt(334)*y(1) + rxt(335)*y(8))
         mat(1021) = -rxt(333)*y(96)
         mat(923) = -rxt(334)*y(96)
         mat(883) = -rxt(335)*y(96)

         mat(50) = -(rxt(262)*y(20))
         mat(986) = -rxt(262)*y(57)

         mat(397) = -(rxt(258)*y(6) + rxt(259)*y(21) + rxt(260)*y(13))
         mat(822) = -rxt(258)*y(58)
         mat(1124) = -rxt(259)*y(58)
         mat(715) = -rxt(260)*y(58)

         mat(1033) = rxt(262)*y(57) + rxt(261)*y(59)
         mat(51) = rxt(262)*y(20)
         mat(159) = rxt(261)*y(20)

         mat(157) = -(rxt(261)*y(20))
         mat(1003) = -rxt(261)*y(59)

         mat(1098) = rxt(259)*y(58)
         mat(395) = rxt(259)*y(21)

         mat(346) = -(rxt(266)*y(20))
         mat(1028) = -rxt(266)*y(60)

         mat(818) = .500_r8*rxt(276)*y(70) + .250_r8*rxt(317)*y(81) + .100_r8*rxt(336) &
                      *y(97) + .820_r8*rxt(258)*y(58)
         mat(712) = .820_r8*rxt(260)*y(58)
         mat(140) = .500_r8*rxt(276)*y(6)
         mat(336) = .250_r8*rxt(317)*y(6)
         mat(459) = .100_r8*rxt(336)*y(6)
         mat(396) = .820_r8*rxt(258)*y(6) + .820_r8*rxt(260)*y(13)

         mat(163) = -(rxt(270)*y(20))
         mat(1004) = -rxt(270)*y(66)

         mat(1099) = rxt(268)*y(64)
         mat(514) = rxt(268)*y(21)

         mat(228) = -(rxt(221)*y(20))
         mat(1014) = -rxt(221)*y(15)

         mat(709) = 2.000_r8*rxt(220)*y(13) + .250_r8*rxt(308)*y(85) &
                      + .250_r8*rxt(289)*y(76) + .300_r8*rxt(239)*y(43) &
                      + .500_r8*rxt(269)*y(64) + .300_r8*rxt(323)*y(88)
         mat(623) = .250_r8*rxt(308)*y(13)
         mat(603) = .250_r8*rxt(289)*y(13)
         mat(364) = .300_r8*rxt(239)*y(13)
         mat(515) = .500_r8*rxt(269)*y(13)
         mat(567) = .300_r8*rxt(323)*y(13)

         mat(100) = -(rxt(252)*y(20))
         mat(994) = -rxt(252)*y(48)

         mat(706) = .200_r8*rxt(239)*y(43)
         mat(362) = .200_r8*rxt(239)*y(13) + .800_r8*rxt(240)*y(43)

         mat(383) = -(rxt(250)*y(20))
         mat(1031) = -rxt(250)*y(49)

         mat(821) = .530_r8*rxt(285)*y(76) + .250_r8*rxt(320)*y(88)
         mat(885) = .530_r8*rxt(287)*y(76) + .250_r8*rxt(321)*y(88)
         mat(714) = .260_r8*rxt(289)*y(76) + .100_r8*rxt(323)*y(88)
         mat(667) = .530_r8*rxt(290)*y(76) + .250_r8*rxt(324)*y(88)
         mat(604) = .530_r8*rxt(285)*y(6) + .530_r8*rxt(287)*y(8) + .260_r8*rxt(289) &
                      *y(13) + .530_r8*rxt(290)*y(45)
         mat(569) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)

         mat(527) = -(rxt(271)*y(20))
         mat(1045) = -rxt(271)*y(63)

         mat(828) = .220_r8*rxt(285)*y(76) + .250_r8*rxt(320)*y(88)
         mat(1045) = mat(1045) + .500_r8*rxt(265)*y(62) + .500_r8*rxt(300)*y(78)
         mat(894) = .220_r8*rxt(287)*y(76) + .250_r8*rxt(321)*y(88)
         mat(718) = .230_r8*rxt(289)*y(76) + .200_r8*rxt(269)*y(64) + .100_r8*rxt(323) &
                      *y(88)
         mat(265) = .500_r8*rxt(265)*y(20)
         mat(669) = .220_r8*rxt(290)*y(76) + .250_r8*rxt(324)*y(88)
         mat(272) = .500_r8*rxt(300)*y(20)
         mat(607) = .220_r8*rxt(285)*y(6) + .220_r8*rxt(287)*y(8) + .230_r8*rxt(289) &
                      *y(13) + .220_r8*rxt(290)*y(45)
         mat(517) = .200_r8*rxt(269)*y(13)
         mat(571) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)

         mat(281) = -(rxt(231)*y(6) + rxt(232)*y(21))
         mat(814) = -rxt(231)*y(52)
         mat(1111) = -rxt(232)*y(52)

         mat(1020) = rxt(230)*y(41)
         mat(148) = rxt(230)*y(20)


         mat(805) = .750_r8*rxt(231)*y(52)
         mat(280) = .750_r8*rxt(231)*y(6)


         mat(1092) = rxt(232)*y(52)
         mat(279) = rxt(232)*y(21)

         mat(154) = -(rxt(316)*y(20))
         mat(1002) = -rxt(316)*y(84)

         mat(807) = .370_r8*rxt(304)*y(85)
         mat(1002) = mat(1002) + rxt(314)*y(87)
         mat(881) = .400_r8*rxt(305)*y(85) + rxt(315)*y(87)
         mat(707) = .300_r8*rxt(308)*y(85)
         mat(662) = .400_r8*rxt(309)*y(85)
         mat(622) = .370_r8*rxt(304)*y(6) + .400_r8*rxt(305)*y(8) + .300_r8*rxt(308) &
                      *y(13) + .400_r8*rxt(309)*y(45)
         mat(449) = rxt(314)*y(20) + rxt(315)*y(8)

         mat(516) = -(rxt(267)*y(6) + rxt(268)*y(21) + rxt(269)*y(13))
         mat(827) = -rxt(267)*y(64)
         mat(1131) = -rxt(268)*y(64)
         mat(717) = -rxt(269)*y(64)

         mat(1044) = rxt(266)*y(60) + rxt(270)*y(66)
         mat(347) = rxt(266)*y(20)
         mat(164) = rxt(270)*y(20)

         mat(558) = -(rxt(272)*y(20) + rxt(273)*y(8))
         mat(1048) = -rxt(272)*y(65)
         mat(897) = -rxt(273)*y(65)

         mat(935) = .950_r8*rxt(278)*y(74) + .800_r8*rxt(284)*y(75)
         mat(831) = .450_r8*rxt(328)*y(93) + .250_r8*rxt(285)*y(76) + .250_r8*rxt(320) &
                      *y(88)
         mat(1048) = mat(1048) + rxt(274)*y(79) + rxt(271)*y(63)
         mat(897) = mat(897) + .250_r8*rxt(287)*y(76) + .250_r8*rxt(321)*y(88)
         mat(721) = .240_r8*rxt(289)*y(76) + .500_r8*rxt(269)*y(64) + .100_r8*rxt(323) &
                      *y(88)
         mat(671) = .250_r8*rxt(290)*y(76) + .250_r8*rxt(324)*y(88)
         mat(170) = rxt(274)*y(20)
         mat(236) = .450_r8*rxt(328)*y(6)
         mat(588) = .950_r8*rxt(278)*y(1)
         mat(546) = .800_r8*rxt(284)*y(1)
         mat(608) = .250_r8*rxt(285)*y(6) + .250_r8*rxt(287)*y(8) + .240_r8*rxt(289) &
                      *y(13) + .250_r8*rxt(290)*y(45)
         mat(528) = rxt(271)*y(20)
         mat(518) = .500_r8*rxt(269)*y(13)
         mat(572) = .250_r8*rxt(320)*y(6) + .250_r8*rxt(321)*y(8) + .100_r8*rxt(323) &
                      *y(13) + .250_r8*rxt(324)*y(45)

         mat(490) = -(rxt(310)*y(6) + rxt(311)*y(8) + rxt(312)*y(21))
         mat(825) = -rxt(310)*y(86)
         mat(891) = -rxt(311)*y(86)
         mat(1128) = -rxt(312)*y(86)

         mat(891) = mat(891) + rxt(303)*y(80)
         mat(416) = rxt(303)*y(8)

         mat(450) = -(rxt(314)*y(20) + rxt(315)*y(8))
         mat(1038) = -rxt(314)*y(87)
         mat(888) = -rxt(315)*y(87)

         mat(823) = .080_r8*rxt(304)*y(85) + .800_r8*rxt(286)*y(76) + .794_r8*rxt(310) &
                      *y(86)
         mat(888) = mat(888) + .794_r8*rxt(311)*y(86)
         mat(1126) = .794_r8*rxt(312)*y(86)
         mat(625) = .080_r8*rxt(304)*y(6)
         mat(605) = .800_r8*rxt(286)*y(6)
         mat(489) = .794_r8*rxt(310)*y(6) + .794_r8*rxt(311)*y(8) + .794_r8*rxt(312) &
                      *y(21)

         mat(573) = -(rxt(320)*y(6) + rxt(321)*y(8) + rxt(322)*y(21) + rxt(323)*y(13) &
                      + rxt(324)*y(45))
         mat(832) = -rxt(320)*y(88)
         mat(898) = -rxt(321)*y(88)
         mat(1136) = -rxt(322)*y(88)
         mat(722) = -rxt(323)*y(88)
         mat(672) = -rxt(324)*y(88)

         mat(1049) = rxt(316)*y(84) + rxt(325)*y(89) + .800_r8*rxt(307)*y(90)
         mat(155) = rxt(316)*y(20)
         mat(136) = rxt(325)*y(20)
         mat(249) = .800_r8*rxt(307)*y(20)

         mat(135) = -((rxt(325) + rxt(326)) * y(20))
         mat(999) = -(rxt(325) + rxt(326)) * y(89)

         mat(1097) = rxt(312)*y(86) + rxt(322)*y(88)
         mat(488) = rxt(312)*y(21)
         mat(566) = rxt(322)*y(21)

         mat(247) = -(rxt(307)*y(20))
         mat(1017) = -rxt(307)*y(90)

         mat(1109) = rxt(306)*y(85)
         mat(624) = rxt(306)*y(21)

         mat(71) = -(rxt(228)*y(20))
         mat(990) = -rxt(228)*y(118)

         mat(173) = -(rxt(223)*y(20))
         mat(1006) = -rxt(223)*y(119)

         mat(921) = .500_r8*rxt(235)*y(41)
         mat(809) = rxt(225)*y(120)
         mat(1006) = mat(1006) + .350_r8*rxt(228)*y(118)
         mat(1100) = rxt(226)*y(120)
         mat(147) = .500_r8*rxt(235)*y(1)
         mat(72) = .350_r8*rxt(228)*y(20)
         mat(207) = rxt(225)*y(6) + rxt(226)*y(21)

         mat(208) = -(rxt(225)*y(6) + rxt(226)*y(21))
         mat(811) = -rxt(225)*y(120)
         mat(1105) = -rxt(226)*y(120)

         mat(757) = rxt(216)*y(21)
         mat(1105) = mat(1105) + rxt(216)*y(16)

         mat(55) = -(rxt(343)*y(20))
         mat(987) = -rxt(343)*y(121)

         mat(987) = mat(987) + (rxt(344)+.500_r8*rxt(345))*y(122)
         mat(878) = rxt(346)*y(122)
         mat(91) = (rxt(344)+.500_r8*rxt(345))*y(20) + rxt(346)*y(8)

         mat(92) = -((rxt(344) + rxt(345)) * y(20) + rxt(346)*y(8))
         mat(993) = -(rxt(344) + rxt(345)) * y(122)
         mat(879) = -rxt(346)*y(122)

         mat(41) = -(rxt(347)*y(20))
         mat(984) = -rxt(347)*y(123)



         mat(981) = rxt(343)*y(121)
         mat(54) = rxt(343)*y(20)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      end subroutine nlnmat06
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = lmat( 25)
         mat( 26) = lmat( 26)
         mat( 27) = lmat( 27)
         mat( 28) = lmat( 28)
         mat( 29) = lmat( 29)
         mat( 30) = lmat( 30)
         mat( 31) = lmat( 31)
         mat( 32) = lmat( 32)
         mat( 33) = lmat( 33)
         mat( 34) = lmat( 34)
         mat( 35) = mat( 35) + lmat( 35)
         mat( 38) = mat( 38) + lmat( 38)
         mat( 41) = mat( 41) + lmat( 41)
         mat( 44) = mat( 44) + lmat( 44)
         mat( 47) = lmat( 47)
         mat( 48) = lmat( 48)
         mat( 49) = lmat( 49)
         mat( 50) = mat( 50) + lmat( 50)
         mat( 55) = mat( 55) + lmat( 55)
         mat( 57) = mat( 57) + lmat( 57)
         mat( 62) = mat( 62) + lmat( 62)
         mat( 65) = lmat( 65)
         mat( 66) = lmat( 66)
         mat( 67) = lmat( 67)
         mat( 68) = lmat( 68)
         mat( 69) = lmat( 69)
         mat( 70) = lmat( 70)
         mat( 71) = mat( 71) + lmat( 71)
         mat( 77) = lmat( 77)
         mat( 78) = lmat( 78)
         mat( 79) = mat( 79) + lmat( 79)
         mat( 83) = mat( 83) + lmat( 83)
         mat( 84) = mat( 84) + lmat( 84)
         mat( 85) = mat( 85) + lmat( 85)
         mat( 87) = mat( 87) + lmat( 87)
         mat( 92) = mat( 92) + lmat( 92)
         mat( 97) = lmat( 97)
         mat( 98) = lmat( 98)
         mat( 99) = lmat( 99)
         mat( 100) = mat( 100) + lmat( 100)
         mat( 104) = lmat( 104)
         mat( 105) = lmat( 105)
         mat( 106) = lmat( 106)
         mat( 107) = lmat( 107)
         mat( 108) = lmat( 108)
         mat( 109) = lmat( 109)
         mat( 110) = lmat( 110)
         mat( 111) = lmat( 111)
         mat( 112) = lmat( 112)
         mat( 113) = lmat( 113)
         mat( 114) = mat( 114) + lmat( 114)
         mat( 120) = mat( 120) + lmat( 120)
         mat( 122) = lmat( 122)
         mat( 123) = lmat( 123)
         mat( 124) = mat( 124) + lmat( 124)
         mat( 125) = mat( 125) + lmat( 125)
         mat( 130) = mat( 130) + lmat( 130)
         mat( 132) = mat( 132) + lmat( 132)
         mat( 133) = mat( 133) + lmat( 133)
         mat( 134) = lmat( 134)
         mat( 135) = mat( 135) + lmat( 135)
         mat( 138) = mat( 138) + lmat( 138)
         mat( 139) = mat( 139) + lmat( 139)
         mat( 146) = mat( 146) + lmat( 146)
         mat( 154) = mat( 154) + lmat( 154)
         mat( 157) = mat( 157) + lmat( 157)
         mat( 158) = lmat( 158)
         mat( 161) = mat( 161) + lmat( 161)
         mat( 162) = lmat( 162)
         mat( 163) = mat( 163) + lmat( 163)
         mat( 165) = lmat( 165)
         mat( 167) = lmat( 167)
         mat( 168) = mat( 168) + lmat( 168)
         mat( 169) = mat( 169) + lmat( 169)
         mat( 173) = mat( 173) + lmat( 173)
         mat( 177) = mat( 177) + lmat( 177)
         mat( 179) = lmat( 179)
         mat( 180) = mat( 180) + lmat( 180)
         mat( 181) = lmat( 181)
         mat( 182) = mat( 182) + lmat( 182)
         mat( 183) = mat( 183) + lmat( 183)
         mat( 185) = lmat( 185)
         mat( 187) = mat( 187) + lmat( 187)
         mat( 188) = mat( 188) + lmat( 188)
         mat( 189) = mat( 189) + lmat( 189)
         mat( 191) = lmat( 191)
         mat( 192) = lmat( 192)
         mat( 193) = lmat( 193)
         mat( 194) = mat( 194) + lmat( 194)
         mat( 195) = mat( 195) + lmat( 195)
         mat( 197) = lmat( 197)
         mat( 198) = lmat( 198)
         mat( 200) = mat( 200) + lmat( 200)
         mat( 201) = lmat( 201)
         mat( 203) = lmat( 203)
         mat( 204) = lmat( 204)
         mat( 205) = mat( 205) + lmat( 205)
         mat( 206) = lmat( 206)
         mat( 208) = mat( 208) + lmat( 208)
         mat( 210) = lmat( 210)
         mat( 213) = mat( 213) + lmat( 213)
         mat( 215) = mat( 215) + lmat( 215)
         mat( 216) = lmat( 216)
         mat( 217) = lmat( 217)
         mat( 219) = mat( 219) + lmat( 219)
         mat( 221) = lmat( 221)
         mat( 222) = mat( 222) + lmat( 222)
         mat( 225) = lmat( 225)
         mat( 227) = mat( 227) + lmat( 227)
         mat( 228) = mat( 228) + lmat( 228)
         mat( 233) = mat( 233) + lmat( 233)
         mat( 241) = lmat( 241)
         mat( 242) = lmat( 242)
         mat( 243) = lmat( 243)
         mat( 244) = lmat( 244)
         mat( 245) = lmat( 245)
         mat( 246) = lmat( 246)
         mat( 247) = mat( 247) + lmat( 247)
         mat( 248) = lmat( 248)
         mat( 250) = lmat( 250)
         mat( 252) = lmat( 252)
         mat( 254) = lmat( 254)
         mat( 255) = mat( 255) + lmat( 255)
         mat( 256) = lmat( 256)
         mat( 257) = lmat( 257)
         mat( 258) = lmat( 258)
         mat( 259) = mat( 259) + lmat( 259)
         mat( 261) = mat( 261) + lmat( 261)
         mat( 262) = lmat( 262)
         mat( 263) = mat( 263) + lmat( 263)
         mat( 266) = lmat( 266)
         mat( 268) = lmat( 268)
         mat( 269) = mat( 269) + lmat( 269)
         mat( 270) = lmat( 270)
         mat( 271) = mat( 271) + lmat( 271)
         mat( 273) = lmat( 273)
         mat( 278) = lmat( 278)
         mat( 281) = mat( 281) + lmat( 281)
         mat( 288) = mat( 288) + lmat( 288)
         mat( 297) = mat( 297) + lmat( 297)
         mat( 301) = mat( 301) + lmat( 301)
         mat( 305) = mat( 305) + lmat( 305)
         mat( 308) = mat( 308) + lmat( 308)
         mat( 309) = mat( 309) + lmat( 309)
         mat( 311) = mat( 311) + lmat( 311)
         mat( 312) = lmat( 312)
         mat( 313) = mat( 313) + lmat( 313)
         mat( 316) = lmat( 316)
         mat( 318) = lmat( 318)
         mat( 320) = lmat( 320)
         mat( 321) = mat( 321) + lmat( 321)
         mat( 322) = lmat( 322)
         mat( 324) = mat( 324) + lmat( 324)
         mat( 335) = mat( 335) + lmat( 335)
         mat( 346) = mat( 346) + lmat( 346)
         mat( 348) = lmat( 348)
         mat( 350) = lmat( 350)
         mat( 353) = mat( 353) + lmat( 353)
         mat( 365) = mat( 365) + lmat( 365)
         mat( 374) = mat( 374) + lmat( 374)
         mat( 376) = lmat( 376)
         mat( 379) = mat( 379) + lmat( 379)
         mat( 383) = mat( 383) + lmat( 383)
         mat( 384) = lmat( 384)
         mat( 385) = mat( 385) + lmat( 385)
         mat( 387) = mat( 387) + lmat( 387)
         mat( 388) = mat( 388) + lmat( 388)
         mat( 390) = lmat( 390)
         mat( 391) = mat( 391) + lmat( 391)
         mat( 397) = mat( 397) + lmat( 397)
         mat( 408) = mat( 408) + lmat( 408)
         mat( 411) = mat( 411) + lmat( 411)
         mat( 412) = lmat( 412)
         mat( 414) = mat( 414) + lmat( 414)
         mat( 430) = mat( 430) + lmat( 430)
         mat( 432) = mat( 432) + lmat( 432)
         mat( 435) = mat( 435) + lmat( 435)
         mat( 438) = mat( 438) + lmat( 438)
         mat( 439) = mat( 439) + lmat( 439)
         mat( 440) = mat( 440) + lmat( 440)
         mat( 442) = mat( 442) + lmat( 442)
         mat( 443) = mat( 443) + lmat( 443)
         mat( 444) = mat( 444) + lmat( 444)
         mat( 448) = lmat( 448)
         mat( 450) = mat( 450) + lmat( 450)
         mat( 451) = lmat( 451)
         mat( 453) = lmat( 453)
         mat( 456) = mat( 456) + lmat( 456)
         mat( 457) = mat( 457) + lmat( 457)
         mat( 460) = mat( 460) + lmat( 460)
         mat( 474) = mat( 474) + lmat( 474)
         mat( 490) = mat( 490) + lmat( 490)
         mat( 502) = mat( 502) + lmat( 502)
         mat( 510) = mat( 510) + lmat( 510)
         mat( 516) = mat( 516) + lmat( 516)
         mat( 527) = mat( 527) + lmat( 527)
         mat( 529) = lmat( 529)
         mat( 530) = lmat( 530)
         mat( 532) = mat( 532) + lmat( 532)
         mat( 534) = lmat( 534)
         mat( 535) = mat( 535) + lmat( 535)
         mat( 539) = lmat( 539)
         mat( 542) = lmat( 542)
         mat( 544) = mat( 544) + lmat( 544)
         mat( 545) = mat( 545) + lmat( 545)
         mat( 548) = mat( 548) + lmat( 548)
         mat( 549) = lmat( 549)
         mat( 552) = mat( 552) + lmat( 552)
         mat( 555) = mat( 555) + lmat( 555)
         mat( 557) = mat( 557) + lmat( 557)
         mat( 558) = mat( 558) + lmat( 558)
         mat( 559) = mat( 559) + lmat( 559)
         mat( 564) = lmat( 564)
         mat( 573) = mat( 573) + lmat( 573)
         mat( 584) = lmat( 584)
         mat( 585) = mat( 585) + lmat( 585)
         mat( 589) = mat( 589) + lmat( 589)
         mat( 591) = lmat( 591)
         mat( 594) = lmat( 594)
         mat( 610) = mat( 610) + lmat( 610)
         mat( 632) = mat( 632) + lmat( 632)
         mat( 650) = mat( 650) + lmat( 650)
         mat( 677) = mat( 677) + lmat( 677)
         mat( 688) = lmat( 688)
         mat( 689) = mat( 689) + lmat( 689)
         mat( 690) = lmat( 690)
         mat( 693) = mat( 693) + lmat( 693)
         mat( 694) = mat( 694) + lmat( 694)
         mat( 695) = lmat( 695)
         mat( 698) = mat( 698) + lmat( 698)
         mat( 704) = mat( 704) + lmat( 704)
         mat( 730) = mat( 730) + lmat( 730)
         mat( 747) = mat( 747) + lmat( 747)
         mat( 760) = lmat( 760)
         mat( 761) = mat( 761) + lmat( 761)
         mat( 763) = mat( 763) + lmat( 763)
         mat( 765) = mat( 765) + lmat( 765)
         mat( 784) = mat( 784) + lmat( 784)
         mat( 789) = lmat( 789)
         mat( 790) = lmat( 790)
         mat( 792) = mat( 792) + lmat( 792)
         mat( 797) = mat( 797) + lmat( 797)
         mat( 800) = mat( 800) + lmat( 800)
         mat( 804) = mat( 804) + lmat( 804)
         mat( 844) = mat( 844) + lmat( 844)
         mat( 852) = mat( 852) + lmat( 852)
         mat( 866) = mat( 866) + lmat( 866)
         mat( 868) = mat( 868) + lmat( 868)
         mat( 875) = mat( 875) + lmat( 875)
         mat( 886) = mat( 886) + lmat( 886)
         mat( 909) = mat( 909) + lmat( 909)
         mat( 911) = mat( 911) + lmat( 911)
         mat( 917) = mat( 917) + lmat( 917)
         mat( 919) = mat( 919) + lmat( 919)
         mat( 951) = mat( 951) + lmat( 951)
         mat( 954) = mat( 954) + lmat( 954)
         mat( 956) = mat( 956) + lmat( 956)
         mat( 966) = lmat( 966)
         mat( 969) = mat( 969) + lmat( 969)
         mat( 974) = mat( 974) + lmat( 974)
         mat(1055) = mat(1055) + lmat(1055)
         mat(1057) = mat(1057) + lmat(1057)
         mat(1058) = mat(1058) + lmat(1058)
         mat(1060) = mat(1060) + lmat(1060)
         mat(1066) = mat(1066) + lmat(1066)
         mat(1068) = mat(1068) + lmat(1068)
         mat(1074) = mat(1074) + lmat(1074)
         mat(1076) = mat(1076) + lmat(1076)
         mat(1077) = lmat(1077)
         mat(1078) = mat(1078) + lmat(1078)
         mat(1079) = lmat(1079)
         mat(1080) = mat(1080) + lmat(1080)
         mat(1081) = lmat(1081)
         mat(1086) = mat(1086) + lmat(1086)
         mat(1087) = mat(1087) + lmat(1087)
         mat(1088) = lmat(1088)
         mat(1089) = lmat(1089)
         mat(1113) = mat(1113) + lmat(1113)
         mat(1155) = mat(1155) + lmat(1155)
         mat(1176) = mat(1176) + lmat(1176)
         mat(1181) = mat(1181) + lmat(1181)
         mat(1191) = mat(1191) + lmat(1191)
         mat(1202) = mat(1202) + lmat(1202)
         mat(1203) = mat(1203) + lmat(1203)
         mat(1215) = mat(1215) + lmat(1215)
         mat(1228) = mat(1228) + lmat(1228)
         mat(1233) = mat(1233) + lmat(1233)
         mat(1236) = mat(1236) + lmat(1236)
         mat(1238) = mat(1238) + lmat(1238)
         mat( 209) = 0._r8
         mat( 212) = 0._r8
         mat( 238) = 0._r8
         mat( 282) = 0._r8
         mat( 285) = 0._r8
         mat( 314) = 0._r8
         mat( 317) = 0._r8
         mat( 319) = 0._r8
         mat( 328) = 0._r8
         mat( 334) = 0._r8
         mat( 337) = 0._r8
         mat( 339) = 0._r8
         mat( 340) = 0._r8
         mat( 343) = 0._r8
         mat( 354) = 0._r8
         mat( 356) = 0._r8
         mat( 359) = 0._r8
         mat( 370) = 0._r8
         mat( 377) = 0._r8
         mat( 398) = 0._r8
         mat( 400) = 0._r8
         mat( 401) = 0._r8
         mat( 405) = 0._r8
         mat( 422) = 0._r8
         mat( 423) = 0._r8
         mat( 441) = 0._r8
         mat( 452) = 0._r8
         mat( 461) = 0._r8
         mat( 464) = 0._r8
         mat( 465) = 0._r8
         mat( 466) = 0._r8
         mat( 468) = 0._r8
         mat( 476) = 0._r8
         mat( 478) = 0._r8
         mat( 479) = 0._r8
         mat( 482) = 0._r8
         mat( 487) = 0._r8
         mat( 491) = 0._r8
         mat( 493) = 0._r8
         mat( 495) = 0._r8
         mat( 499) = 0._r8
         mat( 520) = 0._r8
         mat( 524) = 0._r8
         mat( 538) = 0._r8
         mat( 543) = 0._r8
         mat( 551) = 0._r8
         mat( 561) = 0._r8
         mat( 565) = 0._r8
         mat( 575) = 0._r8
         mat( 576) = 0._r8
         mat( 581) = 0._r8
         mat( 586) = 0._r8
         mat( 592) = 0._r8
         mat( 593) = 0._r8
         mat( 596) = 0._r8
         mat( 597) = 0._r8
         mat( 601) = 0._r8
         mat( 609) = 0._r8
         mat( 611) = 0._r8
         mat( 613) = 0._r8
         mat( 614) = 0._r8
         mat( 619) = 0._r8
         mat( 626) = 0._r8
         mat( 628) = 0._r8
         mat( 629) = 0._r8
         mat( 631) = 0._r8
         mat( 633) = 0._r8
         mat( 635) = 0._r8
         mat( 636) = 0._r8
         mat( 641) = 0._r8
         mat( 642) = 0._r8
         mat( 648) = 0._r8
         mat( 649) = 0._r8
         mat( 652) = 0._r8
         mat( 653) = 0._r8
         mat( 659) = 0._r8
         mat( 678) = 0._r8
         mat( 679) = 0._r8
         mat( 683) = 0._r8
         mat( 685) = 0._r8
         mat( 691) = 0._r8
         mat( 692) = 0._r8
         mat( 699) = 0._r8
         mat( 701) = 0._r8
         mat( 703) = 0._r8
         mat( 728) = 0._r8
         mat( 729) = 0._r8
         mat( 735) = 0._r8
         mat( 736) = 0._r8
         mat( 737) = 0._r8
         mat( 738) = 0._r8
         mat( 739) = 0._r8
         mat( 741) = 0._r8
         mat( 745) = 0._r8
         mat( 746) = 0._r8
         mat( 749) = 0._r8
         mat( 751) = 0._r8
         mat( 752) = 0._r8
         mat( 753) = 0._r8
         mat( 755) = 0._r8
         mat( 767) = 0._r8
         mat( 769) = 0._r8
         mat( 772) = 0._r8
         mat( 775) = 0._r8
         mat( 776) = 0._r8
         mat( 785) = 0._r8
         mat( 786) = 0._r8
         mat( 787) = 0._r8
         mat( 793) = 0._r8
         mat( 799) = 0._r8
         mat( 801) = 0._r8
         mat( 802) = 0._r8
         mat( 803) = 0._r8
         mat( 838) = 0._r8
         mat( 839) = 0._r8
         mat( 848) = 0._r8
         mat( 850) = 0._r8
         mat( 861) = 0._r8
         mat( 862) = 0._r8
         mat( 869) = 0._r8
         mat( 870) = 0._r8
         mat( 873) = 0._r8
         mat( 893) = 0._r8
         mat( 904) = 0._r8
         mat( 905) = 0._r8
         mat( 906) = 0._r8
         mat( 908) = 0._r8
         mat( 910) = 0._r8
         mat( 912) = 0._r8
         mat( 913) = 0._r8
         mat( 915) = 0._r8
         mat( 918) = 0._r8
         mat( 922) = 0._r8
         mat( 925) = 0._r8
         mat( 927) = 0._r8
         mat( 929) = 0._r8
         mat( 931) = 0._r8
         mat( 932) = 0._r8
         mat( 936) = 0._r8
         mat( 938) = 0._r8
         mat( 939) = 0._r8
         mat( 941) = 0._r8
         mat( 942) = 0._r8
         mat( 952) = 0._r8
         mat( 967) = 0._r8
         mat( 968) = 0._r8
         mat( 970) = 0._r8
         mat( 971) = 0._r8
         mat( 972) = 0._r8
         mat( 973) = 0._r8
         mat( 977) = 0._r8
         mat( 979) = 0._r8
         mat( 980) = 0._r8
         mat(1016) = 0._r8
         mat(1041) = 0._r8
         mat(1061) = 0._r8
         mat(1067) = 0._r8
         mat(1082) = 0._r8
         mat(1083) = 0._r8
         mat(1090) = 0._r8
         mat(1091) = 0._r8
         mat(1093) = 0._r8
         mat(1108) = 0._r8
         mat(1114) = 0._r8
         mat(1118) = 0._r8
         mat(1122) = 0._r8
         mat(1130) = 0._r8
         mat(1132) = 0._r8
         mat(1133) = 0._r8
         mat(1135) = 0._r8
         mat(1154) = 0._r8
         mat(1163) = 0._r8
         mat(1168) = 0._r8
         mat(1179) = 0._r8
         mat(1188) = 0._r8
         mat(1189) = 0._r8
         mat(1190) = 0._r8
         mat(1192) = 0._r8
         mat(1196) = 0._r8
         mat(1197) = 0._r8
         mat(1198) = 0._r8
         mat(1200) = 0._r8
         mat(1213) = 0._r8
         mat(1214) = 0._r8
         mat(1217) = 0._r8
         mat(1218) = 0._r8
         mat(1219) = 0._r8
         mat(1222) = 0._r8
         mat(1223) = 0._r8
         mat(1224) = 0._r8
         mat(1225) = 0._r8
         mat(1226) = 0._r8
         mat(1227) = 0._r8
         mat(1232) = 0._r8
         mat(1234) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 17) = mat( 17) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 20) = mat( 20) - dti
         mat( 21) = mat( 21) - dti
         mat( 22) = mat( 22) - dti
         mat( 23) = mat( 23) - dti
         mat( 24) = mat( 24) - dti
         mat( 25) = mat( 25) - dti
         mat( 26) = mat( 26) - dti
         mat( 27) = mat( 27) - dti
         mat( 28) = mat( 28) - dti
         mat( 29) = mat( 29) - dti
         mat( 30) = mat( 30) - dti
         mat( 31) = mat( 31) - dti
         mat( 32) = mat( 32) - dti
         mat( 33) = mat( 33) - dti
         mat( 34) = mat( 34) - dti
         mat( 35) = mat( 35) - dti
         mat( 38) = mat( 38) - dti
         mat( 41) = mat( 41) - dti
         mat( 44) = mat( 44) - dti
         mat( 47) = mat( 47) - dti
         mat( 50) = mat( 50) - dti
         mat( 55) = mat( 55) - dti
         mat( 57) = mat( 57) - dti
         mat( 62) = mat( 62) - dti
         mat( 65) = mat( 65) - dti
         mat( 68) = mat( 68) - dti
         mat( 71) = mat( 71) - dti
         mat( 77) = mat( 77) - dti
         mat( 79) = mat( 79) - dti
         mat( 83) = mat( 83) - dti
         mat( 87) = mat( 87) - dti
         mat( 92) = mat( 92) - dti
         mat( 97) = mat( 97) - dti
         mat( 100) = mat( 100) - dti
         mat( 104) = mat( 104) - dti
         mat( 108) = mat( 108) - dti
         mat( 114) = mat( 114) - dti
         mat( 120) = mat( 120) - dti
         mat( 125) = mat( 125) - dti
         mat( 130) = mat( 130) - dti
         mat( 135) = mat( 135) - dti
         mat( 139) = mat( 139) - dti
         mat( 146) = mat( 146) - dti
         mat( 154) = mat( 154) - dti
         mat( 157) = mat( 157) - dti
         mat( 163) = mat( 163) - dti
         mat( 169) = mat( 169) - dti
         mat( 173) = mat( 173) - dti
         mat( 177) = mat( 177) - dti
         mat( 183) = mat( 183) - dti
         mat( 189) = mat( 189) - dti
         mat( 195) = mat( 195) - dti
         mat( 200) = mat( 200) - dti
         mat( 208) = mat( 208) - dti
         mat( 215) = mat( 215) - dti
         mat( 222) = mat( 222) - dti
         mat( 228) = mat( 228) - dti
         mat( 233) = mat( 233) - dti
         mat( 241) = mat( 241) - dti
         mat( 247) = mat( 247) - dti
         mat( 255) = mat( 255) - dti
         mat( 263) = mat( 263) - dti
         mat( 271) = mat( 271) - dti
         mat( 281) = mat( 281) - dti
         mat( 288) = mat( 288) - dti
         mat( 297) = mat( 297) - dti
         mat( 301) = mat( 301) - dti
         mat( 308) = mat( 308) - dti
         mat( 313) = mat( 313) - dti
         mat( 324) = mat( 324) - dti
         mat( 335) = mat( 335) - dti
         mat( 346) = mat( 346) - dti
         mat( 353) = mat( 353) - dti
         mat( 365) = mat( 365) - dti
         mat( 374) = mat( 374) - dti
         mat( 383) = mat( 383) - dti
         mat( 388) = mat( 388) - dti
         mat( 397) = mat( 397) - dti
         mat( 408) = mat( 408) - dti
         mat( 414) = mat( 414) - dti
         mat( 430) = mat( 430) - dti
         mat( 440) = mat( 440) - dti
         mat( 450) = mat( 450) - dti
         mat( 460) = mat( 460) - dti
         mat( 474) = mat( 474) - dti
         mat( 490) = mat( 490) - dti
         mat( 502) = mat( 502) - dti
         mat( 510) = mat( 510) - dti
         mat( 516) = mat( 516) - dti
         mat( 527) = mat( 527) - dti
         mat( 535) = mat( 535) - dti
         mat( 545) = mat( 545) - dti
         mat( 558) = mat( 558) - dti
         mat( 573) = mat( 573) - dti
         mat( 589) = mat( 589) - dti
         mat( 610) = mat( 610) - dti
         mat( 632) = mat( 632) - dti
         mat( 650) = mat( 650) - dti
         mat( 677) = mat( 677) - dti
         mat( 689) = mat( 689) - dti
         mat( 698) = mat( 698) - dti
         mat( 730) = mat( 730) - dti
         mat( 747) = mat( 747) - dti
         mat( 765) = mat( 765) - dti
         mat( 792) = mat( 792) - dti
         mat( 844) = mat( 844) - dti
         mat( 868) = mat( 868) - dti
         mat( 911) = mat( 911) - dti
         mat( 951) = mat( 951) - dti
         mat( 974) = mat( 974) - dti
         mat(1066) = mat(1066) - dti
         mat(1087) = mat(1087) - dti
         mat(1155) = mat(1155) - dti
         mat(1181) = mat(1181) - dti
         mat(1203) = mat(1203) - dti
         mat(1238) = mat(1238) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
