



      module mo_prod_loss

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: exp_prod_loss
      public :: imp_prod_loss

      contains

      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:,:,:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:,:,:)
      real(r8), intent(in) :: rxt(:,:,:)
      real(r8), intent(in) :: het_rates(:,:,:)



!--------------------------------------------------------------------
! ... loss and production for Explicit method
!--------------------------------------------------------------------


         loss(:,:,1) = ( + het_rates(:,:,168))* y(:,:,168)
         prod(:,:,1) = 0._r8
         loss(:,:,2) = ((rxt(:,:,109) +rxt(:,:,110) +rxt(:,:,111))* y(:,:,3) &
                  +rxt(:,:,212)* y(:,:,20) +rxt(:,:,163)* y(:,:,25) + rxt(:,:,54) &
                  + rxt(:,:,55) + het_rates(:,:,12))* y(:,:,12)
         prod(:,:,2) = 0._r8
         loss(:,:,3) = ((rxt(:,:,90) +rxt(:,:,91))* y(:,:,3) + rxt(:,:,4) &
                  + het_rates(:,:,4))* y(:,:,4)
         prod(:,:,3) = 0._r8
         loss(:,:,4) = (rxt(:,:,201)* y(:,:,20) +rxt(:,:,200)* y(:,:,25) + rxt(:,:,35) &
                  + het_rates(:,:,105))* y(:,:,105)
         prod(:,:,4) = 0._r8
         loss(:,:,5) = (rxt(:,:,102)* y(:,:,3) +rxt(:,:,204)* y(:,:,20) +rxt(:,:,205) &
                 * y(:,:,25) + rxt(:,:,46) + het_rates(:,:,106))* y(:,:,106)
         prod(:,:,5) = 0._r8
         loss(:,:,6) = (rxt(:,:,93)* y(:,:,3) + rxt(:,:,38) + het_rates(:,:,107)) &
                 * y(:,:,107)
         prod(:,:,6) = 0._r8
         loss(:,:,7) = (rxt(:,:,94)* y(:,:,3) + rxt(:,:,39) + het_rates(:,:,108)) &
                 * y(:,:,108)
         prod(:,:,7) = 0._r8
         loss(:,:,8) = (rxt(:,:,95)* y(:,:,3) + rxt(:,:,40) + het_rates(:,:,109)) &
                 * y(:,:,109)
         prod(:,:,8) = 0._r8
         loss(:,:,9) = (rxt(:,:,96)* y(:,:,3) + rxt(:,:,42) + het_rates(:,:,117)) &
                 * y(:,:,117)
         prod(:,:,9) = 0._r8
         loss(:,:,10) = (rxt(:,:,97)* y(:,:,3) + rxt(:,:,43) + het_rates(:,:,118)) &
                 * y(:,:,118)
         prod(:,:,10) = 0._r8
         loss(:,:,11) = (rxt(:,:,98)* y(:,:,3) +rxt(:,:,203)* y(:,:,20) + rxt(:,:,41) &
                  + het_rates(:,:,110))* y(:,:,110)
         prod(:,:,11) = 0._r8
         loss(:,:,12) = (rxt(:,:,99)* y(:,:,3) +rxt(:,:,206)* y(:,:,20) + rxt(:,:,44) &
                  + het_rates(:,:,115))* y(:,:,115)
         prod(:,:,12) = 0._r8
         loss(:,:,13) = (rxt(:,:,100)* y(:,:,3) +rxt(:,:,207)* y(:,:,20) + rxt(:,:,45) &
                  + het_rates(:,:,116))* y(:,:,116)
         prod(:,:,13) = 0._r8
         loss(:,:,14) = (rxt(:,:,101)* y(:,:,3) + rxt(:,:,36) + het_rates(:,:,111)) &
                 * y(:,:,111)
         prod(:,:,14) = 0._r8
         loss(:,:,15) = (rxt(:,:,202)* y(:,:,20) + rxt(:,:,37) + het_rates(:,:,112)) &
                 * y(:,:,112)
         prod(:,:,15) = 0._r8
         loss(:,:,16) = (rxt(:,:,104)* y(:,:,3) + rxt(:,:,47) + het_rates(:,:,113)) &
                 * y(:,:,113)
         prod(:,:,16) = 0._r8
         loss(:,:,17) = (rxt(:,:,103)* y(:,:,3) + rxt(:,:,50) + het_rates(:,:,114)) &
                 * y(:,:,114)
         prod(:,:,17) = 0._r8
         loss(:,:,18) = (rxt(:,:,105)* y(:,:,3) + rxt(:,:,48) + het_rates(:,:,119)) &
                 * y(:,:,119)
         prod(:,:,18) = 0._r8
         loss(:,:,19) = (rxt(:,:,106)* y(:,:,3) + rxt(:,:,49) + het_rates(:,:,120)) &
                 * y(:,:,120)
         prod(:,:,19) = 0._r8
         loss(:,:,20) = (rxt(:,:,107)* y(:,:,3) +rxt(:,:,209)* y(:,:,20) +rxt(:,:,211) &
                 * y(:,:,25) + rxt(:,:,51) + het_rates(:,:,121))* y(:,:,121)
         prod(:,:,20) = 0._r8
         loss(:,:,21) = (rxt(:,:,108)* y(:,:,3) +rxt(:,:,208)* y(:,:,20) +rxt(:,:,210) &
                 * y(:,:,25) + rxt(:,:,52) + het_rates(:,:,122))* y(:,:,122)
         prod(:,:,21) = 0._r8
         loss(:,:,22) = ( + rxt(:,:,53) + het_rates(:,:,123))* y(:,:,123)
         prod(:,:,22) =.440_r8*rxt(:,:,55)*y(:,:,12)
         loss(:,:,23) = ( + het_rates(:,:,23))* y(:,:,23)
         prod(:,:,23) = 0._r8
         loss(:,:,24) = ( + het_rates(:,:,24))* y(:,:,24)
         prod(:,:,24) = 0._r8
         loss(:,:,25) = ( + rxt(:,:,347) + het_rates(:,:,163))* y(:,:,163)
         prod(:,:,25) = 0._r8
         loss(:,:,26) = ( + het_rates(:,:,164))* y(:,:,164)
         prod(:,:,26) =rxt(:,:,347)*y(:,:,163)
         loss(:,:,27) = ( + rxt(:,:,403) + het_rates(:,:,169))* y(:,:,169)
         prod(:,:,27) = 0._r8
         loss(:,:,28) = ( + rxt(:,:,404) + het_rates(:,:,170))* y(:,:,170)
         prod(:,:,28) = 0._r8
         loss(:,:,29) = ( + rxt(:,:,405) + het_rates(:,:,171))* y(:,:,171)
         prod(:,:,29) = 0._r8

      end subroutine exp_prod_loss

      subroutine imp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:)
      real(r8), intent(in) :: rxt(:)
      real(r8), intent(in) :: het_rates(:)



!--------------------------------------------------------------------
! ... loss and production for Implicit method
!--------------------------------------------------------------------


         loss(131) = (rxt(85)* y(2) +rxt(92)* y(3) +rxt(142)* y(6) +rxt(145)* y(7) &
                  +rxt(117)* y(19) +rxt(122)* y(20) +rxt(130)* y(21) +rxt(157)* y(25) &
                  +rxt(184)* y(34) +rxt(237)* y(41) +rxt(258)* y(56) +rxt(280)* y(74) &
                  +rxt(286)* y(75) +rxt(304)* y(80) +rxt(342)* y(102) + rxt(2) &
                  + rxt(3) + het_rates(1))* y(1)
         prod(131) = (.200_r8*rxt(280)*y(74) +.200_r8*rxt(286)*y(75) + &
                 .100_r8*rxt(304)*y(80))*y(1) + (.250_r8*rxt(248)*y(45) + &
                 .250_r8*rxt(296)*y(73))*y(21) +rxt(84)*y(2)
         loss(141) = (rxt(85)* y(1) + 2._r8*rxt(86)* y(2) +rxt(140)* y(6) &
                  + (rxt(143) +rxt(144))* y(7) +rxt(151)* y(8) +rxt(217)* y(16) &
                  +rxt(128)* y(18) +rxt(121)* y(20) +rxt(129)* y(21) +rxt(132)* y(22) &
                  +rxt(164)* y(27) +rxt(177)* y(30) +rxt(178)* y(31) +rxt(181)* y(32) &
                  +rxt(187)* y(35) +rxt(197)* y(36) +rxt(198)* y(37) +rxt(199)* y(38) &
                  + rxt(84) + het_rates(2))* y(2)
         prod(141) = (rxt(135) +rxt(136)*y(6) +rxt(137)*y(7))*y(5) + (rxt(87) + &
                 rxt(88))*y(3) +rxt(3)*y(1) +rxt(5)*y(6) +rxt(6)*y(7) +rxt(10)*y(8) &
                  +rxt(8)*y(11) +rxt(120)*y(21)*y(19) +rxt(124)*y(20)*y(20) +rxt(22) &
                 *y(27) +rxt(23)*y(28) +rxt(30)*y(35) +rxt(19)*y(124)
         loss(134) = (rxt(92)* y(1) + (rxt(90) +rxt(91))* y(4) + (rxt(109) +rxt(110) + &
                 rxt(111))* y(12) +rxt(112)* y(18) +rxt(113)* y(30) +rxt(114)* y(36) &
                  +rxt(115)* y(39) +rxt(102)* y(106) +rxt(93)* y(107) +rxt(94)* y(108) &
                  +rxt(95)* y(109) +rxt(98)* y(110) +rxt(101)* y(111) +rxt(104) &
                 * y(113) +rxt(103)* y(114) +rxt(99)* y(115) +rxt(100)* y(116) &
                  +rxt(96)* y(117) +rxt(97)* y(118) +rxt(105)* y(119) +rxt(106) &
                 * y(120) +rxt(107)* y(121) +rxt(108)* y(122) +rxt(89)* y(124) &
                  + rxt(87) + rxt(88) + het_rates(3))* y(3)
         prod(134) =rxt(2)*y(1) +rxt(18)*y(124)
         loss(113) = (rxt(128)* y(2) +rxt(112)* y(3) +rxt(126)* y(20) +rxt(158)* y(25) &
                  + het_rates(18))* y(18)
         prod(113) =rxt(111)*y(12)*y(3) +rxt(16)*y(16) +rxt(119)*y(21)*y(19) +rxt(18) &
                 *y(124)
         loss(114) = ((rxt(213) +rxt(214))* y(20) + het_rates(17))* y(17)
         prod(114) = (rxt(15) +rxt(16) +rxt(162)*y(25) +rxt(186)*y(34) + &
                 rxt(215)*y(8) +rxt(216)*y(20) +rxt(217)*y(2))*y(16) &
                  + (.500_r8*rxt(237)*y(41) +.560_r8*rxt(258)*y(56) + &
                 .050_r8*rxt(280)*y(74) +.200_r8*rxt(286)*y(75) + &
                 .300_r8*rxt(304)*y(80))*y(1) + (.220_r8*rxt(287)*y(6) + &
                 .220_r8*rxt(289)*y(8) +.110_r8*rxt(291)*y(13) + &
                 .220_r8*rxt(292)*y(45))*y(76) + (.500_r8*rxt(322)*y(6) + &
                 .500_r8*rxt(323)*y(8) +.200_r8*rxt(325)*y(13) + &
                 .500_r8*rxt(326)*y(45))*y(88) + (.350_r8*rxt(230)*y(125) + &
                 rxt(253)*y(50) +rxt(274)*y(65))*y(20) + (rxt(69) +rxt(275)*y(8)) &
                 *y(65) +rxt(200)*y(105)*y(25) +rxt(56)*y(47) +rxt(74)*y(49) &
                  +2.000_r8*rxt(77)*y(50) +.700_r8*rxt(63)*y(74) +1.340_r8*rxt(62) &
                 *y(75) +.450_r8*rxt(76)*y(83) +rxt(71)*y(87)
         loss(54) = (rxt(136)* y(6) + (rxt(137) +rxt(138) +rxt(139))* y(7) + rxt(135) &
                  + het_rates(5))* y(5)
         prod(54) =rxt(5)*y(6)
         loss(135) = (rxt(142)* y(1) +rxt(140)* y(2) +rxt(136)* y(5) +rxt(150)* y(8) &
                  +rxt(219)* y(13) +rxt(141)* y(21) +rxt(169)* y(27) +rxt(190)* y(35) &
                  +rxt(239)* y(43) +rxt(246)* y(45) +rxt(233)* y(52) +rxt(260)* y(58) &
                  +rxt(265)* y(61) +rxt(269)* y(64) +rxt(278)* y(70) +rxt(282)* y(71) &
                  +rxt(294)* y(73) + (rxt(287) +rxt(288))* y(76) +rxt(319)* y(81) &
                  +rxt(306)* y(85) +rxt(312)* y(86) +rxt(322)* y(88) +rxt(330)* y(93) &
                  +rxt(337)* y(97) +rxt(340)* y(100) +rxt(344)* y(103) +rxt(227) &
                 * y(127) + rxt(5) + het_rates(6))* y(6)
         prod(135) = (rxt(6) +.500_r8*rxt(350) +2.000_r8*rxt(138)*y(5) +rxt(143)*y(2)) &
                 *y(7) +2.000_r8*rxt(90)*y(4)*y(3) +rxt(135)*y(5) +rxt(11)*y(8) &
                  +rxt(8)*y(11)
         loss(137) = (rxt(145)* y(1) + (rxt(143) +rxt(144))* y(2) + (rxt(137) + &
                 rxt(138) +rxt(139))* y(5) +rxt(146)* y(8) +rxt(148)* y(20) +rxt(154) &
                 * y(21) +rxt(170)* y(27) +rxt(191)* y(35) +rxt(247)* y(45) +rxt(300) &
                 * y(73) +rxt(334)* y(95) + rxt(6) + rxt(350) + het_rates(7))* y(7)
         prod(137) = (rxt(140)*y(2) +rxt(141)*y(21) +rxt(142)*y(1) + &
                 2.000_r8*rxt(150)*y(8) +rxt(169)*y(27) +rxt(190)*y(35) + &
                 rxt(219)*y(13) +rxt(227)*y(127) +rxt(233)*y(52) +rxt(239)*y(43) + &
                 rxt(246)*y(45) +rxt(260)*y(58) +rxt(265)*y(61) +rxt(269)*y(64) + &
                 rxt(278)*y(70) +rxt(282)*y(71) +rxt(287)*y(76) +rxt(294)*y(73) + &
                 .920_r8*rxt(306)*y(85) +1.206_r8*rxt(312)*y(86) + &
                 .900_r8*rxt(319)*y(81) +rxt(322)*y(88) +.900_r8*rxt(330)*y(93) + &
                 .900_r8*rxt(337)*y(97) +.900_r8*rxt(340)*y(100) +rxt(344)*y(103)) &
                 *y(6) + (rxt(10) +rxt(151)*y(2) +rxt(152)*y(20) +rxt(153)*y(21) + &
                 rxt(289)*y(76) +rxt(295)*y(73) +rxt(307)*y(85) + &
                 1.206_r8*rxt(313)*y(86) +rxt(317)*y(87) +rxt(323)*y(88) + &
                 rxt(343)*y(102))*y(8) + (rxt(13) +rxt(156) +rxt(155)*y(20))*y(10) &
                  + (rxt(7) +rxt(147))*y(11) + (rxt(276)*y(79) + &
                 .400_r8*rxt(316)*y(87))*y(20) + (.600_r8*rxt(59) +rxt(255))*y(55) &
                  + (rxt(60) +rxt(301))*y(78) +.700_r8*rxt(334)*y(95)*y(7) +rxt(9) &
                 *y(9) +.206_r8*rxt(314)*y(86)*y(21) +rxt(28)*y(32) +rxt(34)*y(38) &
                  +rxt(71)*y(87)
         loss(142) = (rxt(122)* y(1) +rxt(121)* y(2) +rxt(148)* y(7) +rxt(152)* y(8) &
                  +rxt(149)* y(9) +rxt(155)* y(10) +rxt(212)* y(12) +rxt(224)* y(14) &
                  +rxt(223)* y(15) +rxt(216)* y(16) + (rxt(213) +rxt(214))* y(17) &
                  +rxt(126)* y(18) + 2._r8*(rxt(124) +rxt(125))* y(20) +rxt(123) &
                 * y(21) +rxt(127)* y(22) + (rxt(165) +rxt(166))* y(27) +rxt(176) &
                 * y(30) +rxt(180)* y(31) +rxt(182)* y(32) +rxt(188)* y(35) +rxt(196) &
                 * y(36) +rxt(133)* y(39) +rxt(134)* y(40) +rxt(232)* y(41) +rxt(231) &
                 * y(42) +rxt(243)* y(44) +rxt(238)* y(46) +rxt(244)* y(47) +rxt(254) &
                 * y(48) +rxt(252)* y(49) +rxt(253)* y(50) +rxt(251)* y(51) +rxt(256) &
                 * y(55) +rxt(257)* y(56) +rxt(264)* y(57) +rxt(263)* y(59) +rxt(268) &
                 * y(60) +rxt(267)* y(62) +rxt(273)* y(63) +rxt(274)* y(65) +rxt(272) &
                 * y(66) +rxt(277)* y(67) +rxt(315)* y(68) +rxt(281)* y(69) +rxt(284) &
                 * y(72) +rxt(279)* y(74) +rxt(285)* y(75) +rxt(293)* y(77) +rxt(302) &
                 * y(78) +rxt(276)* y(79) +rxt(303)* y(80) +rxt(321)* y(82) +rxt(318) &
                 * y(84) +rxt(316)* y(87) +rxt(327)* y(89) +rxt(309)* y(90) +rxt(329) &
                 * y(91) +rxt(333)* y(92) +rxt(332)* y(94) +rxt(335)* y(96) +rxt(338) &
                 * y(99) +rxt(341)* y(102) +rxt(346)* y(104) +rxt(201)* y(105) &
                  +rxt(204)* y(106) +rxt(203)* y(110) +rxt(202)* y(112) +rxt(206) &
                 * y(115) +rxt(207)* y(116) +rxt(209)* y(121) +rxt(208)* y(122) &
                  +rxt(230)* y(125) +rxt(225)* y(126) +rxt(352)* y(142) + (rxt(353) + &
                 rxt(354))* y(143) +rxt(356)* y(145) + het_rates(20))* y(20)
         prod(142) = (rxt(117)*y(19) +rxt(130)*y(21) +.120_r8*rxt(237)*y(41) + &
                 .330_r8*rxt(258)*y(56) +.080_r8*rxt(280)*y(74) + &
                 .215_r8*rxt(286)*y(75) +.270_r8*rxt(304)*y(80) + &
                 .700_r8*rxt(342)*y(102))*y(1) + (rxt(128)*y(18) +rxt(129)*y(21) + &
                 rxt(132)*y(22) +rxt(177)*y(30) +rxt(178)*y(31) +rxt(197)*y(36) + &
                 rxt(198)*y(37) +rxt(217)*y(16))*y(2) + (rxt(109)*y(12) + &
                 2.000_r8*rxt(89)*y(124) +rxt(112)*y(18) +rxt(113)*y(30) + &
                 rxt(114)*y(36) +rxt(115)*y(39))*y(3) + (.300_r8*rxt(224)*y(14) + &
                 .650_r8*rxt(230)*y(125) +.500_r8*rxt(243)*y(44) + &
                 .500_r8*rxt(267)*y(62) +.100_r8*rxt(293)*y(77))*y(20) &
                  + (2.000_r8*rxt(118)*y(19) +rxt(141)*y(6) +rxt(153)*y(8) + &
                 rxt(161)*y(25))*y(21) +.500_r8*rxt(350)*y(7) +rxt(9)*y(9) +rxt(12) &
                 *y(10) +rxt(14)*y(14) +2.000_r8*rxt(20)*y(22) +rxt(25)*y(31) +rxt(31) &
                 *y(37) +rxt(64)*y(44) +rxt(58)*y(51) +rxt(65)*y(54) +rxt(66)*y(59) &
                  +rxt(57)*y(62) +rxt(67)*y(66) +rxt(79)*y(72) +rxt(78)*y(82) +rxt(70) &
                 *y(89) +rxt(80)*y(94) +rxt(81)*y(104) +rxt(17)*y(124)
         loss(132) = (rxt(151)* y(2) +rxt(150)* y(6) +rxt(146)* y(7) +rxt(215)* y(16) &
                  +rxt(152)* y(20) +rxt(153)* y(21) +rxt(245)* y(47) +rxt(259)* y(56) &
                  +rxt(275)* y(65) +rxt(295)* y(73) +rxt(289)* y(76) +rxt(305)* y(80) &
                  +rxt(307)* y(85) +rxt(313)* y(86) +rxt(317)* y(87) +rxt(323)* y(88) &
                  +rxt(343)* y(102) +rxt(355)* y(143) + rxt(10) + rxt(11) + rxt(349) &
                  + het_rates(8))* y(8)
         prod(132) = (rxt(149)*y(9) +rxt(182)*y(32) +rxt(256)*y(55) + &
                 .500_r8*rxt(302)*y(78))*y(20) + (rxt(144)*y(7) +rxt(181)*y(32) + &
                 rxt(199)*y(38))*y(2) + (rxt(7) +rxt(8) +rxt(147))*y(11) + (rxt(27) + &
                 rxt(183)*y(25))*y(32) +rxt(145)*y(7)*y(1) +rxt(12)*y(10) +rxt(33) &
                 *y(38) +.400_r8*rxt(59)*y(55)
         loss(105) = (rxt(149)* y(20) + rxt(9) + het_rates(9))* y(9)
         prod(105) = (rxt(381) +rxt(387) +rxt(392) +rxt(383)*y(30) +rxt(388)*y(30) + &
                 rxt(394)*y(30))*y(32) + (rxt(349) +rxt(215)*y(16) +rxt(245)*y(47) + &
                 rxt(275)*y(65) +rxt(355)*y(143))*y(8) + (2.000_r8*rxt(348) + &
                 2.000_r8*rxt(380) +2.000_r8*rxt(386) +2.000_r8*rxt(391))*y(11) &
                  + (rxt(382) +rxt(390) +rxt(393))*y(38) + (.500_r8*rxt(350) + &
                 rxt(148)*y(20))*y(7)
         loss(74) = (rxt(155)* y(20) + rxt(12) + rxt(13) + rxt(156) + het_rates(10)) &
                 * y(10)
         prod(74) =rxt(154)*y(21)*y(7)
         loss(61) = ( + rxt(7) + rxt(8) + rxt(147) + rxt(348) + rxt(380) + rxt(386) &
                  + rxt(391) + het_rates(11))* y(11)
         prod(61) =rxt(146)*y(8)*y(7)
         loss(128) = (rxt(219)* y(6) + 2._r8*(rxt(221) +rxt(222))* y(13) +rxt(220) &
                 * y(21) +rxt(168)* y(27) +rxt(241)* y(43) +rxt(249)* y(45) +rxt(262) &
                 * y(58) +rxt(271)* y(64) +rxt(297)* y(73) +rxt(291)* y(76) +rxt(310) &
                 * y(85) +rxt(325)* y(88) + het_rates(13))* y(13)
         prod(128) = (rxt(246)*y(6) +.900_r8*rxt(249)*y(13) +2.000_r8*rxt(250)*y(45) + &
                 rxt(292)*y(76) +rxt(298)*y(73) +rxt(311)*y(85) +rxt(326)*y(88))*y(45) &
                  + (rxt(109)*y(3) +rxt(163)*y(25) +rxt(212)*y(20))*y(12) &
                  + (.700_r8*rxt(224)*y(14) +rxt(238)*y(46))*y(20) &
                  +.310_r8*rxt(258)*y(56)*y(1) +rxt(56)*y(47) +rxt(58)*y(51) &
                  +.400_r8*rxt(59)*y(55) +rxt(68)*y(60) +.300_r8*rxt(63)*y(74)
         loss(76) = (rxt(224)* y(20) + rxt(14) + het_rates(14))* y(14)
         prod(76) =rxt(220)*y(21)*y(13)
         loss(55) = (rxt(115)* y(3) +rxt(133)* y(20) + het_rates(39))* y(39)
         prod(55) = 0._r8
         loss(43) = (rxt(134)* y(20) + het_rates(40))* y(40)
         prod(43) = 0._r8
         loss(140) = (rxt(217)* y(2) +rxt(215)* y(8) +rxt(216)* y(20) +rxt(218)* y(21) &
                  +rxt(162)* y(25) +rxt(186)* y(34) + rxt(15) + rxt(16) &
                  + het_rates(16))* y(16)
         prod(140) = (rxt(168)*y(27) +rxt(219)*y(6) +2.000_r8*rxt(221)*y(13) + &
                 rxt(222)*y(13) +.700_r8*rxt(241)*y(43) +rxt(249)*y(45) + &
                 rxt(262)*y(58) +.800_r8*rxt(271)*y(64) +.880_r8*rxt(291)*y(76) + &
                 2.000_r8*rxt(297)*y(73) +1.200_r8*rxt(310)*y(85) + &
                 .700_r8*rxt(325)*y(88))*y(13) + (.500_r8*rxt(233)*y(52) + &
                 rxt(265)*y(61) +rxt(269)*y(64) +.500_r8*rxt(278)*y(70) + &
                 .250_r8*rxt(287)*y(76) +rxt(294)*y(73) +.510_r8*rxt(306)*y(85) + &
                 .072_r8*rxt(312)*y(86) +.100_r8*rxt(319)*y(81))*y(6) &
                  + (rxt(223)*y(15) +.300_r8*rxt(224)*y(14) +.500_r8*rxt(251)*y(51) + &
                 .800_r8*rxt(252)*y(49) +rxt(256)*y(55) +.500_r8*rxt(302)*y(78))*y(20) &
                  + (rxt(237)*y(41) +.540_r8*rxt(258)*y(56) +.800_r8*rxt(280)*y(74) + &
                 .700_r8*rxt(286)*y(75) +.600_r8*rxt(304)*y(80))*y(1) &
                  + (.250_r8*rxt(289)*y(76) +rxt(295)*y(73) +.600_r8*rxt(307)*y(85) + &
                 .072_r8*rxt(313)*y(86))*y(8) + (.250_r8*rxt(292)*y(76) + &
                 rxt(298)*y(73) +.600_r8*rxt(311)*y(85))*y(45) + (rxt(110)*y(12) + &
                 rxt(111)*y(12))*y(3) +rxt(14)*y(14) +.008_r8*rxt(314)*y(86)*y(21) &
                  +rxt(74)*y(49) +2.000_r8*rxt(236)*y(53) +rxt(57)*y(62) +rxt(73) &
                 *y(63) +rxt(67)*y(66) +2.000_r8*rxt(299)*y(73)*y(73) &
                  +1.340_r8*rxt(61)*y(75) +.100_r8*rxt(78)*y(82) +rxt(71)*y(87) &
                  +.690_r8*rxt(72)*y(90) +rxt(226)*y(127)
         loss(127) = (rxt(117)* y(1) + (rxt(118) +rxt(119) +rxt(120))* y(21) &
                  + rxt(116) + het_rates(19))* y(19)
         prod(127) = (rxt(112)*y(3) +rxt(126)*y(20) +rxt(128)*y(2) +rxt(158)*y(25)) &
                 *y(18) + (rxt(121)*y(2) +rxt(213)*y(17) +rxt(216)*y(16))*y(20) &
                  + (rxt(17) +2.000_r8*rxt(19))*y(124) +rxt(110)*y(12)*y(3) +rxt(14) &
                 *y(14) +2.000_r8*rxt(15)*y(16) +rxt(26)*y(30) +rxt(32)*y(36)
         loss(139) = (rxt(130)* y(1) +rxt(129)* y(2) +rxt(141)* y(6) +rxt(154)* y(7) &
                  +rxt(153)* y(8) +rxt(220)* y(13) +rxt(218)* y(16) + (rxt(118) + &
                 rxt(119) +rxt(120))* y(19) +rxt(123)* y(20) + 2._r8*rxt(131)* y(21) &
                  + (rxt(160) +rxt(161))* y(25) +rxt(167)* y(27) +rxt(185)* y(34) &
                  +rxt(189)* y(35) +rxt(240)* y(43) +rxt(248)* y(45) +rxt(234)* y(52) &
                  +rxt(261)* y(58) +rxt(266)* y(61) +rxt(270)* y(64) +rxt(283)* y(71) &
                  +rxt(296)* y(73) +rxt(290)* y(76) +rxt(320)* y(81) +rxt(308)* y(85) &
                  +rxt(314)* y(86) +rxt(324)* y(88) +rxt(331)* y(93) +rxt(336)* y(97) &
                  +rxt(339)* y(100) +rxt(345)* y(103) +rxt(228)* y(127) + rxt(358) &
                  + het_rates(21))* y(21)
         prod(139) = (rxt(201)*y(105) +rxt(204)*y(106) +rxt(122)*y(1) + &
                 rxt(127)*y(22) +rxt(133)*y(39) +rxt(134)*y(40) +rxt(152)*y(8) + &
                 rxt(165)*y(27) +rxt(188)*y(35) +rxt(214)*y(17) +rxt(223)*y(15) + &
                 rxt(225)*y(126) +.350_r8*rxt(230)*y(125) +rxt(252)*y(49) + &
                 rxt(253)*y(50) +rxt(254)*y(48) +rxt(273)*y(63) + &
                 .200_r8*rxt(293)*y(77) +.500_r8*rxt(302)*y(78) +rxt(316)*y(87) + &
                 .250_r8*rxt(329)*y(91) +.500_r8*rxt(354)*y(143))*y(20) &
                  + (rxt(219)*y(13) +rxt(227)*y(127) +.250_r8*rxt(233)*y(52) + &
                 rxt(239)*y(43) +rxt(260)*y(58) +rxt(265)*y(61) +rxt(278)*y(70) + &
                 .470_r8*rxt(287)*y(76) +rxt(306)*y(85) +.794_r8*rxt(312)*y(86) + &
                 .900_r8*rxt(319)*y(81) +rxt(322)*y(88) +.900_r8*rxt(330)*y(93) + &
                 .900_r8*rxt(337)*y(97) +.900_r8*rxt(340)*y(100) +rxt(344)*y(103)) &
                 *y(6) + (rxt(168)*y(27) +2.000_r8*rxt(221)*y(13) +rxt(241)*y(43) + &
                 .900_r8*rxt(249)*y(45) +rxt(262)*y(58) +.300_r8*rxt(271)*y(64) + &
                 .730_r8*rxt(291)*y(76) +rxt(297)*y(73) +rxt(310)*y(85) + &
                 .800_r8*rxt(325)*y(88))*y(13) + (.120_r8*rxt(237)*y(41) + &
                 .190_r8*rxt(258)*y(56) +.060_r8*rxt(280)*y(74) + &
                 .275_r8*rxt(286)*y(75) +.060_r8*rxt(304)*y(80) +rxt(342)*y(102))*y(1) &
                  + (rxt(215)*y(16) +.470_r8*rxt(289)*y(76) +rxt(307)*y(85) + &
                 .794_r8*rxt(313)*y(86) +rxt(317)*y(87) +rxt(323)*y(88))*y(8) &
                  + (rxt(200)*y(105) +rxt(205)*y(106) +rxt(159)*y(22) +rxt(162)*y(16)) &
                 *y(25) + (.470_r8*rxt(292)*y(76) +rxt(311)*y(85) +rxt(326)*y(88)) &
                 *y(45) + (rxt(132)*y(22) +rxt(217)*y(16))*y(2) + (rxt(13) +rxt(156)) &
                 *y(10) + (rxt(235) +rxt(236))*y(53) + (1.340_r8*rxt(61) + &
                 .660_r8*rxt(62))*y(75) +rxt(110)*y(12)*y(3) +.700_r8*rxt(334)*y(95) &
                 *y(7) +rxt(186)*y(34)*y(16) +rxt(116)*y(19) +.794_r8*rxt(314)*y(86) &
                 *y(21) +1.200_r8*rxt(242)*y(43)*y(43) +rxt(64)*y(44) +rxt(56)*y(47) &
                  +2.000_r8*rxt(74)*y(49) +2.000_r8*rxt(77)*y(50) +rxt(66)*y(59) &
                  +rxt(57)*y(62) +rxt(73)*y(63) +rxt(69)*y(65) +.900_r8*rxt(78)*y(82) &
                  +.560_r8*rxt(76)*y(83) +rxt(71)*y(87) +rxt(72)*y(90) +rxt(81)*y(104) &
                  +rxt(226)*y(127)
         loss(93) = (rxt(132)* y(2) +rxt(127)* y(20) +rxt(159)* y(25) + rxt(20) &
                  + het_rates(22))* y(22)
         prod(93) = (.500_r8*rxt(358) +rxt(131)*y(21))*y(21) +rxt(125)*y(20)*y(20)
         loss(126) = (rxt(89)* y(3) + rxt(17) + rxt(18) + rxt(19) + het_rates(124)) &
                 * y(124)
         prod(126) = (rxt(201)*y(105) +rxt(202)*y(112) +rxt(203)*y(110) + &
                 rxt(204)*y(106) +rxt(208)*y(122) +rxt(212)*y(12) +rxt(123)*y(21) + &
                 rxt(124)*y(20) +rxt(126)*y(18) +rxt(127)*y(22) +rxt(149)*y(9) + &
                 rxt(155)*y(10) +rxt(176)*y(30) +rxt(180)*y(31) +rxt(196)*y(36) + &
                 rxt(216)*y(16) +rxt(224)*y(14) +rxt(225)*y(126) +rxt(231)*y(42) + &
                 rxt(238)*y(46) +rxt(244)*y(47) +rxt(251)*y(51) +rxt(263)*y(59) + &
                 rxt(264)*y(57) +rxt(267)*y(62) +rxt(268)*y(60) +rxt(272)*y(66) + &
                 rxt(274)*y(65) +.500_r8*rxt(285)*y(75) +rxt(327)*y(89) + &
                 rxt(328)*y(89) +rxt(356)*y(145))*y(20) + (rxt(384)*y(31) + &
                 rxt(385)*y(37) +rxt(389)*y(31) +rxt(395)*y(31) +rxt(396)*y(37))*y(30) &
                  +rxt(120)*y(21)*y(19)
         loss(136) = (rxt(157)* y(1) +rxt(163)* y(12) +rxt(162)* y(16) +rxt(158) &
                 * y(18) + (rxt(160) +rxt(161))* y(21) +rxt(159)* y(22) +rxt(179) &
                 * y(31) +rxt(183)* y(32) +rxt(229)* y(42) +rxt(200)* y(105) +rxt(205) &
                 * y(106) +rxt(211)* y(121) +rxt(210)* y(122) + het_rates(25))* y(25)
         prod(136) = (3.000_r8*rxt(93)*y(107) +2.000_r8*rxt(94)*y(108) + &
                 3.000_r8*rxt(95)*y(109) +2.000_r8*rxt(96)*y(117) +rxt(97)*y(118) + &
                 rxt(98)*y(110) +2.000_r8*rxt(99)*y(115) +rxt(100)*y(116) + &
                 4.000_r8*rxt(101)*y(111) +rxt(103)*y(114) +rxt(113)*y(30))*y(3) &
                  + (rxt(22) +rxt(164)*y(2) +rxt(165)*y(20) +rxt(168)*y(13) + &
                 rxt(169)*y(6) +2.000_r8*rxt(171)*y(27) +rxt(173)*y(27) + &
                 rxt(193)*y(35))*y(27) + (rxt(201)*y(105) +3.000_r8*rxt(202)*y(112) + &
                 rxt(203)*y(110) +2.000_r8*rxt(206)*y(115) +rxt(207)*y(116) + &
                 rxt(176)*y(30))*y(20) + (rxt(26) +rxt(177)*y(2))*y(30) &
                  +2.000_r8*rxt(21)*y(26) +2.000_r8*rxt(24)*y(29) +rxt(25)*y(31) &
                  +rxt(27)*y(32) +rxt(29)*y(33)
         loss(52) = ( + rxt(21) + het_rates(26))* y(26)
         prod(52) = (rxt(383)*y(32) +rxt(384)*y(31) +rxt(388)*y(32) +rxt(389)*y(31) + &
                 rxt(394)*y(32) +rxt(395)*y(31))*y(30) +rxt(183)*y(32)*y(25) &
                  +rxt(172)*y(27)*y(27)
         loss(130) = (rxt(164)* y(2) +rxt(169)* y(6) +rxt(170)* y(7) +rxt(168)* y(13) &
                  + (rxt(165) +rxt(166))* y(20) +rxt(167)* y(21) + 2._r8*(rxt(171) + &
                 rxt(172) +rxt(173) +rxt(174))* y(27) + (rxt(192) +rxt(193) +rxt(194)) &
                 * y(35) + rxt(22) + het_rates(27))* y(27)
         prod(130) = (rxt(157)*y(1) +rxt(161)*y(21) +rxt(179)*y(31))*y(25) &
                  + (rxt(178)*y(31) +rxt(181)*y(32))*y(2) +rxt(180)*y(31)*y(20) &
                  +rxt(23)*y(28) +2.000_r8*rxt(175)*y(29) +rxt(28)*y(32)
         loss(50) = ( + rxt(23) + het_rates(28))* y(28)
         prod(50) = (rxt(173)*y(27) +rxt(192)*y(35))*y(27)
         loss(44) = ( + rxt(24) + rxt(175) + het_rates(29))* y(29)
         prod(44) =rxt(174)*y(27)*y(27)
         loss(133) = (rxt(177)* y(2) +rxt(113)* y(3) +rxt(176)* y(20) + (rxt(384) + &
                 rxt(389) +rxt(395))* y(31) + (rxt(383) +rxt(388) +rxt(394))* y(32) &
                  + (rxt(385) +rxt(396))* y(37) + rxt(26) + het_rates(30))* y(30)
         prod(133) = (rxt(163)*y(12) +2.000_r8*rxt(200)*y(105) +rxt(205)*y(106) + &
                 rxt(210)*y(122) +rxt(211)*y(121) +rxt(158)*y(18) +rxt(159)*y(22) + &
                 rxt(160)*y(21) +rxt(162)*y(16) +rxt(179)*y(31) +rxt(229)*y(42))*y(25) &
                  +rxt(166)*y(27)*y(20)
         loss(107) = (rxt(178)* y(2) +rxt(180)* y(20) +rxt(179)* y(25) + (rxt(384) + &
                 rxt(389) +rxt(395))* y(30) + rxt(25) + het_rates(31))* y(31)
         prod(107) = (rxt(381) +rxt(387) +rxt(392) +rxt(182)*y(20))*y(32) &
                  +rxt(167)*y(27)*y(21)
         loss(108) = (rxt(181)* y(2) +rxt(182)* y(20) +rxt(183)* y(25) + (rxt(383) + &
                 rxt(388) +rxt(394))* y(30) + rxt(27) + rxt(28) + rxt(381) + rxt(387) &
                  + rxt(392) + het_rates(32))* y(32)
         prod(108) =rxt(170)*y(27)*y(7)
         loss(57) = ( + rxt(29) + het_rates(33))* y(33)
         prod(57) = (rxt(385)*y(37) +rxt(396)*y(37))*y(30) +rxt(194)*y(35)*y(27)
         loss(129) = (rxt(184)* y(1) +rxt(186)* y(16) +rxt(185)* y(21) &
                  + het_rates(34))* y(34)
         prod(129) = (rxt(102)*y(106) +rxt(103)*y(114) +rxt(104)*y(113) + &
                 2.000_r8*rxt(105)*y(119) +2.000_r8*rxt(106)*y(120) + &
                 3.000_r8*rxt(107)*y(121) +2.000_r8*rxt(108)*y(122) +rxt(114)*y(36)) &
                 *y(3) + (rxt(30) +rxt(187)*y(2) +rxt(188)*y(20) +rxt(190)*y(6) + &
                 rxt(192)*y(27) +rxt(193)*y(27) +2.000_r8*rxt(195)*y(35))*y(35) &
                  + (rxt(204)*y(106) +2.000_r8*rxt(208)*y(122) + &
                 3.000_r8*rxt(209)*y(121) +rxt(196)*y(36))*y(20) + (rxt(205)*y(106) + &
                 2.000_r8*rxt(210)*y(122) +3.000_r8*rxt(211)*y(121))*y(25) &
                  + (rxt(32) +rxt(197)*y(2))*y(36) +rxt(29)*y(33) +rxt(31)*y(37) &
                  +rxt(33)*y(38)
         loss(138) = (rxt(187)* y(2) +rxt(190)* y(6) +rxt(191)* y(7) +rxt(188)* y(20) &
                  +rxt(189)* y(21) + (rxt(192) +rxt(193) +rxt(194))* y(27) &
                  + 2._r8*rxt(195)* y(35) + rxt(30) + het_rates(35))* y(35)
         prod(138) = (rxt(198)*y(37) +rxt(199)*y(38))*y(2) +rxt(184)*y(34)*y(1) &
                  +rxt(34)*y(38)
         loss(102) = (rxt(197)* y(2) +rxt(114)* y(3) +rxt(196)* y(20) + rxt(32) &
                  + het_rates(36))* y(36)
         prod(102) = (rxt(185)*y(21) +rxt(186)*y(16))*y(34)
         loss(101) = (rxt(198)* y(2) + (rxt(385) +rxt(396))* y(30) + rxt(31) &
                  + het_rates(37))* y(37)
         prod(101) = (rxt(382) +rxt(390) +rxt(393))*y(38) +rxt(189)*y(35)*y(21)
         loss(89) = (rxt(199)* y(2) + rxt(33) + rxt(34) + rxt(382) + rxt(390) &
                  + rxt(393) + het_rates(38))* y(38)
         prod(89) =rxt(191)*y(35)*y(7)
         loss(111) = (rxt(258)* y(1) +rxt(259)* y(8) +rxt(257)* y(20) + het_rates(56)) &
                 * y(56)
         prod(111) =.070_r8*rxt(304)*y(80)*y(1) +.700_r8*rxt(63)*y(74)
         loss(106) = (rxt(304)* y(1) +rxt(305)* y(8) +rxt(303)* y(20) + het_rates(80)) &
                 * y(80)
         prod(106) = 0._r8
         loss(99) = (rxt(265)* y(6) +rxt(266)* y(21) + het_rates(61))* y(61)
         prod(99) = (rxt(257)*y(56) +.500_r8*rxt(267)*y(62))*y(20)
         loss(117) = (rxt(245)* y(8) +rxt(244)* y(20) + rxt(56) + het_rates(47)) &
                 * y(47)
         prod(117) = (rxt(239)*y(43) +.270_r8*rxt(260)*y(58) +rxt(265)*y(61) + &
                 rxt(278)*y(70) +rxt(282)*y(71) +.400_r8*rxt(319)*y(81))*y(6) &
                  + (.500_r8*rxt(258)*y(56) +.040_r8*rxt(280)*y(74))*y(1) &
                  + (.500_r8*rxt(243)*y(44) +rxt(254)*y(48))*y(20) &
                  + (.800_r8*rxt(241)*y(13) +1.600_r8*rxt(242)*y(43))*y(43) +rxt(64) &
                 *y(44) +rxt(57)*y(62) +rxt(79)*y(72) +.400_r8*rxt(78)*y(82)
         loss(91) = (rxt(238)* y(20) + het_rates(46))* y(46)
         prod(91) = (.250_r8*rxt(258)*y(56) +.200_r8*rxt(304)*y(80))*y(1) &
                  + (.250_r8*rxt(248)*y(45) +.250_r8*rxt(296)*y(73))*y(21) &
                  +.100_r8*rxt(249)*y(45)*y(13)
         loss(87) = (rxt(267)* y(20) + rxt(57) + het_rates(62))* y(62)
         prod(87) =rxt(266)*y(61)*y(21)
         loss(125) = (rxt(246)* y(6) +rxt(247)* y(7) +rxt(249)* y(13) +rxt(248)* y(21) &
                  + 2._r8*rxt(250)* y(45) +rxt(292)* y(76) +rxt(311)* y(85) +rxt(326) &
                 * y(88) + het_rates(45))* y(45)
         prod(125) = (rxt(269)*y(64) +rxt(282)*y(71) +.530_r8*rxt(287)*y(76) + &
                 rxt(294)*y(73))*y(6) + (rxt(245)*y(47) +rxt(275)*y(65) + &
                 .530_r8*rxt(289)*y(76) +rxt(295)*y(73))*y(8) &
                  + (.300_r8*rxt(271)*y(64) +.260_r8*rxt(291)*y(76) +rxt(297)*y(73)) &
                 *y(13) + (rxt(244)*y(47) +.500_r8*rxt(251)*y(51) +rxt(274)*y(65)) &
                 *y(20) + (.600_r8*rxt(59) +rxt(255))*y(55) +.530_r8*rxt(292)*y(76) &
                 *y(45) +rxt(68)*y(60) +rxt(73)*y(63) +rxt(69)*y(65) +rxt(67)*y(66) &
                  +rxt(75)*y(69) +rxt(79)*y(72) +2.000_r8*rxt(299)*y(73)*y(73) &
                  +.300_r8*rxt(63)*y(74) +1.340_r8*rxt(61)*y(75) +.130_r8*rxt(76) &
                 *y(83)
         loss(82) = (rxt(251)* y(20) + rxt(58) + het_rates(51))* y(51)
         prod(82) = (.750_r8*rxt(248)*y(45) +.750_r8*rxt(296)*y(73))*y(21)
         loss(78) = (rxt(256)* y(20) + rxt(59) + rxt(255) + het_rates(55))* y(55)
         prod(78) =rxt(247)*y(45)*y(7)
         loss(73) = (rxt(276)* y(20) + het_rates(79))* y(79)
         prod(73) =.100_r8*rxt(319)*y(81)*y(6) +rxt(259)*y(56)*y(8)
         loss(60) = (rxt(231)* y(20) +rxt(229)* y(25) + het_rates(42))* y(42)
         prod(60) = 0._r8
         loss(67) = (rxt(237)* y(1) +rxt(232)* y(20) + het_rates(41))* y(41)
         prod(67) = 0._r8
         loss(38) = (rxt(315)* y(20) + het_rates(68))* y(68)
         prod(38) = 0._r8
         loss(88) = (rxt(302)* y(20) + rxt(60) + rxt(301) + het_rates(78))* y(78)
         prod(88) =rxt(300)*y(73)*y(7)
         loss(39) = (rxt(277)* y(20) + het_rates(67))* y(67)
         prod(39) = 0._r8
         loss(65) = (rxt(278)* y(6) + het_rates(70))* y(70)
         prod(65) =rxt(277)*y(67)*y(20)
         loss(97) = (rxt(319)* y(6) +rxt(320)* y(21) + het_rates(81))* y(81)
         prod(97) = (rxt(315)*y(68) +rxt(321)*y(82))*y(20)
         loss(94) = (rxt(321)* y(20) + rxt(78) + het_rates(82))* y(82)
         prod(94) =rxt(320)*y(81)*y(21)
         loss(77) = (rxt(281)* y(20) + rxt(75) + het_rates(69))* y(69)
         prod(77) =.800_r8*rxt(319)*y(81)*y(6) +.800_r8*rxt(78)*y(82)
         loss(95) = (rxt(282)* y(6) +rxt(283)* y(21) + het_rates(71))* y(71)
         prod(95) = (rxt(281)*y(69) +rxt(284)*y(72))*y(20)
         loss(66) = (rxt(284)* y(20) + rxt(79) + het_rates(72))* y(72)
         prod(66) =rxt(283)*y(71)*y(21)
         loss(47) = (rxt(329)* y(20) + het_rates(91))* y(91)
         prod(47) = 0._r8
         loss(48) = (rxt(333)* y(20) + het_rates(92))* y(92)
         prod(48) =.250_r8*rxt(329)*y(91)*y(20)
         loss(84) = (rxt(330)* y(6) +rxt(331)* y(21) + het_rates(93))* y(93)
         prod(84) = (.700_r8*rxt(329)*y(91) +rxt(332)*y(94))*y(20)
         loss(75) = (rxt(332)* y(20) + rxt(80) + het_rates(94))* y(94)
         prod(75) =rxt(331)*y(93)*y(21)
         loss(53) = (rxt(334)* y(7) + het_rates(95))* y(95)
         prod(53) =rxt(333)*y(92)*y(20)
         loss(110) = (rxt(344)* y(6) +rxt(345)* y(21) + het_rates(103))* y(103)
         prod(110) = (rxt(341)*y(102) +rxt(346)*y(104))*y(20) +rxt(343)*y(102)*y(8)
         loss(80) = (rxt(346)* y(20) + rxt(81) + het_rates(104))* y(104)
         prod(80) =rxt(345)*y(103)*y(21)
         loss(85) = ( + rxt(76) + het_rates(83))* y(83)
         prod(85) = (.900_r8*rxt(330)*y(93) +.900_r8*rxt(337)*y(97) + &
                 .620_r8*rxt(340)*y(100))*y(6) +.700_r8*rxt(334)*y(95)*y(7) &
                  +.900_r8*rxt(80)*y(94)
         loss(96) = (rxt(253)* y(20) + rxt(77) + het_rates(50))* y(50)
         prod(96) = (.250_r8*rxt(322)*y(88) +.450_r8*rxt(330)*y(93) + &
                 .900_r8*rxt(337)*y(97) +.340_r8*rxt(340)*y(100))*y(6) &
                  + (.250_r8*rxt(323)*y(8) +.100_r8*rxt(325)*y(13) + &
                 .250_r8*rxt(326)*y(45))*y(88) + (.650_r8*rxt(230)*y(125) + &
                 .200_r8*rxt(252)*y(49))*y(20) +.130_r8*rxt(76)*y(83) +.450_r8*rxt(80) &
                 *y(94)
         loss(40) = (rxt(335)* y(20) + het_rates(96))* y(96)
         prod(40) = 0._r8
         loss(71) = (rxt(337)* y(6) +rxt(336)* y(21) + het_rates(97))* y(97)
         prod(71) =rxt(335)*y(96)*y(20)
         loss(1) = ( + het_rates(98))* y(98)
         prod(1) =rxt(336)*y(97)*y(21)
         loss(41) = (rxt(338)* y(20) + het_rates(99))* y(99)
         prod(41) = 0._r8
         loss(79) = (rxt(340)* y(6) +rxt(339)* y(21) + het_rates(100))* y(100)
         prod(79) =rxt(338)*y(99)*y(20)
         loss(2) = ( + het_rates(101))* y(101)
         prod(2) =rxt(339)*y(100)*y(21)
         loss(123) = (rxt(306)* y(6) +rxt(307)* y(8) +rxt(310)* y(13) +rxt(308)* y(21) &
                  +rxt(311)* y(45) + het_rates(85))* y(85)
         prod(123) = (rxt(303)*y(80) +.200_r8*rxt(309)*y(90))*y(20)
         loss(121) = (rxt(280)* y(1) +rxt(279)* y(20) + rxt(63) + het_rates(74)) &
                 * y(74)
         prod(121) = (.320_r8*rxt(306)*y(6) +.350_r8*rxt(307)*y(8) + &
                 .260_r8*rxt(310)*y(13) +.350_r8*rxt(311)*y(45))*y(85) &
                  + (.039_r8*rxt(312)*y(6) +.039_r8*rxt(313)*y(8) + &
                 .039_r8*rxt(314)*y(21))*y(86) + (.200_r8*rxt(304)*y(80) + &
                 rxt(342)*y(102))*y(1) +rxt(344)*y(103)*y(6) +.402_r8*rxt(72)*y(90) &
                  +rxt(81)*y(104)
         loss(118) = (rxt(286)* y(1) +rxt(285)* y(20) + rxt(61) + rxt(62) &
                  + het_rates(75))* y(75)
         prod(118) = (.230_r8*rxt(306)*y(6) +.250_r8*rxt(307)*y(8) + &
                 .190_r8*rxt(310)*y(13) +.250_r8*rxt(311)*y(45))*y(85) &
                  + (.167_r8*rxt(312)*y(6) +.167_r8*rxt(313)*y(8) + &
                 .167_r8*rxt(314)*y(21))*y(86) + (.400_r8*rxt(304)*y(80) + &
                 rxt(342)*y(102))*y(1) +rxt(344)*y(103)*y(6) +.288_r8*rxt(72)*y(90) &
                  +rxt(81)*y(104)
         loss(122) = ((rxt(287) +rxt(288))* y(6) +rxt(289)* y(8) +rxt(291)* y(13) &
                  +rxt(290)* y(21) +rxt(292)* y(45) + het_rates(76))* y(76)
         prod(122) = (rxt(279)*y(74) +.500_r8*rxt(285)*y(75) +.200_r8*rxt(293)*y(77)) &
                 *y(20)
         loss(62) = (rxt(293)* y(20) + het_rates(77))* y(77)
         prod(62) =rxt(290)*y(76)*y(21)
         loss(124) = (rxt(294)* y(6) +rxt(300)* y(7) +rxt(295)* y(8) +rxt(297)* y(13) &
                  +rxt(296)* y(21) +rxt(298)* y(45) + 2._r8*rxt(299)* y(73) &
                  + het_rates(73))* y(73)
         prod(124) = (.500_r8*rxt(285)*y(75) +.500_r8*rxt(293)*y(77))*y(20) &
                  + (rxt(60) +rxt(301))*y(78) +.200_r8*rxt(304)*y(80)*y(1) &
                  +.660_r8*rxt(61)*y(75)
         loss(100) = (rxt(239)* y(6) +rxt(241)* y(13) +rxt(240)* y(21) &
                  + 2._r8*rxt(242)* y(43) + het_rates(43))* y(43)
         prod(100) = (rxt(231)*y(42) +.500_r8*rxt(243)*y(44))*y(20) +rxt(229)*y(42) &
                 *y(25) +rxt(75)*y(69)
         loss(63) = (rxt(243)* y(20) + rxt(64) + het_rates(44))* y(44)
         prod(63) =rxt(240)*y(43)*y(21)
         loss(92) = (rxt(342)* y(1) +rxt(343)* y(8) +rxt(341)* y(20) + het_rates(102)) &
                 * y(102)
         prod(92) = 0._r8
         loss(45) = (rxt(264)* y(20) + het_rates(57))* y(57)
         prod(45) = 0._r8
         loss(104) = (rxt(260)* y(6) +rxt(262)* y(13) +rxt(261)* y(21) &
                  + het_rates(58))* y(58)
         prod(104) = (rxt(263)*y(59) +rxt(264)*y(57))*y(20)
         loss(69) = (rxt(263)* y(20) + rxt(66) + het_rates(59))* y(59)
         prod(69) =rxt(261)*y(58)*y(21)
         loss(98) = (rxt(268)* y(20) + rxt(68) + het_rates(60))* y(60)
         prod(98) = (.820_r8*rxt(260)*y(58) +.500_r8*rxt(278)*y(70) + &
                 .250_r8*rxt(319)*y(81) +.100_r8*rxt(344)*y(103))*y(6) &
                  +.820_r8*rxt(262)*y(58)*y(13) +.820_r8*rxt(66)*y(59) &
                  +.250_r8*rxt(78)*y(82) +.100_r8*rxt(81)*y(104)
         loss(70) = (rxt(272)* y(20) + rxt(67) + het_rates(66))* y(66)
         prod(70) =rxt(270)*y(64)*y(21)
         loss(83) = (rxt(223)* y(20) + het_rates(15))* y(15)
         prod(83) = (rxt(222)*y(13) +.300_r8*rxt(241)*y(43) +.500_r8*rxt(271)*y(64) + &
                 .250_r8*rxt(291)*y(76) +.250_r8*rxt(310)*y(85) + &
                 .300_r8*rxt(325)*y(88))*y(13)
         loss(58) = (rxt(254)* y(20) + het_rates(48))* y(48)
         prod(58) = (.200_r8*rxt(241)*y(13) +.400_r8*rxt(242)*y(43))*y(43)
         loss(103) = (rxt(252)* y(20) + rxt(74) + het_rates(49))* y(49)
         prod(103) = (.530_r8*rxt(287)*y(6) +.530_r8*rxt(289)*y(8) + &
                 .260_r8*rxt(291)*y(13) +.530_r8*rxt(292)*y(45))*y(76) &
                  + (.250_r8*rxt(322)*y(6) +.250_r8*rxt(323)*y(8) + &
                 .100_r8*rxt(325)*y(13) +.250_r8*rxt(326)*y(45))*y(88) +rxt(235)*y(53)
         loss(116) = (rxt(273)* y(20) + rxt(73) + het_rates(63))* y(63)
         prod(116) = (.220_r8*rxt(287)*y(6) +.220_r8*rxt(289)*y(8) + &
                 .230_r8*rxt(291)*y(13) +.220_r8*rxt(292)*y(45))*y(76) &
                  + (.250_r8*rxt(322)*y(6) +.250_r8*rxt(323)*y(8) + &
                 .100_r8*rxt(325)*y(13) +.250_r8*rxt(326)*y(45))*y(88) &
                  + (.500_r8*rxt(267)*y(62) +.500_r8*rxt(302)*y(78))*y(20) &
                  +.200_r8*rxt(271)*y(64)*y(13)
         loss(90) = (rxt(233)* y(6) +rxt(234)* y(21) + het_rates(52))* y(52)
         prod(90) =rxt(232)*y(41)*y(20)
         loss(59) = ( + rxt(235) + rxt(236) + het_rates(53))* y(53)
         prod(59) =.750_r8*rxt(233)*y(52)*y(6) +rxt(65)*y(54)
         loss(49) = ( + rxt(65) + het_rates(54))* y(54)
         prod(49) =rxt(234)*y(52)*y(21)
         loss(68) = (rxt(318)* y(20) + het_rates(84))* y(84)
         prod(68) = (.370_r8*rxt(306)*y(6) +.400_r8*rxt(307)*y(8) + &
                 .300_r8*rxt(310)*y(13) +.400_r8*rxt(311)*y(45))*y(85) &
                  + (rxt(316)*y(20) +rxt(317)*y(8))*y(87)
         loss(115) = (rxt(269)* y(6) +rxt(271)* y(13) +rxt(270)* y(21) &
                  + het_rates(64))* y(64)
         prod(115) = (rxt(268)*y(60) +rxt(272)*y(66))*y(20)
         loss(119) = (rxt(275)* y(8) +rxt(274)* y(20) + rxt(69) + het_rates(65)) &
                 * y(65)
         prod(119) = (.250_r8*rxt(287)*y(76) +.250_r8*rxt(322)*y(88) + &
                 .450_r8*rxt(330)*y(93) +.540_r8*rxt(340)*y(100))*y(6) &
                  + (.500_r8*rxt(271)*y(64) +.240_r8*rxt(291)*y(76) + &
                 .100_r8*rxt(325)*y(88))*y(13) + (.950_r8*rxt(280)*y(74) + &
                 .800_r8*rxt(286)*y(75))*y(1) + (.250_r8*rxt(289)*y(76) + &
                 .250_r8*rxt(323)*y(88))*y(8) + (rxt(273)*y(63) +rxt(276)*y(79))*y(20) &
                  + (.250_r8*rxt(292)*y(76) +.250_r8*rxt(326)*y(88))*y(45) &
                  +.180_r8*rxt(76)*y(83) +.450_r8*rxt(80)*y(94)
         loss(112) = (rxt(312)* y(6) +rxt(313)* y(8) +rxt(314)* y(21) + het_rates(86)) &
                 * y(86)
         prod(112) =rxt(305)*y(80)*y(8)
         loss(109) = (rxt(317)* y(8) +rxt(316)* y(20) + rxt(71) + het_rates(87)) &
                 * y(87)
         prod(109) = (.800_r8*rxt(288)*y(76) +.080_r8*rxt(306)*y(85) + &
                 .794_r8*rxt(312)*y(86))*y(6) + (.794_r8*rxt(313)*y(8) + &
                 .794_r8*rxt(314)*y(21))*y(86)
         loss(120) = (rxt(322)* y(6) +rxt(323)* y(8) +rxt(325)* y(13) +rxt(324)* y(21) &
                  +rxt(326)* y(45) + het_rates(88))* y(88)
         prod(120) = (.800_r8*rxt(309)*y(90) +rxt(318)*y(84) +rxt(327)*y(89))*y(20)
         loss(64) = ((rxt(327) +rxt(328))* y(20) + rxt(70) + het_rates(89))* y(89)
         prod(64) = (rxt(314)*y(86) +rxt(324)*y(88))*y(21)
         loss(86) = (rxt(309)* y(20) + rxt(72) + het_rates(90))* y(90)
         prod(86) =rxt(308)*y(85)*y(21)
         loss(51) = (rxt(230)* y(20) + het_rates(125))* y(125)
         prod(51) = 0._r8
         loss(72) = (rxt(225)* y(20) + het_rates(126))* y(126)
         prod(72) = (rxt(227)*y(6) +rxt(228)*y(21))*y(127) +.500_r8*rxt(237)*y(41) &
                 *y(1) +.350_r8*rxt(230)*y(125)*y(20)
         loss(81) = (rxt(227)* y(6) +rxt(228)* y(21) + rxt(226) + het_rates(127)) &
                 * y(127)
         prod(81) =rxt(218)*y(21)*y(16)
         loss(46) = (rxt(352)* y(20) + het_rates(142))* y(142)
         prod(46) = (rxt(353)*y(20) +.500_r8*rxt(354)*y(20) +rxt(355)*y(8))*y(143)
         loss(56) = (rxt(355)* y(8) + (rxt(353) +rxt(354))* y(20) + het_rates(143)) &
                 * y(143)
         prod(56) = 0._r8
         loss(3) = ( + rxt(363) + het_rates(144))* y(144)
         prod(3) =rxt(352)*y(142)*y(20)
         loss(42) = (rxt(356)* y(20) + het_rates(145))* y(145)
         prod(42) = 0._r8
         loss(4) = ( + rxt(369) + het_rates(146))* y(146)
         prod(4) = 0._r8
         loss(5) = ( + rxt(370) + het_rates(147))* y(147)
         prod(5) = 0._r8
         loss(6) = ( + rxt(364) + het_rates(132))* y(132)
         prod(6) = 0._r8
         loss(7) = ( + rxt(365) + het_rates(133))* y(133)
         prod(7) = 0._r8
         loss(8) = ( + rxt(367) + het_rates(134))* y(134)
         prod(8) = 0._r8
         loss(9) = ( + rxt(366) + het_rates(135))* y(135)
         prod(9) = 0._r8
         loss(10) = ( + rxt(368) + het_rates(136))* y(136)
         prod(10) = 0._r8
         loss(11) = ( + het_rates(137))* y(137)
         prod(11) = 0._r8
         loss(12) = ( + het_rates(138))* y(138)
         prod(12) = 0._r8
         loss(13) = ( + het_rates(139))* y(139)
         prod(13) = 0._r8
         loss(14) = ( + het_rates(140))* y(140)
         prod(14) = 0._r8
         loss(15) = ( + het_rates(141))* y(141)
         prod(15) = 0._r8
         loss(16) = ( + rxt(351) + rxt(359) + het_rates(128))* y(128)
         prod(16) = 0._r8
         loss(17) = ( + rxt(360) + het_rates(129))* y(129)
         prod(17) =rxt(351)*y(128)
         loss(18) = ( + rxt(357) + rxt(361) + het_rates(130))* y(130)
         prod(18) = 0._r8
         loss(19) = ( + rxt(362) + het_rates(131))* y(131)
         prod(19) =rxt(357)*y(130)
         loss(20) = ( + rxt(371) + het_rates(148))* y(148)
         prod(20) = 0._r8
         loss(21) = ( + rxt(372) + het_rates(149))* y(149)
         prod(21) = 0._r8
         loss(22) = ( + rxt(373) + het_rates(150))* y(150)
         prod(22) = 0._r8
         loss(23) = ( + rxt(374) + het_rates(151))* y(151)
         prod(23) = 0._r8
         loss(24) = ( + rxt(375) + het_rates(152))* y(152)
         prod(24) = 0._r8
         loss(25) = ( + rxt(376) + het_rates(153))* y(153)
         prod(25) = 0._r8
         loss(26) = ( + rxt(377) + het_rates(154))* y(154)
         prod(26) = 0._r8
         loss(27) = ( + rxt(378) + het_rates(155))* y(155)
         prod(27) = 0._r8
         loss(28) = ( + rxt(397) + het_rates(156))* y(156)
         prod(28) = 0._r8
         loss(29) = ( + rxt(398) + het_rates(157))* y(157)
         prod(29) = 0._r8
         loss(30) = ( + rxt(399) + het_rates(158))* y(158)
         prod(30) = 0._r8
         loss(31) = ( + het_rates(159))* y(159)
         prod(31) = 0._r8
         loss(32) = ( + rxt(400) + het_rates(160))* y(160)
         prod(32) = 0._r8
         loss(33) = ( + rxt(401) + het_rates(161))* y(161)
         prod(33) = 0._r8
         loss(34) = ( + rxt(402) + het_rates(162))* y(162)
         prod(34) = 0._r8
         loss(35) = ( + rxt(379) + het_rates(165))* y(165)
         prod(35) = 0._r8
         loss(36) = ( + rxt(82) + het_rates(166))* y(166)
         prod(36) = 0._r8
         loss(37) = ( + rxt(83) + het_rates(167))* y(167)
         prod(37) = 0._r8

      end subroutine imp_prod_loss

      end module mo_prod_loss
