




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(922) = -(rxt(116)*y(2) + rxt(134)*y(3) + rxt(161)*y(22) + rxt(166)*y(23) &
                      + rxt(174)*y(24) + rxt(189)*y(9) + rxt(192)*y(10) + rxt(204) &
                      *y(28) + rxt(231)*y(37) + rxt(290)*y(44) + rxt(311)*y(59) &
                      + rxt(333)*y(77) + rxt(339)*y(78) + rxt(357)*y(83) + rxt(389) &
                      *y(99))
         mat(959) = -rxt(116)*y(1)
         mat(983) = -rxt(134)*y(1)
         mat(1034) = -rxt(161)*y(1)
         mat(1245) = -rxt(166)*y(1)
         mat(1376) = -rxt(174)*y(1)
         mat(1114) = -rxt(189)*y(1)
         mat(1149) = -rxt(192)*y(1)
         mat(1017) = -rxt(204)*y(1)
         mat(879) = -rxt(231)*y(1)
         mat(262) = -rxt(290)*y(1)
         mat(570) = -rxt(311)*y(1)
         mat(722) = -rxt(333)*y(1)
         mat(619) = -rxt(339)*y(1)
         mat(478) = -rxt(357)*y(1)
         mat(290) = -rxt(389)*y(1)

         mat(922) = mat(922) + .100_r8*rxt(357)*y(83) + .200_r8*rxt(333)*y(77) &
                      + .200_r8*rxt(339)*y(78)
         mat(959) = mat(959) + rxt(115)*y(4)
         mat(810) = rxt(115)*y(2)
         mat(1376) = mat(1376) + .250_r8*rxt(301)*y(48) + .250_r8*rxt(349)*y(76)
         mat(478) = mat(478) + .100_r8*rxt(357)*y(1)
         mat(769) = .250_r8*rxt(301)*y(24)
         mat(722) = mat(722) + .200_r8*rxt(333)*y(1)
         mat(619) = mat(619) + .200_r8*rxt(339)*y(1)
         mat(741) = .250_r8*rxt(349)*y(24)

         mat(960) = -(rxt(115)*y(4) + rxt(116)*y(1) + 4._r8*rxt(117)*y(2) + rxt(165) &
                      *y(23) + rxt(172)*y(21) + rxt(173)*y(24) + rxt(176)*y(25) &
                      + rxt(187)*y(9) + (rxt(190) + rxt(191)) * y(10) + rxt(198)*y(11) &
                      + rxt(211)*y(30) + rxt(224)*y(33) + rxt(225)*y(34) + rxt(228) &
                      *y(35) + rxt(234)*y(38) + rxt(244)*y(39) + rxt(245)*y(40) &
                      + rxt(246)*y(41) + rxt(268)*y(19) + (rxt(441) + rxt(442) &
                      ) * y(121) + rxt(448)*y(123))
         mat(811) = -rxt(115)*y(2)
         mat(923) = -rxt(116)*y(2)
         mat(1246) = -rxt(165)*y(2)
         mat(629) = -rxt(172)*y(2)
         mat(1377) = -rxt(173)*y(2)
         mat(308) = -rxt(176)*y(2)
         mat(1115) = -rxt(187)*y(2)
         mat(1150) = -(rxt(190) + rxt(191)) * y(2)
         mat(1287) = -rxt(198)*y(2)
         mat(859) = -rxt(211)*y(2)
         mat(1059) = -rxt(224)*y(2)
         mat(488) = -rxt(225)*y(2)
         mat(540) = -rxt(228)*y(2)
         mat(788) = -rxt(234)*y(2)
         mat(438) = -rxt(244)*y(2)
         mat(374) = -rxt(245)*y(2)
         mat(251) = -rxt(246)*y(2)
         mat(1308) = -rxt(268)*y(2)
         mat(341) = -(rxt(441) + rxt(442)) * y(2)
         mat(190) = -rxt(448)*y(2)

         mat(984) = (rxt(129)+rxt(130))*y(4)
         mat(811) = mat(811) + (rxt(129)+rxt(130))*y(3) + rxt(182)*y(8) + rxt(447) &
                      *y(123) + rxt(439)*y(124)
         mat(462) = rxt(182)*y(4) + rxt(183)*y(9) + rxt(184)*y(10) + rxt(444)*y(122)
         mat(1115) = mat(1115) + rxt(183)*y(8)
         mat(1150) = mat(1150) + rxt(184)*y(8)
         mat(1246) = mat(1246) + 2.000_r8*rxt(168)*y(23)
         mat(1035) = rxt(164)*y(24)
         mat(1377) = mat(1377) + rxt(164)*y(22)
         mat(402) = rxt(444)*y(8) + 1.150_r8*rxt(452)*y(126)
         mat(190) = mat(190) + rxt(447)*y(4)
         mat(305) = rxt(439)*y(4)
         mat(410) = rxt(451)*y(126)
         mat(421) = 1.150_r8*rxt(452)*y(122) + rxt(451)*y(125)

         mat(985) = -((rxt(129) + rxt(130)) * y(4) + rxt(131)*y(128) + rxt(134)*y(1) &
                      + rxt(151)*y(132) + rxt(152)*y(133) + rxt(156)*y(21) + rxt(157) &
                      *y(33) + rxt(158)*y(39) + rxt(159)*y(42))
         mat(812) = -(rxt(129) + rxt(130)) * y(3)
         mat(825) = -rxt(131)*y(3)
         mat(924) = -rxt(134)*y(3)
         mat(57) = -rxt(151)*y(3)
         mat(75) = -rxt(152)*y(3)
         mat(630) = -rxt(156)*y(3)
         mat(1060) = -rxt(157)*y(3)
         mat(439) = -rxt(158)*y(3)
         mat(66) = -rxt(159)*y(3)

         mat(812) = mat(812) + rxt(179)*y(127)
         mat(403) = .850_r8*rxt(452)*y(126)
         mat(221) = rxt(179)*y(4)
         mat(422) = .850_r8*rxt(452)*y(122)

         mat(809) = -(rxt(115)*y(2) + rxt(125)*y(6) + rxt(129)*y(3) + rxt(160)*y(22) &
                      + rxt(179)*y(127) + rxt(182)*y(8) + rxt(288)*y(56) + rxt(439) &
                      *y(124) + (rxt(446) + rxt(447)) * y(123) + rxt(449)*y(121))
         mat(954) = -rxt(115)*y(4)
         mat(59) = -rxt(125)*y(4)
         mat(979) = -rxt(129)*y(4)
         mat(1031) = -rxt(160)*y(4)
         mat(220) = -rxt(179)*y(4)
         mat(461) = -rxt(182)*y(4)
         mat(181) = -rxt(288)*y(4)
         mat(304) = -rxt(439)*y(4)
         mat(189) = -(rxt(446) + rxt(447)) * y(4)
         mat(340) = -rxt(449)*y(4)

         mat(917) = 2.000_r8*rxt(116)*y(2) + 2.000_r8*rxt(134)*y(3) + rxt(189)*y(9) &
                      + rxt(192)*y(10) + rxt(166)*y(23) + rxt(161)*y(22) &
                      + 2.000_r8*rxt(174)*y(24) + rxt(204)*y(28) + rxt(231)*y(37)
         mat(954) = mat(954) + 2.000_r8*rxt(116)*y(1) + 2.000_r8*rxt(117)*y(2) &
                      + rxt(124)*y(6) + rxt(190)*y(10) + rxt(165)*y(23) + rxt(198) &
                      *y(11) + rxt(173)*y(24) + rxt(211)*y(30) + rxt(234)*y(38)
         mat(979) = mat(979) + 2.000_r8*rxt(134)*y(1)
         mat(809) = mat(809) + 2.000_r8*rxt(125)*y(6)
         mat(59) = mat(59) + rxt(124)*y(2) + 2.000_r8*rxt(125)*y(4)
         mat(461) = mat(461) + rxt(186)*y(10)
         mat(1109) = rxt(189)*y(1) + rxt(445)*y(122)
         mat(1144) = rxt(192)*y(1) + rxt(190)*y(2) + rxt(186)*y(8)
         mat(1240) = rxt(166)*y(1) + rxt(165)*y(2) + rxt(202)*y(13) + rxt(167)*y(24) &
                      + rxt(213)*y(30)
         mat(1283) = rxt(198)*y(2) + rxt(200)*y(24)
         mat(206) = rxt(202)*y(23)
         mat(1411) = rxt(271)*y(24)
         mat(1031) = mat(1031) + rxt(161)*y(1) + rxt(163)*y(24)
         mat(1371) = 2.000_r8*rxt(174)*y(1) + rxt(173)*y(2) + rxt(167)*y(23) &
                      + rxt(200)*y(11) + rxt(271)*y(16) + rxt(163)*y(22) &
                      + 2.000_r8*rxt(175)*y(24) + rxt(207)*y(28) + rxt(214)*y(30) &
                      + rxt(232)*y(37) + rxt(236)*y(38) + rxt(319)*y(64) &
                      + .750_r8*rxt(349)*y(76) + rxt(293)*y(46) + rxt(314)*y(61) &
                      + rxt(323)*y(67)
         mat(1012) = rxt(204)*y(1) + rxt(207)*y(24)
         mat(853) = rxt(211)*y(2) + rxt(213)*y(23) + rxt(214)*y(24) + ( &
                      + 2.000_r8*rxt(218)+2.000_r8*rxt(219))*y(30) + (rxt(240) &
                       +rxt(241))*y(38)
         mat(874) = rxt(231)*y(1) + rxt(232)*y(24)
         mat(783) = rxt(234)*y(2) + rxt(236)*y(24) + (rxt(240)+rxt(241))*y(30) &
                      + 2.000_r8*rxt(242)*y(38)
         mat(401) = rxt(445)*y(9)
         mat(428) = rxt(319)*y(24)
         mat(738) = .750_r8*rxt(349)*y(24)
         mat(447) = rxt(293)*y(24)
         mat(504) = rxt(314)*y(24)
         mat(604) = rxt(323)*y(24)

         mat(61) = -(rxt(118)*y(2) + rxt(119)*y(4) + rxt(121)*y(1))
         mat(936) = -rxt(118)*y(5)
         mat(797) = -rxt(119)*y(5)
         mat(893) = -rxt(121)*y(5)

         mat(973) = rxt(129)*y(4)
         mat(797) = mat(797) + rxt(129)*y(3)

         mat(58) = -(rxt(124)*y(2) + rxt(125)*y(4))
         mat(935) = -rxt(124)*y(6)
         mat(796) = -rxt(125)*y(6)

         mat(892) = rxt(121)*y(5)
         mat(935) = mat(935) + rxt(118)*y(5)
         mat(796) = mat(796) + rxt(119)*y(5)
         mat(60) = rxt(121)*y(1) + rxt(118)*y(2) + rxt(119)*y(4)

         mat(626) = -(rxt(156)*y(3) + rxt(170)*y(23) + rxt(172)*y(2) + rxt(205)*y(28) &
                      + rxt(248)*y(135))
         mat(978) = -rxt(156)*y(21)
         mat(1231) = -rxt(170)*y(21)
         mat(952) = -rxt(172)*y(21)
         mat(1010) = -rxt(205)*y(21)
         mat(390) = -rxt(248)*y(21)

         mat(1030) = rxt(163)*y(24)
         mat(1362) = rxt(163)*y(22)

         mat(578) = -((rxt(264) + rxt(265)) * y(23))
         mat(1226) = -(rxt(264) + rxt(265)) * y(20)

         mat(904) = .560_r8*rxt(311)*y(59) + .300_r8*rxt(357)*y(83) + .500_r8*rxt(290) &
                      *y(44) + .050_r8*rxt(333)*y(77) + .200_r8*rxt(339)*y(78)
         mat(951) = rxt(268)*y(19)
         mat(1096) = .220_r8*rxt(340)*y(79) + .500_r8*rxt(375)*y(91)
         mat(1226) = mat(1226) + rxt(267)*y(19) + rxt(306)*y(53) + rxt(327)*y(68) &
                      + .350_r8*rxt(283)*y(129)
         mat(1271) = rxt(266)*y(19) + .220_r8*rxt(342)*y(79) + rxt(328)*y(68) &
                      + .500_r8*rxt(376)*y(91)
         mat(1399) = .110_r8*rxt(344)*y(79) + .200_r8*rxt(378)*y(91)
         mat(1302) = rxt(268)*y(2) + rxt(267)*y(23) + rxt(266)*y(11) + rxt(209)*y(28) &
                      + rxt(233)*y(37)
         mat(1008) = rxt(209)*y(19)
         mat(872) = rxt(233)*y(19)
         mat(564) = .560_r8*rxt(311)*y(1)
         mat(472) = .300_r8*rxt(357)*y(1)
         mat(756) = .220_r8*rxt(345)*y(79) + .500_r8*rxt(379)*y(91)
         mat(261) = .500_r8*rxt(290)*y(1)
         mat(345) = rxt(306)*y(23)
         mat(711) = .050_r8*rxt(333)*y(1)
         mat(612) = .200_r8*rxt(339)*y(1)
         mat(693) = .220_r8*rxt(340)*y(9) + .220_r8*rxt(342)*y(11) + .110_r8*rxt(344) &
                      *y(16) + .220_r8*rxt(345)*y(48)
         mat(637) = rxt(327)*y(23) + rxt(328)*y(11)
         mat(650) = .500_r8*rxt(375)*y(9) + .500_r8*rxt(376)*y(11) + .200_r8*rxt(378) &
                      *y(16) + .500_r8*rxt(379)*y(48)
         mat(102) = .350_r8*rxt(283)*y(23)

         mat(459) = -(rxt(181)*y(23) + rxt(182)*y(4) + rxt(183)*y(9) + (rxt(184) &
                      + rxt(185) + rxt(186)) * y(10) + rxt(444)*y(122))
         mat(1216) = -rxt(181)*y(8)
         mat(806) = -rxt(182)*y(8)
         mat(1090) = -rxt(183)*y(8)
         mat(1136) = -(rxt(184) + rxt(185) + rxt(186)) * y(8)
         mat(400) = -rxt(444)*y(8)

         mat(948) = rxt(448)*y(123) + rxt(180)*y(127)
         mat(806) = mat(806) + rxt(446)*y(123)
         mat(338) = 1.100_r8*rxt(453)*y(126)
         mat(188) = rxt(448)*y(2) + rxt(446)*y(4)
         mat(408) = .200_r8*rxt(451)*y(126)
         mat(219) = rxt(180)*y(2)
         mat(418) = 1.100_r8*rxt(453)*y(121) + .200_r8*rxt(451)*y(125)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1120) = -(rxt(183)*y(8) + rxt(187)*y(2) + rxt(188)*y(24) + rxt(189)*y(1) &
                      + rxt(197)*y(11) + rxt(216)*y(30) + rxt(237)*y(38) + rxt(270) &
                      *y(16) + rxt(278)*y(131) + rxt(286)*y(55) + rxt(292)*y(46) &
                      + rxt(299)*y(48) + rxt(313)*y(61) + rxt(318)*y(64) + rxt(322) &
                      *y(67) + rxt(331)*y(73) + rxt(335)*y(74) + (rxt(340) + rxt(341) &
                      ) * y(79) + rxt(347)*y(76) + rxt(359)*y(88) + rxt(365)*y(89) &
                      + rxt(372)*y(84) + rxt(375)*y(91) + rxt(383)*y(96) + rxt(391) &
                      *y(100) + rxt(445)*y(122))
         mat(465) = -rxt(183)*y(9)
         mat(965) = -rxt(187)*y(9)
         mat(1382) = -rxt(188)*y(9)
         mat(928) = -rxt(189)*y(9)
         mat(1292) = -rxt(197)*y(9)
         mat(864) = -rxt(216)*y(9)
         mat(791) = -rxt(237)*y(9)
         mat(1422) = -rxt(270)*y(9)
         mat(164) = -rxt(278)*y(9)
         mat(383) = -rxt(286)*y(9)
         mat(448) = -rxt(292)*y(9)
         mat(771) = -rxt(299)*y(9)
         mat(506) = -rxt(313)*y(9)
         mat(430) = -rxt(318)*y(9)
         mat(606) = -rxt(322)*y(9)
         mat(114) = -rxt(331)*y(9)
         mat(328) = -rxt(335)*y(9)
         mat(703) = -(rxt(340) + rxt(341)) * y(9)
         mat(743) = -rxt(347)*y(9)
         mat(682) = -rxt(359)*y(9)
         mat(554) = -rxt(365)*y(9)
         mat(358) = -rxt(372)*y(9)
         mat(658) = -rxt(375)*y(9)
         mat(236) = -rxt(383)*y(9)
         mat(529) = -rxt(391)*y(9)
         mat(404) = -rxt(445)*y(9)

         mat(965) = mat(965) + rxt(190)*y(10)
         mat(814) = rxt(182)*y(8) + rxt(179)*y(127)
         mat(465) = mat(465) + rxt(182)*y(4) + 2.000_r8*rxt(185)*y(10) + rxt(181) &
                      *y(23)
         mat(1155) = rxt(190)*y(2) + 2.000_r8*rxt(185)*y(8)
         mat(1251) = rxt(181)*y(8)
         mat(222) = rxt(179)*y(4)

         mat(1156) = -((rxt(184) + rxt(185) + rxt(186)) * y(8) + (rxt(190) + rxt(191) &
                      ) * y(2) + rxt(192)*y(1) + rxt(193)*y(11) + rxt(195)*y(23) &
                      + rxt(201)*y(24) + rxt(217)*y(30) + rxt(238)*y(38) + rxt(300) &
                      *y(48) + rxt(353)*y(76) + rxt(387)*y(98))
         mat(466) = -(rxt(184) + rxt(185) + rxt(186)) * y(10)
         mat(966) = -(rxt(190) + rxt(191)) * y(10)
         mat(929) = -rxt(192)*y(10)
         mat(1293) = -rxt(193)*y(10)
         mat(1252) = -rxt(195)*y(10)
         mat(1383) = -rxt(201)*y(10)
         mat(865) = -rxt(217)*y(10)
         mat(792) = -rxt(238)*y(10)
         mat(772) = -rxt(300)*y(10)
         mat(744) = -rxt(353)*y(10)
         mat(71) = -rxt(387)*y(10)

         mat(929) = mat(929) + rxt(189)*y(9)
         mat(966) = mat(966) + rxt(187)*y(9) + rxt(198)*y(11)
         mat(1121) = rxt(189)*y(1) + rxt(187)*y(2) + 2.000_r8*rxt(197)*y(11) &
                      + rxt(270)*y(16) + rxt(188)*y(24) + rxt(216)*y(30) + rxt(237) &
                      *y(38) + rxt(318)*y(64) + rxt(299)*y(48) + rxt(331)*y(73) &
                      + .900_r8*rxt(372)*y(84) + rxt(335)*y(74) + .900_r8*rxt(383) &
                      *y(96) + rxt(391)*y(100) + .920_r8*rxt(359)*y(88) + rxt(340) &
                      *y(79) + rxt(347)*y(76) + rxt(292)*y(46) + rxt(313)*y(61) &
                      + rxt(286)*y(55) + rxt(322)*y(67) + 1.206_r8*rxt(365)*y(89) &
                      + rxt(375)*y(91) + rxt(278)*y(131)
         mat(1156) = mat(1156) + .700_r8*rxt(387)*y(98)
         mat(1252) = mat(1252) + rxt(199)*y(11) + rxt(202)*y(13) + rxt(329)*y(82) &
                      + .400_r8*rxt(369)*y(90)
         mat(1293) = mat(1293) + rxt(198)*y(2) + 2.000_r8*rxt(197)*y(9) + rxt(199) &
                      *y(23) + rxt(200)*y(24) + rxt(360)*y(88) + rxt(342)*y(79) &
                      + rxt(348)*y(76) + rxt(390)*y(99) + 1.206_r8*rxt(366)*y(89) &
                      + rxt(370)*y(90) + rxt(376)*y(91)
         mat(208) = rxt(202)*y(23)
         mat(1423) = rxt(270)*y(9)
         mat(1383) = mat(1383) + rxt(188)*y(9) + rxt(200)*y(11) + .206_r8*rxt(367) &
                      *y(89)
         mat(865) = mat(865) + rxt(216)*y(9)
         mat(792) = mat(792) + rxt(237)*y(9)
         mat(431) = rxt(318)*y(9)
         mat(772) = mat(772) + rxt(299)*y(9)
         mat(142) = rxt(329)*y(23)
         mat(115) = rxt(331)*y(9)
         mat(359) = .900_r8*rxt(372)*y(9)
         mat(329) = rxt(335)*y(9)
         mat(237) = .900_r8*rxt(383)*y(9)
         mat(71) = mat(71) + .700_r8*rxt(387)*y(10)
         mat(530) = rxt(391)*y(9)
         mat(683) = .920_r8*rxt(359)*y(9) + rxt(360)*y(11)
         mat(704) = rxt(340)*y(9) + rxt(342)*y(11)
         mat(744) = mat(744) + rxt(347)*y(9) + rxt(348)*y(11)
         mat(449) = rxt(292)*y(9)
         mat(291) = rxt(390)*y(11)
         mat(507) = rxt(313)*y(9)
         mat(384) = rxt(286)*y(9)
         mat(607) = rxt(322)*y(9)
         mat(555) = 1.206_r8*rxt(365)*y(9) + 1.206_r8*rxt(366)*y(11) &
                      + .206_r8*rxt(367)*y(24)
         mat(516) = .400_r8*rxt(369)*y(23) + rxt(370)*y(11)
         mat(659) = rxt(375)*y(9) + rxt(376)*y(11)
         mat(165) = rxt(278)*y(9)

         mat(1253) = -(rxt(165)*y(2) + rxt(166)*y(1) + rxt(167)*y(24) + (4._r8*rxt(168) &
                      + 4._r8*rxt(169)) * y(23) + rxt(170)*y(21) + rxt(171)*y(25) &
                      + rxt(177)*y(42) + rxt(178)*y(43) + rxt(181)*y(8) + rxt(195) &
                      *y(10) + rxt(196)*y(12) + rxt(199)*y(11) + rxt(202)*y(13) &
                      + (rxt(212) + rxt(213)) * y(30) + rxt(223)*y(33) + rxt(227) &
                      *y(34) + rxt(229)*y(35) + rxt(235)*y(38) + rxt(243)*y(39) &
                      + (rxt(264) + rxt(265)) * y(20) + rxt(267)*y(19) + rxt(274) &
                      *y(18) + rxt(275)*y(17) + rxt(276)*y(130) + rxt(283)*y(129) &
                      + rxt(284)*y(45) + rxt(285)*y(44) + rxt(291)*y(49) + rxt(296) &
                      *y(47) + rxt(297)*y(50) + rxt(304)*y(54) + rxt(305)*y(52) &
                      + rxt(306)*y(53) + rxt(307)*y(51) + rxt(309)*y(58) + rxt(310) &
                      *y(59) + rxt(316)*y(62) + rxt(317)*y(60) + rxt(320)*y(65) &
                      + rxt(321)*y(63) + rxt(325)*y(69) + rxt(326)*y(66) + rxt(327) &
                      *y(68) + rxt(329)*y(82) + rxt(330)*y(70) + rxt(332)*y(77) &
                      + rxt(334)*y(72) + rxt(337)*y(75) + rxt(338)*y(78) + rxt(346) &
                      *y(80) + rxt(355)*y(81) + rxt(356)*y(83) + rxt(362)*y(93) &
                      + rxt(368)*y(71) + rxt(369)*y(90) + rxt(371)*y(87) + rxt(374) &
                      *y(85) + rxt(380)*y(92) + rxt(382)*y(94) + rxt(385)*y(97) &
                      + rxt(386)*y(95) + rxt(388)*y(99) + rxt(393)*y(101) + rxt(398) &
                      *y(141) + (rxt(399) + rxt(400)) * y(142) + rxt(402)*y(144))
         mat(967) = -rxt(165)*y(23)
         mat(930) = -rxt(166)*y(23)
         mat(1384) = -rxt(167)*y(23)
         mat(634) = -rxt(170)*y(23)
         mat(311) = -rxt(171)*y(23)
         mat(67) = -rxt(177)*y(23)
         mat(20) = -rxt(178)*y(23)
         mat(467) = -rxt(181)*y(23)
         mat(1157) = -rxt(195)*y(23)
         mat(843) = -rxt(196)*y(23)
         mat(1294) = -rxt(199)*y(23)
         mat(209) = -rxt(202)*y(23)
         mat(866) = -(rxt(212) + rxt(213)) * y(23)
         mat(1066) = -rxt(223)*y(23)
         mat(491) = -rxt(227)*y(23)
         mat(544) = -rxt(229)*y(23)
         mat(793) = -rxt(235)*y(23)
         mat(441) = -rxt(243)*y(23)
         mat(580) = -(rxt(264) + rxt(265)) * y(23)
         mat(1315) = -rxt(267)*y(23)
         mat(255) = -rxt(274)*y(23)
         mat(171) = -rxt(275)*y(23)
         mat(268) = -rxt(276)*y(23)
         mat(103) = -rxt(283)*y(23)
         mat(98) = -rxt(284)*y(23)
         mat(263) = -rxt(285)*y(23)
         mat(297) = -rxt(291)*y(23)
         mat(131) = -rxt(296)*y(23)
         mat(588) = -rxt(297)*y(23)
         mat(215) = -rxt(304)*y(23)
         mat(495) = -rxt(305)*y(23)
         mat(346) = -rxt(306)*y(23)
         mat(91) = -rxt(307)*y(23)
         mat(201) = -rxt(309)*y(23)
         mat(573) = -rxt(310)*y(23)
         mat(154) = -rxt(316)*y(23)
         mat(37) = -rxt(317)*y(23)
         mat(283) = -rxt(320)*y(23)
         mat(367) = -rxt(321)*y(23)
         mat(160) = -rxt(325)*y(23)
         mat(595) = -rxt(326)*y(23)
         mat(643) = -rxt(327)*y(23)
         mat(143) = -rxt(329)*y(23)
         mat(30) = -rxt(330)*y(23)
         mat(726) = -rxt(332)*y(23)
         mat(178) = -rxt(334)*y(23)
         mat(122) = -rxt(337)*y(23)
         mat(621) = -rxt(338)*y(23)
         mat(126) = -rxt(346)*y(23)
         mat(227) = -rxt(355)*y(23)
         mat(479) = -rxt(356)*y(23)
         mat(275) = -rxt(362)*y(23)
         mat(27) = -rxt(368)*y(23)
         mat(517) = -rxt(369)*y(23)
         mat(139) = -rxt(371)*y(23)
         mat(321) = -rxt(374)*y(23)
         mat(136) = -rxt(380)*y(23)
         mat(47) = -rxt(382)*y(23)
         mat(149) = -rxt(385)*y(23)
         mat(51) = -rxt(386)*y(23)
         mat(292) = -rxt(388)*y(23)
         mat(196) = -rxt(393)*y(23)
         mat(40) = -rxt(398)*y(23)
         mat(86) = -(rxt(399) + rxt(400)) * y(23)
         mat(33) = -rxt(402)*y(23)

         mat(930) = mat(930) + rxt(161)*y(22) + rxt(174)*y(24) + .330_r8*rxt(311) &
                      *y(59) + .270_r8*rxt(357)*y(83) + .120_r8*rxt(290)*y(44) &
                      + .080_r8*rxt(333)*y(77) + .215_r8*rxt(339)*y(78) &
                      + .700_r8*rxt(389)*y(99)
         mat(967) = mat(967) + rxt(172)*y(21) + rxt(268)*y(19) + rxt(173)*y(24) &
                      + rxt(176)*y(25) + rxt(224)*y(33) + rxt(225)*y(34) + rxt(244) &
                      *y(39) + rxt(245)*y(40)
         mat(991) = rxt(156)*y(21) + rxt(159)*y(42) + 2.000_r8*rxt(131)*y(128) &
                      + rxt(157)*y(33) + rxt(158)*y(39)
         mat(634) = mat(634) + rxt(172)*y(2) + rxt(156)*y(3)
         mat(1122) = rxt(188)*y(24)
         mat(1253) = mat(1253) + .300_r8*rxt(275)*y(17) + .500_r8*rxt(320)*y(65) &
                      + .100_r8*rxt(346)*y(80) + .500_r8*rxt(296)*y(47) &
                      + .650_r8*rxt(283)*y(129)
         mat(1294) = mat(1294) + rxt(200)*y(24)
         mat(171) = mat(171) + .300_r8*rxt(275)*y(23)
         mat(67) = mat(67) + rxt(159)*y(3)
         mat(1315) = mat(1315) + rxt(268)*y(2)
         mat(1042) = rxt(161)*y(1) + 2.000_r8*rxt(162)*y(24)
         mat(1384) = mat(1384) + rxt(174)*y(1) + rxt(173)*y(2) + rxt(188)*y(9) &
                      + rxt(200)*y(11) + 2.000_r8*rxt(162)*y(22) + rxt(208)*y(28)
         mat(311) = mat(311) + rxt(176)*y(2)
         mat(829) = 2.000_r8*rxt(131)*y(3) + rxt(247)*y(135)
         mat(1025) = rxt(208)*y(24)
         mat(1066) = mat(1066) + rxt(224)*y(2) + rxt(157)*y(3)
         mat(491) = mat(491) + rxt(225)*y(2)
         mat(441) = mat(441) + rxt(244)*y(2) + rxt(158)*y(3)
         mat(377) = rxt(245)*y(2)
         mat(573) = mat(573) + .330_r8*rxt(311)*y(1)
         mat(479) = mat(479) + .270_r8*rxt(357)*y(1)
         mat(283) = mat(283) + .500_r8*rxt(320)*y(23)
         mat(263) = mat(263) + .120_r8*rxt(290)*y(1)
         mat(726) = mat(726) + .080_r8*rxt(333)*y(1)
         mat(621) = mat(621) + .215_r8*rxt(339)*y(1)
         mat(126) = mat(126) + .100_r8*rxt(346)*y(23)
         mat(131) = mat(131) + .500_r8*rxt(296)*y(23)
         mat(292) = mat(292) + .700_r8*rxt(389)*y(1)
         mat(103) = mat(103) + .650_r8*rxt(283)*y(23)
         mat(394) = rxt(247)*y(128)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1295) = -(rxt(193)*y(10) + rxt(197)*y(9) + rxt(198)*y(2) + rxt(199)*y(23) &
                      + rxt(200)*y(24) + rxt(266)*y(19) + rxt(298)*y(50) + rxt(312) &
                      *y(59) + rxt(328)*y(68) + rxt(342)*y(79) + rxt(348)*y(76) &
                      + rxt(358)*y(83) + rxt(360)*y(88) + rxt(366)*y(89) + rxt(370) &
                      *y(90) + rxt(376)*y(91) + rxt(390)*y(99) + rxt(401)*y(142))
         mat(1158) = -rxt(193)*y(11)
         mat(1123) = -rxt(197)*y(11)
         mat(968) = -rxt(198)*y(11)
         mat(1254) = -rxt(199)*y(11)
         mat(1385) = -rxt(200)*y(11)
         mat(1316) = -rxt(266)*y(11)
         mat(589) = -rxt(298)*y(11)
         mat(574) = -rxt(312)*y(11)
         mat(644) = -rxt(328)*y(11)
         mat(706) = -rxt(342)*y(11)
         mat(746) = -rxt(348)*y(11)
         mat(480) = -rxt(358)*y(11)
         mat(685) = -rxt(360)*y(11)
         mat(557) = -rxt(366)*y(11)
         mat(518) = -rxt(370)*y(11)
         mat(661) = -rxt(376)*y(11)
         mat(293) = -rxt(390)*y(11)
         mat(87) = -rxt(401)*y(11)

         mat(931) = rxt(192)*y(10)
         mat(968) = mat(968) + rxt(191)*y(10) + rxt(228)*y(35) + rxt(246)*y(41)
         mat(1158) = mat(1158) + rxt(192)*y(1) + rxt(191)*y(2)
         mat(1254) = mat(1254) + rxt(196)*y(12) + rxt(229)*y(35) + rxt(309)*y(58) &
                      + .500_r8*rxt(355)*y(81)
         mat(844) = rxt(196)*y(23) + rxt(250)*y(135)
         mat(1026) = rxt(230)*y(35)
         mat(545) = rxt(228)*y(2) + rxt(229)*y(23) + rxt(230)*y(28)
         mat(253) = rxt(246)*y(2)
         mat(202) = rxt(309)*y(23)
         mat(228) = .500_r8*rxt(355)*y(23)
         mat(395) = rxt(250)*y(12)

         mat(836) = -(rxt(196)*y(23) + rxt(250)*y(135))
         mat(1242) = -rxt(196)*y(12)
         mat(392) = -rxt(250)*y(12)

         mat(1146) = rxt(195)*y(23)
         mat(1242) = mat(1242) + rxt(195)*y(10)
         mat(1285) = rxt(266)*y(19) + rxt(298)*y(50) + rxt(328)*y(68) + rxt(401) &
                      *y(142)
         mat(1305) = rxt(266)*y(11)
         mat(1055) = (rxt(425)+rxt(430)+rxt(436))*y(35)
         mat(538) = (rxt(425)+rxt(430)+rxt(436))*y(33)
         mat(586) = rxt(298)*y(11)
         mat(641) = rxt(328)*y(11)
         mat(85) = rxt(401)*y(11)

         mat(205) = -(rxt(202)*y(23))
         mat(1193) = -rxt(202)*y(13)

         mat(1130) = rxt(201)*y(24)
         mat(1332) = rxt(201)*y(10)


         mat(1128) = rxt(193)*y(11)
         mat(1260) = rxt(193)*y(10)

         mat(1428) = -(rxt(215)*y(30) + rxt(270)*y(9) + rxt(271)*y(24) + (4._r8*rxt(272) &
                      + 4._r8*rxt(273)) * y(16) + rxt(294)*y(46) + rxt(302)*y(48) &
                      + rxt(315)*y(61) + rxt(324)*y(67) + rxt(344)*y(79) + rxt(350) &
                      *y(76) + rxt(363)*y(88) + rxt(378)*y(91))
         mat(870) = -rxt(215)*y(16)
         mat(1126) = -rxt(270)*y(16)
         mat(1388) = -rxt(271)*y(16)
         mat(453) = -rxt(294)*y(16)
         mat(777) = -rxt(302)*y(16)
         mat(511) = -rxt(315)*y(16)
         mat(611) = -rxt(324)*y(16)
         mat(709) = -rxt(344)*y(16)
         mat(749) = -rxt(350)*y(16)
         mat(688) = -rxt(363)*y(16)
         mat(664) = -rxt(378)*y(16)

         mat(934) = .310_r8*rxt(311)*y(59)
         mat(1126) = mat(1126) + rxt(299)*y(48)
         mat(1257) = .700_r8*rxt(275)*y(17) + rxt(291)*y(49)
         mat(1428) = mat(1428) + .900_r8*rxt(302)*y(48)
         mat(173) = .700_r8*rxt(275)*y(23)
         mat(577) = .310_r8*rxt(311)*y(1)
         mat(298) = rxt(291)*y(23)
         mat(777) = mat(777) + rxt(299)*y(9) + .900_r8*rxt(302)*y(16) &
                      + 4.000_r8*rxt(303)*y(48) + rxt(364)*y(88) + rxt(345)*y(79) &
                      + rxt(351)*y(76) + rxt(379)*y(91)
         mat(688) = mat(688) + rxt(364)*y(48)
         mat(709) = mat(709) + rxt(345)*y(48)
         mat(749) = mat(749) + rxt(351)*y(48)
         mat(664) = mat(664) + rxt(379)*y(48)

         mat(168) = -(rxt(275)*y(23))
         mat(1189) = -rxt(275)*y(17)

         mat(1391) = rxt(271)*y(24)
         mat(1329) = rxt(271)*y(16)

         mat(65) = -(rxt(159)*y(3) + rxt(177)*y(23))
         mat(974) = -rxt(159)*y(42)
         mat(1172) = -rxt(177)*y(42)

         mat(19) = -(rxt(178)*y(23))
         mat(1163) = -rxt(178)*y(43)

         mat(1317) = -(rxt(209)*y(28) + rxt(233)*y(37) + rxt(266)*y(11) + rxt(267) &
                      *y(23) + rxt(268)*y(2) + rxt(269)*y(24))
         mat(1027) = -rxt(209)*y(19)
         mat(889) = -rxt(233)*y(19)
         mat(1296) = -rxt(266)*y(19)
         mat(1255) = -rxt(267)*y(19)
         mat(969) = -rxt(268)*y(19)
         mat(1386) = -rxt(269)*y(19)

         mat(932) = .540_r8*rxt(311)*y(59) + .600_r8*rxt(357)*y(83) + rxt(290)*y(44) &
                      + .800_r8*rxt(333)*y(77) + .700_r8*rxt(339)*y(78)
         mat(1124) = rxt(270)*y(16) + rxt(318)*y(64) + .500_r8*rxt(331)*y(73) &
                      + .100_r8*rxt(372)*y(84) + .510_r8*rxt(359)*y(88) &
                      + .250_r8*rxt(340)*y(79) + rxt(347)*y(76) + .500_r8*rxt(286) &
                      *y(55) + rxt(322)*y(67) + .072_r8*rxt(365)*y(89)
         mat(1255) = mat(1255) + .300_r8*rxt(275)*y(17) + .500_r8*rxt(304)*y(54) &
                      + rxt(309)*y(58) + .500_r8*rxt(355)*y(81) + rxt(274)*y(18) &
                      + .800_r8*rxt(305)*y(52)
         mat(1296) = mat(1296) + .600_r8*rxt(360)*y(88) + .250_r8*rxt(342)*y(79) &
                      + rxt(348)*y(76) + .072_r8*rxt(366)*y(89)
         mat(1426) = rxt(270)*y(9) + (4.000_r8*rxt(272)+2.000_r8*rxt(273))*y(16) &
                      + rxt(215)*y(30) + rxt(302)*y(48) + 1.200_r8*rxt(363)*y(88) &
                      + .880_r8*rxt(344)*y(79) + 2.000_r8*rxt(350)*y(76) &
                      + .700_r8*rxt(294)*y(46) + rxt(315)*y(61) + .800_r8*rxt(324) &
                      *y(67) + .700_r8*rxt(378)*y(91)
         mat(172) = .300_r8*rxt(275)*y(23)
         mat(1386) = mat(1386) + .008_r8*rxt(367)*y(89)
         mat(868) = rxt(215)*y(16)
         mat(575) = .540_r8*rxt(311)*y(1)
         mat(481) = .600_r8*rxt(357)*y(1)
         mat(433) = rxt(318)*y(9)
         mat(775) = rxt(302)*y(16) + .600_r8*rxt(364)*y(88) + .250_r8*rxt(345)*y(79) &
                      + rxt(351)*y(76)
         mat(216) = .500_r8*rxt(304)*y(23)
         mat(203) = rxt(309)*y(23)
         mat(264) = rxt(290)*y(1)
         mat(229) = .500_r8*rxt(355)*y(23)
         mat(116) = .500_r8*rxt(331)*y(9)
         mat(361) = .100_r8*rxt(372)*y(9)
         mat(686) = .510_r8*rxt(359)*y(9) + .600_r8*rxt(360)*y(11) + 1.200_r8*rxt(363) &
                      *y(16) + .600_r8*rxt(364)*y(48)
         mat(728) = .800_r8*rxt(333)*y(1)
         mat(622) = .700_r8*rxt(339)*y(1)
         mat(707) = .250_r8*rxt(340)*y(9) + .250_r8*rxt(342)*y(11) + .880_r8*rxt(344) &
                      *y(16) + .250_r8*rxt(345)*y(48)
         mat(747) = rxt(347)*y(9) + rxt(348)*y(11) + 2.000_r8*rxt(350)*y(16) &
                      + rxt(351)*y(48) + 4.000_r8*rxt(352)*y(76)
         mat(451) = .700_r8*rxt(294)*y(16)
         mat(509) = rxt(315)*y(16)
         mat(256) = rxt(274)*y(23)
         mat(496) = .800_r8*rxt(305)*y(23)
         mat(386) = .500_r8*rxt(286)*y(9)
         mat(609) = rxt(322)*y(9) + .800_r8*rxt(324)*y(16)
         mat(558) = .072_r8*rxt(365)*y(9) + .072_r8*rxt(366)*y(11) + .008_r8*rxt(367) &
                      *y(24)
         mat(662) = .700_r8*rxt(378)*y(16)

         mat(1038) = -(rxt(160)*y(4) + rxt(161)*y(1) + (rxt(162) + rxt(163) + rxt(164) &
                      ) * y(24))
         mat(813) = -rxt(160)*y(22)
         mat(926) = -rxt(161)*y(22)
         mat(1380) = -(rxt(162) + rxt(163) + rxt(164)) * y(22)

         mat(963) = rxt(172)*y(21) + rxt(165)*y(23)
         mat(987) = rxt(156)*y(21)
         mat(632) = rxt(172)*y(2) + rxt(156)*y(3) + rxt(170)*y(23) + rxt(205)*y(28) &
                      + rxt(248)*y(135)
         mat(579) = rxt(264)*y(23)
         mat(464) = rxt(181)*y(23)
         mat(1249) = rxt(165)*y(2) + rxt(170)*y(21) + rxt(264)*y(20) + rxt(181)*y(8) &
                      + rxt(267)*y(19)
         mat(1311) = rxt(267)*y(23)
         mat(1021) = rxt(205)*y(21)
         mat(393) = rxt(248)*y(21)

         mat(1387) = -((rxt(162) + rxt(163) + rxt(164)) * y(22) + rxt(167)*y(23) &
                      + rxt(173)*y(2) + rxt(174)*y(1) + 4._r8*rxt(175)*y(24) + rxt(188) &
                      *y(9) + rxt(200)*y(11) + rxt(201)*y(10) + (rxt(207) + rxt(208) &
                      ) * y(28) + rxt(214)*y(30) + rxt(232)*y(37) + rxt(236)*y(38) &
                      + rxt(269)*y(19) + rxt(271)*y(16) + rxt(279)*y(131) + rxt(287) &
                      *y(55) + rxt(293)*y(46) + rxt(301)*y(48) + rxt(314)*y(61) &
                      + rxt(319)*y(64) + rxt(323)*y(67) + rxt(336)*y(74) + rxt(343) &
                      *y(79) + rxt(349)*y(76) + rxt(361)*y(88) + rxt(367)*y(89) &
                      + rxt(373)*y(84) + rxt(377)*y(91) + rxt(384)*y(96) + rxt(392) &
                      *y(100))
         mat(1045) = -(rxt(162) + rxt(163) + rxt(164)) * y(24)
         mat(1256) = -rxt(167)*y(24)
         mat(970) = -rxt(173)*y(24)
         mat(933) = -rxt(174)*y(24)
         mat(1125) = -rxt(188)*y(24)
         mat(1297) = -rxt(200)*y(24)
         mat(1160) = -rxt(201)*y(24)
         mat(1028) = -(rxt(207) + rxt(208)) * y(24)
         mat(869) = -rxt(214)*y(24)
         mat(890) = -rxt(232)*y(24)
         mat(795) = -rxt(236)*y(24)
         mat(1318) = -rxt(269)*y(24)
         mat(1427) = -rxt(271)*y(24)
         mat(167) = -rxt(279)*y(24)
         mat(387) = -rxt(287)*y(24)
         mat(452) = -rxt(293)*y(24)
         mat(776) = -rxt(301)*y(24)
         mat(510) = -rxt(314)*y(24)
         mat(434) = -rxt(319)*y(24)
         mat(610) = -rxt(323)*y(24)
         mat(331) = -rxt(336)*y(24)
         mat(708) = -rxt(343)*y(24)
         mat(748) = -rxt(349)*y(24)
         mat(687) = -rxt(361)*y(24)
         mat(559) = -rxt(367)*y(24)
         mat(362) = -rxt(373)*y(24)
         mat(663) = -rxt(377)*y(24)
         mat(239) = -rxt(384)*y(24)
         mat(532) = -rxt(392)*y(24)

         mat(933) = mat(933) + rxt(166)*y(23) + .190_r8*rxt(311)*y(59) &
                      + .060_r8*rxt(357)*y(83) + .120_r8*rxt(290)*y(44) &
                      + .060_r8*rxt(333)*y(77) + .275_r8*rxt(339)*y(78) + rxt(389) &
                      *y(99)
         mat(970) = mat(970) + rxt(268)*y(19) + rxt(176)*y(25)
         mat(818) = rxt(160)*y(22) + rxt(288)*y(56)
         mat(581) = rxt(265)*y(23)
         mat(1125) = mat(1125) + rxt(270)*y(16) + rxt(318)*y(64) + rxt(331)*y(73) &
                      + .900_r8*rxt(372)*y(84) + .900_r8*rxt(383)*y(96) + rxt(391) &
                      *y(100) + rxt(359)*y(88) + .470_r8*rxt(340)*y(79) + rxt(292) &
                      *y(46) + rxt(313)*y(61) + .250_r8*rxt(286)*y(55) &
                      + .794_r8*rxt(365)*y(89) + rxt(375)*y(91) + rxt(278)*y(131)
         mat(1160) = mat(1160) + .700_r8*rxt(387)*y(98)
         mat(1256) = mat(1256) + rxt(166)*y(1) + rxt(265)*y(20) + rxt(199)*y(11) &
                      + rxt(177)*y(42) + rxt(178)*y(43) + rxt(171)*y(25) + rxt(212) &
                      *y(30) + rxt(235)*y(38) + .500_r8*rxt(355)*y(81) &
                      + .250_r8*rxt(382)*y(94) + rxt(306)*y(53) + .200_r8*rxt(346) &
                      *y(80) + rxt(274)*y(18) + rxt(307)*y(51) + rxt(305)*y(52) &
                      + rxt(326)*y(66) + rxt(369)*y(90) + .350_r8*rxt(283)*y(129) &
                      + rxt(276)*y(130) + .500_r8*rxt(400)*y(142)
         mat(1297) = mat(1297) + rxt(199)*y(23) + rxt(266)*y(19) + rxt(360)*y(88) &
                      + .470_r8*rxt(342)*y(79) + .794_r8*rxt(366)*y(89) + rxt(370) &
                      *y(90) + rxt(376)*y(91)
         mat(1427) = mat(1427) + rxt(270)*y(9) + 4.000_r8*rxt(272)*y(16) + rxt(215) &
                      *y(30) + .900_r8*rxt(302)*y(48) + rxt(363)*y(88) &
                      + .730_r8*rxt(344)*y(79) + rxt(350)*y(76) + rxt(294)*y(46) &
                      + rxt(315)*y(61) + .300_r8*rxt(324)*y(67) + .800_r8*rxt(378) &
                      *y(91)
         mat(68) = rxt(177)*y(23)
         mat(21) = rxt(178)*y(23)
         mat(1318) = mat(1318) + rxt(268)*y(2) + rxt(266)*y(11) + rxt(209)*y(28) &
                      + rxt(233)*y(37)
         mat(1045) = mat(1045) + rxt(160)*y(4)
         mat(1387) = mat(1387) + .794_r8*rxt(367)*y(89)
         mat(312) = rxt(176)*y(2) + rxt(171)*y(23) + rxt(206)*y(28)
         mat(1028) = mat(1028) + rxt(209)*y(19) + rxt(206)*y(25)
         mat(869) = mat(869) + rxt(212)*y(23) + rxt(215)*y(16)
         mat(890) = mat(890) + rxt(233)*y(19)
         mat(795) = mat(795) + rxt(235)*y(23)
         mat(576) = .190_r8*rxt(311)*y(1)
         mat(482) = .060_r8*rxt(357)*y(1)
         mat(434) = mat(434) + rxt(318)*y(9)
         mat(776) = mat(776) + .900_r8*rxt(302)*y(16) + rxt(364)*y(88) &
                      + .470_r8*rxt(345)*y(79) + rxt(379)*y(91)
         mat(265) = .120_r8*rxt(290)*y(1)
         mat(230) = .500_r8*rxt(355)*y(23)
         mat(117) = rxt(331)*y(9)
         mat(362) = mat(362) + .900_r8*rxt(372)*y(9)
         mat(48) = .250_r8*rxt(382)*y(23)
         mat(239) = mat(239) + .900_r8*rxt(383)*y(9)
         mat(72) = .700_r8*rxt(387)*y(10)
         mat(532) = mat(532) + rxt(391)*y(9)
         mat(347) = rxt(306)*y(23)
         mat(687) = mat(687) + rxt(359)*y(9) + rxt(360)*y(11) + rxt(363)*y(16) &
                      + rxt(364)*y(48)
         mat(729) = .060_r8*rxt(333)*y(1)
         mat(623) = .275_r8*rxt(339)*y(1)
         mat(708) = mat(708) + .470_r8*rxt(340)*y(9) + .470_r8*rxt(342)*y(11) &
                      + .730_r8*rxt(344)*y(16) + .470_r8*rxt(345)*y(48)
         mat(127) = .200_r8*rxt(346)*y(23)
         mat(748) = mat(748) + rxt(350)*y(16)
         mat(452) = mat(452) + rxt(292)*y(9) + rxt(294)*y(16) + 2.400_r8*rxt(295) &
                      *y(46)
         mat(294) = rxt(389)*y(1)
         mat(510) = mat(510) + rxt(313)*y(9) + rxt(315)*y(16)
         mat(257) = rxt(274)*y(23)
         mat(92) = rxt(307)*y(23)
         mat(497) = rxt(305)*y(23)
         mat(597) = rxt(326)*y(23)
         mat(387) = mat(387) + .250_r8*rxt(286)*y(9)
         mat(183) = rxt(288)*y(4)
         mat(610) = mat(610) + .300_r8*rxt(324)*y(16)
         mat(559) = mat(559) + .794_r8*rxt(365)*y(9) + .794_r8*rxt(366)*y(11) &
                      + .794_r8*rxt(367)*y(24)
         mat(520) = rxt(369)*y(23) + rxt(370)*y(11)
         mat(663) = mat(663) + rxt(375)*y(9) + rxt(376)*y(11) + .800_r8*rxt(378)*y(16) &
                      + rxt(379)*y(48)
         mat(104) = .350_r8*rxt(283)*y(23)
         mat(269) = rxt(276)*y(23)
         mat(167) = mat(167) + rxt(278)*y(9)
         mat(88) = .500_r8*rxt(400)*y(23)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(306) = -(rxt(171)*y(23) + rxt(176)*y(2) + rxt(206)*y(28))
         mat(1205) = -rxt(171)*y(25)
         mat(941) = -rxt(176)*y(25)
         mat(1001) = -rxt(206)*y(25)

         mat(1205) = mat(1205) + 2.000_r8*rxt(169)*y(23)
         mat(1340) = 2.000_r8*rxt(175)*y(24)

         mat(822) = -(rxt(131)*y(3) + rxt(247)*y(135))
         mat(980) = -rxt(131)*y(128)
         mat(391) = -rxt(247)*y(128)

         mat(627) = rxt(170)*y(23)
         mat(1241) = rxt(170)*y(21) + 2.000_r8*rxt(168)*y(23) + rxt(196)*y(12) &
                      + rxt(202)*y(13) + rxt(275)*y(17) + rxt(267)*y(19) + rxt(167) &
                      *y(24) + rxt(171)*y(25) + rxt(223)*y(33) + rxt(227)*y(34) &
                      + rxt(243)*y(39) + rxt(297)*y(50) + rxt(291)*y(49) + rxt(320) &
                      *y(65) + rxt(304)*y(54) + rxt(284)*y(45) + .500_r8*rxt(338) &
                      *y(78) + rxt(317)*y(60) + rxt(316)*y(62) + rxt(321)*y(63) &
                      + rxt(325)*y(69) + rxt(327)*y(68) + (rxt(380)+rxt(381))*y(92) &
                      + rxt(276)*y(130) + rxt(402)*y(144)
         mat(835) = rxt(196)*y(23)
         mat(207) = rxt(202)*y(23)
         mat(169) = rxt(275)*y(23)
         mat(1304) = rxt(267)*y(23)
         mat(1032) = rxt(164)*y(24)
         mat(1372) = rxt(167)*y(23) + rxt(164)*y(22)
         mat(307) = rxt(171)*y(23)
         mat(1054) = rxt(223)*y(23) + (rxt(426)+rxt(431)+rxt(437))*y(34) + (rxt(427) &
                       +rxt(438))*y(40)
         mat(486) = rxt(227)*y(23) + (rxt(426)+rxt(431)+rxt(437))*y(33)
         mat(436) = rxt(243)*y(23)
         mat(372) = (rxt(427)+rxt(438))*y(33)
         mat(585) = rxt(297)*y(23)
         mat(296) = rxt(291)*y(23)
         mat(282) = rxt(320)*y(23)
         mat(214) = rxt(304)*y(23)
         mat(95) = rxt(284)*y(23)
         mat(618) = .500_r8*rxt(338)*y(23)
         mat(36) = rxt(317)*y(23)
         mat(153) = rxt(316)*y(23)
         mat(366) = rxt(321)*y(23)
         mat(159) = rxt(325)*y(23)
         mat(640) = rxt(327)*y(23)
         mat(135) = (rxt(380)+rxt(381))*y(23)
         mat(267) = rxt(276)*y(23)
         mat(32) = rxt(402)*y(23)

         mat(1020) = -(rxt(204)*y(1) + rxt(205)*y(21) + rxt(206)*y(25) + (rxt(207) &
                      + rxt(208)) * y(24) + rxt(209)*y(19) + rxt(226)*y(34) + rxt(230) &
                      *y(35) + rxt(282)*y(45))
         mat(925) = -rxt(204)*y(28)
         mat(631) = -rxt(205)*y(28)
         mat(309) = -rxt(206)*y(28)
         mat(1379) = -(rxt(207) + rxt(208)) * y(28)
         mat(1310) = -rxt(209)*y(28)
         mat(489) = -rxt(226)*y(28)
         mat(541) = -rxt(230)*y(28)
         mat(96) = -rxt(282)*y(28)

         mat(962) = rxt(211)*y(30) + rxt(224)*y(33)
         mat(986) = rxt(157)*y(33) + rxt(152)*y(133)
         mat(1117) = rxt(216)*y(30)
         mat(1248) = rxt(212)*y(30) + rxt(223)*y(33)
         mat(1419) = rxt(215)*y(30)
         mat(861) = rxt(211)*y(2) + rxt(216)*y(9) + rxt(212)*y(23) + rxt(215)*y(16) + ( &
                      + 4.000_r8*rxt(218)+2.000_r8*rxt(220))*y(30) + rxt(240)*y(38)
         mat(1061) = rxt(224)*y(2) + rxt(157)*y(3) + rxt(223)*y(23)
         mat(789) = rxt(240)*y(30)
         mat(76) = rxt(152)*y(3)


         mat(996) = rxt(230)*y(35)
         mat(848) = 2.000_r8*rxt(219)*y(30)
         mat(1047) = (rxt(426)+rxt(431)+rxt(437))*y(34) + (rxt(425)+rxt(430)+rxt(436)) &
                      *y(35)
         mat(484) = (rxt(426)+rxt(431)+rxt(437))*y(33)
         mat(534) = rxt(230)*y(28) + (rxt(425)+rxt(430)+rxt(436))*y(33)

         mat(856) = -(rxt(211)*y(2) + (rxt(212) + rxt(213)) * y(23) + rxt(214)*y(24) &
                      + rxt(215)*y(16) + rxt(216)*y(9) + rxt(217)*y(10) + (4._r8*rxt(218) &
                      + 4._r8*rxt(219) + 4._r8*rxt(220) + 4._r8*rxt(221)) * y(30) &
                      + (rxt(239) + rxt(240) + rxt(241)) * y(38))
         mat(957) = -rxt(211)*y(30)
         mat(1243) = -(rxt(212) + rxt(213)) * y(30)
         mat(1374) = -rxt(214)*y(30)
         mat(1414) = -rxt(215)*y(30)
         mat(1112) = -rxt(216)*y(30)
         mat(1147) = -rxt(217)*y(30)
         mat(786) = -(rxt(239) + rxt(240) + rxt(241)) * y(30)

         mat(920) = rxt(204)*y(28)
         mat(957) = mat(957) + rxt(225)*y(34) + rxt(228)*y(35)
         mat(1243) = mat(1243) + rxt(227)*y(34)
         mat(1374) = mat(1374) + rxt(208)*y(28)
         mat(1015) = rxt(204)*y(1) + rxt(208)*y(24) + rxt(226)*y(34)
         mat(487) = rxt(225)*y(2) + rxt(227)*y(23) + rxt(226)*y(28)
         mat(539) = rxt(228)*y(2)


         mat(847) = 2.000_r8*rxt(220)*y(30) + rxt(239)*y(38)
         mat(778) = rxt(239)*y(30)


         mat(846) = 2.000_r8*rxt(221)*y(30)

         mat(1063) = -(rxt(157)*y(3) + rxt(223)*y(23) + rxt(224)*y(2) + (rxt(425) &
                      + rxt(430) + rxt(436)) * y(35) + (rxt(426) + rxt(431) + rxt(437) &
                      ) * y(34) + (rxt(427) + rxt(438)) * y(40))
         mat(988) = -rxt(157)*y(33)
         mat(1250) = -rxt(223)*y(33)
         mat(964) = -rxt(224)*y(33)
         mat(542) = -(rxt(425) + rxt(430) + rxt(436)) * y(33)
         mat(490) = -(rxt(426) + rxt(431) + rxt(437)) * y(33)
         mat(376) = -(rxt(427) + rxt(438)) * y(33)

         mat(633) = rxt(205)*y(28)
         mat(1250) = mat(1250) + rxt(213)*y(30)
         mat(1312) = rxt(209)*y(28)
         mat(1381) = rxt(207)*y(28)
         mat(310) = rxt(206)*y(28)
         mat(1022) = rxt(205)*y(21) + rxt(209)*y(19) + rxt(207)*y(24) + rxt(206)*y(25) &
                      + rxt(226)*y(34) + rxt(282)*y(45)
         mat(863) = rxt(213)*y(23)
         mat(490) = mat(490) + rxt(226)*y(28)
         mat(97) = rxt(282)*y(28)

         mat(485) = -(rxt(225)*y(2) + rxt(226)*y(28) + rxt(227)*y(23) + (rxt(426) &
                      + rxt(431) + rxt(437)) * y(33))
         mat(949) = -rxt(225)*y(34)
         mat(1005) = -rxt(226)*y(34)
         mat(1218) = -rxt(227)*y(34)
         mat(1050) = -(rxt(426) + rxt(431) + rxt(437)) * y(34)

         mat(1218) = mat(1218) + rxt(229)*y(35)
         mat(1351) = rxt(214)*y(30)
         mat(850) = rxt(214)*y(24)
         mat(535) = rxt(229)*y(23)

         mat(536) = -(rxt(228)*y(2) + rxt(229)*y(23) + rxt(230)*y(28) + (rxt(425) &
                      + rxt(430) + rxt(436)) * y(33))
         mat(950) = -rxt(228)*y(35)
         mat(1223) = -rxt(229)*y(35)
         mat(1007) = -rxt(230)*y(35)
         mat(1051) = -(rxt(425) + rxt(430) + rxt(436)) * y(35)

         mat(1137) = rxt(217)*y(30)
         mat(851) = rxt(217)*y(10)


         mat(849) = rxt(241)*y(38)
         mat(1048) = (rxt(427)+rxt(438))*y(40)
         mat(779) = rxt(241)*y(30)
         mat(369) = (rxt(427)+rxt(438))*y(33)

         mat(878) = -(rxt(231)*y(1) + rxt(232)*y(24) + rxt(233)*y(19))
         mat(921) = -rxt(231)*y(37)
         mat(1375) = -rxt(232)*y(37)
         mat(1306) = -rxt(233)*y(37)

         mat(958) = rxt(234)*y(38) + rxt(244)*y(39)
         mat(982) = rxt(158)*y(39)
         mat(1113) = rxt(237)*y(38)
         mat(1244) = rxt(235)*y(38) + rxt(243)*y(39)
         mat(857) = (rxt(239)+rxt(240))*y(38)
         mat(787) = rxt(234)*y(2) + rxt(237)*y(9) + rxt(235)*y(23) + (rxt(239) &
                       +rxt(240))*y(30) + 4.000_r8*rxt(242)*y(38)
         mat(437) = rxt(244)*y(2) + rxt(158)*y(3) + rxt(243)*y(23)

         mat(782) = -(rxt(234)*y(2) + rxt(235)*y(23) + rxt(236)*y(24) + rxt(237)*y(9) &
                      + rxt(238)*y(10) + (rxt(239) + rxt(240) + rxt(241)) * y(30) &
                      + 4._r8*rxt(242)*y(38))
         mat(953) = -rxt(234)*y(38)
         mat(1239) = -rxt(235)*y(38)
         mat(1370) = -rxt(236)*y(38)
         mat(1108) = -rxt(237)*y(38)
         mat(1143) = -rxt(238)*y(38)
         mat(852) = -(rxt(239) + rxt(240) + rxt(241)) * y(38)

         mat(916) = rxt(231)*y(37)
         mat(953) = mat(953) + rxt(245)*y(40) + rxt(246)*y(41)
         mat(873) = rxt(231)*y(1)
         mat(371) = rxt(245)*y(2)
         mat(248) = rxt(246)*y(2)

         mat(435) = -(rxt(158)*y(3) + rxt(243)*y(23) + rxt(244)*y(2))
         mat(977) = -rxt(158)*y(39)
         mat(1214) = -rxt(243)*y(39)
         mat(947) = -rxt(244)*y(39)

         mat(1301) = rxt(233)*y(37)
         mat(1349) = rxt(232)*y(37)
         mat(871) = rxt(233)*y(19) + rxt(232)*y(24)

         mat(370) = -(rxt(245)*y(2) + (rxt(427) + rxt(438)) * y(33))
         mat(943) = -rxt(245)*y(40)
         mat(1049) = -(rxt(427) + rxt(438)) * y(40)

         mat(1346) = rxt(236)*y(38)
         mat(781) = rxt(236)*y(24)

         mat(246) = -(rxt(246)*y(2))
         mat(939) = -rxt(246)*y(41)

         mat(1133) = rxt(238)*y(38)
         mat(780) = rxt(238)*y(10)

         mat(334) = -((rxt(441) + rxt(442)) * y(2) + rxt(449)*y(4) + rxt(453)*y(126))
         mat(942) = -(rxt(441) + rxt(442)) * y(121)
         mat(802) = -rxt(449)*y(121)
         mat(414) = -rxt(453)*y(121)

         mat(397) = -(rxt(444)*y(8) + rxt(445)*y(9) + rxt(452)*y(126))
         mat(456) = -rxt(444)*y(122)
         mat(1085) = -rxt(445)*y(122)
         mat(415) = -rxt(452)*y(122)

         mat(803) = rxt(449)*y(121) + rxt(446)*y(123) + rxt(439)*y(124)
         mat(335) = rxt(449)*y(4)
         mat(186) = rxt(446)*y(4)
         mat(300) = rxt(439)*y(4)

         mat(184) = -((rxt(446) + rxt(447)) * y(4) + rxt(448)*y(2))
         mat(799) = -(rxt(446) + rxt(447)) * y(123)
         mat(937) = -rxt(448)*y(123)

         mat(299) = -(rxt(439)*y(4))
         mat(801) = -rxt(439)*y(124)

         mat(940) = rxt(442)*y(121) + rxt(448)*y(123)
         mat(333) = rxt(442)*y(2)
         mat(185) = rxt(448)*y(2)

         mat(406) = -(rxt(451)*y(126))
         mat(416) = -rxt(451)*y(125)

         mat(945) = rxt(441)*y(121)
         mat(804) = rxt(447)*y(123)
         mat(457) = rxt(444)*y(122)
         mat(1086) = rxt(445)*y(122)
         mat(336) = rxt(441)*y(2)
         mat(398) = rxt(444)*y(8) + rxt(445)*y(9)
         mat(187) = rxt(447)*y(4)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(218) = -(rxt(179)*y(4) + rxt(180)*y(2))
         mat(800) = -rxt(179)*y(127)
         mat(938) = -rxt(180)*y(127)

         mat(938) = mat(938) + rxt(441)*y(121)
         mat(332) = rxt(441)*y(2) + .900_r8*rxt(453)*y(126)
         mat(405) = .800_r8*rxt(451)*y(126)
         mat(413) = .900_r8*rxt(453)*y(121) + .800_r8*rxt(451)*y(125)

         mat(417) = -(rxt(451)*y(125) + rxt(452)*y(122) + rxt(453)*y(121))
         mat(407) = -rxt(451)*y(126)
         mat(399) = -rxt(452)*y(126)
         mat(337) = -rxt(453)*y(126)

         mat(563) = -(rxt(310)*y(23) + rxt(311)*y(1) + rxt(312)*y(11))
         mat(1225) = -rxt(310)*y(59)
         mat(903) = -rxt(311)*y(59)
         mat(1270) = -rxt(312)*y(59)

         mat(903) = mat(903) + .070_r8*rxt(357)*y(83)
         mat(471) = .070_r8*rxt(357)*y(1)

         mat(469) = -(rxt(356)*y(23) + rxt(357)*y(1) + rxt(358)*y(11))
         mat(1217) = -rxt(356)*y(83)
         mat(899) = -rxt(357)*y(83)
         mat(1265) = -rxt(358)*y(83)

         mat(425) = -(rxt(318)*y(9) + rxt(319)*y(24))
         mat(1088) = -rxt(318)*y(64)
         mat(1348) = -rxt(319)*y(64)

         mat(1213) = rxt(310)*y(59) + .500_r8*rxt(320)*y(65)
         mat(562) = rxt(310)*y(23)
         mat(279) = .500_r8*rxt(320)*y(23)

         mat(583) = -(rxt(297)*y(23) + rxt(298)*y(11))
         mat(1227) = -rxt(297)*y(50)
         mat(1272) = -rxt(298)*y(50)

         mat(905) = .500_r8*rxt(311)*y(59) + .040_r8*rxt(333)*y(77)
         mat(1097) = rxt(318)*y(64) + rxt(331)*y(73) + .400_r8*rxt(372)*y(84) &
                      + rxt(335)*y(74) + rxt(292)*y(46) + .270_r8*rxt(313)*y(61)
         mat(1227) = mat(1227) + .500_r8*rxt(296)*y(47) + rxt(307)*y(51)
         mat(1400) = .800_r8*rxt(294)*y(46)
         mat(565) = .500_r8*rxt(311)*y(1)
         mat(426) = rxt(318)*y(9)
         mat(113) = rxt(331)*y(9)
         mat(355) = .400_r8*rxt(372)*y(9)
         mat(326) = rxt(335)*y(9)
         mat(712) = .040_r8*rxt(333)*y(1)
         mat(446) = rxt(292)*y(9) + .800_r8*rxt(294)*y(16) + 3.200_r8*rxt(295)*y(46)
         mat(130) = .500_r8*rxt(296)*y(23)
         mat(501) = .270_r8*rxt(313)*y(9)
         mat(90) = rxt(307)*y(23)

         mat(295) = -(rxt(291)*y(23))
         mat(1204) = -rxt(291)*y(49)

         mat(897) = .250_r8*rxt(311)*y(59) + .200_r8*rxt(357)*y(83)
         mat(1393) = .100_r8*rxt(302)*y(48)
         mat(1339) = .250_r8*rxt(301)*y(48) + .250_r8*rxt(349)*y(76)
         mat(561) = .250_r8*rxt(311)*y(1)
         mat(468) = .200_r8*rxt(357)*y(1)
         mat(753) = .100_r8*rxt(302)*y(16) + .250_r8*rxt(301)*y(24)
         mat(733) = .250_r8*rxt(349)*y(24)

         mat(278) = -(rxt(320)*y(23))
         mat(1202) = -rxt(320)*y(65)

         mat(1338) = rxt(319)*y(64)
         mat(424) = rxt(319)*y(24)

         mat(765) = -(rxt(299)*y(9) + rxt(300)*y(10) + rxt(301)*y(24) + rxt(302)*y(16) &
                      + 4._r8*rxt(303)*y(48) + rxt(345)*y(79) + rxt(364)*y(88) + rxt(379) &
                      *y(91))
         mat(1107) = -rxt(299)*y(48)
         mat(1142) = -rxt(300)*y(48)
         mat(1369) = -rxt(301)*y(48)
         mat(1410) = -rxt(302)*y(48)
         mat(699) = -rxt(345)*y(48)
         mat(677) = -rxt(364)*y(48)
         mat(654) = -rxt(379)*y(48)

         mat(1107) = mat(1107) + rxt(335)*y(74) + .530_r8*rxt(340)*y(79) + rxt(347) &
                      *y(76) + rxt(322)*y(67)
         mat(1238) = rxt(297)*y(50) + .500_r8*rxt(304)*y(54) + rxt(327)*y(68)
         mat(1282) = rxt(298)*y(50) + .530_r8*rxt(342)*y(79) + rxt(348)*y(76) &
                      + rxt(328)*y(68)
         mat(1410) = mat(1410) + .260_r8*rxt(344)*y(79) + rxt(350)*y(76) &
                      + .300_r8*rxt(324)*y(67)
         mat(584) = rxt(297)*y(23) + rxt(298)*y(11)
         mat(765) = mat(765) + .530_r8*rxt(345)*y(79)
         mat(213) = .500_r8*rxt(304)*y(23)
         mat(327) = rxt(335)*y(9)
         mat(699) = mat(699) + .530_r8*rxt(340)*y(9) + .530_r8*rxt(342)*y(11) &
                      + .260_r8*rxt(344)*y(16) + .530_r8*rxt(345)*y(48)
         mat(737) = rxt(347)*y(9) + rxt(348)*y(11) + rxt(350)*y(16) &
                      + 4.000_r8*rxt(352)*y(76)
         mat(603) = rxt(322)*y(9) + .300_r8*rxt(324)*y(16)
         mat(639) = rxt(327)*y(23) + rxt(328)*y(11)

         mat(212) = -(rxt(304)*y(23))
         mat(1194) = -rxt(304)*y(54)

         mat(1333) = .750_r8*rxt(301)*y(48) + .750_r8*rxt(349)*y(76)
         mat(752) = .750_r8*rxt(301)*y(24)
         mat(731) = .750_r8*rxt(349)*y(24)

         mat(198) = -(rxt(309)*y(23))
         mat(1192) = -rxt(309)*y(58)

         mat(1129) = rxt(300)*y(48)
         mat(751) = rxt(300)*y(10)

         mat(140) = -(rxt(329)*y(23))
         mat(1185) = -rxt(329)*y(82)

         mat(1073) = .100_r8*rxt(372)*y(84)
         mat(1262) = rxt(312)*y(59)
         mat(560) = rxt(312)*y(11)
         mat(348) = .100_r8*rxt(372)*y(9)

         mat(93) = -(rxt(282)*y(28) + rxt(284)*y(23))
         mat(997) = -rxt(282)*y(45)
         mat(1177) = -rxt(284)*y(45)

         mat(258) = -(rxt(281)*y(28) + rxt(285)*y(23) + rxt(290)*y(1))
         mat(999) = -rxt(281)*y(44)
         mat(1199) = -rxt(285)*y(44)
         mat(894) = -rxt(290)*y(44)

         mat(25) = -(rxt(368)*y(23))
         mat(1164) = -rxt(368)*y(71)

         mat(223) = -(rxt(355)*y(23))
         mat(1195) = -rxt(355)*y(81)

         mat(1131) = rxt(353)*y(76)
         mat(732) = rxt(353)*y(10)

         mat(28) = -(rxt(330)*y(23))
         mat(1165) = -rxt(330)*y(70)

         mat(111) = -(rxt(331)*y(9))
         mat(1071) = -rxt(331)*y(73)

         mat(1179) = rxt(330)*y(70)
         mat(29) = rxt(330)*y(23)

         mat(352) = -(rxt(372)*y(9) + rxt(373)*y(24))
         mat(1082) = -rxt(372)*y(84)
         mat(1344) = -rxt(373)*y(84)

         mat(1209) = rxt(368)*y(71) + rxt(374)*y(85)
         mat(26) = rxt(368)*y(23)
         mat(316) = rxt(374)*y(23)

         mat(314) = -(rxt(374)*y(23))
         mat(1206) = -rxt(374)*y(85)

         mat(1341) = rxt(373)*y(84)
         mat(350) = rxt(373)*y(24)

         mat(174) = -(rxt(334)*y(23))
         mat(1190) = -rxt(334)*y(72)

         mat(1075) = .800_r8*rxt(372)*y(84)
         mat(349) = .800_r8*rxt(372)*y(9)

         mat(325) = -(rxt(335)*y(9) + rxt(336)*y(24))
         mat(1080) = -rxt(335)*y(74)
         mat(1342) = -rxt(336)*y(74)

         mat(1207) = rxt(334)*y(72) + rxt(337)*y(75)
         mat(175) = rxt(334)*y(23)
         mat(119) = rxt(337)*y(23)

         mat(118) = -(rxt(337)*y(23))
         mat(1180) = -rxt(337)*y(75)

         mat(1321) = rxt(336)*y(74)
         mat(324) = rxt(336)*y(24)

         mat(44) = -(rxt(382)*y(23))
         mat(1169) = -rxt(382)*y(94)

         mat(49) = -(rxt(386)*y(23))
         mat(1170) = -rxt(386)*y(95)

         mat(1170) = mat(1170) + .250_r8*rxt(382)*y(94)
         mat(45) = .250_r8*rxt(382)*y(23)

         mat(232) = -(rxt(383)*y(9) + rxt(384)*y(24))
         mat(1077) = -rxt(383)*y(96)
         mat(1334) = -rxt(384)*y(96)

         mat(1196) = .700_r8*rxt(382)*y(94) + rxt(385)*y(97)
         mat(46) = .700_r8*rxt(382)*y(23)
         mat(145) = rxt(385)*y(23)

         mat(144) = -(rxt(385)*y(23))
         mat(1186) = -rxt(385)*y(97)

         mat(1325) = rxt(384)*y(96)
         mat(231) = rxt(384)*y(24)

         mat(69) = -(rxt(387)*y(10))
         mat(1127) = -rxt(387)*y(98)

         mat(1173) = rxt(386)*y(95)
         mat(50) = rxt(386)*y(23)

         mat(523) = -(rxt(391)*y(9) + rxt(392)*y(24))
         mat(1094) = -rxt(391)*y(100)
         mat(1355) = -rxt(392)*y(100)

         mat(1222) = rxt(393)*y(101) + rxt(388)*y(99)
         mat(1268) = rxt(390)*y(99)
         mat(193) = rxt(393)*y(23)
         mat(287) = rxt(388)*y(23) + rxt(390)*y(11)

         mat(191) = -(rxt(393)*y(23))
         mat(1191) = -rxt(393)*y(101)

         mat(1331) = rxt(392)*y(100)
         mat(521) = rxt(392)*y(24)


         mat(1078) = .900_r8*rxt(383)*y(96)
         mat(1132) = .700_r8*rxt(387)*y(98)
         mat(233) = .900_r8*rxt(383)*y(9)
         mat(70) = .700_r8*rxt(387)*y(10)

         mat(344) = -(rxt(306)*y(23))
         mat(1208) = -rxt(306)*y(53)

         mat(1081) = .450_r8*rxt(383)*y(96) + .250_r8*rxt(375)*y(91)
         mat(1208) = mat(1208) + .200_r8*rxt(305)*y(52) + .650_r8*rxt(283)*y(129)
         mat(1264) = .250_r8*rxt(376)*y(91)
         mat(1394) = .100_r8*rxt(378)*y(91)
         mat(754) = .250_r8*rxt(379)*y(91)
         mat(234) = .450_r8*rxt(383)*y(9)
         mat(492) = .200_r8*rxt(305)*y(23)
         mat(648) = .250_r8*rxt(375)*y(9) + .250_r8*rxt(376)*y(11) + .100_r8*rxt(378) &
                      *y(16) + .250_r8*rxt(379)*y(48)
         mat(101) = .650_r8*rxt(283)*y(23)

         mat(673) = -(rxt(359)*y(9) + rxt(360)*y(11) + rxt(361)*y(24) + rxt(363)*y(16) &
                      + rxt(364)*y(48))
         mat(1103) = -rxt(359)*y(88)
         mat(1278) = -rxt(360)*y(88)
         mat(1365) = -rxt(361)*y(88)
         mat(1406) = -rxt(363)*y(88)
         mat(761) = -rxt(364)*y(88)

         mat(1234) = rxt(356)*y(83) + .200_r8*rxt(362)*y(93)
         mat(474) = rxt(356)*y(23)
         mat(273) = .200_r8*rxt(362)*y(23)

         mat(716) = -(rxt(332)*y(23) + rxt(333)*y(1))
         mat(1236) = -rxt(332)*y(77)
         mat(913) = -rxt(333)*y(77)

         mat(913) = mat(913) + .200_r8*rxt(357)*y(83) + rxt(389)*y(99)
         mat(1105) = rxt(391)*y(100) + .320_r8*rxt(359)*y(88) + .039_r8*rxt(365)*y(89)
         mat(1280) = .350_r8*rxt(360)*y(88) + .039_r8*rxt(366)*y(89)
         mat(1408) = .260_r8*rxt(363)*y(88)
         mat(1367) = .039_r8*rxt(367)*y(89)
         mat(475) = .200_r8*rxt(357)*y(1)
         mat(763) = .350_r8*rxt(364)*y(88)
         mat(526) = rxt(391)*y(9)
         mat(675) = .320_r8*rxt(359)*y(9) + .350_r8*rxt(360)*y(11) + .260_r8*rxt(363) &
                      *y(16) + .350_r8*rxt(364)*y(48)
         mat(289) = rxt(389)*y(1)
         mat(552) = .039_r8*rxt(365)*y(9) + .039_r8*rxt(366)*y(11) + .039_r8*rxt(367) &
                      *y(24)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(613) = -(rxt(338)*y(23) + rxt(339)*y(1))
         mat(1230) = -rxt(338)*y(78)
         mat(908) = -rxt(339)*y(78)

         mat(908) = mat(908) + .400_r8*rxt(357)*y(83) + rxt(389)*y(99)
         mat(1100) = rxt(391)*y(100) + .230_r8*rxt(359)*y(88) + .167_r8*rxt(365)*y(89)
         mat(1275) = .250_r8*rxt(360)*y(88) + .167_r8*rxt(366)*y(89)
         mat(1403) = .190_r8*rxt(363)*y(88)
         mat(1361) = .167_r8*rxt(367)*y(89)
         mat(473) = .400_r8*rxt(357)*y(1)
         mat(758) = .250_r8*rxt(364)*y(88)
         mat(525) = rxt(391)*y(9)
         mat(670) = .230_r8*rxt(359)*y(9) + .250_r8*rxt(360)*y(11) + .190_r8*rxt(363) &
                      *y(16) + .250_r8*rxt(364)*y(48)
         mat(288) = rxt(389)*y(1)
         mat(550) = .167_r8*rxt(365)*y(9) + .167_r8*rxt(366)*y(11) + .167_r8*rxt(367) &
                      *y(24)

         mat(697) = -((rxt(340) + rxt(341)) * y(9) + rxt(342)*y(11) + rxt(343)*y(24) &
                      + rxt(344)*y(16) + rxt(345)*y(48))
         mat(1104) = -(rxt(340) + rxt(341)) * y(79)
         mat(1279) = -rxt(342)*y(79)
         mat(1366) = -rxt(343)*y(79)
         mat(1407) = -rxt(344)*y(79)
         mat(762) = -rxt(345)*y(79)

         mat(1235) = rxt(332)*y(77) + .500_r8*rxt(338)*y(78) + .200_r8*rxt(346)*y(80)
         mat(715) = rxt(332)*y(23)
         mat(615) = .500_r8*rxt(338)*y(23)
         mat(124) = .200_r8*rxt(346)*y(23)

         mat(123) = -(rxt(346)*y(23))
         mat(1181) = -rxt(346)*y(80)

         mat(1322) = rxt(343)*y(79)
         mat(689) = rxt(343)*y(24)

         mat(736) = -(rxt(347)*y(9) + rxt(348)*y(11) + rxt(349)*y(24) + rxt(350)*y(16) &
                      + rxt(351)*y(48) + 4._r8*rxt(352)*y(76) + rxt(353)*y(10))
         mat(1106) = -rxt(347)*y(76)
         mat(1281) = -rxt(348)*y(76)
         mat(1368) = -rxt(349)*y(76)
         mat(1409) = -rxt(350)*y(76)
         mat(764) = -rxt(351)*y(76)
         mat(1141) = -rxt(353)*y(76)

         mat(914) = .200_r8*rxt(357)*y(83)
         mat(1237) = .500_r8*rxt(338)*y(78) + .500_r8*rxt(346)*y(80)
         mat(476) = .200_r8*rxt(357)*y(1)
         mat(616) = .500_r8*rxt(338)*y(23)
         mat(125) = .500_r8*rxt(346)*y(23)

         mat(445) = -(rxt(292)*y(9) + rxt(293)*y(24) + rxt(294)*y(16) + 4._r8*rxt(295) &
                      *y(46))
         mat(1089) = -rxt(292)*y(46)
         mat(1350) = -rxt(293)*y(46)
         mat(1396) = -rxt(294)*y(46)

         mat(1215) = rxt(284)*y(45) + .500_r8*rxt(296)*y(47)
         mat(1004) = rxt(282)*y(45)
         mat(94) = rxt(284)*y(23) + rxt(282)*y(28)
         mat(129) = .500_r8*rxt(296)*y(23)

         mat(128) = -(rxt(296)*y(23))
         mat(1182) = -rxt(296)*y(47)

         mat(1323) = rxt(293)*y(46)
         mat(443) = rxt(293)*y(24)

         mat(286) = -(rxt(388)*y(23) + rxt(389)*y(1) + rxt(390)*y(11))
         mat(1203) = -rxt(388)*y(99)
         mat(896) = -rxt(389)*y(99)
         mat(1263) = -rxt(390)*y(99)

         mat(34) = -(rxt(317)*y(23))
         mat(1167) = -rxt(317)*y(60)

         mat(500) = -(rxt(313)*y(9) + rxt(314)*y(24) + rxt(315)*y(16))
         mat(1092) = -rxt(313)*y(61)
         mat(1353) = -rxt(314)*y(61)
         mat(1398) = -rxt(315)*y(61)

         mat(1220) = rxt(317)*y(60) + rxt(316)*y(62)
         mat(35) = rxt(317)*y(23)
         mat(152) = rxt(316)*y(23)

         mat(150) = -(rxt(316)*y(23))
         mat(1187) = -rxt(316)*y(62)

         mat(1326) = rxt(314)*y(61)
         mat(498) = rxt(314)*y(24)

         mat(363) = -(rxt(321)*y(23))
         mat(1210) = -rxt(321)*y(63)

         mat(1083) = .500_r8*rxt(331)*y(73) + .250_r8*rxt(372)*y(84) &
                      + .100_r8*rxt(391)*y(100) + .820_r8*rxt(313)*y(61)
         mat(1395) = .820_r8*rxt(315)*y(61)
         mat(112) = .500_r8*rxt(331)*y(9)
         mat(353) = .250_r8*rxt(372)*y(9)
         mat(522) = .100_r8*rxt(391)*y(9)
         mat(499) = .820_r8*rxt(313)*y(9) + .820_r8*rxt(315)*y(16)

         mat(156) = -(rxt(325)*y(23))
         mat(1188) = -rxt(325)*y(69)

         mat(1327) = rxt(323)*y(67)
         mat(598) = rxt(323)*y(24)

         mat(254) = -(rxt(274)*y(23))
         mat(1198) = -rxt(274)*y(18)

         mat(1392) = 2.000_r8*rxt(273)*y(16) + .250_r8*rxt(363)*y(88) &
                      + .250_r8*rxt(344)*y(79) + .300_r8*rxt(294)*y(46) &
                      + .500_r8*rxt(324)*y(67) + .300_r8*rxt(378)*y(91)
         mat(666) = .250_r8*rxt(363)*y(16)
         mat(690) = .250_r8*rxt(344)*y(16)
         mat(444) = .300_r8*rxt(294)*y(16)
         mat(599) = .500_r8*rxt(324)*y(16)
         mat(647) = .300_r8*rxt(378)*y(16)

         mat(89) = -(rxt(307)*y(23))
         mat(1176) = -rxt(307)*y(51)

         mat(1389) = .200_r8*rxt(294)*y(46)
         mat(442) = .200_r8*rxt(294)*y(16) + .800_r8*rxt(295)*y(46)

         mat(493) = -(rxt(305)*y(23))
         mat(1219) = -rxt(305)*y(52)

         mat(807) = rxt(288)*y(56)
         mat(1091) = .530_r8*rxt(340)*y(79) + .250_r8*rxt(375)*y(91)
         mat(1266) = .530_r8*rxt(342)*y(79) + .250_r8*rxt(376)*y(91)
         mat(1397) = .260_r8*rxt(344)*y(79) + .100_r8*rxt(378)*y(91)
         mat(755) = .530_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(691) = .530_r8*rxt(340)*y(9) + .530_r8*rxt(342)*y(11) + .260_r8*rxt(344) &
                      *y(16) + .530_r8*rxt(345)*y(48)
         mat(180) = rxt(288)*y(4)
         mat(649) = .250_r8*rxt(375)*y(9) + .250_r8*rxt(376)*y(11) + .100_r8*rxt(378) &
                      *y(16) + .250_r8*rxt(379)*y(48)

         mat(592) = -(rxt(326)*y(23))
         mat(1228) = -rxt(326)*y(66)

         mat(1098) = .220_r8*rxt(340)*y(79) + .250_r8*rxt(375)*y(91)
         mat(1228) = mat(1228) + .500_r8*rxt(320)*y(65) + .500_r8*rxt(355)*y(81)
         mat(1273) = .220_r8*rxt(342)*y(79) + .250_r8*rxt(376)*y(91)
         mat(1401) = .230_r8*rxt(344)*y(79) + .200_r8*rxt(324)*y(67) &
                      + .100_r8*rxt(378)*y(91)
         mat(281) = .500_r8*rxt(320)*y(23)
         mat(757) = .220_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(224) = .500_r8*rxt(355)*y(23)
         mat(694) = .220_r8*rxt(340)*y(9) + .220_r8*rxt(342)*y(11) + .230_r8*rxt(344) &
                      *y(16) + .220_r8*rxt(345)*y(48)
         mat(600) = .200_r8*rxt(324)*y(16)
         mat(651) = .250_r8*rxt(375)*y(9) + .250_r8*rxt(376)*y(11) + .100_r8*rxt(378) &
                      *y(16) + .250_r8*rxt(379)*y(48)

         mat(380) = -(rxt(286)*y(9) + rxt(287)*y(24))
         mat(1084) = -rxt(286)*y(55)
         mat(1347) = -rxt(287)*y(55)

         mat(1211) = rxt(285)*y(44)
         mat(260) = rxt(285)*y(23)

         mat(179) = -(rxt(288)*y(4))
         mat(798) = -rxt(288)*y(56)

         mat(1076) = .750_r8*rxt(286)*y(55)
         mat(379) = .750_r8*rxt(286)*y(9)


         mat(1320) = rxt(287)*y(55)
         mat(378) = rxt(287)*y(24)

         mat(137) = -(rxt(371)*y(23))
         mat(1184) = -rxt(371)*y(87)

         mat(1072) = .370_r8*rxt(359)*y(88)
         mat(1184) = mat(1184) + rxt(369)*y(90)
         mat(1261) = .400_r8*rxt(360)*y(88) + rxt(370)*y(90)
         mat(1390) = .300_r8*rxt(363)*y(88)
         mat(750) = .400_r8*rxt(364)*y(88)
         mat(665) = .370_r8*rxt(359)*y(9) + .400_r8*rxt(360)*y(11) + .300_r8*rxt(363) &
                      *y(16) + .400_r8*rxt(364)*y(48)
         mat(512) = rxt(369)*y(23) + rxt(370)*y(11)

         mat(601) = -(rxt(322)*y(9) + rxt(323)*y(24) + rxt(324)*y(16))
         mat(1099) = -rxt(322)*y(67)
         mat(1360) = -rxt(323)*y(67)
         mat(1402) = -rxt(324)*y(67)

         mat(1229) = rxt(321)*y(63) + rxt(325)*y(69)
         mat(364) = rxt(321)*y(23)
         mat(157) = rxt(325)*y(23)

         mat(638) = -(rxt(327)*y(23) + rxt(328)*y(11))
         mat(1232) = -rxt(327)*y(68)
         mat(1276) = -rxt(328)*y(68)

         mat(909) = .950_r8*rxt(333)*y(77) + .800_r8*rxt(339)*y(78)
         mat(1101) = .450_r8*rxt(383)*y(96) + .250_r8*rxt(340)*y(79) &
                      + .250_r8*rxt(375)*y(91)
         mat(1232) = mat(1232) + rxt(329)*y(82) + rxt(326)*y(66)
         mat(1276) = mat(1276) + .250_r8*rxt(342)*y(79) + .250_r8*rxt(376)*y(91)
         mat(1404) = .240_r8*rxt(344)*y(79) + .500_r8*rxt(324)*y(67) &
                      + .100_r8*rxt(378)*y(91)
         mat(759) = .250_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(141) = rxt(329)*y(23)
         mat(235) = .450_r8*rxt(383)*y(9)
         mat(714) = .950_r8*rxt(333)*y(1)
         mat(614) = .800_r8*rxt(339)*y(1)
         mat(695) = .250_r8*rxt(340)*y(9) + .250_r8*rxt(342)*y(11) + .240_r8*rxt(344) &
                      *y(16) + .250_r8*rxt(345)*y(48)
         mat(593) = rxt(326)*y(23)
         mat(602) = .500_r8*rxt(324)*y(16)
         mat(652) = .250_r8*rxt(375)*y(9) + .250_r8*rxt(376)*y(11) + .100_r8*rxt(378) &
                      *y(16) + .250_r8*rxt(379)*y(48)

         mat(548) = -(rxt(365)*y(9) + rxt(366)*y(11) + rxt(367)*y(24))
         mat(1095) = -rxt(365)*y(89)
         mat(1269) = -rxt(366)*y(89)
         mat(1356) = -rxt(367)*y(89)

         mat(1269) = mat(1269) + rxt(358)*y(83)
         mat(470) = rxt(358)*y(11)

         mat(513) = -(rxt(369)*y(23) + rxt(370)*y(11))
         mat(1221) = -rxt(369)*y(90)
         mat(1267) = -rxt(370)*y(90)

         mat(1093) = .080_r8*rxt(359)*y(88) + .800_r8*rxt(341)*y(79) &
                      + .794_r8*rxt(365)*y(89)
         mat(1267) = mat(1267) + .794_r8*rxt(366)*y(89)
         mat(1354) = .794_r8*rxt(367)*y(89)
         mat(668) = .080_r8*rxt(359)*y(9)
         mat(692) = .800_r8*rxt(341)*y(9)
         mat(547) = .794_r8*rxt(365)*y(9) + .794_r8*rxt(366)*y(11) + .794_r8*rxt(367) &
                      *y(24)

         mat(653) = -(rxt(375)*y(9) + rxt(376)*y(11) + rxt(377)*y(24) + rxt(378)*y(16) &
                      + rxt(379)*y(48))
         mat(1102) = -rxt(375)*y(91)
         mat(1277) = -rxt(376)*y(91)
         mat(1364) = -rxt(377)*y(91)
         mat(1405) = -rxt(378)*y(91)
         mat(760) = -rxt(379)*y(91)

         mat(1233) = rxt(371)*y(87) + rxt(380)*y(92) + .800_r8*rxt(362)*y(93)
         mat(138) = rxt(371)*y(23)
         mat(134) = rxt(380)*y(23)
         mat(272) = .800_r8*rxt(362)*y(23)


      end subroutine nlnmat06

      subroutine nlnmat07( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(133) = -((rxt(380) + rxt(381)) * y(23))
         mat(1183) = -(rxt(380) + rxt(381)) * y(92)

         mat(1324) = rxt(367)*y(89) + rxt(377)*y(91)
         mat(546) = rxt(367)*y(24)
         mat(646) = rxt(377)*y(24)

         mat(270) = -(rxt(362)*y(23))
         mat(1201) = -rxt(362)*y(93)

         mat(1337) = rxt(361)*y(88)
         mat(667) = rxt(361)*y(24)

         mat(99) = -(rxt(280)*y(28) + rxt(283)*y(23))
         mat(998) = -rxt(280)*y(129)
         mat(1178) = -rxt(283)*y(129)

         mat(266) = -(rxt(276)*y(23))
         mat(1200) = -rxt(276)*y(130)

         mat(895) = .500_r8*rxt(290)*y(44)
         mat(1079) = rxt(278)*y(131)
         mat(1200) = mat(1200) + .350_r8*rxt(283)*y(129)
         mat(1336) = rxt(279)*y(131)
         mat(259) = .500_r8*rxt(290)*y(1)
         mat(100) = .350_r8*rxt(283)*y(23)
         mat(163) = rxt(278)*y(9) + rxt(279)*y(24)

         mat(162) = -(rxt(278)*y(9) + rxt(279)*y(24))
         mat(1074) = -rxt(278)*y(131)
         mat(1328) = -rxt(279)*y(131)

         mat(1299) = rxt(269)*y(24)
         mat(1328) = mat(1328) + rxt(269)*y(19)

         mat(55) = -(rxt(151)*y(3))
         mat(972) = -rxt(151)*y(132)

         mat(73) = -(rxt(152)*y(3))
         mat(975) = -rxt(152)*y(133)


         mat(624) = rxt(248)*y(135)
         mat(832) = rxt(250)*y(135)
         mat(819) = rxt(247)*y(135)
         mat(388) = rxt(248)*y(21) + rxt(250)*y(12) + rxt(247)*y(128)

         mat(389) = -(rxt(247)*y(128) + rxt(248)*y(21) + rxt(250)*y(12))
         mat(820) = -rxt(247)*y(135)
         mat(625) = -rxt(248)*y(135)
         mat(833) = -rxt(250)*y(135)

         mat(976) = 2.000_r8*rxt(151)*y(132) + rxt(152)*y(133)
         mat(56) = 2.000_r8*rxt(151)*y(3)
         mat(74) = rxt(152)*y(3)

         mat(39) = -(rxt(398)*y(23))
         mat(1168) = -rxt(398)*y(141)

         mat(1168) = mat(1168) + (rxt(399)+.500_r8*rxt(400))*y(142)
         mat(1258) = rxt(401)*y(142)
         mat(83) = (rxt(399)+.500_r8*rxt(400))*y(23) + rxt(401)*y(11)

         mat(84) = -((rxt(399) + rxt(400)) * y(23) + rxt(401)*y(11))
         mat(1175) = -(rxt(399) + rxt(400)) * y(142)
         mat(1259) = -rxt(401)*y(142)


         mat(1162) = rxt(398)*y(141)
         mat(38) = rxt(398)*y(23)

         mat(31) = -(rxt(402)*y(23))
         mat(1166) = -rxt(402)*y(144)
      end subroutine nlnmat07
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = mat( 19) + lmat( 19)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = mat( 25) + lmat( 25)
         mat( 28) = mat( 28) + lmat( 28)
         mat( 31) = mat( 31) + lmat( 31)
         mat( 34) = mat( 34) + lmat( 34)
         mat( 39) = mat( 39) + lmat( 39)
         mat( 41) = lmat( 41)
         mat( 42) = lmat( 42)
         mat( 43) = lmat( 43)
         mat( 44) = mat( 44) + lmat( 44)
         mat( 49) = mat( 49) + lmat( 49)
         mat( 52) = lmat( 52)
         mat( 53) = lmat( 53)
         mat( 54) = lmat( 54)
         mat( 55) = mat( 55) + lmat( 55)
         mat( 56) = mat( 56) + lmat( 56)
         mat( 58) = mat( 58) + lmat( 58)
         mat( 59) = mat( 59) + lmat( 59)
         mat( 60) = mat( 60) + lmat( 60)
         mat( 61) = mat( 61) + lmat( 61)
         mat( 62) = lmat( 62)
         mat( 63) = lmat( 63)
         mat( 64) = lmat( 64)
         mat( 65) = mat( 65) + lmat( 65)
         mat( 69) = mat( 69) + lmat( 69)
         mat( 73) = mat( 73) + lmat( 73)
         mat( 74) = mat( 74) + lmat( 74)
         mat( 76) = mat( 76) + lmat( 76)
         mat( 77) = lmat( 77)
         mat( 78) = lmat( 78)
         mat( 79) = lmat( 79)
         mat( 80) = lmat( 80)
         mat( 81) = lmat( 81)
         mat( 82) = lmat( 82)
         mat( 84) = mat( 84) + lmat( 84)
         mat( 89) = mat( 89) + lmat( 89)
         mat( 93) = mat( 93) + lmat( 93)
         mat( 99) = mat( 99) + lmat( 99)
         mat( 105) = lmat( 105)
         mat( 106) = lmat( 106)
         mat( 107) = lmat( 107)
         mat( 108) = lmat( 108)
         mat( 109) = lmat( 109)
         mat( 110) = lmat( 110)
         mat( 111) = mat( 111) + lmat( 111)
         mat( 118) = mat( 118) + lmat( 118)
         mat( 120) = lmat( 120)
         mat( 121) = lmat( 121)
         mat( 122) = mat( 122) + lmat( 122)
         mat( 123) = mat( 123) + lmat( 123)
         mat( 128) = mat( 128) + lmat( 128)
         mat( 130) = mat( 130) + lmat( 130)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 132) = lmat( 132)
         mat( 133) = mat( 133) + lmat( 133)
         mat( 136) = mat( 136) + lmat( 136)
         mat( 137) = mat( 137) + lmat( 137)
         mat( 140) = mat( 140) + lmat( 140)
         mat( 144) = mat( 144) + lmat( 144)
         mat( 146) = lmat( 146)
         mat( 147) = lmat( 147)
         mat( 148) = lmat( 148)
         mat( 149) = mat( 149) + lmat( 149)
         mat( 150) = mat( 150) + lmat( 150)
         mat( 151) = lmat( 151)
         mat( 154) = mat( 154) + lmat( 154)
         mat( 155) = lmat( 155)
         mat( 156) = mat( 156) + lmat( 156)
         mat( 158) = lmat( 158)
         mat( 160) = mat( 160) + lmat( 160)
         mat( 161) = lmat( 161)
         mat( 162) = mat( 162) + lmat( 162)
         mat( 166) = lmat( 166)
         mat( 167) = mat( 167) + lmat( 167)
         mat( 168) = mat( 168) + lmat( 168)
         mat( 170) = lmat( 170)
         mat( 171) = mat( 171) + lmat( 171)
         mat( 172) = mat( 172) + lmat( 172)
         mat( 174) = mat( 174) + lmat( 174)
         mat( 176) = lmat( 176)
         mat( 177) = lmat( 177)
         mat( 179) = mat( 179) + lmat( 179)
         mat( 182) = lmat( 182)
         mat( 183) = mat( 183) + lmat( 183)
         mat( 184) = mat( 184) + lmat( 184)
         mat( 191) = mat( 191) + lmat( 191)
         mat( 192) = lmat( 192)
         mat( 194) = lmat( 194)
         mat( 195) = lmat( 195)
         mat( 196) = mat( 196) + lmat( 196)
         mat( 197) = lmat( 197)
         mat( 198) = mat( 198) + lmat( 198)
         mat( 199) = lmat( 199)
         mat( 200) = lmat( 200)
         mat( 202) = mat( 202) + lmat( 202)
         mat( 204) = lmat( 204)
         mat( 205) = mat( 205) + lmat( 205)
         mat( 208) = mat( 208) + lmat( 208)
         mat( 209) = mat( 209) + lmat( 209)
         mat( 210) = lmat( 210)
         mat( 211) = lmat( 211)
         mat( 212) = mat( 212) + lmat( 212)
         mat( 215) = mat( 215) + lmat( 215)
         mat( 217) = lmat( 217)
         mat( 218) = mat( 218) + lmat( 218)
         mat( 223) = mat( 223) + lmat( 223)
         mat( 225) = lmat( 225)
         mat( 226) = lmat( 226)
         mat( 232) = mat( 232) + lmat( 232)
         mat( 240) = lmat( 240)
         mat( 241) = lmat( 241)
         mat( 242) = lmat( 242)
         mat( 243) = lmat( 243)
         mat( 244) = lmat( 244)
         mat( 245) = lmat( 245)
         mat( 246) = mat( 246) + lmat( 246)
         mat( 247) = lmat( 247)
         mat( 248) = mat( 248) + lmat( 248)
         mat( 249) = lmat( 249)
         mat( 250) = lmat( 250)
         mat( 252) = lmat( 252)
         mat( 253) = mat( 253) + lmat( 253)
         mat( 254) = mat( 254) + lmat( 254)
         mat( 258) = mat( 258) + lmat( 258)
         mat( 266) = mat( 266) + lmat( 266)
         mat( 270) = mat( 270) + lmat( 270)
         mat( 271) = lmat( 271)
         mat( 274) = lmat( 274)
         mat( 276) = lmat( 276)
         mat( 277) = lmat( 277)
         mat( 278) = mat( 278) + lmat( 278)
         mat( 280) = lmat( 280)
         mat( 283) = mat( 283) + lmat( 283)
         mat( 284) = lmat( 284)
         mat( 285) = lmat( 285)
         mat( 286) = mat( 286) + lmat( 286)
         mat( 295) = mat( 295) + lmat( 295)
         mat( 299) = mat( 299) + lmat( 299)
         mat( 300) = mat( 300) + lmat( 300)
         mat( 301) = lmat( 301)
         mat( 302) = lmat( 302)
         mat( 303) = lmat( 303)
         mat( 306) = mat( 306) + lmat( 306)
         mat( 311) = mat( 311) + lmat( 311)
         mat( 313) = lmat( 313)
         mat( 314) = mat( 314) + lmat( 314)
         mat( 317) = lmat( 317)
         mat( 319) = lmat( 319)
         mat( 321) = mat( 321) + lmat( 321)
         mat( 322) = lmat( 322)
         mat( 323) = lmat( 323)
         mat( 325) = mat( 325) + lmat( 325)
         mat( 334) = mat( 334) + lmat( 334)
         mat( 344) = mat( 344) + lmat( 344)
         mat( 345) = mat( 345) + lmat( 345)
         mat( 347) = mat( 347) + lmat( 347)
         mat( 352) = mat( 352) + lmat( 352)
         mat( 363) = mat( 363) + lmat( 363)
         mat( 365) = lmat( 365)
         mat( 368) = lmat( 368)
         mat( 370) = mat( 370) + lmat( 370)
         mat( 373) = lmat( 373)
         mat( 377) = mat( 377) + lmat( 377)
         mat( 380) = mat( 380) + lmat( 380)
         mat( 388) = mat( 388) + lmat( 388)
         mat( 389) = mat( 389) + lmat( 389)
         mat( 396) = lmat( 396)
         mat( 397) = mat( 397) + lmat( 397)
         mat( 398) = mat( 398) + lmat( 398)
         mat( 404) = mat( 404) + lmat( 404)
         mat( 406) = mat( 406) + lmat( 406)
         mat( 417) = mat( 417) + lmat( 417)
         mat( 425) = mat( 425) + lmat( 425)
         mat( 435) = mat( 435) + lmat( 435)
         mat( 437) = mat( 437) + lmat( 437)
         mat( 440) = lmat( 440)
         mat( 445) = mat( 445) + lmat( 445)
         mat( 454) = lmat( 454)
         mat( 458) = lmat( 458)
         mat( 459) = mat( 459) + lmat( 459)
         mat( 469) = mat( 469) + lmat( 469)
         mat( 485) = mat( 485) + lmat( 485)
         mat( 489) = mat( 489) + lmat( 489)
         mat( 491) = mat( 491) + lmat( 491)
         mat( 493) = mat( 493) + lmat( 493)
         mat( 494) = lmat( 494)
         mat( 496) = mat( 496) + lmat( 496)
         mat( 497) = mat( 497) + lmat( 497)
         mat( 500) = mat( 500) + lmat( 500)
         mat( 513) = mat( 513) + lmat( 513)
         mat( 514) = lmat( 514)
         mat( 516) = mat( 516) + lmat( 516)
         mat( 519) = lmat( 519)
         mat( 520) = mat( 520) + lmat( 520)
         mat( 523) = mat( 523) + lmat( 523)
         mat( 535) = mat( 535) + lmat( 535)
         mat( 536) = mat( 536) + lmat( 536)
         mat( 538) = mat( 538) + lmat( 538)
         mat( 539) = mat( 539) + lmat( 539)
         mat( 541) = mat( 541) + lmat( 541)
         mat( 543) = lmat( 543)
         mat( 545) = mat( 545) + lmat( 545)
         mat( 548) = mat( 548) + lmat( 548)
         mat( 563) = mat( 563) + lmat( 563)
         mat( 578) = mat( 578) + lmat( 578)
         mat( 582) = lmat( 582)
         mat( 583) = mat( 583) + lmat( 583)
         mat( 590) = lmat( 590)
         mat( 591) = lmat( 591)
         mat( 592) = mat( 592) + lmat( 592)
         mat( 594) = lmat( 594)
         mat( 596) = lmat( 596)
         mat( 597) = mat( 597) + lmat( 597)
         mat( 601) = mat( 601) + lmat( 601)
         mat( 612) = mat( 612) + lmat( 612)
         mat( 613) = mat( 613) + lmat( 613)
         mat( 616) = mat( 616) + lmat( 616)
         mat( 617) = lmat( 617)
         mat( 622) = mat( 622) + lmat( 622)
         mat( 623) = mat( 623) + lmat( 623)
         mat( 626) = mat( 626) + lmat( 626)
         mat( 637) = mat( 637) + lmat( 637)
         mat( 638) = mat( 638) + lmat( 638)
         mat( 639) = mat( 639) + lmat( 639)
         mat( 645) = lmat( 645)
         mat( 653) = mat( 653) + lmat( 653)
         mat( 673) = mat( 673) + lmat( 673)
         mat( 697) = mat( 697) + lmat( 697)
         mat( 710) = lmat( 710)
         mat( 711) = mat( 711) + lmat( 711)
         mat( 716) = mat( 716) + lmat( 716)
         mat( 718) = lmat( 718)
         mat( 730) = lmat( 730)
         mat( 736) = mat( 736) + lmat( 736)
         mat( 765) = mat( 765) + lmat( 765)
         mat( 782) = mat( 782) + lmat( 782)
         mat( 787) = mat( 787) + lmat( 787)
         mat( 788) = mat( 788) + lmat( 788)
         mat( 801) = mat( 801) + lmat( 801)
         mat( 803) = mat( 803) + lmat( 803)
         mat( 805) = lmat( 805)
         mat( 809) = mat( 809) + lmat( 809)
         mat( 811) = mat( 811) + lmat( 811)
         mat( 812) = mat( 812) + lmat( 812)
         mat( 821) = lmat( 821)
         mat( 822) = mat( 822) + lmat( 822)
         mat( 824) = lmat( 824)
         mat( 825) = mat( 825) + lmat( 825)
         mat( 827) = lmat( 827)
         mat( 829) = mat( 829) + lmat( 829)
         mat( 836) = mat( 836) + lmat( 836)
         mat( 842) = lmat( 842)
         mat( 843) = mat( 843) + lmat( 843)
         mat( 856) = mat( 856) + lmat( 856)
         mat( 859) = mat( 859) + lmat( 859)
         mat( 861) = mat( 861) + lmat( 861)
         mat( 878) = mat( 878) + lmat( 878)
         mat( 892) = mat( 892) + lmat( 892)
         mat( 917) = mat( 917) + lmat( 917)
         mat( 922) = mat( 922) + lmat( 922)
         mat( 923) = mat( 923) + lmat( 923)
         mat( 924) = mat( 924) + lmat( 924)
         mat( 940) = mat( 940) + lmat( 940)
         mat( 946) = lmat( 946)
         mat( 960) = mat( 960) + lmat( 960)
         mat( 972) = mat( 972) + lmat( 972)
         mat( 975) = mat( 975) + lmat( 975)
         mat( 976) = mat( 976) + lmat( 976)
         mat( 978) = mat( 978) + lmat( 978)
         mat( 979) = mat( 979) + lmat( 979)
         mat( 982) = mat( 982) + lmat( 982)
         mat( 984) = mat( 984) + lmat( 984)
         mat( 985) = mat( 985) + lmat( 985)
         mat( 986) = mat( 986) + lmat( 986)
         mat( 987) = mat( 987) + lmat( 987)
         mat( 989) = lmat( 989)
         mat( 991) = mat( 991) + lmat( 991)
         mat( 993) = lmat( 993)
         mat( 994) = lmat( 994)
         mat( 995) = lmat( 995)
         mat(1008) = mat(1008) + lmat(1008)
         mat(1016) = lmat(1016)
         mat(1020) = mat(1020) + lmat(1020)
         mat(1022) = mat(1022) + lmat(1022)
         mat(1028) = mat(1028) + lmat(1028)
         mat(1029) = lmat(1029)
         mat(1038) = mat(1038) + lmat(1038)
         mat(1061) = mat(1061) + lmat(1061)
         mat(1062) = lmat(1062)
         mat(1063) = mat(1063) + lmat(1063)
         mat(1086) = mat(1086) + lmat(1086)
         mat(1087) = lmat(1087)
         mat(1090) = mat(1090) + lmat(1090)
         mat(1115) = mat(1115) + lmat(1115)
         mat(1120) = mat(1120) + lmat(1120)
         mat(1146) = mat(1146) + lmat(1146)
         mat(1150) = mat(1150) + lmat(1150)
         mat(1155) = mat(1155) + lmat(1155)
         mat(1156) = mat(1156) + lmat(1156)
         mat(1157) = mat(1157) + lmat(1157)
         mat(1171) = lmat(1171)
         mat(1174) = lmat(1174)
         mat(1241) = mat(1241) + lmat(1241)
         mat(1244) = mat(1244) + lmat(1244)
         mat(1248) = mat(1248) + lmat(1248)
         mat(1253) = mat(1253) + lmat(1253)
         mat(1256) = mat(1256) + lmat(1256)
         mat(1257) = mat(1257) + lmat(1257)
         mat(1283) = mat(1283) + lmat(1283)
         mat(1285) = mat(1285) + lmat(1285)
         mat(1287) = mat(1287) + lmat(1287)
         mat(1292) = mat(1292) + lmat(1292)
         mat(1293) = mat(1293) + lmat(1293)
         mat(1295) = mat(1295) + lmat(1295)
         mat(1302) = mat(1302) + lmat(1302)
         mat(1303) = lmat(1303)
         mat(1311) = mat(1311) + lmat(1311)
         mat(1317) = mat(1317) + lmat(1317)
         mat(1340) = mat(1340) + lmat(1340)
         mat(1387) = mat(1387) + lmat(1387)
         mat(1428) = mat(1428) + lmat(1428)
         mat( 238) = 0._r8
         mat( 315) = 0._r8
         mat( 318) = 0._r8
         mat( 320) = 0._r8
         mat( 330) = 0._r8
         mat( 339) = 0._r8
         mat( 342) = 0._r8
         mat( 343) = 0._r8
         mat( 351) = 0._r8
         mat( 354) = 0._r8
         mat( 356) = 0._r8
         mat( 357) = 0._r8
         mat( 360) = 0._r8
         mat( 375) = 0._r8
         mat( 381) = 0._r8
         mat( 382) = 0._r8
         mat( 385) = 0._r8
         mat( 409) = 0._r8
         mat( 411) = 0._r8
         mat( 412) = 0._r8
         mat( 419) = 0._r8
         mat( 420) = 0._r8
         mat( 423) = 0._r8
         mat( 427) = 0._r8
         mat( 429) = 0._r8
         mat( 432) = 0._r8
         mat( 450) = 0._r8
         mat( 455) = 0._r8
         mat( 460) = 0._r8
         mat( 463) = 0._r8
         mat( 477) = 0._r8
         mat( 483) = 0._r8
         mat( 502) = 0._r8
         mat( 503) = 0._r8
         mat( 505) = 0._r8
         mat( 508) = 0._r8
         mat( 515) = 0._r8
         mat( 524) = 0._r8
         mat( 527) = 0._r8
         mat( 528) = 0._r8
         mat( 531) = 0._r8
         mat( 533) = 0._r8
         mat( 537) = 0._r8
         mat( 549) = 0._r8
         mat( 551) = 0._r8
         mat( 553) = 0._r8
         mat( 556) = 0._r8
         mat( 566) = 0._r8
         mat( 567) = 0._r8
         mat( 568) = 0._r8
         mat( 569) = 0._r8
         mat( 571) = 0._r8
         mat( 572) = 0._r8
         mat( 587) = 0._r8
         mat( 605) = 0._r8
         mat( 608) = 0._r8
         mat( 620) = 0._r8
         mat( 628) = 0._r8
         mat( 635) = 0._r8
         mat( 636) = 0._r8
         mat( 642) = 0._r8
         mat( 655) = 0._r8
         mat( 656) = 0._r8
         mat( 657) = 0._r8
         mat( 660) = 0._r8
         mat( 669) = 0._r8
         mat( 671) = 0._r8
         mat( 672) = 0._r8
         mat( 674) = 0._r8
         mat( 676) = 0._r8
         mat( 678) = 0._r8
         mat( 679) = 0._r8
         mat( 680) = 0._r8
         mat( 681) = 0._r8
         mat( 684) = 0._r8
         mat( 696) = 0._r8
         mat( 698) = 0._r8
         mat( 700) = 0._r8
         mat( 701) = 0._r8
         mat( 702) = 0._r8
         mat( 705) = 0._r8
         mat( 713) = 0._r8
         mat( 717) = 0._r8
         mat( 719) = 0._r8
         mat( 720) = 0._r8
         mat( 721) = 0._r8
         mat( 723) = 0._r8
         mat( 724) = 0._r8
         mat( 725) = 0._r8
         mat( 727) = 0._r8
         mat( 734) = 0._r8
         mat( 735) = 0._r8
         mat( 739) = 0._r8
         mat( 740) = 0._r8
         mat( 742) = 0._r8
         mat( 745) = 0._r8
         mat( 766) = 0._r8
         mat( 767) = 0._r8
         mat( 768) = 0._r8
         mat( 770) = 0._r8
         mat( 773) = 0._r8
         mat( 774) = 0._r8
         mat( 784) = 0._r8
         mat( 785) = 0._r8
         mat( 790) = 0._r8
         mat( 794) = 0._r8
         mat( 808) = 0._r8
         mat( 815) = 0._r8
         mat( 816) = 0._r8
         mat( 817) = 0._r8
         mat( 823) = 0._r8
         mat( 826) = 0._r8
         mat( 828) = 0._r8
         mat( 830) = 0._r8
         mat( 831) = 0._r8
         mat( 834) = 0._r8
         mat( 837) = 0._r8
         mat( 838) = 0._r8
         mat( 839) = 0._r8
         mat( 840) = 0._r8
         mat( 841) = 0._r8
         mat( 845) = 0._r8
         mat( 854) = 0._r8
         mat( 855) = 0._r8
         mat( 858) = 0._r8
         mat( 860) = 0._r8
         mat( 862) = 0._r8
         mat( 867) = 0._r8
         mat( 875) = 0._r8
         mat( 876) = 0._r8
         mat( 877) = 0._r8
         mat( 880) = 0._r8
         mat( 881) = 0._r8
         mat( 882) = 0._r8
         mat( 883) = 0._r8
         mat( 884) = 0._r8
         mat( 885) = 0._r8
         mat( 886) = 0._r8
         mat( 887) = 0._r8
         mat( 888) = 0._r8
         mat( 891) = 0._r8
         mat( 898) = 0._r8
         mat( 900) = 0._r8
         mat( 901) = 0._r8
         mat( 902) = 0._r8
         mat( 906) = 0._r8
         mat( 907) = 0._r8
         mat( 910) = 0._r8
         mat( 911) = 0._r8
         mat( 912) = 0._r8
         mat( 915) = 0._r8
         mat( 918) = 0._r8
         mat( 919) = 0._r8
         mat( 927) = 0._r8
         mat( 944) = 0._r8
         mat( 955) = 0._r8
         mat( 956) = 0._r8
         mat( 961) = 0._r8
         mat( 971) = 0._r8
         mat( 981) = 0._r8
         mat( 990) = 0._r8
         mat( 992) = 0._r8
         mat(1000) = 0._r8
         mat(1002) = 0._r8
         mat(1003) = 0._r8
         mat(1006) = 0._r8
         mat(1009) = 0._r8
         mat(1011) = 0._r8
         mat(1013) = 0._r8
         mat(1014) = 0._r8
         mat(1018) = 0._r8
         mat(1019) = 0._r8
         mat(1023) = 0._r8
         mat(1024) = 0._r8
         mat(1033) = 0._r8
         mat(1036) = 0._r8
         mat(1037) = 0._r8
         mat(1039) = 0._r8
         mat(1040) = 0._r8
         mat(1041) = 0._r8
         mat(1043) = 0._r8
         mat(1044) = 0._r8
         mat(1046) = 0._r8
         mat(1052) = 0._r8
         mat(1053) = 0._r8
         mat(1056) = 0._r8
         mat(1057) = 0._r8
         mat(1058) = 0._r8
         mat(1064) = 0._r8
         mat(1065) = 0._r8
         mat(1067) = 0._r8
         mat(1068) = 0._r8
         mat(1069) = 0._r8
         mat(1070) = 0._r8
         mat(1110) = 0._r8
         mat(1111) = 0._r8
         mat(1116) = 0._r8
         mat(1118) = 0._r8
         mat(1119) = 0._r8
         mat(1134) = 0._r8
         mat(1135) = 0._r8
         mat(1138) = 0._r8
         mat(1139) = 0._r8
         mat(1140) = 0._r8
         mat(1145) = 0._r8
         mat(1148) = 0._r8
         mat(1151) = 0._r8
         mat(1152) = 0._r8
         mat(1153) = 0._r8
         mat(1154) = 0._r8
         mat(1159) = 0._r8
         mat(1161) = 0._r8
         mat(1197) = 0._r8
         mat(1212) = 0._r8
         mat(1224) = 0._r8
         mat(1247) = 0._r8
         mat(1274) = 0._r8
         mat(1284) = 0._r8
         mat(1286) = 0._r8
         mat(1288) = 0._r8
         mat(1289) = 0._r8
         mat(1290) = 0._r8
         mat(1291) = 0._r8
         mat(1298) = 0._r8
         mat(1300) = 0._r8
         mat(1307) = 0._r8
         mat(1309) = 0._r8
         mat(1313) = 0._r8
         mat(1314) = 0._r8
         mat(1319) = 0._r8
         mat(1330) = 0._r8
         mat(1335) = 0._r8
         mat(1343) = 0._r8
         mat(1345) = 0._r8
         mat(1352) = 0._r8
         mat(1357) = 0._r8
         mat(1358) = 0._r8
         mat(1359) = 0._r8
         mat(1363) = 0._r8
         mat(1373) = 0._r8
         mat(1378) = 0._r8
         mat(1412) = 0._r8
         mat(1413) = 0._r8
         mat(1415) = 0._r8
         mat(1416) = 0._r8
         mat(1417) = 0._r8
         mat(1418) = 0._r8
         mat(1420) = 0._r8
         mat(1421) = 0._r8
         mat(1424) = 0._r8
         mat(1425) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 17) = mat( 17) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 22) = mat( 22) - dti
         mat( 25) = mat( 25) - dti
         mat( 28) = mat( 28) - dti
         mat( 31) = mat( 31) - dti
         mat( 34) = mat( 34) - dti
         mat( 39) = mat( 39) - dti
         mat( 41) = mat( 41) - dti
         mat( 44) = mat( 44) - dti
         mat( 49) = mat( 49) - dti
         mat( 52) = mat( 52) - dti
         mat( 55) = mat( 55) - dti
         mat( 58) = mat( 58) - dti
         mat( 61) = mat( 61) - dti
         mat( 63) = mat( 63) - dti
         mat( 65) = mat( 65) - dti
         mat( 69) = mat( 69) - dti
         mat( 73) = mat( 73) - dti
         mat( 77) = mat( 77) - dti
         mat( 80) = mat( 80) - dti
         mat( 84) = mat( 84) - dti
         mat( 89) = mat( 89) - dti
         mat( 93) = mat( 93) - dti
         mat( 99) = mat( 99) - dti
         mat( 105) = mat( 105) - dti
         mat( 111) = mat( 111) - dti
         mat( 118) = mat( 118) - dti
         mat( 123) = mat( 123) - dti
         mat( 128) = mat( 128) - dti
         mat( 133) = mat( 133) - dti
         mat( 137) = mat( 137) - dti
         mat( 140) = mat( 140) - dti
         mat( 144) = mat( 144) - dti
         mat( 150) = mat( 150) - dti
         mat( 156) = mat( 156) - dti
         mat( 162) = mat( 162) - dti
         mat( 168) = mat( 168) - dti
         mat( 174) = mat( 174) - dti
         mat( 179) = mat( 179) - dti
         mat( 184) = mat( 184) - dti
         mat( 191) = mat( 191) - dti
         mat( 198) = mat( 198) - dti
         mat( 205) = mat( 205) - dti
         mat( 212) = mat( 212) - dti
         mat( 218) = mat( 218) - dti
         mat( 223) = mat( 223) - dti
         mat( 232) = mat( 232) - dti
         mat( 240) = mat( 240) - dti
         mat( 246) = mat( 246) - dti
         mat( 254) = mat( 254) - dti
         mat( 258) = mat( 258) - dti
         mat( 266) = mat( 266) - dti
         mat( 270) = mat( 270) - dti
         mat( 278) = mat( 278) - dti
         mat( 286) = mat( 286) - dti
         mat( 295) = mat( 295) - dti
         mat( 299) = mat( 299) - dti
         mat( 306) = mat( 306) - dti
         mat( 314) = mat( 314) - dti
         mat( 325) = mat( 325) - dti
         mat( 334) = mat( 334) - dti
         mat( 344) = mat( 344) - dti
         mat( 352) = mat( 352) - dti
         mat( 363) = mat( 363) - dti
         mat( 370) = mat( 370) - dti
         mat( 380) = mat( 380) - dti
         mat( 389) = mat( 389) - dti
         mat( 397) = mat( 397) - dti
         mat( 406) = mat( 406) - dti
         mat( 417) = mat( 417) - dti
         mat( 425) = mat( 425) - dti
         mat( 435) = mat( 435) - dti
         mat( 445) = mat( 445) - dti
         mat( 459) = mat( 459) - dti
         mat( 469) = mat( 469) - dti
         mat( 485) = mat( 485) - dti
         mat( 493) = mat( 493) - dti
         mat( 500) = mat( 500) - dti
         mat( 513) = mat( 513) - dti
         mat( 523) = mat( 523) - dti
         mat( 536) = mat( 536) - dti
         mat( 548) = mat( 548) - dti
         mat( 563) = mat( 563) - dti
         mat( 578) = mat( 578) - dti
         mat( 583) = mat( 583) - dti
         mat( 592) = mat( 592) - dti
         mat( 601) = mat( 601) - dti
         mat( 613) = mat( 613) - dti
         mat( 626) = mat( 626) - dti
         mat( 638) = mat( 638) - dti
         mat( 653) = mat( 653) - dti
         mat( 673) = mat( 673) - dti
         mat( 697) = mat( 697) - dti
         mat( 716) = mat( 716) - dti
         mat( 736) = mat( 736) - dti
         mat( 765) = mat( 765) - dti
         mat( 782) = mat( 782) - dti
         mat( 809) = mat( 809) - dti
         mat( 822) = mat( 822) - dti
         mat( 836) = mat( 836) - dti
         mat( 856) = mat( 856) - dti
         mat( 878) = mat( 878) - dti
         mat( 922) = mat( 922) - dti
         mat( 960) = mat( 960) - dti
         mat( 985) = mat( 985) - dti
         mat(1020) = mat(1020) - dti
         mat(1038) = mat(1038) - dti
         mat(1063) = mat(1063) - dti
         mat(1120) = mat(1120) - dti
         mat(1156) = mat(1156) - dti
         mat(1253) = mat(1253) - dti
         mat(1295) = mat(1295) - dti
         mat(1317) = mat(1317) - dti
         mat(1387) = mat(1387) - dti
         mat(1428) = mat(1428) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat07( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
