




      module mo_indprd

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: indprd

      contains

      subroutine indprd( class, prod, nprod, y, extfrc, rxt, ncol )

      use chem_mods, only : gas_pcnst, extcnt, rxntot
      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy arguments
!--------------------------------------------------------------------
      integer, intent(in) :: class
      integer, intent(in) :: ncol
      integer, intent(in) :: nprod
      real(r8), intent(in) :: y(ncol,pver,gas_pcnst)
      real(r8), intent(in) :: rxt(ncol,pver,rxntot)
      real(r8), intent(in) :: extfrc(ncol,pver,extcnt)
      real(r8), intent(inout) :: prod(ncol,pver,nprod)

!--------------------------------------------------------------------
! ... "independent" production for Explicit species
!--------------------------------------------------------------------
      if( class == 1 ) then
         prod(:,:,1) =.080_r8*rxt(:,:,314)*y(:,:,59)*y(:,:,1)

         prod(:,:,2) =rxt(:,:,187)*y(:,:,10)*y(:,:,8)

         prod(:,:,3) = 0._r8

         prod(:,:,4) = 0._r8

         prod(:,:,5) = 0._r8

         prod(:,:,6) = 0._r8

         prod(:,:,7) = 0._r8

         prod(:,:,8) = 0._r8

         prod(:,:,9) = 0._r8

         prod(:,:,10) = 0._r8

         prod(:,:,11) = 0._r8

         prod(:,:,12) = 0._r8

         prod(:,:,13) = 0._r8

         prod(:,:,14) = 0._r8

         prod(:,:,15) = 0._r8

         prod(:,:,16) = 0._r8

         prod(:,:,17) = 0._r8

         prod(:,:,18) = 0._r8

         prod(:,:,19) = 0._r8

         prod(:,:,20) = 0._r8

         prod(:,:,21) = (rxt(:,:,267)*y(:,:,20) +rxt(:,:,268)*y(:,:,20) + &
                 rxt(:,:,279)*y(:,:,130) +rxt(:,:,294)*y(:,:,49) + &
                 .500_r8*rxt(:,:,307)*y(:,:,54) +.800_r8*rxt(:,:,308)*y(:,:,52) + &
                 rxt(:,:,309)*y(:,:,53) +.500_r8*rxt(:,:,358)*y(:,:,81))*y(:,:,23) &
                  + (rxt(:,:,302)*y(:,:,9) +.900_r8*rxt(:,:,305)*y(:,:,16) + &
                 2.000_r8*rxt(:,:,306)*y(:,:,48) +2.000_r8*rxt(:,:,354)*y(:,:,76) + &
                 rxt(:,:,382)*y(:,:,91))*y(:,:,48) + (rxt(:,:,353)*y(:,:,16) + &
                 2.000_r8*rxt(:,:,355)*y(:,:,76))*y(:,:,76) +rxt(:,:,63)*y(:,:,54) &
                  +.400_r8*rxt(:,:,64)*y(:,:,58)

         prod(:,:,22) = 0._r8

         prod(:,:,23) = 0._r8

!--------------------------------------------------------------------
! ... "independent" production for Implicit species
!--------------------------------------------------------------------
      else if( class == 4 ) then
         prod(:,:,128) = 0._r8

         prod(:,:,121) = (rxt(:,:,58) +rxt(:,:,117))*y(:,:,120) +.180_r8*rxt(:,:,60) &
                 *y(:,:,15)

         prod(:,:,125) =rxt(:,:,5)*y(:,:,7)

         prod(:,:,120) = 0._r8

         prod(:,:,28) = 0._r8

         prod(:,:,27) = 0._r8

         prod(:,:,108) =1.440_r8*rxt(:,:,60)*y(:,:,15)

         prod(:,:,103) = (rxt(:,:,58) +rxt(:,:,117))*y(:,:,120) +.380_r8*rxt(:,:,60) &
                 *y(:,:,15) + extfrc(:,:,3)

         prod(:,:,92) = (rxt(:,:,101) +.800_r8*rxt(:,:,104) +rxt(:,:,113) + &
                 .800_r8*rxt(:,:,116)) + extfrc(:,:,12)

         prod(:,:,129) = + extfrc(:,:,1)

         prod(:,:,130) = + extfrc(:,:,2)

         prod(:,:,131) =.660_r8*rxt(:,:,60)*y(:,:,15) + extfrc(:,:,14)

         prod(:,:,132) = 0._r8

         prod(:,:,133) = 0._r8

         prod(:,:,60) = 0._r8

         prod(:,:,40) = 0._r8

         prod(:,:,119) =rxt(:,:,59)*y(:,:,15) +rxt(:,:,37)*y(:,:,102) +rxt(:,:,48) &
                 *y(:,:,103)

         prod(:,:,50) = 0._r8

         prod(:,:,30) = 0._r8

         prod(:,:,17) = 0._r8

         prod(:,:,135) =.180_r8*rxt(:,:,60)*y(:,:,15)

         prod(:,:,127) =rxt(:,:,59)*y(:,:,15)

         prod(:,:,126) = 0._r8

         prod(:,:,74) = 0._r8

         prod(:,:,134) =.050_r8*rxt(:,:,60)*y(:,:,15)

         prod(:,:,123) =rxt(:,:,37)*y(:,:,102) +2.000_r8*rxt(:,:,40)*y(:,:,104) &
                  +2.000_r8*rxt(:,:,41)*y(:,:,105) +2.000_r8*rxt(:,:,42)*y(:,:,106) &
                  +rxt(:,:,45)*y(:,:,107) +4.000_r8*rxt(:,:,38)*y(:,:,108) &
                  +3.000_r8*rxt(:,:,39)*y(:,:,109) +rxt(:,:,50)*y(:,:,111) &
                  +rxt(:,:,46)*y(:,:,112) +rxt(:,:,47)*y(:,:,113) &
                  +2.000_r8*rxt(:,:,43)*y(:,:,114) +rxt(:,:,44)*y(:,:,115)

         prod(:,:,29) = 0._r8

         prod(:,:,124) = 0._r8

         prod(:,:,46) = 0._r8

         prod(:,:,18) = 0._r8

         prod(:,:,117) = 0._r8

         prod(:,:,93) = 0._r8

         prod(:,:,100) = 0._r8

         prod(:,:,33) = 0._r8

         prod(:,:,118) =rxt(:,:,48)*y(:,:,103) +rxt(:,:,49)*y(:,:,110) +rxt(:,:,50) &
                 *y(:,:,111) +2.000_r8*rxt(:,:,53)*y(:,:,116) +2.000_r8*rxt(:,:,54) &
                 *y(:,:,117) +3.000_r8*rxt(:,:,51)*y(:,:,118) +2.000_r8*rxt(:,:,52) &
                 *y(:,:,119)

         prod(:,:,122) = 0._r8

         prod(:,:,90) = 0._r8

         prod(:,:,84) = 0._r8

         prod(:,:,70) = 0._r8

         prod(:,:,78) = (rxt(:,:,97) +rxt(:,:,109)) + extfrc(:,:,10)

         prod(:,:,85) = + extfrc(:,:,8)

         prod(:,:,58) = (rxt(:,:,101) +rxt(:,:,102) +rxt(:,:,113) +rxt(:,:,114)) &
                  + extfrc(:,:,9)

         prod(:,:,72) = + extfrc(:,:,7)

         prod(:,:,86) = 0._r8

         prod(:,:,61) = (rxt(:,:,102) +1.200_r8*rxt(:,:,104) +rxt(:,:,114) + &
                 1.200_r8*rxt(:,:,116)) + extfrc(:,:,11)

         prod(:,:,87) = (rxt(:,:,97) +rxt(:,:,101) +rxt(:,:,102) +rxt(:,:,109) + &
                 rxt(:,:,113) +rxt(:,:,114)) + extfrc(:,:,13)

         prod(:,:,102) = 0._r8

         prod(:,:,94) = 0._r8

         prod(:,:,89) = 0._r8

         prod(:,:,104) = 0._r8

         prod(:,:,75) = 0._r8

         prod(:,:,67) = 0._r8

         prod(:,:,115) = 0._r8

         prod(:,:,62) = 0._r8

         prod(:,:,57) = 0._r8

         prod(:,:,49) = 0._r8

         prod(:,:,37) = 0._r8

         prod(:,:,63) = 0._r8

         prod(:,:,19) = 0._r8

         prod(:,:,71) = 0._r8

         prod(:,:,20) = 0._r8

         prod(:,:,41) = 0._r8

         prod(:,:,79) = 0._r8

         prod(:,:,76) = 0._r8

         prod(:,:,55) = 0._r8

         prod(:,:,77) = 0._r8

         prod(:,:,42) = 0._r8

         prod(:,:,22) = 0._r8

         prod(:,:,23) = 0._r8

         prod(:,:,65) = 0._r8

         prod(:,:,51) = 0._r8

         prod(:,:,31) = 0._r8

         prod(:,:,98) = 0._r8

         prod(:,:,59) = 0._r8

         prod(:,:,66) = 0._r8

         prod(:,:,81) = 0._r8

         prod(:,:,111) = 0._r8

         prod(:,:,113) = 0._r8

         prod(:,:,107) = 0._r8

         prod(:,:,112) = 0._r8

         prod(:,:,43) = 0._r8

         prod(:,:,114) = 0._r8

         prod(:,:,91) = 0._r8

         prod(:,:,44) = 0._r8

         prod(:,:,73) = 0._r8

         prod(:,:,21) = 0._r8

         prod(:,:,96) = 0._r8

         prod(:,:,52) = 0._r8

         prod(:,:,80) = 0._r8

         prod(:,:,53) = 0._r8

         prod(:,:,68) = 0._r8

         prod(:,:,35) = 0._r8

         prod(:,:,95) = 0._r8

         prod(:,:,105) = 0._r8

         prod(:,:,83) = 0._r8

         prod(:,:,56) = 0._r8

         prod(:,:,24) = 0._r8

         prod(:,:,47) = 0._r8

         prod(:,:,106) = 0._r8

         prod(:,:,109) = 0._r8

         prod(:,:,101) = 0._r8

         prod(:,:,97) = 0._r8

         prod(:,:,110) = 0._r8

         prod(:,:,45) = 0._r8

         prod(:,:,69) = 0._r8

         prod(:,:,38) = 0._r8

         prod(:,:,64) = 0._r8

         prod(:,:,54) = 0._r8

         prod(:,:,25) =rxt(:,:,41)*y(:,:,105) +rxt(:,:,42)*y(:,:,106) +rxt(:,:,45) &
                 *y(:,:,107) +rxt(:,:,49)*y(:,:,110) +rxt(:,:,50)*y(:,:,111) &
                  +rxt(:,:,47)*y(:,:,113) +2.000_r8*rxt(:,:,43)*y(:,:,114) &
                  +2.000_r8*rxt(:,:,44)*y(:,:,115) +rxt(:,:,53)*y(:,:,116) &
                  +2.000_r8*rxt(:,:,54)*y(:,:,117)

         prod(:,:,32) =rxt(:,:,40)*y(:,:,104) +rxt(:,:,42)*y(:,:,106) +rxt(:,:,46) &
                 *y(:,:,112)

         prod(:,:,34) = 0._r8

         prod(:,:,88) =rxt(:,:,49)*y(:,:,110) +rxt(:,:,44)*y(:,:,115)

         prod(:,:,99) = + extfrc(:,:,4)

         prod(:,:,39) = 0._r8

         prod(:,:,1) = + extfrc(:,:,5)

         prod(:,:,2) = 0._r8

         prod(:,:,3) = 0._r8

         prod(:,:,4) = 0._r8

         prod(:,:,48) = 0._r8

         prod(:,:,82) = 0._r8

         prod(:,:,116) = 0._r8

         prod(:,:,36) = 0._r8

         prod(:,:,26) = 0._r8

         prod(:,:,5) = + extfrc(:,:,6)

         prod(:,:,6) = 0._r8

         prod(:,:,7) = 0._r8

         prod(:,:,8) = 0._r8

         prod(:,:,9) = 0._r8

         prod(:,:,10) = 0._r8

         prod(:,:,11) = 0._r8

         prod(:,:,12) = 0._r8

         prod(:,:,13) = 0._r8

         prod(:,:,14) = 0._r8

         prod(:,:,15) = 0._r8

         prod(:,:,16) = 0._r8

      end if

      end subroutine indprd

      end module mo_indprd
