




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1198) = -(rxt(119)*y(2) + rxt(137)*y(3) + rxt(164)*y(22) + rxt(169)*y(23) &
                      + rxt(177)*y(24) + rxt(192)*y(9) + rxt(195)*y(10) + rxt(207) &
                      *y(28) + rxt(234)*y(37) + rxt(293)*y(44) + rxt(314)*y(59) &
                      + rxt(336)*y(77) + rxt(342)*y(78) + rxt(360)*y(83) + rxt(392) &
                      *y(99) + rxt(423)*y(147) + rxt(426)*y(148))
         mat(952) = -rxt(119)*y(1)
         mat(1064) = -rxt(137)*y(1)
         mat(1153) = -rxt(164)*y(1)
         mat(1388) = -rxt(169)*y(1)
         mat(1133) = -rxt(177)*y(1)
         mat(1253) = -rxt(192)*y(1)
         mat(1290) = -rxt(195)*y(1)
         mat(1011) = -rxt(207)*y(1)
         mat(848) = -rxt(234)*y(1)
         mat(240) = -rxt(293)*y(1)
         mat(597) = -rxt(314)*y(1)
         mat(749) = -rxt(336)*y(1)
         mat(646) = -rxt(342)*y(1)
         mat(506) = -rxt(360)*y(1)
         mat(310) = -rxt(392)*y(1)
         mat(386) = -rxt(423)*y(1)
         mat(816) = -rxt(426)*y(1)

         mat(1198) = mat(1198) + .100_r8*rxt(360)*y(83) + .200_r8*rxt(336)*y(77) &
                      + .200_r8*rxt(342)*y(78)
         mat(952) = mat(952) + rxt(118)*y(4)
         mat(913) = rxt(118)*y(2)
         mat(1133) = mat(1133) + .250_r8*rxt(304)*y(48) + .250_r8*rxt(352)*y(76)
         mat(506) = mat(506) + .100_r8*rxt(360)*y(1)
         mat(796) = .250_r8*rxt(304)*y(24)
         mat(749) = mat(749) + .200_r8*rxt(336)*y(1)
         mat(646) = mat(646) + .200_r8*rxt(342)*y(1)
         mat(768) = .250_r8*rxt(352)*y(24)

         mat(945) = -(rxt(118)*y(4) + rxt(119)*y(1) + 4._r8*rxt(120)*y(2) + rxt(168) &
                      *y(23) + rxt(175)*y(21) + rxt(176)*y(24) + rxt(179)*y(25) &
                      + rxt(190)*y(9) + (rxt(193) + rxt(194)) * y(10) + rxt(201)*y(11) &
                      + rxt(214)*y(30) + rxt(227)*y(33) + rxt(228)*y(34) + rxt(231) &
                      *y(35) + rxt(237)*y(38) + rxt(247)*y(39) + rxt(248)*y(40) &
                      + rxt(249)*y(41) + rxt(271)*y(19) + rxt(419)*y(146) + (rxt(455) &
                      + rxt(456)) * y(121) + rxt(462)*y(123))
         mat(906) = -rxt(118)*y(2)
         mat(1191) = -rxt(119)*y(2)
         mat(1381) = -rxt(168)*y(2)
         mat(655) = -rxt(175)*y(2)
         mat(1126) = -rxt(176)*y(2)
         mat(316) = -rxt(179)*y(2)
         mat(1246) = -rxt(190)*y(2)
         mat(1283) = -(rxt(193) + rxt(194)) * y(2)
         mat(1425) = -rxt(201)*y(2)
         mat(1031) = -rxt(214)*y(2)
         mat(828) = -rxt(227)*y(2)
         mat(490) = -rxt(228)*y(2)
         mat(564) = -rxt(231)*y(2)
         mat(969) = -rxt(237)*y(2)
         mat(456) = -rxt(247)*y(2)
         mat(402) = -rxt(248)*y(2)
         mat(285) = -rxt(249)*y(2)
         mat(1497) = -rxt(271)*y(2)
         mat(149) = -rxt(419)*y(2)
         mat(353) = -(rxt(455) + rxt(456)) * y(2)
         mat(209) = -rxt(462)*y(2)

         mat(1057) = (rxt(132)+rxt(133))*y(4)
         mat(906) = mat(906) + (rxt(132)+rxt(133))*y(3) + rxt(185)*y(8) + rxt(461) &
                      *y(123) + rxt(453)*y(124) + rxt(422)*y(147) + rxt(425)*y(148)
         mat(481) = rxt(185)*y(4) + rxt(186)*y(9) + rxt(187)*y(10) + rxt(458)*y(122)
         mat(1246) = mat(1246) + rxt(186)*y(8)
         mat(1283) = mat(1283) + rxt(187)*y(8)
         mat(1381) = mat(1381) + 2.000_r8*rxt(171)*y(23)
         mat(1146) = rxt(167)*y(24)
         mat(1126) = mat(1126) + rxt(167)*y(22)
         mat(412) = rxt(458)*y(8) + 1.150_r8*rxt(466)*y(126)
         mat(209) = mat(209) + rxt(461)*y(4)
         mat(304) = rxt(453)*y(4)
         mat(420) = rxt(465)*y(126)
         mat(431) = 1.150_r8*rxt(466)*y(122) + rxt(465)*y(125)
         mat(384) = rxt(422)*y(4)
         mat(810) = rxt(425)*y(4)

         mat(1061) = -((rxt(132) + rxt(133)) * y(4) + rxt(134)*y(128) + rxt(137)*y(1) &
                      + rxt(154)*y(132) + rxt(155)*y(133) + rxt(159)*y(21) + rxt(160) &
                      *y(33) + rxt(161)*y(39) + rxt(162)*y(42))
         mat(910) = -(rxt(132) + rxt(133)) * y(3)
         mat(1477) = -rxt(134)*y(3)
         mat(1195) = -rxt(137)*y(3)
         mat(48) = -rxt(154)*y(3)
         mat(70) = -rxt(155)*y(3)
         mat(657) = -rxt(159)*y(3)
         mat(832) = -rxt(160)*y(3)
         mat(457) = -rxt(161)*y(3)
         mat(60) = -rxt(162)*y(3)

         mat(910) = mat(910) + rxt(182)*y(127)
         mat(413) = .850_r8*rxt(466)*y(126)
         mat(227) = rxt(182)*y(4)
         mat(432) = .850_r8*rxt(466)*y(122)

         mat(905) = -(rxt(118)*y(2) + rxt(128)*y(6) + rxt(132)*y(3) + rxt(163)*y(22) &
                      + rxt(182)*y(127) + rxt(185)*y(8) + rxt(291)*y(56) + rxt(422) &
                      *y(147) + rxt(425)*y(148) + rxt(453)*y(124) + (rxt(460) + rxt(461) &
                      ) * y(123) + rxt(463)*y(121))
         mat(944) = -rxt(118)*y(4)
         mat(53) = -rxt(128)*y(4)
         mat(1056) = -rxt(132)*y(4)
         mat(1145) = -rxt(163)*y(4)
         mat(226) = -rxt(182)*y(4)
         mat(480) = -rxt(185)*y(4)
         mat(193) = -rxt(291)*y(4)
         mat(383) = -rxt(422)*y(4)
         mat(809) = -rxt(425)*y(4)
         mat(303) = -rxt(453)*y(4)
         mat(208) = -(rxt(460) + rxt(461)) * y(4)
         mat(352) = -rxt(463)*y(4)

         mat(1190) = 2.000_r8*rxt(119)*y(2) + 2.000_r8*rxt(137)*y(3) + rxt(192)*y(9) &
                      + rxt(195)*y(10) + rxt(169)*y(23) + rxt(164)*y(22) &
                      + 2.000_r8*rxt(177)*y(24) + rxt(207)*y(28) + rxt(234)*y(37) &
                      + rxt(423)*y(147) + rxt(426)*y(148)
         mat(944) = mat(944) + 2.000_r8*rxt(119)*y(1) + 2.000_r8*rxt(120)*y(2) &
                      + rxt(127)*y(6) + rxt(193)*y(10) + rxt(168)*y(23) + rxt(201) &
                      *y(11) + rxt(176)*y(24) + rxt(214)*y(30) + rxt(237)*y(38)
         mat(1056) = mat(1056) + 2.000_r8*rxt(137)*y(1)
         mat(905) = mat(905) + 2.000_r8*rxt(128)*y(6)
         mat(53) = mat(53) + rxt(127)*y(2) + 2.000_r8*rxt(128)*y(4)
         mat(480) = mat(480) + rxt(189)*y(10)
         mat(1245) = rxt(192)*y(1) + rxt(459)*y(122)
         mat(1282) = rxt(195)*y(1) + rxt(193)*y(2) + rxt(189)*y(8)
         mat(1380) = rxt(169)*y(1) + rxt(168)*y(2) + rxt(205)*y(13) + rxt(170)*y(24) &
                      + rxt(216)*y(30)
         mat(1424) = rxt(201)*y(2) + rxt(203)*y(24)
         mat(218) = rxt(205)*y(23)
         mat(875) = rxt(274)*y(24)
         mat(1145) = mat(1145) + rxt(164)*y(1) + rxt(166)*y(24)
         mat(1125) = 2.000_r8*rxt(177)*y(1) + rxt(176)*y(2) + rxt(170)*y(23) &
                      + rxt(203)*y(11) + rxt(274)*y(16) + rxt(166)*y(22) &
                      + 2.000_r8*rxt(178)*y(24) + rxt(210)*y(28) + rxt(217)*y(30) &
                      + rxt(235)*y(37) + rxt(239)*y(38) + rxt(322)*y(64) &
                      + .750_r8*rxt(352)*y(76) + rxt(296)*y(46) + rxt(317)*y(61) &
                      + rxt(326)*y(67)
         mat(1003) = rxt(207)*y(1) + rxt(210)*y(24)
         mat(1030) = rxt(214)*y(2) + rxt(216)*y(23) + rxt(217)*y(24) + ( &
                      + 2.000_r8*rxt(221)+2.000_r8*rxt(222))*y(30) + (rxt(243) &
                       +rxt(244))*y(38)
         mat(842) = rxt(234)*y(1) + rxt(235)*y(24)
         mat(968) = rxt(237)*y(2) + rxt(239)*y(24) + (rxt(243)+rxt(244))*y(30) &
                      + 2.000_r8*rxt(245)*y(38)
         mat(411) = rxt(459)*y(9)
         mat(447) = rxt(322)*y(24)
         mat(765) = .750_r8*rxt(352)*y(24)
         mat(467) = rxt(296)*y(24)
         mat(524) = rxt(317)*y(24)
         mat(631) = rxt(326)*y(24)
         mat(383) = mat(383) + rxt(423)*y(1)
         mat(809) = mat(809) + rxt(426)*y(1)

         mat(55) = -(rxt(121)*y(2) + rxt(122)*y(4) + rxt(124)*y(1))
         mat(920) = -rxt(121)*y(5)
         mat(889) = -rxt(122)*y(5)
         mat(1162) = -rxt(124)*y(5)

         mat(1047) = rxt(132)*y(4)
         mat(889) = mat(889) + rxt(132)*y(3)

         mat(52) = -(rxt(127)*y(2) + rxt(128)*y(4))
         mat(919) = -rxt(127)*y(6)
         mat(888) = -rxt(128)*y(6)

         mat(1161) = rxt(124)*y(5)
         mat(919) = mat(919) + rxt(121)*y(5)
         mat(888) = mat(888) + rxt(122)*y(5)
         mat(54) = rxt(124)*y(1) + rxt(121)*y(2) + rxt(122)*y(4)

         mat(652) = -(rxt(159)*y(3) + rxt(173)*y(23) + rxt(175)*y(2) + rxt(208)*y(28) &
                      + rxt(251)*y(135))
         mat(1052) = -rxt(159)*y(21)
         mat(1368) = -rxt(173)*y(21)
         mat(939) = -rxt(175)*y(21)
         mat(998) = -rxt(208)*y(21)
         mat(436) = -rxt(251)*y(21)

         mat(1141) = rxt(166)*y(24)
         mat(1114) = rxt(166)*y(22)

         mat(604) = -((rxt(267) + rxt(268)) * y(23))
         mat(1363) = -(rxt(267) + rxt(268)) * y(20)

         mat(1175) = .560_r8*rxt(314)*y(59) + .300_r8*rxt(360)*y(83) &
                      + .500_r8*rxt(293)*y(44) + .050_r8*rxt(336)*y(77) &
                      + .200_r8*rxt(342)*y(78)
         mat(938) = rxt(271)*y(19) + rxt(419)*y(146)
         mat(1231) = .220_r8*rxt(343)*y(79) + .500_r8*rxt(378)*y(91)
         mat(1363) = mat(1363) + rxt(270)*y(19) + rxt(309)*y(53) + rxt(330)*y(68) &
                      + .350_r8*rxt(286)*y(129) + rxt(420)*y(146)
         mat(1409) = rxt(269)*y(19) + .220_r8*rxt(345)*y(79) + rxt(331)*y(68) &
                      + .500_r8*rxt(379)*y(91)
         mat(862) = .110_r8*rxt(347)*y(79) + .200_r8*rxt(381)*y(91)
         mat(1491) = rxt(271)*y(2) + rxt(270)*y(23) + rxt(269)*y(11) + rxt(212)*y(28) &
                      + rxt(236)*y(37)
         mat(996) = rxt(212)*y(19)
         mat(840) = rxt(236)*y(19)
         mat(590) = .560_r8*rxt(314)*y(1)
         mat(499) = .300_r8*rxt(360)*y(1)
         mat(782) = .220_r8*rxt(348)*y(79) + .500_r8*rxt(382)*y(91)
         mat(238) = .500_r8*rxt(293)*y(1)
         mat(378) = rxt(309)*y(23)
         mat(737) = .050_r8*rxt(336)*y(1)
         mat(638) = .200_r8*rxt(342)*y(1)
         mat(719) = .220_r8*rxt(343)*y(9) + .220_r8*rxt(345)*y(11) + .110_r8*rxt(347) &
                      *y(16) + .220_r8*rxt(348)*y(48)
         mat(663) = rxt(330)*y(23) + rxt(331)*y(11)
         mat(676) = .500_r8*rxt(378)*y(9) + .500_r8*rxt(379)*y(11) + .200_r8*rxt(381) &
                      *y(16) + .500_r8*rxt(382)*y(48)
         mat(95) = .350_r8*rxt(286)*y(23)
         mat(147) = rxt(419)*y(2) + rxt(420)*y(23)

         mat(478) = -(rxt(184)*y(23) + rxt(185)*y(4) + rxt(186)*y(9) + (rxt(187) &
                      + rxt(188) + rxt(189)) * y(10) + rxt(458)*y(122))
         mat(1352) = -rxt(184)*y(8)
         mat(899) = -rxt(185)*y(8)
         mat(1225) = -rxt(186)*y(8)
         mat(1270) = -(rxt(187) + rxt(188) + rxt(189)) * y(8)
         mat(410) = -rxt(458)*y(8)

         mat(934) = rxt(462)*y(123) + rxt(183)*y(127)
         mat(899) = mat(899) + rxt(460)*y(123)
         mat(350) = 1.100_r8*rxt(467)*y(126)
         mat(207) = rxt(462)*y(2) + rxt(460)*y(4)
         mat(418) = .200_r8*rxt(465)*y(126)
         mat(225) = rxt(183)*y(2)
         mat(428) = 1.100_r8*rxt(467)*y(121) + .200_r8*rxt(465)*y(125)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1254) = -(rxt(186)*y(8) + rxt(190)*y(2) + rxt(191)*y(24) + rxt(192)*y(1) &
                      + rxt(200)*y(11) + rxt(219)*y(30) + rxt(240)*y(38) + rxt(273) &
                      *y(16) + rxt(281)*y(131) + rxt(289)*y(55) + rxt(295)*y(46) &
                      + rxt(302)*y(48) + rxt(316)*y(61) + rxt(321)*y(64) + rxt(325) &
                      *y(67) + rxt(334)*y(73) + rxt(338)*y(74) + (rxt(343) + rxt(344) &
                      ) * y(79) + rxt(350)*y(76) + rxt(362)*y(88) + rxt(368)*y(89) &
                      + rxt(375)*y(84) + rxt(378)*y(91) + rxt(386)*y(96) + rxt(394) &
                      *y(100) + rxt(459)*y(122))
         mat(484) = -rxt(186)*y(9)
         mat(953) = -rxt(190)*y(9)
         mat(1134) = -rxt(191)*y(9)
         mat(1199) = -rxt(192)*y(9)
         mat(1433) = -rxt(200)*y(9)
         mat(1039) = -rxt(219)*y(9)
         mat(977) = -rxt(240)*y(9)
         mat(881) = -rxt(273)*y(9)
         mat(183) = -rxt(281)*y(9)
         mat(394) = -rxt(289)*y(9)
         mat(469) = -rxt(295)*y(9)
         mat(797) = -rxt(302)*y(9)
         mat(526) = -rxt(316)*y(9)
         mat(449) = -rxt(321)*y(9)
         mat(633) = -rxt(325)*y(9)
         mat(114) = -rxt(334)*y(9)
         mat(341) = -rxt(338)*y(9)
         mat(729) = -(rxt(343) + rxt(344)) * y(9)
         mat(769) = -rxt(350)*y(9)
         mat(708) = -rxt(362)*y(9)
         mat(580) = -rxt(368)*y(9)
         mat(367) = -rxt(375)*y(9)
         mat(684) = -rxt(378)*y(9)
         mat(253) = -rxt(386)*y(9)
         mat(549) = -rxt(394)*y(9)
         mat(414) = -rxt(459)*y(9)

         mat(953) = mat(953) + rxt(193)*y(10)
         mat(914) = rxt(185)*y(8) + rxt(182)*y(127)
         mat(484) = mat(484) + rxt(185)*y(4) + 2.000_r8*rxt(188)*y(10) + rxt(184) &
                      *y(23)
         mat(1291) = rxt(193)*y(2) + 2.000_r8*rxt(188)*y(8) + rxt(427)*y(148)
         mat(1389) = rxt(184)*y(8)
         mat(228) = rxt(182)*y(4)
         mat(817) = rxt(427)*y(10)

         mat(1292) = -((rxt(187) + rxt(188) + rxt(189)) * y(8) + (rxt(193) + rxt(194) &
                      ) * y(2) + rxt(195)*y(1) + rxt(196)*y(11) + rxt(198)*y(23) &
                      + rxt(204)*y(24) + rxt(220)*y(30) + rxt(241)*y(38) + rxt(303) &
                      *y(48) + rxt(356)*y(76) + rxt(390)*y(98) + rxt(427)*y(148))
         mat(485) = -(rxt(187) + rxt(188) + rxt(189)) * y(10)
         mat(954) = -(rxt(193) + rxt(194)) * y(10)
         mat(1200) = -rxt(195)*y(10)
         mat(1434) = -rxt(196)*y(10)
         mat(1390) = -rxt(198)*y(10)
         mat(1135) = -rxt(204)*y(10)
         mat(1040) = -rxt(220)*y(10)
         mat(978) = -rxt(241)*y(10)
         mat(798) = -rxt(303)*y(10)
         mat(770) = -rxt(356)*y(10)
         mat(66) = -rxt(390)*y(10)
         mat(818) = -rxt(427)*y(10)

         mat(1200) = mat(1200) + rxt(192)*y(9)
         mat(954) = mat(954) + rxt(190)*y(9) + rxt(201)*y(11)
         mat(1255) = rxt(192)*y(1) + rxt(190)*y(2) + 2.000_r8*rxt(200)*y(11) &
                      + rxt(273)*y(16) + rxt(191)*y(24) + rxt(219)*y(30) + rxt(240) &
                      *y(38) + rxt(321)*y(64) + rxt(302)*y(48) + rxt(334)*y(73) &
                      + .900_r8*rxt(375)*y(84) + rxt(338)*y(74) + .900_r8*rxt(386) &
                      *y(96) + rxt(394)*y(100) + .920_r8*rxt(362)*y(88) + rxt(343) &
                      *y(79) + rxt(350)*y(76) + rxt(295)*y(46) + rxt(316)*y(61) &
                      + rxt(289)*y(55) + rxt(325)*y(67) + 1.206_r8*rxt(368)*y(89) &
                      + rxt(378)*y(91) + rxt(281)*y(131)
         mat(1292) = mat(1292) + .700_r8*rxt(390)*y(98)
         mat(1390) = mat(1390) + rxt(202)*y(11) + rxt(205)*y(13) + rxt(332)*y(82) &
                      + .400_r8*rxt(372)*y(90)
         mat(1434) = mat(1434) + rxt(201)*y(2) + 2.000_r8*rxt(200)*y(9) + rxt(202) &
                      *y(23) + rxt(203)*y(24) + rxt(363)*y(88) + rxt(345)*y(79) &
                      + rxt(351)*y(76) + rxt(393)*y(99) + 1.206_r8*rxt(369)*y(89) &
                      + rxt(373)*y(90) + rxt(379)*y(91)
         mat(220) = rxt(205)*y(23)
         mat(882) = rxt(273)*y(9)
         mat(1135) = mat(1135) + rxt(191)*y(9) + rxt(203)*y(11) + .206_r8*rxt(370) &
                      *y(89)
         mat(1040) = mat(1040) + rxt(219)*y(9)
         mat(978) = mat(978) + rxt(240)*y(9)
         mat(450) = rxt(321)*y(9)
         mat(798) = mat(798) + rxt(302)*y(9)
         mat(154) = rxt(332)*y(23)
         mat(115) = rxt(334)*y(9)
         mat(368) = .900_r8*rxt(375)*y(9)
         mat(342) = rxt(338)*y(9)
         mat(254) = .900_r8*rxt(386)*y(9)
         mat(66) = mat(66) + .700_r8*rxt(390)*y(10)
         mat(550) = rxt(394)*y(9)
         mat(709) = .920_r8*rxt(362)*y(9) + rxt(363)*y(11)
         mat(730) = rxt(343)*y(9) + rxt(345)*y(11)
         mat(770) = mat(770) + rxt(350)*y(9) + rxt(351)*y(11)
         mat(470) = rxt(295)*y(9)
         mat(311) = rxt(393)*y(11)
         mat(527) = rxt(316)*y(9)
         mat(395) = rxt(289)*y(9)
         mat(634) = rxt(325)*y(9)
         mat(581) = 1.206_r8*rxt(368)*y(9) + 1.206_r8*rxt(369)*y(11) &
                      + .206_r8*rxt(370)*y(24)
         mat(536) = .400_r8*rxt(372)*y(23) + rxt(373)*y(11)
         mat(685) = rxt(378)*y(9) + rxt(379)*y(11)
         mat(184) = rxt(281)*y(9)

         mat(1391) = -(rxt(168)*y(2) + rxt(169)*y(1) + rxt(170)*y(24) + (4._r8*rxt(171) &
                      + 4._r8*rxt(172)) * y(23) + rxt(173)*y(21) + rxt(174)*y(25) &
                      + rxt(180)*y(42) + rxt(181)*y(43) + rxt(184)*y(8) + rxt(198) &
                      *y(10) + rxt(199)*y(12) + rxt(202)*y(11) + rxt(205)*y(13) &
                      + (rxt(215) + rxt(216)) * y(30) + rxt(226)*y(33) + rxt(230) &
                      *y(34) + rxt(232)*y(35) + rxt(238)*y(38) + rxt(246)*y(39) &
                      + (rxt(267) + rxt(268)) * y(20) + rxt(270)*y(19) + rxt(277) &
                      *y(18) + rxt(278)*y(17) + rxt(279)*y(130) + rxt(286)*y(129) &
                      + rxt(287)*y(45) + rxt(288)*y(44) + rxt(294)*y(49) + rxt(299) &
                      *y(47) + rxt(300)*y(50) + rxt(307)*y(54) + rxt(308)*y(52) &
                      + rxt(309)*y(53) + rxt(310)*y(51) + rxt(312)*y(58) + rxt(313) &
                      *y(59) + rxt(319)*y(62) + rxt(320)*y(60) + rxt(323)*y(65) &
                      + rxt(324)*y(63) + rxt(328)*y(69) + rxt(329)*y(66) + rxt(330) &
                      *y(68) + rxt(332)*y(82) + rxt(333)*y(70) + rxt(335)*y(77) &
                      + rxt(337)*y(72) + rxt(340)*y(75) + rxt(341)*y(78) + rxt(349) &
                      *y(80) + rxt(358)*y(81) + rxt(359)*y(83) + rxt(365)*y(93) &
                      + rxt(371)*y(71) + rxt(372)*y(90) + rxt(374)*y(87) + rxt(377) &
                      *y(85) + rxt(383)*y(92) + rxt(385)*y(94) + rxt(388)*y(97) &
                      + rxt(389)*y(95) + rxt(391)*y(99) + rxt(396)*y(101) + rxt(420) &
                      *y(146) + rxt(421)*y(147) + rxt(424)*y(148) + rxt(431)*y(141) &
                      + (rxt(433) + rxt(434)) * y(142))
         mat(955) = -rxt(168)*y(23)
         mat(1201) = -rxt(169)*y(23)
         mat(1136) = -rxt(170)*y(23)
         mat(659) = -rxt(173)*y(23)
         mat(319) = -rxt(174)*y(23)
         mat(62) = -rxt(180)*y(23)
         mat(21) = -rxt(181)*y(23)
         mat(486) = -rxt(184)*y(23)
         mat(1293) = -rxt(198)*y(23)
         mat(1457) = -rxt(199)*y(23)
         mat(1435) = -rxt(202)*y(23)
         mat(221) = -rxt(205)*y(23)
         mat(1041) = -(rxt(215) + rxt(216)) * y(23)
         mat(835) = -rxt(226)*y(23)
         mat(493) = -rxt(230)*y(23)
         mat(568) = -rxt(232)*y(23)
         mat(979) = -rxt(238)*y(23)
         mat(459) = -rxt(246)*y(23)
         mat(607) = -(rxt(267) + rxt(268)) * y(23)
         mat(1507) = -rxt(270)*y(23)
         mat(272) = -rxt(277)*y(23)
         mat(159) = -rxt(278)*y(23)
         mat(245) = -rxt(279)*y(23)
         mat(97) = -rxt(286)*y(23)
         mat(90) = -rxt(287)*y(23)
         mat(241) = -rxt(288)*y(23)
         mat(323) = -rxt(294)*y(23)
         mat(131) = -rxt(299)*y(23)
         mat(614) = -rxt(300)*y(23)
         mat(232) = -rxt(307)*y(23)
         mat(515) = -rxt(308)*y(23)
         mat(380) = -rxt(309)*y(23)
         mat(80) = -rxt(310)*y(23)
         mat(200) = -rxt(312)*y(23)
         mat(600) = -rxt(313)*y(23)
         mat(172) = -rxt(319)*y(23)
         mat(33) = -rxt(320)*y(23)
         mat(267) = -rxt(323)*y(23)
         mat(375) = -rxt(324)*y(23)
         mat(177) = -rxt(328)*y(23)
         mat(622) = -rxt(329)*y(23)
         mat(668) = -rxt(330)*y(23)
         mat(155) = -rxt(332)*y(23)
         mat(30) = -rxt(333)*y(23)
         mat(752) = -rxt(335)*y(23)
         mat(190) = -rxt(337)*y(23)
         mat(121) = -rxt(340)*y(23)
         mat(647) = -rxt(341)*y(23)
         mat(126) = -rxt(349)*y(23)
         mat(295) = -rxt(358)*y(23)
         mat(507) = -rxt(359)*y(23)
         mat(280) = -rxt(365)*y(23)
         mat(27) = -rxt(371)*y(23)
         mat(537) = -rxt(372)*y(23)
         mat(143) = -rxt(374)*y(23)
         mat(334) = -rxt(377)*y(23)
         mat(134) = -rxt(383)*y(23)
         mat(39) = -rxt(385)*y(23)
         mat(167) = -rxt(388)*y(23)
         mat(42) = -rxt(389)*y(23)
         mat(312) = -rxt(391)*y(23)
         mat(216) = -rxt(396)*y(23)
         mat(151) = -rxt(420)*y(23)
         mat(387) = -rxt(421)*y(23)
         mat(819) = -rxt(424)*y(23)
         mat(558) = -rxt(431)*y(23)
         mat(101) = -(rxt(433) + rxt(434)) * y(23)

         mat(1201) = mat(1201) + rxt(164)*y(22) + rxt(177)*y(24) + .330_r8*rxt(314) &
                      *y(59) + .270_r8*rxt(360)*y(83) + .120_r8*rxt(293)*y(44) &
                      + .080_r8*rxt(336)*y(77) + .215_r8*rxt(342)*y(78) &
                      + .700_r8*rxt(392)*y(99)
         mat(955) = mat(955) + rxt(175)*y(21) + rxt(271)*y(19) + rxt(176)*y(24) &
                      + rxt(179)*y(25) + rxt(227)*y(33) + rxt(228)*y(34) + rxt(247) &
                      *y(39) + rxt(248)*y(40)
         mat(1067) = rxt(159)*y(21) + rxt(162)*y(42) + 2.000_r8*rxt(134)*y(128) &
                      + rxt(160)*y(33) + rxt(161)*y(39)
         mat(659) = mat(659) + rxt(175)*y(2) + rxt(159)*y(3)
         mat(1256) = rxt(191)*y(24)
         mat(1391) = mat(1391) + .300_r8*rxt(278)*y(17) + .500_r8*rxt(323)*y(65) &
                      + .100_r8*rxt(349)*y(80) + .500_r8*rxt(299)*y(47) &
                      + .650_r8*rxt(286)*y(129)
         mat(1435) = mat(1435) + rxt(203)*y(24)
         mat(159) = mat(159) + .300_r8*rxt(278)*y(23)
         mat(62) = mat(62) + rxt(162)*y(3)
         mat(1507) = mat(1507) + rxt(271)*y(2)
         mat(1156) = rxt(164)*y(1) + 2.000_r8*rxt(165)*y(24)
         mat(1136) = mat(1136) + rxt(177)*y(1) + rxt(176)*y(2) + rxt(191)*y(9) &
                      + rxt(203)*y(11) + 2.000_r8*rxt(165)*y(22) + rxt(211)*y(28)
         mat(319) = mat(319) + rxt(179)*y(2)
         mat(1483) = 2.000_r8*rxt(134)*y(3) + rxt(250)*y(135)
         mat(1014) = rxt(211)*y(24)
         mat(835) = mat(835) + rxt(227)*y(2) + rxt(160)*y(3)
         mat(493) = mat(493) + rxt(228)*y(2)
         mat(459) = mat(459) + rxt(247)*y(2) + rxt(161)*y(3)
         mat(405) = rxt(248)*y(2)
         mat(600) = mat(600) + .330_r8*rxt(314)*y(1)
         mat(507) = mat(507) + .270_r8*rxt(360)*y(1)
         mat(267) = mat(267) + .500_r8*rxt(323)*y(23)
         mat(241) = mat(241) + .120_r8*rxt(293)*y(1)
         mat(752) = mat(752) + .080_r8*rxt(336)*y(1)
         mat(647) = mat(647) + .215_r8*rxt(342)*y(1)
         mat(126) = mat(126) + .100_r8*rxt(349)*y(23)
         mat(131) = mat(131) + .500_r8*rxt(299)*y(23)
         mat(312) = mat(312) + .700_r8*rxt(392)*y(1)
         mat(97) = mat(97) + .650_r8*rxt(286)*y(23)
         mat(439) = rxt(250)*y(128)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1436) = -(rxt(196)*y(10) + rxt(200)*y(9) + rxt(201)*y(2) + rxt(202)*y(23) &
                      + rxt(203)*y(24) + rxt(269)*y(19) + rxt(301)*y(50) + rxt(315) &
                      *y(59) + rxt(331)*y(68) + rxt(345)*y(79) + rxt(351)*y(76) &
                      + rxt(361)*y(83) + rxt(363)*y(88) + rxt(369)*y(89) + rxt(373) &
                      *y(90) + rxt(379)*y(91) + rxt(393)*y(99) + rxt(435)*y(142))
         mat(1294) = -rxt(196)*y(11)
         mat(1257) = -rxt(200)*y(11)
         mat(956) = -rxt(201)*y(11)
         mat(1392) = -rxt(202)*y(11)
         mat(1137) = -rxt(203)*y(11)
         mat(1508) = -rxt(269)*y(11)
         mat(615) = -rxt(301)*y(11)
         mat(601) = -rxt(315)*y(11)
         mat(669) = -rxt(331)*y(11)
         mat(732) = -rxt(345)*y(11)
         mat(772) = -rxt(351)*y(11)
         mat(508) = -rxt(361)*y(11)
         mat(711) = -rxt(363)*y(11)
         mat(583) = -rxt(369)*y(11)
         mat(538) = -rxt(373)*y(11)
         mat(687) = -rxt(379)*y(11)
         mat(313) = -rxt(393)*y(11)
         mat(102) = -rxt(435)*y(11)

         mat(1202) = rxt(195)*y(10)
         mat(956) = mat(956) + rxt(194)*y(10) + rxt(231)*y(35) + rxt(249)*y(41)
         mat(1294) = mat(1294) + rxt(195)*y(1) + rxt(194)*y(2)
         mat(1392) = mat(1392) + rxt(199)*y(12) + rxt(232)*y(35) + rxt(312)*y(58) &
                      + .500_r8*rxt(358)*y(81)
         mat(1458) = rxt(199)*y(23) + rxt(253)*y(135)
         mat(1015) = rxt(233)*y(35)
         mat(569) = rxt(231)*y(2) + rxt(232)*y(23) + rxt(233)*y(28)
         mat(288) = rxt(249)*y(2)
         mat(201) = rxt(312)*y(23)
         mat(296) = .500_r8*rxt(358)*y(23)
         mat(440) = rxt(253)*y(12)

         mat(1459) = -(rxt(199)*y(23) + rxt(253)*y(135))
         mat(1393) = -rxt(199)*y(12)
         mat(441) = -rxt(253)*y(12)

         mat(1295) = rxt(198)*y(23)
         mat(1393) = mat(1393) + rxt(198)*y(10)
         mat(1437) = rxt(269)*y(19) + rxt(301)*y(50) + rxt(331)*y(68) + rxt(435) &
                      *y(142)
         mat(1509) = rxt(269)*y(11)
         mat(837) = (rxt(439)+rxt(444)+rxt(450))*y(35)
         mat(570) = (rxt(439)+rxt(444)+rxt(450))*y(33)
         mat(616) = rxt(301)*y(11)
         mat(670) = rxt(331)*y(11)
         mat(103) = rxt(435)*y(11)

         mat(217) = -(rxt(205)*y(23))
         mat(1328) = -rxt(205)*y(13)

         mat(1264) = rxt(204)*y(24)
         mat(1084) = rxt(204)*y(10)


         mat(1262) = rxt(196)*y(11)
         mat(1397) = rxt(196)*y(10)

         mat(874) = -(rxt(218)*y(30) + rxt(273)*y(9) + rxt(274)*y(24) + (4._r8*rxt(275) &
                      + 4._r8*rxt(276)) * y(16) + rxt(297)*y(46) + rxt(305)*y(48) &
                      + rxt(318)*y(61) + rxt(327)*y(67) + rxt(347)*y(79) + rxt(353) &
                      *y(76) + rxt(366)*y(88) + rxt(381)*y(91))
         mat(1029) = -rxt(218)*y(16)
         mat(1244) = -rxt(273)*y(16)
         mat(1124) = -rxt(274)*y(16)
         mat(466) = -rxt(297)*y(16)
         mat(792) = -rxt(305)*y(16)
         mat(523) = -rxt(318)*y(16)
         mat(630) = -rxt(327)*y(16)
         mat(726) = -rxt(347)*y(16)
         mat(764) = -rxt(353)*y(16)
         mat(704) = -rxt(366)*y(16)
         mat(681) = -rxt(381)*y(16)

         mat(1189) = .310_r8*rxt(314)*y(59)
         mat(1244) = mat(1244) + rxt(302)*y(48)
         mat(1379) = .700_r8*rxt(278)*y(17) + rxt(294)*y(49)
         mat(874) = mat(874) + .900_r8*rxt(305)*y(48)
         mat(157) = .700_r8*rxt(278)*y(23)
         mat(594) = .310_r8*rxt(314)*y(1)
         mat(322) = rxt(294)*y(23)
         mat(792) = mat(792) + rxt(302)*y(9) + .900_r8*rxt(305)*y(16) &
                      + 4.000_r8*rxt(306)*y(48) + rxt(367)*y(88) + rxt(348)*y(79) &
                      + rxt(354)*y(76) + rxt(382)*y(91)
         mat(704) = mat(704) + rxt(367)*y(48)
         mat(726) = mat(726) + rxt(348)*y(48)
         mat(764) = mat(764) + rxt(354)*y(48)
         mat(681) = mat(681) + rxt(382)*y(48)

         mat(156) = -(rxt(278)*y(23))
         mat(1321) = -rxt(278)*y(17)

         mat(854) = rxt(274)*y(24)
         mat(1077) = rxt(274)*y(16)

         mat(59) = -(rxt(162)*y(3) + rxt(180)*y(23))
         mat(1048) = -rxt(162)*y(42)
         mat(1305) = -rxt(180)*y(42)

         mat(19) = -(rxt(181)*y(23))
         mat(1298) = -rxt(181)*y(43)

         mat(1511) = -(rxt(212)*y(28) + rxt(236)*y(37) + rxt(269)*y(11) + rxt(270) &
                      *y(23) + rxt(271)*y(2) + rxt(272)*y(24))
         mat(1018) = -rxt(212)*y(19)
         mat(851) = -rxt(236)*y(19)
         mat(1439) = -rxt(269)*y(19)
         mat(1395) = -rxt(270)*y(19)
         mat(959) = -rxt(271)*y(19)
         mat(1140) = -rxt(272)*y(19)

         mat(1205) = .540_r8*rxt(314)*y(59) + .600_r8*rxt(360)*y(83) + rxt(293)*y(44) &
                      + .800_r8*rxt(336)*y(77) + .700_r8*rxt(342)*y(78)
         mat(1260) = rxt(273)*y(16) + rxt(321)*y(64) + .500_r8*rxt(334)*y(73) &
                      + .100_r8*rxt(375)*y(84) + .510_r8*rxt(362)*y(88) &
                      + .250_r8*rxt(343)*y(79) + rxt(350)*y(76) + .500_r8*rxt(289) &
                      *y(55) + rxt(325)*y(67) + .072_r8*rxt(368)*y(89)
         mat(1395) = mat(1395) + .300_r8*rxt(278)*y(17) + .500_r8*rxt(307)*y(54) &
                      + rxt(312)*y(58) + .500_r8*rxt(358)*y(81) + rxt(277)*y(18) &
                      + .800_r8*rxt(308)*y(52)
         mat(1439) = mat(1439) + .600_r8*rxt(363)*y(88) + .250_r8*rxt(345)*y(79) &
                      + rxt(351)*y(76) + .072_r8*rxt(369)*y(89)
         mat(887) = rxt(273)*y(9) + (4.000_r8*rxt(275)+2.000_r8*rxt(276))*y(16) &
                      + rxt(218)*y(30) + rxt(305)*y(48) + 1.200_r8*rxt(366)*y(88) &
                      + .880_r8*rxt(347)*y(79) + 2.000_r8*rxt(353)*y(76) &
                      + .700_r8*rxt(297)*y(46) + rxt(318)*y(61) + .800_r8*rxt(327) &
                      *y(67) + .700_r8*rxt(381)*y(91)
         mat(161) = .300_r8*rxt(278)*y(23)
         mat(1140) = mat(1140) + .008_r8*rxt(370)*y(89)
         mat(1045) = rxt(218)*y(16)
         mat(603) = .540_r8*rxt(314)*y(1)
         mat(510) = .600_r8*rxt(360)*y(1)
         mat(453) = rxt(321)*y(9)
         mat(803) = rxt(305)*y(16) + .600_r8*rxt(367)*y(88) + .250_r8*rxt(348)*y(79) &
                      + rxt(354)*y(76)
         mat(234) = .500_r8*rxt(307)*y(23)
         mat(202) = rxt(312)*y(23)
         mat(242) = rxt(293)*y(1)
         mat(297) = .500_r8*rxt(358)*y(23)
         mat(116) = .500_r8*rxt(334)*y(9)
         mat(370) = .100_r8*rxt(375)*y(9)
         mat(714) = .510_r8*rxt(362)*y(9) + .600_r8*rxt(363)*y(11) + 1.200_r8*rxt(366) &
                      *y(16) + .600_r8*rxt(367)*y(48)
         mat(756) = .800_r8*rxt(336)*y(1)
         mat(649) = .700_r8*rxt(342)*y(1)
         mat(735) = .250_r8*rxt(343)*y(9) + .250_r8*rxt(345)*y(11) + .880_r8*rxt(347) &
                      *y(16) + .250_r8*rxt(348)*y(48)
         mat(775) = rxt(350)*y(9) + rxt(351)*y(11) + 2.000_r8*rxt(353)*y(16) &
                      + rxt(354)*y(48) + 4.000_r8*rxt(355)*y(76)
         mat(472) = .700_r8*rxt(297)*y(16)
         mat(530) = rxt(318)*y(16)
         mat(273) = rxt(277)*y(23)
         mat(516) = .800_r8*rxt(308)*y(23)
         mat(397) = .500_r8*rxt(289)*y(9)
         mat(637) = rxt(325)*y(9) + .800_r8*rxt(327)*y(16)
         mat(585) = .072_r8*rxt(368)*y(9) + .072_r8*rxt(369)*y(11) + .008_r8*rxt(370) &
                      *y(24)
         mat(690) = .700_r8*rxt(381)*y(16)

         mat(1152) = -(rxt(163)*y(4) + rxt(164)*y(1) + (rxt(165) + rxt(166) + rxt(167) &
                      ) * y(24))
         mat(912) = -rxt(163)*y(22)
         mat(1197) = -rxt(164)*y(22)
         mat(1132) = -(rxt(165) + rxt(166) + rxt(167)) * y(22)

         mat(951) = rxt(175)*y(21) + rxt(168)*y(23)
         mat(1063) = rxt(159)*y(21)
         mat(658) = rxt(175)*y(2) + rxt(159)*y(3) + rxt(173)*y(23) + rxt(208)*y(28) &
                      + rxt(251)*y(135)
         mat(606) = rxt(267)*y(23)
         mat(483) = rxt(184)*y(23)
         mat(1387) = rxt(168)*y(2) + rxt(173)*y(21) + rxt(267)*y(20) + rxt(184)*y(8) &
                      + rxt(270)*y(19) + rxt(420)*y(146) + rxt(421)*y(147) + rxt(424) &
                      *y(148)
         mat(1503) = rxt(270)*y(23)
         mat(1010) = rxt(208)*y(21)
         mat(438) = rxt(251)*y(21)
         mat(150) = rxt(420)*y(23)
         mat(385) = rxt(421)*y(23)
         mat(815) = rxt(424)*y(23)

         mat(1131) = -((rxt(165) + rxt(166) + rxt(167)) * y(22) + rxt(170)*y(23) &
                      + rxt(176)*y(2) + rxt(177)*y(1) + 4._r8*rxt(178)*y(24) + rxt(191) &
                      *y(9) + rxt(203)*y(11) + rxt(204)*y(10) + (rxt(210) + rxt(211) &
                      ) * y(28) + rxt(217)*y(30) + rxt(235)*y(37) + rxt(239)*y(38) &
                      + rxt(272)*y(19) + rxt(274)*y(16) + rxt(282)*y(131) + rxt(290) &
                      *y(55) + rxt(296)*y(46) + rxt(304)*y(48) + rxt(317)*y(61) &
                      + rxt(322)*y(64) + rxt(326)*y(67) + rxt(339)*y(74) + rxt(346) &
                      *y(79) + rxt(352)*y(76) + rxt(364)*y(88) + rxt(370)*y(89) &
                      + rxt(376)*y(84) + rxt(380)*y(91) + rxt(387)*y(96) + rxt(395) &
                      *y(100))
         mat(1151) = -(rxt(165) + rxt(166) + rxt(167)) * y(24)
         mat(1386) = -rxt(170)*y(24)
         mat(950) = -rxt(176)*y(24)
         mat(1196) = -rxt(177)*y(24)
         mat(1251) = -rxt(191)*y(24)
         mat(1430) = -rxt(203)*y(24)
         mat(1288) = -rxt(204)*y(24)
         mat(1009) = -(rxt(210) + rxt(211)) * y(24)
         mat(1036) = -rxt(217)*y(24)
         mat(846) = -rxt(235)*y(24)
         mat(974) = -rxt(239)*y(24)
         mat(1502) = -rxt(272)*y(24)
         mat(878) = -rxt(274)*y(24)
         mat(182) = -rxt(282)*y(24)
         mat(393) = -rxt(290)*y(24)
         mat(468) = -rxt(296)*y(24)
         mat(794) = -rxt(304)*y(24)
         mat(525) = -rxt(317)*y(24)
         mat(448) = -rxt(322)*y(24)
         mat(632) = -rxt(326)*y(24)
         mat(340) = -rxt(339)*y(24)
         mat(727) = -rxt(346)*y(24)
         mat(766) = -rxt(352)*y(24)
         mat(705) = -rxt(364)*y(24)
         mat(579) = -rxt(370)*y(24)
         mat(366) = -rxt(376)*y(24)
         mat(682) = -rxt(380)*y(24)
         mat(252) = -rxt(387)*y(24)
         mat(548) = -rxt(395)*y(24)

         mat(1196) = mat(1196) + rxt(169)*y(23) + .190_r8*rxt(314)*y(59) &
                      + .060_r8*rxt(360)*y(83) + .120_r8*rxt(293)*y(44) &
                      + .060_r8*rxt(336)*y(77) + .275_r8*rxt(342)*y(78) + rxt(392) &
                      *y(99)
         mat(950) = mat(950) + rxt(271)*y(19) + rxt(179)*y(25)
         mat(911) = rxt(163)*y(22) + rxt(291)*y(56)
         mat(605) = rxt(268)*y(23)
         mat(1251) = mat(1251) + rxt(273)*y(16) + rxt(321)*y(64) + rxt(334)*y(73) &
                      + .900_r8*rxt(375)*y(84) + .900_r8*rxt(386)*y(96) + rxt(394) &
                      *y(100) + rxt(362)*y(88) + .470_r8*rxt(343)*y(79) + rxt(295) &
                      *y(46) + rxt(316)*y(61) + .250_r8*rxt(289)*y(55) &
                      + .794_r8*rxt(368)*y(89) + rxt(378)*y(91) + rxt(281)*y(131)
         mat(1288) = mat(1288) + .700_r8*rxt(390)*y(98)
         mat(1386) = mat(1386) + rxt(169)*y(1) + rxt(268)*y(20) + rxt(202)*y(11) &
                      + rxt(180)*y(42) + rxt(181)*y(43) + rxt(174)*y(25) + rxt(215) &
                      *y(30) + rxt(238)*y(38) + .500_r8*rxt(358)*y(81) &
                      + .250_r8*rxt(385)*y(94) + rxt(309)*y(53) + .200_r8*rxt(349) &
                      *y(80) + rxt(277)*y(18) + rxt(310)*y(51) + rxt(308)*y(52) &
                      + rxt(329)*y(66) + rxt(372)*y(90) + .350_r8*rxt(286)*y(129) &
                      + rxt(279)*y(130) + rxt(431)*y(141) + .500_r8*rxt(434)*y(142)
         mat(1430) = mat(1430) + rxt(202)*y(23) + rxt(269)*y(19) + rxt(363)*y(88) &
                      + .470_r8*rxt(345)*y(79) + .794_r8*rxt(369)*y(89) + rxt(373) &
                      *y(90) + rxt(379)*y(91)
         mat(878) = mat(878) + rxt(273)*y(9) + 4.000_r8*rxt(275)*y(16) + rxt(218) &
                      *y(30) + .900_r8*rxt(305)*y(48) + rxt(366)*y(88) &
                      + .730_r8*rxt(347)*y(79) + rxt(353)*y(76) + rxt(297)*y(46) &
                      + rxt(318)*y(61) + .300_r8*rxt(327)*y(67) + .800_r8*rxt(381) &
                      *y(91)
         mat(61) = rxt(180)*y(23)
         mat(20) = rxt(181)*y(23)
         mat(1502) = mat(1502) + rxt(271)*y(2) + rxt(269)*y(11) + rxt(212)*y(28) &
                      + rxt(236)*y(37)
         mat(1151) = mat(1151) + rxt(163)*y(4)
         mat(1131) = mat(1131) + .794_r8*rxt(370)*y(89)
         mat(318) = rxt(179)*y(2) + rxt(174)*y(23) + rxt(209)*y(28)
         mat(1009) = mat(1009) + rxt(212)*y(19) + rxt(209)*y(25)
         mat(1036) = mat(1036) + rxt(215)*y(23) + rxt(218)*y(16)
         mat(846) = mat(846) + rxt(236)*y(19)
         mat(974) = mat(974) + rxt(238)*y(23)
         mat(596) = .190_r8*rxt(314)*y(1)
         mat(505) = .060_r8*rxt(360)*y(1)
         mat(448) = mat(448) + rxt(321)*y(9)
         mat(794) = mat(794) + .900_r8*rxt(305)*y(16) + rxt(367)*y(88) &
                      + .470_r8*rxt(348)*y(79) + rxt(382)*y(91)
         mat(239) = .120_r8*rxt(293)*y(1)
         mat(293) = .500_r8*rxt(358)*y(23)
         mat(113) = rxt(334)*y(9)
         mat(366) = mat(366) + .900_r8*rxt(375)*y(9)
         mat(38) = .250_r8*rxt(385)*y(23)
         mat(252) = mat(252) + .900_r8*rxt(386)*y(9)
         mat(65) = .700_r8*rxt(390)*y(10)
         mat(548) = mat(548) + rxt(394)*y(9)
         mat(379) = rxt(309)*y(23)
         mat(705) = mat(705) + rxt(362)*y(9) + rxt(363)*y(11) + rxt(366)*y(16) &
                      + rxt(367)*y(48)
         mat(747) = .060_r8*rxt(336)*y(1)
         mat(644) = .275_r8*rxt(342)*y(1)
         mat(727) = mat(727) + .470_r8*rxt(343)*y(9) + .470_r8*rxt(345)*y(11) &
                      + .730_r8*rxt(347)*y(16) + .470_r8*rxt(348)*y(48)
         mat(125) = .200_r8*rxt(349)*y(23)
         mat(766) = mat(766) + rxt(353)*y(16)
         mat(468) = mat(468) + rxt(295)*y(9) + rxt(297)*y(16) + 2.400_r8*rxt(298) &
                      *y(46)
         mat(309) = rxt(392)*y(1)
         mat(525) = mat(525) + rxt(316)*y(9) + rxt(318)*y(16)
         mat(271) = rxt(277)*y(23)
         mat(79) = rxt(310)*y(23)
         mat(514) = rxt(308)*y(23)
         mat(621) = rxt(329)*y(23)
         mat(393) = mat(393) + .250_r8*rxt(289)*y(9)
         mat(194) = rxt(291)*y(4)
         mat(632) = mat(632) + .300_r8*rxt(327)*y(16)
         mat(579) = mat(579) + .794_r8*rxt(368)*y(9) + .794_r8*rxt(369)*y(11) &
                      + .794_r8*rxt(370)*y(24)
         mat(535) = rxt(372)*y(23) + rxt(373)*y(11)
         mat(682) = mat(682) + rxt(378)*y(9) + rxt(379)*y(11) + .800_r8*rxt(381)*y(16) &
                      + rxt(382)*y(48)
         mat(96) = .350_r8*rxt(286)*y(23)
         mat(244) = rxt(279)*y(23)
         mat(182) = mat(182) + rxt(281)*y(9)
         mat(557) = rxt(431)*y(23)
         mat(100) = .500_r8*rxt(434)*y(23)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(314) = -(rxt(174)*y(23) + rxt(179)*y(2) + rxt(209)*y(28))
         mat(1339) = -rxt(174)*y(25)
         mat(926) = -rxt(179)*y(25)
         mat(989) = -rxt(209)*y(25)

         mat(1339) = mat(1339) + 2.000_r8*rxt(172)*y(23)
         mat(1091) = 2.000_r8*rxt(178)*y(24)

         mat(1486) = -(rxt(134)*y(3) + rxt(250)*y(135) + rxt(432)*y(149))
         mat(1070) = -rxt(134)*y(128)
         mat(442) = -rxt(250)*y(128)
         mat(85) = -rxt(432)*y(128)

         mat(662) = rxt(173)*y(23)
         mat(1394) = rxt(173)*y(21) + 2.000_r8*rxt(171)*y(23) + rxt(199)*y(12) &
                      + rxt(205)*y(13) + rxt(278)*y(17) + rxt(270)*y(19) + rxt(170) &
                      *y(24) + rxt(174)*y(25) + rxt(226)*y(33) + rxt(230)*y(34) &
                      + rxt(246)*y(39) + rxt(300)*y(50) + rxt(294)*y(49) + rxt(323) &
                      *y(65) + rxt(307)*y(54) + rxt(287)*y(45) + .500_r8*rxt(341) &
                      *y(78) + rxt(320)*y(60) + rxt(319)*y(62) + rxt(324)*y(63) &
                      + rxt(328)*y(69) + rxt(330)*y(68) + (rxt(383)+rxt(384))*y(92) &
                      + rxt(279)*y(130)
         mat(1460) = rxt(199)*y(23)
         mat(223) = rxt(205)*y(23)
         mat(160) = rxt(278)*y(23)
         mat(1510) = rxt(270)*y(23)
         mat(1159) = rxt(167)*y(24)
         mat(1139) = rxt(170)*y(23) + rxt(167)*y(22)
         mat(320) = rxt(174)*y(23)
         mat(838) = rxt(226)*y(23) + (rxt(440)+rxt(445)+rxt(451))*y(34) + (rxt(441) &
                       +rxt(452))*y(40)
         mat(494) = rxt(230)*y(23) + (rxt(440)+rxt(445)+rxt(451))*y(33)
         mat(460) = rxt(246)*y(23)
         mat(406) = (rxt(441)+rxt(452))*y(33)
         mat(617) = rxt(300)*y(23)
         mat(324) = rxt(294)*y(23)
         mat(268) = rxt(323)*y(23)
         mat(233) = rxt(307)*y(23)
         mat(91) = rxt(287)*y(23)
         mat(648) = .500_r8*rxt(341)*y(23)
         mat(34) = rxt(320)*y(23)
         mat(173) = rxt(319)*y(23)
         mat(376) = rxt(324)*y(23)
         mat(178) = rxt(328)*y(23)
         mat(671) = rxt(330)*y(23)
         mat(135) = (rxt(383)+rxt(384))*y(23)
         mat(246) = rxt(279)*y(23)

         mat(1006) = -(rxt(207)*y(1) + rxt(208)*y(21) + rxt(209)*y(25) + (rxt(210) &
                      + rxt(211)) * y(24) + rxt(212)*y(19) + rxt(229)*y(34) + rxt(233) &
                      *y(35) + rxt(285)*y(45))
         mat(1193) = -rxt(207)*y(28)
         mat(656) = -rxt(208)*y(28)
         mat(317) = -rxt(209)*y(28)
         mat(1128) = -(rxt(210) + rxt(211)) * y(28)
         mat(1499) = -rxt(212)*y(28)
         mat(491) = -rxt(229)*y(28)
         mat(565) = -rxt(233)*y(28)
         mat(89) = -rxt(285)*y(28)

         mat(947) = rxt(214)*y(30) + rxt(227)*y(33)
         mat(1059) = rxt(160)*y(33) + rxt(155)*y(133)
         mat(1248) = rxt(219)*y(30)
         mat(1383) = rxt(215)*y(30) + rxt(226)*y(33)
         mat(876) = rxt(218)*y(30)
         mat(1033) = rxt(214)*y(2) + rxt(219)*y(9) + rxt(215)*y(23) + rxt(218)*y(16) + ( &
                      + 4.000_r8*rxt(221)+2.000_r8*rxt(223))*y(30) + rxt(243)*y(38) &
                      + rxt(428)*y(148)
         mat(830) = rxt(227)*y(2) + rxt(160)*y(3) + rxt(226)*y(23)
         mat(971) = rxt(243)*y(30)
         mat(69) = rxt(155)*y(3)
         mat(812) = rxt(428)*y(30)


         mat(984) = rxt(233)*y(35)
         mat(1020) = 2.000_r8*rxt(222)*y(30)
         mat(821) = (rxt(440)+rxt(445)+rxt(451))*y(34) + (rxt(439)+rxt(444)+rxt(450)) &
                      *y(35)
         mat(487) = (rxt(440)+rxt(445)+rxt(451))*y(33)
         mat(560) = rxt(233)*y(28) + (rxt(439)+rxt(444)+rxt(450))*y(33)

         mat(1034) = -(rxt(214)*y(2) + (rxt(215) + rxt(216)) * y(23) + rxt(217)*y(24) &
                      + rxt(218)*y(16) + rxt(219)*y(9) + rxt(220)*y(10) + (4._r8*rxt(221) &
                      + 4._r8*rxt(222) + 4._r8*rxt(223) + 4._r8*rxt(224)) * y(30) &
                      + (rxt(242) + rxt(243) + rxt(244)) * y(38) + rxt(428)*y(148))
         mat(948) = -rxt(214)*y(30)
         mat(1384) = -(rxt(215) + rxt(216)) * y(30)
         mat(1129) = -rxt(217)*y(30)
         mat(877) = -rxt(218)*y(30)
         mat(1249) = -rxt(219)*y(30)
         mat(1286) = -rxt(220)*y(30)
         mat(972) = -(rxt(242) + rxt(243) + rxt(244)) * y(30)
         mat(813) = -rxt(428)*y(30)

         mat(1194) = rxt(207)*y(28)
         mat(948) = mat(948) + rxt(228)*y(34) + rxt(231)*y(35)
         mat(1384) = mat(1384) + rxt(230)*y(34)
         mat(1129) = mat(1129) + rxt(211)*y(28)
         mat(1007) = rxt(207)*y(1) + rxt(211)*y(24) + rxt(229)*y(34)
         mat(140) = rxt(430)*y(148)
         mat(492) = rxt(228)*y(2) + rxt(230)*y(23) + rxt(229)*y(28)
         mat(566) = rxt(231)*y(2)
         mat(813) = mat(813) + rxt(430)*y(31)

         mat(136) = -(rxt(430)*y(148))
         mat(804) = -rxt(430)*y(31)

         mat(1022) = 2.000_r8*rxt(223)*y(30) + rxt(242)*y(38)
         mat(961) = rxt(242)*y(30)


         mat(1019) = 2.000_r8*rxt(224)*y(30)

         mat(826) = -(rxt(160)*y(3) + rxt(226)*y(23) + rxt(227)*y(2) + (rxt(439) &
                      + rxt(444) + rxt(450)) * y(35) + (rxt(440) + rxt(445) + rxt(451) &
                      ) * y(34) + (rxt(441) + rxt(452)) * y(40))
         mat(1053) = -rxt(160)*y(33)
         mat(1377) = -rxt(226)*y(33)
         mat(941) = -rxt(227)*y(33)
         mat(563) = -(rxt(439) + rxt(444) + rxt(450)) * y(33)
         mat(489) = -(rxt(440) + rxt(445) + rxt(451)) * y(33)
         mat(400) = -(rxt(441) + rxt(452)) * y(33)

         mat(653) = rxt(208)*y(28)
         mat(1377) = mat(1377) + rxt(216)*y(30)
         mat(1493) = rxt(212)*y(28)
         mat(1122) = rxt(210)*y(28)
         mat(315) = rxt(209)*y(28)
         mat(1000) = rxt(208)*y(21) + rxt(212)*y(19) + rxt(210)*y(24) + rxt(209)*y(25) &
                      + rxt(229)*y(34) + rxt(285)*y(45)
         mat(1027) = rxt(216)*y(23)
         mat(489) = mat(489) + rxt(229)*y(28)
         mat(88) = rxt(285)*y(28)

         mat(488) = -(rxt(228)*y(2) + rxt(229)*y(28) + rxt(230)*y(23) + (rxt(440) &
                      + rxt(445) + rxt(451)) * y(33))
         mat(935) = -rxt(228)*y(34)
         mat(993) = -rxt(229)*y(34)
         mat(1353) = -rxt(230)*y(34)
         mat(824) = -(rxt(440) + rxt(445) + rxt(451)) * y(34)

         mat(1353) = mat(1353) + rxt(232)*y(35)
         mat(1103) = rxt(217)*y(30)
         mat(1023) = rxt(217)*y(24)
         mat(561) = rxt(232)*y(23)

         mat(562) = -(rxt(231)*y(2) + rxt(232)*y(23) + rxt(233)*y(28) + (rxt(439) &
                      + rxt(444) + rxt(450)) * y(33))
         mat(937) = -rxt(231)*y(35)
         mat(1360) = -rxt(232)*y(35)
         mat(995) = -rxt(233)*y(35)
         mat(825) = -(rxt(439) + rxt(444) + rxt(450)) * y(35)

         mat(1272) = rxt(220)*y(30)
         mat(1025) = rxt(220)*y(10)


         mat(1021) = rxt(244)*y(38)
         mat(822) = (rxt(441)+rxt(452))*y(40)
         mat(960) = rxt(244)*y(30)
         mat(398) = (rxt(441)+rxt(452))*y(33)

         mat(841) = -(rxt(234)*y(1) + rxt(235)*y(24) + rxt(236)*y(19))
         mat(1188) = -rxt(234)*y(37)
         mat(1123) = -rxt(235)*y(37)
         mat(1494) = -rxt(236)*y(37)

         mat(942) = rxt(237)*y(38) + rxt(247)*y(39)
         mat(1054) = rxt(161)*y(39)
         mat(1243) = rxt(240)*y(38)
         mat(1378) = rxt(238)*y(38) + rxt(246)*y(39)
         mat(1028) = (rxt(242)+rxt(243))*y(38)
         mat(967) = rxt(237)*y(2) + rxt(240)*y(9) + rxt(238)*y(23) + (rxt(242) &
                       +rxt(243))*y(30) + 4.000_r8*rxt(245)*y(38) + rxt(429)*y(148)
         mat(455) = rxt(247)*y(2) + rxt(161)*y(3) + rxt(246)*y(23)
         mat(808) = rxt(429)*y(38)

         mat(970) = -(rxt(237)*y(2) + rxt(238)*y(23) + rxt(239)*y(24) + rxt(240)*y(9) &
                      + rxt(241)*y(10) + (rxt(242) + rxt(243) + rxt(244)) * y(30) &
                      + 4._r8*rxt(245)*y(38) + rxt(429)*y(148))
         mat(946) = -rxt(237)*y(38)
         mat(1382) = -rxt(238)*y(38)
         mat(1127) = -rxt(239)*y(38)
         mat(1247) = -rxt(240)*y(38)
         mat(1284) = -rxt(241)*y(38)
         mat(1032) = -(rxt(242) + rxt(243) + rxt(244)) * y(38)
         mat(811) = -rxt(429)*y(38)

         mat(1192) = rxt(234)*y(37)
         mat(946) = mat(946) + rxt(248)*y(40) + rxt(249)*y(41)
         mat(844) = rxt(234)*y(1)
         mat(403) = rxt(248)*y(2)
         mat(286) = rxt(249)*y(2)

         mat(454) = -(rxt(161)*y(3) + rxt(246)*y(23) + rxt(247)*y(2))
         mat(1051) = -rxt(161)*y(39)
         mat(1350) = -rxt(246)*y(39)
         mat(933) = -rxt(247)*y(39)

         mat(1490) = rxt(236)*y(37)
         mat(1101) = rxt(235)*y(37)
         mat(839) = rxt(236)*y(19) + rxt(235)*y(24)

         mat(399) = -(rxt(248)*y(2) + (rxt(441) + rxt(452)) * y(33))
         mat(929) = -rxt(248)*y(40)
         mat(823) = -(rxt(441) + rxt(452)) * y(40)

         mat(1099) = rxt(239)*y(38)
         mat(963) = rxt(239)*y(24)

         mat(282) = -(rxt(249)*y(2))
         mat(924) = -rxt(249)*y(41)

         mat(1266) = rxt(241)*y(38)
         mat(962) = rxt(241)*y(10)

         mat(346) = -((rxt(455) + rxt(456)) * y(2) + rxt(463)*y(4) + rxt(467)*y(126))
         mat(927) = -(rxt(455) + rxt(456)) * y(121)
         mat(894) = -rxt(463)*y(121)
         mat(424) = -rxt(467)*y(121)

         mat(407) = -(rxt(458)*y(8) + rxt(459)*y(9) + rxt(466)*y(126))
         mat(475) = -rxt(458)*y(122)
         mat(1220) = -rxt(459)*y(122)
         mat(425) = -rxt(466)*y(122)

         mat(896) = rxt(463)*y(121) + rxt(460)*y(123) + rxt(453)*y(124)
         mat(347) = rxt(463)*y(4)
         mat(205) = rxt(460)*y(4)
         mat(299) = rxt(453)*y(4)

         mat(203) = -((rxt(460) + rxt(461)) * y(4) + rxt(462)*y(2))
         mat(891) = -(rxt(460) + rxt(461)) * y(123)
         mat(922) = -rxt(462)*y(123)

         mat(298) = -(rxt(453)*y(4))
         mat(893) = -rxt(453)*y(124)

         mat(925) = rxt(456)*y(121) + rxt(462)*y(123)
         mat(345) = rxt(456)*y(2)
         mat(204) = rxt(462)*y(2)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(416) = -(rxt(465)*y(126))
         mat(426) = -rxt(465)*y(125)

         mat(931) = rxt(455)*y(121)
         mat(897) = rxt(461)*y(123)
         mat(476) = rxt(458)*y(122)
         mat(1221) = rxt(459)*y(122)
         mat(348) = rxt(455)*y(2)
         mat(408) = rxt(458)*y(8) + rxt(459)*y(9)
         mat(206) = rxt(461)*y(4)

         mat(224) = -(rxt(182)*y(4) + rxt(183)*y(2))
         mat(892) = -rxt(182)*y(127)
         mat(923) = -rxt(183)*y(127)

         mat(923) = mat(923) + rxt(455)*y(121)
         mat(344) = rxt(455)*y(2) + .900_r8*rxt(467)*y(126)
         mat(415) = .800_r8*rxt(465)*y(126)
         mat(423) = .900_r8*rxt(467)*y(121) + .800_r8*rxt(465)*y(125)

         mat(427) = -(rxt(465)*y(125) + rxt(466)*y(122) + rxt(467)*y(121))
         mat(417) = -rxt(465)*y(126)
         mat(409) = -rxt(466)*y(126)
         mat(349) = -rxt(467)*y(126)

         mat(589) = -(rxt(313)*y(23) + rxt(314)*y(1) + rxt(315)*y(11))
         mat(1362) = -rxt(313)*y(59)
         mat(1174) = -rxt(314)*y(59)
         mat(1408) = -rxt(315)*y(59)

         mat(1174) = mat(1174) + .070_r8*rxt(360)*y(83)
         mat(498) = .070_r8*rxt(360)*y(1)

         mat(496) = -(rxt(359)*y(23) + rxt(360)*y(1) + rxt(361)*y(11))
         mat(1354) = -rxt(359)*y(83)
         mat(1169) = -rxt(360)*y(83)
         mat(1402) = -rxt(361)*y(83)

         mat(444) = -(rxt(321)*y(9) + rxt(322)*y(24))
         mat(1223) = -rxt(321)*y(64)
         mat(1100) = -rxt(322)*y(64)

         mat(1349) = rxt(313)*y(59) + .500_r8*rxt(323)*y(65)
         mat(588) = rxt(313)*y(23)
         mat(263) = .500_r8*rxt(323)*y(23)

         mat(609) = -(rxt(300)*y(23) + rxt(301)*y(11))
         mat(1364) = -rxt(300)*y(50)
         mat(1410) = -rxt(301)*y(50)

         mat(1176) = .500_r8*rxt(314)*y(59) + .040_r8*rxt(336)*y(77)
         mat(1232) = rxt(321)*y(64) + rxt(334)*y(73) + .400_r8*rxt(375)*y(84) &
                      + rxt(338)*y(74) + rxt(295)*y(46) + .270_r8*rxt(316)*y(61)
         mat(1364) = mat(1364) + .500_r8*rxt(299)*y(47) + rxt(310)*y(51)
         mat(863) = .800_r8*rxt(297)*y(46)
         mat(591) = .500_r8*rxt(314)*y(1)
         mat(445) = rxt(321)*y(9)
         mat(112) = rxt(334)*y(9)
         mat(363) = .400_r8*rxt(375)*y(9)
         mat(338) = rxt(338)*y(9)
         mat(738) = .040_r8*rxt(336)*y(1)
         mat(465) = rxt(295)*y(9) + .800_r8*rxt(297)*y(16) + 3.200_r8*rxt(298)*y(46)
         mat(129) = .500_r8*rxt(299)*y(23)
         mat(520) = .270_r8*rxt(316)*y(9)
         mat(78) = rxt(310)*y(23)

         mat(321) = -(rxt(294)*y(23))
         mat(1340) = -rxt(294)*y(49)

         mat(1166) = .250_r8*rxt(314)*y(59) + .200_r8*rxt(360)*y(83)
         mat(856) = .100_r8*rxt(305)*y(48)
         mat(1092) = .250_r8*rxt(304)*y(48) + .250_r8*rxt(352)*y(76)
         mat(587) = .250_r8*rxt(314)*y(1)
         mat(495) = .200_r8*rxt(360)*y(1)
         mat(779) = .100_r8*rxt(305)*y(16) + .250_r8*rxt(304)*y(24)
         mat(759) = .250_r8*rxt(352)*y(24)

         mat(262) = -(rxt(323)*y(23))
         mat(1334) = -rxt(323)*y(65)

         mat(1089) = rxt(322)*y(64)
         mat(443) = rxt(322)*y(24)

         mat(791) = -(rxt(302)*y(9) + rxt(303)*y(10) + rxt(304)*y(24) + rxt(305)*y(16) &
                      + 4._r8*rxt(306)*y(48) + rxt(348)*y(79) + rxt(367)*y(88) + rxt(382) &
                      *y(91))
         mat(1242) = -rxt(302)*y(48)
         mat(1277) = -rxt(303)*y(48)
         mat(1121) = -rxt(304)*y(48)
         mat(873) = -rxt(305)*y(48)
         mat(725) = -rxt(348)*y(48)
         mat(703) = -rxt(367)*y(48)
         mat(680) = -rxt(382)*y(48)

         mat(1242) = mat(1242) + rxt(338)*y(74) + .530_r8*rxt(343)*y(79) + rxt(350) &
                      *y(76) + rxt(325)*y(67)
         mat(1375) = rxt(300)*y(50) + .500_r8*rxt(307)*y(54) + rxt(330)*y(68)
         mat(1420) = rxt(301)*y(50) + .530_r8*rxt(345)*y(79) + rxt(351)*y(76) &
                      + rxt(331)*y(68)
         mat(873) = mat(873) + .260_r8*rxt(347)*y(79) + rxt(353)*y(76) &
                      + .300_r8*rxt(327)*y(67)
         mat(610) = rxt(300)*y(23) + rxt(301)*y(11)
         mat(791) = mat(791) + .530_r8*rxt(348)*y(79)
         mat(230) = .500_r8*rxt(307)*y(23)
         mat(339) = rxt(338)*y(9)
         mat(725) = mat(725) + .530_r8*rxt(343)*y(9) + .530_r8*rxt(345)*y(11) &
                      + .260_r8*rxt(347)*y(16) + .530_r8*rxt(348)*y(48)
         mat(763) = rxt(350)*y(9) + rxt(351)*y(11) + rxt(353)*y(16) &
                      + 4.000_r8*rxt(355)*y(76)
         mat(629) = rxt(325)*y(9) + .300_r8*rxt(327)*y(16)
         mat(665) = rxt(330)*y(23) + rxt(331)*y(11)

         mat(229) = -(rxt(307)*y(23))
         mat(1329) = -rxt(307)*y(54)

         mat(1085) = .750_r8*rxt(304)*y(48) + .750_r8*rxt(352)*y(76)
         mat(778) = .750_r8*rxt(304)*y(24)
         mat(757) = .750_r8*rxt(352)*y(24)

         mat(196) = -(rxt(312)*y(23))
         mat(1326) = -rxt(312)*y(58)

         mat(1263) = rxt(303)*y(48)
         mat(777) = rxt(303)*y(10)

         mat(152) = -(rxt(332)*y(23))
         mat(1320) = -rxt(332)*y(82)

         mat(1208) = .100_r8*rxt(375)*y(84)
         mat(1399) = rxt(315)*y(59)
         mat(586) = rxt(315)*y(11)
         mat(356) = .100_r8*rxt(375)*y(9)

         mat(86) = -(rxt(285)*y(28) + rxt(287)*y(23))
         mat(985) = -rxt(285)*y(45)
         mat(1310) = -rxt(287)*y(45)

         mat(235) = -(rxt(284)*y(28) + rxt(288)*y(23) + rxt(293)*y(1))
         mat(987) = -rxt(284)*y(44)
         mat(1330) = -rxt(288)*y(44)
         mat(1163) = -rxt(293)*y(44)

         mat(25) = -(rxt(371)*y(23))
         mat(1299) = -rxt(371)*y(71)

         mat(290) = -(rxt(358)*y(23))
         mat(1337) = -rxt(358)*y(81)

         mat(1267) = rxt(356)*y(76)
         mat(758) = rxt(356)*y(10)

         mat(28) = -(rxt(333)*y(23))
         mat(1300) = -rxt(333)*y(70)

         mat(110) = -(rxt(334)*y(9))
         mat(1206) = -rxt(334)*y(73)

         mat(1313) = rxt(333)*y(70)
         mat(29) = rxt(333)*y(23)

         mat(360) = -(rxt(375)*y(9) + rxt(376)*y(24))
         mat(1216) = -rxt(375)*y(84)
         mat(1095) = -rxt(376)*y(84)

         mat(1343) = rxt(371)*y(71) + rxt(377)*y(85)
         mat(26) = rxt(371)*y(23)
         mat(328) = rxt(377)*y(23)

         mat(326) = -(rxt(377)*y(23))
         mat(1341) = -rxt(377)*y(85)

         mat(1093) = rxt(376)*y(84)
         mat(358) = rxt(376)*y(24)

         mat(186) = -(rxt(337)*y(23))
         mat(1325) = -rxt(337)*y(72)

         mat(1210) = .800_r8*rxt(375)*y(84)
         mat(357) = .800_r8*rxt(375)*y(9)

         mat(337) = -(rxt(338)*y(9) + rxt(339)*y(24))
         mat(1215) = -rxt(338)*y(74)
         mat(1094) = -rxt(339)*y(74)

         mat(1342) = rxt(337)*y(72) + rxt(340)*y(75)
         mat(187) = rxt(337)*y(23)
         mat(118) = rxt(340)*y(23)

         mat(117) = -(rxt(340)*y(23))
         mat(1314) = -rxt(340)*y(75)

         mat(1073) = rxt(339)*y(74)
         mat(336) = rxt(339)*y(24)

         mat(35) = -(rxt(385)*y(23))
         mat(1302) = -rxt(385)*y(94)

         mat(40) = -(rxt(389)*y(23))
         mat(1303) = -rxt(389)*y(95)

         mat(1303) = mat(1303) + .250_r8*rxt(385)*y(94)
         mat(36) = .250_r8*rxt(385)*y(23)

         mat(248) = -(rxt(386)*y(9) + rxt(387)*y(24))
         mat(1213) = -rxt(386)*y(96)
         mat(1087) = -rxt(387)*y(96)

         mat(1332) = .700_r8*rxt(385)*y(94) + rxt(388)*y(97)
         mat(37) = .700_r8*rxt(385)*y(23)
         mat(163) = rxt(388)*y(23)

         mat(162) = -(rxt(388)*y(23))
         mat(1322) = -rxt(388)*y(97)

         mat(1078) = rxt(387)*y(96)
         mat(247) = rxt(387)*y(24)

         mat(63) = -(rxt(390)*y(10))
         mat(1261) = -rxt(390)*y(98)

         mat(1306) = rxt(389)*y(95)
         mat(41) = rxt(389)*y(23)

         mat(542) = -(rxt(394)*y(9) + rxt(395)*y(24))
         mat(1229) = -rxt(394)*y(100)
         mat(1107) = -rxt(395)*y(100)

         mat(1358) = rxt(396)*y(101) + rxt(391)*y(99)
         mat(1405) = rxt(393)*y(99)
         mat(212) = rxt(396)*y(23)
         mat(306) = rxt(391)*y(23) + rxt(393)*y(11)

         mat(210) = -(rxt(396)*y(23))
         mat(1327) = -rxt(396)*y(101)

         mat(1083) = rxt(395)*y(100)
         mat(540) = rxt(395)*y(24)


         mat(1214) = .900_r8*rxt(386)*y(96)
         mat(1265) = .700_r8*rxt(390)*y(98)
         mat(249) = .900_r8*rxt(386)*y(9)
         mat(64) = .700_r8*rxt(390)*y(10)

         mat(377) = -(rxt(309)*y(23))
         mat(1345) = -rxt(309)*y(53)

         mat(1218) = .450_r8*rxt(386)*y(96) + .250_r8*rxt(378)*y(91)
         mat(1345) = mat(1345) + .200_r8*rxt(308)*y(52) + .650_r8*rxt(286)*y(129)
         mat(1401) = .250_r8*rxt(379)*y(91)
         mat(858) = .100_r8*rxt(381)*y(91)
         mat(780) = .250_r8*rxt(382)*y(91)
         mat(250) = .450_r8*rxt(386)*y(9)
         mat(511) = .200_r8*rxt(308)*y(23)
         mat(674) = .250_r8*rxt(378)*y(9) + .250_r8*rxt(379)*y(11) + .100_r8*rxt(381) &
                      *y(16) + .250_r8*rxt(382)*y(48)
         mat(94) = .650_r8*rxt(286)*y(23)

         mat(699) = -(rxt(362)*y(9) + rxt(363)*y(11) + rxt(364)*y(24) + rxt(366)*y(16) &
                      + rxt(367)*y(48))
         mat(1238) = -rxt(362)*y(88)
         mat(1416) = -rxt(363)*y(88)
         mat(1117) = -rxt(364)*y(88)
         mat(869) = -rxt(366)*y(88)
         mat(787) = -rxt(367)*y(88)

         mat(1371) = rxt(359)*y(83) + .200_r8*rxt(365)*y(93)
         mat(501) = rxt(359)*y(23)
         mat(277) = .200_r8*rxt(365)*y(23)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(742) = -(rxt(335)*y(23) + rxt(336)*y(1))
         mat(1373) = -rxt(335)*y(77)
         mat(1184) = -rxt(336)*y(77)

         mat(1184) = mat(1184) + .200_r8*rxt(360)*y(83) + rxt(392)*y(99)
         mat(1240) = rxt(394)*y(100) + .320_r8*rxt(362)*y(88) + .039_r8*rxt(368)*y(89)
         mat(1418) = .350_r8*rxt(363)*y(88) + .039_r8*rxt(369)*y(89)
         mat(871) = .260_r8*rxt(366)*y(88)
         mat(1119) = .039_r8*rxt(370)*y(89)
         mat(502) = .200_r8*rxt(360)*y(1)
         mat(789) = .350_r8*rxt(367)*y(88)
         mat(545) = rxt(394)*y(9)
         mat(701) = .320_r8*rxt(362)*y(9) + .350_r8*rxt(363)*y(11) + .260_r8*rxt(366) &
                      *y(16) + .350_r8*rxt(367)*y(48)
         mat(308) = rxt(392)*y(1)
         mat(578) = .039_r8*rxt(368)*y(9) + .039_r8*rxt(369)*y(11) + .039_r8*rxt(370) &
                      *y(24)

         mat(639) = -(rxt(341)*y(23) + rxt(342)*y(1))
         mat(1367) = -rxt(341)*y(78)
         mat(1179) = -rxt(342)*y(78)

         mat(1179) = mat(1179) + .400_r8*rxt(360)*y(83) + rxt(392)*y(99)
         mat(1235) = rxt(394)*y(100) + .230_r8*rxt(362)*y(88) + .167_r8*rxt(368)*y(89)
         mat(1413) = .250_r8*rxt(363)*y(88) + .167_r8*rxt(369)*y(89)
         mat(866) = .190_r8*rxt(366)*y(88)
         mat(1113) = .167_r8*rxt(370)*y(89)
         mat(500) = .400_r8*rxt(360)*y(1)
         mat(784) = .250_r8*rxt(367)*y(88)
         mat(544) = rxt(394)*y(9)
         mat(696) = .230_r8*rxt(362)*y(9) + .250_r8*rxt(363)*y(11) + .190_r8*rxt(366) &
                      *y(16) + .250_r8*rxt(367)*y(48)
         mat(307) = rxt(392)*y(1)
         mat(576) = .167_r8*rxt(368)*y(9) + .167_r8*rxt(369)*y(11) + .167_r8*rxt(370) &
                      *y(24)

         mat(723) = -((rxt(343) + rxt(344)) * y(9) + rxt(345)*y(11) + rxt(346)*y(24) &
                      + rxt(347)*y(16) + rxt(348)*y(48))
         mat(1239) = -(rxt(343) + rxt(344)) * y(79)
         mat(1417) = -rxt(345)*y(79)
         mat(1118) = -rxt(346)*y(79)
         mat(870) = -rxt(347)*y(79)
         mat(788) = -rxt(348)*y(79)

         mat(1372) = rxt(335)*y(77) + .500_r8*rxt(341)*y(78) + .200_r8*rxt(349)*y(80)
         mat(741) = rxt(335)*y(23)
         mat(641) = .500_r8*rxt(341)*y(23)
         mat(123) = .200_r8*rxt(349)*y(23)

         mat(122) = -(rxt(349)*y(23))
         mat(1315) = -rxt(349)*y(80)

         mat(1074) = rxt(346)*y(79)
         mat(715) = rxt(346)*y(24)

         mat(762) = -(rxt(350)*y(9) + rxt(351)*y(11) + rxt(352)*y(24) + rxt(353)*y(16) &
                      + rxt(354)*y(48) + 4._r8*rxt(355)*y(76) + rxt(356)*y(10))
         mat(1241) = -rxt(350)*y(76)
         mat(1419) = -rxt(351)*y(76)
         mat(1120) = -rxt(352)*y(76)
         mat(872) = -rxt(353)*y(76)
         mat(790) = -rxt(354)*y(76)
         mat(1276) = -rxt(356)*y(76)

         mat(1185) = .200_r8*rxt(360)*y(83)
         mat(1374) = .500_r8*rxt(341)*y(78) + .500_r8*rxt(349)*y(80)
         mat(503) = .200_r8*rxt(360)*y(1)
         mat(642) = .500_r8*rxt(341)*y(23)
         mat(124) = .500_r8*rxt(349)*y(23)

         mat(464) = -(rxt(295)*y(9) + rxt(296)*y(24) + rxt(297)*y(16) + 4._r8*rxt(298) &
                      *y(46))
         mat(1224) = -rxt(295)*y(46)
         mat(1102) = -rxt(296)*y(46)
         mat(859) = -rxt(297)*y(46)

         mat(1351) = rxt(287)*y(45) + .500_r8*rxt(299)*y(47)
         mat(992) = rxt(285)*y(45)
         mat(87) = rxt(287)*y(23) + rxt(285)*y(28)
         mat(128) = .500_r8*rxt(299)*y(23)

         mat(127) = -(rxt(299)*y(23))
         mat(1316) = -rxt(299)*y(47)

         mat(1075) = rxt(296)*y(46)
         mat(462) = rxt(296)*y(24)

         mat(305) = -(rxt(391)*y(23) + rxt(392)*y(1) + rxt(393)*y(11))
         mat(1338) = -rxt(391)*y(99)
         mat(1165) = -rxt(392)*y(99)
         mat(1400) = -rxt(393)*y(99)

         mat(31) = -(rxt(320)*y(23))
         mat(1301) = -rxt(320)*y(60)

         mat(519) = -(rxt(316)*y(9) + rxt(317)*y(24) + rxt(318)*y(16))
         mat(1227) = -rxt(316)*y(61)
         mat(1105) = -rxt(317)*y(61)
         mat(861) = -rxt(318)*y(61)

         mat(1356) = rxt(320)*y(60) + rxt(319)*y(62)
         mat(32) = rxt(320)*y(23)
         mat(170) = rxt(319)*y(23)

         mat(168) = -(rxt(319)*y(23))
         mat(1323) = -rxt(319)*y(62)

         mat(1079) = rxt(317)*y(61)
         mat(517) = rxt(317)*y(24)

         mat(371) = -(rxt(324)*y(23))
         mat(1344) = -rxt(324)*y(63)

         mat(1217) = .500_r8*rxt(334)*y(73) + .250_r8*rxt(375)*y(84) &
                      + .100_r8*rxt(394)*y(100) + .820_r8*rxt(316)*y(61)
         mat(857) = .820_r8*rxt(318)*y(61)
         mat(111) = .500_r8*rxt(334)*y(9)
         mat(361) = .250_r8*rxt(375)*y(9)
         mat(541) = .100_r8*rxt(394)*y(9)
         mat(518) = .820_r8*rxt(316)*y(9) + .820_r8*rxt(318)*y(16)

         mat(174) = -(rxt(328)*y(23))
         mat(1324) = -rxt(328)*y(69)

         mat(1080) = rxt(326)*y(67)
         mat(624) = rxt(326)*y(24)

         mat(270) = -(rxt(277)*y(23))
         mat(1335) = -rxt(277)*y(18)

         mat(855) = 2.000_r8*rxt(276)*y(16) + .250_r8*rxt(366)*y(88) &
                      + .250_r8*rxt(347)*y(79) + .300_r8*rxt(297)*y(46) &
                      + .500_r8*rxt(327)*y(67) + .300_r8*rxt(381)*y(91)
         mat(692) = .250_r8*rxt(366)*y(16)
         mat(716) = .250_r8*rxt(347)*y(16)
         mat(463) = .300_r8*rxt(297)*y(16)
         mat(625) = .500_r8*rxt(327)*y(16)
         mat(673) = .300_r8*rxt(381)*y(16)

         mat(77) = -(rxt(310)*y(23))
         mat(1308) = -rxt(310)*y(51)

         mat(852) = .200_r8*rxt(297)*y(46)
         mat(461) = .200_r8*rxt(297)*y(16) + .800_r8*rxt(298)*y(46)

         mat(512) = -(rxt(308)*y(23))
         mat(1355) = -rxt(308)*y(52)

         mat(900) = rxt(291)*y(56)
         mat(1226) = .530_r8*rxt(343)*y(79) + .250_r8*rxt(378)*y(91)
         mat(1403) = .530_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(860) = .260_r8*rxt(347)*y(79) + .100_r8*rxt(381)*y(91)
         mat(781) = .530_r8*rxt(348)*y(79) + .250_r8*rxt(382)*y(91)
         mat(717) = .530_r8*rxt(343)*y(9) + .530_r8*rxt(345)*y(11) + .260_r8*rxt(347) &
                      *y(16) + .530_r8*rxt(348)*y(48)
         mat(192) = rxt(291)*y(4)
         mat(675) = .250_r8*rxt(378)*y(9) + .250_r8*rxt(379)*y(11) + .100_r8*rxt(381) &
                      *y(16) + .250_r8*rxt(382)*y(48)

         mat(618) = -(rxt(329)*y(23))
         mat(1365) = -rxt(329)*y(66)

         mat(1233) = .220_r8*rxt(343)*y(79) + .250_r8*rxt(378)*y(91)
         mat(1365) = mat(1365) + .500_r8*rxt(323)*y(65) + .500_r8*rxt(358)*y(81)
         mat(1411) = .220_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(864) = .230_r8*rxt(347)*y(79) + .200_r8*rxt(327)*y(67) + .100_r8*rxt(381) &
                      *y(91)
         mat(265) = .500_r8*rxt(323)*y(23)
         mat(783) = .220_r8*rxt(348)*y(79) + .250_r8*rxt(382)*y(91)
         mat(291) = .500_r8*rxt(358)*y(23)
         mat(720) = .220_r8*rxt(343)*y(9) + .220_r8*rxt(345)*y(11) + .230_r8*rxt(347) &
                      *y(16) + .220_r8*rxt(348)*y(48)
         mat(626) = .200_r8*rxt(327)*y(16)
         mat(677) = .250_r8*rxt(378)*y(9) + .250_r8*rxt(379)*y(11) + .100_r8*rxt(381) &
                      *y(16) + .250_r8*rxt(382)*y(48)

         mat(390) = -(rxt(289)*y(9) + rxt(290)*y(24))
         mat(1219) = -rxt(289)*y(55)
         mat(1098) = -rxt(290)*y(55)

         mat(1347) = rxt(288)*y(44)
         mat(237) = rxt(288)*y(23)

         mat(191) = -(rxt(291)*y(4))
         mat(890) = -rxt(291)*y(56)

         mat(1211) = .750_r8*rxt(289)*y(55)
         mat(389) = .750_r8*rxt(289)*y(9)


         mat(1072) = rxt(290)*y(55)
         mat(388) = rxt(290)*y(24)

         mat(141) = -(rxt(374)*y(23))
         mat(1318) = -rxt(374)*y(87)

         mat(1207) = .370_r8*rxt(362)*y(88)
         mat(1318) = mat(1318) + rxt(372)*y(90)
         mat(1398) = .400_r8*rxt(363)*y(88) + rxt(373)*y(90)
         mat(853) = .300_r8*rxt(366)*y(88)
         mat(776) = .400_r8*rxt(367)*y(88)
         mat(691) = .370_r8*rxt(362)*y(9) + .400_r8*rxt(363)*y(11) + .300_r8*rxt(366) &
                      *y(16) + .400_r8*rxt(367)*y(48)
         mat(531) = rxt(372)*y(23) + rxt(373)*y(11)

         mat(627) = -(rxt(325)*y(9) + rxt(326)*y(24) + rxt(327)*y(16))
         mat(1234) = -rxt(325)*y(67)
         mat(1112) = -rxt(326)*y(67)
         mat(865) = -rxt(327)*y(67)

         mat(1366) = rxt(324)*y(63) + rxt(328)*y(69)
         mat(372) = rxt(324)*y(23)
         mat(175) = rxt(328)*y(23)

         mat(664) = -(rxt(330)*y(23) + rxt(331)*y(11))
         mat(1369) = -rxt(330)*y(68)
         mat(1414) = -rxt(331)*y(68)

         mat(1180) = .950_r8*rxt(336)*y(77) + .800_r8*rxt(342)*y(78)
         mat(1236) = .450_r8*rxt(386)*y(96) + .250_r8*rxt(343)*y(79) &
                      + .250_r8*rxt(378)*y(91)
         mat(1369) = mat(1369) + rxt(332)*y(82) + rxt(329)*y(66)
         mat(1414) = mat(1414) + .250_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(867) = .240_r8*rxt(347)*y(79) + .500_r8*rxt(327)*y(67) + .100_r8*rxt(381) &
                      *y(91)
         mat(785) = .250_r8*rxt(348)*y(79) + .250_r8*rxt(382)*y(91)
         mat(153) = rxt(332)*y(23)
         mat(251) = .450_r8*rxt(386)*y(9)
         mat(740) = .950_r8*rxt(336)*y(1)
         mat(640) = .800_r8*rxt(342)*y(1)
         mat(721) = .250_r8*rxt(343)*y(9) + .250_r8*rxt(345)*y(11) + .240_r8*rxt(347) &
                      *y(16) + .250_r8*rxt(348)*y(48)
         mat(619) = rxt(329)*y(23)
         mat(628) = .500_r8*rxt(327)*y(16)
         mat(678) = .250_r8*rxt(378)*y(9) + .250_r8*rxt(379)*y(11) + .100_r8*rxt(381) &
                      *y(16) + .250_r8*rxt(382)*y(48)

         mat(574) = -(rxt(368)*y(9) + rxt(369)*y(11) + rxt(370)*y(24))
         mat(1230) = -rxt(368)*y(89)
         mat(1407) = -rxt(369)*y(89)
         mat(1108) = -rxt(370)*y(89)

         mat(1407) = mat(1407) + rxt(361)*y(83)
         mat(497) = rxt(361)*y(11)

         mat(532) = -(rxt(372)*y(23) + rxt(373)*y(11))
         mat(1357) = -rxt(372)*y(90)
         mat(1404) = -rxt(373)*y(90)

         mat(1228) = .080_r8*rxt(362)*y(88) + .800_r8*rxt(344)*y(79) &
                      + .794_r8*rxt(368)*y(89)
         mat(1404) = mat(1404) + .794_r8*rxt(369)*y(89)
         mat(1106) = .794_r8*rxt(370)*y(89)
         mat(694) = .080_r8*rxt(362)*y(9)
         mat(718) = .800_r8*rxt(344)*y(9)
         mat(573) = .794_r8*rxt(368)*y(9) + .794_r8*rxt(369)*y(11) + .794_r8*rxt(370) &
                      *y(24)


      end subroutine nlnmat06

      subroutine nlnmat07( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(679) = -(rxt(378)*y(9) + rxt(379)*y(11) + rxt(380)*y(24) + rxt(381)*y(16) &
                      + rxt(382)*y(48))
         mat(1237) = -rxt(378)*y(91)
         mat(1415) = -rxt(379)*y(91)
         mat(1116) = -rxt(380)*y(91)
         mat(868) = -rxt(381)*y(91)
         mat(786) = -rxt(382)*y(91)

         mat(1370) = rxt(374)*y(87) + rxt(383)*y(92) + .800_r8*rxt(365)*y(93)
         mat(142) = rxt(374)*y(23)
         mat(133) = rxt(383)*y(23)
         mat(276) = .800_r8*rxt(365)*y(23)

         mat(132) = -((rxt(383) + rxt(384)) * y(23))
         mat(1317) = -(rxt(383) + rxt(384)) * y(92)

         mat(1076) = rxt(370)*y(89) + rxt(380)*y(91)
         mat(572) = rxt(370)*y(24)
         mat(672) = rxt(380)*y(24)

         mat(274) = -(rxt(365)*y(23))
         mat(1336) = -rxt(365)*y(93)

         mat(1090) = rxt(364)*y(88)
         mat(693) = rxt(364)*y(24)

         mat(92) = -(rxt(283)*y(28) + rxt(286)*y(23))
         mat(986) = -rxt(283)*y(129)
         mat(1311) = -rxt(286)*y(129)

         mat(243) = -(rxt(279)*y(23))
         mat(1331) = -rxt(279)*y(130)

         mat(1164) = .500_r8*rxt(293)*y(44)
         mat(1212) = rxt(281)*y(131)
         mat(1331) = mat(1331) + .350_r8*rxt(286)*y(129)
         mat(1086) = rxt(282)*y(131)
         mat(236) = .500_r8*rxt(293)*y(1)
         mat(93) = .350_r8*rxt(286)*y(23)
         mat(181) = rxt(281)*y(9) + rxt(282)*y(24)

         mat(180) = -(rxt(281)*y(9) + rxt(282)*y(24))
         mat(1209) = -rxt(281)*y(131)
         mat(1081) = -rxt(282)*y(131)

         mat(1488) = rxt(272)*y(24)
         mat(1081) = mat(1081) + rxt(272)*y(19)

         mat(46) = -(rxt(154)*y(3))
         mat(1046) = -rxt(154)*y(132)

         mat(67) = -(rxt(155)*y(3))
         mat(1049) = -rxt(155)*y(133)


         mat(650) = rxt(251)*y(135)
         mat(1440) = rxt(253)*y(135)
         mat(1463) = rxt(250)*y(135)
         mat(434) = rxt(251)*y(21) + rxt(253)*y(12) + rxt(250)*y(128)

         mat(435) = -(rxt(250)*y(128) + rxt(251)*y(21) + rxt(253)*y(12))
         mat(1465) = -rxt(250)*y(135)
         mat(651) = -rxt(251)*y(135)
         mat(1441) = -rxt(253)*y(135)

         mat(1050) = 2.000_r8*rxt(154)*y(132) + rxt(155)*y(133)
         mat(47) = 2.000_r8*rxt(154)*y(3)
         mat(68) = rxt(155)*y(3)

         mat(554) = -(rxt(431)*y(23))
         mat(1359) = -rxt(431)*y(141)

         mat(1172) = rxt(426)*y(148)
         mat(901) = rxt(425)*y(148)
         mat(1271) = rxt(427)*y(148)
         mat(1359) = mat(1359) + (rxt(433)+.500_r8*rxt(434))*y(142) + rxt(420)*y(146) &
                      + rxt(424)*y(148)
         mat(1406) = rxt(435)*y(142)
         mat(1024) = rxt(428)*y(148)
         mat(137) = rxt(430)*y(148)
         mat(964) = rxt(429)*y(148)
         mat(99) = (rxt(433)+.500_r8*rxt(434))*y(23) + rxt(435)*y(11)
         mat(146) = rxt(420)*y(23)
         mat(806) = rxt(426)*y(1) + rxt(425)*y(4) + rxt(427)*y(10) + rxt(424)*y(23) &
                      + rxt(428)*y(30) + rxt(430)*y(31) + rxt(429)*y(38)

         mat(98) = -((rxt(433) + rxt(434)) * y(23) + rxt(435)*y(11))
         mat(1312) = -(rxt(433) + rxt(434)) * y(142)
         mat(1396) = -rxt(435)*y(142)





         mat(144) = -(rxt(419)*y(2) + rxt(420)*y(23))
         mat(921) = -rxt(419)*y(146)
         mat(1319) = -rxt(420)*y(146)

         mat(381) = -(rxt(421)*y(23) + rxt(422)*y(4) + rxt(423)*y(1))
         mat(1346) = -rxt(421)*y(147)
         mat(895) = -rxt(422)*y(147)
         mat(1167) = -rxt(423)*y(147)

         mat(807) = -(rxt(424)*y(23) + rxt(425)*y(4) + rxt(426)*y(1) + rxt(427)*y(10) &
                      + rxt(428)*y(30) + rxt(429)*y(38) + rxt(430)*y(31))
         mat(1376) = -rxt(424)*y(148)
         mat(903) = -rxt(425)*y(148)
         mat(1187) = -rxt(426)*y(148)
         mat(1278) = -rxt(427)*y(148)
         mat(1026) = -rxt(428)*y(148)
         mat(965) = -rxt(429)*y(148)
         mat(138) = -rxt(430)*y(148)

         mat(1187) = mat(1187) + rxt(423)*y(147)
         mat(940) = rxt(419)*y(146)
         mat(903) = mat(903) + rxt(422)*y(147)
         mat(1376) = mat(1376) + rxt(421)*y(147)
         mat(148) = rxt(419)*y(2)
         mat(382) = rxt(423)*y(1) + rxt(422)*y(4) + rxt(421)*y(23)

         mat(82) = -(rxt(432)*y(128))
         mat(1464) = -rxt(432)*y(149)

         mat(1309) = rxt(431)*y(141)
         mat(553) = rxt(431)*y(23)


         mat(1462) = rxt(432)*y(149)
         mat(81) = rxt(432)*y(128)
      end subroutine nlnmat07
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = mat( 19) + lmat( 19)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = mat( 25) + lmat( 25)
         mat( 28) = mat( 28) + lmat( 28)
         mat( 31) = mat( 31) + lmat( 31)
         mat( 35) = mat( 35) + lmat( 35)
         mat( 40) = mat( 40) + lmat( 40)
         mat( 43) = lmat( 43)
         mat( 44) = lmat( 44)
         mat( 45) = lmat( 45)
         mat( 46) = mat( 46) + lmat( 46)
         mat( 47) = mat( 47) + lmat( 47)
         mat( 49) = lmat( 49)
         mat( 50) = lmat( 50)
         mat( 51) = lmat( 51)
         mat( 52) = mat( 52) + lmat( 52)
         mat( 53) = mat( 53) + lmat( 53)
         mat( 54) = mat( 54) + lmat( 54)
         mat( 55) = mat( 55) + lmat( 55)
         mat( 56) = lmat( 56)
         mat( 57) = lmat( 57)
         mat( 58) = lmat( 58)
         mat( 59) = mat( 59) + lmat( 59)
         mat( 63) = mat( 63) + lmat( 63)
         mat( 67) = mat( 67) + lmat( 67)
         mat( 68) = mat( 68) + lmat( 68)
         mat( 69) = mat( 69) + lmat( 69)
         mat( 71) = lmat( 71)
         mat( 72) = lmat( 72)
         mat( 73) = lmat( 73)
         mat( 74) = lmat( 74)
         mat( 75) = lmat( 75)
         mat( 76) = lmat( 76)
         mat( 77) = mat( 77) + lmat( 77)
         mat( 82) = mat( 82) + lmat( 82)
         mat( 83) = lmat( 83)
         mat( 84) = lmat( 84)
         mat( 86) = mat( 86) + lmat( 86)
         mat( 92) = mat( 92) + lmat( 92)
         mat( 98) = mat( 98) + lmat( 98)
         mat( 104) = lmat( 104)
         mat( 105) = lmat( 105)
         mat( 106) = lmat( 106)
         mat( 107) = lmat( 107)
         mat( 108) = lmat( 108)
         mat( 109) = lmat( 109)
         mat( 110) = mat( 110) + lmat( 110)
         mat( 117) = mat( 117) + lmat( 117)
         mat( 119) = lmat( 119)
         mat( 120) = lmat( 120)
         mat( 121) = mat( 121) + lmat( 121)
         mat( 122) = mat( 122) + lmat( 122)
         mat( 127) = mat( 127) + lmat( 127)
         mat( 129) = mat( 129) + lmat( 129)
         mat( 130) = lmat( 130)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 132) = mat( 132) + lmat( 132)
         mat( 134) = mat( 134) + lmat( 134)
         mat( 136) = mat( 136) + lmat( 136)
         mat( 139) = lmat( 139)
         mat( 140) = mat( 140) + lmat( 140)
         mat( 141) = mat( 141) + lmat( 141)
         mat( 144) = mat( 144) + lmat( 144)
         mat( 145) = lmat( 145)
         mat( 147) = mat( 147) + lmat( 147)
         mat( 152) = mat( 152) + lmat( 152)
         mat( 156) = mat( 156) + lmat( 156)
         mat( 158) = lmat( 158)
         mat( 159) = mat( 159) + lmat( 159)
         mat( 161) = mat( 161) + lmat( 161)
         mat( 162) = mat( 162) + lmat( 162)
         mat( 164) = lmat( 164)
         mat( 165) = lmat( 165)
         mat( 166) = lmat( 166)
         mat( 167) = mat( 167) + lmat( 167)
         mat( 168) = mat( 168) + lmat( 168)
         mat( 169) = lmat( 169)
         mat( 171) = lmat( 171)
         mat( 172) = mat( 172) + lmat( 172)
         mat( 174) = mat( 174) + lmat( 174)
         mat( 176) = lmat( 176)
         mat( 177) = mat( 177) + lmat( 177)
         mat( 179) = lmat( 179)
         mat( 180) = mat( 180) + lmat( 180)
         mat( 182) = mat( 182) + lmat( 182)
         mat( 185) = lmat( 185)
         mat( 186) = mat( 186) + lmat( 186)
         mat( 188) = lmat( 188)
         mat( 189) = lmat( 189)
         mat( 191) = mat( 191) + lmat( 191)
         mat( 194) = mat( 194) + lmat( 194)
         mat( 195) = lmat( 195)
         mat( 196) = mat( 196) + lmat( 196)
         mat( 197) = lmat( 197)
         mat( 198) = lmat( 198)
         mat( 199) = lmat( 199)
         mat( 201) = mat( 201) + lmat( 201)
         mat( 203) = mat( 203) + lmat( 203)
         mat( 210) = mat( 210) + lmat( 210)
         mat( 211) = lmat( 211)
         mat( 213) = lmat( 213)
         mat( 214) = lmat( 214)
         mat( 215) = lmat( 215)
         mat( 216) = mat( 216) + lmat( 216)
         mat( 217) = mat( 217) + lmat( 217)
         mat( 219) = lmat( 219)
         mat( 220) = mat( 220) + lmat( 220)
         mat( 221) = mat( 221) + lmat( 221)
         mat( 222) = lmat( 222)
         mat( 224) = mat( 224) + lmat( 224)
         mat( 229) = mat( 229) + lmat( 229)
         mat( 231) = lmat( 231)
         mat( 232) = mat( 232) + lmat( 232)
         mat( 235) = mat( 235) + lmat( 235)
         mat( 243) = mat( 243) + lmat( 243)
         mat( 248) = mat( 248) + lmat( 248)
         mat( 256) = lmat( 256)
         mat( 257) = lmat( 257)
         mat( 258) = lmat( 258)
         mat( 259) = lmat( 259)
         mat( 260) = lmat( 260)
         mat( 261) = lmat( 261)
         mat( 262) = mat( 262) + lmat( 262)
         mat( 264) = lmat( 264)
         mat( 266) = lmat( 266)
         mat( 267) = mat( 267) + lmat( 267)
         mat( 269) = lmat( 269)
         mat( 270) = mat( 270) + lmat( 270)
         mat( 274) = mat( 274) + lmat( 274)
         mat( 275) = lmat( 275)
         mat( 278) = lmat( 278)
         mat( 279) = lmat( 279)
         mat( 281) = lmat( 281)
         mat( 282) = mat( 282) + lmat( 282)
         mat( 283) = lmat( 283)
         mat( 284) = lmat( 284)
         mat( 286) = mat( 286) + lmat( 286)
         mat( 287) = lmat( 287)
         mat( 288) = mat( 288) + lmat( 288)
         mat( 289) = lmat( 289)
         mat( 290) = mat( 290) + lmat( 290)
         mat( 292) = lmat( 292)
         mat( 294) = lmat( 294)
         mat( 298) = mat( 298) + lmat( 298)
         mat( 299) = mat( 299) + lmat( 299)
         mat( 300) = lmat( 300)
         mat( 301) = lmat( 301)
         mat( 302) = lmat( 302)
         mat( 305) = mat( 305) + lmat( 305)
         mat( 314) = mat( 314) + lmat( 314)
         mat( 319) = mat( 319) + lmat( 319)
         mat( 321) = mat( 321) + lmat( 321)
         mat( 325) = lmat( 325)
         mat( 326) = mat( 326) + lmat( 326)
         mat( 329) = lmat( 329)
         mat( 331) = lmat( 331)
         mat( 333) = lmat( 333)
         mat( 334) = mat( 334) + lmat( 334)
         mat( 335) = lmat( 335)
         mat( 337) = mat( 337) + lmat( 337)
         mat( 346) = mat( 346) + lmat( 346)
         mat( 360) = mat( 360) + lmat( 360)
         mat( 371) = mat( 371) + lmat( 371)
         mat( 373) = lmat( 373)
         mat( 374) = lmat( 374)
         mat( 377) = mat( 377) + lmat( 377)
         mat( 378) = mat( 378) + lmat( 378)
         mat( 379) = mat( 379) + lmat( 379)
         mat( 381) = mat( 381) + lmat( 381)
         mat( 390) = mat( 390) + lmat( 390)
         mat( 399) = mat( 399) + lmat( 399)
         mat( 401) = lmat( 401)
         mat( 405) = mat( 405) + lmat( 405)
         mat( 407) = mat( 407) + lmat( 407)
         mat( 408) = mat( 408) + lmat( 408)
         mat( 414) = mat( 414) + lmat( 414)
         mat( 416) = mat( 416) + lmat( 416)
         mat( 427) = mat( 427) + lmat( 427)
         mat( 434) = mat( 434) + lmat( 434)
         mat( 435) = mat( 435) + lmat( 435)
         mat( 437) = lmat( 437)
         mat( 444) = mat( 444) + lmat( 444)
         mat( 454) = mat( 454) + lmat( 454)
         mat( 455) = mat( 455) + lmat( 455)
         mat( 458) = lmat( 458)
         mat( 464) = mat( 464) + lmat( 464)
         mat( 473) = lmat( 473)
         mat( 477) = lmat( 477)
         mat( 478) = mat( 478) + lmat( 478)
         mat( 488) = mat( 488) + lmat( 488)
         mat( 491) = mat( 491) + lmat( 491)
         mat( 493) = mat( 493) + lmat( 493)
         mat( 496) = mat( 496) + lmat( 496)
         mat( 512) = mat( 512) + lmat( 512)
         mat( 513) = lmat( 513)
         mat( 514) = mat( 514) + lmat( 514)
         mat( 516) = mat( 516) + lmat( 516)
         mat( 519) = mat( 519) + lmat( 519)
         mat( 532) = mat( 532) + lmat( 532)
         mat( 533) = lmat( 533)
         mat( 535) = mat( 535) + lmat( 535)
         mat( 536) = mat( 536) + lmat( 536)
         mat( 539) = lmat( 539)
         mat( 542) = mat( 542) + lmat( 542)
         mat( 554) = mat( 554) + lmat( 554)
         mat( 555) = lmat( 555)
         mat( 556) = lmat( 556)
         mat( 561) = mat( 561) + lmat( 561)
         mat( 562) = mat( 562) + lmat( 562)
         mat( 565) = mat( 565) + lmat( 565)
         mat( 566) = mat( 566) + lmat( 566)
         mat( 567) = lmat( 567)
         mat( 569) = mat( 569) + lmat( 569)
         mat( 570) = mat( 570) + lmat( 570)
         mat( 574) = mat( 574) + lmat( 574)
         mat( 589) = mat( 589) + lmat( 589)
         mat( 604) = mat( 604) + lmat( 604)
         mat( 608) = lmat( 608)
         mat( 609) = mat( 609) + lmat( 609)
         mat( 611) = lmat( 611)
         mat( 612) = lmat( 612)
         mat( 618) = mat( 618) + lmat( 618)
         mat( 620) = lmat( 620)
         mat( 621) = mat( 621) + lmat( 621)
         mat( 623) = lmat( 623)
         mat( 627) = mat( 627) + lmat( 627)
         mat( 638) = mat( 638) + lmat( 638)
         mat( 639) = mat( 639) + lmat( 639)
         mat( 642) = mat( 642) + lmat( 642)
         mat( 643) = lmat( 643)
         mat( 644) = mat( 644) + lmat( 644)
         mat( 649) = mat( 649) + lmat( 649)
         mat( 652) = mat( 652) + lmat( 652)
         mat( 663) = mat( 663) + lmat( 663)
         mat( 664) = mat( 664) + lmat( 664)
         mat( 665) = mat( 665) + lmat( 665)
         mat( 666) = lmat( 666)
         mat( 679) = mat( 679) + lmat( 679)
         mat( 699) = mat( 699) + lmat( 699)
         mat( 723) = mat( 723) + lmat( 723)
         mat( 736) = lmat( 736)
         mat( 737) = mat( 737) + lmat( 737)
         mat( 742) = mat( 742) + lmat( 742)
         mat( 744) = lmat( 744)
         mat( 745) = lmat( 745)
         mat( 762) = mat( 762) + lmat( 762)
         mat( 791) = mat( 791) + lmat( 791)
         mat( 805) = lmat( 805)
         mat( 807) = mat( 807) + lmat( 807)
         mat( 810) = mat( 810) + lmat( 810)
         mat( 826) = mat( 826) + lmat( 826)
         mat( 830) = mat( 830) + lmat( 830)
         mat( 833) = lmat( 833)
         mat( 841) = mat( 841) + lmat( 841)
         mat( 874) = mat( 874) + lmat( 874)
         mat( 893) = mat( 893) + lmat( 893)
         mat( 896) = mat( 896) + lmat( 896)
         mat( 898) = lmat( 898)
         mat( 905) = mat( 905) + lmat( 905)
         mat( 906) = mat( 906) + lmat( 906)
         mat( 910) = mat( 910) + lmat( 910)
         mat( 925) = mat( 925) + lmat( 925)
         mat( 932) = lmat( 932)
         mat( 945) = mat( 945) + lmat( 945)
         mat( 967) = mat( 967) + lmat( 967)
         mat( 969) = mat( 969) + lmat( 969)
         mat( 970) = mat( 970) + lmat( 970)
         mat( 996) = mat( 996) + lmat( 996)
         mat(1000) = mat(1000) + lmat(1000)
         mat(1001) = lmat(1001)
         mat(1002) = lmat(1002)
         mat(1006) = mat(1006) + lmat(1006)
         mat(1009) = mat(1009) + lmat(1009)
         mat(1031) = mat(1031) + lmat(1031)
         mat(1033) = mat(1033) + lmat(1033)
         mat(1034) = mat(1034) + lmat(1034)
         mat(1046) = mat(1046) + lmat(1046)
         mat(1049) = mat(1049) + lmat(1049)
         mat(1050) = mat(1050) + lmat(1050)
         mat(1052) = mat(1052) + lmat(1052)
         mat(1054) = mat(1054) + lmat(1054)
         mat(1055) = lmat(1055)
         mat(1056) = mat(1056) + lmat(1056)
         mat(1057) = mat(1057) + lmat(1057)
         mat(1059) = mat(1059) + lmat(1059)
         mat(1061) = mat(1061) + lmat(1061)
         mat(1062) = lmat(1062)
         mat(1063) = mat(1063) + lmat(1063)
         mat(1065) = lmat(1065)
         mat(1067) = mat(1067) + lmat(1067)
         mat(1071) = lmat(1071)
         mat(1091) = mat(1091) + lmat(1091)
         mat(1131) = mat(1131) + lmat(1131)
         mat(1152) = mat(1152) + lmat(1152)
         mat(1161) = mat(1161) + lmat(1161)
         mat(1190) = mat(1190) + lmat(1190)
         mat(1191) = mat(1191) + lmat(1191)
         mat(1195) = mat(1195) + lmat(1195)
         mat(1198) = mat(1198) + lmat(1198)
         mat(1221) = mat(1221) + lmat(1221)
         mat(1222) = lmat(1222)
         mat(1225) = mat(1225) + lmat(1225)
         mat(1246) = mat(1246) + lmat(1246)
         mat(1254) = mat(1254) + lmat(1254)
         mat(1283) = mat(1283) + lmat(1283)
         mat(1291) = mat(1291) + lmat(1291)
         mat(1292) = mat(1292) + lmat(1292)
         mat(1293) = mat(1293) + lmat(1293)
         mat(1295) = mat(1295) + lmat(1295)
         mat(1304) = lmat(1304)
         mat(1307) = lmat(1307)
         mat(1378) = mat(1378) + lmat(1378)
         mat(1379) = mat(1379) + lmat(1379)
         mat(1383) = mat(1383) + lmat(1383)
         mat(1386) = mat(1386) + lmat(1386)
         mat(1391) = mat(1391) + lmat(1391)
         mat(1394) = mat(1394) + lmat(1394)
         mat(1424) = mat(1424) + lmat(1424)
         mat(1425) = mat(1425) + lmat(1425)
         mat(1433) = mat(1433) + lmat(1433)
         mat(1434) = mat(1434) + lmat(1434)
         mat(1436) = mat(1436) + lmat(1436)
         mat(1437) = mat(1437) + lmat(1437)
         mat(1456) = lmat(1456)
         mat(1457) = mat(1457) + lmat(1457)
         mat(1459) = mat(1459) + lmat(1459)
         mat(1467) = lmat(1467)
         mat(1473) = lmat(1473)
         mat(1477) = mat(1477) + lmat(1477)
         mat(1479) = lmat(1479)
         mat(1483) = mat(1483) + lmat(1483)
         mat(1486) = mat(1486) + lmat(1486)
         mat(1491) = mat(1491) + lmat(1491)
         mat(1492) = lmat(1492)
         mat(1503) = mat(1503) + lmat(1503)
         mat(1511) = mat(1511) + lmat(1511)
         mat( 255) = 0._r8
         mat( 327) = 0._r8
         mat( 330) = 0._r8
         mat( 332) = 0._r8
         mat( 343) = 0._r8
         mat( 351) = 0._r8
         mat( 354) = 0._r8
         mat( 355) = 0._r8
         mat( 359) = 0._r8
         mat( 362) = 0._r8
         mat( 364) = 0._r8
         mat( 365) = 0._r8
         mat( 369) = 0._r8
         mat( 391) = 0._r8
         mat( 392) = 0._r8
         mat( 396) = 0._r8
         mat( 404) = 0._r8
         mat( 419) = 0._r8
         mat( 421) = 0._r8
         mat( 422) = 0._r8
         mat( 429) = 0._r8
         mat( 430) = 0._r8
         mat( 433) = 0._r8
         mat( 446) = 0._r8
         mat( 451) = 0._r8
         mat( 452) = 0._r8
         mat( 471) = 0._r8
         mat( 474) = 0._r8
         mat( 479) = 0._r8
         mat( 482) = 0._r8
         mat( 504) = 0._r8
         mat( 509) = 0._r8
         mat( 521) = 0._r8
         mat( 522) = 0._r8
         mat( 528) = 0._r8
         mat( 529) = 0._r8
         mat( 534) = 0._r8
         mat( 543) = 0._r8
         mat( 546) = 0._r8
         mat( 547) = 0._r8
         mat( 551) = 0._r8
         mat( 552) = 0._r8
         mat( 559) = 0._r8
         mat( 571) = 0._r8
         mat( 575) = 0._r8
         mat( 577) = 0._r8
         mat( 582) = 0._r8
         mat( 584) = 0._r8
         mat( 592) = 0._r8
         mat( 593) = 0._r8
         mat( 595) = 0._r8
         mat( 598) = 0._r8
         mat( 599) = 0._r8
         mat( 602) = 0._r8
         mat( 613) = 0._r8
         mat( 635) = 0._r8
         mat( 636) = 0._r8
         mat( 645) = 0._r8
         mat( 654) = 0._r8
         mat( 660) = 0._r8
         mat( 661) = 0._r8
         mat( 667) = 0._r8
         mat( 683) = 0._r8
         mat( 686) = 0._r8
         mat( 688) = 0._r8
         mat( 689) = 0._r8
         mat( 695) = 0._r8
         mat( 697) = 0._r8
         mat( 698) = 0._r8
         mat( 700) = 0._r8
         mat( 702) = 0._r8
         mat( 706) = 0._r8
         mat( 707) = 0._r8
         mat( 710) = 0._r8
         mat( 712) = 0._r8
         mat( 713) = 0._r8
         mat( 722) = 0._r8
         mat( 724) = 0._r8
         mat( 728) = 0._r8
         mat( 731) = 0._r8
         mat( 733) = 0._r8
         mat( 734) = 0._r8
         mat( 739) = 0._r8
         mat( 743) = 0._r8
         mat( 746) = 0._r8
         mat( 748) = 0._r8
         mat( 750) = 0._r8
         mat( 751) = 0._r8
         mat( 753) = 0._r8
         mat( 754) = 0._r8
         mat( 755) = 0._r8
         mat( 760) = 0._r8
         mat( 761) = 0._r8
         mat( 767) = 0._r8
         mat( 771) = 0._r8
         mat( 773) = 0._r8
         mat( 774) = 0._r8
         mat( 793) = 0._r8
         mat( 795) = 0._r8
         mat( 799) = 0._r8
         mat( 800) = 0._r8
         mat( 801) = 0._r8
         mat( 802) = 0._r8
         mat( 814) = 0._r8
         mat( 820) = 0._r8
         mat( 827) = 0._r8
         mat( 829) = 0._r8
         mat( 831) = 0._r8
         mat( 834) = 0._r8
         mat( 836) = 0._r8
         mat( 843) = 0._r8
         mat( 845) = 0._r8
         mat( 847) = 0._r8
         mat( 849) = 0._r8
         mat( 850) = 0._r8
         mat( 879) = 0._r8
         mat( 880) = 0._r8
         mat( 883) = 0._r8
         mat( 884) = 0._r8
         mat( 885) = 0._r8
         mat( 886) = 0._r8
         mat( 902) = 0._r8
         mat( 904) = 0._r8
         mat( 907) = 0._r8
         mat( 908) = 0._r8
         mat( 909) = 0._r8
         mat( 915) = 0._r8
         mat( 916) = 0._r8
         mat( 917) = 0._r8
         mat( 918) = 0._r8
         mat( 928) = 0._r8
         mat( 930) = 0._r8
         mat( 936) = 0._r8
         mat( 943) = 0._r8
         mat( 949) = 0._r8
         mat( 957) = 0._r8
         mat( 958) = 0._r8
         mat( 966) = 0._r8
         mat( 973) = 0._r8
         mat( 975) = 0._r8
         mat( 976) = 0._r8
         mat( 980) = 0._r8
         mat( 981) = 0._r8
         mat( 982) = 0._r8
         mat( 983) = 0._r8
         mat( 988) = 0._r8
         mat( 990) = 0._r8
         mat( 991) = 0._r8
         mat( 994) = 0._r8
         mat( 997) = 0._r8
         mat( 999) = 0._r8
         mat(1004) = 0._r8
         mat(1005) = 0._r8
         mat(1008) = 0._r8
         mat(1012) = 0._r8
         mat(1013) = 0._r8
         mat(1016) = 0._r8
         mat(1017) = 0._r8
         mat(1035) = 0._r8
         mat(1037) = 0._r8
         mat(1038) = 0._r8
         mat(1042) = 0._r8
         mat(1043) = 0._r8
         mat(1044) = 0._r8
         mat(1058) = 0._r8
         mat(1060) = 0._r8
         mat(1066) = 0._r8
         mat(1068) = 0._r8
         mat(1069) = 0._r8
         mat(1082) = 0._r8
         mat(1088) = 0._r8
         mat(1096) = 0._r8
         mat(1097) = 0._r8
         mat(1104) = 0._r8
         mat(1109) = 0._r8
         mat(1110) = 0._r8
         mat(1111) = 0._r8
         mat(1115) = 0._r8
         mat(1130) = 0._r8
         mat(1138) = 0._r8
         mat(1142) = 0._r8
         mat(1143) = 0._r8
         mat(1144) = 0._r8
         mat(1147) = 0._r8
         mat(1148) = 0._r8
         mat(1149) = 0._r8
         mat(1150) = 0._r8
         mat(1154) = 0._r8
         mat(1155) = 0._r8
         mat(1157) = 0._r8
         mat(1158) = 0._r8
         mat(1160) = 0._r8
         mat(1168) = 0._r8
         mat(1170) = 0._r8
         mat(1171) = 0._r8
         mat(1173) = 0._r8
         mat(1177) = 0._r8
         mat(1178) = 0._r8
         mat(1181) = 0._r8
         mat(1182) = 0._r8
         mat(1183) = 0._r8
         mat(1186) = 0._r8
         mat(1203) = 0._r8
         mat(1204) = 0._r8
         mat(1250) = 0._r8
         mat(1252) = 0._r8
         mat(1258) = 0._r8
         mat(1259) = 0._r8
         mat(1268) = 0._r8
         mat(1269) = 0._r8
         mat(1273) = 0._r8
         mat(1274) = 0._r8
         mat(1275) = 0._r8
         mat(1279) = 0._r8
         mat(1280) = 0._r8
         mat(1281) = 0._r8
         mat(1285) = 0._r8
         mat(1287) = 0._r8
         mat(1289) = 0._r8
         mat(1296) = 0._r8
         mat(1297) = 0._r8
         mat(1333) = 0._r8
         mat(1348) = 0._r8
         mat(1361) = 0._r8
         mat(1385) = 0._r8
         mat(1412) = 0._r8
         mat(1421) = 0._r8
         mat(1422) = 0._r8
         mat(1423) = 0._r8
         mat(1426) = 0._r8
         mat(1427) = 0._r8
         mat(1428) = 0._r8
         mat(1429) = 0._r8
         mat(1431) = 0._r8
         mat(1432) = 0._r8
         mat(1438) = 0._r8
         mat(1442) = 0._r8
         mat(1443) = 0._r8
         mat(1444) = 0._r8
         mat(1445) = 0._r8
         mat(1446) = 0._r8
         mat(1447) = 0._r8
         mat(1448) = 0._r8
         mat(1449) = 0._r8
         mat(1450) = 0._r8
         mat(1451) = 0._r8
         mat(1452) = 0._r8
         mat(1453) = 0._r8
         mat(1454) = 0._r8
         mat(1455) = 0._r8
         mat(1461) = 0._r8
         mat(1466) = 0._r8
         mat(1468) = 0._r8
         mat(1469) = 0._r8
         mat(1470) = 0._r8
         mat(1471) = 0._r8
         mat(1472) = 0._r8
         mat(1474) = 0._r8
         mat(1475) = 0._r8
         mat(1476) = 0._r8
         mat(1478) = 0._r8
         mat(1480) = 0._r8
         mat(1481) = 0._r8
         mat(1482) = 0._r8
         mat(1484) = 0._r8
         mat(1485) = 0._r8
         mat(1487) = 0._r8
         mat(1489) = 0._r8
         mat(1495) = 0._r8
         mat(1496) = 0._r8
         mat(1498) = 0._r8
         mat(1500) = 0._r8
         mat(1501) = 0._r8
         mat(1504) = 0._r8
         mat(1505) = 0._r8
         mat(1506) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 17) = mat( 17) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 22) = mat( 22) - dti
         mat( 25) = mat( 25) - dti
         mat( 28) = mat( 28) - dti
         mat( 31) = mat( 31) - dti
         mat( 35) = mat( 35) - dti
         mat( 40) = mat( 40) - dti
         mat( 43) = mat( 43) - dti
         mat( 46) = mat( 46) - dti
         mat( 49) = mat( 49) - dti
         mat( 52) = mat( 52) - dti
         mat( 55) = mat( 55) - dti
         mat( 57) = mat( 57) - dti
         mat( 59) = mat( 59) - dti
         mat( 63) = mat( 63) - dti
         mat( 67) = mat( 67) - dti
         mat( 71) = mat( 71) - dti
         mat( 74) = mat( 74) - dti
         mat( 77) = mat( 77) - dti
         mat( 82) = mat( 82) - dti
         mat( 86) = mat( 86) - dti
         mat( 92) = mat( 92) - dti
         mat( 98) = mat( 98) - dti
         mat( 104) = mat( 104) - dti
         mat( 110) = mat( 110) - dti
         mat( 117) = mat( 117) - dti
         mat( 122) = mat( 122) - dti
         mat( 127) = mat( 127) - dti
         mat( 132) = mat( 132) - dti
         mat( 136) = mat( 136) - dti
         mat( 141) = mat( 141) - dti
         mat( 144) = mat( 144) - dti
         mat( 152) = mat( 152) - dti
         mat( 156) = mat( 156) - dti
         mat( 162) = mat( 162) - dti
         mat( 168) = mat( 168) - dti
         mat( 174) = mat( 174) - dti
         mat( 180) = mat( 180) - dti
         mat( 186) = mat( 186) - dti
         mat( 191) = mat( 191) - dti
         mat( 196) = mat( 196) - dti
         mat( 203) = mat( 203) - dti
         mat( 210) = mat( 210) - dti
         mat( 217) = mat( 217) - dti
         mat( 224) = mat( 224) - dti
         mat( 229) = mat( 229) - dti
         mat( 235) = mat( 235) - dti
         mat( 243) = mat( 243) - dti
         mat( 248) = mat( 248) - dti
         mat( 256) = mat( 256) - dti
         mat( 262) = mat( 262) - dti
         mat( 270) = mat( 270) - dti
         mat( 274) = mat( 274) - dti
         mat( 282) = mat( 282) - dti
         mat( 290) = mat( 290) - dti
         mat( 298) = mat( 298) - dti
         mat( 305) = mat( 305) - dti
         mat( 314) = mat( 314) - dti
         mat( 321) = mat( 321) - dti
         mat( 326) = mat( 326) - dti
         mat( 337) = mat( 337) - dti
         mat( 346) = mat( 346) - dti
         mat( 360) = mat( 360) - dti
         mat( 371) = mat( 371) - dti
         mat( 377) = mat( 377) - dti
         mat( 381) = mat( 381) - dti
         mat( 390) = mat( 390) - dti
         mat( 399) = mat( 399) - dti
         mat( 407) = mat( 407) - dti
         mat( 416) = mat( 416) - dti
         mat( 427) = mat( 427) - dti
         mat( 435) = mat( 435) - dti
         mat( 444) = mat( 444) - dti
         mat( 454) = mat( 454) - dti
         mat( 464) = mat( 464) - dti
         mat( 478) = mat( 478) - dti
         mat( 488) = mat( 488) - dti
         mat( 496) = mat( 496) - dti
         mat( 512) = mat( 512) - dti
         mat( 519) = mat( 519) - dti
         mat( 532) = mat( 532) - dti
         mat( 542) = mat( 542) - dti
         mat( 554) = mat( 554) - dti
         mat( 562) = mat( 562) - dti
         mat( 574) = mat( 574) - dti
         mat( 589) = mat( 589) - dti
         mat( 604) = mat( 604) - dti
         mat( 609) = mat( 609) - dti
         mat( 618) = mat( 618) - dti
         mat( 627) = mat( 627) - dti
         mat( 639) = mat( 639) - dti
         mat( 652) = mat( 652) - dti
         mat( 664) = mat( 664) - dti
         mat( 679) = mat( 679) - dti
         mat( 699) = mat( 699) - dti
         mat( 723) = mat( 723) - dti
         mat( 742) = mat( 742) - dti
         mat( 762) = mat( 762) - dti
         mat( 791) = mat( 791) - dti
         mat( 807) = mat( 807) - dti
         mat( 826) = mat( 826) - dti
         mat( 841) = mat( 841) - dti
         mat( 874) = mat( 874) - dti
         mat( 905) = mat( 905) - dti
         mat( 945) = mat( 945) - dti
         mat( 970) = mat( 970) - dti
         mat(1006) = mat(1006) - dti
         mat(1034) = mat(1034) - dti
         mat(1061) = mat(1061) - dti
         mat(1131) = mat(1131) - dti
         mat(1152) = mat(1152) - dti
         mat(1198) = mat(1198) - dti
         mat(1254) = mat(1254) - dti
         mat(1292) = mat(1292) - dti
         mat(1391) = mat(1391) - dti
         mat(1436) = mat(1436) - dti
         mat(1459) = mat(1459) - dti
         mat(1486) = mat(1486) - dti
         mat(1511) = mat(1511) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat07( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
