



      module mo_prod_loss

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: exp_prod_loss
      public :: imp_prod_loss

      contains

      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:,:,:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:,:,:)
      real(r8), intent(in) :: rxt(:,:,:)
      real(r8), intent(in) :: het_rates(:,:,:)



!--------------------------------------------------------------------
! ... loss and production for Explicit method
!--------------------------------------------------------------------


         loss(:,:,1) = ((rxt(:,:,156) +rxt(:,:,157) +rxt(:,:,158))* y(:,:,3) &
                  +rxt(:,:,266)* y(:,:,23) +rxt(:,:,213)* y(:,:,28) +rxt(:,:,252) &
                 * y(:,:,135) + rxt(:,:,59) + rxt(:,:,60) + het_rates(:,:,15)) &
                 * y(:,:,15)
         prod(:,:,1) = 0._r8
         loss(:,:,2) = ((rxt(:,:,135) +rxt(:,:,136))* y(:,:,3) + rxt(:,:,5) &
                  + het_rates(:,:,7))* y(:,:,7)
         prod(:,:,2) = 0._r8
         loss(:,:,3) = (rxt(:,:,255)* y(:,:,23) +rxt(:,:,254)* y(:,:,28) + rxt(:,:,37) &
                  + het_rates(:,:,102))* y(:,:,102)
         prod(:,:,3) = 0._r8
         loss(:,:,4) = (rxt(:,:,147)* y(:,:,3) +rxt(:,:,258)* y(:,:,23) +rxt(:,:,259) &
                 * y(:,:,28) + rxt(:,:,48) + het_rates(:,:,103))* y(:,:,103)
         prod(:,:,4) = 0._r8
         loss(:,:,5) = (rxt(:,:,138)* y(:,:,3) + rxt(:,:,40) + het_rates(:,:,104)) &
                 * y(:,:,104)
         prod(:,:,5) = 0._r8
         loss(:,:,6) = (rxt(:,:,139)* y(:,:,3) + rxt(:,:,41) + het_rates(:,:,105)) &
                 * y(:,:,105)
         prod(:,:,6) = 0._r8
         loss(:,:,7) = (rxt(:,:,140)* y(:,:,3) + rxt(:,:,42) + het_rates(:,:,106)) &
                 * y(:,:,106)
         prod(:,:,7) = 0._r8
         loss(:,:,8) = (rxt(:,:,141)* y(:,:,3) + rxt(:,:,43) + het_rates(:,:,114)) &
                 * y(:,:,114)
         prod(:,:,8) = 0._r8
         loss(:,:,9) = (rxt(:,:,142)* y(:,:,3) + rxt(:,:,44) + het_rates(:,:,115)) &
                 * y(:,:,115)
         prod(:,:,9) = 0._r8
         loss(:,:,10) = (rxt(:,:,143)* y(:,:,3) +rxt(:,:,257)* y(:,:,23) + rxt(:,:,45) &
                  + het_rates(:,:,107))* y(:,:,107)
         prod(:,:,10) = 0._r8
         loss(:,:,11) = (rxt(:,:,144)* y(:,:,3) +rxt(:,:,260)* y(:,:,23) + rxt(:,:,46) &
                  + het_rates(:,:,112))* y(:,:,112)
         prod(:,:,11) = 0._r8
         loss(:,:,12) = (rxt(:,:,145)* y(:,:,3) +rxt(:,:,261)* y(:,:,23) + rxt(:,:,47) &
                  + het_rates(:,:,113))* y(:,:,113)
         prod(:,:,12) = 0._r8
         loss(:,:,13) = (rxt(:,:,146)* y(:,:,3) + rxt(:,:,38) + het_rates(:,:,108)) &
                 * y(:,:,108)
         prod(:,:,13) = 0._r8
         loss(:,:,14) = (rxt(:,:,256)* y(:,:,23) + rxt(:,:,39) + het_rates(:,:,109)) &
                 * y(:,:,109)
         prod(:,:,14) = 0._r8
         loss(:,:,15) = (rxt(:,:,149)* y(:,:,3) + rxt(:,:,49) + het_rates(:,:,110)) &
                 * y(:,:,110)
         prod(:,:,15) = 0._r8
         loss(:,:,16) = (rxt(:,:,148)* y(:,:,3) + rxt(:,:,50) + het_rates(:,:,111)) &
                 * y(:,:,111)
         prod(:,:,16) = 0._r8
         loss(:,:,17) = (rxt(:,:,150)* y(:,:,3) + rxt(:,:,53) + het_rates(:,:,116)) &
                 * y(:,:,116)
         prod(:,:,17) = 0._r8
         loss(:,:,18) = (rxt(:,:,151)* y(:,:,3) + rxt(:,:,54) + het_rates(:,:,117)) &
                 * y(:,:,117)
         prod(:,:,18) = 0._r8
         loss(:,:,19) = (rxt(:,:,152)* y(:,:,3) +rxt(:,:,263)* y(:,:,23) +rxt(:,:,265) &
                 * y(:,:,28) + rxt(:,:,51) + het_rates(:,:,118))* y(:,:,118)
         prod(:,:,19) = 0._r8
         loss(:,:,20) = (rxt(:,:,153)* y(:,:,3) +rxt(:,:,262)* y(:,:,23) +rxt(:,:,264) &
                 * y(:,:,28) + rxt(:,:,52) + het_rates(:,:,119))* y(:,:,119)
         prod(:,:,20) = 0._r8
         loss(:,:,21) = (rxt(:,:,457)* y(:,:,124) + rxt(:,:,58) + rxt(:,:,117) &
                  + het_rates(:,:,120))* y(:,:,120)
         prod(:,:,21) =.440_r8*rxt(:,:,60)*y(:,:,15)
         loss(:,:,22) = ( + het_rates(:,:,26))* y(:,:,26)
         prod(:,:,22) = 0._r8
         loss(:,:,23) = ( + het_rates(:,:,27))* y(:,:,27)
         prod(:,:,23) = 0._r8

      end subroutine exp_prod_loss

      subroutine imp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:)
      real(r8), intent(in) :: rxt(:)
      real(r8), intent(in) :: het_rates(:)



!--------------------------------------------------------------------
! ... loss and production for Implicit method
!--------------------------------------------------------------------


         loss(128) = (rxt(119)* y(2) +rxt(137)* y(3) +rxt(192)* y(9) +rxt(195)* y(10) &
                  +rxt(164)* y(22) +rxt(169)* y(23) +rxt(177)* y(24) +rxt(207)* y(28) &
                  +rxt(234)* y(37) +rxt(293)* y(44) +rxt(314)* y(59) +rxt(336)* y(77) &
                  +rxt(342)* y(78) +rxt(360)* y(83) +rxt(392)* y(99) +rxt(423)* y(147) &
                  +rxt(426)* y(148) + rxt(3) + rxt(4) + het_rates(1))* y(1)
         prod(128) = (.200_r8*rxt(336)*y(77) +.200_r8*rxt(342)*y(78) + &
                 .100_r8*rxt(360)*y(83))*y(1) + (.250_r8*rxt(304)*y(48) + &
                 .250_r8*rxt(352)*y(76))*y(24) +rxt(118)*y(4)*y(2)
         loss(121) = (rxt(119)* y(1) + 2._r8*rxt(120)* y(2) +rxt(118)* y(4) +rxt(190) &
                 * y(9) + (rxt(193) +rxt(194))* y(10) +rxt(201)* y(11) +rxt(271) &
                 * y(19) +rxt(175)* y(21) +rxt(168)* y(23) +rxt(176)* y(24) +rxt(179) &
                 * y(25) +rxt(214)* y(30) +rxt(227)* y(33) +rxt(228)* y(34) +rxt(231) &
                 * y(35) +rxt(237)* y(38) +rxt(247)* y(39) +rxt(248)* y(40) +rxt(249) &
                 * y(41) + (rxt(455) +rxt(456))* y(121) +rxt(462)* y(123) +rxt(419) &
                 * y(146) + rxt(92) + rxt(93) + rxt(94) + rxt(105) + rxt(106) &
                  + rxt(107) + het_rates(2))* y(2)
         prod(121) = (rxt(1) +2.000_r8*rxt(2) +rxt(98) +rxt(99) +rxt(100) + &
                 2.000_r8*rxt(103) +rxt(110) +rxt(111) +rxt(112) +2.000_r8*rxt(115) + &
                 rxt(132)*y(3) +rxt(133)*y(3) +rxt(185)*y(8) +rxt(422)*y(147) + &
                 rxt(425)*y(148) +rxt(453)*y(124) +rxt(461)*y(123))*y(4) &
                  + (rxt(186)*y(9) +rxt(187)*y(10) +rxt(458)*y(122))*y(8) &
                  + (rxt(465)*y(125) +1.150_r8*rxt(466)*y(122))*y(126) +rxt(4)*y(1) &
                  +rxt(131)*y(3) +rxt(6)*y(9) +rxt(8)*y(10) +rxt(12)*y(11) +rxt(10) &
                 *y(14) +rxt(167)*y(24)*y(22) +rxt(171)*y(23)*y(23) +rxt(24)*y(30) &
                  +rxt(25)*y(31) +rxt(32)*y(38) +rxt(21)*y(128) +rxt(88)*y(141) &
                  +rxt(91)*y(148) +rxt(89)*y(149)
         loss(125) = (rxt(137)* y(1) + (rxt(132) +rxt(133))* y(4) + (rxt(135) + &
                 rxt(136))* y(7) + (rxt(156) +rxt(157) +rxt(158))* y(15) +rxt(159) &
                 * y(21) +rxt(160)* y(33) +rxt(161)* y(39) +rxt(162)* y(42) +rxt(147) &
                 * y(103) +rxt(138)* y(104) +rxt(139)* y(105) +rxt(140)* y(106) &
                  +rxt(143)* y(107) +rxt(146)* y(108) +rxt(149)* y(110) +rxt(148) &
                 * y(111) +rxt(144)* y(112) +rxt(145)* y(113) +rxt(141)* y(114) &
                  +rxt(142)* y(115) +rxt(150)* y(116) +rxt(151)* y(117) +rxt(152) &
                 * y(118) +rxt(153)* y(119) +rxt(134)* y(128) +rxt(154)* y(132) &
                  +rxt(155)* y(133) + rxt(131) + het_rates(3))* y(3)
         prod(125) = (rxt(1) +rxt(182)*y(127))*y(4) +rxt(3)*y(1) &
                  +.850_r8*rxt(466)*y(126)*y(122) +rxt(20)*y(128)
         loss(120) = (rxt(118)* y(2) +rxt(132)* y(3) +rxt(128)* y(6) +rxt(185)* y(8) &
                  +rxt(163)* y(22) +rxt(291)* y(56) +rxt(463)* y(121) + (rxt(460) + &
                 rxt(461))* y(123) +rxt(453)* y(124) +rxt(182)* y(127) +rxt(422) &
                 * y(147) +rxt(425)* y(148) + rxt(1) + rxt(2) + rxt(96) + rxt(98) &
                  + rxt(99) + rxt(100) + rxt(103) + rxt(108) + rxt(110) + rxt(111) &
                  + rxt(112) + rxt(115) + het_rates(4))* y(4)
         prod(120) = (rxt(166)*y(22) +rxt(170)*y(23) +rxt(176)*y(2) + &
                 2.000_r8*rxt(177)*y(1) +rxt(178)*y(24) +rxt(203)*y(11) + &
                 rxt(210)*y(28) +rxt(217)*y(30) +rxt(235)*y(37) +rxt(239)*y(38) + &
                 rxt(274)*y(16) +rxt(296)*y(46) +rxt(317)*y(61) +rxt(322)*y(64) + &
                 rxt(326)*y(67) +.750_r8*rxt(352)*y(76))*y(24) + (rxt(4) + &
                 2.000_r8*rxt(119)*y(2) +2.000_r8*rxt(137)*y(3) +rxt(164)*y(22) + &
                 rxt(169)*y(23) +rxt(192)*y(9) +rxt(195)*y(10) +rxt(207)*y(28) + &
                 rxt(234)*y(37) +rxt(423)*y(147) +rxt(426)*y(148))*y(1) &
                  + (rxt(120)*y(2) +rxt(127)*y(6) +rxt(168)*y(23) +rxt(193)*y(10) + &
                 rxt(201)*y(11) +rxt(214)*y(30) +rxt(237)*y(38))*y(2) &
                  + (rxt(216)*y(23) +rxt(221)*y(30) +rxt(222)*y(30) +rxt(243)*y(38) + &
                 rxt(244)*y(38))*y(30) + (rxt(129) +rxt(130) +2.000_r8*rxt(128)*y(4)) &
                 *y(6) +rxt(136)*y(7)*y(3) +rxt(126)*y(5) +rxt(189)*y(10)*y(8) &
                  +rxt(459)*y(122)*y(9) +rxt(13)*y(11) +rxt(205)*y(23)*y(13) &
                  +rxt(245)*y(38)*y(38)
         loss(28) = (rxt(124)* y(1) +rxt(121)* y(2) +rxt(122)* y(4) +rxt(125)* y(120) &
                  + rxt(123) + rxt(126) + het_rates(5))* y(5)
         prod(28) =rxt(132)*y(4)*y(3)
         loss(27) = (rxt(127)* y(2) +rxt(128)* y(4) + rxt(129) + rxt(130) &
                  + het_rates(6))* y(6)
         prod(27) = (rxt(123) +rxt(125)*y(120) +rxt(121)*y(2) +rxt(122)*y(4) + &
                 rxt(124)*y(1))*y(5) +rxt(3)*y(1)
         loss(108) = (rxt(175)* y(2) +rxt(159)* y(3) +rxt(173)* y(23) +rxt(208)* y(28) &
                  +rxt(251)* y(135) + het_rates(21))* y(21)
         prod(108) =rxt(158)*y(15)*y(3) +rxt(18)*y(19) +rxt(166)*y(24)*y(22) +rxt(20) &
                 *y(128)
         loss(103) = ((rxt(267) +rxt(268))* y(23) + het_rates(20))* y(20)
         prod(103) = (rxt(17) +rxt(18) +rxt(212)*y(28) +rxt(236)*y(37) + &
                 rxt(269)*y(11) +rxt(270)*y(23) +rxt(271)*y(2))*y(19) &
                  + (.500_r8*rxt(293)*y(44) +.560_r8*rxt(314)*y(59) + &
                 .050_r8*rxt(336)*y(77) +.200_r8*rxt(342)*y(78) + &
                 .300_r8*rxt(360)*y(83))*y(1) + (.350_r8*rxt(286)*y(129) + &
                 rxt(309)*y(53) +rxt(330)*y(68) +rxt(420)*y(146))*y(23) &
                  + (.220_r8*rxt(343)*y(9) +.220_r8*rxt(345)*y(11) + &
                 .110_r8*rxt(347)*y(16) +.220_r8*rxt(348)*y(48))*y(79) &
                  + (.500_r8*rxt(378)*y(9) +.500_r8*rxt(379)*y(11) + &
                 .200_r8*rxt(381)*y(16) +.500_r8*rxt(382)*y(48))*y(91) + (rxt(74) + &
                 rxt(331)*y(11))*y(68) + (rxt(90) +rxt(419)*y(2))*y(146) &
                  +rxt(254)*y(102)*y(28) +rxt(61)*y(50) +rxt(79)*y(52) &
                  +2.000_r8*rxt(82)*y(53) +.700_r8*rxt(68)*y(77) +1.340_r8*rxt(67) &
                 *y(78) +.450_r8*rxt(81)*y(86) +rxt(76)*y(90) +rxt(457)*y(124)*y(120)
         loss(92) = (rxt(185)* y(4) +rxt(186)* y(9) + (rxt(187) +rxt(188) +rxt(189)) &
                 * y(10) +rxt(184)* y(23) +rxt(458)* y(122) + rxt(95) + het_rates(8)) &
                 * y(8)
         prod(92) = (rxt(183)*y(127) +rxt(462)*y(123))*y(2) &
                  + (.200_r8*rxt(465)*y(125) +1.100_r8*rxt(467)*y(121))*y(126) &
                  +rxt(460)*y(123)*y(4) +rxt(6)*y(9) +rxt(454)*y(124)
         loss(129) = (rxt(192)* y(1) +rxt(190)* y(2) +rxt(186)* y(8) +rxt(200)* y(11) &
                  +rxt(273)* y(16) +rxt(191)* y(24) +rxt(219)* y(30) +rxt(240)* y(38) &
                  +rxt(295)* y(46) +rxt(302)* y(48) +rxt(289)* y(55) +rxt(316)* y(61) &
                  +rxt(321)* y(64) +rxt(325)* y(67) +rxt(334)* y(73) +rxt(338)* y(74) &
                  +rxt(350)* y(76) + (rxt(343) +rxt(344))* y(79) +rxt(375)* y(84) &
                  +rxt(362)* y(88) +rxt(368)* y(89) +rxt(378)* y(91) +rxt(386)* y(96) &
                  +rxt(394)* y(100) +rxt(459)* y(122) +rxt(281)* y(131) + rxt(6) &
                  + rxt(7) + het_rates(9))* y(9)
         prod(129) = (rxt(8) +.500_r8*rxt(399) +2.000_r8*rxt(188)*y(8) + &
                 rxt(193)*y(2) +rxt(427)*y(148))*y(10) + (rxt(182)*y(127) + &
                 rxt(185)*y(8))*y(4) +2.000_r8*rxt(135)*y(7)*y(3) +rxt(184)*y(23)*y(8) &
                  +rxt(13)*y(11) +rxt(10)*y(14) +rxt(464)*y(122)
         loss(130) = (rxt(195)* y(1) + (rxt(193) +rxt(194))* y(2) + (rxt(187) + &
                 rxt(188) +rxt(189))* y(8) +rxt(196)* y(11) +rxt(198)* y(23) +rxt(204) &
                 * y(24) +rxt(220)* y(30) +rxt(241)* y(38) +rxt(303)* y(48) +rxt(356) &
                 * y(76) +rxt(390)* y(98) +rxt(427)* y(148) + rxt(8) + rxt(399) &
                  + het_rates(10))* y(10)
         prod(130) = (rxt(190)*y(2) +rxt(191)*y(24) +rxt(192)*y(1) + &
                 2.000_r8*rxt(200)*y(11) +rxt(219)*y(30) +rxt(240)*y(38) + &
                 rxt(273)*y(16) +rxt(281)*y(131) +rxt(289)*y(55) +rxt(295)*y(46) + &
                 rxt(302)*y(48) +rxt(316)*y(61) +rxt(321)*y(64) +rxt(325)*y(67) + &
                 rxt(334)*y(73) +rxt(338)*y(74) +rxt(343)*y(79) +rxt(350)*y(76) + &
                 .920_r8*rxt(362)*y(88) +1.206_r8*rxt(368)*y(89) + &
                 .900_r8*rxt(375)*y(84) +rxt(378)*y(91) +.900_r8*rxt(386)*y(96) + &
                 rxt(394)*y(100))*y(9) + (rxt(12) +rxt(201)*y(2) +rxt(202)*y(23) + &
                 rxt(203)*y(24) +rxt(345)*y(79) +rxt(351)*y(76) +rxt(363)*y(88) + &
                 1.206_r8*rxt(369)*y(89) +rxt(373)*y(90) +rxt(379)*y(91) + &
                 rxt(393)*y(99))*y(11) + (rxt(15) +rxt(206) +rxt(205)*y(23))*y(13) &
                  + (rxt(9) +rxt(197))*y(14) + (rxt(332)*y(82) + &
                 .400_r8*rxt(372)*y(90))*y(23) + (.600_r8*rxt(64) +rxt(311))*y(58) &
                  + (rxt(65) +rxt(357))*y(81) +.700_r8*rxt(390)*y(98)*y(10) +rxt(11) &
                 *y(12) +.206_r8*rxt(370)*y(89)*y(24) +rxt(30)*y(35) +rxt(36)*y(41) &
                  +rxt(76)*y(90)
         loss(131) = (rxt(169)* y(1) +rxt(168)* y(2) +rxt(184)* y(8) +rxt(198)* y(10) &
                  +rxt(202)* y(11) +rxt(199)* y(12) +rxt(205)* y(13) +rxt(266)* y(15) &
                  +rxt(278)* y(17) +rxt(277)* y(18) +rxt(270)* y(19) + (rxt(267) + &
                 rxt(268))* y(20) +rxt(173)* y(21) + 2._r8*(rxt(171) +rxt(172))* y(23) &
                  +rxt(170)* y(24) +rxt(174)* y(25) + (rxt(215) +rxt(216))* y(30) &
                  +rxt(226)* y(33) +rxt(230)* y(34) +rxt(232)* y(35) +rxt(238)* y(38) &
                  +rxt(246)* y(39) +rxt(180)* y(42) +rxt(181)* y(43) +rxt(288)* y(44) &
                  +rxt(287)* y(45) +rxt(299)* y(47) +rxt(294)* y(49) +rxt(300)* y(50) &
                  +rxt(310)* y(51) +rxt(308)* y(52) +rxt(309)* y(53) +rxt(307)* y(54) &
                  +rxt(312)* y(58) +rxt(313)* y(59) +rxt(320)* y(60) +rxt(319)* y(62) &
                  +rxt(324)* y(63) +rxt(323)* y(65) +rxt(329)* y(66) +rxt(330)* y(68) &
                  +rxt(328)* y(69) +rxt(333)* y(70) +rxt(371)* y(71) +rxt(337)* y(72) &
                  +rxt(340)* y(75) +rxt(335)* y(77) +rxt(341)* y(78) +rxt(349)* y(80) &
                  +rxt(358)* y(81) +rxt(332)* y(82) +rxt(359)* y(83) +rxt(377)* y(85) &
                  +rxt(374)* y(87) +rxt(372)* y(90) +rxt(383)* y(92) +rxt(365)* y(93) &
                  +rxt(385)* y(94) +rxt(389)* y(95) +rxt(388)* y(97) +rxt(391)* y(99) &
                  +rxt(396)* y(101) +rxt(255)* y(102) +rxt(258)* y(103) +rxt(257) &
                 * y(107) +rxt(256)* y(109) +rxt(260)* y(112) +rxt(261)* y(113) &
                  +rxt(263)* y(118) +rxt(262)* y(119) +rxt(286)* y(129) +rxt(279) &
                 * y(130) +rxt(431)* y(141) + (rxt(433) +rxt(434))* y(142) +rxt(420) &
                 * y(146) +rxt(421)* y(147) +rxt(424)* y(148) + het_rates(23))* y(23)
         prod(131) = (rxt(164)*y(22) +rxt(177)*y(24) +.120_r8*rxt(293)*y(44) + &
                 .330_r8*rxt(314)*y(59) +.080_r8*rxt(336)*y(77) + &
                 .215_r8*rxt(342)*y(78) +.270_r8*rxt(360)*y(83) + &
                 .700_r8*rxt(392)*y(99))*y(1) + (rxt(175)*y(21) +rxt(176)*y(24) + &
                 rxt(179)*y(25) +rxt(227)*y(33) +rxt(228)*y(34) +rxt(247)*y(39) + &
                 rxt(248)*y(40) +rxt(271)*y(19))*y(2) + (rxt(156)*y(15) + &
                 2.000_r8*rxt(134)*y(128) +rxt(159)*y(21) +rxt(160)*y(33) + &
                 rxt(161)*y(39) +rxt(162)*y(42))*y(3) + (.300_r8*rxt(278)*y(17) + &
                 .650_r8*rxt(286)*y(129) +.500_r8*rxt(299)*y(47) + &
                 .500_r8*rxt(323)*y(65) +.100_r8*rxt(349)*y(80))*y(23) &
                  + (2.000_r8*rxt(165)*y(22) +rxt(191)*y(9) +rxt(203)*y(11) + &
                 rxt(211)*y(28))*y(24) + (rxt(19) +rxt(250)*y(135))*y(128) &
                  +.500_r8*rxt(399)*y(10) +rxt(11)*y(12) +rxt(14)*y(13) +rxt(16)*y(17) &
                  +2.000_r8*rxt(22)*y(25) +rxt(27)*y(34) +rxt(33)*y(40) +rxt(69)*y(47) &
                  +rxt(63)*y(54) +rxt(70)*y(57) +rxt(71)*y(62) +rxt(62)*y(65) +rxt(72) &
                 *y(69) +rxt(84)*y(75) +rxt(83)*y(85) +rxt(75)*y(92) +rxt(85)*y(97) &
                  +rxt(86)*y(101)
         loss(132) = (rxt(201)* y(2) +rxt(200)* y(9) +rxt(196)* y(10) +rxt(269)* y(19) &
                  +rxt(202)* y(23) +rxt(203)* y(24) +rxt(301)* y(50) +rxt(315)* y(59) &
                  +rxt(331)* y(68) +rxt(351)* y(76) +rxt(345)* y(79) +rxt(361)* y(83) &
                  +rxt(363)* y(88) +rxt(369)* y(89) +rxt(373)* y(90) +rxt(379)* y(91) &
                  +rxt(393)* y(99) +rxt(435)* y(142) + rxt(12) + rxt(13) + rxt(398) &
                  + het_rates(11))* y(11)
         prod(132) = (rxt(199)*y(12) +rxt(232)*y(35) +rxt(312)*y(58) + &
                 .500_r8*rxt(358)*y(81))*y(23) + (rxt(194)*y(10) +rxt(231)*y(35) + &
                 rxt(249)*y(41))*y(2) + (rxt(9) +rxt(10) +rxt(197))*y(14) + (rxt(29) + &
                 rxt(233)*y(28))*y(35) +rxt(195)*y(10)*y(1) +rxt(253)*y(135)*y(12) &
                  +rxt(14)*y(13) +rxt(35)*y(41) +.400_r8*rxt(64)*y(58)
         loss(133) = (rxt(199)* y(23) +rxt(253)* y(135) + rxt(11) + het_rates(12)) &
                 * y(12)
         prod(133) = (rxt(437) +rxt(443) +rxt(448) +rxt(439)*y(33) +rxt(444)*y(33) + &
                 rxt(450)*y(33))*y(35) + (rxt(398) +rxt(269)*y(19) +rxt(301)*y(50) + &
                 rxt(331)*y(68) +rxt(435)*y(142))*y(11) + (2.000_r8*rxt(397) + &
                 2.000_r8*rxt(436) +2.000_r8*rxt(442) +2.000_r8*rxt(447))*y(14) &
                  + (rxt(438) +rxt(446) +rxt(449))*y(41) + (.500_r8*rxt(399) + &
                 rxt(198)*y(23))*y(10)
         loss(60) = (rxt(205)* y(23) + rxt(14) + rxt(15) + rxt(206) + het_rates(13)) &
                 * y(13)
         prod(60) =rxt(204)*y(24)*y(10)
         loss(40) = ( + rxt(9) + rxt(10) + rxt(197) + rxt(397) + rxt(436) + rxt(442) &
                  + rxt(447) + het_rates(14))* y(14)
         prod(40) =rxt(196)*y(11)*y(10)
         loss(119) = (rxt(273)* y(9) + 2._r8*(rxt(275) +rxt(276))* y(16) +rxt(274) &
                 * y(24) +rxt(218)* y(30) +rxt(297)* y(46) +rxt(305)* y(48) +rxt(318) &
                 * y(61) +rxt(327)* y(67) +rxt(353)* y(76) +rxt(347)* y(79) +rxt(366) &
                 * y(88) +rxt(381)* y(91) + het_rates(16))* y(16)
         prod(119) = (rxt(302)*y(9) +.900_r8*rxt(305)*y(16) +2.000_r8*rxt(306)*y(48) + &
                 rxt(348)*y(79) +rxt(354)*y(76) +rxt(367)*y(88) +rxt(382)*y(91))*y(48) &
                  + (rxt(156)*y(3) +rxt(213)*y(28) +rxt(252)*y(135) +rxt(266)*y(23)) &
                 *y(15) + (.700_r8*rxt(278)*y(17) +rxt(294)*y(49))*y(23) &
                  +.310_r8*rxt(314)*y(59)*y(1) +rxt(61)*y(50) +rxt(63)*y(54) &
                  +.400_r8*rxt(64)*y(58) +rxt(73)*y(63) +.300_r8*rxt(68)*y(77)
         loss(50) = (rxt(278)* y(23) + rxt(16) + het_rates(17))* y(17)
         prod(50) =rxt(274)*y(24)*y(16)
         loss(30) = (rxt(162)* y(3) +rxt(180)* y(23) + het_rates(42))* y(42)
         prod(30) = 0._r8
         loss(17) = (rxt(181)* y(23) + het_rates(43))* y(43)
         prod(17) = 0._r8
         loss(135) = (rxt(271)* y(2) +rxt(269)* y(11) +rxt(270)* y(23) +rxt(272) &
                 * y(24) +rxt(212)* y(28) +rxt(236)* y(37) + rxt(17) + rxt(18) &
                  + het_rates(19))* y(19)
         prod(135) = (rxt(218)*y(30) +rxt(273)*y(9) +2.000_r8*rxt(275)*y(16) + &
                 rxt(276)*y(16) +.700_r8*rxt(297)*y(46) +rxt(305)*y(48) + &
                 rxt(318)*y(61) +.800_r8*rxt(327)*y(67) +.880_r8*rxt(347)*y(79) + &
                 2.000_r8*rxt(353)*y(76) +1.200_r8*rxt(366)*y(88) + &
                 .700_r8*rxt(381)*y(91))*y(16) + (.500_r8*rxt(289)*y(55) + &
                 rxt(321)*y(64) +rxt(325)*y(67) +.500_r8*rxt(334)*y(73) + &
                 .250_r8*rxt(343)*y(79) +rxt(350)*y(76) +.510_r8*rxt(362)*y(88) + &
                 .072_r8*rxt(368)*y(89) +.100_r8*rxt(375)*y(84))*y(9) &
                  + (rxt(277)*y(18) +.300_r8*rxt(278)*y(17) +.500_r8*rxt(307)*y(54) + &
                 .800_r8*rxt(308)*y(52) +rxt(312)*y(58) +.500_r8*rxt(358)*y(81))*y(23) &
                  + (rxt(293)*y(44) +.540_r8*rxt(314)*y(59) +.800_r8*rxt(336)*y(77) + &
                 .700_r8*rxt(342)*y(78) +.600_r8*rxt(360)*y(83))*y(1) &
                  + (.250_r8*rxt(345)*y(79) +rxt(351)*y(76) +.600_r8*rxt(363)*y(88) + &
                 .072_r8*rxt(369)*y(89))*y(11) + (.250_r8*rxt(348)*y(79) + &
                 rxt(354)*y(76) +.600_r8*rxt(367)*y(88))*y(48) + (rxt(157)*y(15) + &
                 rxt(158)*y(15))*y(3) +rxt(16)*y(17) +.008_r8*rxt(370)*y(89)*y(24) &
                  +rxt(79)*y(52) +2.000_r8*rxt(292)*y(56) +rxt(62)*y(65) +rxt(78) &
                 *y(66) +rxt(72)*y(69) +2.000_r8*rxt(355)*y(76)*y(76) &
                  +1.340_r8*rxt(66)*y(78) +.100_r8*rxt(83)*y(85) +rxt(76)*y(90) &
                  +.690_r8*rxt(77)*y(93) +rxt(280)*y(131)
         loss(127) = (rxt(164)* y(1) +rxt(163)* y(4) + (rxt(165) +rxt(166) +rxt(167)) &
                 * y(24) + het_rates(22))* y(22)
         prod(127) = (rxt(168)*y(2) +rxt(173)*y(21) +rxt(184)*y(8) +rxt(267)*y(20) + &
                 rxt(270)*y(19) +rxt(420)*y(146) +rxt(421)*y(147) +rxt(424)*y(148)) &
                 *y(23) + (rxt(159)*y(3) +rxt(175)*y(2) +rxt(208)*y(28) + &
                 rxt(251)*y(135))*y(21) + (rxt(19) +2.000_r8*rxt(21))*y(128) &
                  +rxt(157)*y(15)*y(3) +rxt(16)*y(17) +2.000_r8*rxt(17)*y(19) +rxt(28) &
                 *y(33) +rxt(34)*y(39) +rxt(57)*y(134)
         loss(126) = (rxt(177)* y(1) +rxt(176)* y(2) +rxt(191)* y(9) +rxt(204)* y(10) &
                  +rxt(203)* y(11) +rxt(274)* y(16) +rxt(272)* y(19) + (rxt(165) + &
                 rxt(166) +rxt(167))* y(22) +rxt(170)* y(23) + 2._r8*rxt(178)* y(24) &
                  + (rxt(210) +rxt(211))* y(28) +rxt(217)* y(30) +rxt(235)* y(37) &
                  +rxt(239)* y(38) +rxt(296)* y(46) +rxt(304)* y(48) +rxt(290)* y(55) &
                  +rxt(317)* y(61) +rxt(322)* y(64) +rxt(326)* y(67) +rxt(339)* y(74) &
                  +rxt(352)* y(76) +rxt(346)* y(79) +rxt(376)* y(84) +rxt(364)* y(88) &
                  +rxt(370)* y(89) +rxt(380)* y(91) +rxt(387)* y(96) +rxt(395)* y(100) &
                  +rxt(282)* y(131) + rxt(402) + het_rates(24))* y(24)
         prod(126) = (rxt(255)*y(102) +rxt(258)*y(103) +rxt(169)*y(1) + &
                 rxt(174)*y(25) +rxt(180)*y(42) +rxt(181)*y(43) +rxt(202)*y(11) + &
                 rxt(215)*y(30) +rxt(238)*y(38) +rxt(268)*y(20) +rxt(277)*y(18) + &
                 rxt(279)*y(130) +.350_r8*rxt(286)*y(129) +rxt(308)*y(52) + &
                 rxt(309)*y(53) +rxt(310)*y(51) +rxt(329)*y(66) + &
                 .200_r8*rxt(349)*y(80) +.500_r8*rxt(358)*y(81) +rxt(372)*y(90) + &
                 .250_r8*rxt(385)*y(94) +rxt(431)*y(141) +.500_r8*rxt(434)*y(142)) &
                 *y(23) + (rxt(273)*y(16) +rxt(281)*y(131) +.250_r8*rxt(289)*y(55) + &
                 rxt(295)*y(46) +rxt(316)*y(61) +rxt(321)*y(64) +rxt(334)*y(73) + &
                 .470_r8*rxt(343)*y(79) +rxt(362)*y(88) +.794_r8*rxt(368)*y(89) + &
                 .900_r8*rxt(375)*y(84) +rxt(378)*y(91) +.900_r8*rxt(386)*y(96) + &
                 rxt(394)*y(100))*y(9) + (rxt(218)*y(30) +2.000_r8*rxt(275)*y(16) + &
                 rxt(297)*y(46) +.900_r8*rxt(305)*y(48) +rxt(318)*y(61) + &
                 .300_r8*rxt(327)*y(67) +.730_r8*rxt(347)*y(79) +rxt(353)*y(76) + &
                 rxt(366)*y(88) +.800_r8*rxt(381)*y(91))*y(16) &
                  + (.120_r8*rxt(293)*y(44) +.190_r8*rxt(314)*y(59) + &
                 .060_r8*rxt(336)*y(77) +.275_r8*rxt(342)*y(78) + &
                 .060_r8*rxt(360)*y(83) +rxt(392)*y(99))*y(1) + (rxt(269)*y(19) + &
                 .470_r8*rxt(345)*y(79) +rxt(363)*y(88) +.794_r8*rxt(369)*y(89) + &
                 rxt(373)*y(90) +rxt(379)*y(91))*y(11) + (rxt(254)*y(102) + &
                 rxt(259)*y(103) +rxt(209)*y(25) +rxt(212)*y(19))*y(28) &
                  + (.470_r8*rxt(348)*y(79) +rxt(367)*y(88) +rxt(382)*y(91))*y(48) &
                  + (rxt(179)*y(25) +rxt(271)*y(19))*y(2) + (rxt(163)*y(22) + &
                 rxt(291)*y(56))*y(4) + (rxt(15) +rxt(206))*y(13) &
                  + (1.340_r8*rxt(66) +.660_r8*rxt(67))*y(78) +rxt(157)*y(15)*y(3) &
                  +.700_r8*rxt(390)*y(98)*y(10) +rxt(236)*y(37)*y(19) &
                  +.794_r8*rxt(370)*y(89)*y(24) +1.200_r8*rxt(298)*y(46)*y(46) &
                  +rxt(69)*y(47) +rxt(61)*y(50) +2.000_r8*rxt(79)*y(52) &
                  +2.000_r8*rxt(82)*y(53) +rxt(292)*y(56) +rxt(71)*y(62) +rxt(62) &
                 *y(65) +rxt(78)*y(66) +rxt(74)*y(68) +.900_r8*rxt(83)*y(85) &
                  +.560_r8*rxt(81)*y(86) +rxt(76)*y(90) +rxt(77)*y(93) +rxt(86)*y(101) &
                  +rxt(280)*y(131)
         loss(74) = (rxt(179)* y(2) +rxt(174)* y(23) +rxt(209)* y(28) + rxt(22) &
                  + het_rates(25))* y(25)
         prod(74) = (.500_r8*rxt(402) +rxt(178)*y(24))*y(24) +rxt(172)*y(23)*y(23)
         loss(134) = (rxt(134)* y(3) +rxt(250)* y(135) +rxt(432)* y(149) + rxt(19) &
                  + rxt(20) + rxt(21) + het_rates(128))* y(128)
         prod(134) = (rxt(255)*y(102) +rxt(256)*y(109) +rxt(257)*y(107) + &
                 rxt(258)*y(103) +rxt(262)*y(119) +rxt(266)*y(15) +rxt(170)*y(24) + &
                 rxt(171)*y(23) +rxt(173)*y(21) +rxt(174)*y(25) +rxt(199)*y(12) + &
                 rxt(205)*y(13) +rxt(226)*y(33) +rxt(230)*y(34) +rxt(246)*y(39) + &
                 rxt(270)*y(19) +rxt(278)*y(17) +rxt(279)*y(130) +rxt(287)*y(45) + &
                 rxt(294)*y(49) +rxt(300)*y(50) +rxt(307)*y(54) +rxt(319)*y(62) + &
                 rxt(320)*y(60) +rxt(323)*y(65) +rxt(324)*y(63) +rxt(328)*y(69) + &
                 rxt(330)*y(68) +.500_r8*rxt(341)*y(78) +rxt(383)*y(92) + &
                 rxt(384)*y(92))*y(23) + (rxt(440)*y(34) +rxt(441)*y(40) + &
                 rxt(445)*y(34) +rxt(451)*y(34) +rxt(452)*y(40))*y(33) +rxt(167)*y(24) &
                 *y(22) +rxt(87)*y(150)
         loss(123) = (rxt(207)* y(1) +rxt(213)* y(15) +rxt(212)* y(19) +rxt(208) &
                 * y(21) + (rxt(210) +rxt(211))* y(24) +rxt(209)* y(25) +rxt(229) &
                 * y(34) +rxt(233)* y(35) +rxt(285)* y(45) +rxt(254)* y(102) +rxt(259) &
                 * y(103) +rxt(265)* y(118) +rxt(264)* y(119) + het_rates(28))* y(28)
         prod(123) = (2.000_r8*rxt(138)*y(104) +2.000_r8*rxt(139)*y(105) + &
                 2.000_r8*rxt(140)*y(106) +2.000_r8*rxt(141)*y(114) +rxt(142)*y(115) + &
                 rxt(143)*y(107) +rxt(144)*y(112) +rxt(145)*y(113) + &
                 4.000_r8*rxt(146)*y(108) +rxt(148)*y(111) +rxt(155)*y(133) + &
                 rxt(160)*y(33))*y(3) + (rxt(24) +rxt(214)*y(2) +rxt(215)*y(23) + &
                 rxt(218)*y(16) +rxt(219)*y(9) +2.000_r8*rxt(221)*y(30) + &
                 rxt(223)*y(30) +rxt(243)*y(38) +rxt(428)*y(148))*y(30) &
                  + (rxt(255)*y(102) +3.000_r8*rxt(256)*y(109) +rxt(257)*y(107) + &
                 rxt(260)*y(112) +rxt(261)*y(113) +rxt(226)*y(33))*y(23) + (rxt(28) + &
                 rxt(227)*y(2))*y(33) +2.000_r8*rxt(23)*y(29) +2.000_r8*rxt(26)*y(32) &
                  +rxt(27)*y(34) +rxt(29)*y(35) +rxt(31)*y(36) +rxt(56)*y(133)
         loss(29) = ( + rxt(23) + het_rates(29))* y(29)
         prod(29) = (rxt(439)*y(35) +rxt(440)*y(34) +rxt(444)*y(35) +rxt(445)*y(34) + &
                 rxt(450)*y(35) +rxt(451)*y(34))*y(33) +rxt(233)*y(35)*y(28) &
                  +rxt(222)*y(30)*y(30)
         loss(124) = (rxt(214)* y(2) +rxt(219)* y(9) +rxt(220)* y(10) +rxt(218)* y(16) &
                  + (rxt(215) +rxt(216))* y(23) +rxt(217)* y(24) + 2._r8*(rxt(221) + &
                 rxt(222) +rxt(223) +rxt(224))* y(30) + (rxt(242) +rxt(243) +rxt(244)) &
                 * y(38) +rxt(428)* y(148) + rxt(24) + het_rates(30))* y(30)
         prod(124) = (rxt(207)*y(1) +rxt(211)*y(24) +rxt(229)*y(34))*y(28) &
                  + (rxt(228)*y(34) +rxt(231)*y(35))*y(2) + (rxt(25) +rxt(430)*y(148)) &
                 *y(31) +rxt(230)*y(34)*y(23) +2.000_r8*rxt(225)*y(32) +rxt(30)*y(35)
         loss(46) = (rxt(430)* y(148) + rxt(25) + het_rates(31))* y(31)
         prod(46) = (rxt(223)*y(30) +rxt(242)*y(38))*y(30)
         loss(18) = ( + rxt(26) + rxt(225) + het_rates(32))* y(32)
         prod(18) =rxt(224)*y(30)*y(30)
         loss(117) = (rxt(227)* y(2) +rxt(160)* y(3) +rxt(226)* y(23) + (rxt(440) + &
                 rxt(445) +rxt(451))* y(34) + (rxt(439) +rxt(444) +rxt(450))* y(35) &
                  + (rxt(441) +rxt(452))* y(40) + rxt(28) + het_rates(33))* y(33)
         prod(117) = (rxt(213)*y(15) +2.000_r8*rxt(254)*y(102) +rxt(259)*y(103) + &
                 rxt(264)*y(119) +rxt(265)*y(118) +rxt(208)*y(21) +rxt(209)*y(25) + &
                 rxt(210)*y(24) +rxt(212)*y(19) +rxt(229)*y(34) +rxt(285)*y(45))*y(28) &
                  +rxt(216)*y(30)*y(23)
         loss(93) = (rxt(228)* y(2) +rxt(230)* y(23) +rxt(229)* y(28) + (rxt(440) + &
                 rxt(445) +rxt(451))* y(33) + rxt(27) + het_rates(34))* y(34)
         prod(93) = (rxt(437) +rxt(443) +rxt(448) +rxt(232)*y(23))*y(35) &
                  +rxt(217)*y(30)*y(24)
         loss(100) = (rxt(231)* y(2) +rxt(232)* y(23) +rxt(233)* y(28) + (rxt(439) + &
                 rxt(444) +rxt(450))* y(33) + rxt(29) + rxt(30) + rxt(437) + rxt(443) &
                  + rxt(448) + het_rates(35))* y(35)
         prod(100) =rxt(220)*y(30)*y(10)
         loss(33) = ( + rxt(31) + het_rates(36))* y(36)
         prod(33) = (rxt(441)*y(40) +rxt(452)*y(40))*y(33) +rxt(244)*y(38)*y(30)
         loss(118) = (rxt(234)* y(1) +rxt(236)* y(19) +rxt(235)* y(24) &
                  + het_rates(37))* y(37)
         prod(118) = (rxt(147)*y(103) +rxt(148)*y(111) +rxt(149)*y(110) + &
                 2.000_r8*rxt(150)*y(116) +2.000_r8*rxt(151)*y(117) + &
                 3.000_r8*rxt(152)*y(118) +2.000_r8*rxt(153)*y(119) +rxt(161)*y(39)) &
                 *y(3) + (rxt(32) +rxt(237)*y(2) +rxt(238)*y(23) +rxt(240)*y(9) + &
                 rxt(242)*y(30) +rxt(243)*y(30) +2.000_r8*rxt(245)*y(38) + &
                 rxt(429)*y(148))*y(38) + (rxt(258)*y(103) +2.000_r8*rxt(262)*y(119) + &
                 3.000_r8*rxt(263)*y(118) +rxt(246)*y(39))*y(23) + (rxt(259)*y(103) + &
                 2.000_r8*rxt(264)*y(119) +3.000_r8*rxt(265)*y(118))*y(28) &
                  + (rxt(34) +rxt(247)*y(2))*y(39) +rxt(31)*y(36) +rxt(33)*y(40) &
                  +rxt(35)*y(41)
         loss(122) = (rxt(237)* y(2) +rxt(240)* y(9) +rxt(241)* y(10) +rxt(238)* y(23) &
                  +rxt(239)* y(24) + (rxt(242) +rxt(243) +rxt(244))* y(30) &
                  + 2._r8*rxt(245)* y(38) +rxt(429)* y(148) + rxt(32) + het_rates(38)) &
                 * y(38)
         prod(122) = (rxt(248)*y(40) +rxt(249)*y(41))*y(2) +rxt(234)*y(37)*y(1) &
                  +rxt(36)*y(41)
         loss(90) = (rxt(247)* y(2) +rxt(161)* y(3) +rxt(246)* y(23) + rxt(34) &
                  + het_rates(39))* y(39)
         prod(90) = (rxt(235)*y(24) +rxt(236)*y(19))*y(37)
         loss(84) = (rxt(248)* y(2) + (rxt(441) +rxt(452))* y(33) + rxt(33) &
                  + het_rates(40))* y(40)
         prod(84) = (rxt(438) +rxt(446) +rxt(449))*y(41) +rxt(239)*y(38)*y(24)
         loss(70) = (rxt(249)* y(2) + rxt(35) + rxt(36) + rxt(438) + rxt(446) &
                  + rxt(449) + het_rates(41))* y(41)
         prod(70) =rxt(241)*y(38)*y(10)
         loss(78) = ((rxt(455) +rxt(456))* y(2) +rxt(463)* y(4) +rxt(467)* y(126) &
                  + het_rates(121))* y(121)
         prod(78) = 0._r8
         loss(85) = (rxt(458)* y(8) +rxt(459)* y(9) +rxt(466)* y(126) + rxt(464) &
                  + het_rates(122))* y(122)
         prod(85) = (rxt(96) +rxt(108) +rxt(453)*y(124) +rxt(460)*y(123) + &
                 rxt(463)*y(121))*y(4) +rxt(457)*y(124)*y(120)
         loss(58) = (rxt(462)* y(2) + (rxt(460) +rxt(461))* y(4) + het_rates(123)) &
                 * y(123)
         prod(58) =rxt(95)*y(8)
         loss(72) = (rxt(453)* y(4) +rxt(457)* y(120) + rxt(454) + het_rates(124)) &
                 * y(124)
         prod(72) = (rxt(92) +rxt(93) +rxt(94) +rxt(105) +rxt(106) +rxt(107) + &
                 rxt(456)*y(121) +rxt(462)*y(123))*y(2) + (rxt(98) +rxt(99) + &
                 rxt(100) +rxt(110) +rxt(111) +rxt(112))*y(4)
         loss(86) = (rxt(465)* y(126) + het_rates(125))* y(125)
         prod(86) = (rxt(464) +rxt(458)*y(8) +rxt(459)*y(9))*y(122) +rxt(455)*y(121) &
                 *y(2) +rxt(461)*y(123)*y(4) +rxt(7)*y(9) +rxt(454)*y(124)
         loss(61) = (rxt(183)* y(2) +rxt(182)* y(4) + het_rates(127))* y(127)
         prod(61) = (rxt(455)*y(2) +.900_r8*rxt(467)*y(126))*y(121) &
                  +.800_r8*rxt(465)*y(126)*y(125)
         loss(87) = (rxt(467)* y(121) +rxt(466)* y(122) +rxt(465)* y(125) &
                  + het_rates(126))* y(126)
         prod(87) = (rxt(96) +rxt(98) +rxt(99) +rxt(100) +rxt(108) +rxt(110) + &
                 rxt(111) +rxt(112))*y(4) + (rxt(92) +rxt(93) +rxt(94) +rxt(105) + &
                 rxt(106) +rxt(107))*y(2) +rxt(95)*y(8) +rxt(7)*y(9)
         loss(102) = (rxt(314)* y(1) +rxt(315)* y(11) +rxt(313)* y(23) &
                  + het_rates(59))* y(59)
         prod(102) =.070_r8*rxt(360)*y(83)*y(1) +.700_r8*rxt(68)*y(77)
         loss(94) = (rxt(360)* y(1) +rxt(361)* y(11) +rxt(359)* y(23) + het_rates(83)) &
                 * y(83)
         prod(94) = 0._r8
         loss(89) = (rxt(321)* y(9) +rxt(322)* y(24) + het_rates(64))* y(64)
         prod(89) = (rxt(313)*y(59) +.500_r8*rxt(323)*y(65))*y(23)
         loss(104) = (rxt(301)* y(11) +rxt(300)* y(23) + rxt(61) + het_rates(50)) &
                 * y(50)
         prod(104) = (rxt(295)*y(46) +.270_r8*rxt(316)*y(61) +rxt(321)*y(64) + &
                 rxt(334)*y(73) +rxt(338)*y(74) +.400_r8*rxt(375)*y(84))*y(9) &
                  + (.500_r8*rxt(314)*y(59) +.040_r8*rxt(336)*y(77))*y(1) &
                  + (.500_r8*rxt(299)*y(47) +rxt(310)*y(51))*y(23) &
                  + (.800_r8*rxt(297)*y(16) +1.600_r8*rxt(298)*y(46))*y(46) +rxt(69) &
                 *y(47) +rxt(62)*y(65) +rxt(84)*y(75) +.400_r8*rxt(83)*y(85)
         loss(75) = (rxt(294)* y(23) + het_rates(49))* y(49)
         prod(75) = (.250_r8*rxt(314)*y(59) +.200_r8*rxt(360)*y(83))*y(1) &
                  + (.250_r8*rxt(304)*y(48) +.250_r8*rxt(352)*y(76))*y(24) &
                  +.100_r8*rxt(305)*y(48)*y(16)
         loss(67) = (rxt(323)* y(23) + rxt(62) + het_rates(65))* y(65)
         prod(67) =rxt(322)*y(64)*y(24)
         loss(115) = (rxt(302)* y(9) +rxt(303)* y(10) +rxt(305)* y(16) +rxt(304) &
                 * y(24) + 2._r8*rxt(306)* y(48) +rxt(348)* y(79) +rxt(367)* y(88) &
                  +rxt(382)* y(91) + het_rates(48))* y(48)
         prod(115) = (rxt(325)*y(67) +rxt(338)*y(74) +.530_r8*rxt(343)*y(79) + &
                 rxt(350)*y(76))*y(9) + (rxt(301)*y(50) +rxt(331)*y(68) + &
                 .530_r8*rxt(345)*y(79) +rxt(351)*y(76))*y(11) &
                  + (.300_r8*rxt(327)*y(67) +.260_r8*rxt(347)*y(79) +rxt(353)*y(76)) &
                 *y(16) + (rxt(300)*y(50) +.500_r8*rxt(307)*y(54) +rxt(330)*y(68)) &
                 *y(23) + (.600_r8*rxt(64) +rxt(311))*y(58) +.530_r8*rxt(348)*y(79) &
                 *y(48) +rxt(73)*y(63) +rxt(78)*y(66) +rxt(74)*y(68) +rxt(72)*y(69) &
                  +rxt(80)*y(72) +rxt(84)*y(75) +2.000_r8*rxt(355)*y(76)*y(76) &
                  +.300_r8*rxt(68)*y(77) +1.340_r8*rxt(66)*y(78) +.130_r8*rxt(81) &
                 *y(86)
         loss(62) = (rxt(307)* y(23) + rxt(63) + het_rates(54))* y(54)
         prod(62) = (.750_r8*rxt(304)*y(48) +.750_r8*rxt(352)*y(76))*y(24)
         loss(57) = (rxt(312)* y(23) + rxt(64) + rxt(311) + het_rates(58))* y(58)
         prod(57) =rxt(303)*y(48)*y(10)
         loss(49) = (rxt(332)* y(23) + het_rates(82))* y(82)
         prod(49) =.100_r8*rxt(375)*y(84)*y(9) +rxt(315)*y(59)*y(11)
         loss(37) = (rxt(287)* y(23) +rxt(285)* y(28) + het_rates(45))* y(45)
         prod(37) = 0._r8
         loss(63) = (rxt(293)* y(1) +rxt(288)* y(23) +rxt(284)* y(28) + het_rates(44)) &
                 * y(44)
         prod(63) = 0._r8
         loss(19) = (rxt(371)* y(23) + het_rates(71))* y(71)
         prod(19) = 0._r8
         loss(71) = (rxt(358)* y(23) + rxt(65) + rxt(357) + het_rates(81))* y(81)
         prod(71) =rxt(356)*y(76)*y(10)
         loss(20) = (rxt(333)* y(23) + het_rates(70))* y(70)
         prod(20) = 0._r8
         loss(41) = (rxt(334)* y(9) + het_rates(73))* y(73)
         prod(41) =rxt(333)*y(70)*y(23)
         loss(79) = (rxt(375)* y(9) +rxt(376)* y(24) + het_rates(84))* y(84)
         prod(79) = (rxt(371)*y(71) +rxt(377)*y(85))*y(23)
         loss(76) = (rxt(377)* y(23) + rxt(83) + het_rates(85))* y(85)
         prod(76) =rxt(376)*y(84)*y(24)
         loss(55) = (rxt(337)* y(23) + rxt(80) + het_rates(72))* y(72)
         prod(55) =.800_r8*rxt(375)*y(84)*y(9) +.800_r8*rxt(83)*y(85)
         loss(77) = (rxt(338)* y(9) +rxt(339)* y(24) + het_rates(74))* y(74)
         prod(77) = (rxt(337)*y(72) +rxt(340)*y(75))*y(23)
         loss(42) = (rxt(340)* y(23) + rxt(84) + het_rates(75))* y(75)
         prod(42) =rxt(339)*y(74)*y(24)
         loss(22) = (rxt(385)* y(23) + het_rates(94))* y(94)
         prod(22) = 0._r8
         loss(23) = (rxt(389)* y(23) + het_rates(95))* y(95)
         prod(23) =.250_r8*rxt(385)*y(94)*y(23)
         loss(65) = (rxt(386)* y(9) +rxt(387)* y(24) + het_rates(96))* y(96)
         prod(65) = (.700_r8*rxt(385)*y(94) +rxt(388)*y(97))*y(23)
         loss(51) = (rxt(388)* y(23) + rxt(85) + het_rates(97))* y(97)
         prod(51) =rxt(387)*y(96)*y(24)
         loss(31) = (rxt(390)* y(10) + het_rates(98))* y(98)
         prod(31) =rxt(389)*y(95)*y(23)
         loss(98) = (rxt(394)* y(9) +rxt(395)* y(24) + het_rates(100))* y(100)
         prod(98) = (rxt(391)*y(99) +rxt(396)*y(101))*y(23) +rxt(393)*y(99)*y(11)
         loss(59) = (rxt(396)* y(23) + rxt(86) + het_rates(101))* y(101)
         prod(59) =rxt(395)*y(100)*y(24)
         loss(66) = ( + rxt(81) + het_rates(86))* y(86)
         prod(66) =.900_r8*rxt(386)*y(96)*y(9) +.700_r8*rxt(390)*y(98)*y(10) &
                  +.900_r8*rxt(85)*y(97)
         loss(81) = (rxt(309)* y(23) + rxt(82) + het_rates(53))* y(53)
         prod(81) = (.250_r8*rxt(378)*y(9) +.250_r8*rxt(379)*y(11) + &
                 .100_r8*rxt(381)*y(16) +.250_r8*rxt(382)*y(48))*y(91) &
                  + (.650_r8*rxt(286)*y(129) +.200_r8*rxt(308)*y(52))*y(23) &
                  +.450_r8*rxt(386)*y(96)*y(9) +.130_r8*rxt(81)*y(86) +.450_r8*rxt(85) &
                 *y(97)
         loss(111) = (rxt(362)* y(9) +rxt(363)* y(11) +rxt(366)* y(16) +rxt(364) &
                 * y(24) +rxt(367)* y(48) + het_rates(88))* y(88)
         prod(111) = (rxt(359)*y(83) +.200_r8*rxt(365)*y(93))*y(23)
         loss(113) = (rxt(336)* y(1) +rxt(335)* y(23) + rxt(68) + het_rates(77)) &
                 * y(77)
         prod(113) = (.320_r8*rxt(362)*y(9) +.350_r8*rxt(363)*y(11) + &
                 .260_r8*rxt(366)*y(16) +.350_r8*rxt(367)*y(48))*y(88) &
                  + (.039_r8*rxt(368)*y(9) +.039_r8*rxt(369)*y(11) + &
                 .039_r8*rxt(370)*y(24))*y(89) + (.200_r8*rxt(360)*y(83) + &
                 rxt(392)*y(99))*y(1) +rxt(394)*y(100)*y(9) +.402_r8*rxt(77)*y(93) &
                  +rxt(86)*y(101)
         loss(107) = (rxt(342)* y(1) +rxt(341)* y(23) + rxt(66) + rxt(67) &
                  + het_rates(78))* y(78)
         prod(107) = (.230_r8*rxt(362)*y(9) +.250_r8*rxt(363)*y(11) + &
                 .190_r8*rxt(366)*y(16) +.250_r8*rxt(367)*y(48))*y(88) &
                  + (.167_r8*rxt(368)*y(9) +.167_r8*rxt(369)*y(11) + &
                 .167_r8*rxt(370)*y(24))*y(89) + (.400_r8*rxt(360)*y(83) + &
                 rxt(392)*y(99))*y(1) +rxt(394)*y(100)*y(9) +.288_r8*rxt(77)*y(93) &
                  +rxt(86)*y(101)
         loss(112) = ((rxt(343) +rxt(344))* y(9) +rxt(345)* y(11) +rxt(347)* y(16) &
                  +rxt(346)* y(24) +rxt(348)* y(48) + het_rates(79))* y(79)
         prod(112) = (rxt(335)*y(77) +.500_r8*rxt(341)*y(78) +.200_r8*rxt(349)*y(80)) &
                 *y(23)
         loss(43) = (rxt(349)* y(23) + het_rates(80))* y(80)
         prod(43) =rxt(346)*y(79)*y(24)
         loss(114) = (rxt(350)* y(9) +rxt(356)* y(10) +rxt(351)* y(11) +rxt(353) &
                 * y(16) +rxt(352)* y(24) +rxt(354)* y(48) + 2._r8*rxt(355)* y(76) &
                  + het_rates(76))* y(76)
         prod(114) = (.500_r8*rxt(341)*y(78) +.500_r8*rxt(349)*y(80))*y(23) &
                  + (rxt(65) +rxt(357))*y(81) +.200_r8*rxt(360)*y(83)*y(1) &
                  +.660_r8*rxt(66)*y(78)
         loss(91) = (rxt(295)* y(9) +rxt(297)* y(16) +rxt(296)* y(24) + 2._r8*rxt(298) &
                 * y(46) + het_rates(46))* y(46)
         prod(91) = (rxt(287)*y(45) +.500_r8*rxt(299)*y(47))*y(23) +rxt(285)*y(45) &
                 *y(28) +rxt(80)*y(72)
         loss(44) = (rxt(299)* y(23) + rxt(69) + het_rates(47))* y(47)
         prod(44) =rxt(296)*y(46)*y(24)
         loss(73) = (rxt(392)* y(1) +rxt(393)* y(11) +rxt(391)* y(23) + het_rates(99)) &
                 * y(99)
         prod(73) = 0._r8
         loss(21) = (rxt(320)* y(23) + het_rates(60))* y(60)
         prod(21) = 0._r8
         loss(96) = (rxt(316)* y(9) +rxt(318)* y(16) +rxt(317)* y(24) + het_rates(61)) &
                 * y(61)
         prod(96) = (rxt(319)*y(62) +rxt(320)*y(60))*y(23)
         loss(52) = (rxt(319)* y(23) + rxt(71) + het_rates(62))* y(62)
         prod(52) =rxt(317)*y(61)*y(24)
         loss(80) = (rxt(324)* y(23) + rxt(73) + het_rates(63))* y(63)
         prod(80) = (.820_r8*rxt(316)*y(61) +.500_r8*rxt(334)*y(73) + &
                 .250_r8*rxt(375)*y(84) +.100_r8*rxt(394)*y(100))*y(9) &
                  +.820_r8*rxt(318)*y(61)*y(16) +.820_r8*rxt(71)*y(62) &
                  +.250_r8*rxt(83)*y(85) +.100_r8*rxt(86)*y(101)
         loss(53) = (rxt(328)* y(23) + rxt(72) + het_rates(69))* y(69)
         prod(53) =rxt(326)*y(67)*y(24)
         loss(68) = (rxt(277)* y(23) + het_rates(18))* y(18)
         prod(68) = (rxt(276)*y(16) +.300_r8*rxt(297)*y(46) +.500_r8*rxt(327)*y(67) + &
                 .250_r8*rxt(347)*y(79) +.250_r8*rxt(366)*y(88) + &
                 .300_r8*rxt(381)*y(91))*y(16)
         loss(35) = (rxt(310)* y(23) + het_rates(51))* y(51)
         prod(35) = (.200_r8*rxt(297)*y(16) +.400_r8*rxt(298)*y(46))*y(46)
         loss(95) = (rxt(308)* y(23) + rxt(79) + het_rates(52))* y(52)
         prod(95) = (.530_r8*rxt(343)*y(9) +.530_r8*rxt(345)*y(11) + &
                 .260_r8*rxt(347)*y(16) +.530_r8*rxt(348)*y(48))*y(79) &
                  + (.250_r8*rxt(378)*y(9) +.250_r8*rxt(379)*y(11) + &
                 .100_r8*rxt(381)*y(16) +.250_r8*rxt(382)*y(48))*y(91) +rxt(291)*y(56) &
                 *y(4)
         loss(105) = (rxt(329)* y(23) + rxt(78) + het_rates(66))* y(66)
         prod(105) = (.220_r8*rxt(343)*y(9) +.220_r8*rxt(345)*y(11) + &
                 .230_r8*rxt(347)*y(16) +.220_r8*rxt(348)*y(48))*y(79) &
                  + (.250_r8*rxt(378)*y(9) +.250_r8*rxt(379)*y(11) + &
                 .100_r8*rxt(381)*y(16) +.250_r8*rxt(382)*y(48))*y(91) &
                  + (.500_r8*rxt(323)*y(65) +.500_r8*rxt(358)*y(81))*y(23) &
                  +.200_r8*rxt(327)*y(67)*y(16)
         loss(83) = (rxt(289)* y(9) +rxt(290)* y(24) + het_rates(55))* y(55)
         prod(83) =rxt(288)*y(44)*y(23)
         loss(56) = (rxt(291)* y(4) + rxt(292) + het_rates(56))* y(56)
         prod(56) =.750_r8*rxt(289)*y(55)*y(9) +rxt(70)*y(57)
         loss(24) = ( + rxt(70) + het_rates(57))* y(57)
         prod(24) =rxt(290)*y(55)*y(24)
         loss(47) = (rxt(374)* y(23) + het_rates(87))* y(87)
         prod(47) = (.370_r8*rxt(362)*y(9) +.400_r8*rxt(363)*y(11) + &
                 .300_r8*rxt(366)*y(16) +.400_r8*rxt(367)*y(48))*y(88) &
                  + (rxt(372)*y(23) +rxt(373)*y(11))*y(90)
         loss(106) = (rxt(325)* y(9) +rxt(327)* y(16) +rxt(326)* y(24) &
                  + het_rates(67))* y(67)
         prod(106) = (rxt(324)*y(63) +rxt(328)*y(69))*y(23)
         loss(109) = (rxt(331)* y(11) +rxt(330)* y(23) + rxt(74) + het_rates(68)) &
                 * y(68)
         prod(109) = (.250_r8*rxt(343)*y(9) +.250_r8*rxt(345)*y(11) + &
                 .240_r8*rxt(347)*y(16) +.250_r8*rxt(348)*y(48))*y(79) &
                  + (.250_r8*rxt(378)*y(9) +.250_r8*rxt(379)*y(11) + &
                 .100_r8*rxt(381)*y(16) +.250_r8*rxt(382)*y(48))*y(91) &
                  + (.950_r8*rxt(336)*y(77) +.800_r8*rxt(342)*y(78))*y(1) &
                  + (rxt(329)*y(66) +rxt(332)*y(82))*y(23) +.450_r8*rxt(386)*y(96) &
                 *y(9) +.500_r8*rxt(327)*y(67)*y(16) +.180_r8*rxt(81)*y(86) &
                  +.450_r8*rxt(85)*y(97)
         loss(101) = (rxt(368)* y(9) +rxt(369)* y(11) +rxt(370)* y(24) &
                  + het_rates(89))* y(89)
         prod(101) =rxt(361)*y(83)*y(11)
         loss(97) = (rxt(373)* y(11) +rxt(372)* y(23) + rxt(76) + het_rates(90)) &
                 * y(90)
         prod(97) = (.800_r8*rxt(344)*y(79) +.080_r8*rxt(362)*y(88) + &
                 .794_r8*rxt(368)*y(89))*y(9) + (.794_r8*rxt(369)*y(11) + &
                 .794_r8*rxt(370)*y(24))*y(89)
         loss(110) = (rxt(378)* y(9) +rxt(379)* y(11) +rxt(381)* y(16) +rxt(380) &
                 * y(24) +rxt(382)* y(48) + het_rates(91))* y(91)
         prod(110) = (.800_r8*rxt(365)*y(93) +rxt(374)*y(87) +rxt(383)*y(92))*y(23)
         loss(45) = ((rxt(383) +rxt(384))* y(23) + rxt(75) + het_rates(92))* y(92)
         prod(45) = (rxt(370)*y(89) +rxt(380)*y(91))*y(24)
         loss(69) = (rxt(365)* y(23) + rxt(77) + het_rates(93))* y(93)
         prod(69) =rxt(364)*y(88)*y(24)
         loss(38) = (rxt(286)* y(23) +rxt(283)* y(28) + het_rates(129))* y(129)
         prod(38) = 0._r8
         loss(64) = (rxt(279)* y(23) + het_rates(130))* y(130)
         prod(64) = (rxt(281)*y(9) +rxt(282)*y(24))*y(131) +.500_r8*rxt(293)*y(44) &
                 *y(1) +.350_r8*rxt(286)*y(129)*y(23)
         loss(54) = (rxt(281)* y(9) +rxt(282)* y(24) + rxt(280) + het_rates(131)) &
                 * y(131)
         prod(54) =rxt(272)*y(24)*y(19)
         loss(25) = (rxt(154)* y(3) + rxt(55) + het_rates(132))* y(132)
         prod(25) = (rxt(139)*y(105) +rxt(140)*y(106) +2.000_r8*rxt(141)*y(114) + &
                 2.000_r8*rxt(142)*y(115) +rxt(143)*y(107) +rxt(145)*y(113) + &
                 rxt(148)*y(111) +rxt(149)*y(110) +rxt(150)*y(116) + &
                 2.000_r8*rxt(151)*y(117))*y(3) + (rxt(257)*y(107) +rxt(261)*y(113)) &
                 *y(23)
         loss(32) = (rxt(155)* y(3) + rxt(56) + het_rates(133))* y(133)
         prod(32) = (rxt(138)*y(104) +rxt(140)*y(106) +rxt(144)*y(112))*y(3) &
                  +rxt(260)*y(112)*y(23)
         loss(34) = ( + rxt(57) + het_rates(134))* y(134)
         prod(34) = (rxt(252)*y(15) +rxt(250)*y(128) +rxt(251)*y(21) +rxt(253)*y(12)) &
                 *y(135)
         loss(88) = (rxt(253)* y(12) +rxt(252)* y(15) +rxt(251)* y(21) +rxt(250) &
                 * y(128) + het_rates(135))* y(135)
         prod(88) = (rxt(142)*y(115) +rxt(149)*y(110) +2.000_r8*rxt(154)*y(132) + &
                 rxt(155)*y(133))*y(3) +2.000_r8*rxt(55)*y(132) +rxt(56)*y(133) &
                  +rxt(57)*y(134)
         loss(99) = (rxt(431)* y(23) + rxt(88) + het_rates(141))* y(141)
         prod(99) = (rxt(424)*y(23) +rxt(425)*y(4) +rxt(426)*y(1) +rxt(427)*y(10) + &
                 rxt(428)*y(30) +rxt(429)*y(38) +rxt(430)*y(31))*y(148) &
                  + (rxt(420)*y(146) +rxt(433)*y(142) +.500_r8*rxt(434)*y(142))*y(23) &
                  +rxt(435)*y(142)*y(11) +rxt(89)*y(149)
         loss(39) = (rxt(435)* y(11) + (rxt(433) +rxt(434))* y(23) + het_rates(142)) &
                 * y(142)
         prod(39) = 0._r8
         loss(1) = ( + rxt(407) + het_rates(143))* y(143)
         prod(1) = 0._r8
         loss(2) = ( + rxt(409) + het_rates(144))* y(144)
         prod(2) = 0._r8
         loss(3) = ( + rxt(410) + het_rates(145))* y(145)
         prod(3) = 0._r8
         loss(4) = ( + rxt(408) + het_rates(140))* y(140)
         prod(4) = 0._r8
         loss(48) = (rxt(419)* y(2) +rxt(420)* y(23) + rxt(90) + het_rates(146)) &
                 * y(146)
         prod(48) = 0._r8
         loss(82) = (rxt(423)* y(1) +rxt(422)* y(4) +rxt(421)* y(23) + het_rates(147)) &
                 * y(147)
         prod(82) =rxt(90)*y(146) +rxt(91)*y(148)
         loss(116) = (rxt(426)* y(1) +rxt(425)* y(4) +rxt(427)* y(10) +rxt(424)* y(23) &
                  +rxt(428)* y(30) +rxt(430)* y(31) +rxt(429)* y(38) + rxt(91) &
                  + het_rates(148))* y(148)
         prod(116) = (rxt(421)*y(23) +rxt(422)*y(4) +rxt(423)*y(1))*y(147) &
                  +rxt(419)*y(146)*y(2) +rxt(88)*y(141)
         loss(36) = (rxt(432)* y(128) + rxt(89) + het_rates(149))* y(149)
         prod(36) =rxt(431)*y(141)*y(23) +rxt(87)*y(150)
         loss(26) = ( + rxt(87) + het_rates(150))* y(150)
         prod(26) =rxt(432)*y(149)*y(128)
         loss(5) = ( + rxt(400) + rxt(403) + het_rates(136))* y(136)
         prod(5) = 0._r8
         loss(6) = ( + rxt(404) + het_rates(137))* y(137)
         prod(6) =rxt(400)*y(136)
         loss(7) = ( + rxt(401) + rxt(405) + het_rates(138))* y(138)
         prod(7) = 0._r8
         loss(8) = ( + rxt(406) + het_rates(139))* y(139)
         prod(8) =rxt(401)*y(138)
         loss(9) = ( + rxt(411) + het_rates(151))* y(151)
         prod(9) = 0._r8
         loss(10) = ( + rxt(412) + het_rates(152))* y(152)
         prod(10) = 0._r8
         loss(11) = ( + rxt(413) + het_rates(153))* y(153)
         prod(11) = 0._r8
         loss(12) = ( + rxt(414) + het_rates(154))* y(154)
         prod(12) = 0._r8
         loss(13) = ( + rxt(415) + het_rates(155))* y(155)
         prod(13) = 0._r8
         loss(14) = ( + rxt(416) + het_rates(156))* y(156)
         prod(14) = 0._r8
         loss(15) = ( + rxt(417) + het_rates(157))* y(157)
         prod(15) = 0._r8
         loss(16) = ( + rxt(418) + het_rates(158))* y(158)
         prod(16) = 0._r8

      end subroutine imp_prod_loss

      end module mo_prod_loss
