#include "dtypes.h"
!===================================================
! DO NOT EDIT THIS FILE, it was generated using ../../../tools/cprnc/genf90/genf90.pl 
! Any changes you make to this file may be lost
!===================================================
module shr_assert_mod

! Assert subroutines for common debugging operations.

use shr_kind_mod, only: &
     r4 => shr_kind_r4, &
     r8 => shr_kind_r8, &
     i4 => shr_kind_i4, &
     i8 => shr_kind_i8

use shr_sys_mod, only: &
     shr_sys_abort

use shr_log_mod, only: &
     shr_log_Unit

use shr_infnan_mod, only: shr_infnan_isnan

implicit none
private
save

! Assert that a logical is true.
public :: shr_assert
public :: shr_assert_all
public :: shr_assert_any

! Assert that a numerical value satisfies certain constraints.
public :: shr_assert_in_domain

# 31 "shr_assert_mod.F90.in"
interface shr_assert_all
   module procedure shr_assert
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_all_1d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_all_2d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_all_3d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_all_4d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_all_5d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_all_6d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_all_7d
end interface

# 37 "shr_assert_mod.F90.in"
interface shr_assert_any
   module procedure shr_assert
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_any_1d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_any_2d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_any_3d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_any_4d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_any_5d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_any_6d
   ! DIMS 1,2,3,4,5,6,7
   module procedure shr_assert_any_7d
end interface

# 43 "shr_assert_mod.F90.in"
interface shr_assert_in_domain
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_0d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_1d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_2d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_3d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_4d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_5d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_6d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_7d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_0d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_1d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_2d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_3d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_4d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_5d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_6d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_7d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_0d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_1d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_2d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_3d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_4d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_5d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_6d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_7d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_0d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_1d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_2d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_3d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_4d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_5d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_6d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure shr_assert_in_domain_7d_long
end interface

! Private utilities.

# 51 "shr_assert_mod.F90.in"
interface print_bad_loc
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_0d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_1d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_2d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_3d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_4d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_5d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_6d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_7d_double
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_0d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_1d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_2d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_3d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_4d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_5d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_6d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_7d_real
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_0d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_1d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_2d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_3d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_4d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_5d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_6d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_7d_int
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_0d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_1d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_2d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_3d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_4d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_5d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_6d_long
   ! TYPE double,real,int,long
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure print_bad_loc_7d_long
end interface

# 57 "shr_assert_mod.F90.in"
interface find_first_loc
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure find_first_loc_0d
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure find_first_loc_1d
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure find_first_loc_2d
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure find_first_loc_3d
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure find_first_loc_4d
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure find_first_loc_5d
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure find_first_loc_6d
   ! DIMS 0,1,2,3,4,5,6,7
   module procedure find_first_loc_7d
end interface

# 62 "shr_assert_mod.F90.in"
interface within_tolerance
   ! TYPE double,real,int,long
   module procedure within_tolerance_double
   ! TYPE double,real,int,long
   module procedure within_tolerance_real
   ! TYPE double,real,int,long
   module procedure within_tolerance_int
   ! TYPE double,real,int,long
   module procedure within_tolerance_long
end interface

# 67 "shr_assert_mod.F90.in"
contains

# 69 "shr_assert_mod.F90.in"
subroutine shr_assert(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  if (.not. var) call shr_sys_abort(msg)

# 78 "shr_assert_mod.F90.in"
end subroutine shr_assert

! DIMS 1,2,3,4,5,6,7
# 81 "shr_assert_mod.F90.in"
subroutine shr_assert_all_1d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(all(var), msg)

# 90 "shr_assert_mod.F90.in"
end subroutine shr_assert_all_1d
! DIMS 1,2,3,4,5,6,7
# 81 "shr_assert_mod.F90.in"
subroutine shr_assert_all_2d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(all(var), msg)

# 90 "shr_assert_mod.F90.in"
end subroutine shr_assert_all_2d
! DIMS 1,2,3,4,5,6,7
# 81 "shr_assert_mod.F90.in"
subroutine shr_assert_all_3d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(all(var), msg)

# 90 "shr_assert_mod.F90.in"
end subroutine shr_assert_all_3d
! DIMS 1,2,3,4,5,6,7
# 81 "shr_assert_mod.F90.in"
subroutine shr_assert_all_4d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:,:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(all(var), msg)

# 90 "shr_assert_mod.F90.in"
end subroutine shr_assert_all_4d
! DIMS 1,2,3,4,5,6,7
# 81 "shr_assert_mod.F90.in"
subroutine shr_assert_all_5d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:,:,:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(all(var), msg)

# 90 "shr_assert_mod.F90.in"
end subroutine shr_assert_all_5d
! DIMS 1,2,3,4,5,6,7
# 81 "shr_assert_mod.F90.in"
subroutine shr_assert_all_6d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:,:,:,:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(all(var), msg)

# 90 "shr_assert_mod.F90.in"
end subroutine shr_assert_all_6d
! DIMS 1,2,3,4,5,6,7
# 81 "shr_assert_mod.F90.in"
subroutine shr_assert_all_7d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:,:,:,:,:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(all(var), msg)

# 90 "shr_assert_mod.F90.in"
end subroutine shr_assert_all_7d

! DIMS 1,2,3,4,5,6,7
# 93 "shr_assert_mod.F90.in"
subroutine shr_assert_any_1d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(any(var), msg)

# 102 "shr_assert_mod.F90.in"
end subroutine shr_assert_any_1d
! DIMS 1,2,3,4,5,6,7
# 93 "shr_assert_mod.F90.in"
subroutine shr_assert_any_2d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(any(var), msg)

# 102 "shr_assert_mod.F90.in"
end subroutine shr_assert_any_2d
! DIMS 1,2,3,4,5,6,7
# 93 "shr_assert_mod.F90.in"
subroutine shr_assert_any_3d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(any(var), msg)

# 102 "shr_assert_mod.F90.in"
end subroutine shr_assert_any_3d
! DIMS 1,2,3,4,5,6,7
# 93 "shr_assert_mod.F90.in"
subroutine shr_assert_any_4d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:,:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(any(var), msg)

# 102 "shr_assert_mod.F90.in"
end subroutine shr_assert_any_4d
! DIMS 1,2,3,4,5,6,7
# 93 "shr_assert_mod.F90.in"
subroutine shr_assert_any_5d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:,:,:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(any(var), msg)

# 102 "shr_assert_mod.F90.in"
end subroutine shr_assert_any_5d
! DIMS 1,2,3,4,5,6,7
# 93 "shr_assert_mod.F90.in"
subroutine shr_assert_any_6d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:,:,:,:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(any(var), msg)

# 102 "shr_assert_mod.F90.in"
end subroutine shr_assert_any_6d
! DIMS 1,2,3,4,5,6,7
# 93 "shr_assert_mod.F90.in"
subroutine shr_assert_any_7d(var, msg)

  ! Logical being asserted.
  logical, intent(in) :: var(:,:,:,:,:,:,:)
  ! Optional error message if assert fails.
  character(len=*), intent(in) :: msg

  call shr_assert(any(var), msg)

# 102 "shr_assert_mod.F90.in"
end subroutine shr_assert_any_7d

!--------------------------------------------------------------------------
!--------------------------------------------------------------------------

! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_0d_double(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (102 == TYPEREAL) || (102 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (0 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r8), intent(in) :: var
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r8), intent(in), optional :: lt
  real(r8), intent(in), optional :: gt
  real(r8), intent(in), optional :: le
  real(r8), intent(in), optional :: ge
  real(r8), intent(in), optional :: eq
  real(r8), intent(in), optional :: ne
  real(r8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(0)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,0)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_0d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_1d_double(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (102 == TYPEREAL) || (102 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (1 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r8), intent(in) :: var(:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r8), intent(in), optional :: lt
  real(r8), intent(in), optional :: gt
  real(r8), intent(in), optional :: le
  real(r8), intent(in), optional :: ge
  real(r8), intent(in), optional :: eq
  real(r8), intent(in), optional :: ne
  real(r8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(1)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,1)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_1d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_2d_double(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (102 == TYPEREAL) || (102 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (2 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r8), intent(in) :: var(:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r8), intent(in), optional :: lt
  real(r8), intent(in), optional :: gt
  real(r8), intent(in), optional :: le
  real(r8), intent(in), optional :: ge
  real(r8), intent(in), optional :: eq
  real(r8), intent(in), optional :: ne
  real(r8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(2)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,2)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_2d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_3d_double(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (102 == TYPEREAL) || (102 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (3 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r8), intent(in) :: var(:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r8), intent(in), optional :: lt
  real(r8), intent(in), optional :: gt
  real(r8), intent(in), optional :: le
  real(r8), intent(in), optional :: ge
  real(r8), intent(in), optional :: eq
  real(r8), intent(in), optional :: ne
  real(r8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(3)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,3)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_3d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_4d_double(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (102 == TYPEREAL) || (102 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (4 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r8), intent(in) :: var(:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r8), intent(in), optional :: lt
  real(r8), intent(in), optional :: gt
  real(r8), intent(in), optional :: le
  real(r8), intent(in), optional :: ge
  real(r8), intent(in), optional :: eq
  real(r8), intent(in), optional :: ne
  real(r8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(4)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,4)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_4d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_5d_double(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (102 == TYPEREAL) || (102 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (5 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r8), intent(in) :: var(:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r8), intent(in), optional :: lt
  real(r8), intent(in), optional :: gt
  real(r8), intent(in), optional :: le
  real(r8), intent(in), optional :: ge
  real(r8), intent(in), optional :: eq
  real(r8), intent(in), optional :: ne
  real(r8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(5)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,5)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_5d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_6d_double(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (102 == TYPEREAL) || (102 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (6 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r8), intent(in) :: var(:,:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r8), intent(in), optional :: lt
  real(r8), intent(in), optional :: gt
  real(r8), intent(in), optional :: le
  real(r8), intent(in), optional :: ge
  real(r8), intent(in), optional :: eq
  real(r8), intent(in), optional :: ne
  real(r8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(6)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,6)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_6d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_7d_double(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (102 == TYPEREAL) || (102 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (7 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r8), intent(in) :: var(:,:,:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r8), intent(in), optional :: lt
  real(r8), intent(in), optional :: gt
  real(r8), intent(in), optional :: le
  real(r8), intent(in), optional :: ge
  real(r8), intent(in), optional :: eq
  real(r8), intent(in), optional :: ne
  real(r8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(7)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,7)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_7d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_0d_real(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (101 == TYPEREAL) || (101 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (0 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r4), intent(in) :: var
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r4), intent(in), optional :: lt
  real(r4), intent(in), optional :: gt
  real(r4), intent(in), optional :: le
  real(r4), intent(in), optional :: ge
  real(r4), intent(in), optional :: eq
  real(r4), intent(in), optional :: ne
  real(r4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(0)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,0)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_0d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_1d_real(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (101 == TYPEREAL) || (101 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (1 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r4), intent(in) :: var(:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r4), intent(in), optional :: lt
  real(r4), intent(in), optional :: gt
  real(r4), intent(in), optional :: le
  real(r4), intent(in), optional :: ge
  real(r4), intent(in), optional :: eq
  real(r4), intent(in), optional :: ne
  real(r4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(1)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,1)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_1d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_2d_real(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (101 == TYPEREAL) || (101 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (2 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r4), intent(in) :: var(:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r4), intent(in), optional :: lt
  real(r4), intent(in), optional :: gt
  real(r4), intent(in), optional :: le
  real(r4), intent(in), optional :: ge
  real(r4), intent(in), optional :: eq
  real(r4), intent(in), optional :: ne
  real(r4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(2)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,2)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_2d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_3d_real(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (101 == TYPEREAL) || (101 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (3 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r4), intent(in) :: var(:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r4), intent(in), optional :: lt
  real(r4), intent(in), optional :: gt
  real(r4), intent(in), optional :: le
  real(r4), intent(in), optional :: ge
  real(r4), intent(in), optional :: eq
  real(r4), intent(in), optional :: ne
  real(r4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(3)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,3)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_3d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_4d_real(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (101 == TYPEREAL) || (101 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (4 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r4), intent(in) :: var(:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r4), intent(in), optional :: lt
  real(r4), intent(in), optional :: gt
  real(r4), intent(in), optional :: le
  real(r4), intent(in), optional :: ge
  real(r4), intent(in), optional :: eq
  real(r4), intent(in), optional :: ne
  real(r4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(4)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,4)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_4d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_5d_real(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (101 == TYPEREAL) || (101 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (5 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r4), intent(in) :: var(:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r4), intent(in), optional :: lt
  real(r4), intent(in), optional :: gt
  real(r4), intent(in), optional :: le
  real(r4), intent(in), optional :: ge
  real(r4), intent(in), optional :: eq
  real(r4), intent(in), optional :: ne
  real(r4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(5)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,5)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_5d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_6d_real(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (101 == TYPEREAL) || (101 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (6 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r4), intent(in) :: var(:,:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r4), intent(in), optional :: lt
  real(r4), intent(in), optional :: gt
  real(r4), intent(in), optional :: le
  real(r4), intent(in), optional :: ge
  real(r4), intent(in), optional :: eq
  real(r4), intent(in), optional :: ne
  real(r4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(6)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,6)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_6d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_7d_real(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (101 == TYPEREAL) || (101 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (7 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  real(r4), intent(in) :: var(:,:,:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  real(r4), intent(in), optional :: lt
  real(r4), intent(in), optional :: gt
  real(r4), intent(in), optional :: le
  real(r4), intent(in), optional :: ge
  real(r4), intent(in), optional :: eq
  real(r4), intent(in), optional :: ne
  real(r4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(7)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  real(r4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,7)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_7d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_0d_int(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (103 == TYPEREAL) || (103 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (0 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i4), intent(in) :: var
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i4), intent(in), optional :: lt
  integer(i4), intent(in), optional :: gt
  integer(i4), intent(in), optional :: le
  integer(i4), intent(in), optional :: ge
  integer(i4), intent(in), optional :: eq
  integer(i4), intent(in), optional :: ne
  integer(i4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(0)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,0)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_0d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_1d_int(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (103 == TYPEREAL) || (103 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (1 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i4), intent(in) :: var(:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i4), intent(in), optional :: lt
  integer(i4), intent(in), optional :: gt
  integer(i4), intent(in), optional :: le
  integer(i4), intent(in), optional :: ge
  integer(i4), intent(in), optional :: eq
  integer(i4), intent(in), optional :: ne
  integer(i4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(1)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,1)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_1d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_2d_int(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (103 == TYPEREAL) || (103 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (2 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i4), intent(in) :: var(:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i4), intent(in), optional :: lt
  integer(i4), intent(in), optional :: gt
  integer(i4), intent(in), optional :: le
  integer(i4), intent(in), optional :: ge
  integer(i4), intent(in), optional :: eq
  integer(i4), intent(in), optional :: ne
  integer(i4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(2)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,2)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_2d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_3d_int(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (103 == TYPEREAL) || (103 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (3 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i4), intent(in) :: var(:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i4), intent(in), optional :: lt
  integer(i4), intent(in), optional :: gt
  integer(i4), intent(in), optional :: le
  integer(i4), intent(in), optional :: ge
  integer(i4), intent(in), optional :: eq
  integer(i4), intent(in), optional :: ne
  integer(i4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(3)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,3)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_3d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_4d_int(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (103 == TYPEREAL) || (103 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (4 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i4), intent(in) :: var(:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i4), intent(in), optional :: lt
  integer(i4), intent(in), optional :: gt
  integer(i4), intent(in), optional :: le
  integer(i4), intent(in), optional :: ge
  integer(i4), intent(in), optional :: eq
  integer(i4), intent(in), optional :: ne
  integer(i4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(4)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,4)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_4d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_5d_int(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (103 == TYPEREAL) || (103 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (5 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i4), intent(in) :: var(:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i4), intent(in), optional :: lt
  integer(i4), intent(in), optional :: gt
  integer(i4), intent(in), optional :: le
  integer(i4), intent(in), optional :: ge
  integer(i4), intent(in), optional :: eq
  integer(i4), intent(in), optional :: ne
  integer(i4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(5)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,5)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_5d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_6d_int(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (103 == TYPEREAL) || (103 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (6 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i4), intent(in) :: var(:,:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i4), intent(in), optional :: lt
  integer(i4), intent(in), optional :: gt
  integer(i4), intent(in), optional :: le
  integer(i4), intent(in), optional :: ge
  integer(i4), intent(in), optional :: eq
  integer(i4), intent(in), optional :: ne
  integer(i4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(6)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,6)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_6d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_7d_int(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (103 == TYPEREAL) || (103 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (7 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i4), intent(in) :: var(:,:,:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i4), intent(in), optional :: lt
  integer(i4), intent(in), optional :: gt
  integer(i4), intent(in), optional :: le
  integer(i4), intent(in), optional :: ge
  integer(i4), intent(in), optional :: eq
  integer(i4), intent(in), optional :: ne
  integer(i4), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(7)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i4) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,7)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_7d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_0d_long(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (104 == TYPEREAL) || (104 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (0 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i8), intent(in) :: var
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i8), intent(in), optional :: lt
  integer(i8), intent(in), optional :: gt
  integer(i8), intent(in), optional :: le
  integer(i8), intent(in), optional :: ge
  integer(i8), intent(in), optional :: eq
  integer(i8), intent(in), optional :: ne
  integer(i8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(0)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,0)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_0d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_1d_long(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (104 == TYPEREAL) || (104 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (1 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i8), intent(in) :: var(:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i8), intent(in), optional :: lt
  integer(i8), intent(in), optional :: gt
  integer(i8), intent(in), optional :: le
  integer(i8), intent(in), optional :: ge
  integer(i8), intent(in), optional :: eq
  integer(i8), intent(in), optional :: ne
  integer(i8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(1)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,1)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_1d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_2d_long(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (104 == TYPEREAL) || (104 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (2 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i8), intent(in) :: var(:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i8), intent(in), optional :: lt
  integer(i8), intent(in), optional :: gt
  integer(i8), intent(in), optional :: le
  integer(i8), intent(in), optional :: ge
  integer(i8), intent(in), optional :: eq
  integer(i8), intent(in), optional :: ne
  integer(i8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(2)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,2)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_2d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_3d_long(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (104 == TYPEREAL) || (104 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (3 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i8), intent(in) :: var(:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i8), intent(in), optional :: lt
  integer(i8), intent(in), optional :: gt
  integer(i8), intent(in), optional :: le
  integer(i8), intent(in), optional :: ge
  integer(i8), intent(in), optional :: eq
  integer(i8), intent(in), optional :: ne
  integer(i8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(3)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,3)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_3d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_4d_long(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (104 == TYPEREAL) || (104 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (4 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i8), intent(in) :: var(:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i8), intent(in), optional :: lt
  integer(i8), intent(in), optional :: gt
  integer(i8), intent(in), optional :: le
  integer(i8), intent(in), optional :: ge
  integer(i8), intent(in), optional :: eq
  integer(i8), intent(in), optional :: ne
  integer(i8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(4)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,4)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_4d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_5d_long(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (104 == TYPEREAL) || (104 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (5 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i8), intent(in) :: var(:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i8), intent(in), optional :: lt
  integer(i8), intent(in), optional :: gt
  integer(i8), intent(in), optional :: le
  integer(i8), intent(in), optional :: ge
  integer(i8), intent(in), optional :: eq
  integer(i8), intent(in), optional :: ne
  integer(i8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(5)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,5)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_5d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_6d_long(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (104 == TYPEREAL) || (104 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (6 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i8), intent(in) :: var(:,:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i8), intent(in), optional :: lt
  integer(i8), intent(in), optional :: gt
  integer(i8), intent(in), optional :: le
  integer(i8), intent(in), optional :: ge
  integer(i8), intent(in), optional :: eq
  integer(i8), intent(in), optional :: ne
  integer(i8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(6)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,6)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_6d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 109 "shr_assert_mod.F90.in"
subroutine shr_assert_in_domain_7d_long(var, varname, msg, &
     is_nan, lt, gt, le, ge, eq, ne, abs_tol)

!-----------------------------
! BEGIN defining local macros
!-----------------------------

! Flag for floating point types.

#if (104 == TYPEREAL) || (104 == TYPEDOUBLE)
#define TYPEFP
#else
#undef TYPEFP
#endif

! "Generalized" macro functions allow transformational intrinsic functions
! to handle both scalars and arrays.

#if (7 != 0)
! When given an array, use the intrinsics.
#define GEN_SIZE(x) size(x)
#define GEN_ALL(x) all(x)
#else

! Scalar extensions:
!   GEN_SIZE always returns 1 for a scalar.
!   GEN_ALL (logical reduction) is a no-op for a scalar.
!   GEN_[MAX,MIN]LOC should return a 1D, size 0 (empty), integer array.
#define GEN_SIZE(x) 1
#define GEN_ALL(x) x

#endif

!-----------------------------
! END macro section
!-----------------------------

  ! Variable being checked.
  integer(i8), intent(in) :: var(:,:,:,:,:,:,:)
  ! Variable name to be used in error messages.
  character(len=*), intent(in), optional :: varname
  ! Optional error message if assert fails.
  character(len=*), intent(in), optional :: msg
  ! Assert that the variable is not (or is) NaN.
  logical, intent(in), optional :: is_nan
  ! Limits for (in)equalities.
  integer(i8), intent(in), optional :: lt
  integer(i8), intent(in), optional :: gt
  integer(i8), intent(in), optional :: le
  integer(i8), intent(in), optional :: ge
  integer(i8), intent(in), optional :: eq
  integer(i8), intent(in), optional :: ne
  integer(i8), intent(in), optional :: abs_tol

  ! Note that the following array is size 0 for scalars.
  integer :: loc_vec(7)

  logical :: is_nan_passed
  logical :: lt_passed
  logical :: gt_passed
  logical :: le_passed
  logical :: ge_passed
  logical :: eq_passed
  logical :: ne_passed

  integer(i8) :: abs_tol_loc

  ! Handling of abs_tol makes a couple of fairly safe assumptions.
  !  1. It is not the most negative integer.
  !  2. It is finite (not a floating point infinity or NaN).
  if (present(abs_tol)) then
     abs_tol_loc = abs(abs_tol)
  else
     abs_tol_loc = 0_i4
  end if

  is_nan_passed = .true.
  lt_passed = .true.
  gt_passed = .true.
  le_passed = .true.
  ge_passed = .true.
  eq_passed = .true.
  ne_passed = .true.

  ! Do one pass just to find out if we can return with no problem.

#ifdef TYPEFP
  ! Only floating-point values can actually be Inf/NaN.
  if (present(is_nan)) &
     is_nan_passed = GEN_ALL(shr_infnan_isnan(var) .eqv. is_nan)
#else
  if (present(is_nan)) &
     is_nan_passed = .not. is_nan .or. GEN_SIZE(var) == 0
#endif

  if (present(lt)) &
     lt_passed = GEN_ALL(var < lt)

  if (present(gt)) &
     gt_passed = GEN_ALL(var > gt)

  if (present(le)) &
     le_passed = GEN_ALL(var <= le)

  if (present(ge)) &
     ge_passed = GEN_ALL(var >= ge)

  if (present(eq)) then
     eq_passed = GEN_ALL(within_tolerance(eq, var, abs_tol_loc))
  end if

  if (present(ne)) then
     ne_passed = GEN_ALL(.not. within_tolerance(ne, var, abs_tol_loc))
  end if

  if ( is_nan_passed .and. &
       lt_passed .and. &
       gt_passed .and. &
       le_passed .and. &
       ge_passed .and. &
       eq_passed .and. &
       ne_passed) &
       return

  ! If we got here, assert will fail, so find out where so that we
  ! can try to print something useful.

  if (.not. is_nan_passed) then
#ifdef TYPEFP
     loc_vec = find_first_loc(shr_infnan_isnan(var) .neqv. is_nan)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) "Expected value to be NaN."
     else
        write(shr_log_Unit,*) "Expected value to be a number."
     end if
#else
     loc_vec = spread(1,1,7)
     call print_bad_loc(var, loc_vec, varname)
     if (is_nan) then
        write(shr_log_Unit,*) &
             "Asserted NaN, but the variable is not floating-point!"
     end if
#endif
  end if

  if (.not. lt_passed) then
     loc_vec = find_first_loc(var >= lt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than ",lt
  end if

  if (.not. gt_passed) then
     loc_vec = find_first_loc(var <= gt)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than ",gt
  end if

  if (.not. le_passed) then
     loc_vec = find_first_loc(var > le)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be less than or &
          &equal to ",le
  end if

  if (.not. ge_passed) then
     loc_vec = find_first_loc(var < ge)
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be greater than or &
          &equal to ",ge
  end if

  if (.not. eq_passed) then
     loc_vec = find_first_loc(.not. within_tolerance(eq, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to be equal to ",eq
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  if (.not. ne_passed) then
     loc_vec = find_first_loc(within_tolerance(ne, var, abs_tol_loc))
     call print_bad_loc(var, loc_vec, varname)
     write(shr_log_Unit,*) "Expected value to never be equal to ",ne
     if (abs_tol_loc > 0) &
          write(shr_log_Unit,*) "Asserted with tolerance ", abs_tol_loc
  end if

  call shr_sys_abort(msg)

! Undefine local macros.
#undef TYPEFP
#undef GEN_SIZE
#undef GEN_ALL

# 304 "shr_assert_mod.F90.in"
end subroutine shr_assert_in_domain_7d_long

!--------------------------------------------------------------------------
!--------------------------------------------------------------------------

! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_0d_double(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r8), intent(in) :: var
  integer, intent(in) :: loc_vec(0)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (0 != 0)
       var(), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_0d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_1d_double(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r8), intent(in) :: var(:)
  integer, intent(in) :: loc_vec(1)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (1 != 0)
       var(loc_vec(1)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_1d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_2d_double(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r8), intent(in) :: var(:,:)
  integer, intent(in) :: loc_vec(2)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (2 != 0)
       var(loc_vec(1),&
loc_vec(2)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_2d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_3d_double(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r8), intent(in) :: var(:,:,:)
  integer, intent(in) :: loc_vec(3)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (3 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_3d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_4d_double(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r8), intent(in) :: var(:,:,:,:)
  integer, intent(in) :: loc_vec(4)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (4 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_4d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_5d_double(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r8), intent(in) :: var(:,:,:,:,:)
  integer, intent(in) :: loc_vec(5)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (5 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_5d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_6d_double(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r8), intent(in) :: var(:,:,:,:,:,:)
  integer, intent(in) :: loc_vec(6)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (6 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5),&
loc_vec(6)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_6d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_7d_double(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r8), intent(in) :: var(:,:,:,:,:,:,:)
  integer, intent(in) :: loc_vec(7)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (7 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5),&
loc_vec(6),&
loc_vec(7)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_7d_double
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_0d_real(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r4), intent(in) :: var
  integer, intent(in) :: loc_vec(0)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (0 != 0)
       var(), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_0d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_1d_real(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r4), intent(in) :: var(:)
  integer, intent(in) :: loc_vec(1)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (1 != 0)
       var(loc_vec(1)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_1d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_2d_real(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r4), intent(in) :: var(:,:)
  integer, intent(in) :: loc_vec(2)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (2 != 0)
       var(loc_vec(1),&
loc_vec(2)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_2d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_3d_real(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r4), intent(in) :: var(:,:,:)
  integer, intent(in) :: loc_vec(3)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (3 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_3d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_4d_real(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r4), intent(in) :: var(:,:,:,:)
  integer, intent(in) :: loc_vec(4)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (4 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_4d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_5d_real(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r4), intent(in) :: var(:,:,:,:,:)
  integer, intent(in) :: loc_vec(5)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (5 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_5d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_6d_real(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r4), intent(in) :: var(:,:,:,:,:,:)
  integer, intent(in) :: loc_vec(6)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (6 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5),&
loc_vec(6)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_6d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_7d_real(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  real(r4), intent(in) :: var(:,:,:,:,:,:,:)
  integer, intent(in) :: loc_vec(7)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (7 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5),&
loc_vec(6),&
loc_vec(7)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_7d_real
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_0d_int(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i4), intent(in) :: var
  integer, intent(in) :: loc_vec(0)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (0 != 0)
       var(), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_0d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_1d_int(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i4), intent(in) :: var(:)
  integer, intent(in) :: loc_vec(1)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (1 != 0)
       var(loc_vec(1)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_1d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_2d_int(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i4), intent(in) :: var(:,:)
  integer, intent(in) :: loc_vec(2)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (2 != 0)
       var(loc_vec(1),&
loc_vec(2)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_2d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_3d_int(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i4), intent(in) :: var(:,:,:)
  integer, intent(in) :: loc_vec(3)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (3 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_3d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_4d_int(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i4), intent(in) :: var(:,:,:,:)
  integer, intent(in) :: loc_vec(4)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (4 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_4d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_5d_int(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i4), intent(in) :: var(:,:,:,:,:)
  integer, intent(in) :: loc_vec(5)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (5 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_5d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_6d_int(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i4), intent(in) :: var(:,:,:,:,:,:)
  integer, intent(in) :: loc_vec(6)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (6 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5),&
loc_vec(6)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_6d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_7d_int(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i4), intent(in) :: var(:,:,:,:,:,:,:)
  integer, intent(in) :: loc_vec(7)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (7 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5),&
loc_vec(6),&
loc_vec(7)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_7d_int
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_0d_long(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i8), intent(in) :: var
  integer, intent(in) :: loc_vec(0)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (0 != 0)
       var(), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_0d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_1d_long(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i8), intent(in) :: var(:)
  integer, intent(in) :: loc_vec(1)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (1 != 0)
       var(loc_vec(1)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_1d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_2d_long(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i8), intent(in) :: var(:,:)
  integer, intent(in) :: loc_vec(2)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (2 != 0)
       var(loc_vec(1),&
loc_vec(2)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_2d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_3d_long(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i8), intent(in) :: var(:,:,:)
  integer, intent(in) :: loc_vec(3)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (3 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_3d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_4d_long(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i8), intent(in) :: var(:,:,:,:)
  integer, intent(in) :: loc_vec(4)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (4 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_4d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_5d_long(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i8), intent(in) :: var(:,:,:,:,:)
  integer, intent(in) :: loc_vec(5)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (5 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_5d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_6d_long(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i8), intent(in) :: var(:,:,:,:,:,:)
  integer, intent(in) :: loc_vec(6)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (6 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5),&
loc_vec(6)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_6d_long
! TYPE double,real,int,long
! DIMS 0,1,2,3,4,5,6,7
# 311 "shr_assert_mod.F90.in"
subroutine print_bad_loc_7d_long(var, loc_vec, varname)
  ! Print information about a bad location in an variable.
  ! For scalars, just print value.

  integer(i8), intent(in) :: var(:,:,:,:,:,:,:)
  integer, intent(in) :: loc_vec(7)

  character(len=*), intent(in), optional :: varname

  character(len=:), allocatable :: varname_to_write

  if (present(varname)) then
     allocate(varname_to_write, source=varname)
  else
     allocate(varname_to_write, source="input variable")
  end if

  write(shr_log_Unit,*) &
       "ERROR: shr_assert_in_domain: ",trim(varname_to_write), &
       " has invalid value ", &
#if (7 != 0)
       var(loc_vec(1),&
loc_vec(2),&
loc_vec(3),&
loc_vec(4),&
loc_vec(5),&
loc_vec(6),&
loc_vec(7)), &
       " at location: ",loc_vec
#else
       var

  ! Kill compiler spam for unused loc_vec.
  if (.false.) write(*,*) loc_vec
#endif

# 341 "shr_assert_mod.F90.in"
end subroutine print_bad_loc_7d_long

!--------------------------------------------------------------------------
!--------------------------------------------------------------------------

! DIMS 0,1,2,3,4,5,6,7
# 347 "shr_assert_mod.F90.in"
pure function find_first_loc_0d(mask) result (loc_vec)
  ! Inefficient but simple subroutine for finding the location of
  ! the first .true. value in an array.
  ! If no true values, returns first value.

  logical, intent(in) :: mask
  integer :: loc_vec(0)

#if (0 != 0)
  integer :: flags()

  where (mask)
     flags = 1
  elsewhere
     flags = 0
  end where

  loc_vec = maxloc(flags)
#else

! Remove compiler warnings (statement will be optimized out).

#if (! defined CPRPGI && ! defined CPRCRAY)
  if (.false. .and. mask) loc_vec = loc_vec
#endif

#endif

# 375 "shr_assert_mod.F90.in"
end function find_first_loc_0d
! DIMS 0,1,2,3,4,5,6,7
# 347 "shr_assert_mod.F90.in"
pure function find_first_loc_1d(mask) result (loc_vec)
  ! Inefficient but simple subroutine for finding the location of
  ! the first .true. value in an array.
  ! If no true values, returns first value.

  logical, intent(in) :: mask(:)
  integer :: loc_vec(1)

#if (1 != 0)
  integer :: flags(size(mask,1))

  where (mask)
     flags = 1
  elsewhere
     flags = 0
  end where

  loc_vec = maxloc(flags)
#else

! Remove compiler warnings (statement will be optimized out).

#if (! defined CPRPGI && ! defined CPRCRAY)
  if (.false. .and. mask) loc_vec = loc_vec
#endif

#endif

# 375 "shr_assert_mod.F90.in"
end function find_first_loc_1d
! DIMS 0,1,2,3,4,5,6,7
# 347 "shr_assert_mod.F90.in"
pure function find_first_loc_2d(mask) result (loc_vec)
  ! Inefficient but simple subroutine for finding the location of
  ! the first .true. value in an array.
  ! If no true values, returns first value.

  logical, intent(in) :: mask(:,:)
  integer :: loc_vec(2)

#if (2 != 0)
  integer :: flags(size(mask,1),&
size(mask,2))

  where (mask)
     flags = 1
  elsewhere
     flags = 0
  end where

  loc_vec = maxloc(flags)
#else

! Remove compiler warnings (statement will be optimized out).

#if (! defined CPRPGI && ! defined CPRCRAY)
  if (.false. .and. mask) loc_vec = loc_vec
#endif

#endif

# 375 "shr_assert_mod.F90.in"
end function find_first_loc_2d
! DIMS 0,1,2,3,4,5,6,7
# 347 "shr_assert_mod.F90.in"
pure function find_first_loc_3d(mask) result (loc_vec)
  ! Inefficient but simple subroutine for finding the location of
  ! the first .true. value in an array.
  ! If no true values, returns first value.

  logical, intent(in) :: mask(:,:,:)
  integer :: loc_vec(3)

#if (3 != 0)
  integer :: flags(size(mask,1),&
size(mask,2),&
size(mask,3))

  where (mask)
     flags = 1
  elsewhere
     flags = 0
  end where

  loc_vec = maxloc(flags)
#else

! Remove compiler warnings (statement will be optimized out).

#if (! defined CPRPGI && ! defined CPRCRAY)
  if (.false. .and. mask) loc_vec = loc_vec
#endif

#endif

# 375 "shr_assert_mod.F90.in"
end function find_first_loc_3d
! DIMS 0,1,2,3,4,5,6,7
# 347 "shr_assert_mod.F90.in"
pure function find_first_loc_4d(mask) result (loc_vec)
  ! Inefficient but simple subroutine for finding the location of
  ! the first .true. value in an array.
  ! If no true values, returns first value.

  logical, intent(in) :: mask(:,:,:,:)
  integer :: loc_vec(4)

#if (4 != 0)
  integer :: flags(size(mask,1),&
size(mask,2),&
size(mask,3),&
size(mask,4))

  where (mask)
     flags = 1
  elsewhere
     flags = 0
  end where

  loc_vec = maxloc(flags)
#else

! Remove compiler warnings (statement will be optimized out).

#if (! defined CPRPGI && ! defined CPRCRAY)
  if (.false. .and. mask) loc_vec = loc_vec
#endif

#endif

# 375 "shr_assert_mod.F90.in"
end function find_first_loc_4d
! DIMS 0,1,2,3,4,5,6,7
# 347 "shr_assert_mod.F90.in"
pure function find_first_loc_5d(mask) result (loc_vec)
  ! Inefficient but simple subroutine for finding the location of
  ! the first .true. value in an array.
  ! If no true values, returns first value.

  logical, intent(in) :: mask(:,:,:,:,:)
  integer :: loc_vec(5)

#if (5 != 0)
  integer :: flags(size(mask,1),&
size(mask,2),&
size(mask,3),&
size(mask,4),&
size(mask,5))

  where (mask)
     flags = 1
  elsewhere
     flags = 0
  end where

  loc_vec = maxloc(flags)
#else

! Remove compiler warnings (statement will be optimized out).

#if (! defined CPRPGI && ! defined CPRCRAY)
  if (.false. .and. mask) loc_vec = loc_vec
#endif

#endif

# 375 "shr_assert_mod.F90.in"
end function find_first_loc_5d
! DIMS 0,1,2,3,4,5,6,7
# 347 "shr_assert_mod.F90.in"
pure function find_first_loc_6d(mask) result (loc_vec)
  ! Inefficient but simple subroutine for finding the location of
  ! the first .true. value in an array.
  ! If no true values, returns first value.

  logical, intent(in) :: mask(:,:,:,:,:,:)
  integer :: loc_vec(6)

#if (6 != 0)
  integer :: flags(size(mask,1),&
size(mask,2),&
size(mask,3),&
size(mask,4),&
size(mask,5),&
size(mask,6))

  where (mask)
     flags = 1
  elsewhere
     flags = 0
  end where

  loc_vec = maxloc(flags)
#else

! Remove compiler warnings (statement will be optimized out).

#if (! defined CPRPGI && ! defined CPRCRAY)
  if (.false. .and. mask) loc_vec = loc_vec
#endif

#endif

# 375 "shr_assert_mod.F90.in"
end function find_first_loc_6d
! DIMS 0,1,2,3,4,5,6,7
# 347 "shr_assert_mod.F90.in"
pure function find_first_loc_7d(mask) result (loc_vec)
  ! Inefficient but simple subroutine for finding the location of
  ! the first .true. value in an array.
  ! If no true values, returns first value.

  logical, intent(in) :: mask(:,:,:,:,:,:,:)
  integer :: loc_vec(7)

#if (7 != 0)
  integer :: flags(size(mask,1),&
size(mask,2),&
size(mask,3),&
size(mask,4),&
size(mask,5),&
size(mask,6),&
size(mask,7))

  where (mask)
     flags = 1
  elsewhere
     flags = 0
  end where

  loc_vec = maxloc(flags)
#else

! Remove compiler warnings (statement will be optimized out).

#if (! defined CPRPGI && ! defined CPRCRAY)
  if (.false. .and. mask) loc_vec = loc_vec
#endif

#endif

# 375 "shr_assert_mod.F90.in"
end function find_first_loc_7d

! TYPE double,real,int,long
# 378 "shr_assert_mod.F90.in"
elemental function within_tolerance_double(expected, actual, tolerance) &
     result(is_in_tol)
  ! Precondition: tolerance must be >= 0.
  real(r8), intent(in) :: expected
  real(r8), intent(in) :: actual
  real(r8), intent(in) :: tolerance
  logical :: is_in_tol

  ! The following conditionals are to ensure that we don't overflow.

  ! This takes care of two identical infinities.
  if (actual == expected) then
     is_in_tol = .true.
  else if (actual > expected) then
     if (expected >= 0) then
        is_in_tol = (actual - expected) <= tolerance
     else
        is_in_tol = actual <= (expected + tolerance)
     end if
  else
     if (expected < 0) then
        is_in_tol = (expected - actual) <= tolerance
     else
        is_in_tol = actual >= (expected - tolerance)
     end if
  end if

# 405 "shr_assert_mod.F90.in"
end function within_tolerance_double
! TYPE double,real,int,long
# 378 "shr_assert_mod.F90.in"
elemental function within_tolerance_real(expected, actual, tolerance) &
     result(is_in_tol)
  ! Precondition: tolerance must be >= 0.
  real(r4), intent(in) :: expected
  real(r4), intent(in) :: actual
  real(r4), intent(in) :: tolerance
  logical :: is_in_tol

  ! The following conditionals are to ensure that we don't overflow.

  ! This takes care of two identical infinities.
  if (actual == expected) then
     is_in_tol = .true.
  else if (actual > expected) then
     if (expected >= 0) then
        is_in_tol = (actual - expected) <= tolerance
     else
        is_in_tol = actual <= (expected + tolerance)
     end if
  else
     if (expected < 0) then
        is_in_tol = (expected - actual) <= tolerance
     else
        is_in_tol = actual >= (expected - tolerance)
     end if
  end if

# 405 "shr_assert_mod.F90.in"
end function within_tolerance_real
! TYPE double,real,int,long
# 378 "shr_assert_mod.F90.in"
elemental function within_tolerance_int(expected, actual, tolerance) &
     result(is_in_tol)
  ! Precondition: tolerance must be >= 0.
  integer(i4), intent(in) :: expected
  integer(i4), intent(in) :: actual
  integer(i4), intent(in) :: tolerance
  logical :: is_in_tol

  ! The following conditionals are to ensure that we don't overflow.

  ! This takes care of two identical infinities.
  if (actual == expected) then
     is_in_tol = .true.
  else if (actual > expected) then
     if (expected >= 0) then
        is_in_tol = (actual - expected) <= tolerance
     else
        is_in_tol = actual <= (expected + tolerance)
     end if
  else
     if (expected < 0) then
        is_in_tol = (expected - actual) <= tolerance
     else
        is_in_tol = actual >= (expected - tolerance)
     end if
  end if

# 405 "shr_assert_mod.F90.in"
end function within_tolerance_int
! TYPE double,real,int,long
# 378 "shr_assert_mod.F90.in"
elemental function within_tolerance_long(expected, actual, tolerance) &
     result(is_in_tol)
  ! Precondition: tolerance must be >= 0.
  integer(i8), intent(in) :: expected
  integer(i8), intent(in) :: actual
  integer(i8), intent(in) :: tolerance
  logical :: is_in_tol

  ! The following conditionals are to ensure that we don't overflow.

  ! This takes care of two identical infinities.
  if (actual == expected) then
     is_in_tol = .true.
  else if (actual > expected) then
     if (expected >= 0) then
        is_in_tol = (actual - expected) <= tolerance
     else
        is_in_tol = actual <= (expected + tolerance)
     end if
  else
     if (expected < 0) then
        is_in_tol = (expected - actual) <= tolerance
     else
        is_in_tol = actual >= (expected - tolerance)
     end if
  end if

# 405 "shr_assert_mod.F90.in"
end function within_tolerance_long

end module shr_assert_mod
