!===================================================
! DO NOT EDIT THIS FILE, it was generated using ../../../../../../tools/cprnc/genf90/genf90.pl 
! Any changes you make to this file may be lost
!===================================================
module ncdio_pio

  ! This is a fake replacement for ncdio_pio. It does not interact with external files
  ! (or pio for that matter) at all! Instead it essentially provides setters and getters
  ! for module-level variables, in order to fake i/o.

  ! Currently it just contains 'read' functionality

  use shr_kind_mod, only : r8 => shr_kind_r8, i4=>shr_kind_i4
  use ncdio_var, only : ncdio_var_type

  ! !PUBLIC TYPES:
  implicit none
  save
  private

  public :: file_desc_t
  
  ! Fake replacement for file_desc_t. Instead of relating to a netcdf file, this fake
  ! object contains the data faking the file.
  type :: file_desc_t
     private
     ! all of the variables in the file (a linked list would be a more efficient
     ! implementation, but I'm going for simplicity over efficiency here)
     type(ncdio_var_type), allocatable :: vars(:)
  end type file_desc_t

  integer, parameter, public :: ncd_double = 1
  integer, parameter, public :: ncd_int = 2
  integer, parameter, public :: ncd_log = 3

  !
  ! !PUBLIC MEMBER FUNCTIONS:

  public :: ncd_io                ! do fake i/o (currently only set up to read)
  public :: ncd_set_var           ! set data on "file" for one variable
  public :: ncd_reset_read_times  ! reset the "read_times" sensor variable for a given variable
  public :: ncd_get_read_times    ! get the value of the "read_times" sensor variable for a given variable
  public :: ncd_pio_openfile      ! stub: open file
  public :: ncd_pio_closefile     ! stub: close file
  public :: ncd_inqdid            ! stub: inquire dimension id
  public :: ncd_inqvdlen          ! stub: inquire size of a dimension
  public :: ncd_inqdlen           ! stub: inquire size of a dimension

# 45 "ncdio_pio_fake.F90.in"
  interface file_desc_t
     module procedure constructor  ! initialize a new file_desc_t object
  end interface file_desc_t

  !
  ! !PRIVATE TYPES:

  integer, parameter :: var_not_found = -1  ! flag indicating variable wasn't found on file

  !
  ! !PRIVATE MEMBER FUNCTIONS:
  
  private :: ncd_get_variable_index  ! return the index of a given variable

# 59 "ncdio_pio_fake.F90.in"
  interface ncd_io
     module procedure ncd_io_1d_double
     module procedure ncd_io_2d_double
     module procedure ncd_io_1d_int
     module procedure ncd_io_1d_logical

     !TYPE int,double
     !DIMS 0,1,2,3
     module procedure ncd_io_0d_int_glob
     !TYPE int,double
     !DIMS 0,1,2,3
     module procedure ncd_io_1d_int_glob
     !TYPE int,double
     !DIMS 0,1,2,3
     module procedure ncd_io_2d_int_glob
     !TYPE int,double
     !DIMS 0,1,2,3
     module procedure ncd_io_3d_int_glob
     !TYPE int,double
     !DIMS 0,1,2,3
     module procedure ncd_io_0d_double_glob
     !TYPE int,double
     !DIMS 0,1,2,3
     module procedure ncd_io_1d_double_glob
     !TYPE int,double
     !DIMS 0,1,2,3
     module procedure ncd_io_2d_double_glob
     !TYPE int,double
     !DIMS 0,1,2,3
     module procedure ncd_io_3d_double_glob

     !TYPE text
     !DIMS 0,1,2
     module procedure ncd_io_0d_text_glob
     !TYPE text
     !DIMS 0,1,2
     module procedure ncd_io_1d_text_glob
     !TYPE text
     !DIMS 0,1,2
     module procedure ncd_io_2d_text_glob

  end interface ncd_io

# 75 "ncdio_pio_fake.F90.in"
contains

  ! ======================================================================
  ! Constructors
  ! ======================================================================

  !-----------------------------------------------------------------------
# 82 "ncdio_pio_fake.F90.in"
  type(file_desc_t) function constructor()
    !
    ! !DESCRIPTION:
    ! Create a new file_desc_t object
    !
    ! !ARGUMENTS:
    !
    ! !LOCAL VARIABLES:
    
    character(len=*), parameter :: subname = 'file_desc_t constructor'
    !-----------------------------------------------------------------------
    
    allocate(constructor%vars(0))
    
# 96 "ncdio_pio_fake.F90.in"
  end function constructor
  
  
  ! ======================================================================
  ! Fakes for the actual ncdio_pio functionality
  ! ======================================================================

  ! DIMS 1,2
  !-----------------------------------------------------------------------
# 105 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_1d_double(varname, data, dim1name, flag, ncid, nt, readvar)
    !
    ! !DESCRIPTION:
    ! Fake for the non-glob form of ncd_io_1d_double.
    !
    ! Note that this assumes we are working with a single time slice (I'm not sure
    ! whether the true ncd_io routines carry that assumption)
    !
    ! !ARGUMENTS:
    character(len=*)   , intent(in)    :: varname      ! variable name
    real(r8)           , pointer       :: data(:) ! local decomposition data (no time dimension)
    character(len=*)   , intent(in)    :: dim1name     ! dimension name (unused for the fake)
    character(len=*)   , intent(in)    :: flag         ! 'read' or 'write' (currently only 'read' is supported)
    class(file_desc_t) , intent(inout) :: ncid         ! netcdf file id
    integer, optional  , intent(in)    :: nt           ! time sample index
    logical, optional  , intent(out)   :: readvar      ! true => variable is on dataset (read only)
    !
    ! !LOCAL VARIABLES:
    integer :: varindex  ! index of variable of interest

    character(len=*), parameter :: subname = 'ncd_io_1d_double'
    !-----------------------------------------------------------------------
    
    if (flag /= 'read') then
       write(*,*) subname, ' ERROR: currently only the "read" flag is supported'
       stop
    end if

    if (.not. present(nt)) then
       ! nt is optional so code can build, but any code that is actually run in a unit
       ! test should be providing nt
       write(*,*) subname, ' ERROR: currently, the nt optional argument must be present'
    end if
    
    varindex = ncd_get_variable_index(ncid, varname)

    if (varindex /= var_not_found) then
       call ncid%vars(varindex)%get_data(nt, data)
       if (present(readvar)) then
          readvar = .true.
       end if
    else  ! varindex == var_not_found
       if (present(readvar)) then
          readvar = .false.
       end if
    end if
       
# 152 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_1d_double
  ! DIMS 1,2
  !-----------------------------------------------------------------------
# 105 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_2d_double(varname, data, dim1name, flag, ncid, nt, readvar)
    !
    ! !DESCRIPTION:
    ! Fake for the non-glob form of ncd_io_2d_double.
    !
    ! Note that this assumes we are working with a single time slice (I'm not sure
    ! whether the true ncd_io routines carry that assumption)
    !
    ! !ARGUMENTS:
    character(len=*)   , intent(in)    :: varname      ! variable name
    real(r8)           , pointer       :: data(:,:) ! local decomposition data (no time dimension)
    character(len=*)   , intent(in)    :: dim1name     ! dimension name (unused for the fake)
    character(len=*)   , intent(in)    :: flag         ! 'read' or 'write' (currently only 'read' is supported)
    class(file_desc_t) , intent(inout) :: ncid         ! netcdf file id
    integer, optional  , intent(in)    :: nt           ! time sample index
    logical, optional  , intent(out)   :: readvar      ! true => variable is on dataset (read only)
    !
    ! !LOCAL VARIABLES:
    integer :: varindex  ! index of variable of interest

    character(len=*), parameter :: subname = 'ncd_io_2d_double'
    !-----------------------------------------------------------------------
    
    if (flag /= 'read') then
       write(*,*) subname, ' ERROR: currently only the "read" flag is supported'
       stop
    end if

    if (.not. present(nt)) then
       ! nt is optional so code can build, but any code that is actually run in a unit
       ! test should be providing nt
       write(*,*) subname, ' ERROR: currently, the nt optional argument must be present'
    end if
    
    varindex = ncd_get_variable_index(ncid, varname)

    if (varindex /= var_not_found) then
       call ncid%vars(varindex)%get_data(nt, data)
       if (present(readvar)) then
          readvar = .true.
       end if
    else  ! varindex == var_not_found
       if (present(readvar)) then
          readvar = .false.
       end if
    end if
       
# 152 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_2d_double

  ! ======================================================================
  ! Stubs for the actual ncdio_pio functionality (do nothing)
  ! ======================================================================

  !-----------------------------------------------------------------------
# 159 "ncdio_pio_fake.F90.in"
  subroutine ncd_pio_openfile(file, fname, mode)
    !
    ! !DESCRIPTION:
    ! Stub replacement: Open a NetCDF PIO file
    !
    ! !ARGUMENTS:
    class(file_desc_t) , intent(inout) :: file   ! Output PIO file handle
    character(len=*)   , intent(in)    :: fname  ! Input filename to open
    integer            , intent(in)    :: mode   ! file mode

# 169 "ncdio_pio_fake.F90.in"
  end subroutine ncd_pio_openfile

  !-----------------------------------------------------------------------
# 172 "ncdio_pio_fake.F90.in"
  subroutine ncd_pio_closefile(file)
    !
    ! !DESCRIPTION:
    ! Stub replacement: Close a NetCDF PIO file
    !
    ! !ARGUMENTS:
    class(file_desc_t), intent(inout) :: file   ! PIO file handle to close

# 180 "ncdio_pio_fake.F90.in"
  end subroutine ncd_pio_closefile

  !TYPE int,logical
# 183 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_1d_int(varname, data, dim1name, flag, ncid, nt, readvar, cnvrtnan2fill)
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O for 1d 
    !
    ! !ARGUMENTS:
    class(file_desc_t), intent(inout)        :: ncid          ! netcdf file id
    character(len=*) , intent(in)            :: flag          ! 'read' or 'write'
    character(len=*) , intent(in)            :: varname       ! variable name
    integer(i4)          , pointer               :: data(:)       ! local decomposition data
    character(len=*) , intent(in)            :: dim1name      ! dimension name
    integer          , optional, intent(in)  :: nt            ! time sample index
    logical          , optional, intent(out) :: readvar       ! true => variable is on initial dataset (read only)
    logical          , optional, intent(in)  :: cnvrtnan2fill ! true => convert any NaN's to _FillValue (spval)
  
    if (present(readvar)) then
       readvar = .false.
    end if

# 202 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_1d_int
  !TYPE int,logical
# 183 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_1d_logical(varname, data, dim1name, flag, ncid, nt, readvar, cnvrtnan2fill)
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O for 1d 
    !
    ! !ARGUMENTS:
    class(file_desc_t), intent(inout)        :: ncid          ! netcdf file id
    character(len=*) , intent(in)            :: flag          ! 'read' or 'write'
    character(len=*) , intent(in)            :: varname       ! variable name
    logical          , pointer               :: data(:)       ! local decomposition data
    character(len=*) , intent(in)            :: dim1name      ! dimension name
    integer          , optional, intent(in)  :: nt            ! time sample index
    logical          , optional, intent(out) :: readvar       ! true => variable is on initial dataset (read only)
    logical          , optional, intent(in)  :: cnvrtnan2fill ! true => convert any NaN's to _FillValue (spval)
  
    if (present(readvar)) then
       readvar = .false.
    end if

# 202 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_1d_logical

  !------------------------------------------------------------------------
  !DIMS 0,1,2,3
  !TYPE int,double
# 207 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_0d_int_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile) 
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    integer(i4)         ,           intent(inout) :: data ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if

# 225 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_0d_int_glob
  !DIMS 0,1,2,3
  !TYPE int,double
# 207 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_1d_int_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile) 
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    integer(i4)         ,           intent(inout) :: data(:) ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if

# 225 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_1d_int_glob
  !DIMS 0,1,2,3
  !TYPE int,double
# 207 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_2d_int_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile) 
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    integer(i4)         ,           intent(inout) :: data(:,:) ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if

# 225 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_2d_int_glob
  !DIMS 0,1,2,3
  !TYPE int,double
# 207 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_3d_int_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile) 
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    integer(i4)         ,           intent(inout) :: data(:,:,:) ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if

# 225 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_3d_int_glob
  !DIMS 0,1,2,3
  !TYPE int,double
# 207 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_0d_double_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile) 
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    real(r8)         ,           intent(inout) :: data ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if

# 225 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_0d_double_glob
  !DIMS 0,1,2,3
  !TYPE int,double
# 207 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_1d_double_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile) 
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    real(r8)         ,           intent(inout) :: data(:) ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if

# 225 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_1d_double_glob
  !DIMS 0,1,2,3
  !TYPE int,double
# 207 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_2d_double_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile) 
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    real(r8)         ,           intent(inout) :: data(:,:) ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if

# 225 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_2d_double_glob
  !DIMS 0,1,2,3
  !TYPE int,double
# 207 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_3d_double_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile) 
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    real(r8)         ,           intent(inout) :: data(:,:,:) ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if

# 225 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_3d_double_glob

  !------------------------------------------------------------------------
  !DIMS 0,1,2
  !TYPE text
# 230 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_0d_text_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile)
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    character(len=*)         ,           intent(inout) :: data ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if
# 247 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_0d_text_glob
  !DIMS 0,1,2
  !TYPE text
# 230 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_1d_text_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile)
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    character(len=*)         ,           intent(inout) :: data(:) ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if
# 247 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_1d_text_glob
  !DIMS 0,1,2
  !TYPE text
# 230 "ncdio_pio_fake.F90.in"
  subroutine ncd_io_2d_text_glob(varname, data, flag, ncid, readvar, nt, posNOTonfile)
    !
    ! !DESCRIPTION:
    ! Stub replacement: netcdf I/O of global variable
    !
    ! !ARGUMENTS:
    class(file_desc_t),         intent(inout) :: ncid         ! netcdf file id
    character(len=*),           intent(in)    :: flag         ! 'read' or 'write'
    character(len=*),           intent(in)    :: varname      ! variable name
    character(len=*)         ,           intent(inout) :: data(:,:) ! raw data
    logical         , optional, intent(out)   :: readvar      ! was var read?
    integer         , optional, intent(in)    :: nt           ! time sample index
    logical         , optional, intent(in)    :: posNOTonfile ! position is NOT on this file

    if (present(readvar)) then
       readvar = .false.
    end if
# 247 "ncdio_pio_fake.F90.in"
  end subroutine ncd_io_2d_text_glob

  !-----------------------------------------------------------------------
# 250 "ncdio_pio_fake.F90.in"
  subroutine ncd_inqdid(ncid,name,dimid,dimexist)
    !
    ! !DESCRIPTION:
    ! Stub replacement for ncd_inqdid. This does nothing useful, but just satisfies the
    ! interface.
    !
    ! !ARGUMENTS:
    class(file_desc_t),intent(inout) :: ncid   ! netcdf file id
    character(len=*) , intent(in) :: name      ! dimension name
    integer          , intent(out):: dimid     ! dimension id
    logical,optional , intent(out):: dimexist  ! if this dimension exists or not

    dimid = 0
    if (present(dimexist)) then
       dimexist = .false.
    end if

# 267 "ncdio_pio_fake.F90.in"
  end subroutine ncd_inqdid

  !-----------------------------------------------------------------------
# 270 "ncdio_pio_fake.F90.in"
  subroutine ncd_inqvdlen(ncid,varname,dimnum,dlen,err_code)
    !
    ! !DESCRIPTION:
    ! Stub replacement for ncd_inqvdlen_byName (note that we currently do not support
    ! ncd_inqvdlen_byDesc). This does nothing, but just satisfies the interface for
    ! ncd_inqvdlen. 
    !
    ! !ARGUMENTS:
    class(file_desc_t),intent(inout) :: ncid      ! netcdf file id
    character(len=*)  ,intent(in)    :: varname   ! variable name
    integer           ,intent(in)    :: dimnum    ! dimension number to query
    integer           ,intent(out)   :: dlen      ! length of the dimension
    integer           ,intent(out)   :: err_code  ! error code (0 means no error)

    dlen = 0
    err_code = 0

# 287 "ncdio_pio_fake.F90.in"
  end subroutine ncd_inqvdlen

  !-----------------------------------------------------------------------
# 290 "ncdio_pio_fake.F90.in"
  subroutine ncd_inqdlen(ncid,dimid,len,name)
    !
    ! !DESCRIPTION:
    ! Stub replacement for ncd_inqdlen. This does nothing, but just satisfies the
    ! interface.
    !
    ! !ARGUMENTS:
    class(file_desc_t), intent(inout) :: ncid       ! netcdf file id
    integer           , intent(inout) :: dimid      ! dimension id
    integer           , intent(out)   :: len        ! dimension len
    character(len=*), optional, intent(in) :: name  ! dimension name

    len = 0

# 304 "ncdio_pio_fake.F90.in"
  end subroutine ncd_inqdlen

  ! ======================================================================
  ! Public routines to aid unit testing, specific to this fake replacement
  ! ======================================================================

  !-----------------------------------------------------------------------
# 311 "ncdio_pio_fake.F90.in"
  subroutine ncd_set_var(ncid, varname, data, data_shape)
    !
    ! !DESCRIPTION:
    ! Set values for a single variable on this netcdf 'file'.
    !
    ! Regardless of the true dimensionality of the undelying data, this should be called
    ! with a 2-d data variable. The 2nd dim is time, 1st is everything else compressed
    ! into a single dimension. 'data_shape' then gives the true shape of the underlying
    ! data, WITHOUT the underlying time dimension
    !
    ! !USES:
    !
    ! !ARGUMENTS:
    class(file_desc_t) , intent(inout) :: ncid          ! netcdf 'file' into which we should add this variable
    character(len=*)   , intent(in)    :: varname       ! variable name
    real(r8)           , intent(in)    :: data(:,:)     ! the data (see notes above)
    integer            , intent(in)    :: data_shape(:) ! true shape of the underlying data, WITHOUT the time dimension
    !
    ! !LOCAL VARIABLES:
    type(ncdio_var_type) :: newvar  ! the new variable
    type(ncdio_var_type), allocatable :: new_var_list(:)
    character(len=*), parameter :: subname = 'ncd_set_var'
    !-----------------------------------------------------------------------

    ! If a variable with this name is already on the file, stop with an error message
    if (ncd_get_variable_index(ncid, varname) /= var_not_found) then
       write(*,*) subname, ' ERROR: cannot set a variable already on file - ', trim(varname)
    end if
    
    newvar = ncdio_var_type(varname, data, data_shape)

    ! Add newvar to the list.
    !
    ! In theory, I think I should be able to do this, but it isn't working, at least with
    ! the intel compiler v. 13 on yellowstone:
    ! ncid%vars = [ncid%vars, newvar]
    !
    ! So I'm using an inefficient method, but that's okay for these purposes
    allocate(new_var_list(size(ncid%vars) + 1))
    new_var_list(1:size(ncid%vars)) = ncid%vars(:)
    new_var_list(size(ncid%vars)+1) = newvar
    call move_alloc(new_var_list, ncid%vars)

# 354 "ncdio_pio_fake.F90.in"
  end subroutine ncd_set_var
  

  !-----------------------------------------------------------------------
# 358 "ncdio_pio_fake.F90.in"
  subroutine ncd_reset_read_times(ncid, varname)
    !
    ! !DESCRIPTION:
    ! Reset the 'read_times' flag for a given variable. This provides a starting point
    ! for a future call to ncd_get_read_times - i.e., if ncd_get_read_times were called
    ! immediately after ncd_reset_read_times, it would always be false.
    !
    ! !ARGUMENTS:
    class(file_desc_t) , intent(inout) :: ncid    ! netcdf 'file' to operate on
    character(len=*)   , intent(in)    :: varname ! variable name
    !
    ! !LOCAL VARIABLES:
    integer :: varindex  ! index of variable of interest
    
    character(len=*), parameter :: subname = 'ncd_reset_read_times'
    !-----------------------------------------------------------------------

    varindex = ncd_get_variable_index(ncid, varname)

    if (varindex /= var_not_found) then
       call ncid%vars(varindex)%reset_read_times()
    else
       write(*,*) subname, ' ERROR: could not find variable: ', trim(varname)
       stop
    end if
    
# 384 "ncdio_pio_fake.F90.in"
  end subroutine ncd_reset_read_times


  !-----------------------------------------------------------------------
# 388 "ncdio_pio_fake.F90.in"
  function ncd_get_read_times(ncid, varname)
    !
    ! !DESCRIPTION:
    ! Return the value of 'read_times' for all times. This tells you whether this variable
    ! has been 'read' for each time index since the last call to reset_read_times (or
    ! since initialization, if reset_read_times hasn't been called).
    !
    ! !ARGUMENTS:
    logical, allocatable :: ncd_get_read_times(:)  ! function result
    class(file_desc_t) , intent(in) :: ncid    ! netcdf 'file' to operate on
    character(len=*)   , intent(in) :: varname ! variable name
    !
    ! !LOCAL VARIABLES:
    integer :: varindex  ! index of variable of interest
    
    character(len=*), parameter :: subname = 'ncd_get_read_times'
    !-----------------------------------------------------------------------
    
    varindex = ncd_get_variable_index(ncid, varname)
    
    if (varindex /= var_not_found) then
       ncd_get_read_times = ncid%vars(varindex)%get_read_times()
    else
       write(*,*) subname, ' ERROR: could not find variable: ', trim(varname)
       stop
    end if

# 415 "ncdio_pio_fake.F90.in"
  end function ncd_get_read_times


  ! ======================================================================
  ! Private routines
  ! ======================================================================

  !-----------------------------------------------------------------------
# 423 "ncdio_pio_fake.F90.in"
  integer function ncd_get_variable_index(ncid, varname)
    ! Return the index of the variable whose name is 'varname' in the ncid structure. If
    ! varname is not present, return var_not_found
    class(file_desc_t), intent(in) :: ncid
    character(len=*), intent(in) :: varname  ! variable name to find

    integer :: index
    logical :: found

    found = .false.
    index = 0
    do while((index < size(ncid%vars)) .and. (.not. found))
       index = index + 1
       if (ncid%vars(index)%get_varname() == varname) then
          found = .true.
       end if
    end do

    if (found) then
       ncd_get_variable_index = index
    else
       ncd_get_variable_index = var_not_found
    end if
# 446 "ncdio_pio_fake.F90.in"
  end function ncd_get_variable_index

end module ncdio_pio
