!===================================================
! DO NOT EDIT THIS FILE, it was generated using ../../../../../../tools/cprnc/genf90/genf90.pl 
! Any changes you make to this file may be lost
!===================================================
module ncdio_var
  ! This module is specific to using the ncdio_pio_fake version of ncdio_pio. This
  ! provides a derived type for holding a single variable from a fake netcdf file, and
  ! associated methods for working with this derived type.

  use shr_kind_mod, only : r8 => shr_kind_r8

  ! Note that we use shr_assert directly rather than using the macros. This is so we don't
  ! have to worry about whether or not NDEBUG is defined (we ALWAYS want to do these
  ! assertions here).
  use shr_assert_mod , only : shr_assert, shr_assert_all
  
  implicit none
  private
  save

  public :: ncdio_var_type

  integer, parameter, public :: max_name = 256   ! max length for a variable name
  
  ! This type stores a single variable in a fake file, for a single time slice.
  type :: ncdio_var_type
     private
     
     character(len=max_name) :: varname   ! variable name

     integer :: ntimes  ! number of time samples for this variable (length of second dimension)

     ! Second dimension is time, first is everything else. Regardless of the true
     ! dimensionality of the underlying data, we compress all dimensions except time into
     ! a single dimension, and then reshape it as needed.
     real(r8), allocatable :: data(:,:)
     
     ! True shape of a single time slice of the data. This will have a single element if
     ! the data are just spatial, two elements if the data have a space dimension plus a
     ! single level dimension, etc.
     integer, allocatable :: data_shape(:)

     ! This is a sensing variable, telling you which time indices have been "read" since
     ! the last call to reset_read_times
     logical, allocatable :: read_times(:) 

# 43 "ncdio_var.F90.in"
   contains
     generic, public :: get_data => &  ! get the value of data for a single time
          get_data_1d, get_data_2d
     procedure :: get_varname       ! get the variable name
     procedure :: reset_read_times  ! reset the "read_times" sensor variable
     procedure :: get_read_times    ! return the value of "read_times" for all times

     procedure, private :: get_data_1d
     procedure, private :: get_data_2d
  end type ncdio_var_type

# 54 "ncdio_var.F90.in"
  interface ncdio_var_type
     module procedure constructor
  end interface ncdio_var_type

# 58 "ncdio_var.F90.in"
contains
  
  !-----------------------------------------------------------------------
# 61 "ncdio_var.F90.in"
  type(ncdio_var_type) function constructor(varname, data, data_shape)
    ! Create a new object of type ncdio_var_type

    character(len=*), intent(in) :: varname  ! variable name
    real(r8), intent(in) :: data(:,:)  ! the data; 2nd dim is time, 1st is everything else compressed into a single dimension
    integer, intent(in) :: data_shape(:)  ! true shape of the underlying data, WITHOUT the time dimension

    character(len=*), parameter :: subname = 'ncdio_var_type constructor'

    call shr_assert(product(data_shape) == size(data, 1), subname//' product of data_shape must match length of 1st dim of data')

    constructor%varname = varname

    allocate(constructor%data(size(data,1), size(data,2)))
    constructor%data = data
    
    allocate(constructor%data_shape(size(data_shape)))
    constructor%data_shape = data_shape

    constructor%ntimes = size(data, 2)
    
    allocate(constructor%read_times(constructor%ntimes))
    call constructor%reset_read_times()
# 84 "ncdio_var.F90.in"
  end function constructor

  !-----------------------------------------------------------------------
# 87 "ncdio_var.F90.in"
  character(len=max_name) function get_varname(this)
    ! Get the name associated with this variable
    class(ncdio_var_type), intent(in) :: this

    get_varname = this%varname
# 92 "ncdio_var.F90.in"
  end function get_varname


  !-----------------------------------------------------------------------
# 96 "ncdio_var.F90.in"
  subroutine reset_read_times(this)
    ! Reset the 'read_times' variable. Any call to get_read_time will tell you whether a
    ! given time slice has been read since the last call to reset_read_times
    class(ncdio_var_type), intent(inout) :: this

    this%read_times(:) = .false.
# 102 "ncdio_var.F90.in"
  end subroutine reset_read_times
    
  !-----------------------------------------------------------------------
# 105 "ncdio_var.F90.in"
  function get_read_times(this)
    ! Return the value of 'read_times' for all times. This tells you whether this variable
    ! has been 'read' for each time index since the last call to reset_read_times (or
    ! since initialization, if reset_read_times hasn't been called).
    logical, allocatable :: get_read_times(:)
    class(ncdio_var_type), intent(in) :: this

    character(len=*), parameter :: subname = 'get_read_times'

    get_read_times = this%read_times
# 115 "ncdio_var.F90.in"
  end function get_read_times

  ! DIMS 1,2
  !-----------------------------------------------------------------------
# 119 "ncdio_var.F90.in"
  subroutine get_data_1d(this, nt, data)
    ! Return the value of data at the given time. The output variable ('data') should
    ! have the shape of true, underlying data (i.e., multi-dimensional if applicable) but
    ! it should NOT have a time dimension because this subroutine returns the data for a
    ! single time index
    class(ncdio_var_type), intent(inout) :: this
    integer, intent(in) :: nt  ! time index of interest
    real(r8), intent(out) :: data(:)

    character(len=*), parameter :: subname = 'get_data_1d'

    call shr_assert_all((shape(data) == this%data_shape), subname//' incorrect shape for data')
    call shr_assert(1 <= nt .and. nt <= this%ntimes, subname//' nt out of bounds')

    data = reshape(this%data(:,nt), this%data_shape(1:1))

    this%read_times(nt) = .true.

# 137 "ncdio_var.F90.in"
  end subroutine get_data_1d
  ! DIMS 1,2
  !-----------------------------------------------------------------------
# 119 "ncdio_var.F90.in"
  subroutine get_data_2d(this, nt, data)
    ! Return the value of data at the given time. The output variable ('data') should
    ! have the shape of true, underlying data (i.e., multi-dimensional if applicable) but
    ! it should NOT have a time dimension because this subroutine returns the data for a
    ! single time index
    class(ncdio_var_type), intent(inout) :: this
    integer, intent(in) :: nt  ! time index of interest
    real(r8), intent(out) :: data(:,:)

    character(len=*), parameter :: subname = 'get_data_2d'

    call shr_assert_all((shape(data) == this%data_shape), subname//' incorrect shape for data')
    call shr_assert(1 <= nt .and. nt <= this%ntimes, subname//' nt out of bounds')

    data = reshape(this%data(:,nt), this%data_shape(1:2))

    this%read_times(nt) = .true.

# 137 "ncdio_var.F90.in"
  end subroutine get_data_2d

end module ncdio_var
