	subroutine fipd_R(PotFld)
c Get the potential fields from a tiegcm history file.
c Need to link with "shavano:~foster/lib/getgcm.a" as well as with the
c library "shavano:/usr/local/lib/libmss.a".
	dimension Fields(73, 25, 36), PotFld(37,73)
	dimension iFields(17), xa(36)
	dimension f(37,73), phi(36,73)

	character*30 mpath
	integer MT(3)
	logical ISTIEGCM

c Read needed data selection criteria from stdin.
	open (unit=9, file= "HistReq")
	read (9,10) mpath
   10	format(a)
	read (9,11, end=12) iday
	read (9,11, end=12) ihr
	read (9,11, end=12) imin
   11   format(i3)
   12	close (unit=9)

  	print *,"fipd_R: mpath= ", mpath
	print *, "fipd_R: iday, ihr, imin= ", iday, ihr, imin
	MT(1)= iday 
	MT(2)= ihr 
	MT(3)= imin 

c logical unit assignment
	LUN= 10

c Don`t need anything other than POTENTIAL data.
	do i= 1, 17
          iFields(i)= 0
	enddo
c Set request to grab potentials 
	iFields(16)= 1

c Find the "real" string length.
	do i= len(mpath), 1, -1
	  if (mpath(i:i) .ne. ' ') then
	    mlen= i
	    goto 20
	  endif
	enddo

c Go get the specified field in the specified MSS file.
   20	call getgcmf(mpath(1:mlen), 1, 1, MT, Fields, 1, iFields, 
     &    73, 25, 36, 17, 0, LUN, 0, IVOL, ISTIEGCM, IER) 

	if (IVOL .lt. 0) then
	  print *,"ERROR: Can not find MSS volume:", mpath
	  stop
	endif

	do j= 1, 73
	  do i= 1, 36
	    phi(i,j)= Fields(j,1,i)
	  enddo
	enddo

C xa(i) holds the latitude values [-87.5, 87.5]
	do i= 1, 36
   	  xa(i)= -177.5 + (90.0 + (i-1)*5.0)
	enddo

c NOTE: f= f(37,73), xa(36), PotFld(37,73), phi(36,73)
c xr runs [-85.0, 85.0].  f(i,j) will thus hold 35,73 values, with
c the end points i=1 and i= 37 undefined.
	do j= 1, 73
	  do i= 2, 36
            xr=  -175.0 + (90.0 + (i-1)*5.0)
	    f(i,j)= polint(xa, phi, 36, 73, j, xr)
	  enddo
	enddo

c Now extrapolate to compute the polar values (i.e. f(1,*), f(37,*)
c First the south polar point, then the north polar point. 
	do j= 1, 73
	  ns= 1
	  x= -90.0
          t1= ((phi(ns+1,j) - phi(ns,j))/(xa(ns+1)-xa(ns)))*x
          t2= ((phi(ns+1,j) - phi(ns,j))/(xa(ns+1)-xa(ns)))*xa(ns)
	  f(1,j)= t1 + (phi(ns,j) - t2)

	  ns=35 
	  x= 90.0
          t1= ((phi(ns+1,j) - phi(ns,j))/(xa(ns+1)-xa(ns)))*x
          t2= ((phi(ns+1,j) - phi(ns,j))/(xa(ns+1)-xa(ns)))*xa(ns)
	  f(37,j)= t1 + (phi(ns,j) - t2)
	enddo

c There is a phase difference of 180 degrees between TGCM grid and
c thunder grid so shift the new data over by 180 degrees.
        do i= 1, 37
	  do j= 1, 37
	    j0= j+36
	    PotFld(i, j0)= f(i,j)
	    PotFld(i, j)= f(i,j0)
	  enddo
	enddo

c Dump these values for processing on lhotse.hao using IDL.
c	open (unit=13, file="TGCM.grid", status= "NEW")
c	do i= 1, 37
c	  do j= 1, 73
c	    ya= (j-1)*5.0 
c	    za= -180.0 + (90.0 + (i-1)*5.0)
c	    write (13, '(1x,f6.2,1x,f6.2,1x,f10.2)') za, ya, PotFld(i,j) 
c   	  enddo
c	enddo
c	close (13)

	return
	end
