      PROGRAM TEST                                                              
      SAVE
C     ****                                                                      
C     ****     TEST BILINEAR INTERPOLATION FOR TRANMSFORMING FROM               
C     ****       GEOGRAPHIC TO GEOMAGNETIC GRID                                 
C     ****                                                                      
C     ****     PARAMETERS DEFINING GEOGRAPHIC AND GEOMAGNETIC GRIDS
C     ****
C     ****       LAMDAG = -180.,180.,5.   (DEGREES)
C     ****       THETAG = -87.5,87.5,5.  AND -90. AND 90.
C     ****       LAMDAM = -180.,180.,5.   (DEGREES)
C     ****       THETAM = -90.,90.,5.     (DEGREES)
C     ****
      PARAMETER (IMAXG=72,JMAXG=38,IMAXM=72,JMAXM=37)                           
      PARAMETER (IMAXGP=IMAXG+1,IMAXMP=IMAXM+1,JMAXGM=JMAXG-2)
      PARAMETER (JMAXGP=JMAXG+2,IMAXGP4=IMAXG+4)
      DIMENSION WORK(IMAXGP4,JMAXGP,11)
      DIMENSION
     2  YLATM(JMAXM),YLATG(IMAXGP),
     3  YLONG(IMAXGP),
     4  AM(IMAXMP,JMAXM),AG(IMAXGP,JMAXG),
     5  AG2(IMAXGP,JMAXG)
      COMMON/WORK/SNYLATM(JMAXM),CSYLATM(JMAXM),A(5,2),AA(IMAXM,4,2),
     1  TTEST(IMAXM,2),IWHICH(IMAXM,JMAXM),B(IMAXM,JMAXM,6,2),
     2  YLONM(IMAXMP)
C     ****
C     ****     MAGNETIC FIELD QUANTITIES GENERATED BY APEX CODE
C     ****
      COMMON/FIELD/XB(IMAXGP,JMAXG),YB(IMAXGP,JMAXG),ZB(IMAXGP,JMAXG),
     1  BMOD(IMAXGP,JMAXG),DMLAT(IMAXGP,JMAXG),DDEC(IMAXGP,JMAXG)
C     ****
C     ****     DATA USED TO TRANSFORM BETWEEN GEOGRAPHIC AND
C     ****       GEOMAGNETIC COORDINATE SYSTEMS
C     ****
      COMMON/TERP/ALATM(IMAXGP,JMAXG),ALONM(IMAXGP,JMAXG),
     1  IG(IMAXMP,JMAXM),JG(IMAXMP,JMAXM),WT(4,IMAXMP,JMAXM),
     2  IM(IMAXGP,JMAXG),JM(IMAXGP,JMAXG),DIM(IMAXGP,JMAXG),
     3  DJM(IMAXGP,JMAXG)
C     ****
C     ****     TRIGONOMETRIC QUANTITIES USED IN SETTING
C     ****       UP TRANSFORMATIONS
C     ****
      COMMON/TRIG/CSLATM(IMAXGP,JMAXGM),SNLATM(IMAXGP,JMAXGM),
     1  CSLONM(IMAXGP,JMAXGM),SNLONM(IMAXGP,JMAXGM),CSLATG(JMAXGM),
     2  SNLATG(JMAXGM),CSLONG(IMAXGP),SNLONG(IMAXGP),DLATG,DLONG
      CALL OPNGKS
C     ****                                                                      
C     ****     SET CONSTANTS                                                    
C     ****                                                                      
      PI = 4.*ATAN(1.)                                                          
      DTR = PI/180.                                                             
      LG = IMAXGP                                                               
      LM = IMAXMP                                                               
      E = 1.E-6                                                                 
C     ****                                                                      
C     ****     GRID SPACING                                                     
C     ****                                                                      
      DLATG = PI/FLOAT(JMAXG-2)                                                 
      DLONG = 2.*PI/FLOAT(IMAXG)                                                
      DLONM = 2.*PI/FLOAT(IMAXM)                                                
C     ****                                                                      
C     ****     SET ARRAY YLATM OF LATITUDE VALUES FOR GEOMAGNETIC GRID.         
C     ****                                                                      
      YLATM(1) = -PI/2.                                                         
      DLAT = 5.*DTR                                                             
      DO 1 J = 2,JMAXM                                                          
        YLATM(J) = YLATM(J-1)+DLAT                                              
    1 CONTINUE                                                                  
C     ****                                                                      
C     ****     SET ARRAY YLONM OF LONGITUDE VALUES FOR GEOMAGNETIC GRID.        
C     ****                                                                      
      YLONM(1) = -PI                                                            
      DO 2 I = 2,IMAXMP                                                         
        YLONM(I) = YLONM(I-1)+DLONM                                             
    2 CONTINUE                                                                  
C     ****                                                                      
C     ****     SET ARRAY YLONG OF LONGITUDE VALUES FOR GEOGRAPHIC GRID.         
C     ****                                                                      
      YLONG(1) = -PI                                                            
      DO 3 I = 2,IMAXGP                                                         
        YLONG(I) = YLONG(I-1)+DLONG                                             
    3 CONTINUE                                                                  
C     ****                                                                      
C     ****     CALCULATE ARRAYS ALATM, ALONM OF GEOMAGNETIC COORDINATES         
C     ****       CORRESPONDING TO GEOGRAPHIC GRID POINTS.                       
C     ****                                                                      
      DO 4 J = 1,JMAXG
        ALAT = (-PI+DLATG)/2.+FLOAT(J-2)*DLATG                                  
        IF(J.EQ.1)ALAT = -PI/2.+E                                               
        IF(J.EQ.JMAXG)ALAT = PI/2.-E                                            
        DO 5 I = 1,IMAXG                                                        
          YLATG(I) = ALAT                                                       
    5   CONTINUE                                                                
C       ****                                                                    
C       ****     CALL GTM TO TRANSFORM TO MAGNETIC COORDINATES.                 
C       ****                                                                    
	CALL GTM2(YLATG,YLONG,ALATM(1,J),ALONM(1,J),XB(1,J),YB(1,J),
     1    ZB(1,J),BMOD(1,J),DMLAT(1,J),DDEC(1,J),IMAXG)
    4 CONTINUE                                                                  
C     ****                                                                      
C     ****     PERIODIC POINTS                                                  
C     ****                                                                      
      DO 6 J = 1,JMAXG                                                          
        ALATM(IMAXGP,J) = ALATM(1,J)                                            
        ALONM(IMAXGP,J) = ALONM(1,J)                                            
	XB(IMAXGP,J) = XB(1,J)
	YB(IMAXGP,J) = YB(1,J)
	ZB(IMAXGP,J) = ZB(1,J)
	BMOD(IMAXGP,J) = BMOD(1,J)
	DMLAT(IMAXGP,J) = DMLAT(1,J)
	DDEC(IMAXGP,J) = DDEC(1,J)
    6 CONTINUE                                                                  
C     ****
C     ****     FILL /TRIG/
C     ****
      DO 20 I = 1,IMAXGP
	CSLONG(I) = COS(-PI+(I-1)*DLONG)
	SNLONG(I) = SIN(-PI+(I-1)*DLONG)
   20 CONTINUE
      DO 21 J = 1,JMAXGM
	SNLATG(J) = SIN(-.5*(PI-DLATG)+(J-1)*DLATG)
	CSLATG(J) = SQRT(1.-SNLATG(J)**2)
	DO 21 I = 1,IMAXGP
	  CSLONM(I,J) = COS(ALONM(I,J+1))
	  SNLONM(I,J) = SIN(ALONM(I,J+1))
	  SNLATM(I,J) = SIN(ALATM(I,J+1))
	  CSLATM(I,J) = SQRT(1.-SNLATM(I,J)**2)
   21 CONTINUE
C     ****                                                                      
C     ****     SET UP YLATG ARRAY AS FUNCTION OF J.                             
C     ****                                                                      
      YLATG(1) = -(PI+DLATG)/2.                                                 
      DO 7 J = 2,JMAXG                                                          
        YLATG(J) = YLATG(J-1)+DLATG                                             
    7 CONTINUE                                                                  
      YLATG(1) = -PI/2.+E                                                       
      YLATG(JMAXG) = PI/2.-E                                                    
C     ****                                                                      
C     ****     SET UP TRANSFORMATION (GEOGRAPHIC TO GEOMAGNETIC)
C     ****                                                                      
      CALL GRDSTM(ALATM,ALONM,IG,JG,WT,LG,IMAXG,JMAXG,LM,IMAXM,
     1  JMAXM,YLATM,YLATG)
C     ****                                                                      
C     ****     SET AG TO SIMPLE SCALAR FIELD.                                   
C     ****                                                                      
      DO 8 J = 1,JMAXG                                                          
        COSJ = COS(YLATG(J))                                                    
        DO 8 I = 1,IMAXGP                                                       
          AG(I,J) = COSJ*COS(FLOAT(I-1)*DLONG)                                  
    8 CONTINUE                                                                  
C     ****                                                                      
C     ****     TRANSFORM TO GEOMAGNETIC COORDINATE SYSTEM
C     ****       OUTPUT FIELD IS IN ARRAY AM
C     ****                                                                      
      CALL GRDINT(AM,AG,IG,JG,WT,LG,LM,IMAXG,JMAXG,IMAXM,JMAXM)
C     ****                                                                      
C     ****     PERIODIC POINTS                                                  
C     ****                                                                      
      DO 9 J = 1,JMAXM                                                          
        AM(IMAXMP,J) = AM(1,J)                                                  
    9 CONTINUE                                                                  
C     ****                                                                      
C     ****     SET UP BILINEAR TRANSFORMATION (GEOMAGNETIC TO GEGRAPHIC)        
C     ****                                                                      
      CALL GRDSET(ALATM,ALONM,IM,JM,DIM,DJM,IMAXGP,IMAXG,JMAXG,IMAXM,           
     1  JMAXM,YLATM)                                                            
C     ****                                                                      
C     ****     PERFORM TRANSFORMATION FROM FROM GEOMAGNETIC TO                  
C     ****       GEOGRAPHIC GRID.  OUTPUT FIELD IS IN ARRAY AG2
C     ****                                                                      
      CALL GRDTRP(AM,AG2,IM,JM,DIM,DJM,IMAXGP,IMAXMP,IMAXG,JMAXG,IMAXM,         
     1  JMAXM)                                                                  
C     ****                                                                      
C     ****     INSERT PERIODIC POINTS IN AG2                                    
C     ****                                                                      
      DO 10 J = 1,JMAXG                                                         
        AG2(IMAXGP,J) = AG2(1,J)                                                
   10 CONTINUE                                                                  
C     ****                                                                      
C     ****     PLOT AG, AM and AG
C     ****                                                                      
      CALL EZCNTR(AG,IMAXGP,JMAXG)                                              
      CALL EZCNTR(AM,IMAXMP,JMAXM)                                              
      CALL EZCNTR(AG2,IMAXGP,JMAXG)                                             
      CALL CLSGKS
      STOP                                                                      
      END                                                                       
      SUBROUTINE GRDSTM(ALATM,ALONM,IG,JG,WT,LG,IMAXG,JMAXG,LM,IMAXM,
     1  JMAXM,YLATM,YLATG)
      SAVE
      PARAMETER (IMXM=72,JMXM=37,IMXMP1=IMXM+1)
C     ****
C     ****     SET CONSTANTS FOR TRANSFORMING SCALAR FIELD FROM
C     ****       GEOGRAPHIC TO GEOMAGNETIC GRID.  USES LINEAR
C     ****       INTERPOLATION OVER TRIANGLES
C     ****
C     ****     NOTE:
C     ****       ALL ANGLES ARE IN RADIANS
C     ****
C     ****     GEOGRAPHIC GRID:
C     ****       IMAXG+1 EQUALLY SPACED LONGITUDE VALUES.
C     ****         RANGE IS -PI TO PI.
C     ****         INDEX(IMAXG+1) IS EQUIVALENT TO INDEX(1)
C     ****       JMAXG LATITUDE VALUES NOT NECESSARILY EQUALLY SPACED.
C     ****         RANGE IS -PI/2 TO PI/2
C     ****
C     ****     GEOMAGNETIC GRID:
C     ****       IMAXM+1 EQUALLY SPACED LONGITUDE VALUES.
C     ****         RANGE IS -PI TO PI.
C     ****         INDEX(IMAXM+1) IS EQUIVALENT TO INDEX(1)
C     ****       JMAXM LATITUDE VALUES NOT NECESSARILY EQUALLY SPACED.
C     ****         RANGE IS -PI/2 TO PI/2
C     ****
C     ****     INPUT:
C     ****       ALATM(LG,JMAXG), ALONM(LG,JMAXG)
C     ****         2-DIM ARRAYS OF GEOMAGNETIC LATITUDES AND LONGITUDES
C     ****         CORRESPONDING TO THE (IMAXG+1)*JMAXG GEOGRAPHIC GRID
C     ****         POINTS.    LG.GE.IMAXG+1
C     ****       IMAXG,JMAXG
C     ****         DIMENSION OF GEOGRAPHIC GRID IS (IMAXG+1,JMAXG)
C     ****       YLATM(JMAXM)
C     ****         1-DIM ARRAY OF GEOMAGNETIC LATITUDE VALUES IN
C     ****         INCREASING ORDER.
C     ****       YLATG(JMAXG)
C     ****         1-DIM ARRAY OF GEOGRAPHIC LATITUDE VALUES IN
C     ****         INCREASING ORDER
C     ****
C     ****     OUTPUT:
C     ****       IG(LM,JMAXM)
C     ****         2-DIM ARRAY OF INTEGER GEOGRAPHIC LONGITUDE INDICES
C     ****         FOR EACH GEOMAGNETIC GRID POINT.
C     ****       JG(LM,JMAXM)
C     ****         2-DIM ARRAY OF INTEGER GEOGRAPHIC LATITUDE INDICES
C     ****         FOR EACH GEOMAGNETIC GRID POINT.
C     ****       WT(4,LM,JMAXM)
C     ****         3-DIM ARRAY GIVING WEIGHTS BY WHICH FUNCTION VALUES
C     ****         AT FOUR CORNERS OF GEOGRAPHIC GRID ELEMENT
C     ****         (IG(IM,JM),JG(IM,JM)) MUST BE MULTIPLIED FOR
C     ****         INTERPOLATION TO GEOMAGNETIC GRID POINT(IM,JM).
C     ****
C     ****     COMMON/WORK/
C     ****       COMMON BLOCK FOR WORKSPACE ARRAYS
C     ****         SNYLTM(JMAXM),CSYLTM(JMAXM)
C     ****           ARRAYS FOR SINES AND COSINES OF GEOMAGNETIC
C     ****           LATITUDE VALUES GIVEN IN YLATM ARRAY
C     ****         A(5,2) FOR SINES AND COSINES OF FOUR SIDES OF CURRENT
C     ****           GEOGRAPHIC GRID ELEMENT.  ALSO DIAGONAL BETWEEN SW
C     ****           AND NE CORNERS. (DISTANCES IN GEOMAGNETIC SPACE)
C     ****         AA(IMAXM,4,2) SINES AND COSINES OF DISTANCES BETWEEN
C     ****           A LATITUDE LINE OF GEOMAGNETIC GRID POINTS AND THE
C     ****           FOUR CORNERS OF ABOVE GEOGRAPHIC GRID ELEMENT.
C     ****         TTEST(IMAXM,2)
C     ****           USED TO TEST WHETHER GEOMAGNETIC GRID POINT LIES
C     ****           WITHIN EITHER OF THE TRIANGLES CREATED BY THE
C     ****           GEOGRAPHIC GRID ELEMENT AND ITS DIAGONAL.
C     ****         IWHICH(IMAXM,JMAXM)
C     ****           IWHICH(IM,JM)=1 IFF THE GEOMAGNETIC GRID POINT
C     ****           (IM,JM) FALLS WITHIN THE NW TRIANGLE OF A
C     ****           GEOGRAPHIC GRID ELEMENT.
C     ****           IWHICH(IM,JM)=2 IFF IT FALLS IN THE SE TRIANGE
C     ****         B(IMAXM,JMAXM,6,2)
C     ****           SINES AND COSINES OF THE THREE SIDES OF THE
C     ****           GEOGRAPHIC TRIANGLE WITHIN WHICH GEOMAGNETIC POINT
C     ****           (IM,JM) FALLS.  ALSO SINES AND COSINES FOR LINES
C     ****           JOINING THE POINT TO THE THREE CORNERS OF THE
C     ****           TRIANGLE.
C     ****         YLONM(IMAX)
C     ****           ARRAY OF MAGNETIC LONGITUDE VALUES
C     ****
      COMMON/WORK/SNYLTM(JMXM),CSYLTM(JMXM),A(5,2),AA(IMXM,4,2),
     1  TTEST(IMXM,2),IWHICH(IMXM,JMXM),B(IMXM,JMXM,6,2),YLONM(IMXMP1)
      DIMENSION ALATM(LG,1),ALONM(LG,1),IG(LM,1),JG(LM,1),WT(4,LM,1),
     1   YLATM(1),YLATG(1),IFF(4),JFF(4),SNLATM(4),CSLATM(4)
C     ****
C     ****    SET CONSTANTS
C     ****
      PI = 4.*ATAN(1.)
      E = 1.E-10
      DLONM = 2.*PI/FLOAT(IMAXM)
C     ****
C     ****     EVALUATE SINE AND COSINE OF EACH GEOMAGNETIC LATITUDE
C     ****       GRID VALUE
C     ****
      DO 1 JM = 1,JMAXM
	SNYLTM(JM) = SIN(YLATM(JM))
	CSYLTM(JM) = COS(YLATM(JM))
    1 CONTINUE
C     ****
C     ****     CALCULATE GEOMAGNETIC LONGITUDE GRID VALUES
C     ****
      DO 2 IM = 1,IMAXM+1
	YLONM(IM) = -PI+FLOAT(IM-1)*DLONM
    2 CONTINUE
C     ****
C     ****     SET ARRAYS IG,JG, WT, IWHICH, B TO ZERO
C     ****
      DO 3 JM = 1,JMAXM
	DO 3 IM = 1,IMAXM
	  IG(IM,JM) = 0
	  JG(IM,JM) = 0
	  WT(1,IM,JM) = 0.
	  WT(2,IM,JM) = 0.
	  WT(3,IM,JM) = 0.
	  WT(4,IM,JM) = 0.
	  IWHICH(IM,JM) = 0
    3 CONTINUE
      DO 12 I = 1,12*IMAXM*JMAXM
	B(I,1,1,1) = 0.
   12 CONTINUE
      DO 4 J = 1,JMAXG-1
	DO 4 I = 1,IMAXG
C       ****
C       ****     SET ARRAYS SNLATM, CSLATM, IFF, JFF
C       ****
	  SNLATM(1) = SIN(ALATM(I,J))
	  SNLATM(2) = SIN(ALATM(I+1,J))
	  SNLATM(3) = SIN(ALATM(I+1,J+1))
	  SNLATM(4) = SIN(ALATM(I,J+1))
	  CSLATM(1) = COS(ALATM(I,J))
	  CSLATM(2) = COS(ALATM(I+1,J))
	  CSLATM(3) = COS(ALATM(I+1,J+1))
	  CSLATM(4) = COS(ALATM(I,J+1))
	  IFF(1) = I
	  IFF(2) = I+1
	  IFF(3) = I+1
	  IFF(4) = I
	  JFF(1) = J
	  JFF(2) = J
	  JFF(3) = J+1
	  JFF(4) = J+1
	  A(5,2)=SNLATM(1)*SNLATM(3)+CSLATM(1)*CSLATM(3)*
     1      COS(ALONM(IFF(3),JFF(3))-ALONM(IFF(1),JFF(1)))
	  A(5,1) = SQRT(1.-A(5,2)**2)
	  DO 11 NP = 1,4
	    NPP1 = 1+MOD(NP,4)

C           ****
C           ****       SET ARRAY A
C           ****
	    A(NP,2) = SNLATM(NP)*SNLATM(NPP1)+CSLATM(NP)*CSLATM(NPP1)
     1        *COS(ALONM(IFF(NPP1),JFF(NPP1))-ALONM(IFF(NP),JFF(NP)))
	    A(NP,1) = SQRT(1.-A(NP,2)**2)
   11     CONTINUE
	  DO 4 JM = 1,JMAXM
	    DO 5 NP = 1,4
	      NPP1 = 1+MOD(NP,4)
	      DO 5 IM = 1,IMAXM
C               ****
C               ****     SET ARRAY AA
C               ****
		AA(IM,NP,2) = SNLATM(NP)*SNYLTM(JM)+CSLATM(NP)*
     1            CSYLTM(JM)*COS(YLONM(IM)-ALONM(IFF(NP),JFF(NP)))
		AA(IM,NP,1) = SQRT(1.-AA(IM,NP,2)**2)
    5       CONTINUE
C           ****
C           ****   TEST FOR (IM,JM) LYING WITHIN TRIANGLE OF (I,J)
C           ****
	    DO 6 IM = 1,IMAXM
	      TTEST(IM,1) = -1.
	      TTEST(IM,2) = -1.
	      TTEST(IM,1) = ACOS((A(5,2)-AA(IM,1,2)*AA(IM,3,2))/
     1          (AA(IM,1,1)*AA(IM,3,1)*(1.+E)))
	      TTEST(IM,2) = TTEST(IM,1)
	      IF(J.NE.JMAXG-1)THEN
		TTEST(IM,1) = TTEST(IM,1)+
     1            ACOS((A(3,2)-AA(IM,3,2)*AA(IM,4,2))/
     2            (AA(IM,3,1)*AA(IM,4,1)*(1.+E)))+
     3            ACOS((A(4,2)-AA(IM,4,2)*AA(IM,1,2))/
     4            (AA(IM,4,1)*AA(IM,1,1)*(1.+E)))
		TTEST(IM,1) = 1.E-5-ABS(2.*PI-TTEST(IM,1))
	      ENDIF
	      IF(J.NE.1)THEN
		TTEST(IM,2) = TTEST(IM,2)+
     1            ACOS((A(1,2)-AA(IM,1,2)*AA(IM,2,2))/
     2            (AA(IM,1,1)*AA(IM,2,1)*(1.+E)))+
     3            ACOS((A(2,2)-AA(IM,2,2)*AA(IM,3,2))/
     4            (AA(IM,2,1)*AA(IM,3,1)*(1.+E)))
		TTEST(IM,2) = 1.E-5-ABS(2.*PI-TTEST(IM,2))
	      ENDIF
	      IF(J.EQ.1)TTEST(IM,2)=-1.
	      IF(J.EQ.JMAXG-1)TTEST(IM,1)=-1.
	      TTEST(IM,1) = CVMGP(TTEST(IM,1),-1.,AA(IM,4,2))
	      TTEST(IM,2) = CVMGP(TTEST(IM,2),-1.,AA(IM,2,2))
    6       CONTINUE
	    DO 7 NP = 1,2
	      DO 7 IM = 1,IMAXM
		IG(IM,JM) = CVMGP(I,IG(IM,JM),TTEST(IM,NP))
		JG(IM,JM) = CVMGP(J,JG(IM,JM),TTEST(IM,NP))
		IWHICH(IM,JM) = CVMGP(NP,IWHICH(IM,JM),TTEST(IM,NP))
		B(IM,JM,1,NP) = CVMGP(A(5,NP),B(IM,JM,1,NP),TTEST(IM,1))
		B(IM,JM,2,NP) = CVMGP(A(3,NP),B(IM,JM,2,NP),TTEST(IM,1))
		B(IM,JM,3,NP) = CVMGP(A(4,NP),B(IM,JM,3,NP),TTEST(IM,1))
		B(IM,JM,4,NP) = CVMGP(AA(IM,1,NP),B(IM,JM,4,NP),
     1            TTEST(IM,1))
		B(IM,JM,5,NP) = CVMGP(AA(IM,3,NP),B(IM,JM,5,NP),
     1            TTEST(IM,1))
		B(IM,JM,6,NP) = CVMGP(AA(IM,4,NP),B(IM,JM,6,NP),
     1            TTEST(IM,1))
		B(IM,JM,1,NP) = CVMGP(A(1,NP),B(IM,JM,1,NP),TTEST(IM,2))
		B(IM,JM,2,NP) = CVMGP(A(2,NP),B(IM,JM,2,NP),TTEST(IM,2))
		B(IM,JM,3,NP) = CVMGP(A(5,NP),B(IM,JM,3,NP),TTEST(IM,2))
		B(IM,JM,4,NP) = CVMGP(AA(IM,1,NP),B(IM,JM,4,NP),
     1            TTEST(IM,2))
		B(IM,JM,5,NP) = CVMGP(AA(IM,2,NP),B(IM,JM,5,NP),
     1            TTEST(IM,2))
		B(IM,JM,6,NP) = CVMGP(AA(IM,3,NP),B(IM,JM,6,NP),
     1            TTEST(IM,2))
    7       CONTINUE
    4 CONTINUE
C     ****
C     ****     CALCULATE WEIGHTS
C     ****
      DO 8 JM = 1,JMAXM
C     ****
C     ****     AREAS OF 3 TRIANGLES
C     ****
	DO 9 NP = 1,3
	  NPP1 = 1+MOD(NP,3)
	  CALL TRIANG(B(1,JM,NP,2),B(1,JM,NP+3,2),B(1,JM,NPP1+3,2),
     1      B(1,JM,NP,1),B(1,JM,NP+3,1),B(1,JM,NPP1+3,1),AA(1,NP,1),
     2      IMAXM)
    9   CONTINUE
	DO 10 IM = 1,IMAXM
	  AA(IM,4,1) = AA(IM,1,1)+AA(IM,2,1)+AA(IM,3,1)
	  AA(IM,1,1) = AA(IM,1,1)/AA(IM,4,1)
	  AA(IM,2,1) = AA(IM,2,1)/AA(IM,4,1)
	  AA(IM,3,1) = AA(IM,3,1)/AA(IM,4,1)
	  WT(1,IM,JM) = CVMGZ(AA(IM,2,1),WT(1,IM,JM),IWHICH(IM,JM)-1)
	  WT(2,IM,JM) = CVMGZ(0.,WT(2,IM,JM),IWHICH(IM,JM)-1)
	  WT(3,IM,JM) = CVMGZ(AA(IM,3,1),WT(3,IM,JM),IWHICH(IM,JM)-1)
	  WT(4,IM,JM) = CVMGZ(AA(IM,1,1),WT(4,IM,JM),IWHICH(IM,JM)-1)
	  WT(1,IM,JM) = CVMGZ(AA(IM,2,1),WT(1,IM,JM),IWHICH(IM,JM)-2)
	  WT(2,IM,JM) = CVMGZ(AA(IM,3,1),WT(2,IM,JM),IWHICH(IM,JM)-2)
	  WT(3,IM,JM) = CVMGZ(AA(IM,1,1),WT(3,IM,JM),IWHICH(IM,JM)-2)
	  WT(4,IM,JM) = CVMGZ(0.,WT(4,IM,JM),IWHICH(IM,JM)-2)
   10   CONTINUE
    8 CONTINUE
      RETURN
      END
      SUBROUTINE TRIANG(CS1,CS2,CS3,SN1,SN2,SN3,AREA,N)
      SAVE
C     ****
C     ****     DETERMINE AREAS OF N SPHERICAL TRIANGLES
C     ****
C     ****     INPUT
C     ****       CS1(N),CS2(N), CS3(N) ARE COSINES OF THE THREE SIDES
C     ****         OF THE N TRIANGLES
C     ****       SN1(N),SN2(N), SN3(N) ARE CORRESPONDING SINES
C     ****
C     ****     OUTPUT:
C     ****       AREA(N) IS USED TO RETURN THE AREAS OF THE N TRIANGLES
C     ****
      DIMENSION CS1(1),CS2(1),CS3(1),SN1(1),SN2(1),SN3(1),AREA(1)
      DATA E/1.E-12/,PI/3.1415926536/
      DO 1 I = 1,N
	AREA(I) = ACOS((CS1(I)-CS2(I)*CS3(I))/(SN2(I)*SN3(I)*(1.+E)))
	AREA(I) = AREA(I)+ACOS((CS2(I)-CS3(I)*CS1(I))/(SN3(I)*SN1(I)*
     1            (1.+E)))
	AREA(I) = AREA(I)+ACOS((CS3(I)-CS1(I)*CS2(I))/(SN1(I)*SN2(I)*
     1            (1.+E)))-PI
    1 CONTINUE
      RETURN
      END
      SUBROUTINE GRDINT(AM,AG,IG,JG,WT,LG,LM,IMAXG,JMAXG,IMAXM,JMAXM)
      SAVE
C     ****
C     ****     TRANSFORM SCALAR FIELD GIVEN ON GEOGRAPHIC GRID TO
C     ****       GEOMAGNETIC GRID USING INDICES AND WEIGHTS GENERATED
C     ****       BY GRDSTM.
C     ****
C     ****     INPUT:
C     ****      AG(LG,1) IS 2-DIM SCALAR FIELD TO BE TRANSFORMED TO
C     ****        GEOMAGNETIC GRID.
C     ****        NB: PERIODIC POINT IS REPEATED SO THAT
C     ****        AG(IMAXG+1,JG) = AG(1,JG)
C     ****        (LM.GE.IMAXG+1)
C     ****      IMAXG, JMAXG  DIMENSIONS OF GEOGRAPHIC GRID
C     ****      IMAXM, JMAXM  DIMENSIONS OF GEOMAGNETIC GRID
C     ****      LG IS FIRST DIMENSION OF AG IN CALLING PROGRAM
C     ****        (LG.GE.IMAXG+1)
C     ****      IG(LM,1) GIVES ROUNDED DOWN GEOGRAPHIC LONGITUDE INDEX
C     ****        FOR EACH GEOMAGNETIC GRID POINT
C     ****      JG(LM,1) GIVES ROUNDED DOWN GEOGRAPHIC LATITUDE INDEX
C     ****        FOR EACH GEOMAGNETIC GRID POINT
C     ****      WT(4,LM,1) WEIGHTS FOR 4 CORNERS OF EACH GEOMAGNETIC
C     ****        GRID ELEMENT
C     ****      LM IS FIRST DIMENSION OF ARRAYS AM, IG, JG, WT IN
C     ****        CALLING PROGRAM
C     ****        (LM.GE.IMAXM)
C     ****      NOTE:  IG, JG, WT ARE PRODUCED BY PREVIOUS CALL TO
C     ****        GRDSTM.
C     ****
C     ****     OUTPUT:
C     ****      AM(LM,1) 2-DIM SCALAR FIELD TRANSFORMED TO GEOMAGNETIC
C     ****        LATITUDE/LONGITUDE GRID
C     ****
      DIMENSION AM(LM,1),AG(LG,1),IG(LM,1),JG(LM,1),WT(4,LM,1)
C     ****
C     ****     CARRY OUT INTERPOLATION
C     ****
      DO 1 JM = 1,JMAXM
	DO 1 IM = 1,IMAXM
	  AM(IM,JM) =
     1      AG(IG(IM,JM),JG(IM,JM))*WT(1,IM,JM)+
     2      AG(IG(IM,JM)+1,JG(IM,JM))*WT(2,IM,JM)+
     3      AG(IG(IM,JM)+1,JG(IM,JM)+1)*WT(3,IM,JM)+
     4      AG(IG(IM,JM),JG(IM,JM)+1)*WT(4,IM,JM)
    1 CONTINUE
      RETURN
      END
      SUBROUTINE GRDSET(ALATM,ALONM,IM,JM,DIM,DJM,L,IMAXG,JMAXG,IMAXM,          
     1  JMAXM,YLATM)                                                            
      SAVE
C     ****                                                                      
C     ****     PROCEDURE TO SET UP BILINEAR TRANSFORMATION FOR                  
C     ****     TRANSFORMING A SCALAR FIELD FROM GEOMAGNETIC TO                  
C     ****     GEOGRAPHIC COORDINATES                                           
C     ****                                                                      
C     ****     GEOGRAPHIC GRID:                                                 
C     ****       IMAXG EQUALLY SPACED LONGITUDE POINTS.  RANGE                  
C     ****         -PI TO PI.                                                   
C     ****       JMAXG LATITUDE POINTS, NOT NECESSARILY EQUALLY                 
C     ****         SPACED.  RANGE -PI/2 TO P/2.                                 
C     ****                                                                      
C     ****     GEOMAGNETIC GRID:                                                
C     ****       IMAXM EQUALLY SPACED LONGITUDE POINTS.  RANGE                  
C     ****         -PI TO PI.                                                   
C     ****       JMAXM LATITUDE POINTS, NOT NECESSARILY EQUALLY                 
C     ****         SPACED.  RANGE -PI/2 TO P/2.  MUST INCLUDE                   
C     ****         POLES                                                        
C     ****                                                                      
C     ****     INPUT:                                                           
C     ****                                                                      
C     ****       ALATM(L,1) IS 2-DIM ARRAY GIVING THE MAGNETIC                  
C     ****         LATITUDE (IN RADIANS) CORRESPONDING TO EACH OF               
C     ****         THE IMAXG*JMAXG GEOGRAPHIC GRID POINTS.                      
C     ****         (L.GE.IMAXG)                                                 
C     ****                                                                      
C     ****       ALONM(L,1) IS 2-DIM ARRAY GIVING THE MAGNETIC                  
C     ****         LONGITUDE (IN RADIANS) CORRESPONDING TO EACH OF              
C     ****         THE IMAXG*JMAXG GEOGRAPHIC GRID POINTS.                      
C     ****         (L.GE.IMAXG)                                                 
C     ****                                                                      
C     ****       IMAXG, JMAXG  DIMENSIONS OF GEOGRAPHIC GRID                    
C     ****                                                                      
C     ****       IMAXM, JMAXM  DIMENSIONS OF GEOMAGNETIC GRID                   
C     ****                                                                      
C     ****       YLATM(1) IS 1-DIM ARRAY GIVING THE JMAXM LATITUDE              
C     ****         VALUES (IN RADIANS AND ARRANGED MONOTONICALLY)               
C     ****                                                                      
C     ****       L IS FIRST DIMENSION OF ARRAYS ALATM, ALONM, IM,               
C     ****         JM, DIM, DJM IN CALLING PROGRAM                              
C     ****                                                                      
C     ****     OUTPUT:                                                          
C     ****                                                                      
C     ****       IM(L,1) GIVES ROUNDED DOWN GEOMAGNETIC LONGITUDE               
C     ****         INDEX FOR EACH GEOGRAPHIC GRID POINT                         
C     ****                                                                      
C     ****       JM(L,1) GIVES ROUNDED DOWN GEOMAGNETIC LATITUDE                
C     ****         INDEX FOR EACH GEOGRAPHIC GRID POINT                         
C     ****                                                                      
C     ****       DIM(L,1) IS FRACTIONAL GEOMAGNETIC LONGITUDE INDEX             
C     ****         FOR EACH GEOGRAPHIC GRID POINT.  USED FOR BILINEAR           
C     ****         INTERPOLATION WITHIN GRID CELL.                              
C     ****                                                                      
C     ****       DJM(L,1) IS FRACTIONAL GEOMAGNETIC LATITUDE INDEX              
C     ****         FOR EACH GEOGRAPHIC GRID POINT.  USED FOR BILINEAR           
C     ****         INTERPOLATION WITHIN GRID CELL.                              
C     ****                                                                      
      DIMENSION ALATM(L,1),ALONM(L,1),IM(L,1),JM(L,1),DIM(L,1),DJM(L,1),        
     1YLATM(1)                                                                  
      DATA E/1.E-8/                                                             
      PI = 4.*ATAN(1.)                                                          
C     ****                                                                      
C     ****     CALCULATE JM FOR EACH GEOGRAPHIC GRID POINT                      
C     ****                                                                      
      DO 1 JG = 1,JMAXG                                                         
        DO 2 IG = 1,IMAXG                                                       
          JM(IG,JG) = 0.                                                        
    2   CONTINUE                                                                
        DO 3 J = 1,JMAXM-1                                                      
          DO 3 IG = 1,IMAXG                                                     
            JM(IG,JG) = JM(IG,JG)+CVMGP(J,0,(ALATM(IG,JG)-YLATM(J))*            
     1      (YLATM(J+1)-ALATM(IG,JG)))                                          
    3   CONTINUE                                                                
    1 CONTINUE                                                                  
C     ****                                                                      
C     ****     EVALUATE IM, DIM, DJM                                            
C     ****                                                                      
      DO 4 JG = 1,JMAXG                                                         
        DO 4 IG = 1,IMAXG                                                       
          DIM(IG,JG) = (ALONM(IG,JG)+PI)*FLOAT(IMAXM)/(2.*PI)+1.                
          IM(IG,JG) = IFIX(DIM(IG,JG)+E)                                        
          DIM(IG,JG) = DIM(IG,JG)-FLOAT(IM(IG,JG))                              
          DJM(IG,JG) = (ALATM(IG,JG)-YLATM(JM(IG,JG)))/(YLATM(JM(IG,JG)         
     1    +1)-YLATM(JM(IG,JG)))                                                 
    4 CONTINUE                                                                  
      RETURN                                                                    
      END                                                                       
      SUBROUTINE GRDTRP(AM,AG,IM,JM,DIM,DJM,LG,LM,IMAXG,JMAXG,IMAXM,            
     1JMAXM)                                                                    
      SAVE
C     ****                                                                      
C     ****     SUBROUTINE TRANSFORMS SCALAR FIELD GIVEN ON GEOMAGNETIC          
C     ****     GRID TO GEOGRAPHIC GRID USING COEFFICIENTS FOR BILINEAR          
C     ****     INTERPOLATION PREVIOUSLY GENERATED BY CALL TO GRDSET.            
C     ****                                                                      
C     ****     GEOGRAPHIC GRID:                                                 
C     ****       IMAXG EQUALLY SPACED LONGITUDE POINTS.  RANGE                  
C     ****         -PI TO PI.                                                   
C     ****       JMAXG LATITUDE POINTS, NOT NECESSARILY EQUALLY                 
C     ****         SPACED.  RANGE -PI/2 TO P/2.                                 
C     ****                                                                      
C     ****     GEOMAGNETIC GRID:                                                
C     ****       IMAXM EQUALLY SPACED LONGITUDE POINTS.  RANGE                  
C     ****         -PI TO PI.                                                   
C     ****       JMAXM LATITUDE POINTS, NOT NECESSARILY EQUALLY                 
C     ****         SPACED.  RANGE -PI/2 TO P/2.  MUST INCLUDE                   
C     ****         POLES                                                        
C     ****                                                                      
C     ****     INPUT:                                                           
C     ****                                                                      
C     ****       AM(LM,1) IS 2-DIM SCALAR FIELD GIVEN ON GEOMAGNETIC            
C     ****         LATITUDE/LONGITUDE GRID.                                     
C     ****         NB.  PERIODIC POINT IS REPEATED SO THAT                      
C     ****         AM(IMAXM+1,JM) = AM(1,JM)                                    
C     ****         (LM.GE.IMAXM+1)                                              
C     ****                                                                      
C     ****       IMAXG, JMAXG  DIMENSIONS OF GEOGRAPHIC GRID                    
C     ****                                                                      
C     ****       IMAXM, JMAXM  DIMENSIONS OF GEOMAGNETIC GRID                   
C     ****                                                                      
C     ****       LM IS FIRST DIMENSION OF ARRAY AM INCALLING PROGRAM            
C     ****         (LM.GE.IMAXM+1)                                              
C     ****                                                                      
C     ****       IM(LG,1) GIVES ROUNDED DOWN GEOMAGNETIC LONGITUDE              
C     ****         INDEX FOR EACH GEOGRAPHIC GRID POINT                         
C     ****                                                                      
C     ****       JM(LG,1) GIVES ROUNDED DOWN GEOMAGNETIC LATITUDE               
C     ****         INDEX FOR EACH GEOGRAPHIC GRID POINT                         
C     ****                                                                      
C     ****       DIM(LG,1) IS FRACTIONAL GEOMAGNETIC LONGITUDE INDEX            
C     ****         FOR EACH GEOGRAPHIC GRID POINT.  USED FOR BILINEAR           
C     ****         INTERPOLATION WITHIN GRID CELL.                              
C     ****                                                                      
C     ****       DJM(LG,1) IS FRACTIONAL GEOMAGNETIC LATITUDE INDEX             
C     ****         FOR EACH GEOGRAPHIC GRID POINT.  USED FOR BILINEAR           
C     ****         INTERPOLATION WITHIN GRID CELL.                              
C     ****                                                                      
C     ****       LG IS FIRST DIMENSION OF ARRAYS AM,IM,JM,DIM,DJM IN            
C     ****         CALLING PROGRAM.                                             
C     ****         (LG.GE.IMAXG)                                                
C     ****                                                                      
C     ****       NOTE:  IM, JM, DIM, DJM ARE PRODUCED BY PREVIOUS CALL          
C     ****         TO GRDSET.                                                   
C     ****                                                                      
C     ****     OUTPUT:                                                          
C     ****                                                                      
C     ****       AG(LG,1) IS 2-DIM SCALAR FIELD TRANSFORMED TO                  
C     ****         GEOGRAPHIC LATITUDE/LONGITUDE GRID.                          
C     ****         (LG.GE.IMAXG)                                                
C     ****                                                                      
C     ****     PERFORM BILINEAR INTERPOLATION                                   
C     ****                                                                      
      DIMENSION AM(LM,1),AG(LG,1),IM(LG,1),JM(LG,1),DIM(LG,1),DJM(LG,1)         
      DO 1 JG = 1,JMAXG                                                         
        DO 1 IG = 1,IMAXG                                                       
          AG(IG,JG) =                                                           
     1    AM(IM(IG,JG),JM(IG,JG))*(1.-DIM(IG,JG))*(1.-DJM(IG,JG))+              
     2    AM(IM(IG,JG)+1,JM(IG,JG))*DIM(IG,JG)*(1.-DJM(IG,JG))+                 
     3    AM(IM(IG,JG),JM(IG,JG)+1)*(1.-DIM(IG,JG))*DJM(IG,JG)+                 
     2    AM(IM(IG,JG)+1,JM(IG,JG)+1)*DIM(IG,JG)*DJM(IG,JG)                     
    1 CONTINUE                                                                  
      RETURN                                                                    
      END                                                                       
      SUBROUTINE GTM2(RLATG,RLONG,RLATM,RLONM,XB,YB,ZB,BMOD,DMLAT,
     1  DDEC,N)
      SAVE
C     ****                                                                      
C     ****     TRANSFORMS GEOGRAPHIC TO GEOMAGNETIC COORDINATES                 
C     ****                                                                      
C     ****     RLATG(N), RLONG(N):  ARRAYS OF GEOGRAPHIC LATITUDES              
C     ****       AND LONGITUDES.  (RADIANS)                                     
C     ****     RLATM(N), RLONM(N):  OUTPUT ARRAYS OF GEOMAGNETIC                
C     ****       COORDINATES.                                                   
C     ****     N:  NUMBER OF POINTS TO BE TRANSFORMED.                          
C     ****                                                                      
C     ****     COMMON BLOCKS                                                    
C     ****                                                                      
      COMMON/CONST/RTOD,DTOR,RE,REQ,COLAT,WLON
      COMMON/APXOUT/A,ALAT,ALON,XMAG,YMAG,ZMAG,BMAG,GMLAT,DMAG
      DIMENSION RLATG(1),RLONG(1),RLATM(1),RLONM(1),XB(1),YB(1),ZB(1),
     1  BMOD(1),DMLAT(1),DDEC(1)
      DATA RE,REQ/6371.2,6378.165/,ISTAR/0/
      IF(ISTAR.EQ.0)THEN
	ISTAR = 1
C       ****
C       ****     CONSTANTS
C       ****
	RTOD = 45./ATAN(1.)
	DTOR = 1./RTOD
C       ****
C       ****     READ DATE, SET UP MAGNETIC FIELD COEFFICIENTS.
C       ****
	READ *,DATE
	READ *,H0
	READ *,HREF
	READ *,IDPOLE
	CALL COFRM(DATE,IDPOLE)
      ENDIF
      DO 1 I = 1,N                                                              
	DLON = RLONG(I)*RTOD
	DLAT = RLATG(I)*RTOD
	CALL LINAPX(DLAT,DLON,H0,HREF)
	RLATM(I) = ALAT*DTOR
	RLONM(I) = ALON*DTOR
	XB(I) = XMAG
	YB(I) = YMAG
	ZB(I) = ZMAG
	BMOD(I) = BMAG
	DMLAT(I) = GMLAT*DTOR
	DDEC(I) = DMAG*DTOR
    1 CONTINUE                                                                  
      RETURN                                                                    
      END                                                                       
CDIR$ NOLIST                                                                    
       SUBROUTINE COFRM (DATE,IDPOLE)
      SAVE
C***BEGIN PROLOGUE  COFRM                                                       
C***DATE WRITTEN   830415   (YYMMDD)                                            
C***REVISION DATE  880201   (YYMMDD)                                            
C***AUTHOR  Wickwar, Vincent B., SRI. INT.                                      
C***PURPOSE  This assigns DGRF/IGRF spherical harmonic coefficients             
C            for date TIME (yyyy.fraction) into array G.  The coeff's           
C            are interpolated from the 5 year DGRF/IGRF values, or              
C            extrapolated if TIME is more recent than 1985.0 .  The first       
C            year of DGRF coeff's is 1965; if TIME is earlier than this         
C            an error message is generated.                                     
C***DESCRIPTION                                                                 
C                                                                               
C     The origonal routine was obtained from SRI.  Modifications                
C     were to update the coeff's with DGRF 1980 & IGRF 1985.                    
C     The new coeff's were obtained from Eos Vol. 7, No. 24,                    
C         17 Jun 1986.  (April 1987 - Roy Barnes)                               
C     COFRM must be called before FELDG OR SHELG subprograms.                   
C     It sets up coefficients ( G array ) for date.                             
C                                                                               
C   INPUT                                                                       
C     DATE   Time (yyyy.fraction)                                               
C   OUTPUT                                                                      
C            Passed out by the common block MAG see description below.          
C                                                                               
C***LONG DESCRIPTION                                                            
C                                                                               
C     COMMON Block Used                                                         
C     /LOOPS / IPRNT, JUNIT                                                     
C     /MAG  / ICODE,XI(3),H(144),DUM1(2,40),NAME(4),NMAX,TIME,G(144),DUM2(4)    
C     ICODE   Flag set in STOER subprogram.                                     
C     XI      Work array used in subprograms FELDG, SHELG and STOER             
C     H       Work array used in subprogram FELDG , SHELG and STOER             
C     DUM1    Work array used in SHELG and STOER.                               
C     NAME    Not being used any more , used in old version of COFRM            
C     NMAX    Order of IGRF model set in COFRM subprogram                       
C     TIME    Equal to input argument DATE in COFRM routine.                    
C     G       Array of spherical harmonic coefficients for given                
C             date derived in COFRM subprogram.                                 
C     DUM2    Array of numbers set in COFRM routine and used in STOER           
C                                                                               
C***REFERENCES  reference 1                                                     
C                 continuation of reference 1                                   
C                                                                               
C***ROUTINES CALLED  None                                                       
C***COMMON BLOCKS    MAG                                                        
C***END PROLOGUE  COFRM                                                         
      DOUBLE PRECISION F,F0                                                     
      COMMON / LOOPS / IPRNT, JUNIT                                             
      COMMON/MAG/IDUM1,DUM1(307),NAME(4),NMAX,TIME,G(144),                      
     +           RMIN,RMAX,STEP,STEQ                                            
        COMMON /CONST/ RTOD,DTOR,RE,REQ,COLAT,WLON                              
      DIMENSION G0(12,12),GT(12,12),GTT(12,12),H0(12,12),HT(12,12),             
     +    HTT(12,12)                                                            
      DIMENSION GYR(12,12,5),HYR(12,12,5),                                      
     +          G1DIM(576), H1DIM(576),GG(12,12)                                
      EQUIVALENCE ( G(1),GG(1,1))                                               
      EQUIVALENCE ( GYR(1,1,1), G1DIM(1) ),( HYR(1,1,1), H1DIM(1) ),            
     +            (G0(1,1),GYR(1,1,5))    , (H0(1,1),HYR(1,1,5))                
      SAVE DATEL,GYR,HYR,GO,HO,GT,HT,GTT,HTT                                    
      DATA DATEL/-999./                                                         
C          D_/Dtime2 coefficients are 0 (for extrapolation T>1985.0)            
      DATA GTT/144*0./,HTT/144*0./                                              
C          DGRF g(n,m) for 1965:                                                
      DATA (G1DIM(I),I=1,144) /0.,                                              
     1  -30334.,-1662., 1297., 957.,-219., 45., 75., 13.,  8.,-2., 2*0.,        
     1   -2119., 2997.,-2038., 804., 358., 61.,-57.,  5., 10.,-3., 3*0.,        
     2           1594., 1292., 479., 254.,  8.,  4., -4.,  2., 2., 4*0.,        
     3                   856.,-390., -31.,-228.,13.,-14.,-13.,-5., 5*0.,        
     4                         252.,-157.,  4.,-26., -0., 10.,-2., 6*0.,        
     5                               -62.,  1., -6.,  8., -1., 4., 7*0.,        
     6                                   -111., 13., -1., -1., 4., 8*0.,        
     7                                           1., 11.,  5., 0., 9*0.,        
     8                                                4.,  1., 2.,10*0.,        
     9                                                    -2., 2.,11*0.,        
     A                                                         0.,13*0./        
C          DGRF g(n,m) for 1970:                                                
       DATA (G1DIM(I),I=145,288)/ 0.,                                           
     1  -30220.,-1781., 1287., 952.,-216., 43., 72., 14.,  8.,-3., 2*0.,        
     1   -2068., 3000.,-2091., 800., 359., 64.,-57.,  6., 10.,-3., 3*0.,        
     2           1611., 1278., 461., 262., 15.,  1., -2.,  2., 2., 4*0.,        
     3                   838.,-395., -42.,-212.,14.,-13.,-12.,-5., 5*0.,        
     4                         234.,-160.,  2.,-22., -3., 10.,-1., 6*0.,        
     5                               -56.,  3., -2.,  5., -1., 6., 7*0.,        
     6                                   -112., 13.,  0.,  0., 4., 8*0.,        
     7                                          -2., 11.,  3., 1., 9*0.,        
     8                                                3.,  1., 0.,10*0.,        
     9                                                    -1., 3.,11*0.,        
     A                                                        -1.,13*0./        
C          DGRF g(n,m) for 1975:                                                
      DATA (G1DIM(I),I=289,432)/ 0.,                                            
     1  -30100.,-1902., 1276., 946.,-218., 45., 71., 14.,  7.,-3., 2*0.,        
     1   -2013., 3010.,-2144., 791., 356., 66.,-56.,  6., 10.,-3., 3*0.,        
     2           1632., 1260., 438., 264., 28.,  1., -1.,  2., 2., 4*0.,        
     3                   830.,-405., -59.,-192.,16.,-12.,-12.,-5., 5*0.,        
     4                         216.,-159.,  1.,-14., -8., 10.,-2., 6*0.,        
     5                               -49.,  6.,  0.,  4., -1., 5., 7*0.,        
     6                                   -111., 12.,  0., -1., 4., 8*0.,        
     7                                          -5., 10.,  4., 1., 9*0.,        
     8                                                1.,  1., 0.,10*0.,        
     9                                                    -2., 3.,11*0.,        
     A                                                        -1.,13*0./        
C          DGRF g(n,m) for 1980:                                                
      DATA (G1DIM(I),I=433,576)/ 0.,                                            
     1  -29992.,-1997., 1281., 938.,-218., 48., 72., 18.,  5.,-4., 2*0.,        
     1   -1956., 3027.,-2180., 782., 357., 66.,-59.,  6., 10.,-4., 3*0.,        
     2           1663., 1251., 398., 261., 42.,  2.,  0.,  1., 2., 4*0.,        
     3                   833.,-419., -74.,-198.,21.,-11.,-12.,-5., 5*0.,        
     4                         199.,-162.,  4.,-12., -7.,  9.,-2., 6*0.,        
     5                               -48., 14.,  1.,  4., -3., 5., 7*0.,        
     6                                   -108., 11.,  3., -1., 3., 8*0.,        
     7                                          -2.,  6.,  7., 1., 9*0.,        
     8                                               -1.,  2., 2.,10*0.,        
     9                                                    -5., 3.,11*0.,        
     A                                                         0.,13*0./        
C          DGRF h(n,m) for 1965:                                                
      DATA (H1DIM(I),I=1,144)/13*0.,                                            
     1    5776,-2016., -404., 148.,  19.,-11.,-61.,  7.,-22., 2., 3*0.,         
     2           114.,  240.,-269., 128.,100.,-27.,-12., 15., 1., 4*0.,         
     3                  -165., 13.,-126., 68., -2.,  9.,  7., 2., 5*0.,         
     4                        -269.,-97.,-32.,  6.,-16., -4., 6., 6*0.,         
     5                               81., -8., 26.,  4., -5.,-4., 7*0.,         
     6                                    -7.,-23., 24., 10., 0., 8*0.,         
     7                                        -12., -3., 10.,-2., 9*0.,         
     8                                             -17., -4., 3.,10*0.,         
     9                                                    1., 0.,11*0.,         
     A                                                       -6.,13*0./         
C          DGRF h(n,m) for 1970:                                                
      DATA (H1DIM(I),I=145,288)/ 13*0.,                                         
     1    5737.,-2047., -366., 167.,  26.,-12.,-70.,  7.,-21., 1., 3*0.,        
     2             25.,  251.,-266., 139.,100.,-27.,-15., 16., 1., 4*0.,        
     3                  -196.,  26.,-139., 72., -4.,  6.,  6., 3., 5*0.,        
     4                        -279., -91.,-37.,  8.,-17., -4., 4., 6*0.,        
     5                                83., -6., 23.,  6., -5.,-4., 7*0.,        
     6                                      1.,-23., 21., 10., 0., 8*0.,        
     7                                         -11., -6., 11.,-1., 9*0.,        
     8                                              -16., -2., 3.,10*0.,        
     9                                                     1., 1.,11*0.,        
     A                                                        -4.,13*0./        
C          DGRF h(n,m) for 1975:                                                
      DATA (H1DIM(I),I=289,432)/ 13*0.,                                         
     1    5675.,-2067., -333., 191.,  31.,-13.,-77.,  6.,-21., 1., 3*0.,        
     2            -68.,  262.,-265., 148., 99.,-26.,-16., 16., 1., 4*0.,        
     3                  -223.,  39.,-152., 75., -5.,  4.,  7., 3., 5*0.,        
     4                        -288., -83.,-41., 10.,-19., -4., 4., 6*0.,        
     5                                88., -4., 22.,  6., -5.,-4., 7*0.,        
     6                                     11.,-23., 18., 10.,-1., 8*0.,        
     7                                         -12.,-10., 11.,-1., 9*0.,        
     8                                              -17., -3., 3.,10*0.,        
     9                                                     1., 1.,11*0.,        
     A                                                        -5.,13*0./        
C          DGRF h(n,m) for 1980:                                                
      DATA (H1DIM(I),I=433,576)/ 13*0.,                                         
     1    5604.,-2129., -336., 212.,  46.,-15.,-82.,  7.,-21., 1., 3*0.,        
     2           -200.,  271.,-257., 150., 93.,-27.,-18., 16., 0., 4*0.,        
     3                  -252.,  53.,-151., 71., -5.,  4.,  9., 3., 5*0.,        
     4                        -297., -78.,-43., 16.,-22., -5., 6., 6*0.,        
     5                                92., -2., 18.,  9., -6.,-4., 7*0.,        
     6                                     17.,-23., 16.,  9., 0., 8*0.,        
     7                                         -10.,-13., 10.,-1., 9*0.,        
     8                                              -15., -6., 4.,10*0.,        
     9                                                     2., 0.,11*0.,        
     A                                                        -6.,13*0./        
C          Initial coefficients g0 (for extrapolation T>1985.0):                
      DATA G0/0.,                                                               
     1  -29877.,-2073., 1300., 937.,-215., 52., 75., 21.,  5.,-4., 2*0.,        
     1   -1903., 3045.,-2208., 780., 356., 65.,-61.,  6., 10.,-4., 3*0.,        
     2           1691., 1244., 363., 253., 50.,  2.,  0.,  1., 2., 4*0.,        
     3                   835.,-426., -94.,-186.,24.,-11.,-12.,-5., 5*0.,        
     4                         169.,-161.,  4., -6., -9.,  9.,-2., 6*0.,        
     5                               -48., 17.,  4.,  2., -3., 5., 7*0.,        
     6                                   -102.,  9.,  4., -1., 3., 8*0.,        
     7                                           0.,  4.,  7., 1., 9*0.,        
     8                                               -6.,  2., 2.,10*0.,        
     9                                                    -5., 3.,11*0.,        
     A                                                         0.,13*0./        
C          D_/Dtime coefficients gt (for extrapolation T>1985.0):               
      DATA GT/0.,                                                               
     1     23.2, -13.7,   5.1,  0.1,  1.3, 1.4, 0.2, 0.7, 0.0,0.0, 2*0.,        
     1     10.0,   3.4,  -4.6, -0.6,  0.1,-0.3,-0.6, 0.0, 0.0,0.0, 3*0.,        
     2             7.0,  -0.6, -7.8, -1.5, 1.7,-0.5, 0.3, 0.0,0.0, 4*0.,        
     3                    0.1, -1.4, -3.2, 0.6, 0.8, 0.4, 0.0,0.0, 5*0.,        
     4                         -6.8,  0.1, 0.0, 1.0,-0.3, 0.0,0.0, 6*0.,        
     5                               -0.1, 0.9, 0.4,-0.3, 0.0,0.0, 7*0.,        
     6                                     1.2,-0.5, 0.1, 0.0,0.0, 8*0.,        
     7                                         -0.1,-0.5, 0.0,0.0, 9*0.,        
     8                                              -0.8, 0.0,0.0,10*0.,        
     9                                                    0.0,0.0,11*0.,        
     A                                                        0.0,13*0./        
C          Initial coefficients h0 (for extrapolation T>1985.0):                
      DATA H0/13*0.,                                                            
     1    5497.,-2191., -312., 233.,  47.,-16.,-82.,  7.,-21., 1., 3*0.,        
     2           -309.,  284.,-250., 148., 90.,-26.,-21., 16., 0., 4*0.,        
     3                  -296.,  68.,-155., 69., -1.,  5.,  9., 3., 5*0.,        
     4                        -298., -75.,-50., 23.,-25., -5., 6., 6*0.,        
     5                                95., -4., 17., 11., -6.,-4., 7*0.,        
     6                                     20.,-21., 12.,  9., 0., 8*0.,        
     7                                          -6.,-16., 10.,-1., 9*0.,        
     8                                              -10., -6., 4.,10*0.,        
     9                                                     2., 0.,11*0.,        
     A                                                        -6.,13*0./        
C          D_/Dtime coefficients ht (for extrapolation T>1985.0):               
      DATA HT/13*0.,                                                            
     1    -24.5, -11.5,   5.3,  3.8,  0.1,-0.4, 0.2, 0.1, 0.0,0.0, 3*0.,        
     2           -20.2,   2.3,  2.2, -0.2,-1.1, 1.0,-1.0, 0.0,0.0, 4*0.,        
     3                  -10.8,  2.5, -0.1,-0.8, 1.1, 0.1, 0.0,0.0, 5*0.,        
     4                          0.9,  0.6,-2.3, 1.9,-0.8, 0.0,0.0, 6*0.,        
     5                                0.0,-0.5, 0.3, 0.2, 0.0,0.0, 7*0.,        
     6                                    -0.1, 0.2,-0.8, 0.0,0.0, 8*0.,        
     7                                          0.9,-0.1, 0.0,0.0, 9*0.,        
     8                                               1.3, 0.0,0.0,10*0.,        
     9                                                    0.0,0.0,11*0.,        
     A                                                        0.0,13*0./        
C                                                                               
C     SET CONSTANT VARIABLES FOR SUBPROGRAM SHELG                               
C                                                                               
      RMIN=0.05                                                                 
      RMAX=1.01                                                                 
      STEP=0.20                                                                 
      STEQ=0.03                                                                 
C                                                                               
C          Trap out of range date:                                              
      IF(DATE .LT. 1965.)  GO TO 9100                                           
      IF(DATE .GT. 1990.)WRITE(6,9200)                                          
C          Do not need to load new coefficients                                 
      IF (DATE .EQ. DATEL) RETURN                                               
      DATEL=DATE                                                                
      NMAX=10                                                                   
C     WRITE( JUNIT, "(' Order of IGRF model NMAX= 'I3)") NMAX                   
      TIME=DATE                                                                 
                                                                                
      IF    (DATE .LT. 1970.0)THEN                                              
        INT=1                                                                   
        EPOCH=1965.0                                                            
      ELSEIF(DATE .LT. 1975.0)THEN                                              
        INT=2                                                                   
        EPOCH=1970.0                                                            
      ELSEIF(DATE .LT. 1980.0)THEN                                              
        INT=3                                                                   
        EPOCH=1975.0                                                            
      ELSEIF(DATE .LT. 1985.0)THEN                                              
        INT=4                                                                   
        EPOCH=1980.0                                                            
      ELSE                                                                      
        INT=5                                                                   
        EPOCH=1985.0                                                            
      ENDIF                                                                     
      IS=0                                                                      
      T=TIME-EPOCH                                                              
      G(1)=0.0                                                                  
      I=2                                                                       
      F0=1.0D-5                                                                 
      IF (IS) 5,4,5                                                             
    4 F0=-F0                                                                    
    5 DO 9 N=1,NMAX                                                             
      FN=N                                                                      
      F0=F0*FN*FN/(4.0*FN-2.0)                                                  
      IF (IS) 502,501,502                                                       
  501 F0=F0*(2.0*FN-1.0)/FN                                                     
  502 F=F0*0.5                                                                  
      IF (IS) 6,503,6                                                           
  503 F=F*SQRT(2.0)                                                             
    6 NN=N+1                                                                    
      MM=1                                                                      
      IF (INT.EQ.5)THEN            ! (extrapolate coeff's)                      
        G(I)=((GTT(NN,MM)*T+GT(NN,MM))*T+G0(NN,MM))*F0                          
      ELSE                         ! (interpolate coeff's)                      
        G(I)=(GYR(NN,MM,INT)+T/5.0*(GYR(NN,MM,INT+1)-GYR(NN,MM,INT)))           
     +                                                           *F0            
      ENDIF                                                                     
      I=I+1                                                                     
      DO 9 M=1,N                                                                
      TMP1=N+M                                                                  
      TMP2=N-M+1                                                                
      F=F*TMP1/TMP2                                                             
      IF (IS) 602,601,602                                                       
  601 F=F*SQRT(TMP2/TMP1)                                                       
  602 NN=N+1                                                                    
      MM=M+1                                                                    
      I1=I+1                                                                    
      IF (INT .EQ. 5)THEN      ! (extrapolate coeff's)                          
        G(I) =((GTT(NN,MM)*T+GT(NN,MM))*T+G0(NN,MM))*F                          
        G(I1)=((HTT(NN,MM)*T+HT(NN,MM))*T+H0(NN,MM))*F                          
      ELSE                     ! (interpolate coeff's)                          
        G(I) =(GYR(NN,MM,INT)+T/5.0*(GYR(NN,MM,INT+1)-GYR(NN,MM,INT)))*F        
        G(I1)=(HYR(NN,MM,INT)+T/5.0*(HYR(NN,MM,INT+1)-HYR(NN,MM,INT)))*F        
      ENDIF                                                                     
    9 I=I+2                                                                     
      IF(IDPOLE.EQ.1)THEN
C     ****     SET ALL BUT DIPOLE COEFFICIENTS TO ZERO
	G(1) = 0.
	DO 10 I = 5,144
	  G(I) = 0.
   10   CONTINUE
      ENDIF
C      COMPUTE GEOGRAPHIC COLATITUDE AND LONGITUDE OF THE NORTH POLE OF         
C      EARTH CENTERED DIPOLE                                                    
C**********************
      COLAT = ACOS(GG(2,1)/SQRT(GG(2,1)**2+GG(3,1)**2+GG(4,1)**2))
     1 *RTOD
      WLON = ATAN2(GG(4,1),GG(3,1))*RTOD
C      IF (GG(2,1)+GG(4,1) .NE. GG(4,1)) THEN
C       COLAT = ATAN(SQRT((GG(3,1)**2+GG(4,1)**2)/GG(2,1)**2))*RTOD
C       COLAT = ATAN2(SQRT(GG(3,1)**2+GG(4,1)**2),GG(2,1)**2)*RTOD
C
C      ELSE
C        COLAT = 90.
C      END IF
C      IF (GG(3,1)+GG(4,1) .NE. GG(4,1)) THEN
C        WLON = ATAN(GG(4,1)/GG(3,1))*RTOD
C        WLON = ATAN2(GG(4,1),GG(3,1))*RTOD
C
C     ELSE
C        WLON = 90.
C      END IF
C**********************
       PRINT *, ' MAGNETIC POLE  ', COLAT,WLON
       RETURN                                                                   
C          Error trap diagnostics:                                              
 9100 WRITE(6,"('0Requested year ',F8.3,' preceeds IGRF/DGRF ',                 
     +                          'coefficients presently coded.  See',/,         
     +          ' subroutine COFRM for modifications.')")DATE                   
      STOP 'mor cod'                                                            
 9200 FORMAT('0Warning:  IGRF model coefficients are extrapolated from',        
     +                                      ' 1985.')                           
      END                                                                       
       SUBROUTINE LINAPX(GDLAT, GLON, H0,HREF)
      SAVE
C***BEGIN PROLOGUE  LINAPX                                                      
C***DATE WRITTEN   731029   (YYMMDD)                                            
C***REVISION DATE  880201   (YYMMDD)                                            
C***AUTHOR  CLARK, W., N.O.A.A. ERL LAB.                                        
C***PURPOSE  Transforms the geographic coordinates to apex coordinates.         
C***DESCRIPTION                                                                 
C     The method used is as follow:                                             
C       1. Calculates step size as a function of the geomagnetic                
C          dipole coordinates of the starting point.                            
C       2. Determine direction of trace                                         
C       3. Convert the geodetic coordinates of the starting point               
C          to the cartesian coordinates for tracing.                            
C       Loop:                                                                   
C       i)   Increment step count, if count > 200,                              
C            assume it is dipole field, call DPLFLD to                          
C            determine Apex coordinates else continue.                          
C       ii)  Get field components in X, Y and Z direction                       
C       iii) Call ITRACE to trace field line.                                   
C       iv)  Test if Apex passed call FNDAPX to determine Apex coordinates      
C            else loop:                                                         
C                                                                               
C   INPUT                                                                       
C     GDLAT  Latitude of starting point (Deg)                                   
C     GLON   Longitude (East=+) of starting point (Deg)                         
C     ALT    Ht. of starting point (Km)                                         
C                                                                               
C     COMMON Blocks Used                                                        
C     /APXIN/ YAPX(3,3)                                                         
C       YAPX    Matrix of cartesian coordinates (loaded columnwise)             
C               of the 3 points about APEX. Set in subprogram ITRACE.           
C                                                                               
C    /APXOUT/ A,ALAT,ALON,BMAG                                                  
C          A  Apex radius (Km)                                                  
C       ALAT  Apex Lat. (Deg)                                                   
C       ALON  Apex Lon. (Deg)                                                   
C       BMAG  Magnitude of the field at the starting point                      
C                                                                               
C                                                                               
C    /CONST/ RTOD,DTOR,RE,REQ,COLAT,WLON                                        
C     RTOD    Unit to convert radian to degrees, 45./ATAN(1.).                  
C     DTOR    Unit to convert degrees to radians ATAN(1.)/45.                   
C     RE      Radius of the earth, 6371.2 (Km).                                 
C     REQ     Equatorial radius, 6378.165.                                      
C     COLAT   Geographic colatitude of the north pole of the                    
C             earth-centered dipole (Deg).                                      
C     WLON    Geographic longitude of the north pole of the                     
C             earth-centered dipole (Deg).                                      
C                                                                               
C     /ITRA/ NSTP, Y(3), YOLD(3), SGN, DS                                       
C     NSTP      Step count. Incremented in subprogram LINAPX.                   
C     Y         Array containing current tracing point cartesian coordinates.   
C     YOLD      Array containing previous tracing point cartesian coordinates.  
C     SGN       Determines direction of trace. Set in subprogram LINAPX         
C     DS        Step size (Km) Computed in subprogram LINAPX.                   
C                                                                               
C     /FLDCOMD/ BX, BY, BZ, BB                                                  
C     BX        X comp. of field vector at the current tracing point (Gauss)    
C     BY        Y comp. of field vector at the current tracing point (Gauss)    
C     BZ        Z comp. of field vector at the current tracing point (Gauss)    
C     BB        Magnitude of field vector at the current tracing point (Gauss)  
C                                                                               
C     /MAG  / ICODE,XI(3),H(144),DUM1(2,40),NAME(4),NMAX,TIME,G(144),DUM2(4)    
C     ICODE   Flag set in STOER subprogram.                                     
C     XI      Work array used in subprograms FELDG, SHELG and STOER             
C     H       Work array used in subprogram FELDG , SHELG and STOER             
C     DUM1    Work array used in SHELG and STOER.                               
C     NAME    Not being used any more , used in old version of COFRM            
C     NMAX    Order of IGRF model set in COFRM subprogram                       
C     TIME    Equal to input argument DATE in COFRM routine.                    
C     G       Array of spherical harmonic coefficients for given                
C             date derived in COFRM subprogram.                                 
C     DUM2    Array of numbers set in COFRM routine and used in STOER           
C                                                                               
C***REFERENCES  Stassinopoulos E. G. , Mead Gilbert D., X-841-72-17             
C                 (1971) GSFC, Greenbelt, Maryland                              
C                                                                               
C***ROUTINES CALLED  TRSK1,FELDGC,FELDG                                         
C                    ITRACE,DPLFLD,FNDAPX                                       
C***COMMON BLOCKS    APXIN,APXOUT,ITRA                                          
C                    FLDCOMD,MAG                                                
C                                                                               
C***END PROLOGUE  LINAPX                                                        
       PARAMETER ( MAXS = 200 )
       COMMON /FLDCOMD/ BX, BY, BZ, BB                                          
       COMMON/APXOUT/A,ALAT,ALON,XMAG,YMAG,ZMAG,F,GMLAT,DMAG
       COMMON /APXIN/ YAPX(3,3)                                                 
       COMMON / CONST / RTOD,DTOR,RE,REQ,COLAT,WLON                             
       COMMON /ITRA/ NSTP, Y(3), YP(3),  SGN, DS                                
       COMMON/MAG/IDUM1,DUM1(307),NAME(4),IDUM,XDUM,G(12,12),                   
     +           RMIN,RMAX,STEP,STEQ                                            
       DIMENSION Z(3)                                                           
C                                                                               
C **   CONVERT TO GEOCENTRIC COORDINATES FOR TRACING                            
C **                                                                            
       CALL CONVRT(1, GDLAT, HREF, GCLAT, R)
C                                                                               
C **   DETERMINE STEP SIZE AS A FUNCTION OF GEOMAGNETIC DIPOLE COORDINATES      
C      OF THE STARTING POINT                                                    
C **                                                                            
C      COMPUTE GEOGRAPHIC LONGITUDE OF THE NORTH POLE OF                        
C      EARTH CENTERED DIPOLE                                                    
C**********************
C      IF ( (G(3,1)+G(4,1)) .NE. G(4,1) ) THEN
C       WLON=ATAN2(G(4,1),G(3,1))*RTOD
C      ELSE
C       WLON = 90.
C      ENDIF
C**********************
       SINGML = .98*SIN(GCLAT*DTOR) + .199*COS(GCLAT*DTOR)*                     
     $  COS((GLON+WLON)*DTOR)                                                   
       DS = .06*R/(1.-SINGML*SINGML) - 370.                                     
       IF (DS .GT. 3000.) DS = 3000.                                            
C     Initialize YAPX array                                                     
       DO 4 J = 1,3                                                             
       DO 4 I =1,3                                                              
        YAPX(I,J) = 0.                                                          
4      CONTINUE                                                                 
C     Convert from geodetic to earth centered cartesian coordinates             
	  CALL TRSK1( GDLAT*DTOR, GLON*DTOR, HREF,Y(1),Y(2),Y(3))
       NSTP = 0                                                                 
C                                                                               
C **   GET FIELD COMPONENTS TO DETERMINE THE DIRECTION OF TRACING               
C      THE FIELD LINE                                                           
C **                                                                            
C                                                                               
       CALL FELDGC(GCLAT,GLON,R,BR,BT,BP,B)                                     
       IF (NSTP .EQ. 0) SGN = SIGN(1.,BR)                                       
C                                                                               
   10  CONTINUE                                                                 
C **   GET FIELD COMPONENTS AND TRACE ALONG FIELD LINE                          
C***********************
C         Z(1) = SQRT( Y(1)**2+Y(2)**2+Y(3)**2)
C         Z(2) = RTOD*ATAN2(Y(3),SQRT(Y(1)**2+Y(2)**2))
C         Z(3) = RTOD*ATAN2(Y(2),Y(1))
C         CALL CONVRT(2,GZ2,GZ1,Z(2),Z(1))
C         IENTRY=1
C         CALL FELDG(IENTRY,GZ2,Z(3),GZ1,BN,BE,BV,F)
C         WRITE(6,100)(Z(I),I=1,3),BN,BE,BV,F
C 100     FORMAT(7E12.4)
C***********************
       IENTRY=2                                                                 
       CALL FELDG(IENTRY,Y(1)/RE,Y(2)/RE,Y(3)/RE,BX,BY,BZ,BB)                   
C                                                                               
       NSTP = NSTP + 1                                                          
C                                                                               
C **   QUIT IF TOO MANY STEPS                                                   
C **                                                                            
       IF (NSTP .GE. MAXS) THEN                                                 
C***************
	  Z(2) = RTOD*ATAN2(YAPX(3,2),SQRT(YAPX(1,2)**2+YAPX(2,2)**2))
	  IF ( Z(2) .NE. 90. ) THEN
	  Z(1) = SQRT( YAPX(1,2)**2+YAPX(2,2)**2+YAPX(3,2)**2)
	  Z(3) = RTOD*ATAN2(YAPX(2,2),YAPX(1,2))
C         Z(2) = RTOD*ATAN2(Y(3),SQRT(Y(1)**2+Y(2)**2))
C         IF ( Z(2) .NE. 90. ) THEN
C         Z(1) = SQRT( Y(1)**2+Y(2)**2+Y(3)**2)
C         Z(3) = RTOD*ATAN2(Y(2),Y(1))
          ELSE                                                                  
C         START TRACING FROM PREVIOUS POINT                                     
	  Z(2) = RTOD*ATAN2(YAPX(3,1),SQRT(YAPX(1,1)**2+YAPX(2,1)**2))
	  Z(1) = SQRT( YAPX(1,1)**2+YAPX(2,1)**2+YAPX(3,1)**2)
	  Z(3) = RTOD*ATAN2(YAPX(2,1),YAPX(1,1))
C         Z(1) = SQRT( YP(1)**2+YP(2)**2+YP(3)**2)
C         Z(2) = RTOD*ATAN2(YP(3),SQRT(YP(1)**2+YP(2)**2))
C         Z(2) = RTOD*ASIN(YP(3)/Z(1))
C         Z(3) = RTOD*ATAN2(YP(2),YP(1))
          ENDIF                                                                 
C***************
          Y(1) = Z(1)                                                           
          Y(2) = Z(2)                                                           
          Y(3) = Z(3)                                                           
	 CALL DPLFLD(Y(1), Y(2), Y(3),GDLAT,GLON,H0,HREF)
         RETURN                                                                 
C                                                                               
       END IF                                                                   
C                                                                               
C **   FIND NEXT POINT USING ADAMS ALGORITHM AFTER 7 POINTS                     
C **                                                                            
       CALL ITRACE( IAPX)                                                       
C                                                                               
C                                                                               
       GO TO (10, 20) IAPX                                                      
C                                                                               
C **    MAXIMUM RADIUS JUST PASSED.  FIND APEX COORDS                           
C **                                                                            
   20  CONTINUE                                                                 
C                                                                               
C      CONVERT CARTESIAN COORDINATES TO GEOCENTRIC COORDINATES                  
C                                                                               
C**********************
C      DO 25 I =1,3
C       Z(1) = SQRT( YAPX(1,I)**2+YAPX(2,I)**2+YAPX(3,I)**2)
C       Z(2) = RTOD*ATAN2(YAPX(3,I),SQRT(YAPX(1,I)**2+YAPX(2,I)**2))
C       Z(2) = RTOD*ASIN(YAPX(3,I)/Z(1))
C       Z(3) = RTOD*ATAN2(YAPX(2,I),YAPX(1,I))
C       DO 24 J = 1,3
C         YAPX(J,I) = Z(J)
C  24   CONTINUE
C  25   CONTINUE
C**********************
       CALL FNDAPX(GDLAT, GLON, H0,HREF)
       RETURN                                                                   
C                                                                               
       END
       SUBROUTINE ITRACE( IAPX)                                                 
      SAVE
C***BEGIN PROLOGUE  ITRACE                                                      
C***DATE WRITTEN   731029   (YYMMDD)                                            
C***REVISION DATE  880201   (YYMMDD)                                            
C***AUTHOR  CLARK, W. N.O.A.A. ERL LAB.                                         
C***PURPOSE  Field line integration routine.                                    
C***DESCRIPTION                                                                 
C     It uses 4-point ADAMS formula after initialization.                       
C     First 7 iterations advance point by 3 steps.                              
C                                                                               
C   INPUT                                                                       
C            Passed in through the common blocks ITRA, FLDCOMD.                 
C            See the description below.                                         
C   OUTPUT                                                                      
C    IAPX    Flag set to 2 when APEX passed, otherwise set to 1.                
C                                                                               
C            Passed out through the common block APXIN.                         
C            See the description below.                                         
C                                                                               
C     COMMON Blocks Used                                                        
C     /APXIN/ YAPX(3,3)                                                         
C     YAPX      Matrix of cartesian coordinates (loaded columnwise)             
C               of the 3 points about APEX. Set in subprogram ITRACE.           
C                                                                               
C     /FLDCOMD/ BX, BY, BZ, BB                                                  
C     BX        X comp. of field vector at the current tracing point (Gauss)    
C     BY        Y comp. of field vector at the current tracing point (Gauss)    
C     BZ        Z comp. of field vector at the current tracing point (Gauss)    
C     BB        Magnitude of field vector at the current tracing point (Gauss)  
C                                                                               
C     /ITRA/ NSTP, Y(3), YOLD(3), SGN, DS                                       
C     NSTP      Step count for line integration.                                
C               Incremented in subprogram LINAPX.                               
C     Y         Array containing current tracing point cartesian coordinates.   
C     YOLD      Array containing previous tracing point cartesian coordinates.  
C     SGN       Determines direction of trace. Set in subprogram LINAPX         
C     DS        Integration step size (arc length Km)                           
C               Computed in subprogram LINAPX.                                  
C                                                                               
C***REFERENCES  reference 1                                                     
C                                                                               
C***ROUTINES CALLED  None                                                       
C***COMMON BLOCKS    APXIN,FLDCOMD,ITRA                                         
C***END PROLOGUE  ITRACE                                                        
C **                                                                            
       COMMON /ITRA/ NSTP, Y(3), YOLD(3), SGN, DS                               
       COMMON /FLDCOMD/ BX, BY, BZ, BB                                          
       COMMON /APXIN/ YAPX(3,3)                                                 
       DIMENSION  YP(3, 4)                                                      
C      Statement function                                                       
       RDUS(D,E,F) = SQRT( D**2 + E**2 + F**2 )                                 
C                                                                               
       IAPX = 1                                                                 
C      Field line is defined by the following differential equations            
C      in cartesian coordinates:                                                
       YP(1, 4) = SGN*BX/BB                                                     
       YP(2, 4) = SGN*BY/BB                                                     
       YP(3, 4) = SGN*BZ/BB                                                     
       IF (NSTP .GT. 7) GO TO 90                                                
C **  FIRST SEVEN STEPS USE THIS BLOCK                                          
       DO 80 I = 1, 3                                                           
         GO TO (10, 20, 30, 40, 50, 60, 70) NSTP                                
C                                                                               
   10   D2 = DS/2.                                                              
         D6 = DS/6.                                                             
         D12 = DS/12.                                                           
         D24 = DS/24.                                                           
         YP(I, 1) = YP(I, 4)                                                    
         YOLD(I) = Y(I)                                                         
         YAPX(I, 1) = Y(I)                                                      
         Y(I) = YOLD(I) + DS*YP(I, 1)                                           
         GO TO 80                                                               
C                                                                               
   20   YP(I, 2) = YP(I, 4)                                                     
         Y(I) = YOLD(I) + D2*(YP(I,2)+YP(I,1))                                  
         GO TO 80                                                               
C                                                                               
   30   Y(I) = YOLD(I) + D6*(2.*YP(I,4)+YP(I,2)+3.*YP(I,1))                     
         GO TO 80                                                               
C                                                                               
   40   YP(I, 2) = YP(I, 4)                                                     
         YAPX(I, 2) = Y(I)                                                      
         YOLD(I) = Y(I)                                                         
         Y(I) = YOLD(I) + D2*(3.*YP(I,2)-YP(I,1))                               
         GO TO 80                                                               
C                                                                               
  50   Y(I) = YOLD(I) + D12*(5.*YP(I,4)+8.*YP(I,2)-YP(I,1))                     
         GO TO 80                                                               
C                                                                               
   60   YP(I, 3) = YP(I, 4)                                                     
         YOLD(I) = Y(I)                                                         
         YAPX(I, 3) = Y(I)                                                      
         Y(I) = YOLD(I) + D12*(23.*YP(I,3)-16.*YP(I,2)+5.*YP(I,1))              
         GO TO 80                                                               
C                                                                               
   70  YAPX(I, 1) = YAPX(I, 2)                                                  
        YAPX(I, 2) = YAPX(I, 3)                                                 
        Y(I) = YOLD(I) + D24*(9.*YP(I,4)+19.*YP(I,3)-5.*YP(I,2)+YP(I,1))        
         YAPX(I, 3) = Y(I)                                                      
   80 CONTINUE                                                                  
C   **   SIGNAL IF APEX PASSED                                                  
       IF ( NSTP .EQ. 6 .OR. NSTP .EQ. 7) THEN                                  
        RC = RDUS( YAPX(1,3), YAPX(2,3), YAPX(3,3))                             
        RP = RDUS( YAPX(1,2), YAPX(2,2), YAPX(3,2))                             
        IF ( RC .LT. RP) IAPX=2                                                 
       ENDIF                                                                    
       RETURN                                                                   
C                                                                               
C **   STEPPING BLOCK FOR NSTEP .GT. 7                                          
   90 DO 110 I = 1, 3                                                           
         YAPX(I, 1) = YAPX(I, 2)                                                
         YAPX(I, 2) = Y(I)                                                      
         YOLD(I) = Y(I)                                                         
         TERM = 55.*YP(I, 4) - 59.*YP(I, 3) + 37.*YP(I, 2) - 9.*YP(I, 1)        
         Y(I) = YOLD(I) + D24*TERM                                              
         YAPX(I, 3) = Y(I)                                                      
         DO 100 J = 1, 3                                                        
           YP(I, J) = YP(I, J+1)                                                
  100   CONTINUE                                                                
  110 CONTINUE                                                                  
        RC =RDUS( Y(1), Y(2), Y(3))                                             
        RP = RDUS( YOLD(1), YOLD(2), YOLD(3))                                   
        IF ( RC .LT. RP) IAPX=2                                                 
       RETURN                                                                   
C                                                                               
       END                                                                      
C     /** TRSK1 **                                                              
      SUBROUTINE TRSK1 (PLT,PLN,PHT,X,Y,Z)                                      
      SAVE
C***BEGIN PROLOGUE  TRSK1                                                       
C***DATE WRITTEN   830415   (YYMMDD)                                            
C***REVISION DATE  880201   (YYMMDD)                                            
C***AUTHOR  WICKWAR, VINCENT B., SRI INTL.                                      
C***PURPOSE  Transform geodetic latitude, longitude, and height                 
C            to geocentric X, Y, Z  (X to greenwich meridian, Y 90 deg east)    
C***DESCRIPTION                                                                 
C                                                                               
C                                                                               
C   INPUT                                                                       
C     PLT    Geodetic lat. of point (Rad)                                       
C     PLN    Geodetic lon. (east=+) of point (Rad)                              
C     PHT    Height of point (Km)                                               
C   OUTPUT                                                                      
C     X      Geocentric cartesian X coordinate (Km)                             
C     Y      Geocentric cartesian Y coordinate (Km)                             
C     X      Geocentric cartesian Z coordinate (Km)                             
C***LONG DESCRIPTION                                                            
C                                                                               
C                                                                               
C     COMMON Block Used                                                         
C                                                                               
C***REFERENCES  Clark spheroid of 1866                                          
C                                                                               
C***ROUTINES CALLED  None                                                       
C***COMMON BLOCKS    None                                                       
C***END PROLOGUE  TRSK1                                                         
      FTKM=0.3048E-3                                                            
      A = 20925874.05 * FTKM                                                    
      B = 20854933.76 * FTKM                                                    
      A2 = A*A                                                                  
      B2 = B*B                                                                  
      EP2 = (A2 - B2) / A2                                                      
      EP = SQRT (EP2)                                                           
      CPLT = COS (PLT)                                                          
      SPLT = SIN (PLT)                                                          
      CPLN = COS (PLN)                                                          
      SPLN = SIN (PLN)                                                          
      TMP1 = SQRT (1.0 - EP2*SPLT*SPLT)                                         
      X = A * CPLT * CPLN / TMP1 + PHT * CPLT * CPLN                            
      Y = A * CPLT * SPLN / TMP1 + PHT * CPLT * SPLN                            
      Z = A * (1.0 - EP2) * SPLT / TMP1 + PHT * SPLT                            
      RETURN                                                                    
      END                                                                       
       SUBROUTINE FELDGC(DLAT, DLONG, R, BR,BT,BP,F)                            
      SAVE
C***BEGIN PROLOGUE  FELDGC                                                      
C***DATE WRITTEN   880201   (YYMMDD)                                            
C***REVISION DATE  880201   (YYMMDD)                                            
C***AUTHOR  PASSI, HARSH ANAND, NCAR BOULDER                                    
C***PURPOSE  Computes magnetic field comps. at geocentric spherical             
C            point.                                                             
C***DESCRIPTION                                                                 
C                                                                               
C   INPUT                                                                       
C     DLAT   Geocentric Lat. (Deg)                                              
C     DLONG  Geocentric Lon. (Deg)                                              
C     R      Geocentric distance (Km)                                           
C   OUTPUT                                                                      
C     BR     Radial component of field vector positive outward (gauss)          
C     BT     Component of field vector along colat. increasing                  
C            positive southward (gauss)                                         
C     BP     Component of field vector along lon. increasing                    
C            positive eastward (gauss)                                          
C     F      Magnitude of field vector (Gauss)                                  
C                                                                               
C***LONG DESCRIPTION                                                            
C                                                                               
C   Common blocks used                                                          
C                                                                               
C    /CONST/ RTOD,DTOR,RE,REQ,COLAT,WLON                                        
C     RTOD    Unit to convert radian to degrees, 45./ATAN(1.).                  
C     DTOR    Unit to convert degrees to radians ATAN(1.)/45.                   
C     RE      Radius of the earth, 6371.2 (Km).                                 
C     REQ     Equatorial radius, 6378.165.                                      
C     COLAT   Geographic colatitude of the north pole of the                    
C             earth-centered dipole (Deg).                                      
C     WLON    Geographic longitude of the north pole of the                     
C             earth-centered dipole (Deg).                                      
C***REFERENCES  NASA DATA USER'S NOTE MAY 1968                                  
C***ROUTINES CALLED  FELDG                                                      
C***COMMON BLOCKS   CONST                                                       
C***END PROLOGUE  FELDGC                                                        
       COMMON / CONST / RTOD,DTOR,RE,REQ,COLAT,WLON                             
C **  LOAD CONSTANTS FOR ELLIPSOID                                              
C **                                                                            
         FLAT = 1. - (1./298.25)                                                
         A2 = REQ*REQ                                                           
         A4 = A2*A2                                                             
         FLSQ = FLAT*FLAT                                                       
         B2 = A2*FLSQ                                                           
         A2B2 = A2*(1.-FLSQ)                                                    
         A4B4 = A4*(1.-(FLSQ*FLSQ))                                             
C                                                                               
C                                                                               
C **  PREPARE LOCATION PARAMETERS                                               
C **                                                                            
       CALL CONVRT (2, GDLAT,ALT,DLAT,R)                                        
       SINLA = SIN(GDLAT*DTOR)                                                  
       RLONG = DLONG*DTOR                                                       
       CPH = COS(RLONG)                                                         
       SPH = SIN(RLONG)                                                         
C                                                                               
C   **        EARTH IS OBLATE                                                   
C   **                                                                          
         SINLA2 = SINLA*SINLA                                                   
         COSLA2 = 1. - SINLA2                                                   
         DEN2 = A2 - A2B2*SINLA2                                                
         DEN = SQRT(DEN2)                                                       
         RHO = ALT*DEN                                                          
         FAC = ((RHO+A2)/(RHO+B2))*((RHO+A2)/(RHO+B2))                          
         CT = SINLA/SQRT(FAC*COSLA2+SINLA2)                                     
         RR = SQRT(ALT*(ALT+2.*DEN)+(A4-A4B4*SINLA2)/DEN2)                      
C                                                                               
C                                                                               
C **  GET MAGNETIC FIELD IN GEOCENTRIC COORDS                                   
C **                                                                            
      ST = SQRT(1-(CT*CT))                                                      
C     Get field components for the geodetic point                               
      IENTRY = 1                                                                
       CALL FELDG(IENTRY,GDLAT,DLONG,ALT,BN,BE,BV,F)                            
C                                                                               
C **   TRANSFORMS FIELD TO GEOCENTRIC DIRECTIONS                                
C **                                                                            
       BP = BE                                                                  
       SIND = SINLA*ST - SQRT(COSLA2)*CT                                        
       COSD = SQRT(1.-(SIND*SIND))                                              
       BR = -BN*SIND - BV*COSD                                                  
       BT = -BN*COSD + BV*SIND                                                  
       RETURN                                                                   
       END                                                                      
C                                                                               
       SUBROUTINE FELDG(IENTY,GLAT,GLON,ALT,BNRTH,BEAST,BDOWN,BABS)             
      SAVE
C***BEGIN PROLOGUE  FELDG                                                       
C***DATE WRITTEN   830415   (YYMMDD)                                            
C***REVISION DATE  880201   (YYMMDD)                                            
C***AUTHOR  Wickwar, Vincent B., SRI INT.                                       
C***PURPOSE  It computes the DGRF/IGRF coeffs. at the point GLAT,               
C            GLON,ALT. COFRM must be called to establish coeffs                 
C            G (array) for correct date prior to calling FELDG.                 
C***DESCRIPTION                                                                 
C                                                                               
C   INPUT                                                                       
C     IENTY  If IENTY=1, (GLAT,GLON,ALT) Geodetic coordinates                   
C            If IENTY=2, (GLAT,GLON,ALT) Earth centered cartesian               
C                        coordinates                                            
C            If IENTY=3, Entry point used for L computation.                    
C   INPUT IF IENTY=1                                                            
C     GLAT   LATITUDE OF POINT (DEG)                                            
C     GLON   LONGITUDE (EAST=+) OF POINT (DEG)                                  
C     ALT    HT OF POINT (KM)                                                   
C   OUTPUT IF IENTY=1                                                           
C     BNRTH  NORTH COMPONENT OF FIELD VECTOR (Gauss)                            
C     BEAST  EAST COMPONENT OF FIELD VECTOR   (Gauss)                           
C     BDOWN  DOWNWARD COMPONENT OF FIELD VECTOR (Gauss)                         
C     BABS   MAGNITUDE OF FIELD VECTOR (Gauss)                                  
C   INPUT IF IENTY=2                                                            
C     GLAT   X coordinate (in units of earth radii 6371.2 km )                  
C     GLON   Y coordinate (in units of earth radii 6371.2 km )                  
C     ALT    Z coordinate (in units of earth radii 6371.2 km )                  
C   OUTPUT IF IENTY=2                                                           
C     BNRTH  X COMPONENT OF FIELD VECTOR (Gauss)                                
C     BEAST  Y COMPONENT OF FIELD VECTOR   (Gauss)                              
C     BDOWN  Z COMPONENT OF FIELD VECTOR (Gauss)                                
C     BABS   MAGNITUDE OF FIELD VECTOR (Gauss)                                  
C                                                                               
C   INPUT IF IENTY=3                                                            
C     GLAT   .Dummy arg                                                         
C     GLON   Dummy arg                                                          
C     ALT    Dummy arg                                                          
C   OUTPUT IF IENTY=3                                                           
C            Passed through the common block MAG.                               
C            See the description below.                                         
C***LONG DESCRIPTION                                                            
C                                                                               
C     COMMON Block Used                                                         
C     /MAG  / ICODE,XI(3),H(144),DUM1(2,40),NAME(4),NMAX,TIME,G(144),DUM2(4)    
C     ICODE   Flag set in STOER subprogram.                                     
C     XI      Work array used in subprograms FELDG, SHELG and STOER             
C             Also used for communication.                                      
C     H       Work array used in subprogram FELDG , SHELG and STOER             
C             Also used for communication.                                      
C     DUM1    Work array used in SHELG and STOER.                               
C     NAME    Not being used any more , used in old version of COFRM            
C     NMAX    Order of IGRF model set in COFRM subprogram                       
C     TIME    Equal to input argument DATE in COFRM routine.                    
C     G       Array of spherical harmonic coefficients for given                
C             date derived in COFRM subprogram.                                 
C     DUM2    Array of numbers set in COFRM routine and used in STOER           
C                                                                               
C    /CONST/ RTOD,DTOR,RE,REQ,COLAT,WLON                                        
C     RTOD    Unit to convert radian to degrees, 45./ATAN(1.).                  
C     DTOR    Unit to convert degrees to radians ATAN(1.)/45.                   
C     RE      Radius of the earth, 6371.2 (Km).                                 
C     REQ     Equatorial radius, 6378.165.                                      
C     COLAT   Geographic colatitude of the north pole of the                    
C             earth-centered dipole (Deg).                                      
C     WLON    Geographic longitude of the north pole of the                     
C             earth-centered dipole (Deg).                                      
C***REFERENCES  reference 1                                                     
C                 continuation of reference 1                                   
C                                                                               
C***ROUTINES CALLED  None                                                       
C***COMMON BLOCKS    MAG                                                        
C***END PROLOGUE  FELDG                                                         
      COMMON/MAG/ICODE,XI(3),H(144),DUM1(8,20),NAME(4),                         
     +              NMAX,TIME,G(144),DUM2(4)                                    
      COMMON / CONST / RTOD,DTOR,RE,REQ,COLAT,WLON                              
      DIMENSION  V(3),B(3)                                                      
                                                                                
      GO TO(100,200,300), IENTY                                                 
  100 CONTINUE                                                                  
      IS=1                                                                      
      RLAT = GLAT*DTOR                                                          
      CT   = SIN(RLAT)                                                          
      ST   = COS(RLAT)                                                          
      D    = SQRT(40680925.E0-272336.E0*CT**2)                                  
      RLON = GLON*DTOR                                                          
      CP   = COS(RLON)                                                          
      SP   = SIN(RLON)                                                          
      ZZZ  = (ALT+40408589.E0/D)*CT/RE                                          
      RHO  = (ALT+40680925.E0/D)*ST/RE                                          
      XXX  = RHO*CP                                                             
      YYY  = RHO*SP                                                             
      GO TO 10                                                                  
C     ENTRY FELDC                                                               
  200 CONTINUE                                                                  
C*****ENTRY POINT  FELDC  TO BE USED WITH CARTESIAN CO-ORDINATES                
      IS   = 2                                                                  
      XXX  = GLAT                                                               
      V(1) = GLAT                                                               
      YYY  = GLON                                                               
      V(2) = GLON                                                               
      ZZZ  = ALT                                                                
      V(3) = ALT                                                                
10    RQ    = 1./(XXX**2+YYY**2+ZZZ**2)                                         
      XI(1) = XXX*RQ                                                            
      XI(2) = YYY*RQ                                                            
      XI(3) = ZZZ*RQ                                                            
      GO TO 20                                                                  
C     ENTRY FELDI                                                               
  300 CONTINUE                                                                  
C*****ENTRY POINT  FELDI  USED FOR L COMPUTATION                                
      IS = 3                                                                    
20    IHMAX = NMAX*NMAX+1                                                       
      LAST  = IHMAX+NMAX+NMAX                                                   
      IMAX  = NMAX+NMAX-1                                                       
      DO 8 I=IHMAX,LAST                                                         
    8 H(I) = G(I)                                                               
      MK = 3                                                                    
      IF ( IMAX .EQ. 1) MK=1                                                    
      DO 6 K=1,MK,2                                                             
      I  = IMAX                                                                 
      IH = IHMAX                                                                
    1 IL = IH-I                                                                 
      F = 2./FLOAT(I-K+2)                                                       
      X = XI(1)*F                                                               
      Y = XI(2)*F                                                               
      Z = XI(3)*(F+F)                                                           
      I = I-2                                                                   
      IF(I-1)5,4,2                                                              
    2 DO 3 M=3,I,2                                                              
      IHM = IH+M                                                                
      ILM = IL+M                                                                
      H(ILM+1) = G(ILM+1)+ Z*H(IHM+1) + X*(H(IHM+3)-H(IHM-1))                   
     +                                        -Y*(H(IHM+2)+H(IHM-2))            
    3 H(ILM)   = G(ILM)  + Z*H(IHM)   + X*(H(IHM+2)-H(IHM-2))                   
     +                                        +Y*(H(IHM+3)+H(IHM-1))            
    4 H(IL+2) = G(IL+2) + Z*H(IH+2) + X*H(IH+4) - Y*(H(IH+3)+H(IH))             
      H(IL+1) = G(IL+1) + Z*H(IH+1) + Y*H(IH+4) + X*(H(IH+3)-H(IH))             
    5 H(IL)   = G(IL)   + Z*H(IH)   + 2.*(X*H(IH+1)+Y*H(IH+2))                  
      IH = IL                                                                   
      IF (I-K) 6,1,1                                                            
    6 CONTINUE                                                                  
      IF(IS .EQ. 3)RETURN       ! (L shell calc done)                           
                                                                                
      S = .5*H(1)+2.*(H(2)*XI(3)+H(3)*XI(1)+H(4)*XI(2))                         
      T = (RQ+RQ)*SQRT(RQ)                                                      
      BXXX = T*(H(3)-S*XXX)                                                     
      BYYY = T*(H(4)-S*YYY)                                                     
      BZZZ = T*(H(2)-S*ZZZ)                                                     
      BABS  = SQRT(BXXX**2+BYYY**2+BZZZ**2)                                     
C     BABS  = BABS * 1.E5        ! (convert from gauss to nT)                   
      IF(IS .EQ. 1)THEN            ! (convert back to geodetic)                 
        BEAST = BYYY*CP-BXXX*SP                                                 
        BRHO  = BYYY*SP+BXXX*CP                                                 
        BNRTH =  BZZZ*ST-BRHO*CT                                                
        BDOWN = -BZZZ*CT-BRHO*ST                                                
      ELSEIF(IS .EQ. 2)THEN        ! (leave in earth centered cartesian)        
        BNRTH = BXXX                                                            
        B(1)  = BXXX                                                            
        BEAST = BYYY                                                            
        B(2)  = BYYY                                                            
        BDOWN = BZZZ                                                            
        B(3)  = BZZZ                                                            
      ENDIF                                                                     
                                                                                
      RETURN                                                                    
      END                                                                       
                                                                                
C                                                                               
       SUBROUTINE CONVRT(I,GDLAT,ALT,GCLAT,RKM)                                 
      SAVE
C***BEGIN PROLOGUE  CONVRT                                                      
C***DATE WRITTEN   830415   (YYMMDD)                                            
C***REVISION DATE  880201   (YYMMDD)                                            
C***AUTHOR  Wickwar, Vincent B., SRI. INT.                                      
C***PURPOSE  Converts space point from geodetic to geocentric or                
C            vice versa. Reference geoig is that adopted by IAU                 
C            in 1964.                                                           
C   INPUT                                                                       
C     I      If I=1, convert from geodetic to geocentric point                  
C            else convert from geocentric to geodetic point                     
C   INPUT IF I .EQ. 1                                                           
C     GDLAT  Geodetic latitude (Deg)                                            
C     ALT    Altitude above reference ellipsoid (Km)                            
C   OUTPUT IF I .EQ. 1                                                          
C     GCLAT  Geocentric latitude (Deg)                                          
C     RKM    Geocentric distance (Km)                                           
C   INPUT IF I .NE. 1                                                           
C     GCLAT  Geocentric latitude (Deg)                                          
C     RKM    Geocentric distance (Km)                                           
C   OUTPUT IF I .NE. 1                                                          
C     GDLAT  Geodetic latitude (Deg)                                            
C     ALT    Altitude above reference ellipsoid (Km)                            
C                                                                               
C***LONG DESCRIPTION                                                            
C                                                                               
C    Common blocks used                                                         
C                                                                               
C    /CONST/ RTOD,DTOR,RE,REQ,COLAT,WLON                                        
C     RTOD    Unit to convert radian to degrees, 45./ATAN(1.).                  
C     DTOR    Unit to convert degrees to radians ATAN(1.)/45.                   
C     RE      Radius of the earth, 6371.2 (Km).                                 
C     REQ     Equatorial radius, 6378.165.                                      
C     COLAT   Geographic colatitude of the north pole of the                    
C             earth-centered dipole (Deg).                                      
C     WLON    Geographic longitude of the north pole of the                     
C             earth-centered dipole (Deg).                                      
C                                                                               
C***REFERENCES  ASTRON. J. VOL. 66 1961                                         
C                 ASTRON. J. VOL. 15 1961                                       
C                                                                               
C***ROUTINES CALLED  None                                                       
C***COMMON BLOCKS    None                                                       
C***END PROLOGUE  CONVRT                                                        
C                                                                               
      COMMON / CONST / RTOD,DTOR,RE,REQ,COLAT,WLON                              
      AB2=1.0067397                                                             
      EP2=.0067397                                                              
      IF ( I .EQ. 1) THEN                                                       
C                                                                               
C  GEODETIC TO GEOCENTRIC                                                       
C                                                                               
       SINLAT=SIN(GDLAT*DTOR)                                                   
       COSLAT=SQRT(1.-SINLAT*SINLAT)                                            
       COSTH=SINLAT/SQRT((AB2*COSLAT)*(AB2*COSLAT)+SINLAT*SINLAT)               
       SINTH=SQRT(1.-COSTH*COSTH)                                               
       RGEO=REQ/SQRT(1.+EP2*COSTH*COSTH)                                        
       X=RGEO*SINTH+ALT*COSLAT                                                  
       Y=RGEO*COSTH+ALT*SINLAT                                                  
       RKM=SQRT( (X*X) + (Y*Y) )                                                
       GCLAT=RTOD*ATAN(Y/X)                                                     
       RETURN                                                                   
      ELSE                                                                      
C                                                                               
C  GEOCENTRIC TO GEODETIC                                                       
C                                                                               
       RER=RKM/REQ                                                              
C  SEE ASTRON. J. VOL. 66 +.15, 1961, FOR FORMULAE BELOW                        
       A2=((-1.4127348E-8/RER+.94339131E-8)/RER+.33523288E-2)/RER               
       A4=(((-1.2545063E-10/RER+.11760996E-9)/RER+.11238084E-4)/RER             
     -  -.2814244E-5)/RER                                                       
       A6=((54.939685E-9/RER-28.301730E-9)/RER+3.5435979E-9)/RER                
       A8=(((320./RER-252.)/RER+64.)/RER-5.)/RER*.98008304E-12                  
       SCL=SIN(GCLAT*DTOR)                                                      
       CCL=SQRT(1.-SCL*SCL)                                                     
       S2CL=2.*SCL*CCL                                                          
       C2CL=2.*CCL*CCL-1.                                                       
       S4CL=2.*S2CL*C2CL                                                        
       C4CL=2.*C2CL*C2CL-1.                                                     
       S8CL=2.*S4CL*C4CL                                                        
       S6CL=S2CL*C4CL+C2CL*S4CL                                                 
       DLTCL=S2CL*A2+S4CL*A4+S6CL*A6+S8CL*A8                                    
       GDLAT=DLTCL*RTOD+GCLAT                                                   
       ALT=RKM-REQ/SQRT(1.+EP2*SCL*SCL)                                         
       RETURN                                                                   
      ENDIF                                                                     
      END                                                                       
       SUBROUTINE FNDAPX(DLTI, DLNI, H0,HREF)
      SAVE
C***BEGIN PROLOGUE  FNDAPX                                                      
C***DATE WRITTEN   731023   (YYMMDD)                                            
C***REVISION DATE  880201   (YYMMDD)                                            
C***AUTHOR  CLARK, W., NOAA BOULDER                                             
C***PURPOSE  Finds apes coords once tracing has signalled that the apex         
C            has been passed.  Also finds the magnitude of the magnetic field   
C            at the starting point (DLTI, DLNI,ALTI)                            
C***DESCRIPTION                                                                 
C                                                                               
C     It uses second degree interpolation routine, FINT, to find                
C     apex latitude and apex longtitude.                                        
C   INPUT                                                                       
C     DLTI   Geodetic lat. of initial point of tracing (Deg)                    
C     DLNI   Geodetic lon. of initial point of tracing (Deg)                    
C     ALTI   Ht. of initial point of tracing (Km)                               
C            Also passed in the three geocentric points on the field line       
C            about apex through the common block APXIN. See                     
C            the description below.                                             
C   OUTPUT                                                                      
C            Passed out the apex coords by the common block APXOUT. See         
C            the description below.                                             
C                                                                               
C***LONG DESCRIPTION                                                            
C                                                                               
C     COMMON Block Used                                                         
C     /APXIN/ YAPX(3,3)                                                         
C     YAPX      Matrix of cartesian coordinates (loaded columnwise)             
C               of the 3 points about APEX. Set in subprogram ITRACE.           
C                                                                               
C    /APXOUT/ A,ALAT,ALON,F                                                     
C          A  Apex radius (Km)                                                  
C       ALAT  Apex Lat. (Deg)                                                   
C       ALON  Apex Lon. (Deg)                                                   
C       F     Magnitude of the field at the initial point (Gauss)               
C                                                                               
C    /CONST/ RTOD,DTOR,RE,REQ,COLAT,WLON                                        
C     RTOD    Unit to convert radian to degrees, 45./ATAN(1.).                  
C     DTOR    Unit to convert degrees to radians ATAN(1.)/45.                   
C     RE      Radius of the earth, 6371.2 (Km).                                 
C     REQ     Equatorial radius, 6378.165.                                      
C     COLAT   Geographic colatitude of the north pole of the                    
C             earth-centered dipole (Deg).                                      
C     WLON    Geographic longitude of the north pole of the                     
C             earth-centered dipole (Deg).                                      
C                                                                               
C***REFERENCES  reference 1                                                     
C                                                                               
C***ROUTINES CALLED  FINT                                                       
C***COMMON BLOCKS    APXIN,APXOUT,CONST                                         
C***END PROLOGUE  FNDAPX                                                        
C                                                                               
       COMMON /APXIN/ YAPX(3,3)                                                 
       COMMON/APXOUT/A,ALAT,ALON,XMAG,YMAG,ZMAG,F,GMLAT,DMAG
       COMMON / CONST / RTOD,DTOR,RE,REQ,COLAT,WLON                             
       DIMENSION DLT(3), Z(3), HT(3), R(3), CLT(3), DLN(3)                      
C****************
       DIMENSION Y(3)
C      WRITE(6,102)DLTI,DLNI,H0,HREF
C 102  FORMAT(4E12.4)
C****************
C      Store in R, CLT and DLN arrays for processing.                           
C      DO 5 I = 1,3
C        R(I) = YAPX(1,I)
C      CLT(I) = YAPX(2,I)
C      DLN(I) = YAPX(3,I)
C  5   CONTINUE
C
C     TEST TO SEE ALL LONGITUDES HAVE THE SAME SIGN, IF NOT                     
C     CHANGE SIGN OF THE ONE WHICH IS DIFFERENT THAN THE OTHER TWO.             
C                                                                               
C      IF ( SIGN(1.,DLN(1)) .EQ. SIGN(1.,DLN(2)))THEN
C        IF ( SIGN(1.,DLN(1)) .NE. SIGN(1.,DLN(3))) DLN(3)=-DLN(3)
C      ELSEIF ( SIGN(1.,DLN(1)) .EQ. SIGN(1.,DLN(3))) THEN
C        DLN(2)=-DLN(2)
C      ELSE
C        DLN(1)=-DLN(1)
C      ENDIF
C                                                                               
C                                                                               
C **  CONVERT TO GEODETIC COORDINATES AND GET GEODETIC FIELD COMPONENTS         
C **                                                                            
C      IENTRY=1
C      DO 10 I = 1, 3
C        CALL CONVRT(2, DLT(I), HT(I), CLT(I), R(I))
C        CALL FELDG(IENTRY, DLT(I), DLN(I), HT(I), X, Y, Z(I), F)
C  10 CONTINUE
C                                                                               
C **   FIND GEOCENTRIC LATITUDE AND LONGITUDE AT DIP EQUATOR                    
C **   BY INTERPOLATION
C      CALL FINT(Z(1), Z(2), Z(3), CLT(1), CLT(2), CLT(3), 0., ELAT)
C      CALL FINT(Z(1), Z(2), Z(3), DLN(1), DLN(2), DLN(3), 0., ELON)
C
C **  FIND THE APEX COORDINATES, GIVING ALAT THE SIGN OF THE DIP                
C **  AT THE STARTING POINT, AND ALON THE VALUE OF THE GEOMAGNETIC              
C **  LONGITUDE AT THE APEX.                                                    
C **
C      CALL FINT(Z(1), Z(2), Z(3), HT(1), HT(2), HT(3), 0., XINTER)
C      IF (XINTER .LT. 0.) THEN
C        XINTER = ABS(XINTER)
C        WRITE (6, 20)
C      END IF
C      A = 1. + (XINTER/REQ)
C      IENTRY=1
C      CALL FELDG(IENTRY,DLTI, DLNI, ALTI, X, Y, SGN, F)
C      RASQ = RTOD*ACOS(SQRT(1./A))
C      ALAT = SIGN(RASQ, SGN)
C      CALL TSFORM(ELAT, ELON, GMLAT, ALON, SIND, COSD, 1)
C*********************
C      WRITE(6,100)(I,R(I),CLT(I),DLN(I),DLT(I),HT(I),Z(I),I=1,3)
C 100  FORMAT(I5,6E12.4)
C      WRITE(6,101)DLTI,DLNI,ALTI,ELAT,ELON,SGN,RASQ,ALAT
C 101  FORMAT(8E12.4)
C*********************
C      RETURN
C
  20   FORMAT (' BOMBED! THIS MAKES A LESS THAN ONE')
C                                                                               
      DO 1 I =1,3
C       ****
C       ****     CONVERSION CARTESIAN TO GEOCENTRIC COORDINATES
C       ****
	R(I) = SQRT(YAPX(1,I)**2+YAPX(2,I)**2+YAPX(3,I)**2)
	CLT(I) = RTOD*ATAN2(YAPX(3,I),SQRT(YAPX(1,I)**2+YAPX(2,I)**2))
	DLN(I) = RTOD*ATAN2(YAPX(2,I),YAPX(1,I))
    1 CONTINUE
C     ****
C     ****     CONVERSION GEOCENTRIC TO GEODETIC
C     ****
      IENTRY = 1
      DO 2 I = 1,3
	CALL CONVRT(2,DLT(I),HT(I),CLT(I),R(I))
C       ****
C       ****     GET GEODETIC FIELD COMPONENTS
C       ****
	CALL FELDG(IENTRY,DLT(I),DLN(I),HT(I),X,Y,Z(I),F)
    2 CONTINUE
C     ****
C     ****     FIND CAARTESIAN COORDINATES AT DIP EQUATOR BY
C     ****       INTERPOLATION
C     ****
      DO 3 I = 1,3
	CALL FINT(Z(1),Z(2),Z(3),YAPX(I,1),YAPX(I,2),YAPX(I,3),0.,Y(I))
    3 CONTINUE
C     ****
C     ****     CONVERT Y TO GEOCENTRIC COORDINATES
C     ****
      ELAT = RTOD*ATAN2(Y(3),SQRT(Y(1)**2+Y(2)**2))
      ELON = RTOD*ATAN2(Y(2),Y(1))
C     ****
C     ****     FIND APEX HEIGHT BY INTERPOLATION
C     ****
      CALL FINT(Z(1),Z(2),Z(3),HT(1),HT(2),HT(3),0.,XINTER)
      A = (REQ+XINTER)/(REQ+H0)
C     ****
C     ****     FIND APEX COORDINATES , GIVING ALAT SIGN OF DIP AT
C     ****       STARTING POINT.  ALON IS THE VALUE OF THE GEOMAGNETIC
C     ****       LONGITUDE AT THE APEX.
C     ****
      IENTRY = 1
      CALL FELDG(IENTRY,DLTI,DLNI,HREF,XMAG,YMAG,ZMAG,F)
      RASQ = RTOD*ACOS(SQRT(1./A))
      ALAT = SIGN(RASQ,ZMAG)
      CALL TSFORM(ELAT,ELON,GMLAT,ALON,DMAG,1)
      RETURN
C**********************
       END                                                                      
       SUBROUTINE DPLFLD( R, DLAT, DLON ,DLTI,DLNI,H0,HREF)
      SAVE
C***BEGIN PROLOGUE  DPLFLD                                                      
C***DATE WRITTEN   880201   (YYMMDD)                                            
C***REVISION DATE  880201   (YYMMDD)                                            
C***AUTHOR  PASSI, HARSH ANAND, NCAR, BOULDER.                                  
C***PURPOSE  Finds Apex parameters for a dipole field passing through           
C            given geocentric point P.                                          
C***DESCRIPTION                                                                 
C                                                                               
C     The method used is as follows:                                            
C       1. Get local (geodetically oriented) magnetic field components          
C          X (northward), Y (eastward), and Z (vertical) radial vector          
C          of the field reckoned positive when inward.                          
C       2. Calculate dipole latitude of the point P                             
C       3. Find the distance at which the line of force of the                  
C          dipole field crosses the equatorial plane.                           
C          ( the equation is given by r = ra*(cos(dipole lat.))**2              
C          where ra is the distance at which the line of force crosses          
C          the equatorial plane.  We know r and dipole lat. Find ra.)           
C       4. Find apex radius (A = ra/req, req is the equatorial                  
C          radius of the earth.)                                                
C       5. Calculate geocentric colatitude and longitude of apex.               
C          Use the relations in spherical triangle.                             
C       6. Use TSFORM subprogram to compute apex longitude                      
C          (geomagnetic lon.).                                                  
C                                                                               
C   INPUT                                                                       
C     R      Geocentric distance of the point (km)                              
C     DLAT   Geocentric latitude (Deg)                                          
C     DLON   Geocentric longitude (Deg)                                         
C                                                                               
C   OUTPUT                                                                      
C            Passed out by the the common block APXOUT. See description         
C            below.                                                             
C                                                                               
C***LONG DESCRIPTION                                                            
C                                                                               
C                                                                               
C     COMMON Block Used                                                         
C     /APXOUT/ A,ALAT,ALON,F                                                    
C     A       Apex radius (Km)                                                  
C     ALAT    Apex lat. (Deg)                                                   
C     ALON    Apex lon. (Deg)                                                   
C     F       Strength of the magnetic field at point P ( Gauss )               
C                                                                               
C    /CONST/ RTOD,DTOR,RE,REQ,COLAT,WLON                                        
C     RTOD    Unit to convert radian to degrees, 45./ATAN(1.).                  
C     DTOR    Unit to convert degrees to radians ATAN(1.)/45.                   
C     RE      Radius of the earth, 6371.2 (Km).                                 
C     REQ     Equatorial radius, 6378.165.                                      
C     COLAT   Geographic colatitude of the north pole of the                    
C             earth-centered dipole (Deg).                                      
C     WLON    Geographic longitude of the north pole of the                     
C             earth-centered dipole (Deg).                                      
C                                                                               
C     COMMON / LOOPS / IPRNT, JUNIT                                             
C                                                                               
C     /MAG  / ICODE,XI(3),H(144),DUM1(2,40),NAME(4),NMAX,TIME,G(144),DUM2(4)    
C     ICODE   Flag set in STOER subprogram.                                     
C     XI      Work array used in subprograms FELDG, SHELG and STOER             
C     H       Work array used in subprogram FELDG , SHELG and STOER             
C     DUM1    Work array used in SHELG and STOER.                               
C     NAME    Not being used any more , used in old version of COFRM            
C     NMAX    Order of IGRF model set in COFRM subprogram                       
C     TIME    Equal to input argument DATE in COFRM routine.                    
C     G       Array of spherical harmonic coefficients for given                
C             date derived in COFRM subprogram.                                 
C     DUM2    Array of numbers set in COFRM routine and used in SHELG           
C                                                                               
C***REFERENCES  Ionospheric Radio Propagation by K. Davies  (1965)              
C***ROUTINES CALLED  TSFORM                                                     
C***COMMON BLOCKS    APXOUT,CONST,MAG                                           
C***END PROLOGUE  DPLFLD                                                        
      COMMON/APXOUT/A,ALAT,ALON,XMAG,YMAG,ZMAG,F,GMLAT,DMAG
      COMMON / CONST / RTOD,DTOR,RE,REQ,COLAT,WLON                              
      COMMON/MAG/IDUM1,DUM1(307),NAME(4),NMAX,TIME,G(12,12),DUM2(4)             
C                                                                               
C     FIND APEX RADIUS AND APEX LONGITUDE                                       
       CALL CONVRT( 2, GDLAT, ALT, DLAT, R)                                     
       IENTRY=1                                                                 
       CALL FELDG( IENTRY,GDLAT,DLON,ALT,BN,BE,BV,F)                            
C***********************
C     TANI= -BV/SQRT(BE*BE+BN*BN)
      TANI= BV/SQRT(BE*BE+BN*BN)
C***********************
      RA =  R*(TANI*TANI + 4.)/4.                                               
       A = RA/(REQ+H0)
C***********************
      COSL = SQRT(R/RA)
      SINL = SQRT(1. - COSL*COSL)
      COSPMD = -BN/SQRT(BE*BE+BN*BN)
      SINPMD =  BE/SQRT(BE*BE+BN*BN)
      COST = COS(( 90.-DLAT)*DTOR)*COSL +
     $       SIN(( 90.-DLAT)*DTOR)*SINL*COSPMD
      SINT = SQRT(1. - COST*COST)
      COSDEL = (COSL-COS((90.-DLAT)*DTOR)*COST)/
     $         (SIN((90.-DLAT)*DTOR)*SINT)
      SINDEL = (SINL*SINPMD)/SINT
      DEL = RTOD*ATAN2(SINDEL,COSDEL)
      ELON = DLON - DEL
      ELAT = 90. - RTOD*ACOS(COST)
      DPLAT = ATAN(.5*TANI)
      SNDPLT = SIN(DPLAT)
      CSDPLT = SQRT(1.-SNDPLT**2)
      GAMMA = ATAN2(BE,BN)
      SNGAMA = SIN(GAMMA)
      CSGAMA = COS(GAMMA)
      SNDLAT = SIN(DLAT*DTOR)
      CSDLAT = SQRT(1.-SNDLAT**2)
      SNELAT = CSDPLT*SNDLAT-SNDPLT*CSDLAT*CSGAMA
      ELAT1 = ASIN(SNELAT)*RTOD
      ELON1 = DLON*DTOR-ATAN2(SNGAMA*SNDPLT*CSDLAT,CSDPLT-SNELAT*SNDLAT)
      SNELON = SIN(ELON1)
      CSELON = COS(ELON1)
      ELON1 = ATAN2(SNELON,CSELON)*RTOD
      ELAT = ELAT1
      ELON = ELON1
C***********************
      IENTRY = 1
      CALL FELDG(IENTRY,DLTI,DLNI,HREF,XMAG,YMAG,ZMAG,F)
      RASQ = RTOD*ACOS(SQRT(1./A))
      ALAT = SIGN(RASQ,ZMAG)
      CALL TSFORM(ELAT,ELON,GMLAT,ALON,DMAG,1)
C     WRITE(6,100)ALAT,ALON
C 100 FORMAT(2E12.4)
      RETURN                                                                    
      END                                                                       
       SUBROUTINE FINT(A1, A2, A3, A4, A5, A6, A7, RESULT)                      
      SAVE
C***BEGIN PROLOGUE  FINT                                                        
C***REFER TO  FNDAPX                                                            
C***PURPOSE  Second degree interpolation routine                                
C***ROUTINES CALLED  None                                                       
C***END PROLOGUE  FINT                                                          
       RESULT = ((A2-A3)*(A7-A2)*(A7-A3)*A4-(A1-A3)*(A7-A1)*(A7-A3)*A5+         
     $  (A1-A2)*(A7-A1)*(A7-A2)*A6)/((A1-A2)*(A1-A3)*(A2-A3))                   
C                                                                               
       RETURN                                                                   
       END                                                                      
       SUBROUTINE TSFORM(CLAT, CLON, GMLAT, GMLON, DMAG, I)
      SAVE
C***BEGIN PROLOGUE  TSFORM                                                      
C***DATE WRITTEN   731029   (YYMMDD)                                            
C***REVISION DATE  880201   (YYMMDD)                                            
C***AUTHOR  CLARK, W, N.O.A.A.                                                  
C***PURPOSE  Converts geocentric to geomagnetic coordinates, or                 
C            vice-versa.  It is used to find apex longitude.                    
C            i.e. geomagnetic longitude.                                        
C***DESCRIPTION                                                                 
C                                                                               
C                                                                               
C   INPUT                                                                       
C    I       If I=1, convert from geocentric to geomagnetic point               
C            If I=2, convert from geomagnetic to geocentric point               
C   INPUT IF I .EQ. 1                                                           
C     CLAT   Geocentric  latitude (Deg)                                         
C     CLON   Geocentric  longitude (Deg)                                        
C   OUTPUT IF I .EQ. 1                                                          
C     GMLAT  Geomagnetic latitude (Deg)                                         
C     GMLON  Geomagnetic longitude (Deg)                                        
C     SIND   Constant which may be used in conversion of                        
C            X and Y field components from geocentric                           
C            to geomagnetic directions.                                         
C            =(cos(colat)-sin(gmlat)sin(clat))/cos(gmlat)cos(clat)              
C            where colat is the geocentric colat of the north pole              
C            of the earth-centered dipole.                                      
C     COSD   Constant which may be used in conversion of                        
C            X and Y field components from geocentric                           
C            to geomagnetic directions.                                         
C            =(sin(colat)*sin(clon-wlon))/cos(gmlat)                            
C            where colat and wlon are the geocentric colat and lon.             
C            of the north pole of the earth-centered dipole.                    
C   INPUT IF I .EQ. 1                                                           
C     GMLAT  Geomagnetic latitude (Deg)                                         
C     GMLON  Geomagnetic longitude (Deg)                                        
C   OUTPUT IF I .EQ. 1                                                          
C     CLAT   Geocentric  latitude (Deg)                                         
C     CLON   Geocentric  longitude (Deg)                                        
C     SIND   Constant which may be used in conversion of                        
C            X and Y field components from geocentric                           
C            to geomagnetic directions.                                         
C            =(cos(colat)-sin(gmlat)sin(clat))/cos(gmlat)cos(clat)              
C            where colat is the geocentric colat of the north pole              
C            of the earth-centered dipole.                                      
C     COSD   Constant which may be used in conversion of                        
C            X and Y field components from geocentric                           
C            to geomagnetic directions.                                         
C            =(sin(colat)*sin(clon-wlon))/cos(gmlat)                            
C            where colat and wlon are the geocentric colat and lon.             
C            of the north pole of the earth-centered dipole.                    
C***LONG DESCRIPTION                                                            
C                                                                               
C                                                                               
C     COMMON Block Used                                                         
C     /MAG  / ICODE,XI(3),H(144),DUM1(2,40),NAME(4),NMAX,TIME,G(144),DUM2(4)    
C     ICODE   Flag set in STOER subprogram.                                     
C     XI      Work array used in subprograms FELDG, SHELG and STOER             
C     H       Work array used in subprogram FELDG , SHELG and STOER             
C     DUM1    Work array used in SHELG and STOER.                               
C     NAME    Not being used any more , used in old version of COFRM            
C     NMAX    Order of IGRF model set in COFRM subprogram                       
C     TIME    Equal to input argument DATE in COFRM routine.                    
C     G       Array of spherical harmonic coefficients for given                
C             date derived in COFRM subprogram.                                 
C     DUM2    Array of numbers set in COFRM routine and used in SHELG           
C                                                                               
C                                                                               
C    /CONST/ RTOD,DTOR,RE,REQ,COLAT,WLON                                        
C     RTOD    Unit to convert radian to degrees, 45./ATAN(1.).                  
C     DTOR    Unit to convert degrees to radians ATAN(1.)/45.                   
C     RE      Radius of the earth, 6371.2 (Km).                                 
C     REQ     Equatorial radius, 6378.165.                                      
C     COLAT   Geographic colatitude of the north pole of the                    
C             earth-centered dipole (Deg).                                      
C     WLON    Geographic longitude of the north pole of the                     
C             earth-centered dipole (Deg).                                      
C                                                                               
C***REFERENCES  reference 1                                                     
C                                                                               
C***ROUTINES CALLED  None                                                       
C***COMMON BLOCKS    CONST,MAG                                                  
C***END PROLOGUE  TSFORM                                                        
      COMMON / CONST / RTOD,DTOR,RE,REQ,COLAT,WLON                              
      COMMON/MAG/IDUM1,DUM1(307),NAME(4),NMAX,TIME,G(12,12),DUM2(4)             
C                                                                               
       STO = SIN(COLAT*DTOR)                                                    
       CTO = COS(COLAT*DTOR)                                                    
       GO TO (10, 20) I                                                         
C                                                                               
C **   GEOCENTRIC TO GEOMAGNETIC                                                
C **                                                                            
   10 CTG = SIN(CLAT*DTOR)                                                      
       STG = COS(CLAT*DTOR)                                                     
       CTD = CTO*CTG + STO*STG*COS((CLON-WLON)*DTOR)                            
       STD = SQRT(1-(CTD*CTD))                                                  
       GMLAT = RTOD*ATAN2(CTD,STD)
C****************
C      CLD = (CTO*CTD-CTG)/(STO*STD)
C      SLGLO = SIN((CLON-WLON)*DTOR)
C      SLD = STG*SLGLO/STD
C      GMLON = 180. - RTOD*ATAN2(SLD, -1*CLD)
C      IF (GMLON .GT. 180.) GMLON = GMLON - 360.
       CLD = (CTO*CTD-CTG)
       SLGLO = SIN((CLON-WLON)*DTOR)                                            
       SLD = STG*SLGLO*STO
       GMLON = RTOD*ATAN2(SLD,CLD)
C****************
       GO TO 30                                                                 
C                                                                               
C **   GEOMAGETIC TO GEOCENTRIC                                                 
C **                                                                            
   20  CTD = SIN(GMLAT*DTOR)                                                    
       STD = COS(GMLAT*DTOR)                                                    
       CTG = CTO*CTD - STO*STD*COS(GMLON*DTOR)                                  
       STG = SQRT(1-(CTG*CTG))                                                  
       CLAT = RTOD*ATAN2(CTG,STG)
       CLGLO = (CTD-CTO*CTG)
       SLGLO = STD*SIN(GMLON*DTOR)*STO
       SWLON = SIN(SWLON*DTOR)
       CWLON = COS(SWLON*DTOR)

       CLON = RTOD*ATAN2(SLGLO*CWLON+CLGLO*SWLON,CLGLO*CWLON-SLGLO*
     1   SWLON)
C      IF (CLON .LT. 0.) CLON = CLON + 360.
C                                                                               
   30  COSD = (CTO-CTD*CTG)
       SIND = STO*SLGLO*STG
       DMAG = RTOD*ATAN2(-SIND,COSD)
       RETURN                                                                   
C                                                                               
       END                                                                      
