# '#' @
@ lcase
@ set RCID SH
# QSUB -s /bin/csh
# QSUB -lT 60                    # time limit in seconds
# QSUB -q prem                   # queue to be used, prem, reg, econ, sb
# QSUB -lM 2Mw                   # space used in megawords
# QSUB -nr
#newacct 24100004
ja
set dir = $TMPDIR
cd $dir
setenv FILENV assign
#********************************
set locl = "magdat"
set remot = "/ECRIDLEY/ECR89/ECRMG4"
lread local=$locl format=tr remote=$remot
assign -a magdat -V fort.03
#********************************
unset timestamp
cat > dyn.f << 'EOF'
      PROGRAM MAGDAT
      SAVE
C     ****
C     ****     READS MAGNETIC DATA FOR DYNAMO
C     ****
C     ****     PARAMETERS DEFINE GEOGRAPHIC GRID
C     ****
C     ****
      PARAMETER (IMAXG=72, JMAXG=36, KMAX=24)
      PARAMETER (IMAXGP=IMAXG+1, JMAXGP=JMAXG+1, KMAXP=KMAX+1)
      PARAMETER (LNGTH1=IMAXGP*JMAXG*(7*KMAX+1))
      PARAMETER (LNGTH2=IMAXGP*(JMAXG+2)*23)
      PARAMETER (IMAXM=80, JMAXM=97)
      PARAMETER (IMAXMP=IMAXM+1)
      PARAMETER (LNGTH3=IMAXMP*JMAXM*6+IMAXGP*(JMAXG+2)*4)
C     ****
C     ****
C     ****     /FIELD/ CONTAINS MAGNETIC QUANTITIES CALCULATED IN MAGNET
C     ****
      COMMON/FIELD/ALATM(IMAXGP,0:JMAXGP),ALONM(IMAXGP,0:JMAXGP),
     1  XB(IMAXGP,0:JMAXGP),YB(IMAXGP,0:JMAXGP),ZB(IMAXGP,0:JMAXGP),
     2  BMOD(IMAXGP,0:JMAXGP),DMLAT(IMAXGP,0:JMAXGP),
     3  RJAC(IMAXGP,0:JMAXGP,2,2),AV(IMAXGP,0:JMAXGP,3,2),
     4  P(IMAXGP,0:JMAXGP),RMAG11(IMAXGP,0:JMAXGP),
     5  RMAGC(IMAXGP,0:JMAXGP),RMAG2(IMAXGP,0:JMAXGP),
     6  RMAG22(IMAXGP,0:JMAXGP),RJACD(IMAXGP,0:JMAXGP)
C     ****
C     ****     WHERE:
C     ****       IMAXG=72, JMAXG=36, IMAXGP=IMAXG+1, JMAXGP=JMAXG+1
C     ****       ALATM = GEOMAGNETIC LATITUDE AT EACH GEOGRAPHIC GRID
C     ****               POINT               (RADIANS)
C     ****       ALONM = GEOMAGNETIC LONGITUDE AT EACH GEOGRAPHIC
C     ****               GRID POINT           (RADIANS)
C     ****       XB    = NORTHWARD COMPONENT OF MAGNETIC FIELD
C     ****       YB    = EASTWARD COMPONENT OF MAGNETIC FIELD
C     ****       ZB    = DOWNWARD COMPONENT OF MAGNETIC FIELD
C     ****       BMOD  = MAGNITUDE OF MAGNETIC FIELD        (IN GAUSS?)
C     ****       DMLAT = DIPOLE LATITUDE CORRESPONDING TO APEX OF
C     ****               FIELD LINE
C     ****       RJAC(2,2) = SCALED DERIVATIVES OF GEOMAGNETIC
C     ****                   COORDINATES W.R.T. GEOGRAPHIC COORDINATES
C     ****         RJAC(1,1) = COS(THETAS)/COS(THETA)*D(LAMDAS)/D(LAMDA)
C     ****         RJAC(1,2) = COS(THETAS)*D(LAMDAS)/D(THETA)
C     ****         RJAC(2,1) = 1./COS(THETA)*D(THETAS)/D(LAMDA)
C     ****         RJAC(2,2) = D(THETAS)/D(THETA)
C     ****
C     ****         WHERE  (LAMDA,THETA) ARE GEOGRAPHIC COORDINATES
C     ****                (LAMDAS,THETAS) ARE GEOMAGNETIC COORDINATES
C     ****       RJACD = DETERMINANT OF RJAC
C     ****       AV    = THE TWO MAGNETIC VECTORS A1 AND A2
C     ****         AV1 = A1
C     ****         AV2 = A2/COS(THETAS)
C     ****       P     = SCALE FACTOR BETWEEN GEOGRAPHIC AND GEOMAGNETIC
C     ****               SYSTEMS DIVIDED BY  SIN(DIP)*COS(THETAS)
C     ****             = RS**2*COS(THETA)/(BMOD*COS(THETAS))*
C     ****                 D(LAMDA,THETA)/D(LAMDAS,THETAS))
C     ****       RMAG11 = (A1.A1)/P*SIN(I)*COS(THETAS)
C     ****       RMAGC  = (A1.A2)/P*SIN(I)
C     ****       RMAG2  = 1./BMOD
C     ****       RMAG22 = (A2.A2)/P*SIN(I)/COS(THETAS)
C     ****
C     ****
      CALL OPNGKS
C*************************************************
      OPEN(UNIT=3,FILE='magdat',STATUS='OLD',IOSTAT=IOS2,ERR=51,
     1  FORM='UNFORMATTED')
   51 CONTINUE
      IF(IOS2.NE.0)THEN
      WRITE(6,52)IOS2
   52   FORMAT(*PROBLEM OPENING FILE magdat*,I5)
      ENDIF
C     ****
C     ****     READ IN MAGNETIC QUANTITIES
C     ****
      IMAG = 3
      BUFFER IN(IMAG,1)(ALATM(1,0),RJACD(IMAXGP,JMAXGP))
      IF(UNIT(IMAG))3,4,4
    4   IUNIT = IMAG
	WRITE(6,100)IUNIT
  100   FORMAT(* PROBLEM READING MAGNETIC FIELDS FROM UNIT *,I5)
	CALL EXIT
    3 CONTINUE
C****************************************************
      CALL GSCLIP(0)
      CALL CONREC(ALATM(1,0),IMAXGP,IMAXGP,JMAXG+2,0.,0.,0.,0,0,
     1  -1430B)
C     ****
C     ****     WRITE TITLE
C     ****
      XLT = .05
      YBT = .05
      SIDE = 0.9
      X2 = FLOAT(IMAXGP)
      Y2 = FLOAT(JMAXG+2)
      FXA = XLT
      FYA = YBT
      FXB = XLT+SIDE
      FYB = YBT+SIDE
      IF(X2/Y2.GT.1.)FYB = YBT+Y2/X2*SIDE
      IF(Y2/X2.GT.1.)FXB = XLT+X2/Y2*SIDE
      XC = 1.
      XD = X2
      YC = 1.
      YD = Y2
      CALL SET(FXA,FXB,FYA,FYB,XC,XD,YC,YD,1)
      MXA = KFPX(FXA)
      MXB = KFPX(FXB)
      MYA = KFPY(FYA)
      MYB = KFPY(FYB)
      MX = (MXA+MXB)/2
      MY = MYB+48
      UX = CPUX(MX)
      UY = CPUY(MY)
      CALL PWRIT(UX,UY,'ALATM',5,2,0,0)
      CALL FRAME
      CALL CONREC(ALONM(1,0),IMAXGP,IMAXGP,JMAXG+2,0.,0.,0.,0,0,
     1  -1430B)
      CALL SET(FXA,FXB,FYA,FYB,XC,XD,YC,YD,1)
      CALL PWRIT(UX,UY,'ALONM',5,2,0,0)
      CALL FRAME
      CALL CONREC(BMOD(1,0),IMAXGP,IMAXGP,JMAXG+2,0.,0.,0.,0,0,
     1  -1430B)
      CALL SET(FXA,FXB,FYA,FYB,XC,XD,YC,YD,1)
      CALL PWRIT(UX,UY,'BMOD',4,2,0,0)
      CALL FRAME
      CALL GSCLIP(1)
      CALL CLSGKS
      STOP
      END
'EOF'
set timestamp
cft77 -m 4 -e zI -a static -i 64 dyn.f
segldr -f indef -o "$QSUB_REQNAME".out -i ~/segdir dyn.o
rm dyn.f dyn.o
unset timestamp
"$QSUB_REQNAME".out << 'EOF'
'EOF'
#
#  transfer plotfile to sting
#
rcp gmeta sting:~roble/ntwk/$QSUB_REQNAME
ja -cslst


