	subroutine mbcntr(arry, title, xlabel, ylabel, iysz, ixsz)
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c Wed Dec 11 09:18:42 MST 1991
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	dimension xrry(iysz,ixsz), arry(ixsz,iysz)
c	dimension xrry(73,37), arry(37,73)
	dimension rwrk(50000), iwrk(10000)

	integer sizeo
	character*7 xtics, ytics
	character*(*) title, xlabel, ylabel

	lrwrk= 5000
	liwrk= 1000

c	ixsz= 37
c	iysz= 73

c Reset mapping for plotchar xpos, ypos coordinate usage.
	call set(0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1) 

c Mapping coordinates for set call and other stuff;
c  p(xy)(lh)= plotter coordinates x,y low, high.
c  u(xy)(lh)= user coordinates x,y low, high.
	pxl= 0.08
	pxh= 0.98
	pyl= 0.40
	pyh= 0.90
	uxl= 0.0
	uxh= float(iysz) 
	uyl= 0.0
	uyh= float(ixsz) 

c Put array in proper order (only if appropriate).
	if (iysz .ne. ixsz) then 
	 do i= 1, iysz 
	  do j= 1, ixsz 
	    jj= (ixsz-j)+1
	    xrry(i,jj)= arry(j,i)
	  enddo
	 enddo
	else
	 do j= 1, ixsz 
	  do i= 1, iysz 
	    xrry(i,j)= arry(i,j)
	  enddo
	 enddo
	endif

c Text attributes.
	size= -0.6
	angd= 0.0
	center= 0.0

c Lay down the longitude values. 
	dstep= (pxh-pxl)/4.0 
	xpos= pxl 
	ypos= pyl - 0.02 
	long= 0
   10   format(i4)
	do i= 1, 5
	  write (xtics, 10) long
	  call plchhq(xpos, ypos, xtics, size, angd, center)
	  long= long + 90
	  xpos= xpos + dstep
	enddo

c Lay down the latitude values.
	dstep= (pyh-pyl)/4 
	xpos= pxl - 0.02 
	ypos= pyl 
	lat= -90
	do i= 1, 5
	  write (ytics, 10) lat
	  call plchhq(xpos, ypos, ytics, size, angd, center)
	  lat= lat + 45
	  ypos= ypos + dstep
	enddo

c Now write out the textual labels for the axes and title,
c  text label sizes,
	size= -1.0
	center= 0.0

c  lay down the y-axis label,
	xpos= pxl - 0.06 
	ypos= (pyh-pyl)/2.0 + pyl
	angd= 90.0
	call plchhq (xpos, ypos, ylabel(1:sizeo(ylabel)), 
     1	 size, angd, center)

c  lay down the x-axis label,
	xpos= (pxh-pxl)/2.0 + pxl
	ypos= pyl - 0.05
	angd= 0.0
	call plchhq (xpos, ypos, xlabel(1:sizeo(xlabel)), 
     1	 size, angd, center)

c  and put down the title of the plot.
	xpos= (pxh-pxl)/2.0 + pxl 
	ypos= pyh + 0.02 
	call plchhq(xpos, ypos, title(1:sizeo(title)), 
     1	 size, angd, center)

	call set(pxl, pxh, pyl, pyh, uxl, uxh, uyl, uyh, 1) 
	call cpseti('SET',0)
	call cpseti('MAP',0)

	call cpsetc('HLT', 'H($ZDV$)''L($ZDV$)')
c Specify the Information Label Text (ILT) and where to put it.
	call cpsetc('ILT',
     1  'Contour interval $CIUS$ Maximum $CMX$ Minimum $CMN$')
	call cpsetr('ILX', 0.85)
	call cpsetr('ILY', -0.15)

c Initialize the work arrays.
	call cprect(xrry, iysz, iysz, ixsz, rwrk, lrwrk, iwrk, liwrk)

c Have CONPACK pick the contour levels.
	call cppkcl(xrry, rwrk, iwrk)

c Set the line pattern for negative contour levels.
	call cpgeti('NCL',icntrs) 
	do i= 1, icntrs
	  call cpseti('PAI', i)
	  call cpgetr('CLV',clv)
	  if (clv .lt. 0.0) call cpseti('CLD', -682)
	enddo

c Draw the contours,
	call cpcldr(xrry, rwrk, iwrk)

c and the information and hi/low labels.
c	call cpsetc('HLT', "'H($ZDV$)''L($ZDV$)'")
	call cplbdr(xrry, rwrk, iwrk)

	call tick4(16, 8, 16, 8)
	mjrx= 4
	mnrx= 6
	mjry= 4
	mnry= 3
	call perim (mjrx,mnrx,mjry,mnry)

c Advance the frame and dump the buffer. 
	call frame

	return
	end
