	subroutine mbcntr(arry, ixsz, iysz)
	dimension arry(ixsz,iysz)

	dimension rwrk(50000), iwrk(10000)
	character*7 xtics, ytics
	character*8 xxlab, yylab
	character*18 title

	lrwrk= 5000
	liwrk= 1000

	size= -0.6
c Lay down the longitude text.
	angd= 0.0
	center= 1.0
	dstep= 0.233
	xpos= 0.07
	ypos= 0.38
	long= -180
   10   format(i4)
	do i= 1, 5
	  write (xtics, 10) xlong
	  call plchhq(xpos, ypos, xtics, size, angd, center)
	  xlong= xlong + 90 
	  xpos= xpos + dstep
	enddo

c Lay down the latitude text.
	center= 0.0
	dstep= 0.126
	xpos= 0.02
	ypos= 0.4
	xlat= -90 
	do i= 1, 5
	  write (ytics, 10) xlat
	  call plchhq(xpos, ypos, ytics, size, angd, center)
	  xlat= xlat + 45 
	  ypos= ypos + dstep
	enddo

c Put down the title of the plot.
	xpos= 0.53
	ypos= 0.92
	size= -1.0
	title= "Orography (meters)"
	call plchhq(xpos, ypos, title, size, angd, center)

	xlo= 0.0
	xhi= float(ixsz) 
	ylo= float(iysz) 
	yhi= 0.0
	call set(0.08, 0.98, 0.4, 0.9, xlo, xhi, ylo, yhi, 1)

	call cpseti('MAP', 0)
	call cpseti('SET', 0)

c Specify the Information Label Text (ILT) and where to put it.
	call cpsetc('ILT','Contour range from $CMN$ to $CMX$ by $CIUS$.')
	call cpsetr('ILX', 0.7)
	call cpsetr('ILY', -0.07)

c Initialize the work arrays.
	call cprect(arry, ixsz, ixsz, iysz, rwrk, lrwrk, iwrk, liwrk)

c Have CONPACK pick the contour levels and request 64 contour levels.
	call cpseti('NCL', 64)
	call cppkcl(arry, rwrk, iwrk)

c Now draw the contours. 
	call cpcldr(arry, rwrk, iwrk)

c Now draw the labels (eg ILT from above).
c	call cplbdr(arry, rwrk, iwrk)
	call cpback(arry, rwrk, iwrk)

c Write it down
	call frame

	return
	end
