	subroutine mbvec(arry1, arry2, title, xlabel, ylabel)
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c Wed Dec 11 09:18:42 MST 1991
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	dimension xrry1(73,37), xrry2(73,37), arry1(37,73), arry2(37,73)
	character*(*) title, xlabel, ylabel

	integer sizeo
	character*7 xtics, ytics

	lrwrk= 5000
	liwrk= 1000

	ixsz= 73
	iysz= 37

c Reset mapping for plotchar xpos, ypos coordinate usage.
	call set(0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1) 

c Mapping coordinates for set call and other stuff;
c  p(xy)(lh)= plotter coordinates x,y low, high.
c  u(xy)(lh)= user coordinates x,y low, high.
	pxl= 0.08
	pxh= 0.98
	pyl= 0.40
	pyh= 0.90
	uxl= 0.0
	uxh= 73.0
	uyl= 0.0
	uyh= 37.0

c Put arrays in proper order
	do i= 1, 73
	  do j= 1, 37
	    jj= (37-j)+1
	    xrry1(i,jj)= arry1(j,i)
	    xrry2(i,jj)= arry2(j,i)
	  enddo
	enddo

c Text attributes.
	size= -0.6
	angd= 0.0
	center= 0.0

c Lay down the longitude values. 
	dstep= (pxh-pxl)/4.0 
	xpos= pxl 
	ypos= pyl - 0.02 
	long= 0
   10   format(i4)
	do i= 1, 5
	  write (xtics, 10) long
	  call plchhq(xpos, ypos, xtics, size, angd, center)
	  long= long + 90
	  xpos= xpos + dstep
	enddo

c Lay down the latitude values.
	dstep= (pyh-pyl)/4 
	xpos= pxl - 0.02 
	ypos= pyl 
	lat= -90
	do i= 1, 5
	  write (ytics, 10) lat
	  call plchhq(xpos, ypos, ytics, size, angd, center)
	  lat= lat + 45
	  ypos= ypos + dstep
	enddo

c Now write out the textual labels for the axes and title,
c  text label sizes,
	size= -1.0
	center= 0.0

c  lay down the y-axis label,
	xpos= pxl - 0.06 
	ypos= (pyh-pyl)/2.0 + pyl
	angd= 90.0
	call plchhq (xpos, ypos, ylabel(1:sizeo(ylabel)), 
     1	 size, angd, center)

c  lay down the x-axis label,
	xpos= (pxh-pxl)/2.0 + pxl
	ypos= pyl - 0.05
	angd= 0.0
	call plchhq (xpos, ypos, xlabel(1:sizeo(xlabel)), 
     1	 size, angd, center)

c  and put down the title of the plot.
	xpos= (pxh-pxl)/2.0 + pxl 
	ypos= pyh + 0.02 
	call plchhq(xpos, ypos, title(1:sizeo(title)), 
     1	 size, angd, center)

c Setup mapping between window and viewport.
	call set(pxl, pxh, pyl, pyh, uxl, uxh, uyl, uyh, 1) 

c Establish vector plot routine required parameters. 
	flo= 0.0e-24
	fhi= -1.0
	ispv= 0
	nset= 1
	length= 0
	call velvct(xrry1, 73, xrry2, 73, 73, 37, flo, fhi,
     1	 nset, length, ispv, spv)

	call tick4(16, 8, 16, 8)
	mjrx= 4
	mnrx= 6
	mjry= 4
	mnry= 3
	call perim (mjrx,mnrx,mjry,mnry)

c Write it down
	call frame

	return
	end
