	program mda
c-------------------------------------------------------------------------
c Access model data from the TIEGCM model history files.  This code reads
c the TIEGCM history file (as aqcuired from MSS:/ROBLE/RGR91/DYEN12) and
c extracts a particular day and time of day, creating the dynamo and
c Heelis potential file, "pot.data".  The pot.data file is read by the 
c subroutine "fipd" in "thund.f".
c
c Wed Dec 11 09:21:28 MST 1991 - executive= thundmain.f 
c-------------------------------------------------------------------------
c Mon Feb 10 16:28:15 MST 1992 - executive= thund.f
c-------------------------------------------------------------------------

	dimension lat_rec(44474), dstruct(74,601)
	integer DYNO, HEELIS, histcnt

	equivalence (lat_rec(2), dstruct)

	iDYNO1= 376 
	iHELIS= 401
	mday= 2
	mhr= 0
	mmin= 0
	histcnt= 0
	loopcnt= 0
	latcnt= 0

	open (unit= 3, file="tiegcm.data", form= "unformatted",
     &   access= "sequential", status= "old")  
	rewind(unit=3)

	open (unit= 4, file="pot.data", form= "unformatted", 
     &   access= "sequential", status= "new")

c	print *, "Starting the DO loop for reading..."
	do index= 1, 500 
	  read(3, end= 100) iter, nday, nhr, nmin, dummy 
c	  print *,'iter= ', iter, 'day= ',nday,', hour= ',nhr,
c     &		  ', minutes= ',nmin

	  if (nday .eq. mday .and. nhr .eq. mhr .and. nmin .eq. mmin) then
c	    print *,'Found day=',mday,', hour=',mhr,', min= ',mmin
	    histcnt= histcnt+1
	    read (3) dummy
	    do lat_loop= 1, 36
	      latcnt= latcnt+1
c	      buffer in(3,0) (lat_rec(1),lat_rec(44474))
	      read (3) lat_rec
	      do long_loop= 1, 74
		loopcnt= loopcnt+1
	        write(4) dstruct(long_loop, iDYNO1), 
     &  		dstruct(long_loop, iHELIS) 
	      enddo
	    enddo
	   else
	    read (3) dummy
	    do lat_loop= 1, 36
c	      print *,'lat_loop= ',lat_loop
	      read (3) dummy
	    enddo
	  endif
	enddo
  100   continue

	print *,'History count is ', histcnt,', loopcnt= ',loopcnt

c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c	do lat_loop= 1, 36
c	  do long_loop= 1, 74
c	    print *,'dstruct(',long_loop,',',iDYNO1,')= ', 
c     & 	     dstruct(long_loop, iDYNO1)
c	    print *,'dstruct(',long_loop,',',iHELIS,')= ', 
c     & 	     dstruct(long_loop, iHELIS)
c	  enddo
c	enddo
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

c Shut down all files.
	close (3)
	close (4)
	stop
	end
