pro file_truncate_query_event,event
  widget_control,event.id,get_uvalue=file
  widget_control,event.top,get_uvalue=stateptr
  uname = widget_info(event.id,/uname)
  state = *stateptr
  case uname of
    'YES': begin
      print,'Will open and truncate file ',file 
      state.ps_confirm_open = 1
      state.ps_outfile = file
    end
    'CANCEL': begin
      print,'Will NOT open file ',file
      state.ps_confirm_open = 0
    end
  endcase 
  *stateptr = state
  widget_control,event.top,/destroy
; bases_sensitivity,stateptr,1
end
;-----------------------------------------------------------------------
pro file_truncate_query,stateptr,file
;
  state = *stateptr
; tlb = widget_base(title='File Truncation Warning',row=2,/modal,$
;   uvalue=stateptr,group_leader=state.tlb)
  tlb = widget_base(title='File Truncation Warning',row=2,$
    uvalue=stateptr,group_leader=state.tlb)

  warning_base = widget_base(tlb,row=1)
  warning = strarr(2)
  warning[0] = string(format="('WARNING: file ',a,' already exists')",$
    file)
  warning[1] = 'Should I open and truncate this file?'
  text = widget_text(warning_base,value=warning,xsize=80,ysize=2)

  button_base = widget_base(tlb,row=1)
  yes_button = widget_button(button_base,value='YES (open and truncate)',$
    uname='YES',uvalue=file)
  cancel_button = widget_button(button_base,value='CANCEL (do not open)',$
    uname='CANCEL',uvalue=file)

; if (state.utvert_tlb gt 0) then widget_control,state.utvert_tlb,$
;   sensitive=sensitive
; if (state.utlat_tlb gt 0) then widget_control,state.utlat_tlb,$
;   sensitive=sensitive

; id = widget_info(state.tlb,find_by_uname='SELECT_MTIMES_BASE')
; widget_control,id,sensitive=0
; id = widget_info(state.tlb,find_by_uname='SELECT_FIELDS_BASE')
; widget_control,id,sensitive=0
; id = widget_info(state.tlb,find_by_uname='UTVERT')
; widget_control,id,sensitive=0
; id = widget_info(state.tlb,find_by_uname='UTLAT')
; widget_control,id,sensitive=0

  widget_control,tlb,/realize
  xmanager,'file_truncate_query',tlb
end
