;-----------------------------------------------------------------------
pro update_select_locs_text,utvptr
  utvstate = *utvptr
  nlocs = utvstate.nlocs
  locs = utvstate.locs[*,0:nlocs-1]
  text = strarr(nlocs)
  for i=0,nlocs-1 do begin
    text[i] = string(format="('(',f6.2,',',f7.2,')')",locs[*,i])
  endfor
  id = widget_info(utvstate.tlb,find_by_uname='SELECT_LOCS_TEXT')
  widget_control,id,set_value=text
end
;-----------------------------------------------------------------------
pro cancel_utvert_event,event
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
  widget_control,event.top,/destroy
  state.utvert_tlb = -1
  *stateptr = state
end
;-----------------------------------------------------------------------
pro select_locs_event,event
;
; Get state from loc base:
;
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
;
; Get utvstate from current widget:
;
  widget_control,event.id,get_uvalue=utvstateptr
  utvstate = *utvstateptr
  uname = widget_info(event.id,/uname)
;
; Get selected longitude or latitude:
; Make current widget insensitive, and if current widget
;   is select lat, then make select lon widget sensitive, 
;   and vice-versa.
;
  iloc = utvstate.nlocs
  if (uname eq 'SELECT_LATITUDES') then begin
    widget_control,event.id,sensitive=0
    lats = *state.lats
    slat = lats[event.index]
    widget_lons = widget_info(event.top,find_by_uname='SELECT_LONGITUDES')
    widget_control,widget_lons,sensitive=1
    utvstate.locs[0,iloc] = slat
  endif
  if (uname eq 'SELECT_LONGITUDES') then begin
    widget_control,event.id,sensitive=0
    lons = *state.lons
    slon = lons[event.index]
;   print,'Selected longitude ',slon
    widget_lats = widget_info(event.top,find_by_uname='SELECT_LATITUDES')
    widget_control,widget_lats,sensitive=1
    utvstate.locs[1,iloc] = slon
  endif
  if (uname eq 'CLEAR_SELECTED_LOCS') then begin
    print,'Clearing selected locations..'
    id = widget_info(utvstate.tlb,find_by_uname='SELECT_LOCS_TEXT')
    widget_control,id,set_value='No selected locations'
    utvstate.nlocs = 0
    utvstate.locs[*,*] = 999.
    *utvstateptr = utvstate
    id = widget_info(utvstate.tlb,find_by_uname='MAKE_PLOTS')
    widget_control,id,sensitive=0
    return 
  endif
  if (uname eq 'SET_DEFAULT_LOCS') then begin
    utvstate.locs = utvstate.default_locs
    utvstate.nlocs = n_elements(utvstate.default_locs)/2
    *utvstateptr = utvstate
    update_select_locs_text,utvstateptr 
    id = widget_info(utvstate.tlb,find_by_uname='MAKE_PLOTS')
    widget_control,id,sensitive=1
    return 
  endif
;
; Increment nlocs if bot lat and lon have been selected:
;
  if (utvstate.locs[0,iloc] ne 999. and utvstate.locs[1,iloc] ne 999.) then begin
    utvstate.nlocs = utvstate.nlocs+1 
  endif
;
; Update utvstate pointer, and text widget displaying currently 
; selected locations:
;
  *utvstateptr = utvstate
  if (utvstate.nlocs gt 0) then begin
    update_select_locs_text,utvstateptr 
    id = widget_info(utvstate.tlb,find_by_uname='MAKE_PLOTS')
    widget_control,id,sensitive=1
  endif
end
;-----------------------------------------------------------------------
pro select_zp_event,event
  uname = widget_info(event.id,/uname)
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
; levs = reverse(*state.levs)
  levs = reverse(*state.ilevs)
  nlev = n_elements(levs)
  widget_control,event.id,get_uvalue=utvstateptr
  utvstate = *utvstateptr
  izpbot = ixfind_simple(levs,utvstate.zpbot)
  izptop = ixfind_simple(levs,utvstate.zptop)
  case uname of
    'SELECT_ZPTOP': begin
      zptop = levs[event.index] 
      if (zptop le utvstate.zpbot) then begin
        print,'>>> Top zp level must be greater than bottom level:'
        print,format=$
          "('Selected top level = ',f6.2,' Current bottom level = ',f6.2)",$
          zptop,utvstate.zpbot
        print,'Reverting to top level ',utvstate.zptop
        widget_control,event.id,set_list_select=izptop
      endif else begin
;       print,'Selected top zp = ',zptop
        utvstate.zptop = zptop
        id = widget_info(event.top,find_by_uname='SELECT_ZPTOP_TEXT')
        text = string(format="('Select top level (',f6.2,')')",zptop)
        widget_control,id,set_value=text
      endelse
    end
    'SELECT_ZPBOT': begin
      zpbot = levs[event.index] 
      if (zpbot ge utvstate.zptop) then begin
        print,'>>> Bottom zp level must be less than top level:'
        print,format=$
          "('Selected bottom level = ',f6.2,' Current top level = ',f6.2)",$
          zpbot,utvstate.zptop
        print,'Reverting to bottom level ',utvstate.zpbot
        widget_control,event.id,set_list_select=izpbot
      endif else begin
;       print,'Selected bottom zp = ',zpbot
        utvstate.zpbot = zpbot
        id = widget_info(event.top,find_by_uname='SELECT_ZPBOT_TEXT')
        text = string(format="('Select bottom level (',f6.2,')')",zpbot)
        widget_control,id,set_value=text
      endelse
    end
  endcase
; izpbot = ixfind_simple(*state.levs,utvstate.zpbot)
; izptop = ixfind_simple(*state.levs,utvstate.zptop)
  izpbot = ixfind_simple(*state.ilevs,utvstate.zpbot)
  izptop = ixfind_simple(*state.ilevs,utvstate.zptop)
  nzp = izptop-izpbot+1
; levs = *state.levs
  levs = *state.ilevs
  zplevs = fltarr(nzp)
  zplevs[*] = levs[izpbot:izptop]
  *utvstate.zplevs = zplevs
  *utvstateptr = utvstate
end
;-----------------------------------------------------------------------
pro plt_utvert_event,event
  widget_control,event.id,get_uvalue=utvstateptr
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
; Re-read ps output file:
; id = widget_info(state.tlb,find_by_uname='SET_PS_OUTFILE')
; set_ps_outfile,id,stateptr
  open_ps_file,stateptr
  widget_control,/hourglass
  pltutvert,stateptr,utvstateptr
end
;-----------------------------------------------------------------------
pro help_utvert_event,event
  widget_control,event.id,get_uvalue=utvstateptr
  utvstate = *utvstateptr
  display_help,utvstate.tlb,'UTVERT'
end
;-----------------------------------------------------------------------
;pro select_model_event,event
;
; Toggle state.model between TGCM and MSIS:
;
; widget_control,event.top,get_uvalue=stateptr
; state = *stateptr
; widget_control,event.id,get_uvalue=widget
; case widget of
;   'TGCM_MODEL': begin ; switch to TGCM model
;     if (event.select eq 0) then return
;     state.model = 'TGCM'
;     print,'Will read TGCM history files.'
;   end 
;   'MSIS_MODEL': begin ; switch to MSIS model
;     if (event.select eq 0) then return
;     state.model = 'MSIS'
;     print,'Will call MSIS model.'
;   end 
; endcase
; *stateptr = state
;end
;-----------------------------------------------------------------------
pro mkutvert,stateptr
  state = *stateptr  ; should be read only
; levs = *state.levs
  levs = *state.ilevs
  nlev = n_elements(levs)
  zpbot = levs[0]
;
; Top level is problematic (e.g., "old" histories store lbc in top level 
; of T,U,V, requiring moving it to the bottom, and interpolating from
; midpoints to interfaces). This can be taken care of later, but in the
; meantime, default to second to top level:
;
; zptop = levs[nlev-1]  ; top level
  zptop = levs[nlev-2]  ; top level-1
;
; utvert state:
;
  mxlocs = 200 ; max number of locations
  utvstate = {                      $
    tlb:0,                          $ top level base
    locs:fltarr(2,mxlocs),          $ selected locations (lat,lon pairs)
    default_locs:fltarr(2,5),       $ default locations (lat,lon)
    nlocs:0,                        $ number of locations
    zpbot:zpbot,                    $ bottom zp level
    zptop:zptop,                    $ top zp level
    zplevs:ptr_new(/allocate_heap)  $ levels to plot (zpbot to zptop)
  }
  utvstateptr = ptr_new(utvstate)
;
; Default locations:
;
  utvstate.locs[*,*] = 999. ; init
  utvstate.nlocs = 5
  utvstate.default_locs = $
    [[-67.5,0.], [-32.5,0.], [2.5,0.], [32.5,0.], [67.5,0.]]
  utvstate.locs[*,0:utvstate.nlocs-1] = utvstate.default_locs[*,*]
;
; tlb for utvert:
;
  utvert_base = widget_base(column=1,uvalue=stateptr,$
    uname='UTVERT_BASE',title='Plot ut vs pressure',$
    group_leader=state.tlb)
;
   utvstate.tlb = utvert_base
   state.utvert_tlb = utvert_base
   *utvstateptr = utvstate
   *stateptr = state
;
; Base for selecting locations:
;
  locs_base = widget_base(utvert_base,col=1,uvalue=stateptr,frame=3)
  select_locs_base = widget_base(locs_base,row=1,uvalue=stateptr)
;
; Select latitudes:
;
  lats_base = widget_base(select_locs_base,row=2,uvalue=stateptr,frame=3)
  label = widget_label(lats_base,value='Select latitudes')
  lats = *state.lats
  nlats = n_elements(lats)
  lats_list = strarr(nlats) 
  for j=0,nlats-1 do lats_list[j] = string(format="(f8.2)",lats[j])
  list = widget_list(lats_base,value=lats_list,ysize=15,xsize=12,$
    uvalue=utvstateptr,event_pro='select_locs_event',$
    uname ='SELECT_LATITUDES')
;
; Select longitudes:
;
  lons_base = widget_base(select_locs_base,row=2,uvalue=stateptr,frame=3)
  label = widget_label(lons_base,value='Select longitudes')
  lons = *state.lons
  nlons = n_elements(lons)
  lons_list = strarr(nlons) 
  for i=0,nlons-1 do lons_list[i] = string(format="(f8.2)",lons[i])
  list = widget_list(lons_base,value=lons_list,ysize=15,xsize=12,$
    uvalue=utvstateptr,event_pro='select_locs_event',$
    uname ='SELECT_LONGITUDES')
;
; Display currently selected locations in text widget:
;
  display_base = widget_base(select_locs_base,row=2,uvalue=stateptr,frame=3)
  label = widget_label(display_base,value='Selected locations (lat,lon):')
  text = strarr(utvstate.nlocs)
  for i=0,utvstate.nlocs-1 do $
    text[i] = string(format="('(',f6.2,',',f7.2,')')",$
      utvstate.default_locs[*,i])
  widget = widget_text(display_base,value=text,$
    uname='SELECT_LOCS_TEXT',xsize=30,ysize=18)
;
; Clear selected locations and set default locations:
;
  button_base = widget_base(locs_base,row=1)
  button = widget_button(button_base,value='Clear selected locations',$
    uname='CLEAR_SELECTED_LOCS',uvalue=utvstateptr,$
    event_pro='select_locs_event')
  button = widget_button(button_base,value='Set default locations',$
    uname='SET_DEFAULT_LOCS',uvalue=utvstateptr,$
    event_pro='select_locs_event')
;
; Select bottom,top levels for y-axis:
; Note that levs array is reversed in the list widgets to make them
;   more visually intuitive (see also the event pros)
;
; Select bottom level (default is levs[0]):
;
  select_zp_base = widget_base(utvert_base,uvalue=stateptr,$
    column=2)
  list_base = widget_base(select_zp_base,row=2,frame=3)
  text = string(format="('Select bottom level (',f6.2,')')",zpbot)
  label = widget_label(list_base,value=text,uname='SELECT_ZPBOT_TEXT')
  list = strarr(nlev)
  for k=0,nlev-1 do list[nlev-k-1] = string(format="(f6.2)",levs[k])
  list = widget_list(list_base,value=list,ysize=10,xsize=12,$
    uvalue=utvstateptr,event_pro='select_zp_event',uname ='SELECT_ZPBOT')
  widget_control,list,set_list_select=nlev-1 ; the bottom level
;
; Select top level (default is levs[nlev-1]):
;
  list_base = widget_base(select_zp_base,row=2,frame=3)
  text = string(format="('Select top level (',f6.2,')')",zptop)
  label = widget_label(list_base,value=text,uname='SELECT_ZPTOP_TEXT')
  list = strarr(nlev)
  for k=0,nlev-1 do list[nlev-k-1] = string(format="(f6.2)",levs[k])
  list = widget_list(list_base,value=list,ysize=10,xsize=12,$
    uvalue=utvstateptr,event_pro='select_zp_event',uname ='SELECT_ZPTOP')
; widget_control,list,set_list_select=0 ; the top level
  widget_control,list,set_list_select=1 ; second level from top
;
; Default zplevs:
;
  izpbot = ixfind_simple(levs,utvstate.zpbot)
  izptop = ixfind_simple(levs,utvstate.zptop)
  *utvstate.zplevs = levs[izpbot:izptop]
;
; Radio buttons for TGCM or MSIS:
;
; model_base = widget_base(utvert_base,row=1,uname='SET_MODEL_BASE',$
;   frame=3)
; label = widget_label(model_base,value='Select Model:')
; radio_base = widget_base(model_base,row=1,/exclusive)
; tgcm_button = widget_button(radio_base,value='TGCM',$
;   uvalue='TGCM_MODEL',uname='SET_TGCM_MODEL',$
;   event_pro='select_model_event')
; msis_button = widget_button(radio_base,value='MSIS',$
;   uvalue='MSIS_MODEL',uname='SET_MSIS_MODEL',$
;   event_pro='select_model_event')
; widget_control,tgcm_button,/set_button
;
; Buttons to cancel or make utvert plots, and help:
;
  button_base = widget_base(utvert_base,row=1,uvalue=stateptr)
;
; Cancel button:
  button = widget_button(button_base,value='CANCEL',$
    event_pro='cancel_utvert_event')
;
; Make plots:
  button = widget_button(button_base,value='Make Ut vs Pressure Plots',$
    event_pro='plt_utvert_event',uvalue=utvstateptr,uname='MAKE_PLOTS')
;
; Display help:
  button = widget_button(button_base,value='Help',uvalue=utvstateptr,$
    event_pro='help_utvert_event')
;
; Realize tlb and hand it off to xmanager:
;
  *stateptr = state       ; updates state.utvert_tlb
  *utvstateptr = utvstate ; update utvstate pointer
  widget_control,utvert_base,/realize
  xmanager,'utvert',utvert_base,/no_block
end
