pro pltutvert,stateptr,utvstateptr
  utvstate = *utvstateptr
  state = *stateptr
  sfields = *state.sfields
  nfields = n_elements(sfields)
  f_units = strarr(nfields)
  lats = *state.lats
  lons = *state.lons
; levs = *state.levs
  levs = *state.ilevs
  nlevs = n_elements(levs)
; model = state.model
;
; Get locs and indices into lat,lon coord arrays:
;
  nlocs = utvstate.nlocs
; print,format="('pltutvert: nlocs=',i3,' locs (lat,lon)=')",nlocs
  locs = utvstate.locs[*,0:nlocs-1]
  ilocs = intarr(2,nlocs) ; indices to nearest grid point for each location
  gridlocs = fltarr(2,nlocs) ; nearest grid-point lat,lon for each location
  for iloc=0,nlocs-1 do begin
    ilat = ixfind(lats,locs[0,iloc],lats[1]-lats[0])
    ilon = ixfind(lons,locs[1,iloc],lons[1]-lons[0])
    ilocs[0,iloc] = ilat
    ilocs[1,iloc] = ilon
    gridlocs(0,iloc) = [lats[ilat]] ; actual lat grid point
    gridlocs(1,iloc) = [lons[ilon]] ; actual lon grid point
;   print,format="('(',2f8.2,')')",locs[*,iloc]
  endfor
;
; Get zp levels and start/end indices into levs:
;
  zplevs = *utvstate.zplevs
  nzplev = n_elements(zplevs)
  for k=0,nlevs-1 do begin
    if (levs[k] eq zplevs[0]) then izp0 = k
    if (levs[k] eq zplevs[nzplev-1]) then izp1 = k
  endfor 
; print,format="('pltutvert: izp0,1=',2i3,' nzplev=',i3,' zplevs=',/,(6f7.2))",$
;   izp0,izp1,nzplev,zplevs
;
; Indices into mtimes of mtime_beg and mtime_end, and
; number of times to plot:
;
  mtimes = *state.mtimes
  ntimes_total = state.ntimes
  for i=0,ntimes_total-1 do begin
    if (array_equal(mtimes[*,i],state.mtime_beg)) then begin
      it0 = i
      break
    endif
  endfor
  for i=0,ntimes_total-1 do begin
    if (array_equal(mtimes[*,i],state.mtime_end)) then begin
      it1 = i
      break
    endif
  endfor
  ntime_plot = it1-it0+1
  mtime_plot = intarr(3,ntime_plot)
  for it=it0,it1 do mtime_plot[*,it-it0] = mtimes[*,it]
  for it=1,ntime_plot-1 do begin
    deltamin = mtime_to_mins(mtime_plot[*,it])-mtime_to_mins(mtime_plot[*,it-1])
    if deltamin ne 0 then break
  endfor
  print,format=$
    "('Reading ',i5,' times: ',i3,',',i3,',',i3,' to ',i3,',',i3,',',i3,' by ',i4)",$
    ntime_plot,mtime_plot[*,0],mtime_plot[*,ntime_plot-1],deltamin
;
; Allocate utv array:
;
  futv   = dblarr(nlocs,nzplev,ntime_plot,nfields)
; help,futv
  years = intarr(ntime_plot)    ; integer years
  days  = intarr(ntime_plot)    ; integer year-days
  decyears = fltarr(ntime_plot) ; decimal years
;
; Read from files:
;
  files = *state.files
  ifile0 = state.ifile_beg
  ifile1 = state.ifile_end
  itime0_plot = 0
  msis_version = "NRL MSIS-2000"
  for ifile=ifile0,ifile1 do begin
    ncid = ncdf_open(files[ifile],/nowrite)

    id = ncdf_varid(ncid,'mtime')
    ncdf_varget,ncid,id,mtime_file
    ntime_file = n_elements(mtime_file)/3

    ncdf_attget,ncid,'missing_value',missing,/global
    ncdf_attget,ncid,'model_version',tgcm_version,/global
    tgcm_version = string(tgcm_version)
    print,'tgcm_version=',tgcm_version

    itime0_file = 0 & itime1_file = ntime_file-1
    for i=0,ntime_file-1 do begin
      if (array_equal(mtime_file[*,i],state.mtime_beg)) then itime0_file=i
      if (array_equal(mtime_file[*,i],state.mtime_end)) then itime1_file=i
    endfor
    ntime_file = itime1_file-itime0_file+1
    itime1_plot = itime0_plot+ntime_file-1

    print,format=$
      "(/,'File ',a,' (',i3,' of ',i3,')')",$
      file_basename(files[ifile]),ifile+1,ifile1-ifile0+1
    print,format=$
      "('Reading ',i4,' mtimes: ',3(i3,','),' to ',3(i3,','),' by ',i5,')')",$
      ntime_file,mtime_plot[*,itime0_plot],mtime_plot[*,itime1_plot],deltamin
;
; Get years:
    id = ncdf_varid(ncid,'year') 
    if (id eq -1) then print,'>>> WARNING: could not find year variable'
    ncdf_varget,ncid,id,var
    years[itime0_plot:itime1_plot] = fix(var[itime0_file:itime1_file])
;
; Get days:
    id = ncdf_varid(ncid,'day')
    if (id eq -1) then print,'>>> WARNING: could not find day variable'
    ncdf_varget,ncid,id,var
    days[itime0_plot:itime1_plot] = fix(var[itime0_file:itime1_file])
;
; Get info structure for current file:
    finfo = ncdf_inquire(ncid)
;
; Get Z geopotential if calling msis
    model = ''
    for i=0,nfields-1 do begin
      if (sfields[i].model eq 'MSIS') then model = 'MSIS'
    endfor
    if (model eq 'MSIS') then begin ; there is at least 1 msis field
      ixz = -1
      for ivar=0,finfo.nvars-1 do begin
        vinfo = ncdf_varinq(ncid,ivar)
        if (vinfo.name eq 'Z') then begin
          ixz = ivar
        endif
      endfor
      if (ixz eq -1) then print,'>>> WARNING: cannot find field Z'
      ncdf_varget,ncid,ixz,zpoten_read ;  double (lon,lat,lev,time)
      print,'Read TGCM geopotential height for MSIS: zpoten min,max=',$
        min(zpoten_read),max(zpoten_read)
      zpoten = dblarr(nzplev,ntime_file)
    endif
;
; msis output field:
    msis_data = dblarr(nzplev,ntime_file)
;
; Loop over variables in current file:
    found = intarr(nfields) & found[*] = 0
    for ivar=0,finfo.nvars-1 do begin
      vinfo = ncdf_varinq(ncid,ivar)
;
; Check for selected field: 
      for ifld=0,nfields-1 do begin
        if (vinfo.name eq sfields[ifld].name) then begin
          f_units[ifld] = ""
          for iatt=0,vinfo.natts-1 do begin
            attname = ncdf_attname(ncid,ivar,iatt)
            if (attname eq "units") then begin
              ncdf_attget,ncid,ivar,attname,units
              f_units[ifld]=string(units)
            endif
          endfor
          found[ifld] = 1
          model = sfields[ifld].model
          ncdf_varget,ncid,ivar,var ; (lon,lat,lev,time)
;
; Location (lat,lon) loop:
          for iloc=0,nlocs-1 do begin
;
; Read tgcm history files, or call msis (model is local from state.model):
            case model of
              'TGCM': begin
                futv[iloc,*,itime0_plot:itime1_plot,ifld] = $
                  var[ilocs[1,iloc],ilocs[0,iloc],izp0:izp1,itime0_file:itime1_file]
              end
              'MSIS': begin
;
; Get tgcm geopotential at this location from Z field, which was read into
; zpoten_read from tgcm history file (see above):
                zpoten(*,*) = zpoten_read(ilocs[1,iloc],ilocs[0,iloc],izp0:izp1,*)
;
; Procedure msis_utvert calls msis for current date and time at current location:
                found_field = msis_utvert(sfields[ifld].name,locs[0:1,iloc],$
                  zplevs[izp0:izp1],$
                  years(itime0_plot:itime1_plot),days(itime0_plot:itime1_plot),$
                  mtime_plot(*,itime0_plot:itime1_plot),zpoten,msis_data)
;
                if (not found_field) then begin
          ;       print,'Note: field ',sfields[ifld].name,' not available from MSIS.'
                  futv[iloc,*,itime0_plot:itime1_plot,ifld] = 0.
                  found[ifld] = 0
          ;       goto,endfloop
                endif else begin
                  futv[iloc,*,itime0_plot:itime1_plot,ifld] = msis_data[*,*]
                endelse
              end
              else: begin
                print,'>>> WARNING: unknown model: ',model
                print,'Resetting model to TGCM'
                model = 'TGCM'
              end
            endcase
;
; Top levels is 1.e36 (missing value) for T,U,V, and possibly others.
; Cannot get max_value to work in contour call (utcontour.pro), so for
; now, just set nlev values to nlev-1 values:
;
;           if (izp1 eq nlevs-1) then $
;             futv[iloc,nzplev-1,itime0_plot:itime1_plot,ifld] = $
;             futv[iloc,nzplev-2,itime0_plot:itime1_plot,ifld]
          endfor ; iloc=0,nlocs-1

          if (model eq 'TGCM') then $
            print,format=$
            "('Read ',a,' field ',a8,' min,max=',2e12.4)",tgcm_version,$
            sfields[ifld].name,min(futv[*,*,itime0_plot:itime1_plot,ifld]),$
                          max(futv[*,*,itime0_plot:itime1_plot,ifld]) $
          else $
            print,format=$
            "('Call ',a,' for field ',a8,' min,max=',2e12.4)",msis_version,$
            sfields[ifld].name,min(futv[*,*,itime0_plot:itime1_plot,ifld]),$
                          max(futv[*,*,itime0_plot:itime1_plot,ifld])

        endif ; a selected field
        endfloop:
      endfor ; ifld=0,nfields-1
    endfor ; ivar=0,nvars-1
;
; Should not be necessary to check for this, but you never know:
    for ivar=0,nfields-1 do begin
      if (found[ivar] eq 0) then print,format=$
        "('(Field ',a,' was not found (model=',a,')')",sfields[ivar].name,$
        sfields[ivar].model
    endfor
    itime0_plot = itime0_plot+ntime_file
    ncdf_close,ncid
  endfor ; ifile=ifile0,ifile1
;
; Insure consistent delta-time (minutes) between all histories.
; If a deltamin between 2 histories is zero (duplicate history),
; then the arrays are shifted to overwrite the 1st history of the
; duplicate pair, and ntimes is decremented.  Duplicate secondary
; histories can occur between the end of one file and the beginning
; of the next when the model is restarted.  If deltamin is inconsistent
; w/ deltamin0 and deltamin is non-zero, then this is a fatal
; (the history write frequency was apparently changed mid-run).
;
  dtimeloop:
  for i=1,ntime_plot-1 do begin
    deltamin = mtime_to_mins(mtime_plot[*,i])-mtime_to_mins(mtime_plot[*,i-1])
    if (deltamin eq 0) then begin
      print,format=$
        "(/,'Warning: duplicate history: i=',i3,',mtime[*,i]=',3i4,' mtime[*,i-1]=',3i4)",$
        i,mtime_plot[*,i],mtime_plot[*,i-1]
      print,format=$
        "('(Duplicate histories are corrected by shifting arrays)')"
      mtime_plot[*,i:ntime_plot-1] = shift(mtime_plot[*,i:ntime_plot-1],0,-1)
      years[i:ntime_plot-1] = shift(years[i:ntime_plot-1],-1)
      decyears[i:ntime_plot-1] = shift(decyears[i:ntime_plot-1],-1)
;
; f = dblarr(nlocs,nzp,ntime_plot,nfields)
; The shift function does not work if there are any degenerate dimensions
;   (i.e., dimensioned 1). Since nfields and nlocs can be degenerate
;   (only one chosen by the user), loop over these to avoid problems
;   w/ shift function:
;
      for ifld=0,nfields-1 do begin
        for iloc=0,nlocs-1 do begin
          futv[iloc,*,i:ntime_plot-1,ifld] = shift(futv[iloc,*,i:ntime_plot-1,ifld],0,0,-1)
        endfor
      endfor
      ntime_plot = ntime_plot-1
      goto,dtimeloop ; check for another one
    endif
  endfor
;
; Number of contour levels, and load default color table:
  nlevels = 12 ; number of contour levels
  loadct,33,ncolors=nlevels,bottom=3 ; Blue-Red
;
; Field plot loop:
;
print,format="(/,'Contouring ut vs pressure:')"
iframe = 0
ijpg = 0
for ifld=0,nfields-1 do begin
  if (found[ifld] eq 0) then begin
    print,'Skipping field ',sfields[ifld].name,' because it was not found (model=',$
      sfields[ifld].model,')'
    continue ; field was not found
  endif
  model = sfields[ifld].model
  for iloc=0,nlocs-1 do begin
    utv = futv[iloc,*,0:ntime_plot-1,ifld] ; [nlev,ntimes]
    utv = transpose(utv)   ; [ntime_plot,nlev]
    funits = f_units[ifld]
    if (f_units[ifld] eq 'CM' or f_units[ifld] eq 'cm') then begin
      utv = utv/1.e5          ; cm to km (e.g., Z)
      funits = 'KM'
    endif
    if (f_units[ifld] eq 'CM/S' or f_units[ifld] eq 'cm/s') then begin
      utv = utv/100.
      funits = 'M/S'
    endif
;
; Main title and y-axis title:
;
    if (model eq 'TGCM') then $
    title = tgcm_version+' '+sfields[ifld].name+' ('+funits+'):  Lat,Lon = '+ $
      string(format="(f6.2)",gridlocs[0,iloc])+', '+$
      string(format="(f7.2)",gridlocs[1,iloc]) $
    else $
    title = msis_version+' '+sfields[ifld].name+' ('+funits+'):  Lat,Lon = '+ $
      string(format="(f6.2)",gridlocs[0,iloc])+', '+$
      string(format="(f7.2)",gridlocs[1,iloc])

;   ytitle = "Log Pressure ("+lev_units+")" ; get this later
    ytitle = "Log Pressure"
;
; Use IDL procedures timegen, julday, and label_date
; (setting nxticks does not appear to work w/ label_date)
;
    time = timeaxis(years[0:ntime_plot-1],mtime_plot[*,0:ntime_plot-1],$
      deltamin,xtitle,nxticks)
    filelabel = "Files " + file_basename(files[ifile0]) + " to " + $
                           file_basename(files[ifile1])
    ps = 0 & if (state.device eq 'PS') then ps = 1
    jpg = 0 & if (state.device eq 'JPG') then jpg = 1
;
; Contour:
    utcontour,utv,time,zplevs,locs[1,iloc],nlevels,xtitle,ytitle,title,filelabel,$
      missing,jpg=jpg,ps=ps
    iframe = iframe+1
    if (state.device eq 'PS') then begin
      print,format="('Frame ',i4,': ',a,' (ps file ',a,')')",$
        iframe,title,strcompress(state.ps_outfile,/remove_all)
    endif else if (state.device eq 'X') then begin
      print,format="('Frame ',i4,': ',a,' (X display)')",iframe,title
    endif else begin
      print,format="('Frame ',i4,': ',a,' (unknown output device)')",$
        iframe,title
    endelse
  endfor ; iloc
endfor ; ifld
end
