;-----------------------------------------------------------------------
pro done_event,event
  widget_control,event.top,/destroy
end
;-----------------------------------------------------------------------
pro displayfile,filename,title=title,group=group
  nlines = min([file_lines(filename),10000])
  openr,lu,filename,/get_lun
; print,'Opened file ',filename,' lu=',lu
  filetext = strarr(nlines)
  readf,lu,filetext
  free_lun,lu
;
  if (not(keyword_set(title))) then title = filename
  if (keyword_set(group)) then begin
    tlb = widget_base(column=1,uvalue=filename,title=title,$
      group_leader=group)
  endif else begin
    tlb = widget_base(row=2,uvalue=filename,title=title)
  endelse
  text_widget = widget_text(tlb,value=filetext,/scroll,xsize=80,ysize=25)
  done_button = widget_button(tlb,value='Done',event_pro='done_event')
  widget_control,tlb,/realize
  xmanager,'displayfile',tlb,/no_block
end
;-----------------------------------------------------------------------
pro display_help,tlb,string
  path = expand_path(!path,/array)
  dir = path[0]
  case string of
    'MAIN': begin
      filepath = dir+'/'+'help_main'
      fileinfo = file_info(filepath)
      if (not fileinfo.exists) then filepath = 'help_main' 
      displayfile,filepath,title="UTPROC MAIN HELP",group=tlb
    end
    'UTVERT': begin
      filepath = dir+'/'+'help_utvert'
      fileinfo = file_info(filepath)
      if (not fileinfo.exists) then filepath = 'help_utvert' 
      displayfile,filepath,title="UT vs VERTICAL HELP",group=tlb
    end
    'UTLAT': begin
      filepath = dir+'/'+'help_utlat'
      fileinfo = file_info(filepath)
      if (not fileinfo.exists) then filepath = 'help_utlat' 
      displayfile,filepath,title="UT vs LATITUDE HELP",group=tlb
    end
    else: print,'>>> Unknown help file..'
  endcase
end    
