function shareable_object, lib_name
;
; Returns the full path and name of the call_external shareable object
; (dll) appropriate for the platform (Unix, Windows, Mac, etc.) and 
; address length (32-bit, 64-bit)
;
; B. Knapp, 2007-05-02
;
  sep = path_sep()
  root = getenv('bgkroot')
;
; Which platform?
  if (strupcase(!version.os_family) eq 'WINDOWS') then begin
    ext = '.dll'
  endif else begin
    ext = '.so'
  endelse 
;
; Use 32-bit or 64-bit shareable object library?
  mbits = ((!version.release ge 5.4) ? !version.memory_bits : 32)
  return, root+sep+'lib'+sep+lib_name+string(mbits,"(i2)")+ext
end
