pro assemble_select_fields,stateptr
  state = *stateptr
  tgcm_list = widget_info(state.tlb,find_by_uname='SELECT_TGCM_FIELDS')
  msis_list = widget_info(state.tlb,find_by_uname='SELECT_MSIS_FIELDS')
  hwm_list = widget_info(state.tlb,find_by_uname='SELECT_HWM_FIELDS')
  iri_list = widget_info(state.tlb,find_by_uname='SELECT_IRI_FIELDS')
;
  tgcm_indices = widget_info(tgcm_list,/list_select)

; print,'assemble_select_fields: #indices=',n_elements(tgcm_indices),$
;   ' tgcm_indices=',tgcm_indices

  ntgcm = 0
  if tgcm_indices[0] ne -1 then begin
    ntgcm = n_elements(tgcm_indices)
    fields_tgcm = *state.fields_tgcm
    sfields_tgcm = fields_tgcm[tgcm_indices]

;   for i=0,n_elements(tgcm_indices)-1 do begin  
;     print,'Enter assemble_select_fields: tgcm field ',sfields_tgcm[i].name,$
;       ' cmin,max,int=',sfields_tgcm[i].cmin,sfields_tgcm[i].cmax,$
;       sfields_tgcm[i].cint
;   endfor

  endif
;
  msis_indices = widget_info(msis_list,/list_select)
  nmsis = 0
  if msis_indices[0] ne -1 then begin
    nmsis = n_elements(msis_indices)
    fields_msis = *state.fields_msis
    sfields_msis = fields_msis[msis_indices]
  endif
;  
  hwm_indices = widget_info(hwm_list,/list_select)
  nhwm = 0
  if hwm_indices[0] ne -1 then begin
    nhwm = n_elements(hwm_indices)
    fields_hwm = *state.fields_hwm
    sfields_hwm = fields_hwm[hwm_indices]
  endif
;  
  iri_indices = widget_info(iri_list,/list_select)
  niri = 0
  if iri_indices[0] ne -1 then begin
    niri = n_elements(iri_indices)
    fields_iri = *state.fields_iri
    sfields_iri = fields_iri[iri_indices]
  endif
;
  nsfields = ntgcm+nmsis+nhwm+niri
  if (nsfields eq 0) then begin
    print,'>>> WARNING: no fields are selected: nsfields=',nsfields
    print,'Please select at least one field to plot.'
    *state.sfields = nullfield()
    *stateptr = state
    return
  endif

  sfields = replicate({field_struct},nsfields)
  i = 0
  if (ntgcm gt 0) then begin
    sfields[0:ntgcm-1] = sfields_tgcm
    i = i+ntgcm
  endif
  if (nmsis gt 0) then begin
    sfields[i:i+nmsis-1] = sfields_msis[0:nmsis-1]
    i = i+nmsis
  endif
  if (nhwm gt 0) then begin
    sfields[i:i+nhwm-1] = sfields_msis[0:nhwm-1]
    i = i+nhwm
  endif
  if (niri gt 0) then begin
    sfields[i:i+niri-1] = sfields_msis[0:niri-1]
    i = i+niri
  endif

; for i=0,nsfields-1 do print,'end assemble_select_fields: i=',i,' nsfields=',$
;   nsfields,' sfield cmin,cmax,cint=',sfields[i].cmin,sfields[i].cmax,$
;   sfields[i].cint

  *state.sfields = sfields
  *stateptr = state
;
; Update options table, if open:
;
  if (state.opts_tlb ne 0) then begin
    widget_control,state.opts_tlb,/destroy
    options_table,stateptr
  endif
end

