function get_tgcm_var,ncid,name,var
;
; Given open history file ncid, return variable with given name
; in var, returning the var id. If var is not found, return -1.
;
  ixf = -1
  finfo = ncdf_inquire(ncid)
  for ivar = 0,finfo.nvars-1 do begin
    vinfo = ncdf_varinq(ncid,ivar)
    if (vinfo.name eq name) then begin
      ixf = ivar
      ncdf_varget,ncid,ixf,var
      print,'get_tgcm_var: Read var ',name,' ixf=',ixf
    endif
  endfor
  if (ixf eq -1) then print,'>>> WARNING get_tgcm_var: var ',name,' not found.'
  return,ixf
end
