  function replace, x, y, miss
;
; Given abscissa array x, data array y, and missing value flag miss,
; replace missing elements of data array y with linear interpolates.
;
; B. Knapp, 89/06/01
;           98.06.09, IDL v. 5 compliance
;
  n = n_elements( x )
  good = where( y ne miss )
  bad = where( y eq miss )
  m = n_elements( bad )
  yy=y
  if m gt 1 or bad[0] ge 0 then begin
     p = lonarr( m )
     for j=0l,m-1 do p[j] = 0 > max( where( good lt bad[j] ) ) < (n-m-2)
     slope = (y[good[p+1]]-y[good[p]])/(x[good[p+1]]-x[good[p]])
     b = y[good[p]]-slope*x[good[p]]
     yy[bad] = slope*x[bad]+b
  endif
  return, yy
  end
